import React from 'react';
import { connect } from 'react-redux';

import DatePicker from 'react-datepicker';
import { setDepartureDate, setReturnDate } from '../../redux/actions';

const now = new Date();

class CustomButton extends React.Component {
    render() {
        const { value, onClick } = this.props;
        return (
            <button className="custom" onClick={onClick}>
                {value}
            </button>
        );
    }
}

const DateSelect = ({
    journeyType,
    departureDate,
    returnDate,
    setDepartureDate,
    setReturnDate
}) => (
    <div className="date-select">
        <div className="input-wrap">
            <label htmlFor="Departure Date">Departure Date</label>
            <DatePicker
                customInput={<CustomButton />}
                name="Departure Date"
                selected={departureDate}
                onChange={value => setDepartureDate(value)}
                dateFormat="dd/M/Y"
                required
                withPortal={window.innerWidth < 992}
                minDate={new Date()}
                onChangeRaw={e => {
                    e.preventDefault();
                }}
            />
        </div>
        {journeyType === 'RETURN' && (
            <div className="input-wrap">
                <label htmlFor="Departure Date">Return Date</label>
                <DatePicker
                    customInput={<CustomButton />}
                    selected={returnDate === null ? now : returnDate}
                    onChange={value => setReturnDate(value)}
                    dateFormat="dd/M/Y"
                    required
                    minDate={departureDate}
                    withPortal={window.innerWidth < 992}
                    onChangeRaw={e => {
                        e.preventDefault();
                    }}
                />
            </div>
        )}
    </div>
);

const mapStateToProps = state => {
    const { journeyType, departureDate, returnDate } = state.cart;
    return {
        journeyType: journeyType,
        departureDate: departureDate,
        returnDate: returnDate
    };
};

export default connect(
    mapStateToProps,
    { setDepartureDate, setReturnDate }
)(DateSelect);
