<?php

namespace XploreBooking\Controller;

class TicketController
{

    public function __construct()
    {
        $this->registerActions();
    }

    private function registerActions()
    {
        add_action('rest_api_init', function () {
            if (is_user_logged_in()) {
                register_rest_route('xplore-booking/v1', '/get-all-tickets/', [
                    'methods' => 'GET',
                    'callback' => [$this, 'getAllTicketsAgent'],
                ]);
            } else {
                register_rest_route('xplore-booking/v1', '/get-all-tickets/', [
                    'methods' => 'GET',
                    'callback' => [$this, 'getAllTickets'],
                ]);
            }
        });
    }

    public static function getAllTickets()
    {
        $ticketData = [];
        $args = [
            'post_type' => 'ticket',
            'posts_per_page' => -1,
            'orderby' => 'publish_date',
            'order' => 'ASC',
            'meta_query' => [
                [
                    'key' => 'staff_ticket',
                    'value' => '1',
                    'compare' => '!=',
                ],
            ],
        ];

        $tickets = new \WP_Query($args);

        while ($tickets->have_posts()) {
            $tickets->the_post();
            $ticketData[] = [
                'id' => get_the_ID(),
                'title' => get_the_title(),
                'single_cost' => get_field('single_cost'),
                'return_cost' => get_field('return_cost'),
                'advanced_single' => get_field('advanced_single'),
                'advanced_return' => get_field('advanced_return'),
                'seats' => get_field('seats'),
            ];
        }
        return json_encode($ticketData);
    }

    public static function getAllTicketsAgent()
    {
        $ticketData = [];
        $args = [
            'post_type' => 'ticket',
            'posts_per_page' => -1,
            'orderby' => 'publish_date',
            'order' => 'ASC'
        ];

        $tickets = new \WP_Query($args);

        while ($tickets->have_posts()) {
            $tickets->the_post();
            $ticketData[] = [
                'id' => get_the_ID(),
                'title' => get_the_title(),
                'single_cost' => get_field('single_cost'),
                'return_cost' => get_field('return_cost'),
                'advanced_single' => get_field('advanced_single'),
                'advanced_return' => get_field('advanced_return'),
                'seats' => get_field('seats'),
            ];
        }

        return json_encode($ticketData);
    }

    public static function ticketTypes()
    {
        $ticketTypes = [
            'adults' => [
                'post_title' => 'Adults',
                'single_cost' => 16,
                'return_cost' => 22,
                'advanced_single' => 12,
                'advanced_return' => 18,
                'seats' => 1,
                'staff_ticket' => false,
            ],
            'child' => [
                'post_title' => 'Child',
                'single_cost' => 8,
                'return_cost' => 12,
                'advanced_single' => 6,
                'advanced_return' => 10,
                'seats' => 1,
                'staff_ticket' => false,
            ],
            'family' => [
                'post_title' => 'Family',
                'single_cost' => 40,
                'return_cost' => 55,
                'advanced_single' => 30,
                'advanced_return' => 45,
                'seats' => 4,
                'staff_ticket' => false,
            ],
            'student' => [
                'post_title' => 'Student',
                'single_cost' => 12,
                'return_cost' => 18,
                'advanced_single' => 10,
                'advanced_return' => 16,
                'seats' => 1,
                'staff_ticket' => false,
            ],
            'concession' => [
                'post_title' => 'Concession',
                'v' => 1,
                'return_cost' => 1,
                'advanced_single' => 1,
                'advanced_return' => 1,
                'seats' => 1,
                'staff_ticket' => false,
            ],
            'group-of-4' => [
                'post_title' => 'Group of 4',
                'single_cost' => 50,
                'return_cost' => 75,
                'advanced_single' => 35,
                'advanced_return' => 60,
                'seats' => 4,
                'staff_ticket' => false,
            ],
            'group-of-5' => [
                'post_title' => 'Group of 5',
                'single_cost' => 55,
                'return_cost' => 85,
                'advanced_single' => 45,
                'advanced_return' => 70,
                'seats' => 5,
                'staff_ticket' => false,
            ],
            'group-of-6' => [
                'post_title' => 'Group of 6',
                'single_cost' => 65,
                'return_cost' => 99,
                'advanced_single' => 50,
                'advanced_return' => 80,
                'seats' => 6,
                'staff_ticket' => false,
            ],
            'group-of-7' => [
                'post_title' => 'Group of 7',
                'single_cost' => 88,
                'return_cost' => 121,
                'advanced_single' => 62,
                'advanced_return' => 92,
                'seats' => 7,
                'staff_ticket' => true,
            ],
            'group-of-8' => [
                'post_title' => 'Group of 8',
                'single_cost' => 100,
                'return_cost' => 138,
                'advanced_single' => 71,
                'advanced_return' => 105,
                'seats' => 8,
                'staff_ticket' => true,
            ],
            'group-of-9' => [
                'post_title' => 'Group of 9',
                'single_cost' => 113,
                'return_cost' => 155,
                'advanced_single' => 79,
                'advanced_return' => 118,
                'seats' => 9,
                'staff_ticket' => true,
            ],
            'group-of-10' => [
                'post_title' => 'Group of 10',
                'single_cost' => 125,
                'return_cost' => 172,
                'advanced_single' => 88,
                'advanced_return' => 131,
                'seats' => 10,
                'staff_ticket' => true,
            ],
            'group-of-11' => [
                'post_title' => 'Group of 11',
                'single_cost' => 138,
                'return_cost' => 189,
                'advanced_single' => 97,
                'advanced_return' => 144,
                'seats' => 11,
                'staff_ticket' => true,
            ],
            'group-of-12' => [
                'post_title' => 'Group of 12',
                'single_cost' => 150,
                'return_cost' => 206,
                'advanced_single' => 106,
                'advanced_return' => 157,
                'seats' => 12,
                'staff_ticket' => true,
            ],
            'group-of-13' => [
                'post_title' => 'Group of 13',
                'single_cost' => 163,
                'return_cost' => 224,
                'advanced_single' => 114,
                'advanced_return' => 170,
                'seats' => 13,
                'staff_ticket' => true,
            ],
            'group-of-14' => [
                'post_title' => 'Group of 14',
                'single_cost' => 175,
                'return_cost' => 241,
                'advanced_single' => 123,
                'advanced_return' => 183,
                'seats' => 14,
                'staff_ticket' => true,
            ],
            'group-of-15' => [
                'post_title' => 'Group of 15',
                'single_cost' => 188,
                'return_cost' => 258,
                'advanced_single' => 132,
                'advanced_return' => 195,
                'seats' => 15,
                'staff_ticket' => true,
            ],
            'group-of-16' => [
                'post_title' => 'Group of 16',
                'single_cost' => 192,
                'return_cost' => 264,
                'advanced_single' => 135,
                'advanced_return' => 204,
                'seats' => 16,
                'staff_ticket' => true,
            ],
            'group-of-17' => [
                'post_title' => 'Group of 17',
                'single_cost' => 204,
                'return_cost' => 281,
                'advanced_single' => 143,
                'advanced_return' => 215,
                'seats' => 17,
                'staff_ticket' => true,
            ],
            'group-of-18' => [
                'post_title' => 'Group of 18',
                'single_cost' => 216,
                'return_cost' => 297,
                'advanced_single' => 152,
                'advanced_return' => 227,
                'seats' => 18,
                'staff_ticket' => true,
            ],
            'group-of-19' => [
                'post_title' => 'Group of 19',
                'single_cost' => 228,
                'return_cost' => 314,
                'advanced_single' => 160,
                'advanced_return' => 240,
                'seats' => 19,
                'staff_ticket' => true,
            ],
            'group-of-20' => [
                'post_title' => 'Group of 20',
                'single_cost' => 240,
                'return_cost' => 330,
                'advanced_single' => 168,
                'advanced_return' => 252,
                'seats' => 20,
                'staff_ticket' => true,
            ],
            'staff-single' => [
                'post_title' => 'Staff Single',
                'single_cost' => 8,
                'return_cost' => 12,
                'advanced_single' => 6,
                'advanced_return' => 10,
                'seats' => 1,
                'staff_ticket' => true,
            ],
            'staff-group-of-2' => [
                'post_title' => 'Staff Group of 2',
                'single_cost' => 16,
                'return_cost' => 24,
                'advanced_single' => 12,
                'advanced_return' => 20,
                'seats' => 2,
                'staff_ticket' => true,
            ],
            'staff-group-of-3' => [
                'post_title' => 'Staff Group of 3',
                'single_cost' => 24,
                'return_cost' => 36,
                'advanced_single' => 18,
                'advanced_return' => 30,
                'seats' => 3,
                'staff_ticket' => true,
            ],
            'staff-group-of-4' => [
                'post_title' => 'Staff Group of 4',
                'single_cost' => 32,
                'return_cost' => 48,
                'advanced_single' => 24,
                'advanced_return' => 40,
                'seats' => 4,
                'staff_ticket' => true,
            ],
        ];

        return $ticketTypes;
    }

}
