<?php

namespace XploreBooking\Controller;

class AdminController
{


    public function __construct()
    {
        $this->registerActions();
    }

    private function registerActions()
    {
        add_action('wp_dashboard_setup', [$this, 'exportJourneyManifest']);
        add_action('init', [$this, 'printDriverManifest']);
    }


    public function exportJourneyManifest()
    {
        global $wp_meta_boxes;
        wp_add_dashboard_widget('journey_manifest', 'Journey Manifest', [$this, 'JourneyManifest']);
    }

    public function JourneyManifest()
    {
        $data = '<p>Please enter the Journey Date:</p>';

        $data .= '
            <form action="" method="GET" id="journeySelectForm" name="journeySelectForm">
                <input type="date" name="journeyDate" placeholder="Please select the date" required>    
                <select name="time" required>
                    <option value="0230">02:30</option>
                    <option value="0400">04:00</option>
                    <option value="0530">05:30</option>
                    <option value="0700">07:00</option>
                    <option value="0830">08:30</option>
                    <option value="1000">10:00</option>
                    <option value="1130">11:30</option>
                    <option value="1300">13:00</option>
                    <option value="1430">14:30</option>
                    <option value="1600">16:00</option>
                    <option value="1730">17:30</option>
                    <option value="1900">19:00</option>
                    <option value="2030">20:30</option>
                    <option value="2200">22:00</option>
                    <option value="2330">23:30</option>
                    <option value="0100">01:00</option>
                </select>        
                <select name="direction" placeholder="Please select the direction" required>
                    <option value="dundee-to-edinburgh">Dundee</option>
                    <option value="edinburgh-to-dundee">Edinburgh Airport</option>
                </select>
                           
                <input type="submit" value="Get Manifest">
            </form>
        ';

        echo $data;
    }

    public function printDriverManifest()
    {

        if (isset($_GET['journeyDate'])) {

            $date = $_GET['journeyDate'];
            $time = $_GET['time'];
            $direction = $_GET['direction'];

            $date = date('d-m-Y', strtotime($date));

            $slug = $direction . '-' . $time . '-' . $date;

            $args = [
                'post_type' => 'journey-date',
                'posts-per_page' => 1,
                'name' => $slug,
            ];

            $journey = get_posts($args);

            $bookingArgs = [
                'post_type' => 'booking',
                'posts_per_page' => -1,
                'meta_query' => [
                    'relation' => 'OR',
                    [
                        'key' => 'inbound_journey',
                        'value' => '"' . $journey[0]->ID . '"',
                        'compare' => 'LIKE',
                    ],
                    [
                        'key' => 'outbound_journey',
                        'value' => '"' . $journey[0]->ID . '"',
                        'compare' => 'LIKE',
                    ],

                ],
            ];
            $bookings = get_posts($bookingArgs);
            if ($bookings) {
                self::outputCsv('manifest-'.$slug.'.csv', $bookings);
            }
        }
    }

    public function outputCsv($fileName, $bookings)
    {
        ob_clean();
        header_remove();
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename=' . $fileName);

        $fp = fopen('php://output', 'w');
        fputcsv($fp, ["Name", "Phone Number", "Reservation Number", "Extra Luggage"]);
        foreach ($bookings as $booking) {
            fputcsv($fp, [get_field('name', $booking->ID) . ' ' . get_field('surname', $booking->ID), get_field('phone_number', $booking->ID), get_field('payment_reference', $booking->ID), get_field('add_ons', $booking->ID)]);
        }
        fclose($fp);
        ob_flush();
        die;
    }

}
