import React from 'react';
import { connect } from 'react-redux';
import { updateUser, hideCart } from '../redux/actions';

const YourDetails = ({ updateUser, hideCart, name, surname, email, phoneNumber }) => {
    return (
        <>
            <h1>Your Details</h1>
            <div className="content">
                <form
                    className="your-details"
                    onFocus={() => hideCart(true)}
                    onBlur={() => hideCart(false)}>
                    <input
                        type="text"
                        placeholder="First Name*"
                        name="firstName"
                        defaultValue={name}
                        required
                        onChange={e => updateUser(e.target)}
                    />
                    <input
                        type="text"
                        placeholder="Surname* "
                        name="surname"
                        defaultValue={surname}
                        required
                        onChange={e => updateUser(e.target)}
                    />
                    <input
                        type="text"
                        placeholder="Email*"
                        name="email"
                        defaultValue={email}
                        required
                        onChange={e => updateUser(e.target)}
                    />
                    <input
                        type="text"
                        placeholder="Phone Number*"
                        name="phoneNumber"
                        defaultValue={phoneNumber}
                        required
                        onChange={e => updateUser(e.target)}
                    />
                </form>
            </div>
        </>
    );
};

const mapStateToProps = state => ({ ...state.user });
export default connect(
    mapStateToProps,
    { updateUser, hideCart }
)(YourDetails);
