import React, { useState } from 'react';
import { connect } from 'react-redux';
import { setTerms } from '../../redux/actions';
import { getTotalCostFromCart } from '../../redux/selectors';
import BackButton from './BackButton';
import ContinueButton from './ContinueButton';
import JourneyDetails from './JourneyDetails';
import PriceBreakdown from './PriceBreakdown';
import Addons from './Addons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

const Cart = ({ totalPrice, setTerms }) => {
    const [opened, setOpened] = useState(false);
    const cartOpen = opened ? 'open' : '';
    const rotation = opened ? 180 : null;
    return (
        <div className={`cart ${cartOpen}`}>
            <BackButton />
            <div className="content">
                <div className="heading">
                    <h2>Booking Details</h2>
                    <button onClick={() => setOpened(!opened)} className="open-cart">
                        <FontAwesomeIcon icon={['far', 'arrow-up']} rotation={rotation} />
                    </button>
                    <span className="price">£{totalPrice}</span>
                    <hr />
                </div>
                <div className="internal">
                    <JourneyDetails />
                    <PriceBreakdown />
                    <Addons />
                    <div className="terms">
                        <input
                            name="terms"
                            type="checkbox"
                            onChange={e => setTerms(e.target.checked)}
                        />
                        I have read and accept the{' '}
                        <a
                            href="https://nxbus.co.uk/dundee/legal/"
                            target="_blank"
                            rel="noopener noreferrer">
                            terms and conditions
                        </a>
                    </div>
                </div>
                <ContinueButton />
            </div>
        </div>
    );
};

const mapStateToProps = state => {
    const { journeyType, depart, departureDate, returnDate, inCart } = state.cart;
    const totalPrice = getTotalCostFromCart(state);
    return {
        journeyType,
        depart,
        departureDate,
        returnDate,
        inCart,
        totalPrice
    };
};

export default connect(
    mapStateToProps,
    { setTerms }
)(Cart);
