<?php

namespace XploreBooking\Controller;

class BookingController
{

    const SEATS = 50;

    public function __construct()
    {
        $this->registerActions();
    }

    private function registerActions()
    {
        add_action('rest_api_init', function () {
            register_rest_route('xplore-booking/v1', '/add-new-booking/', [
                'methods' => 'POST',
                'callback' => [$this, 'addNewBooking'],
            ]);

            register_rest_route('xplore-booking/v1', '/set-booking-notes/', [
                'methods' => 'POST',
                'callback' => [$this, 'addNotes'],
            ]);

            register_rest_route('xplore-booking/v1', '/update-payment-status/', [
                'methods' => 'POST',
                'callback' => [$this, 'updatePaymentStatus'],
            ]);

            register_rest_route('xplore-booking/v1', '/get-confirmation-text/', [
                'methods' => 'GET',
                'callback' => [$this, 'getConfirmationText'],
            ]);
        });

        add_action('template_redirect',[$this, 'confirmationRedirect']);
    }

    public function confirmationRedirect() {
        if (is_404() && isset($_POST['name']) && isset($_POST['transStatus'])) {
            self::updatePaymentStatus();
            $bookingId = $_POST['cartId'];
            status_header(200);
            echo '
            <!DOCTYPE html>
            <html>
            <head>
                <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="profile" href="http://gmpg.org/xfn/11">
                <META HTTP-EQUIV="Refresh" CONTENT="3; URL=http://booking.nxdiscovrit.co.uk/booking/?complete=' . $bookingId . '">
            </head>
            <WPDISPLAY FILE="header.html">
            <body>
                <p>Redirecting to site</p>
            </body>
            <WPDISPLAY FILE="footer.html">
            </html>';
            exit;
        }
    }

    public static function updatePaymentStatus()
    {
        $status = $_POST['transStatus'] == 'Y' ? 'paid' : 'failed';
        $bookingId = $_POST['cartId'];
        $paymentReference = $_POST['transId'];
        switch ($status) {
            case 'paid':
                update_field('payment_reference', $paymentReference, $bookingId);
                update_field('booking_status', 'Completed', $bookingId);
                wp_update_post(['ID' => $bookingId]);
                self::emailUserBookingDetails($status, $bookingId);
                // return 'sucessful-booking';
                break;
            case 'failed':
                update_field('payment_reference', $paymentReference, $bookingId);
                update_field('booking_status', 'Failed', $bookingId);
                self::emailUserBookingDetails($status, $bookingId);
                // return 'payment-failed';
                break;
            default :
                update_field('booking_status', 'Pending', $bookingId);
                wp_update_post(['ID' => $bookingId]);
                // return 'unsucessful-booking';
                break;
        }
    }

    public function getConfirmationText($request) {
        $bookingId = $request['bookingId'];
        if($bookingId == null) {
            return new \WP_REST_Response('No id was sent', 400);
        }

        $outboundJourney = get_field('outbound_journey', $bookingId);
        $outboundRef = get_field('outbound_reference', $bookingId);
        $explodedOutbound = explode(' ', $outboundJourney[0]->post_title);
        $response[] = "Journey: $explodedOutbound[0] $explodedOutbound[1] $explodedOutbound[2]	&nbsp;	&nbsp;	&nbsp;	&nbsp;Time: $explodedOutbound[3]	&nbsp;	&nbsp;	&nbsp;	&nbsp; Date: $explodedOutbound[4] $explodedOutbound[5] $explodedOutbound[6] 	&nbsp;	&nbsp;	&nbsp;	&nbsp;Ref: $outboundRef";

        $inboundJourney = get_field('inbound_journey', $bookingId);
        if($inboundJourney) {
            $inboundRef = get_field('inbound_reference', $bookingId);
            $explodedinbound = explode(' ', $inboundJourney[0]->post_title);
            $response[] = "Journey: $explodedinbound[0] $explodedinbound[1] $explodedinbound[2]  &nbsp;	&nbsp;	&nbsp;	&nbsp;  Time: $explodedinbound[3]   &nbsp;	&nbsp;	&nbsp;	&nbsp; Date: $explodedinbound[4] $explodedinbound[5] $explodedinbound[6]  &nbsp;	&nbsp;	&nbsp;	&nbsp;  Ref: $inboundRef";
        }

        return $response;
    }

    public static function emailUserBookingDetails($status, $bookingId)
    {
        $to = get_field('email', $bookingId);
        $name = get_field('name', $bookingId);
        $surname = get_field('surname', $bookingId);
        $paymentReference = get_field('payment_reference', $bookingId);

        switch ($status) {
            case 'paid':
                $subject = 'Successful Booking for ' . $paymentReference;
                $tickets = get_field('tickets', $bookingId);
                $outboundJourney = get_field('outbound_journey', $bookingId);
                $outboundJourney = $outboundJourney[0];
                $outboundJourney = get_the_title($outboundJourney->ID);
                $outboundReference = get_field('outbound_reference', $bookingId);

                $inboundJourney = get_field('inbound_journey', $bookingId);
                $inboundJourney = $inboundJourney[0];
                $inboundJourney = get_the_title($inboundJourney->ID);
                $inboundReference = get_field('inbound_reference', $bookingId);

                $addOns = get_field('add_ons', $paymentReference);

                $body = '<p>Dear ' . $name . ' ' . $surname . '</p><br>';
                $body .= '<p>Thank you for your placing your booking, below you will find your booking and journey details.</p><br>';
                $body .= '<p>Booking for ' . $name . ' ' . $surname . '.</p>';
                $body .= '<p>Payment Reference: ' . $paymentReference . '</p>';
                $body .= '<p>Tickets:</p>';
                foreach ($tickets as $ticket) {
                    $body .= '<p>' . $ticket['ticket_type'] . ', Quantity: ' . $ticket['quantity'] . '</p><br>';
                }
                $body .= '<p>Journey: ' . $outboundJourney . '<br>Reference: ' . $outboundReference . '</p>';
                if ($inboundJourney) {
                    $body .= '<p>Return Journey: ' . $inboundJourney . '<br>Reference: ' . $inboundReference . '</p>';
                }
                if (get_field('add_ons')) {
                    $body .= '<p>Add-ons:<br> ' . $addOns . '<p>';
                }
                break;
            case 'failed':
                $subject = '<p>Unsuccessful Booking for ' . $paymentReference . '</p>';
                $body = '<p>Unfortunately payment was not succesful for reference: ' . $paymentReference . '</p>';
                $body .= '<p>Please try again or contact <a href="tel:01382 340006">01382 340006</a> or <a href="mailto:XploreMore@nationalexpress.com">XploreMore@nationalexpress.com</a></p>';
                break;
        }

        $headers = ['Content-Type: text/html; charset=UTF-8'];

        wp_mail($to, $subject, $body, $headers);
    }

    public function addNewBooking($request)
    {
        $requiredFields = [
            'name',
            'surname',
            'email',
            'phoneNumber',
            'outbound',
            'seats'
        ];
        foreach($requiredFields as $field) {
            if(!isset($request[$field]) || $request[$field] === '') {
                return new \WP_REST_Response('Required fields are missing.', 400);
            }
        }

        $name = $request['name'];
        $surname = $request['surname'];
        $email = $request['email'];
        $phone = $request['phoneNumber'];
        $seats = $request['seats'];
        $price = $request['price'];

        $outboundSlug = $request['outbound'];
        $outboundReference = explode('-', $outboundSlug);
        $outboundReference = strtoupper($outboundReference[0] . '-' . $outboundReference[2] . '-' . $outboundReference[3] . '-' . mt_rand(00000, 99999));
        $outboundJourney = self::updateOrInsertPostJourney($outboundSlug, $seats);

        if(isset($request['inbound']) && $request['inbound'] !== false) {
            $inboundSlug = $request['inbound'];
            $inboundReference = explode('-', $inboundSlug);
            $inboundReference = strtoupper($inboundReference[0].'-'.$inboundReference[2].'-'.$inboundReference[3].'-'.mt_rand(00000, 99999));
            $inboundJourney = self::updateOrInsertPostJourney($inboundSlug, $seats);
        }

        $addOns = implode(",",$request['addons']);

        $cartItem = $request['inCart'];
        $tickets = [];
        foreach($cartItem as $ticket) {
            $tickets[] = [
                'ticket_type' => $ticket['title'],
                'quantity' => $ticket['quantity']
            ];
        }


        if ( (isset($inboundJourney) && $inboundJourney === 'no-seats')  || $outboundJourney === 'no-seats') {
            return new \WP_REST_Response('There are not enough seats available on the selected journey', 400);
        } else {
            $args = [
                'post_type' => 'booking',
                'post_title' => $name . ' ' . $surname . ' ' . date("d-m-Y H:i"),
                'post_status' => 'publish'
            ];

            $newBooking = wp_insert_post($args);
            update_field('tickets', $tickets, $newBooking);
            update_field('field_5cf5622486fd7', $outboundJourney, $newBooking);
            update_field('outbound_reference', $outboundReference, $newBooking);
            update_field('field_5cf7f1b976a3b', $inboundJourney, $newBooking);
            update_field('inbound_reference', $inboundReference, $newBooking);
            update_field('add_ons', $addOns, $newBooking);
            update_field('name', $name, $newBooking);
            update_field('surname', $surname, $newBooking);
            update_field('email', $email, $newBooking);
            update_field('phone_number', $phone, $newBooking);
            update_field('price', $price, $newBooking);
            wp_update_post(['ID' => $newBooking]);

            return $newBooking;
        }
    }

    public function addNotes($request) {
        $bookingId = $request['bookingId'];
        $notes = $request['notes'];

        update_field('agent_payment_details', $notes, $bookingId);
        update_field('booking_status', 'Completed', $bookingId);
        update_field('payment_reference', 'Cash', $bookingId);

        self::emailUserBookingDetails('paid', $bookingId);
    }

    public function updateOrInsertPostJourney($slug, $seats)
    {
        $newJourneyBooking = '';

        $postTitle = ucwords(str_replace('-', ' ', $slug));
        $postParts = explode('-', $slug);

        $date = $postParts['4'] . '-' . $postParts['5'] . '-' . $postParts['6'];
        $date = date('Ymd', strtotime($date));

        $args = [
            'name' => $slug,
            'post_type' => 'journey-date',
            'posts_per_page' => 1
        ];

        $query = new \WP_Query($args);

        if (!$query->have_posts()) {

            $newJourneyArgs = [
                'post_title' => $postTitle,
                'post_type' => 'journey-date',
                'post_status' => 'publish'
            ];

            $newJourneyBooking = wp_insert_post($newJourneyArgs);
            update_field('date', $date, $newJourneyBooking);
            update_field('seats', (self::SEATS - $seats), $newJourneyBooking);
        } else {
            while ($query->have_posts()) {
                $query->the_post();
                wp_update_post(get_the_ID());
                $seatsLeft = get_field('seats', get_the_ID());
                if ($seatsLeft > $seats) {
                    update_field('seats', ($seatsLeft - $seats), get_the_ID());
                    $newJourneyBooking = get_the_ID();
                } else {
                    $newJourneyBooking = 'no-seats';
                }
            }
        }
        return $newJourneyBooking;
    }
}
