import React from 'react';
import { connect } from 'react-redux';
import { updateUser } from '../redux/actions';

const YourDetails = ({ updateUser, name, surname, email, phoneNumber }) => {
    return (
        <>
            <h1>Your Details</h1>
            <div className="content">
                <div className="your-details">
                    <input
                        type="text"
                        placeholder="Name*"
                        name="name"
                        defaultValue={name}
                        required
                        onChange={e => updateUser(e.target)}
                    />
                    <input
                        type="text"
                        placeholder="Surname* "
                        name="surname"
                        defaultValue={surname}
                        required
                        onChange={e => updateUser(e.target)}
                    />
                    <input
                        type="text"
                        placeholder="Email*"
                        name="email"
                        defaultValue={email}
                        required
                        onChange={e => updateUser(e.target)}
                    />
                    <input
                        type="text"
                        placeholder="Phone Number*"
                        name="phoneNumber"
                        defaultValue={phoneNumber}
                        required
                        onChange={e => updateUser(e.target)}
                    />
                </div>
            </div>
        </>
    );
};

const mapStateToProps = state => ({ ...state.user });
export default connect(
    mapStateToProps,
    { updateUser }
)(YourDetails);
