import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { GET_CONFIRMATION_TEXT } from '../config/endpoints';

const Confirmation = ({ match }) => {
    const [confirmations, setConfirmations] = useState([]);

    async function fetchData() {
        const bookingId = match.params.bookingId;
        console.log(bookingId);
        if (bookingId === null) return null;
        axios
            .get(GET_CONFIRMATION_TEXT, {
                params: {
                    bookingId
                }
            })
            .then(response => {
                setConfirmations(response.data);
            })
            .catch(err => console.warn(err));
    }

    useEffect(() => {
        fetchData();
    }, []);

    return (
        <div className="centered-container">
            <h1>Thank you for booking with Xplore More</h1>
            <div className="confirmation" style={{ textAlign: 'left' }}>
                {confirmations.map((confirmation, key) => {
                    return (
                        <p
                            key={key}
                            style={{ fontWeight: 600 }}
                            dangerouslySetInnerHTML={{ __html: confirmation }}
                        />
                    );
                })}
            </div>

            <p>We hope you have an enjoyable journey to/from Edinburgh Airport.</p>
            <p>
                If you have any queries or questions regarding your booking please call 01382 201121
                during office hours 9 - 5.
            </p>
            <p>
                Monday to Friday Outwith these hours please call the National Express helpline
                number on 0871 781 8181 and they will be more than happy to assist you in your
                enquiry
            </p>
            <p>
                Please ensure that you arrive at the coach stance at least 10 minutes prior to the
                time of departure as after this time your seat may be released to other customers
            </p>
            <br />
            <a
                href="//www.nxdiscovrit.co.uk/"
                title="National Express Xplore Dundee"
                className="primary">
                Back to Xplore Site
            </a>
        </div>
    );
};

export default Confirmation;
