import React from 'react';
import { NavLink, withRouter } from 'react-router-dom';
import Routes from '../routes';
import Logo from '../images/logo.png';

const Header = ({ location }) => {
    console.log(location);
    const showText =
        location.pathname === '/booking/choose-journey' || location.pathname === '/booking/';
    return (
        <>
            <img src={Logo} alt="Xplore Dundee Logo" className="logo" />
            <div className="header">
                <ul>
                    {Routes.map((route, index) => {
                        return route.hide ? null : (
                            <li key={index}>
                                <NavLink
                                    exact={true}
                                    isActive={route.isActive && route.isActive}
                                    to={route.path}
                                    title={route.title}
                                    onClick={e => e.preventDefault()}>
                                    {route.title}
                                </NavLink>
                            </li>
                        );
                    })}
                </ul>
            </div>
            <div>{showText && <p>You can book your tickets for the Airport Xpress below. </p>}</div>
        </>
    );
};

export default withRouter(Header);
