import React, { Component } from 'react';
import axios from 'axios';
import Loader from 'react-loader-spinner';
import { connect } from 'react-redux';
import { toast } from 'react-toastify';
import { ADD_NEW_BOOKING } from './../config/endpoints';
import { addBooking } from '../redux/actions';
import { getTotalSeatsFromCart, getTotalCostFromCart } from '../redux/selectors';

class Payment extends Component {
    constructor(props) {
        super(props);

        this.state = {
            complete: false
        };
        this.formRef = React.createRef();
    }

    componentDidMount() {
        this.addBooking();
    }

    addBooking = () => {
        const { name, surname, email, phoneNumber } = this.props.user;
        const { inCart, addons, seats, price } = this.props;
        const outbound = this.props.outbound !== null && this.props.outbound.slug;
        const inbound = this.props.inbound !== null && this.props.inbound.slug;
        axios
            .post(ADD_NEW_BOOKING, {
                name,
                surname,
                email,
                phoneNumber,
                outbound,
                inbound,
                addons,
                seats,
                inCart,
                price
            })
            .then(response => {
                const bookingId = response.data;
                this.props.addBooking(bookingId);
                this.setState({ complete: true });
            })
            .catch(error => {
                toast.error(error.response.data);
                console.error('Create booking:', error);
                this.setState({ loading: false });
            });
    };

    componentDidUpdate(prevProps, prevState) {
        if (this.props.bookingId !== null && this.state.complete === true) {
            this.redirectWorldPay();
        }
    }

    redirectWorldPay = () => {
        const form = this.formRef.current;
        form.submit();
    };

    render() {
        return (
            <div className="choose-journey">
                <h1>Payment</h1>
                <Loader type="Oval" width={50} height={50} color="#088584" />
                {this.props.bookingId !== null && (
                    <>
                        <form
                            action="https://secure-test.worldpay.com/wcc/purchase"
                            method="POST"
                            ref={this.formRef}>
                            <input type="hidden" name="testMode" value="100" />
                            <input type="hidden" name="instId" value="1357697" />
                            <input type="hidden" name="cartId" value={this.props.bookingId} />
                            <input type="hidden" name="amount" value={this.props.price} />
                            <input type="hidden" name="currency" value="GBP" />
                        </form>
                    </>
                )}
            </div>
        );
    }
}

const mapStateToProps = state => {
    const { outbound, inbound, addons, inCart } = state.cart;
    const seats = getTotalSeatsFromCart(state);
    const price = getTotalCostFromCart(state);

    return {
        bookingId: state.booking.bookingId,
        user: state.user,
        outbound,
        inbound,
        addons,
        seats,
        inCart,
        price
    };
};

export default connect(
    mapStateToProps,
    { addBooking }
)(Payment);
