/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/content/plugins/xplore-booking-plugin/dist/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./assets/index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./assets/BookingApp.js":
/*!******************************!*\
  !*** ./assets/BookingApp.js ***!
  \******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components */ "./assets/components/index.js");
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-toastify */ "./node_modules/react-toastify/esm/react-toastify.js");
/* harmony import */ var react_toastify_dist_ReactToastify_min_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-toastify/dist/ReactToastify.min.css */ "./node_modules/react-toastify/dist/ReactToastify.min.css");
/* harmony import */ var react_toastify_dist_ReactToastify_min_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_toastify_dist_ReactToastify_min_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _config_FontAwesomeLibrary__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./config/FontAwesomeLibrary */ "./assets/config/FontAwesomeLibrary.js");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }









var BookingApp =
/*#__PURE__*/
function (_Component) {
  _inherits(BookingApp, _Component);

  function BookingApp(props) {
    _classCallCheck(this, BookingApp);

    return _possibleConstructorReturn(this, _getPrototypeOf(BookingApp).call(this, props));
  }

  _createClass(BookingApp, [{
    key: "render",
    value: function render() {
      return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "container"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_1__["BrowserRouter"], null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components__WEBPACK_IMPORTED_MODULE_2__["Header"], null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "row"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components__WEBPACK_IMPORTED_MODULE_2__["MainView"], null), this.props.step !== 6 && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components__WEBPACK_IMPORTED_MODULE_2__["Cart"], null))), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_toastify__WEBPACK_IMPORTED_MODULE_3__["ToastContainer"], {
        position: "top-center",
        autoClose: 3000,
        hideProgressBar: true,
        newestOnTop: true,
        transition: react_toastify__WEBPACK_IMPORTED_MODULE_3__["Slide"],
        closeOnClick: true,
        rtl: false,
        pauseOnVisibilityChange: true,
        draggable: true,
        pauseOnHover: false
      }));
    }
  }]);

  return BookingApp;
}(react__WEBPACK_IMPORTED_MODULE_0__["Component"]);

var mapStateToProps = function mapStateToProps(state) {
  return {
    step: state.route.step
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_6__["connect"])(mapStateToProps)(BookingApp));

/***/ }),

/***/ "./assets/components/Cart/Addons.js":
/*!******************************************!*\
  !*** ./assets/components/Cart/Addons.js ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





var Addons = function Addons(_ref) {
  var additionalLuggageChecked = _ref.additionalLuggageChecked,
      oversizedLuggage = _ref.oversizedLuggage;
  if (additionalLuggageChecked !== 'yes' && oversizedLuggage !== 'yes') return null;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "additional-cost"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("b", null, "Additional Cost")), additionalLuggageChecked === 'yes' && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Extra Luggage"), oversizedLuggage === 'yes' && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Oversized Luggage"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", {
    className: "small-text"
  }, "* The additional cost for each extra luggage is \xA310 per item, per journey. This will be paid upon your arrival at the bus"));
};

Addons.propTypes = {
  additionalLuggageChecked: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string,
  oversizedLuggage: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string
};
/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_2__["connect"])(function (state) {
  return _objectSpread({}, state.cart.addons);
})(Addons));

/***/ }),

/***/ "./assets/components/Cart/BackButton.js":
/*!**********************************************!*\
  !*** ./assets/components/Cart/BackButton.js ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../../redux/actions */ "./assets/redux/actions.js");





var BackButton = function BackButton(_ref) {
  var history = _ref.history,
      step = _ref.step,
      previousRoute = _ref.previousRoute;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "back-button"
  }, step > 1 && step < 5 && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    className: "dark",
    onClick: function onClick() {
      history.goBack();
      previousRoute();
    }
  }, "Back"));
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(function (state) {
  return {
    step: state.route.step
  };
}, {
  previousRoute: _redux_actions__WEBPACK_IMPORTED_MODULE_3__["previousRoute"]
})(Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["withRouter"])(BackButton)));

/***/ }),

/***/ "./assets/components/Cart/ContinueButton.js":
/*!**************************************************!*\
  !*** ./assets/components/Cart/ContinueButton.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../../redux/actions */ "./assets/redux/actions.js");
/* harmony import */ var _redux_selectors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../redux/selectors */ "./assets/redux/selectors.js");
/* harmony import */ var _routes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../routes */ "./assets/routes/index.js");
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-toastify */ "./node_modules/react-toastify/esm/react-toastify.js");








var ContinueButton = function ContinueButton(_ref) {
  var history = _ref.history,
      step = _ref.step,
      continueDisable = _ref.continueDisable,
      progressRoute = _ref.progressRoute,
      valid = _ref.valid;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    disabled: continueDisable,
    className: valid.status ? 'primary continue-button' : 'primary continue-button invalid',
    onClick: function onClick() {
      if (valid.status) {
        history.push(_routes__WEBPACK_IMPORTED_MODULE_5__["default"][step].path);
        progressRoute();
      } else {
        react_toastify__WEBPACK_IMPORTED_MODULE_6__["toast"].error(valid.message);
      }
    }
  }, valid.status && step == 4 ? 'Confirm and Pay' : 'Continue');
};

var mapStateToProps = function mapStateToProps(state) {
  var valid = Object(_redux_selectors__WEBPACK_IMPORTED_MODULE_4__["checkValidStep"])(state);
  return {
    step: state.route.step,
    continueDisable: state.route.continueDisable,
    valid: valid
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(mapStateToProps, {
  progressRoute: _redux_actions__WEBPACK_IMPORTED_MODULE_3__["progressRoute"]
})(Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["withRouter"])(ContinueButton)));

/***/ }),

/***/ "./assets/components/Cart/JourneyDetails.js":
/*!**************************************************!*\
  !*** ./assets/components/Cart/JourneyDetails.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);




var DirectionText = function DirectionText(_ref) {
  var direction = _ref.direction;
  return direction ? react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("b", null, "Dundee to Edinburgh")) : react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("b", null, "Edinburgh to Dundee"));
};

var departureTimeText = function departureTimeText(date, journey) {
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "detail"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "flex-row"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "label"
  }, "Departure"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "info"
  }, moment__WEBPACK_IMPORTED_MODULE_2___default()(date).format('ddd Do MMMM'), journey !== null && ", ".concat(journey.departure_time))), journey !== null && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "flex-row"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "label"
  }, "Arrival"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "info"
  }, journey !== null && "".concat(journey.arrival_time))));
};

var JourneyDetails = function JourneyDetails(_ref2) {
  var depart = _ref2.depart,
      departureDate = _ref2.departureDate,
      journeyType = _ref2.journeyType,
      returnDate = _ref2.returnDate,
      outbound = _ref2.outbound,
      inbound = _ref2.inbound;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "journey-details"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(DirectionText, {
    direction: depart === 'DUNDEE'
  }), departureDate && departureTimeText(departureDate, outbound), journeyType === 'RETURN' && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(DirectionText, {
    direction: depart !== 'DUNDEE'
  }), returnDate && departureTimeText(returnDate, inbound)), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("hr", null));
};

var mapStateToProps = function mapStateToProps(state) {
  var _state$cart = state.cart,
      depart = _state$cart.depart,
      departureDate = _state$cart.departureDate,
      journeyType = _state$cart.journeyType,
      returnDate = _state$cart.returnDate,
      inbound = _state$cart.inbound,
      outbound = _state$cart.outbound;
  return {
    depart: depart,
    departureDate: departureDate,
    journeyType: journeyType,
    returnDate: returnDate,
    inbound: inbound,
    outbound: outbound
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(mapStateToProps)(JourneyDetails));

/***/ }),

/***/ "./assets/components/Cart/PriceBreakdown.js":
/*!**************************************************!*\
  !*** ./assets/components/Cart/PriceBreakdown.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }





var iterateObject = function iterateObject(tickets, journeyType, advanced) {
  var items = [];
  var priceIndex;

  if (advanced) {
    priceIndex = journeyType === 'SINGLE' ? 'advanced_single' : 'advanced_return';
  } else {
    priceIndex = journeyType === 'SINGLE' ? 'single_cost' : 'return_cost';
  }

  for (var _i = 0, _Object$entries = Object.entries(tickets); _i < _Object$entries.length; _i++) {
    var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
        key = _Object$entries$_i[0],
        value = _Object$entries$_i[1];

    items.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", {
      key: key
    }, value.title, " x", value.quantity, ": ", react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("b", null, "\xA3", value[priceIndex] * value.quantity)));
  }

  return items;
};

var PriceBreakdown = function PriceBreakdown(_ref) {
  var inCart = _ref.inCart,
      journeyType = _ref.journeyType,
      bookingFee = _ref.bookingFee,
      advanced = _ref.advanced;
  var priceList = inCart ? iterateObject(inCart, journeyType, advanced) : null;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "price-breakdown"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("b", null, "Price breakdown")), priceList, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "\xA3", bookingFee, " Booking Fee"));
};

PriceBreakdown.propTypes = {
  inCart: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object,
  journeyType: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string
};

var mapStateToProps = function mapStateToProps(state) {
  return {
    advanced: state.cart.advanced,
    inCart: state.cart.inCart,
    journeyType: state.cart.journeyType,
    bookingFee: state.cart.bookingFee
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_2__["connect"])(mapStateToProps)(PriceBreakdown));

/***/ }),

/***/ "./assets/components/Cart/index.js":
/*!*****************************************!*\
  !*** ./assets/components/Cart/index.js ***!
  \*****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../redux/actions */ "./assets/redux/actions.js");
/* harmony import */ var _redux_selectors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../redux/selectors */ "./assets/redux/selectors.js");
/* harmony import */ var _BackButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BackButton */ "./assets/components/Cart/BackButton.js");
/* harmony import */ var _ContinueButton__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ContinueButton */ "./assets/components/Cart/ContinueButton.js");
/* harmony import */ var _JourneyDetails__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./JourneyDetails */ "./assets/components/Cart/JourneyDetails.js");
/* harmony import */ var _PriceBreakdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./PriceBreakdown */ "./assets/components/Cart/PriceBreakdown.js");
/* harmony import */ var _Addons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Addons */ "./assets/components/Cart/Addons.js");
/* harmony import */ var _fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @fortawesome/react-fontawesome */ "./node_modules/@fortawesome/react-fontawesome/index.es.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }












var Cart = function Cart(_ref) {
  var totalPrice = _ref.totalPrice,
      setTerms = _ref.setTerms;

  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false),
      _useState2 = _slicedToArray(_useState, 2),
      opened = _useState2[0],
      setOpened = _useState2[1];

  var cartOpen = opened ? 'open' : '';
  var rotation = opened ? 180 : null;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "cart ".concat(cartOpen)
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_BackButton__WEBPACK_IMPORTED_MODULE_4__["default"], null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "content"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "heading"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h2", null, "Booking Details"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    onClick: function onClick() {
      return setOpened(!opened);
    },
    className: "open-cart"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_9__["FontAwesomeIcon"], {
    icon: ['far', 'arrow-up'],
    rotation: rotation
  })), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", {
    className: "price"
  }, "\xA3", totalPrice), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("hr", null)), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "internal"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_JourneyDetails__WEBPACK_IMPORTED_MODULE_6__["default"], null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_PriceBreakdown__WEBPACK_IMPORTED_MODULE_7__["default"], null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_Addons__WEBPACK_IMPORTED_MODULE_8__["default"], null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "terms"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
    name: "terms",
    type: "checkbox",
    onChange: function onChange(e) {
      return setTerms(e.target.checked);
    }
  }), "I have read and accept the", ' ', react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", {
    href: "https://nxbus.co.uk/dundee/legal/",
    target: "_blank",
    rel: "noopener noreferrer"
  }, "terms and conditions"))), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_ContinueButton__WEBPACK_IMPORTED_MODULE_5__["default"], null)));
};

var mapStateToProps = function mapStateToProps(state) {
  var _state$cart = state.cart,
      journeyType = _state$cart.journeyType,
      depart = _state$cart.depart,
      departureDate = _state$cart.departureDate,
      returnDate = _state$cart.returnDate,
      inCart = _state$cart.inCart;
  var totalPrice = Object(_redux_selectors__WEBPACK_IMPORTED_MODULE_3__["getTotalCostFromCart"])(state);
  return {
    journeyType: journeyType,
    depart: depart,
    departureDate: departureDate,
    returnDate: returnDate,
    inCart: inCart,
    totalPrice: totalPrice
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(mapStateToProps, {
  setTerms: _redux_actions__WEBPACK_IMPORTED_MODULE_2__["setTerms"]
})(Cart));

/***/ }),

/***/ "./assets/components/ChooseTickets/DateSelect.js":
/*!*******************************************************!*\
  !*** ./assets/components/ChooseTickets/DateSelect.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var react_datepicker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-datepicker */ "./node_modules/react-datepicker/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../redux/actions */ "./assets/redux/actions.js");




var now = new Date();

var DateSelect = function DateSelect(_ref) {
  var journeyType = _ref.journeyType,
      departureDate = _ref.departureDate,
      returnDate = _ref.returnDate,
      setDepartureDate = _ref.setDepartureDate,
      setReturnDate = _ref.setReturnDate;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "date-select"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "input-wrap"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
    htmlFor: "Departure Date"
  }, "Departure Date"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_datepicker__WEBPACK_IMPORTED_MODULE_2__["default"], {
    name: "Departure Date",
    selected: departureDate,
    onChange: function onChange(value) {
      return setDepartureDate(value);
    },
    dateFormat: "dd/M/Y",
    required: true,
    withPortal: window.innerWidth < 992
  })), journeyType === 'RETURN' && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "input-wrap"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("label", {
    htmlFor: "Departure Date"
  }, "Return Date"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_datepicker__WEBPACK_IMPORTED_MODULE_2__["default"], {
    selected: returnDate === null ? now : returnDate,
    onChange: function onChange(value) {
      return setReturnDate(value);
    },
    dateFormat: "dd/M/Y",
    required: true,
    withPortal: window.innerWidth < 992
  })));
};

var mapStateToProps = function mapStateToProps(state) {
  var _state$cart = state.cart,
      journeyType = _state$cart.journeyType,
      departureDate = _state$cart.departureDate,
      returnDate = _state$cart.returnDate;
  return {
    journeyType: journeyType,
    departureDate: departureDate,
    returnDate: returnDate
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(mapStateToProps, {
  setDepartureDate: _redux_actions__WEBPACK_IMPORTED_MODULE_3__["setDepartureDate"],
  setReturnDate: _redux_actions__WEBPACK_IMPORTED_MODULE_3__["setReturnDate"]
})(DateSelect));

/***/ }),

/***/ "./assets/components/ChooseTickets/DirectionSelect.js":
/*!************************************************************!*\
  !*** ./assets/components/ChooseTickets/DirectionSelect.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../redux/actions */ "./assets/redux/actions.js");
/* harmony import */ var _fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @fortawesome/react-fontawesome */ "./node_modules/@fortawesome/react-fontawesome/index.es.js");





var JourneyTypeSelect = function JourneyTypeSelect(_ref) {
  var depart = _ref.depart,
      changeDirection = _ref.changeDirection;
  var leave = depart === 'DUNDEE' ? 'Dundee' : 'Edinburgh Airport';
  var arrive = depart === 'DUNDEE' ? 'Edinburgh Airport' : 'Dundee';
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "direction-select"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null, leave), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    onClick: changeDirection
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_3__["FontAwesomeIcon"], {
    icon: ['far', 'exchange-alt'],
    rotation: 90
  })), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", null, arrive));
};

var mapStateToProps = function mapStateToProps(state) {
  return {
    depart: state.cart.depart
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(mapStateToProps, {
  changeDirection: _redux_actions__WEBPACK_IMPORTED_MODULE_2__["changeDirection"]
})(JourneyTypeSelect));

/***/ }),

/***/ "./assets/components/ChooseTickets/JourneyTypeSelect.js":
/*!**************************************************************!*\
  !*** ./assets/components/ChooseTickets/JourneyTypeSelect.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../redux/actions */ "./assets/redux/actions.js");




var JourneyTypeSelect = function JourneyTypeSelect(_ref) {
  var journeyType = _ref.journeyType,
      changeJourneyType = _ref.changeJourneyType;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "journey-type-radio"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
    type: "radio",
    value: "SINGLE",
    name: "journey_type",
    onChange: function onChange(e) {
      return changeJourneyType(e.target.value);
    },
    checked: journeyType === 'SINGLE'
  }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    className: journeyType === 'SINGLE' ? 'active primary' : 'primary',
    onClick: function onClick() {
      return changeJourneyType('SINGLE');
    }
  }, "Single")), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "journey-type-radio"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
    type: "radio",
    value: "RETURN",
    name: "journey_type",
    onChange: function onChange(e) {
      return changeJourneyType(e.target.value);
    },
    checked: journeyType === 'RETURN'
  }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    className: journeyType === 'RETURN' ? 'active primary' : 'primary',
    onClick: function onClick() {
      return changeJourneyType('RETURN');
    }
  }, "Return")));
};

var mapStateToProps = function mapStateToProps(state) {
  return {
    journeyType: state.cart.journeyType
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(mapStateToProps, {
  changeJourneyType: _redux_actions__WEBPACK_IMPORTED_MODULE_2__["changeJourneyType"]
})(JourneyTypeSelect));

/***/ }),

/***/ "./assets/components/ChooseTickets/NoResults.js":
/*!******************************************************!*\
  !*** ./assets/components/ChooseTickets/NoResults.js ***!
  \******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../redux/actions */ "./assets/redux/actions.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");





var NoResults = function NoResults(_ref) {
  var history = _ref.history,
      previousRoute = _ref.previousRoute;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "No results found for the selected time.", react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    onClick: function onClick() {
      history.goBack();
      previousRoute();
    }
  }, "Back to Search"));
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(null, {
  previousRoute: _redux_actions__WEBPACK_IMPORTED_MODULE_2__["previousRoute"]
})(Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__["withRouter"])(NoResults)));

/***/ }),

/***/ "./assets/components/ChooseTickets/TicketList.js":
/*!*******************************************************!*\
  !*** ./assets/components/ChooseTickets/TicketList.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../redux/actions */ "./assets/redux/actions.js");
/* harmony import */ var _redux_selectors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../redux/selectors */ "./assets/redux/selectors.js");
/* harmony import */ var react_loader_spinner__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-loader-spinner */ "./node_modules/react-loader-spinner/index.js");
/* harmony import */ var react_loader_spinner__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_loader_spinner__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @fortawesome/react-fontawesome */ "./node_modules/@fortawesome/react-fontawesome/index.es.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }








var TicketList = function TicketList(_ref) {
  var tickets = _ref.tickets,
      totalPassengers = _ref.totalPassengers,
      inCart = _ref.inCart,
      addTicketToCart = _ref.addTicketToCart,
      removeTicketFromCart = _ref.removeTicketFromCart;

  var _useState = Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false),
      _useState2 = _slicedToArray(_useState, 2),
      opened = _useState2[0],
      setOpened = _useState2[1];

  var openClass = opened ? 'open' : '';
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "ticket-list"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "ticket-input",
    onClick: function onClick() {
      return setOpened(!opened);
    }
  }, totalPassengers, " Passengers", react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    onClick: function onClick() {
      return setOpened(!opened);
    }
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_5__["FontAwesomeIcon"], {
    icon: ['far', 'chevron-down'],
    rotation: opened ? 180 : null
  }))), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "ticket-window ".concat(openClass)
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "container"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h2", null, "Passengers"), tickets.length === 0 ? react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_loader_spinner__WEBPACK_IMPORTED_MODULE_4___default.a, {
    type: "Oval",
    width: 50,
    height: 50,
    color: "#088584"
  }) : tickets.map(function (ticket) {
    var id = ticket.id,
        title = ticket.title;
    var count = inCart[id] ? inCart[id].quantity : 0;
    return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
      className: "ticket",
      key: id
    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", {
      className: "title"
    }, title), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
      onClick: function onClick() {
        return removeTicketFromCart(ticket);
      }
    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_5__["FontAwesomeIcon"], {
      icon: ['fas', 'minus-circle']
    })), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span", null, count), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
      onClick: function onClick() {
        return addTicketToCart(ticket);
      }
    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_fortawesome_react_fontawesome__WEBPACK_IMPORTED_MODULE_5__["FontAwesomeIcon"], {
      icon: ['fas', 'plus-circle']
    })));
  }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "info"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("b", null, "Important information"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ol", null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null, "For wheelchair - number to call 01382 340006/7 and requires 48 hours advance notice"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null, "For 7+, visit Travel Centre and call 01382 340006/7"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", null, "A family ticket covers two adults with two children or one adult with three children"))), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
    className: "primary",
    onClick: function onClick() {
      return setOpened(false);
    }
  }, "Done"))));
};

var mapStateToProps = function mapStateToProps(state) {
  return {
    tickets: state.tickets.allTickets,
    inCart: state.cart.inCart,
    totalPassengers: Object(_redux_selectors__WEBPACK_IMPORTED_MODULE_3__["getTotalSeatsFromCart"])(state)
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(mapStateToProps, {
  addTicketToCart: _redux_actions__WEBPACK_IMPORTED_MODULE_2__["addTicketToCart"],
  removeTicketFromCart: _redux_actions__WEBPACK_IMPORTED_MODULE_2__["removeTicketFromCart"]
})(TicketList));

/***/ }),

/***/ "./assets/components/ChooseTickets/index.js":
/*!**************************************************!*\
  !*** ./assets/components/ChooseTickets/index.js ***!
  \**************************************************/
/*! exports provided: JourneyTypeSelect, DirectionSelect, DateSelect, TicketList */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _JourneyTypeSelect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./JourneyTypeSelect */ "./assets/components/ChooseTickets/JourneyTypeSelect.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JourneyTypeSelect", function() { return _JourneyTypeSelect__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony import */ var _DirectionSelect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DirectionSelect */ "./assets/components/ChooseTickets/DirectionSelect.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DirectionSelect", function() { return _DirectionSelect__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _DateSelect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DateSelect */ "./assets/components/ChooseTickets/DateSelect.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DateSelect", function() { return _DateSelect__WEBPACK_IMPORTED_MODULE_2__["default"]; });

/* harmony import */ var _TicketList__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TicketList */ "./assets/components/ChooseTickets/TicketList.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TicketList", function() { return _TicketList__WEBPACK_IMPORTED_MODULE_3__["default"]; });







/***/ }),

/***/ "./assets/components/Footer.js":
/*!*************************************!*\
  !*** ./assets/components/Footer.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/* harmony default export */ __webpack_exports__["default"] = (function () {
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "footer"
  }, "Footer");
});

/***/ }),

/***/ "./assets/components/Header.js":
/*!*************************************!*\
  !*** ./assets/components/Header.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _routes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../routes */ "./assets/routes/index.js");
/* harmony import */ var _images_logo_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../images/logo.png */ "./assets/images/logo.png");
/* harmony import */ var _images_logo_png__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_images_logo_png__WEBPACK_IMPORTED_MODULE_3__);





var Header = function Header() {
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("img", {
    src: _images_logo_png__WEBPACK_IMPORTED_MODULE_3___default.a,
    alt: "Xplore Dundee Logo",
    className: "logo"
  }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "header"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("ul", null, _routes__WEBPACK_IMPORTED_MODULE_2__["default"].map(function (route, index) {
    return route.hide ? null : react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("li", {
      key: index
    }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_1__["NavLink"], {
      exact: true,
      isActive: route.isActive && route.isActive,
      to: route.path,
      title: route.title,
      onClick: function onClick(e) {
        return e.preventDefault();
      }
    }, route.title));
  }))));
};

/* harmony default export */ __webpack_exports__["default"] = (Header);

/***/ }),

/***/ "./assets/components/MainView.js":
/*!***************************************!*\
  !*** ./assets/components/MainView.js ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var react_pose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-pose */ "./node_modules/react-pose/dist/react-pose.es.js");
/* harmony import */ var _routes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../routes */ "./assets/routes/index.js");




var RoutesContainer = react_pose__WEBPACK_IMPORTED_MODULE_2__["default"].div({
  enter: {
    opacity: 1,
    delay: 100,
    beforeChildren: true
  },
  exit: {
    opacity: 0
  }
});

var MainView = function MainView() {
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "main-view"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_1__["Route"], {
    render: function render(_ref) {
      var location = _ref.location;
      return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_pose__WEBPACK_IMPORTED_MODULE_2__["PoseGroup"], null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(RoutesContainer, {
        key: location.pathname
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_1__["Switch"], {
        location: location
      }, _routes__WEBPACK_IMPORTED_MODULE_3__["default"].map(function (route, index) {
        return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_1__["Route"], {
          exact: true,
          path: route.path,
          component: route.component,
          key: index
        });
      }))));
    }
  }));
};

/* harmony default export */ __webpack_exports__["default"] = (MainView);

/***/ }),

/***/ "./assets/components/index.js":
/*!************************************!*\
  !*** ./assets/components/index.js ***!
  \************************************/
/*! exports provided: Header, Footer, MainView, Cart */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Header__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Header */ "./assets/components/Header.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Header", function() { return _Header__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony import */ var _Footer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Footer */ "./assets/components/Footer.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Footer", function() { return _Footer__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _MainView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MainView */ "./assets/components/MainView.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MainView", function() { return _MainView__WEBPACK_IMPORTED_MODULE_2__["default"]; });

/* harmony import */ var _Cart__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Cart */ "./assets/components/Cart/index.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Cart", function() { return _Cart__WEBPACK_IMPORTED_MODULE_3__["default"]; });







/***/ }),

/***/ "./assets/config/FontAwesomeLibrary.js":
/*!*********************************************!*\
  !*** ./assets/config/FontAwesomeLibrary.js ***!
  \*********************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @fortawesome/fontawesome-svg-core */ "./node_modules/@fortawesome/fontawesome-svg-core/index.es.js");
/* harmony import */ var _fortawesome_pro_regular_svg_icons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @fortawesome/pro-regular-svg-icons */ "./node_modules/@fortawesome/pro-regular-svg-icons/index.es.js");
/* harmony import */ var _fortawesome_pro_solid_svg_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @fortawesome/pro-solid-svg-icons */ "./node_modules/@fortawesome/pro-solid-svg-icons/index.es.js");



_fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_0__["library"].add(_fortawesome_pro_regular_svg_icons__WEBPACK_IMPORTED_MODULE_1__["faExchangeAlt"], _fortawesome_pro_regular_svg_icons__WEBPACK_IMPORTED_MODULE_1__["faArrowUp"], _fortawesome_pro_solid_svg_icons__WEBPACK_IMPORTED_MODULE_2__["faPlusCircle"], _fortawesome_pro_solid_svg_icons__WEBPACK_IMPORTED_MODULE_2__["faMinusCircle"], _fortawesome_pro_regular_svg_icons__WEBPACK_IMPORTED_MODULE_1__["faChevronDown"]);

/***/ }),

/***/ "./assets/config/endpoints.js":
/*!************************************!*\
  !*** ./assets/config/endpoints.js ***!
  \************************************/
/*! exports provided: ENDPOINT_URL, ALL_TICKETS, ALL_JOURNEYS, AVAILABLE_JOURNEYS, ADD_NEW_BOOKING */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ENDPOINT_URL", function() { return ENDPOINT_URL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ALL_TICKETS", function() { return ALL_TICKETS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ALL_JOURNEYS", function() { return ALL_JOURNEYS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AVAILABLE_JOURNEYS", function() { return AVAILABLE_JOURNEYS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ADD_NEW_BOOKING", function() { return ADD_NEW_BOOKING; });
var ENDPOINT_URL = "/wp-json/xplore-booking/v1";
var ALL_TICKETS = "".concat(ENDPOINT_URL, "/get-all-tickets");
var ALL_JOURNEYS = "".concat(ENDPOINT_URL, "/get-all-journey-times/");
var AVAILABLE_JOURNEYS = "".concat(ENDPOINT_URL, "/return-available-journeys/");
var ADD_NEW_BOOKING = "".concat(ENDPOINT_URL, "/add-new-booking/");

/***/ }),

/***/ "./assets/images/logo.png":
/*!********************************!*\
  !*** ./assets/images/logo.png ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "images/202a007189bc49f7ce59e40b33f1298d.png";

/***/ }),

/***/ "./assets/index.js":
/*!*************************!*\
  !*** ./assets/index.js ***!
  \*************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _styles_main_scss__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/main.scss */ "./assets/styles/main.scss");
/* harmony import */ var _styles_main_scss__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_styles_main_scss__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_datepicker_dist_react_datepicker_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-datepicker/dist/react-datepicker.css */ "./node_modules/react-datepicker/dist/react-datepicker.css");
/* harmony import */ var react_datepicker_dist_react_datepicker_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_datepicker_dist_react_datepicker_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var normalize_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! normalize.css */ "./node_modules/normalize.css/normalize.css");
/* harmony import */ var normalize_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(normalize_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./redux/store */ "./assets/redux/store.js");
/* harmony import */ var _BookingApp__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./BookingApp */ "./assets/BookingApp.js");








react_dom__WEBPACK_IMPORTED_MODULE_1___default.a.render(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_redux__WEBPACK_IMPORTED_MODULE_5__["Provider"], {
  store: _redux_store__WEBPACK_IMPORTED_MODULE_6__["default"]
}, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_BookingApp__WEBPACK_IMPORTED_MODULE_7__["default"], null)), document.getElementById('app'));

/***/ }),

/***/ "./assets/redux/actionTypes.js":
/*!*************************************!*\
  !*** ./assets/redux/actionTypes.js ***!
  \*************************************/
/*! exports provided: CHANGE_JOURNEY_TYPE, CHANGE_DIRECTION, SET_DEPARTURE_DATE, SET_RETURN_DATE, ADD_TICKET_TO_CART, REMOVE_TICKET_FROM_CART, UPDATE_ADDONS, SET_TERMS, ADD_JOURNEY, ADD_TICKETS, UPDATE_USER, PROGRESS_ROUTE, PREVIOUS_ROUTE, ADD_BOOKING */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CHANGE_JOURNEY_TYPE", function() { return CHANGE_JOURNEY_TYPE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CHANGE_DIRECTION", function() { return CHANGE_DIRECTION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SET_DEPARTURE_DATE", function() { return SET_DEPARTURE_DATE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SET_RETURN_DATE", function() { return SET_RETURN_DATE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ADD_TICKET_TO_CART", function() { return ADD_TICKET_TO_CART; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "REMOVE_TICKET_FROM_CART", function() { return REMOVE_TICKET_FROM_CART; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UPDATE_ADDONS", function() { return UPDATE_ADDONS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SET_TERMS", function() { return SET_TERMS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ADD_JOURNEY", function() { return ADD_JOURNEY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ADD_TICKETS", function() { return ADD_TICKETS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UPDATE_USER", function() { return UPDATE_USER; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PROGRESS_ROUTE", function() { return PROGRESS_ROUTE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PREVIOUS_ROUTE", function() { return PREVIOUS_ROUTE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ADD_BOOKING", function() { return ADD_BOOKING; });
//CART
var CHANGE_JOURNEY_TYPE = 'CHANGE_JOURNEY_TYPE';
var CHANGE_DIRECTION = 'CHANGE_DIRECTION';
var SET_DEPARTURE_DATE = 'SET_DEPARTURE_DATE';
var SET_RETURN_DATE = 'SET_RETURN_DATE';
var ADD_TICKET_TO_CART = 'ADD_TICKET_TO_CART';
var REMOVE_TICKET_FROM_CART = 'REMOVE_TICKET_FROM_CART';
var UPDATE_ADDONS = 'UPDATE_ADDONS';
var SET_TERMS = 'SET_TERMS';
var ADD_JOURNEY = 'ADD_JOURNEY'; //TICKETS

var ADD_TICKETS = 'ADD_TICKETS'; //USER

var UPDATE_USER = 'UPDATE_USER'; //ROUTE

var PROGRESS_ROUTE = 'PROGRESS_ROUTE';
var PREVIOUS_ROUTE = 'PREVIOUS_ROUTE'; //BOOKING

var ADD_BOOKING = 'ADD_BOOKING';

/***/ }),

/***/ "./assets/redux/actions.js":
/*!*********************************!*\
  !*** ./assets/redux/actions.js ***!
  \*********************************/
/*! exports provided: changeJourneyType, changeDirection, setDepartureDate, setReturnDate, addTicketToCart, removeTicketFromCart, updateAddons, setTerms, addJourney, addTickets, updateUser, progressRoute, previousRoute, addBooking */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "changeJourneyType", function() { return changeJourneyType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "changeDirection", function() { return changeDirection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setDepartureDate", function() { return setDepartureDate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setReturnDate", function() { return setReturnDate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addTicketToCart", function() { return addTicketToCart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeTicketFromCart", function() { return removeTicketFromCart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateAddons", function() { return updateAddons; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setTerms", function() { return setTerms; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addJourney", function() { return addJourney; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addTickets", function() { return addTickets; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateUser", function() { return updateUser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "progressRoute", function() { return progressRoute; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "previousRoute", function() { return previousRoute; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addBooking", function() { return addBooking; });
/* harmony import */ var _actionTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./actionTypes */ "./assets/redux/actionTypes.js");
 //CART

var changeJourneyType = function changeJourneyType(type) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["CHANGE_JOURNEY_TYPE"],
    payload: {
      type: type
    }
  };
};
var changeDirection = function changeDirection() {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["CHANGE_DIRECTION"]
  };
};
var setDepartureDate = function setDepartureDate(date) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["SET_DEPARTURE_DATE"],
    payload: {
      date: date
    }
  };
};
var setReturnDate = function setReturnDate(date) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["SET_RETURN_DATE"],
    payload: {
      date: date
    }
  };
};
var addTicketToCart = function addTicketToCart(ticket) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["ADD_TICKET_TO_CART"],
    payload: ticket
  };
};
var removeTicketFromCart = function removeTicketFromCart(id) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["REMOVE_TICKET_FROM_CART"],
    payload: id
  };
};
var updateAddons = function updateAddons(field) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["UPDATE_ADDONS"],
    payload: {
      key: field.name,
      value: field.value
    }
  };
};
var setTerms = function setTerms(value) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["SET_TERMS"],
    payload: value
  };
};
var addJourney = function addJourney(journey, direction) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["ADD_JOURNEY"],
    payload: {
      journey: journey,
      direction: direction
    }
  };
}; //TICKETS

var addTickets = function addTickets(tickets) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["ADD_TICKETS"],
    payload: tickets
  };
}; //USER

var updateUser = function updateUser(field) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["UPDATE_USER"],
    payload: {
      key: field.name,
      value: field.value
    }
  };
}; //ROUTE

var progressRoute = function progressRoute() {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["PROGRESS_ROUTE"]
  };
};
var previousRoute = function previousRoute() {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["PREVIOUS_ROUTE"]
  };
}; //BOOKING

var addBooking = function addBooking(bookingId) {
  return {
    type: _actionTypes__WEBPACK_IMPORTED_MODULE_0__["ADD_BOOKING"],
    payload: {
      bookingId: bookingId
    }
  };
};

/***/ }),

/***/ "./assets/redux/reducers/booking.js":
/*!******************************************!*\
  !*** ./assets/redux/reducers/booking.js ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _actionTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../actionTypes */ "./assets/redux/actionTypes.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


var initialState = {
  bookingId: null
};
/* harmony default export */ __webpack_exports__["default"] = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actionTypes__WEBPACK_IMPORTED_MODULE_0__["ADD_BOOKING"]:
      {
        var bookingId = action.payload.bookingId;
        return _objectSpread({}, state, {
          bookingId: bookingId
        });
      }

    default:
      return state;
  }
});

/***/ }),

/***/ "./assets/redux/reducers/cart.js":
/*!***************************************!*\
  !*** ./assets/redux/reducers/cart.js ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _actionTypes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../actionTypes */ "./assets/redux/actionTypes.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }



var now = new Date();
var initialState = {
  journeyType: 'SINGLE',
  depart: 'DUNDEE',
  departureDate: now,
  returnDate: null,
  inCart: {},
  addons: {
    additionalLuggageChecked: 'no',
    luggageDescription: '',
    oversizedLuggage: 'no',
    oversizedDescription: ''
  },
  outbound: null,
  inbound: null,
  agreeToTerms: false,
  bookingFee: 1,
  advanced: false
};
/* harmony default export */ __webpack_exports__["default"] = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["CHANGE_JOURNEY_TYPE"]:
      {
        var type = action.payload.type;
        return _objectSpread({}, state, {
          journeyType: type
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["CHANGE_DIRECTION"]:
      {
        var newDepart = state.depart === 'DUNDEE' ? 'EDINBURGH' : 'DUNDEE';
        return _objectSpread({}, state, {
          depart: newDepart
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["SET_DEPARTURE_DATE"]:
      {
        var date = action.payload.date;

        var _now = moment__WEBPACK_IMPORTED_MODULE_0___default()(new Date());

        var selected = moment__WEBPACK_IMPORTED_MODULE_0___default()(date);
        var duration = moment__WEBPACK_IMPORTED_MODULE_0___default.a.duration(selected.diff(_now)).asDays();
        var advanced = duration >= 14;
        return _objectSpread({}, state, {
          departureDate: date,
          advanced: advanced
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["SET_RETURN_DATE"]:
      {
        var _date = action.payload.date;
        return _objectSpread({}, state, {
          returnDate: _date
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["ADD_TICKET_TO_CART"]:
      {
        var _action$payload = action.payload,
            id = _action$payload.id,
            title = _action$payload.title,
            single_cost = _action$payload.single_cost,
            return_cost = _action$payload.return_cost,
            seats = _action$payload.seats,
            advanced_single = _action$payload.advanced_single,
            advanced_return = _action$payload.advanced_return;
        var newObj = state.inCart[id] ? {
          quantity: state.inCart[id].quantity + 1
        } : {
          title: title,
          single_cost: single_cost,
          return_cost: return_cost,
          seats: seats,
          quantity: 1,
          advanced_single: advanced_single,
          advanced_return: advanced_return
        };
        return _objectSpread({}, state, {
          inCart: _objectSpread({}, state.inCart, _defineProperty({}, id, _objectSpread({}, state.inCart[id], newObj)))
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["REMOVE_TICKET_FROM_CART"]:
      {
        var _id = action.payload.id;
        if (!(_id in state.inCart)) return state;

        if (state.inCart[_id].quantity === 1) {
          var newInCart = state.inCart;
          delete newInCart[_id];
          return _objectSpread({}, state, {
            inCart: _objectSpread({}, newInCart)
          });
        }

        var quantity = state.inCart[_id].quantity - 1;
        return _objectSpread({}, state, {
          inCart: _objectSpread({}, state.inCart, _defineProperty({}, _id, _objectSpread({}, state.inCart[_id], {
            quantity: quantity
          })))
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["UPDATE_ADDONS"]:
      {
        var _action$payload2 = action.payload,
            key = _action$payload2.key,
            value = _action$payload2.value;
        return _objectSpread({}, state, {
          addons: _objectSpread({}, state.addons, _defineProperty({}, key, value))
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["SET_TERMS"]:
      {
        return _objectSpread({}, state, {
          agreeToTerms: action.payload
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_1__["ADD_JOURNEY"]:
      {
        var _action$payload3 = action.payload,
            journey = _action$payload3.journey,
            direction = _action$payload3.direction;
        return _objectSpread({}, state, _defineProperty({}, direction, _objectSpread({}, journey)));
      }

    default:
      return state;
  }
});

/***/ }),

/***/ "./assets/redux/reducers/index.js":
/*!****************************************!*\
  !*** ./assets/redux/reducers/index.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var redux__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! redux */ "./node_modules/redux/es/redux.js");
/* harmony import */ var _cart__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cart */ "./assets/redux/reducers/cart.js");
/* harmony import */ var _tickets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./tickets */ "./assets/redux/reducers/tickets.js");
/* harmony import */ var _user__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./user */ "./assets/redux/reducers/user.js");
/* harmony import */ var _route__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./route */ "./assets/redux/reducers/route.js");
/* harmony import */ var _booking__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./booking */ "./assets/redux/reducers/booking.js");






/* harmony default export */ __webpack_exports__["default"] = (Object(redux__WEBPACK_IMPORTED_MODULE_0__["combineReducers"])({
  cart: _cart__WEBPACK_IMPORTED_MODULE_1__["default"],
  tickets: _tickets__WEBPACK_IMPORTED_MODULE_2__["default"],
  user: _user__WEBPACK_IMPORTED_MODULE_3__["default"],
  route: _route__WEBPACK_IMPORTED_MODULE_4__["default"],
  booking: _booking__WEBPACK_IMPORTED_MODULE_5__["default"]
}));

/***/ }),

/***/ "./assets/redux/reducers/route.js":
/*!****************************************!*\
  !*** ./assets/redux/reducers/route.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _actionTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../actionTypes */ "./assets/redux/actionTypes.js");
/* harmony import */ var _routes_index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../../routes/index */ "./assets/routes/index.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




var initialState = {
  step: 1,
  continueDisable: false
};
/* harmony default export */ __webpack_exports__["default"] = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actionTypes__WEBPACK_IMPORTED_MODULE_0__["PROGRESS_ROUTE"]:
      {
        var nextStep = state.step + 1;
        if (nextStep > _routes_index__WEBPACK_IMPORTED_MODULE_1__["Routes"].length) return _objectSpread({}, state);
        var continueDisable = nextStep === _routes_index__WEBPACK_IMPORTED_MODULE_1__["Routes"].length;
        return _objectSpread({}, state, {
          continueDisable: continueDisable,
          step: nextStep
        });
      }

    case _actionTypes__WEBPACK_IMPORTED_MODULE_0__["PREVIOUS_ROUTE"]:
      {
        var prevStep = state.step - 1;
        if (prevStep < 0) return _objectSpread({}, state);

        var _continueDisable = prevStep === _routes_index__WEBPACK_IMPORTED_MODULE_1__["Routes"].length;

        return _objectSpread({}, state, {
          continueDisable: _continueDisable,
          step: prevStep
        });
      }

    default:
      return state;
  }
});

/***/ }),

/***/ "./assets/redux/reducers/tickets.js":
/*!******************************************!*\
  !*** ./assets/redux/reducers/tickets.js ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _actionTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../actionTypes */ "./assets/redux/actionTypes.js");
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }


var initialState = {
  allTickets: []
};
/* harmony default export */ __webpack_exports__["default"] = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actionTypes__WEBPACK_IMPORTED_MODULE_0__["ADD_TICKETS"]:
      {
        return {
          allTickets: _toConsumableArray(action.payload)
        };
      }

    default:
      return state;
  }
});

/***/ }),

/***/ "./assets/redux/reducers/user.js":
/*!***************************************!*\
  !*** ./assets/redux/reducers/user.js ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _actionTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../actionTypes */ "./assets/redux/actionTypes.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


var initialState = {};
/* harmony default export */ __webpack_exports__["default"] = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case _actionTypes__WEBPACK_IMPORTED_MODULE_0__["UPDATE_USER"]:
      {
        var _action$payload = action.payload,
            key = _action$payload.key,
            value = _action$payload.value;
        return _objectSpread({}, state, _defineProperty({}, key, value));
      }

    default:
      return state;
  }
});

/***/ }),

/***/ "./assets/redux/selectors.js":
/*!***********************************!*\
  !*** ./assets/redux/selectors.js ***!
  \***********************************/
/*! exports provided: getTotalSeatsFromCart, getTotalCostFromCart, checkValidStep */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTotalSeatsFromCart", function() { return getTotalSeatsFromCart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTotalCostFromCart", function() { return getTotalCostFromCart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "checkValidStep", function() { return checkValidStep; });
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! yup */ "./node_modules/yup/lib/index.js");
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_0__);
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }


var schema = yup__WEBPACK_IMPORTED_MODULE_0__["object"]().shape({
  name: yup__WEBPACK_IMPORTED_MODULE_0__["string"]().required(),
  surname: yup__WEBPACK_IMPORTED_MODULE_0__["string"]().required(),
  email: yup__WEBPACK_IMPORTED_MODULE_0__["string"]().email().required(),
  phoneNumber: yup__WEBPACK_IMPORTED_MODULE_0__["number"]().required()
});
var getTotalSeatsFromCart = function getTotalSeatsFromCart(store) {
  var inCart = store.cart.inCart;
  var seats = 0;

  for (var _i = 0, _Object$entries = Object.entries(inCart); _i < _Object$entries.length; _i++) {
    var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
        key = _Object$entries$_i[0],
        value = _Object$entries$_i[1];

    seats += parseInt(value.seats) * parseInt(value.quantity);
  }

  return seats;
};
var getTotalCostFromCart = function getTotalCostFromCart(store) {
  var _store$cart = store.cart,
      inCart = _store$cart.inCart,
      journeyType = _store$cart.journeyType,
      bookingFee = _store$cart.bookingFee,
      advanced = _store$cart.advanced;
  var priceIndex;

  if (advanced) {
    priceIndex = journeyType === 'SINGLE' ? 'advanced_single' : 'advanced_return';
  } else {
    priceIndex = journeyType === 'SINGLE' ? 'single_cost' : 'return_cost';
  }

  var cost = Object.keys(inCart).length === 0 ? 0 : bookingFee;

  for (var _i2 = 0, _Object$entries2 = Object.entries(inCart); _i2 < _Object$entries2.length; _i2++) {
    var _Object$entries2$_i = _slicedToArray(_Object$entries2[_i2], 2),
        key = _Object$entries2$_i[0],
        value = _Object$entries2$_i[1];

    cost += value[priceIndex] * value.quantity;
  }

  return cost;
};
var checkValidStep = function checkValidStep(store) {
  var step = store.route.step;
  var valid = {
    status: true,
    message: ''
  };

  switch (step) {
    case 1:
      {
        if (Object.keys(store.cart.inCart).length === 0) {
          valid.status = false;
          valid.message = 'At least one ticket must be added';
        }

        if (store.cart.journeyType === 'RETURN' && store.cart.returnDate === null) {
          valid.status = false;
          valid.message = 'A return date must be selected';
        }

        break;
      }

    case 2:
      {
        var _store$cart2 = store.cart,
            outbound = _store$cart2.outbound,
            inbound = _store$cart2.inbound,
            journeyType = _store$cart2.journeyType;

        if (outbound === null) {
          valid.status = false;
          valid.message = 'An outbound journey must be selected';
        }

        if (journeyType === 'RETURN' && inbound === null) {
          valid.status = false;
          valid.message = 'An inbound journey must be selected';
        }

        break;
      }

    case 4:
      {
        var validSchema = schema.isValidSync(store.user);

        if (!validSchema) {
          valid.status = false;
          valid.message = 'Please check you have filled in all the details with valid information';
        }

        var agreeToTerms = store.cart.agreeToTerms;

        if (!agreeToTerms) {
          valid.status = false;
          valid.message = 'You must accept the terms and conditions before continuing';
        }

        break;
      }

    default:
      return valid;
  }

  return valid;
};

/***/ }),

/***/ "./assets/redux/store.js":
/*!*******************************!*\
  !*** ./assets/redux/store.js ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var redux__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! redux */ "./node_modules/redux/es/redux.js");
/* harmony import */ var _reducers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reducers */ "./assets/redux/reducers/index.js");


/* harmony default export */ __webpack_exports__["default"] = (Object(redux__WEBPACK_IMPORTED_MODULE_0__["createStore"])(_reducers__WEBPACK_IMPORTED_MODULE_1__["default"], window.__REDUX_DEVTOOLS_EXTENSION__ && window.__REDUX_DEVTOOLS_EXTENSION__()));

/***/ }),

/***/ "./assets/routes/AddOns.js":
/*!*********************************!*\
  !*** ./assets/routes/AddOns.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../redux/actions */ "./assets/redux/actions.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






var AddOns =
/*#__PURE__*/
function (_Component) {
  _inherits(AddOns, _Component);

  function AddOns(props) {
    var _this;

    _classCallCheck(this, AddOns);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AddOns).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "updateUserDetail", function (e) {
      _this.props.updateAddons(e.target);
    });

    return _this;
  }

  _createClass(AddOns, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          additionalLuggageChecked = _this$props.additionalLuggageChecked,
          luggageDescription = _this$props.luggageDescription,
          oversizedLuggage = _this$props.oversizedLuggage,
          oversizedDescription = _this$props.oversizedDescription;
      return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "addons"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h1", null, "Add ons"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "content"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("strong", null, "Will you have extra luggage?")), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "radio-input"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "radio",
        name: "additionalLuggageChecked",
        value: "yes",
        checked: additionalLuggageChecked === 'yes',
        onChange: this.updateUserDetail
      }), "Yes"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "radio-input"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "radio",
        name: "additionalLuggageChecked",
        value: "no",
        checked: additionalLuggageChecked === 'no',
        onChange: this.updateUserDetail
      }), "No"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", {
        className: "small-text"
      }, "The additional cost for each extra luggage is \xA310 per item, per journey. This will be paid upon your arrival at the bus"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", null), additionalLuggageChecked === 'yes' && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Please let us know the amount of extra luggage you will have."), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("textarea", {
        name: "luggageDescription",
        placeholder: luggageDescription === '' ? 'Please enter brief description...' : undefined,
        defaultValue: luggageDescription,
        onBlur: this.updateUserDetail
      }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", null)), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("strong", null, "Will you have oversized baggage?")), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "radio-input"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "radio",
        name: "oversizedLuggage",
        value: "yes",
        checked: oversizedLuggage === 'yes',
        onChange: this.updateUserDetail
      }), "Yes"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "radio-input"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "radio",
        name: "oversizedLuggage",
        value: "no",
        checked: oversizedLuggage === 'no',
        onChange: this.updateUserDetail
      }), "No"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", null), oversizedLuggage === 'yes' && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Please let us know the amount of extra luggage you will have."), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("textarea", {
        name: "oversizedDescription",
        placeholder: oversizedDescription === '' ? 'Please enter brief description...' : undefined,
        defaultValue: oversizedDescription,
        onBlur: this.updateUserDetail
      }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", null))), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "* Luggage allowance is 1 large suitcase with a maximum weight of 23kg, or two medium suitcases per person with a maximum combined weight of 23kg"));
    }
  }]);

  return AddOns;
}(react__WEBPACK_IMPORTED_MODULE_0__["Component"]);

AddOns.propTypes = {
  context: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.object
};

var mapStateToProps = function mapStateToProps(state) {
  return _objectSpread({}, state.cart.addons);
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_2__["connect"])(mapStateToProps, {
  updateAddons: _redux_actions__WEBPACK_IMPORTED_MODULE_3__["updateAddons"]
})(AddOns));

/***/ }),

/***/ "./assets/routes/ChooseJourney.js":
/*!****************************************!*\
  !*** ./assets/routes/ChooseJourney.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_loader_spinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-loader-spinner */ "./node_modules/react-loader-spinner/index.js");
/* harmony import */ var react_loader_spinner__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_loader_spinner__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _config_endpoints__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../config/endpoints */ "./assets/config/endpoints.js");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_selectors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../redux/selectors */ "./assets/redux/selectors.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../redux/actions */ "./assets/redux/actions.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _components_ChooseTickets_NoResults__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../components/ChooseTickets/NoResults */ "./assets/components/ChooseTickets/NoResults.js");
/* harmony import */ var react_pose__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-pose */ "./node_modules/react-pose/dist/react-pose.es.js");
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react-toastify */ "./node_modules/react-toastify/esm/react-toastify.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }












var Container = react_pose__WEBPACK_IMPORTED_MODULE_9__["default"].div({
  enter: {
    staggerChildren: 50
  }
});
var AnimatedDiv = react_pose__WEBPACK_IMPORTED_MODULE_9__["default"].div({
  enter: {
    x: 0,
    opacity: 1
  },
  exit: {
    x: 25,
    opacity: 0
  }
});

var ChooseJourney =
/*#__PURE__*/
function (_Component) {
  _inherits(ChooseJourney, _Component);

  function ChooseJourney(props) {
    var _this;

    _classCallCheck(this, ChooseJourney);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ChooseJourney).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "formatDate", function (date) {
      return moment__WEBPACK_IMPORTED_MODULE_7___default()(date).format('DD-MM-YYYY');
    });

    _defineProperty(_assertThisInitialized(_this), "journeyList", function (journeys, direction) {
      var _this$props = _this.props,
          outbound = _this$props.outbound,
          inbound = _this$props.inbound;
      var items = [];
      var comparison = direction === 'outbound' ? outbound : inbound;

      var _loop = function _loop() {
        var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
            key = _Object$entries$_i[0],
            value = _Object$entries$_i[1];

        var selected = comparison && value.id === comparison.id;
        items.push(react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(AnimatedDiv, {
          className: "journey",
          key: key
        }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h2", {
          className: "time"
        }, value.departure_time, " - ", value.arrival_time), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("hr", null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
          className: "internal"
        }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
          className: "info"
        }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", {
          className: "duration"
        }, "1.30h"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Departure, to Arrival")), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("button", {
          className: "dark",
          disabled: selected,
          onClick: function onClick() {
            _this.props.addJourney(_objectSpread({}, value, {
              slug: key
            }), direction);

            if (direction === 'outbound' && _this.state.journeys.inbound) {
              window.scrollTo({
                top: 0,
                behavior: 'smooth'
              });

              _this.setState({
                showReturn: true
              });
            }
          }
        }, selected ? "Added" : "Add Journey"))));
      };

      for (var _i = 0, _Object$entries = Object.entries(journeys); _i < _Object$entries.length; _i++) {
        _loop();
      }

      return items;
    });

    _this.state = {
      journeys: null,
      loading: true,
      showReturn: false
    };
    return _this;
  }

  _createClass(ChooseJourney, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      var _this$props2 = this.props,
          journeyType = _this$props2.journeyType,
          depart = _this$props2.depart,
          departureDate = _this$props2.departureDate,
          returnDate = _this$props2.returnDate,
          totalSeats = _this$props2.totalSeats;
      var departFormatted = this.formatDate(departureDate);
      var returnFormatted = this.formatDate(returnDate);
      var body = {
        journeyType: journeyType,
        depart: depart,
        departFormatted: departFormatted,
        returnFormatted: returnFormatted,
        totalSeats: totalSeats
      };
      axios__WEBPACK_IMPORTED_MODULE_1___default.a.get(_config_endpoints__WEBPACK_IMPORTED_MODULE_3__["AVAILABLE_JOURNEYS"], {
        params: body
      }).then(function (response) {
        if (response.status !== 200) {
          console.log(response);
          react_toastify__WEBPACK_IMPORTED_MODULE_10__["toast"].error('An error occured fetching journeys');
          return;
        }

        _this2.setState({
          journeys: JSON.parse(response.data),
          loading: false
        });
      })["catch"](function (error) {
        react_toastify__WEBPACK_IMPORTED_MODULE_10__["toast"].error('An error occured fetching journeys');
        console.error('Fetch Journeys: ', error);

        _this2.setState({
          loading: false
        });
      });
    }
  }, {
    key: "render",
    value: function render() {
      return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "choose-journey"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h1", null, !this.state.showReturn ? 'Outbound Journey' : 'Inbound Journey'), this.state.loading && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_loader_spinner__WEBPACK_IMPORTED_MODULE_2___default.a, {
        type: "Oval",
        width: 50,
        height: 50,
        color: "#088584"
      }), !this.state.loading && this.state.journeys === null && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_ChooseTickets_NoResults__WEBPACK_IMPORTED_MODULE_8__["default"], null), this.state.journeys && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Container, null, this.state.journeys.outbound && !this.state.showReturn && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, this.journeyList(this.state.journeys.outbound, 'outbound')), this.state.journeys.inbound && this.state.showReturn && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, this.journeyList(this.state.journeys.inbound, 'inbound'))));
    }
  }]);

  return ChooseJourney;
}(react__WEBPACK_IMPORTED_MODULE_0__["Component"]);

var mapStateToProps = function mapStateToProps(state) {
  var _state$cart = state.cart,
      journeyType = _state$cart.journeyType,
      depart = _state$cart.depart,
      departureDate = _state$cart.departureDate,
      returnDate = _state$cart.returnDate,
      outbound = _state$cart.outbound,
      inbound = _state$cart.inbound;
  var totalSeats = Object(_redux_selectors__WEBPACK_IMPORTED_MODULE_5__["getTotalSeatsFromCart"])(state);
  return {
    journeyType: journeyType,
    depart: depart,
    departureDate: departureDate,
    returnDate: returnDate,
    totalSeats: totalSeats,
    outbound: outbound,
    inbound: inbound
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_4__["connect"])(mapStateToProps, {
  addJourney: _redux_actions__WEBPACK_IMPORTED_MODULE_6__["addJourney"]
})(ChooseJourney));

/***/ }),

/***/ "./assets/routes/ChooseTicket.js":
/*!***************************************!*\
  !*** ./assets/routes/ChooseTicket.js ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _config_endpoints__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../config/endpoints */ "./assets/config/endpoints.js");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../redux/actions */ "./assets/redux/actions.js");
/* harmony import */ var _components_ChooseTickets__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/ChooseTickets */ "./assets/components/ChooseTickets/index.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }








var ChooseTicket =
/*#__PURE__*/
function (_Component) {
  _inherits(ChooseTicket, _Component);

  function ChooseTicket(props) {
    var _this;

    _classCallCheck(this, ChooseTicket);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ChooseTicket).call(this, props));
    _this.now = new Date();
    return _this;
  }

  _createClass(ChooseTicket, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      axios__WEBPACK_IMPORTED_MODULE_1___default.a.get(_config_endpoints__WEBPACK_IMPORTED_MODULE_2__["ALL_TICKETS"]).then(function (response) {
        _this2.props.addTickets(JSON.parse(response.data));

        _this2.setState({
          loading: false
        });
      })["catch"](function (error) {
        console.warn('CATCH ERROR: ', error);
      });
    }
  }, {
    key: "render",
    value: function render() {
      return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "choose-ticket"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h1", null, "Choose Journey"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "content"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_ChooseTickets__WEBPACK_IMPORTED_MODULE_5__["JourneyTypeSelect"], null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_ChooseTickets__WEBPACK_IMPORTED_MODULE_5__["DirectionSelect"], null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_ChooseTickets__WEBPACK_IMPORTED_MODULE_5__["DateSelect"], null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_ChooseTickets__WEBPACK_IMPORTED_MODULE_5__["TicketList"], null)));
    }
  }]);

  return ChooseTicket;
}(react__WEBPACK_IMPORTED_MODULE_0__["Component"]);

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_3__["connect"])(null, {
  addTickets: _redux_actions__WEBPACK_IMPORTED_MODULE_4__["addTickets"]
})(ChooseTicket));

/***/ }),

/***/ "./assets/routes/Confirmation.js":
/*!***************************************!*\
  !*** ./assets/routes/Confirmation.js ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var Confirmation = function Confirmation() {
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "centered-container"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h1", null, "Thank you for your booking"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Deserunt aperiam, illum minima voluptatum qui amet. Eveniet suscipit nostrum eum vero tempora nam, tenetur, quasi porro nobis, impedit natus. Deleniti, ut."), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("br", null), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", {
    href: "https://www.nxdiscovrit.co.uk/",
    title: "National Express Xplore Dundee",
    className: "primary"
  }, "Back to Xplore Site"));
};

/* harmony default export */ __webpack_exports__["default"] = (Confirmation);

/***/ }),

/***/ "./assets/routes/Payment.js":
/*!**********************************!*\
  !*** ./assets/routes/Payment.js ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_loader_spinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-loader-spinner */ "./node_modules/react-loader-spinner/index.js");
/* harmony import */ var react_loader_spinner__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_loader_spinner__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-toastify */ "./node_modules/react-toastify/esm/react-toastify.js");
/* harmony import */ var _config_endpoints__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./../config/endpoints */ "./assets/config/endpoints.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../redux/actions */ "./assets/redux/actions.js");
/* harmony import */ var _redux_selectors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../redux/selectors */ "./assets/redux/selectors.js");
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










var Payment =
/*#__PURE__*/
function (_Component) {
  _inherits(Payment, _Component);

  function Payment(props) {
    var _this;

    _classCallCheck(this, Payment);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Payment).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "addBooking", function () {
      var _this$props$user = _this.props.user,
          name = _this$props$user.name,
          surname = _this$props$user.surname,
          email = _this$props$user.email,
          phoneNumber = _this$props$user.phoneNumber;
      var _this$props = _this.props,
          inCart = _this$props.inCart,
          addons = _this$props.addons,
          seats = _this$props.seats,
          price = _this$props.price;
      var outbound = _this.props.outbound !== null && _this.props.outbound.slug;
      var inbound = _this.props.inbound !== null && _this.props.inbound.slug;
      axios__WEBPACK_IMPORTED_MODULE_1___default.a.post(_config_endpoints__WEBPACK_IMPORTED_MODULE_5__["ADD_NEW_BOOKING"], {
        name: name,
        surname: surname,
        email: email,
        phoneNumber: phoneNumber,
        outbound: outbound,
        inbound: inbound,
        addons: addons,
        seats: seats,
        inCart: inCart,
        price: price
      }).then(function (response) {
        var bookingId = response.data;

        _this.props.addBooking(bookingId);

        _this.setState({
          loading: false
        });

        _this.redirectWorldPay();
      })["catch"](function (error) {
        react_toastify__WEBPACK_IMPORTED_MODULE_4__["toast"].error(error.response.data);
        console.error('Create booking:', error);

        _this.setState({
          loading: false
        });
      });
    });

    _defineProperty(_assertThisInitialized(_this), "redirectWorldPay", function () {
      var form = _this.formRef.current;
      form.submit();
    });

    _this.state = {
      loading: true
    };
    _this.formRef = react__WEBPACK_IMPORTED_MODULE_0___default.a.createRef();
    return _this;
  }

  _createClass(Payment, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.addBooking();
    }
  }, {
    key: "render",
    value: function render() {
      return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
        className: "choose-journey"
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_loader_spinner__WEBPACK_IMPORTED_MODULE_2__["Loader"], {
        type: "Oval",
        width: 50,
        height: 50,
        color: "#088584"
      }), this.props.bookingId !== null && react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h1", null, "Payment"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("form", {
        action: "https://secure-test.worldpay.com/wcc/purchase",
        method: "POST",
        ref: this.formRef
      }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "hidden",
        name: "testMode",
        value: "100"
      }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "hidden",
        name: "instId",
        value: "1357697"
      }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "hidden",
        name: "cartId",
        value: this.props.bookingId
      }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "hidden",
        name: "amount",
        value: this.props.price
      }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
        type: "hidden",
        name: "currency",
        value: "GBP"
      }))));
    }
  }]);

  return Payment;
}(react__WEBPACK_IMPORTED_MODULE_0__["Component"]);

var mapStateToProps = function mapStateToProps(state) {
  var _state$cart = state.cart,
      outbound = _state$cart.outbound,
      inbound = _state$cart.inbound,
      addons = _state$cart.addons,
      inCart = _state$cart.inCart;
  var seats = Object(_redux_selectors__WEBPACK_IMPORTED_MODULE_7__["getTotalSeatsFromCart"])(state);
  var price = Object(_redux_selectors__WEBPACK_IMPORTED_MODULE_7__["getTotalCostFromCart"])(state);
  return {
    bookingId: state.booking.bookingId,
    user: state.user,
    outbound: outbound,
    inbound: inbound,
    addons: addons,
    seats: seats,
    inCart: inCart,
    price: price
  };
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_3__["connect"])(mapStateToProps, {
  addBooking: _redux_actions__WEBPACK_IMPORTED_MODULE_6__["addBooking"]
})(Payment));

/***/ }),

/***/ "./assets/routes/YourDetails.js":
/*!**************************************!*\
  !*** ./assets/routes/YourDetails.js ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/es/index.js");
/* harmony import */ var _redux_actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../redux/actions */ "./assets/redux/actions.js");
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





var YourDetails = function YourDetails(_ref) {
  var updateUser = _ref.updateUser,
      name = _ref.name,
      surname = _ref.surname,
      email = _ref.email,
      phoneNumber = _ref.phoneNumber;
  return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment, null, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h1", null, "Your Details"), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "content"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div", {
    className: "your-details"
  }, react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
    type: "text",
    placeholder: "Name*",
    name: "name",
    defaultValue: name,
    required: true,
    onChange: function onChange(e) {
      return updateUser(e.target);
    }
  }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
    type: "text",
    placeholder: "Surname* ",
    name: "surname",
    defaultValue: surname,
    required: true,
    onChange: function onChange(e) {
      return updateUser(e.target);
    }
  }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
    type: "text",
    placeholder: "Email*",
    name: "email",
    defaultValue: email,
    required: true,
    onChange: function onChange(e) {
      return updateUser(e.target);
    }
  }), react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("input", {
    type: "text",
    placeholder: "Phone Number*",
    name: "phoneNumber",
    defaultValue: phoneNumber,
    required: true,
    onChange: function onChange(e) {
      return updateUser(e.target);
    }
  }))));
};

var mapStateToProps = function mapStateToProps(state) {
  return _objectSpread({}, state.user);
};

/* harmony default export */ __webpack_exports__["default"] = (Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["connect"])(mapStateToProps, {
  updateUser: _redux_actions__WEBPACK_IMPORTED_MODULE_2__["updateUser"]
})(YourDetails));

/***/ }),

/***/ "./assets/routes/index.js":
/*!********************************!*\
  !*** ./assets/routes/index.js ***!
  \********************************/
/*! exports provided: base, Routes, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "base", function() { return base; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Routes", function() { return Routes; });
/* harmony import */ var _AddOns__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AddOns */ "./assets/routes/AddOns.js");
/* harmony import */ var _ChooseTicket__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ChooseTicket */ "./assets/routes/ChooseTicket.js");
/* harmony import */ var _ChooseJourney__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ChooseJourney */ "./assets/routes/ChooseJourney.js");
/* harmony import */ var _Confirmation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Confirmation */ "./assets/routes/Confirmation.js");
/* harmony import */ var _Payment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Payment */ "./assets/routes/Payment.js");
/* harmony import */ var _YourDetails__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./YourDetails */ "./assets/routes/YourDetails.js");






var base = '/booking';
var Routes = [{
  path: "".concat(base),
  component: _ChooseTicket__WEBPACK_IMPORTED_MODULE_1__["default"],
  title: 'Choose Journey',
  isActive: function isActive(match, location) {
    return location.pathname === "".concat(base) || location.pathname === "".concat(base, "/") || location.pathname === "".concat(base, "/choose-journey");
  }
}, {
  path: "".concat(base, "/choose-journey"),
  component: _ChooseJourney__WEBPACK_IMPORTED_MODULE_2__["default"],
  title: 'Choose Journey',
  hide: true
}, {
  path: "".concat(base, "/add-ons"),
  component: _AddOns__WEBPACK_IMPORTED_MODULE_0__["default"],
  title: 'Add Ons'
}, {
  path: "".concat(base, "/your-details"),
  component: _YourDetails__WEBPACK_IMPORTED_MODULE_5__["default"],
  title: 'Your Details'
}, {
  path: "".concat(base, "/payment"),
  component: _Payment__WEBPACK_IMPORTED_MODULE_4__["default"],
  title: 'Payment'
}, {
  path: "".concat(base, "/confirmation"),
  component: _Confirmation__WEBPACK_IMPORTED_MODULE_3__["default"],
  title: 'Confirmation'
}];
/* harmony default export */ __webpack_exports__["default"] = (Routes);

/***/ }),

/***/ "./assets/styles/main.scss":
/*!*********************************!*\
  !*** ./assets/styles/main.scss ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/assertThisInitialized.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/assertThisInitialized.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

module.exports = _assertThisInitialized;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/defineProperty.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/defineProperty.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

module.exports = _defineProperty;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _assertThisInitialized; });
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/extends.js":
/*!************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/extends.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _extends; });
function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/inheritsLoose.js":
/*!******************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/inheritsLoose.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _inheritsLoose; });
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _objectWithoutPropertiesLoose; });
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/extends.js":
/*!********************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/extends.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _extends() {
  module.exports = _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

module.exports = _extends;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/inheritsLoose.js":
/*!**************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/inheritsLoose.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}

module.exports = _inheritsLoose;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/interopRequireDefault.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    "default": obj
  };
}

module.exports = _interopRequireDefault;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/interopRequireWildcard.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/interopRequireWildcard.js ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _interopRequireWildcard(obj) {
  if (obj && obj.__esModule) {
    return obj;
  } else {
    var newObj = {};

    if (obj != null) {
      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

          if (desc.get || desc.set) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj["default"] = obj;
    return newObj;
  }
}

module.exports = _interopRequireWildcard;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/objectWithoutPropertiesLoose.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/objectWithoutPropertiesLoose.js ***!
  \*****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

module.exports = _objectWithoutPropertiesLoose;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/taggedTemplateLiteralLoose.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/taggedTemplateLiteralLoose.js ***!
  \***************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _taggedTemplateLiteralLoose(strings, raw) {
  if (!raw) {
    raw = strings.slice(0);
  }

  strings.raw = raw;
  return strings;
}

module.exports = _taggedTemplateLiteralLoose;

/***/ }),

/***/ "./node_modules/@emotion/is-prop-valid/dist/is-prop-valid.browser.esm.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@emotion/is-prop-valid/dist/is-prop-valid.browser.esm.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/@emotion/memoize/dist/memoize.browser.esm.js");


var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|default|defer|dir|disabled|download|draggable|encType|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|itemProp|itemScope|itemType|itemID|itemRef|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

var index = Object(_emotion_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function (prop) {
  return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
  /* o */
  && prop.charCodeAt(1) === 110
  /* n */
  && prop.charCodeAt(2) < 91;
}
/* Z+1 */
);

/* harmony default export */ __webpack_exports__["default"] = (index);


/***/ }),

/***/ "./node_modules/@emotion/memoize/dist/memoize.browser.esm.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@emotion/memoize/dist/memoize.browser.esm.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function memoize(fn) {
  var cache = {};
  return function (arg) {
    if (cache[arg] === undefined) cache[arg] = fn(arg);
    return cache[arg];
  };
}

/* harmony default export */ __webpack_exports__["default"] = (memoize);


/***/ }),

/***/ "./node_modules/@fortawesome/fontawesome-svg-core/index.es.js":
/*!********************************************************************!*\
  !*** ./node_modules/@fortawesome/fontawesome-svg-core/index.es.js ***!
  \********************************************************************/
/*! exports provided: icon, noAuto, config, toHtml, layer, text, counter, library, dom, parse, findIconDefinition */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(global, setImmediate) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "icon", function() { return icon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "noAuto", function() { return noAuto; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "config", function() { return config; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toHtml", function() { return toHtml; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "layer", function() { return layer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "text", function() { return text; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "counter", function() { return counter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "library", function() { return library; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dom", function() { return dom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parse", function() { return parse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findIconDefinition", function() { return findIconDefinition; });
function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);

    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
      }));
    }

    ownKeys.forEach(function (key) {
      _defineProperty(target, key, source[key]);
    });
  }

  return target;
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

var noop = function noop() {};

var _WINDOW = {};
var _DOCUMENT = {};
var _MUTATION_OBSERVER = null;
var _PERFORMANCE = {
  mark: noop,
  measure: noop
};

try {
  if (typeof window !== 'undefined') _WINDOW = window;
  if (typeof document !== 'undefined') _DOCUMENT = document;
  if (typeof MutationObserver !== 'undefined') _MUTATION_OBSERVER = MutationObserver;
  if (typeof performance !== 'undefined') _PERFORMANCE = performance;
} catch (e) {}

var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;

var WINDOW = _WINDOW;
var DOCUMENT = _DOCUMENT;
var MUTATION_OBSERVER = _MUTATION_OBSERVER;
var PERFORMANCE = _PERFORMANCE;
var IS_BROWSER = !!WINDOW.document;
var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
var UNITS_IN_GRID = 16;
var DEFAULT_FAMILY_PREFIX = 'fa';
var DEFAULT_REPLACEMENT_CLASS = 'svg-inline--fa';
var DATA_FA_I2SVG = 'data-fa-i2svg';
var DATA_FA_PSEUDO_ELEMENT = 'data-fa-pseudo-element';
var DATA_FA_PSEUDO_ELEMENT_PENDING = 'data-fa-pseudo-element-pending';
var DATA_PREFIX = 'data-prefix';
var DATA_ICON = 'data-icon';
var HTML_CLASS_I2SVG_BASE_CLASS = 'fontawesome-i2svg';
var MUTATION_APPROACH_ASYNC = 'async';
var TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS = ['HTML', 'HEAD', 'STYLE', 'SCRIPT'];
var PRODUCTION = function () {
  try {
    return "development" === 'production';
  } catch (e) {
    return false;
  }
}();
var PREFIX_TO_STYLE = {
  'fas': 'solid',
  'far': 'regular',
  'fal': 'light',
  'fab': 'brands',
  'fa': 'solid'
};
var STYLE_TO_PREFIX = {
  'solid': 'fas',
  'regular': 'far',
  'light': 'fal',
  'brands': 'fab'
};
var LAYERS_TEXT_CLASSNAME = 'fa-layers-text';
var FONT_FAMILY_PATTERN = /Font Awesome 5 (Solid|Regular|Light|Brands|Free|Pro)/;
var FONT_WEIGHT_TO_PREFIX = {
  '900': 'fas',
  '400': 'far',
  'normal': 'far',
  '300': 'fal'
};
var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
var ATTRIBUTES_WATCHED_FOR_MUTATION = ['class', 'data-prefix', 'data-icon', 'data-fa-transform', 'data-fa-mask'];
var RESERVED_CLASSES = ['xs', 'sm', 'lg', 'fw', 'ul', 'li', 'border', 'pull-left', 'pull-right', 'spin', 'pulse', 'rotate-90', 'rotate-180', 'rotate-270', 'flip-horizontal', 'flip-vertical', 'flip-both', 'stack', 'stack-1x', 'stack-2x', 'inverse', 'layers', 'layers-text', 'layers-counter'].concat(oneToTen.map(function (n) {
  return "".concat(n, "x");
})).concat(oneToTwenty.map(function (n) {
  return "w-".concat(n);
}));

var initial = WINDOW.FontAwesomeConfig || {};

function getAttrConfig(attr) {
  var element = DOCUMENT.querySelector('script[' + attr + ']');

  if (element) {
    return element.getAttribute(attr);
  }
}

function coerce(val) {
  // Getting an empty string will occur if the attribute is set on the HTML tag but without a value
  // We'll assume that this is an indication that it should be toggled to true
  // For example <script data-search-pseudo-elements src="..."></script>
  if (val === '') return true;
  if (val === 'false') return false;
  if (val === 'true') return true;
  return val;
}

if (DOCUMENT && typeof DOCUMENT.querySelector === 'function') {
  var attrs = [['data-family-prefix', 'familyPrefix'], ['data-replacement-class', 'replacementClass'], ['data-auto-replace-svg', 'autoReplaceSvg'], ['data-auto-add-css', 'autoAddCss'], ['data-auto-a11y', 'autoA11y'], ['data-search-pseudo-elements', 'searchPseudoElements'], ['data-observe-mutations', 'observeMutations'], ['data-mutate-approach', 'mutateApproach'], ['data-keep-original-source', 'keepOriginalSource'], ['data-measure-performance', 'measurePerformance'], ['data-show-missing-icons', 'showMissingIcons']];
  attrs.forEach(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        attr = _ref2[0],
        key = _ref2[1];

    var val = coerce(getAttrConfig(attr));

    if (val !== undefined && val !== null) {
      initial[key] = val;
    }
  });
}

var _default = {
  familyPrefix: DEFAULT_FAMILY_PREFIX,
  replacementClass: DEFAULT_REPLACEMENT_CLASS,
  autoReplaceSvg: true,
  autoAddCss: true,
  autoA11y: true,
  searchPseudoElements: false,
  observeMutations: true,
  mutateApproach: 'async',
  keepOriginalSource: true,
  measurePerformance: false,
  showMissingIcons: true
};

var _config = _objectSpread({}, _default, initial);

if (!_config.autoReplaceSvg) _config.observeMutations = false;

var config = _objectSpread({}, _config);

WINDOW.FontAwesomeConfig = config;

var w = WINDOW || {};
if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
var namespace = w[NAMESPACE_IDENTIFIER];

var functions = [];

var listener = function listener() {
  DOCUMENT.removeEventListener('DOMContentLoaded', listener);
  loaded = 1;
  functions.map(function (fn) {
    return fn();
  });
};

var loaded = false;

if (IS_DOM) {
  loaded = (DOCUMENT.documentElement.doScroll ? /^loaded|^c/ : /^loaded|^i|^c/).test(DOCUMENT.readyState);
  if (!loaded) DOCUMENT.addEventListener('DOMContentLoaded', listener);
}

function domready (fn) {
  if (!IS_DOM) return;
  loaded ? setTimeout(fn, 0) : functions.push(fn);
}

var PENDING = 'pending';
var SETTLED = 'settled';
var FULFILLED = 'fulfilled';
var REJECTED = 'rejected';

var NOOP = function NOOP() {};

var isNode = typeof global !== 'undefined' && typeof global.process !== 'undefined' && typeof global.process.emit === 'function';
var asyncSetTimer = typeof setImmediate === 'undefined' ? setTimeout : setImmediate;
var asyncQueue = [];
var asyncTimer;

function asyncFlush() {
  // run promise callbacks
  for (var i = 0; i < asyncQueue.length; i++) {
    asyncQueue[i][0](asyncQueue[i][1]);
  } // reset async asyncQueue


  asyncQueue = [];
  asyncTimer = false;
}

function asyncCall(callback, arg) {
  asyncQueue.push([callback, arg]);

  if (!asyncTimer) {
    asyncTimer = true;
    asyncSetTimer(asyncFlush, 0);
  }
}

function invokeResolver(resolver, promise) {
  function resolvePromise(value) {
    resolve(promise, value);
  }

  function rejectPromise(reason) {
    reject(promise, reason);
  }

  try {
    resolver(resolvePromise, rejectPromise);
  } catch (e) {
    rejectPromise(e);
  }
}

function invokeCallback(subscriber) {
  var owner = subscriber.owner;
  var settled = owner._state;
  var value = owner._data;
  var callback = subscriber[settled];
  var promise = subscriber.then;

  if (typeof callback === 'function') {
    settled = FULFILLED;

    try {
      value = callback(value);
    } catch (e) {
      reject(promise, e);
    }
  }

  if (!handleThenable(promise, value)) {
    if (settled === FULFILLED) {
      resolve(promise, value);
    }

    if (settled === REJECTED) {
      reject(promise, value);
    }
  }
}

function handleThenable(promise, value) {
  var resolved;

  try {
    if (promise === value) {
      throw new TypeError('A promises callback cannot return that same promise.');
    }

    if (value && (typeof value === 'function' || _typeof(value) === 'object')) {
      // then should be retrieved only once
      var then = value.then;

      if (typeof then === 'function') {
        then.call(value, function (val) {
          if (!resolved) {
            resolved = true;

            if (value === val) {
              fulfill(promise, val);
            } else {
              resolve(promise, val);
            }
          }
        }, function (reason) {
          if (!resolved) {
            resolved = true;
            reject(promise, reason);
          }
        });
        return true;
      }
    }
  } catch (e) {
    if (!resolved) {
      reject(promise, e);
    }

    return true;
  }

  return false;
}

function resolve(promise, value) {
  if (promise === value || !handleThenable(promise, value)) {
    fulfill(promise, value);
  }
}

function fulfill(promise, value) {
  if (promise._state === PENDING) {
    promise._state = SETTLED;
    promise._data = value;
    asyncCall(publishFulfillment, promise);
  }
}

function reject(promise, reason) {
  if (promise._state === PENDING) {
    promise._state = SETTLED;
    promise._data = reason;
    asyncCall(publishRejection, promise);
  }
}

function publish(promise) {
  promise._then = promise._then.forEach(invokeCallback);
}

function publishFulfillment(promise) {
  promise._state = FULFILLED;
  publish(promise);
}

function publishRejection(promise) {
  promise._state = REJECTED;
  publish(promise);

  if (!promise._handled && isNode) {
    global.process.emit('unhandledRejection', promise._data, promise);
  }
}

function notifyRejectionHandled(promise) {
  global.process.emit('rejectionHandled', promise);
}
/**
 * @class
 */


function P(resolver) {
  if (typeof resolver !== 'function') {
    throw new TypeError('Promise resolver ' + resolver + ' is not a function');
  }

  if (this instanceof P === false) {
    throw new TypeError('Failed to construct \'Promise\': Please use the \'new\' operator, this object constructor cannot be called as a function.');
  }

  this._then = [];
  invokeResolver(resolver, this);
}

P.prototype = {
  constructor: P,
  _state: PENDING,
  _then: null,
  _data: undefined,
  _handled: false,
  then: function then(onFulfillment, onRejection) {
    var subscriber = {
      owner: this,
      then: new this.constructor(NOOP),
      fulfilled: onFulfillment,
      rejected: onRejection
    };

    if ((onRejection || onFulfillment) && !this._handled) {
      this._handled = true;

      if (this._state === REJECTED && isNode) {
        asyncCall(notifyRejectionHandled, this);
      }
    }

    if (this._state === FULFILLED || this._state === REJECTED) {
      // already resolved, call callback async
      asyncCall(invokeCallback, subscriber);
    } else {
      // subscribe
      this._then.push(subscriber);
    }

    return subscriber.then;
  },
  catch: function _catch(onRejection) {
    return this.then(null, onRejection);
  }
};

P.all = function (promises) {
  if (!Array.isArray(promises)) {
    throw new TypeError('You must pass an array to Promise.all().');
  }

  return new P(function (resolve, reject) {
    var results = [];
    var remaining = 0;

    function resolver(index) {
      remaining++;
      return function (value) {
        results[index] = value;

        if (! --remaining) {
          resolve(results);
        }
      };
    }

    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];

      if (promise && typeof promise.then === 'function') {
        promise.then(resolver(i), reject);
      } else {
        results[i] = promise;
      }
    }

    if (!remaining) {
      resolve(results);
    }
  });
};

P.race = function (promises) {
  if (!Array.isArray(promises)) {
    throw new TypeError('You must pass an array to Promise.race().');
  }

  return new P(function (resolve, reject) {
    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];

      if (promise && typeof promise.then === 'function') {
        promise.then(resolve, reject);
      } else {
        resolve(promise);
      }
    }
  });
};

P.resolve = function (value) {
  if (value && _typeof(value) === 'object' && value.constructor === P) {
    return value;
  }

  return new P(function (resolve) {
    resolve(value);
  });
};

P.reject = function (reason) {
  return new P(function (resolve, reject) {
    reject(reason);
  });
};

var picked = typeof Promise === 'function' ? Promise : P;

var d = UNITS_IN_GRID;
var meaninglessTransform = {
  size: 16,
  x: 0,
  y: 0,
  rotate: 0,
  flipX: false,
  flipY: false
};

function isReserved(name) {
  return ~RESERVED_CLASSES.indexOf(name);
}
function insertCss(css) {
  if (!css || !IS_DOM) {
    return;
  }

  var style = DOCUMENT.createElement('style');
  style.setAttribute('type', 'text/css');
  style.innerHTML = css;
  var headChildren = DOCUMENT.head.childNodes;
  var beforeChild = null;

  for (var i = headChildren.length - 1; i > -1; i--) {
    var child = headChildren[i];
    var tagName = (child.tagName || '').toUpperCase();

    if (['STYLE', 'LINK'].indexOf(tagName) > -1) {
      beforeChild = child;
    }
  }

  DOCUMENT.head.insertBefore(style, beforeChild);
  return css;
}
var idPool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
function nextUniqueId() {
  var size = 12;
  var id = '';

  while (size-- > 0) {
    id += idPool[Math.random() * 62 | 0];
  }

  return id;
}
function toArray(obj) {
  var array = [];

  for (var i = (obj || []).length >>> 0; i--;) {
    array[i] = obj[i];
  }

  return array;
}
function classArray(node) {
  if (node.classList) {
    return toArray(node.classList);
  } else {
    return (node.getAttribute('class') || '').split(' ').filter(function (i) {
      return i;
    });
  }
}
function getIconName(familyPrefix, cls) {
  var parts = cls.split('-');
  var prefix = parts[0];
  var iconName = parts.slice(1).join('-');

  if (prefix === familyPrefix && iconName !== '' && !isReserved(iconName)) {
    return iconName;
  } else {
    return null;
  }
}
function htmlEscape(str) {
  return "".concat(str).replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
}
function joinAttributes(attributes) {
  return Object.keys(attributes || {}).reduce(function (acc, attributeName) {
    return acc + "".concat(attributeName, "=\"").concat(htmlEscape(attributes[attributeName]), "\" ");
  }, '').trim();
}
function joinStyles(styles) {
  return Object.keys(styles || {}).reduce(function (acc, styleName) {
    return acc + "".concat(styleName, ": ").concat(styles[styleName], ";");
  }, '');
}
function transformIsMeaningful(transform) {
  return transform.size !== meaninglessTransform.size || transform.x !== meaninglessTransform.x || transform.y !== meaninglessTransform.y || transform.rotate !== meaninglessTransform.rotate || transform.flipX || transform.flipY;
}
function transformForSvg(_ref) {
  var transform = _ref.transform,
      containerWidth = _ref.containerWidth,
      iconWidth = _ref.iconWidth;
  var outer = {
    transform: "translate(".concat(containerWidth / 2, " 256)")
  };
  var innerTranslate = "translate(".concat(transform.x * 32, ", ").concat(transform.y * 32, ") ");
  var innerScale = "scale(".concat(transform.size / 16 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / 16 * (transform.flipY ? -1 : 1), ") ");
  var innerRotate = "rotate(".concat(transform.rotate, " 0 0)");
  var inner = {
    transform: "".concat(innerTranslate, " ").concat(innerScale, " ").concat(innerRotate)
  };
  var path = {
    transform: "translate(".concat(iconWidth / 2 * -1, " -256)")
  };
  return {
    outer: outer,
    inner: inner,
    path: path
  };
}
function transformForCss(_ref2) {
  var transform = _ref2.transform,
      _ref2$width = _ref2.width,
      width = _ref2$width === void 0 ? UNITS_IN_GRID : _ref2$width,
      _ref2$height = _ref2.height,
      height = _ref2$height === void 0 ? UNITS_IN_GRID : _ref2$height,
      _ref2$startCentered = _ref2.startCentered,
      startCentered = _ref2$startCentered === void 0 ? false : _ref2$startCentered;
  var val = '';

  if (startCentered && IS_IE) {
    val += "translate(".concat(transform.x / d - width / 2, "em, ").concat(transform.y / d - height / 2, "em) ");
  } else if (startCentered) {
    val += "translate(calc(-50% + ".concat(transform.x / d, "em), calc(-50% + ").concat(transform.y / d, "em)) ");
  } else {
    val += "translate(".concat(transform.x / d, "em, ").concat(transform.y / d, "em) ");
  }

  val += "scale(".concat(transform.size / d * (transform.flipX ? -1 : 1), ", ").concat(transform.size / d * (transform.flipY ? -1 : 1), ") ");
  val += "rotate(".concat(transform.rotate, "deg) ");
  return val;
}

var ALL_SPACE = {
  x: 0,
  y: 0,
  width: '100%',
  height: '100%'
};
function makeIconMasking (_ref) {
  var children = _ref.children,
      attributes = _ref.attributes,
      main = _ref.main,
      mask = _ref.mask,
      transform = _ref.transform;
  var mainWidth = main.width,
      mainPath = main.icon;
  var maskWidth = mask.width,
      maskPath = mask.icon;
  var trans = transformForSvg({
    transform: transform,
    containerWidth: maskWidth,
    iconWidth: mainWidth
  });
  var maskRect = {
    tag: 'rect',
    attributes: _objectSpread({}, ALL_SPACE, {
      fill: 'white'
    })
  };
  var maskInnerGroup = {
    tag: 'g',
    attributes: _objectSpread({}, trans.inner),
    children: [{
      tag: 'path',
      attributes: _objectSpread({}, mainPath.attributes, trans.path, {
        fill: 'black'
      })
    }]
  };
  var maskOuterGroup = {
    tag: 'g',
    attributes: _objectSpread({}, trans.outer),
    children: [maskInnerGroup]
  };
  var maskId = "mask-".concat(nextUniqueId());
  var clipId = "clip-".concat(nextUniqueId());
  var maskTag = {
    tag: 'mask',
    attributes: _objectSpread({}, ALL_SPACE, {
      id: maskId,
      maskUnits: 'userSpaceOnUse',
      maskContentUnits: 'userSpaceOnUse'
    }),
    children: [maskRect, maskOuterGroup]
  };
  var defs = {
    tag: 'defs',
    children: [{
      tag: 'clipPath',
      attributes: {
        id: clipId
      },
      children: [maskPath]
    }, maskTag]
  };
  children.push(defs, {
    tag: 'rect',
    attributes: _objectSpread({
      fill: 'currentColor',
      'clip-path': "url(#".concat(clipId, ")"),
      mask: "url(#".concat(maskId, ")")
    }, ALL_SPACE)
  });
  return {
    children: children,
    attributes: attributes
  };
}

function makeIconStandard (_ref) {
  var children = _ref.children,
      attributes = _ref.attributes,
      main = _ref.main,
      transform = _ref.transform,
      styles = _ref.styles;
  var styleString = joinStyles(styles);

  if (styleString.length > 0) {
    attributes['style'] = styleString;
  }

  if (transformIsMeaningful(transform)) {
    var trans = transformForSvg({
      transform: transform,
      containerWidth: main.width,
      iconWidth: main.width
    });
    children.push({
      tag: 'g',
      attributes: _objectSpread({}, trans.outer),
      children: [{
        tag: 'g',
        attributes: _objectSpread({}, trans.inner),
        children: [{
          tag: main.icon.tag,
          children: main.icon.children,
          attributes: _objectSpread({}, main.icon.attributes, trans.path)
        }]
      }]
    });
  } else {
    children.push(main.icon);
  }

  return {
    children: children,
    attributes: attributes
  };
}

function asIcon (_ref) {
  var children = _ref.children,
      main = _ref.main,
      mask = _ref.mask,
      attributes = _ref.attributes,
      styles = _ref.styles,
      transform = _ref.transform;

  if (transformIsMeaningful(transform) && main.found && !mask.found) {
    var width = main.width,
        height = main.height;
    var offset = {
      x: width / height / 2,
      y: 0.5
    };
    attributes['style'] = joinStyles(_objectSpread({}, styles, {
      'transform-origin': "".concat(offset.x + transform.x / 16, "em ").concat(offset.y + transform.y / 16, "em")
    }));
  }

  return [{
    tag: 'svg',
    attributes: attributes,
    children: children
  }];
}

function asSymbol (_ref) {
  var prefix = _ref.prefix,
      iconName = _ref.iconName,
      children = _ref.children,
      attributes = _ref.attributes,
      symbol = _ref.symbol;
  var id = symbol === true ? "".concat(prefix, "-").concat(config.familyPrefix, "-").concat(iconName) : symbol;
  return [{
    tag: 'svg',
    attributes: {
      style: 'display: none;'
    },
    children: [{
      tag: 'symbol',
      attributes: _objectSpread({}, attributes, {
        id: id
      }),
      children: children
    }]
  }];
}

function makeInlineSvgAbstract(params) {
  var _params$icons = params.icons,
      main = _params$icons.main,
      mask = _params$icons.mask,
      prefix = params.prefix,
      iconName = params.iconName,
      transform = params.transform,
      symbol = params.symbol,
      title = params.title,
      extra = params.extra,
      _params$watchable = params.watchable,
      watchable = _params$watchable === void 0 ? false : _params$watchable;

  var _ref = mask.found ? mask : main,
      width = _ref.width,
      height = _ref.height;

  var widthClass = "fa-w-".concat(Math.ceil(width / height * 16));
  var attrClass = [config.replacementClass, iconName ? "".concat(config.familyPrefix, "-").concat(iconName) : '', widthClass].filter(function (c) {
    return extra.classes.indexOf(c) === -1;
  }).concat(extra.classes).join(' ');
  var content = {
    children: [],
    attributes: _objectSpread({}, extra.attributes, {
      'data-prefix': prefix,
      'data-icon': iconName,
      'class': attrClass,
      'role': extra.attributes.role || 'img',
      'xmlns': 'http://www.w3.org/2000/svg',
      'viewBox': "0 0 ".concat(width, " ").concat(height)
    })
  };

  if (watchable) {
    content.attributes[DATA_FA_I2SVG] = '';
  }

  if (title) content.children.push({
    tag: 'title',
    attributes: {
      id: content.attributes['aria-labelledby'] || "title-".concat(nextUniqueId())
    },
    children: [title]
  });

  var args = _objectSpread({}, content, {
    prefix: prefix,
    iconName: iconName,
    main: main,
    mask: mask,
    transform: transform,
    symbol: symbol,
    styles: extra.styles
  });

  var _ref2 = mask.found && main.found ? makeIconMasking(args) : makeIconStandard(args),
      children = _ref2.children,
      attributes = _ref2.attributes;

  args.children = children;
  args.attributes = attributes;

  if (symbol) {
    return asSymbol(args);
  } else {
    return asIcon(args);
  }
}
function makeLayersTextAbstract(params) {
  var content = params.content,
      width = params.width,
      height = params.height,
      transform = params.transform,
      title = params.title,
      extra = params.extra,
      _params$watchable2 = params.watchable,
      watchable = _params$watchable2 === void 0 ? false : _params$watchable2;

  var attributes = _objectSpread({}, extra.attributes, title ? {
    'title': title
  } : {}, {
    'class': extra.classes.join(' ')
  });

  if (watchable) {
    attributes[DATA_FA_I2SVG] = '';
  }

  var styles = _objectSpread({}, extra.styles);

  if (transformIsMeaningful(transform)) {
    styles['transform'] = transformForCss({
      transform: transform,
      startCentered: true,
      width: width,
      height: height
    });
    styles['-webkit-transform'] = styles['transform'];
  }

  var styleString = joinStyles(styles);

  if (styleString.length > 0) {
    attributes['style'] = styleString;
  }

  var val = [];
  val.push({
    tag: 'span',
    attributes: attributes,
    children: [content]
  });

  if (title) {
    val.push({
      tag: 'span',
      attributes: {
        class: 'sr-only'
      },
      children: [title]
    });
  }

  return val;
}
function makeLayersCounterAbstract(params) {
  var content = params.content,
      title = params.title,
      extra = params.extra;

  var attributes = _objectSpread({}, extra.attributes, title ? {
    'title': title
  } : {}, {
    'class': extra.classes.join(' ')
  });

  var styleString = joinStyles(extra.styles);

  if (styleString.length > 0) {
    attributes['style'] = styleString;
  }

  var val = [];
  val.push({
    tag: 'span',
    attributes: attributes,
    children: [content]
  });

  if (title) {
    val.push({
      tag: 'span',
      attributes: {
        class: 'sr-only'
      },
      children: [title]
    });
  }

  return val;
}

var noop$1 = function noop() {};

var p = config.measurePerformance && PERFORMANCE && PERFORMANCE.mark && PERFORMANCE.measure ? PERFORMANCE : {
  mark: noop$1,
  measure: noop$1
};
var preamble = "FA \"5.9.0\"";

var begin = function begin(name) {
  p.mark("".concat(preamble, " ").concat(name, " begins"));
  return function () {
    return end(name);
  };
};

var end = function end(name) {
  p.mark("".concat(preamble, " ").concat(name, " ends"));
  p.measure("".concat(preamble, " ").concat(name), "".concat(preamble, " ").concat(name, " begins"), "".concat(preamble, " ").concat(name, " ends"));
};

var perf = {
  begin: begin,
  end: end
};

/**
 * Internal helper to bind a function known to have 4 arguments
 * to a given context.
 */

var bindInternal4 = function bindInternal4(func, thisContext) {
  return function (a, b, c, d) {
    return func.call(thisContext, a, b, c, d);
  };
};

/**
 * # Reduce
 *
 * A fast object `.reduce()` implementation.
 *
 * @param  {Object}   subject      The object to reduce over.
 * @param  {Function} fn           The reducer function.
 * @param  {mixed}    initialValue The initial value for the reducer, defaults to subject[0].
 * @param  {Object}   thisContext  The context for the reducer.
 * @return {mixed}                 The final result.
 */


var reduce = function fastReduceObject(subject, fn, initialValue, thisContext) {
  var keys = Object.keys(subject),
      length = keys.length,
      iterator = thisContext !== undefined ? bindInternal4(fn, thisContext) : fn,
      i,
      key,
      result;

  if (initialValue === undefined) {
    i = 1;
    result = subject[keys[0]];
  } else {
    i = 0;
    result = initialValue;
  }

  for (; i < length; i++) {
    key = keys[i];
    result = iterator(result, subject[key], key, subject);
  }

  return result;
};

function toHex(unicode) {
  var result = '';

  for (var i = 0; i < unicode.length; i++) {
    var hex = unicode.charCodeAt(i).toString(16);
    result += ('000' + hex).slice(-4);
  }

  return result;
}

function defineIcons(prefix, icons) {
  var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
  var normalized = Object.keys(icons).reduce(function (acc, iconName) {
    var icon = icons[iconName];
    var expanded = !!icon.icon;

    if (expanded) {
      acc[icon.iconName] = icon.icon;
    } else {
      acc[iconName] = icon;
    }

    return acc;
  }, {});

  if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
    namespace.hooks.addPack(prefix, normalized);
  } else {
    namespace.styles[prefix] = _objectSpread({}, namespace.styles[prefix] || {}, normalized);
  }
  /**
   * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
   * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
   * for `fas` so we'll easy the upgrade process for our users by automatically defining
   * this as well.
   */


  if (prefix === 'fas') {
    defineIcons('fa', icons);
  }
}

var styles = namespace.styles,
    shims = namespace.shims;
var _byUnicode = {};
var _byLigature = {};
var _byOldName = {};
var build = function build() {
  var lookup = function lookup(reducer) {
    return reduce(styles, function (o, style, prefix) {
      o[prefix] = reduce(style, reducer, {});
      return o;
    }, {});
  };

  _byUnicode = lookup(function (acc, icon, iconName) {
    if (icon[3]) {
      acc[icon[3]] = iconName;
    }

    return acc;
  });
  _byLigature = lookup(function (acc, icon, iconName) {
    var ligatures = icon[2];
    acc[iconName] = iconName;
    ligatures.forEach(function (ligature) {
      acc[ligature] = iconName;
    });
    return acc;
  });
  var hasRegular = 'far' in styles;
  _byOldName = reduce(shims, function (acc, shim) {
    var oldName = shim[0];
    var prefix = shim[1];
    var iconName = shim[2];

    if (prefix === 'far' && !hasRegular) {
      prefix = 'fas';
    }

    acc[oldName] = {
      prefix: prefix,
      iconName: iconName
    };
    return acc;
  }, {});
};
build();
function byUnicode(prefix, unicode) {
  return (_byUnicode[prefix] || {})[unicode];
}
function byLigature(prefix, ligature) {
  return (_byLigature[prefix] || {})[ligature];
}
function byOldName(name) {
  return _byOldName[name] || {
    prefix: null,
    iconName: null
  };
}

var styles$1 = namespace.styles;
var emptyCanonicalIcon = function emptyCanonicalIcon() {
  return {
    prefix: null,
    iconName: null,
    rest: []
  };
};
function getCanonicalIcon(values) {
  return values.reduce(function (acc, cls) {
    var iconName = getIconName(config.familyPrefix, cls);

    if (styles$1[cls]) {
      acc.prefix = cls;
    } else if (config.autoFetchSvg && ['fas', 'far', 'fal', 'fab', 'fa'].indexOf(cls) > -1) {
      acc.prefix = cls;
    } else if (iconName) {
      var shim = acc.prefix === 'fa' ? byOldName(iconName) : {};
      acc.iconName = shim.iconName || iconName;
      acc.prefix = shim.prefix || acc.prefix;
    } else if (cls !== config.replacementClass && cls.indexOf('fa-w-') !== 0) {
      acc.rest.push(cls);
    }

    return acc;
  }, emptyCanonicalIcon());
}
function iconFromMapping(mapping, prefix, iconName) {
  if (mapping && mapping[prefix] && mapping[prefix][iconName]) {
    return {
      prefix: prefix,
      iconName: iconName,
      icon: mapping[prefix][iconName]
    };
  }
}

function toHtml(abstractNodes) {
  var tag = abstractNodes.tag,
      _abstractNodes$attrib = abstractNodes.attributes,
      attributes = _abstractNodes$attrib === void 0 ? {} : _abstractNodes$attrib,
      _abstractNodes$childr = abstractNodes.children,
      children = _abstractNodes$childr === void 0 ? [] : _abstractNodes$childr;

  if (typeof abstractNodes === 'string') {
    return htmlEscape(abstractNodes);
  } else {
    return "<".concat(tag, " ").concat(joinAttributes(attributes), ">").concat(children.map(toHtml).join(''), "</").concat(tag, ">");
  }
}

var noop$2 = function noop() {};

function isWatched(node) {
  var i2svg = node.getAttribute ? node.getAttribute(DATA_FA_I2SVG) : null;
  return typeof i2svg === 'string';
}

function getMutator() {
  if (config.autoReplaceSvg === true) {
    return mutators.replace;
  }

  var mutator = mutators[config.autoReplaceSvg];
  return mutator || mutators.replace;
}

var mutators = {
  replace: function replace(mutation) {
    var node = mutation[0];
    var abstract = mutation[1];
    var newOuterHTML = abstract.map(function (a) {
      return toHtml(a);
    }).join('\n');

    if (node.parentNode && node.outerHTML) {
      node.outerHTML = newOuterHTML + (config.keepOriginalSource && node.tagName.toLowerCase() !== 'svg' ? "<!-- ".concat(node.outerHTML, " -->") : '');
    } else if (node.parentNode) {
      var newNode = document.createElement('span');
      node.parentNode.replaceChild(newNode, node);
      newNode.outerHTML = newOuterHTML;
    }
  },
  nest: function nest(mutation) {
    var node = mutation[0];
    var abstract = mutation[1]; // If we already have a replaced node we do not want to continue nesting within it.
    // Short-circuit to the standard replacement

    if (~classArray(node).indexOf(config.replacementClass)) {
      return mutators.replace(mutation);
    }

    var forSvg = new RegExp("".concat(config.familyPrefix, "-.*"));
    delete abstract[0].attributes.style;
    var splitClasses = abstract[0].attributes.class.split(' ').reduce(function (acc, cls) {
      if (cls === config.replacementClass || cls.match(forSvg)) {
        acc.toSvg.push(cls);
      } else {
        acc.toNode.push(cls);
      }

      return acc;
    }, {
      toNode: [],
      toSvg: []
    });
    abstract[0].attributes.class = splitClasses.toSvg.join(' ');
    var newInnerHTML = abstract.map(function (a) {
      return toHtml(a);
    }).join('\n');
    node.setAttribute('class', splitClasses.toNode.join(' '));
    node.setAttribute(DATA_FA_I2SVG, '');
    node.innerHTML = newInnerHTML;
  }
};

function performOperationSync(op) {
  op();
}

function perform(mutations, callback) {
  var callbackFunction = typeof callback === 'function' ? callback : noop$2;

  if (mutations.length === 0) {
    callbackFunction();
  } else {
    var frame = performOperationSync;

    if (config.mutateApproach === MUTATION_APPROACH_ASYNC) {
      frame = WINDOW.requestAnimationFrame || performOperationSync;
    }

    frame(function () {
      var mutator = getMutator();
      var mark = perf.begin('mutate');
      mutations.map(mutator);
      mark();
      callbackFunction();
    });
  }
}
var disabled = false;
function disableObservation() {
  disabled = true;
}
function enableObservation() {
  disabled = false;
}
var mo = null;
function observe(options) {
  if (!MUTATION_OBSERVER) {
    return;
  }

  if (!config.observeMutations) {
    return;
  }

  var treeCallback = options.treeCallback,
      nodeCallback = options.nodeCallback,
      pseudoElementsCallback = options.pseudoElementsCallback,
      _options$observeMutat = options.observeMutationsRoot,
      observeMutationsRoot = _options$observeMutat === void 0 ? DOCUMENT : _options$observeMutat;
  mo = new MUTATION_OBSERVER(function (objects) {
    if (disabled) return;
    toArray(objects).forEach(function (mutationRecord) {
      if (mutationRecord.type === 'childList' && mutationRecord.addedNodes.length > 0 && !isWatched(mutationRecord.addedNodes[0])) {
        if (config.searchPseudoElements) {
          pseudoElementsCallback(mutationRecord.target);
        }

        treeCallback(mutationRecord.target);
      }

      if (mutationRecord.type === 'attributes' && mutationRecord.target.parentNode && config.searchPseudoElements) {
        pseudoElementsCallback(mutationRecord.target.parentNode);
      }

      if (mutationRecord.type === 'attributes' && isWatched(mutationRecord.target) && ~ATTRIBUTES_WATCHED_FOR_MUTATION.indexOf(mutationRecord.attributeName)) {
        if (mutationRecord.attributeName === 'class') {
          var _getCanonicalIcon = getCanonicalIcon(classArray(mutationRecord.target)),
              prefix = _getCanonicalIcon.prefix,
              iconName = _getCanonicalIcon.iconName;

          if (prefix) mutationRecord.target.setAttribute('data-prefix', prefix);
          if (iconName) mutationRecord.target.setAttribute('data-icon', iconName);
        } else {
          nodeCallback(mutationRecord.target);
        }
      }
    });
  });
  if (!IS_DOM) return;
  mo.observe(observeMutationsRoot, {
    childList: true,
    attributes: true,
    characterData: true,
    subtree: true
  });
}
function disconnect() {
  if (!mo) return;
  mo.disconnect();
}

function styleParser (node) {
  var style = node.getAttribute('style');
  var val = [];

  if (style) {
    val = style.split(';').reduce(function (acc, style) {
      var styles = style.split(':');
      var prop = styles[0];
      var value = styles.slice(1);

      if (prop && value.length > 0) {
        acc[prop] = value.join(':').trim();
      }

      return acc;
    }, {});
  }

  return val;
}

function classParser (node) {
  var existingPrefix = node.getAttribute('data-prefix');
  var existingIconName = node.getAttribute('data-icon');
  var innerText = node.innerText !== undefined ? node.innerText.trim() : '';
  var val = getCanonicalIcon(classArray(node));

  if (existingPrefix && existingIconName) {
    val.prefix = existingPrefix;
    val.iconName = existingIconName;
  }

  if (val.prefix && innerText.length > 1) {
    val.iconName = byLigature(val.prefix, node.innerText);
  } else if (val.prefix && innerText.length === 1) {
    val.iconName = byUnicode(val.prefix, toHex(node.innerText));
  }

  return val;
}

var parseTransformString = function parseTransformString(transformString) {
  var transform = {
    size: 16,
    x: 0,
    y: 0,
    flipX: false,
    flipY: false,
    rotate: 0
  };

  if (!transformString) {
    return transform;
  } else {
    return transformString.toLowerCase().split(' ').reduce(function (acc, n) {
      var parts = n.toLowerCase().split('-');
      var first = parts[0];
      var rest = parts.slice(1).join('-');

      if (first && rest === 'h') {
        acc.flipX = true;
        return acc;
      }

      if (first && rest === 'v') {
        acc.flipY = true;
        return acc;
      }

      rest = parseFloat(rest);

      if (isNaN(rest)) {
        return acc;
      }

      switch (first) {
        case 'grow':
          acc.size = acc.size + rest;
          break;

        case 'shrink':
          acc.size = acc.size - rest;
          break;

        case 'left':
          acc.x = acc.x - rest;
          break;

        case 'right':
          acc.x = acc.x + rest;
          break;

        case 'up':
          acc.y = acc.y - rest;
          break;

        case 'down':
          acc.y = acc.y + rest;
          break;

        case 'rotate':
          acc.rotate = acc.rotate + rest;
          break;
      }

      return acc;
    }, transform);
  }
};
function transformParser (node) {
  return parseTransformString(node.getAttribute('data-fa-transform'));
}

function symbolParser (node) {
  var symbol = node.getAttribute('data-fa-symbol');
  return symbol === null ? false : symbol === '' ? true : symbol;
}

function attributesParser (node) {
  var extraAttributes = toArray(node.attributes).reduce(function (acc, attr) {
    if (acc.name !== 'class' && acc.name !== 'style') {
      acc[attr.name] = attr.value;
    }

    return acc;
  }, {});
  var title = node.getAttribute('title');

  if (config.autoA11y) {
    if (title) {
      extraAttributes['aria-labelledby'] = "".concat(config.replacementClass, "-title-").concat(nextUniqueId());
    } else {
      extraAttributes['aria-hidden'] = 'true';
      extraAttributes['focusable'] = 'false';
    }
  }

  return extraAttributes;
}

function maskParser (node) {
  var mask = node.getAttribute('data-fa-mask');

  if (!mask) {
    return emptyCanonicalIcon();
  } else {
    return getCanonicalIcon(mask.split(' ').map(function (i) {
      return i.trim();
    }));
  }
}

function blankMeta() {
  return {
    iconName: null,
    title: null,
    prefix: null,
    transform: meaninglessTransform,
    symbol: false,
    mask: null,
    extra: {
      classes: [],
      styles: {},
      attributes: {}
    }
  };
}
function parseMeta(node) {
  var _classParser = classParser(node),
      iconName = _classParser.iconName,
      prefix = _classParser.prefix,
      extraClasses = _classParser.rest;

  var extraStyles = styleParser(node);
  var transform = transformParser(node);
  var symbol = symbolParser(node);
  var extraAttributes = attributesParser(node);
  var mask = maskParser(node);
  return {
    iconName: iconName,
    title: node.getAttribute('title'),
    prefix: prefix,
    transform: transform,
    symbol: symbol,
    mask: mask,
    extra: {
      classes: extraClasses,
      styles: extraStyles,
      attributes: extraAttributes
    }
  };
}

function MissingIcon(error) {
  this.name = 'MissingIcon';
  this.message = error || 'Icon unavailable';
  this.stack = new Error().stack;
}
MissingIcon.prototype = Object.create(Error.prototype);
MissingIcon.prototype.constructor = MissingIcon;

var FILL = {
  fill: 'currentColor'
};
var ANIMATION_BASE = {
  attributeType: 'XML',
  repeatCount: 'indefinite',
  dur: '2s'
};
var RING = {
  tag: 'path',
  attributes: _objectSpread({}, FILL, {
    d: 'M156.5,447.7l-12.6,29.5c-18.7-9.5-35.9-21.2-51.5-34.9l22.7-22.7C127.6,430.5,141.5,440,156.5,447.7z M40.6,272H8.5 c1.4,21.2,5.4,41.7,11.7,61.1L50,321.2C45.1,305.5,41.8,289,40.6,272z M40.6,240c1.4-18.8,5.2-37,11.1-54.1l-29.5-12.6 C14.7,194.3,10,216.7,8.5,240H40.6z M64.3,156.5c7.8-14.9,17.2-28.8,28.1-41.5L69.7,92.3c-13.7,15.6-25.5,32.8-34.9,51.5 L64.3,156.5z M397,419.6c-13.9,12-29.4,22.3-46.1,30.4l11.9,29.8c20.7-9.9,39.8-22.6,56.9-37.6L397,419.6z M115,92.4 c13.9-12,29.4-22.3,46.1-30.4l-11.9-29.8c-20.7,9.9-39.8,22.6-56.8,37.6L115,92.4z M447.7,355.5c-7.8,14.9-17.2,28.8-28.1,41.5 l22.7,22.7c13.7-15.6,25.5-32.9,34.9-51.5L447.7,355.5z M471.4,272c-1.4,18.8-5.2,37-11.1,54.1l29.5,12.6 c7.5-21.1,12.2-43.5,13.6-66.8H471.4z M321.2,462c-15.7,5-32.2,8.2-49.2,9.4v32.1c21.2-1.4,41.7-5.4,61.1-11.7L321.2,462z M240,471.4c-18.8-1.4-37-5.2-54.1-11.1l-12.6,29.5c21.1,7.5,43.5,12.2,66.8,13.6V471.4z M462,190.8c5,15.7,8.2,32.2,9.4,49.2h32.1 c-1.4-21.2-5.4-41.7-11.7-61.1L462,190.8z M92.4,397c-12-13.9-22.3-29.4-30.4-46.1l-29.8,11.9c9.9,20.7,22.6,39.8,37.6,56.9 L92.4,397z M272,40.6c18.8,1.4,36.9,5.2,54.1,11.1l12.6-29.5C317.7,14.7,295.3,10,272,8.5V40.6z M190.8,50 c15.7-5,32.2-8.2,49.2-9.4V8.5c-21.2,1.4-41.7,5.4-61.1,11.7L190.8,50z M442.3,92.3L419.6,115c12,13.9,22.3,29.4,30.5,46.1 l29.8-11.9C470,128.5,457.3,109.4,442.3,92.3z M397,92.4l22.7-22.7c-15.6-13.7-32.8-25.5-51.5-34.9l-12.6,29.5 C370.4,72.1,384.4,81.5,397,92.4z'
  })
};

var OPACITY_ANIMATE = _objectSpread({}, ANIMATION_BASE, {
  attributeName: 'opacity'
});

var DOT = {
  tag: 'circle',
  attributes: _objectSpread({}, FILL, {
    cx: '256',
    cy: '364',
    r: '28'
  }),
  children: [{
    tag: 'animate',
    attributes: _objectSpread({}, ANIMATION_BASE, {
      attributeName: 'r',
      values: '28;14;28;28;14;28;'
    })
  }, {
    tag: 'animate',
    attributes: _objectSpread({}, OPACITY_ANIMATE, {
      values: '1;0;1;1;0;1;'
    })
  }]
};
var QUESTION = {
  tag: 'path',
  attributes: _objectSpread({}, FILL, {
    opacity: '1',
    d: 'M263.7,312h-16c-6.6,0-12-5.4-12-12c0-71,77.4-63.9,77.4-107.8c0-20-17.8-40.2-57.4-40.2c-29.1,0-44.3,9.6-59.2,28.7 c-3.9,5-11.1,6-16.2,2.4l-13.1-9.2c-5.6-3.9-6.9-11.8-2.6-17.2c21.2-27.2,46.4-44.7,91.2-44.7c52.3,0,97.4,29.8,97.4,80.2 c0,67.6-77.4,63.5-77.4,107.8C275.7,306.6,270.3,312,263.7,312z'
  }),
  children: [{
    tag: 'animate',
    attributes: _objectSpread({}, OPACITY_ANIMATE, {
      values: '1;0;0;0;0;1;'
    })
  }]
};
var EXCLAMATION = {
  tag: 'path',
  attributes: _objectSpread({}, FILL, {
    opacity: '0',
    d: 'M232.5,134.5l7,168c0.3,6.4,5.6,11.5,12,11.5h9c6.4,0,11.7-5.1,12-11.5l7-168c0.3-6.8-5.2-12.5-12-12.5h-23 C237.7,122,232.2,127.7,232.5,134.5z'
  }),
  children: [{
    tag: 'animate',
    attributes: _objectSpread({}, OPACITY_ANIMATE, {
      values: '0;0;1;1;0;0;'
    })
  }]
};
var missing = {
  tag: 'g',
  children: [RING, DOT, QUESTION, EXCLAMATION]
};

var styles$2 = namespace.styles;
function findIcon(iconName, prefix) {
  return new picked(function (resolve, reject) {
    var val = {
      found: false,
      width: 512,
      height: 512,
      icon: missing
    };

    if (iconName && prefix && styles$2[prefix] && styles$2[prefix][iconName]) {
      var icon = styles$2[prefix][iconName];
      var width = icon[0];
      var height = icon[1];
      var vectorData = icon.slice(4);
      val = {
        found: true,
        width: width,
        height: height,
        icon: {
          tag: 'path',
          attributes: {
            fill: 'currentColor',
            d: vectorData[0]
          }
        }
      };
      return resolve(val);
    }

    if (iconName && prefix && !config.showMissingIcons) {
      reject(new MissingIcon("Icon is missing for prefix ".concat(prefix, " with icon name ").concat(iconName)));
    } else {
      resolve(val);
    }
  });
}

var styles$3 = namespace.styles;

function generateSvgReplacementMutation(node, nodeMeta) {
  var iconName = nodeMeta.iconName,
      title = nodeMeta.title,
      prefix = nodeMeta.prefix,
      transform = nodeMeta.transform,
      symbol = nodeMeta.symbol,
      mask = nodeMeta.mask,
      extra = nodeMeta.extra;
  return new picked(function (resolve, reject) {
    picked.all([findIcon(iconName, prefix), findIcon(mask.iconName, mask.prefix)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          main = _ref2[0],
          mask = _ref2[1];

      resolve([node, makeInlineSvgAbstract({
        icons: {
          main: main,
          mask: mask
        },
        prefix: prefix,
        iconName: iconName,
        transform: transform,
        symbol: symbol,
        mask: mask,
        title: title,
        extra: extra,
        watchable: true
      })]);
    });
  });
}

function generateLayersText(node, nodeMeta) {
  var title = nodeMeta.title,
      transform = nodeMeta.transform,
      extra = nodeMeta.extra;
  var width = null;
  var height = null;

  if (IS_IE) {
    var computedFontSize = parseInt(getComputedStyle(node).fontSize, 10);
    var boundingClientRect = node.getBoundingClientRect();
    width = boundingClientRect.width / computedFontSize;
    height = boundingClientRect.height / computedFontSize;
  }

  if (config.autoA11y && !title) {
    extra.attributes['aria-hidden'] = 'true';
  }

  return picked.resolve([node, makeLayersTextAbstract({
    content: node.innerHTML,
    width: width,
    height: height,
    transform: transform,
    title: title,
    extra: extra,
    watchable: true
  })]);
}

function generateMutation(node) {
  var nodeMeta = parseMeta(node);

  if (~nodeMeta.extra.classes.indexOf(LAYERS_TEXT_CLASSNAME)) {
    return generateLayersText(node, nodeMeta);
  } else {
    return generateSvgReplacementMutation(node, nodeMeta);
  }
}

function onTree(root) {
  var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  if (!IS_DOM) return;
  var htmlClassList = DOCUMENT.documentElement.classList;

  var hclAdd = function hclAdd(suffix) {
    return htmlClassList.add("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
  };

  var hclRemove = function hclRemove(suffix) {
    return htmlClassList.remove("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
  };

  var prefixes = config.autoFetchSvg ? Object.keys(PREFIX_TO_STYLE) : Object.keys(styles$3);
  var prefixesDomQuery = [".".concat(LAYERS_TEXT_CLASSNAME, ":not([").concat(DATA_FA_I2SVG, "])")].concat(prefixes.map(function (p) {
    return ".".concat(p, ":not([").concat(DATA_FA_I2SVG, "])");
  })).join(', ');

  if (prefixesDomQuery.length === 0) {
    return;
  }

  var candidates = [];

  try {
    candidates = toArray(root.querySelectorAll(prefixesDomQuery));
  } catch (e) {// noop
  }

  if (candidates.length > 0) {
    hclAdd('pending');
    hclRemove('complete');
  } else {
    return;
  }

  var mark = perf.begin('onTree');
  var mutations = candidates.reduce(function (acc, node) {
    try {
      var mutation = generateMutation(node);

      if (mutation) {
        acc.push(mutation);
      }
    } catch (e) {
      if (!PRODUCTION) {
        if (e instanceof MissingIcon) {
          console.error(e);
        }
      }
    }

    return acc;
  }, []);
  return new picked(function (resolve, reject) {
    picked.all(mutations).then(function (resolvedMutations) {
      perform(resolvedMutations, function () {
        hclAdd('active');
        hclAdd('complete');
        hclRemove('pending');
        if (typeof callback === 'function') callback();
        mark();
        resolve();
      });
    }).catch(function () {
      mark();
      reject();
    });
  });
}
function onNode(node) {
  var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  generateMutation(node).then(function (mutation) {
    if (mutation) {
      perform([mutation], callback);
    }
  });
}

function replaceForPosition(node, position) {
  var pendingAttribute = "".concat(DATA_FA_PSEUDO_ELEMENT_PENDING).concat(position.replace(':', '-'));
  return new picked(function (resolve, reject) {
    if (node.getAttribute(pendingAttribute) !== null) {
      // This node is already being processed
      return resolve();
    }

    var children = toArray(node.children);
    var alreadyProcessedPseudoElement = children.filter(function (c) {
      return c.getAttribute(DATA_FA_PSEUDO_ELEMENT) === position;
    })[0];
    var styles = WINDOW.getComputedStyle(node, position);
    var fontFamily = styles.getPropertyValue('font-family').match(FONT_FAMILY_PATTERN);
    var fontWeight = styles.getPropertyValue('font-weight');

    if (alreadyProcessedPseudoElement && !fontFamily) {
      // If we've already processed it but the current computed style does not result in a font-family,
      // that probably means that a class name that was previously present to make the icon has been
      // removed. So we now should delete the icon.
      node.removeChild(alreadyProcessedPseudoElement);
      return resolve();
    } else if (fontFamily) {
      var content = styles.getPropertyValue('content');
      var prefix = ~['Light', 'Regular', 'Solid', 'Brands'].indexOf(fontFamily[1]) ? STYLE_TO_PREFIX[fontFamily[1].toLowerCase()] : FONT_WEIGHT_TO_PREFIX[fontWeight];
      var hexValue = toHex(content.length === 3 ? content.substr(1, 1) : content);
      var iconName = byUnicode(prefix, hexValue);
      var iconIdentifier = iconName; // Only convert the pseudo element in this :before/:after position into an icon if we haven't
      // already done so with the same prefix and iconName

      if (iconName && (!alreadyProcessedPseudoElement || alreadyProcessedPseudoElement.getAttribute(DATA_PREFIX) !== prefix || alreadyProcessedPseudoElement.getAttribute(DATA_ICON) !== iconIdentifier)) {
        node.setAttribute(pendingAttribute, iconIdentifier);

        if (alreadyProcessedPseudoElement) {
          // Delete the old one, since we're replacing it with a new one
          node.removeChild(alreadyProcessedPseudoElement);
        }

        var meta = blankMeta();
        var extra = meta.extra;
        extra.attributes[DATA_FA_PSEUDO_ELEMENT] = position;
        findIcon(iconName, prefix).then(function (main) {
          var abstract = makeInlineSvgAbstract(_objectSpread({}, meta, {
            icons: {
              main: main,
              mask: emptyCanonicalIcon()
            },
            prefix: prefix,
            iconName: iconIdentifier,
            extra: extra,
            watchable: true
          }));
          var element = DOCUMENT.createElement('svg');

          if (position === ':before') {
            node.insertBefore(element, node.firstChild);
          } else {
            node.appendChild(element);
          }

          element.outerHTML = abstract.map(function (a) {
            return toHtml(a);
          }).join('\n');
          node.removeAttribute(pendingAttribute);
          resolve();
        }).catch(reject);
      } else {
        resolve();
      }
    } else {
      resolve();
    }
  });
}

function replace(node) {
  return picked.all([replaceForPosition(node, ':before'), replaceForPosition(node, ':after')]);
}

function processable(node) {
  return node.parentNode !== document.head && !~TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS.indexOf(node.tagName.toUpperCase()) && !node.getAttribute(DATA_FA_PSEUDO_ELEMENT) && (!node.parentNode || node.parentNode.tagName !== 'svg');
}

function searchPseudoElements (root) {
  if (!IS_DOM) return;
  return new picked(function (resolve, reject) {
    var operations = toArray(root.querySelectorAll('*')).filter(processable).map(replace);
    var end = perf.begin('searchPseudoElements');
    disableObservation();
    picked.all(operations).then(function () {
      end();
      enableObservation();
      resolve();
    }).catch(function () {
      end();
      enableObservation();
      reject();
    });
  });
}

var baseStyles = "svg:not(:root).svg-inline--fa {\n  overflow: visible;\n}\n\n.svg-inline--fa {\n  display: inline-block;\n  font-size: inherit;\n  height: 1em;\n  overflow: visible;\n  vertical-align: -0.125em;\n}\n.svg-inline--fa.fa-lg {\n  vertical-align: -0.225em;\n}\n.svg-inline--fa.fa-w-1 {\n  width: 0.0625em;\n}\n.svg-inline--fa.fa-w-2 {\n  width: 0.125em;\n}\n.svg-inline--fa.fa-w-3 {\n  width: 0.1875em;\n}\n.svg-inline--fa.fa-w-4 {\n  width: 0.25em;\n}\n.svg-inline--fa.fa-w-5 {\n  width: 0.3125em;\n}\n.svg-inline--fa.fa-w-6 {\n  width: 0.375em;\n}\n.svg-inline--fa.fa-w-7 {\n  width: 0.4375em;\n}\n.svg-inline--fa.fa-w-8 {\n  width: 0.5em;\n}\n.svg-inline--fa.fa-w-9 {\n  width: 0.5625em;\n}\n.svg-inline--fa.fa-w-10 {\n  width: 0.625em;\n}\n.svg-inline--fa.fa-w-11 {\n  width: 0.6875em;\n}\n.svg-inline--fa.fa-w-12 {\n  width: 0.75em;\n}\n.svg-inline--fa.fa-w-13 {\n  width: 0.8125em;\n}\n.svg-inline--fa.fa-w-14 {\n  width: 0.875em;\n}\n.svg-inline--fa.fa-w-15 {\n  width: 0.9375em;\n}\n.svg-inline--fa.fa-w-16 {\n  width: 1em;\n}\n.svg-inline--fa.fa-w-17 {\n  width: 1.0625em;\n}\n.svg-inline--fa.fa-w-18 {\n  width: 1.125em;\n}\n.svg-inline--fa.fa-w-19 {\n  width: 1.1875em;\n}\n.svg-inline--fa.fa-w-20 {\n  width: 1.25em;\n}\n.svg-inline--fa.fa-pull-left {\n  margin-right: 0.3em;\n  width: auto;\n}\n.svg-inline--fa.fa-pull-right {\n  margin-left: 0.3em;\n  width: auto;\n}\n.svg-inline--fa.fa-border {\n  height: 1.5em;\n}\n.svg-inline--fa.fa-li {\n  width: 2em;\n}\n.svg-inline--fa.fa-fw {\n  width: 1.25em;\n}\n\n.fa-layers svg.svg-inline--fa {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.fa-layers {\n  display: inline-block;\n  height: 1em;\n  position: relative;\n  text-align: center;\n  vertical-align: -0.125em;\n  width: 1em;\n}\n.fa-layers svg.svg-inline--fa {\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-counter, .fa-layers-text {\n  display: inline-block;\n  position: absolute;\n  text-align: center;\n}\n\n.fa-layers-text {\n  left: 50%;\n  top: 50%;\n  -webkit-transform: translate(-50%, -50%);\n          transform: translate(-50%, -50%);\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-counter {\n  background-color: #ff253a;\n  border-radius: 1em;\n  -webkit-box-sizing: border-box;\n          box-sizing: border-box;\n  color: #fff;\n  height: 1.5em;\n  line-height: 1;\n  max-width: 5em;\n  min-width: 1.5em;\n  overflow: hidden;\n  padding: 0.25em;\n  right: 0;\n  text-overflow: ellipsis;\n  top: 0;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-bottom-right {\n  bottom: 0;\n  right: 0;\n  top: auto;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: bottom right;\n          transform-origin: bottom right;\n}\n\n.fa-layers-bottom-left {\n  bottom: 0;\n  left: 0;\n  right: auto;\n  top: auto;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: bottom left;\n          transform-origin: bottom left;\n}\n\n.fa-layers-top-right {\n  right: 0;\n  top: 0;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-top-left {\n  left: 0;\n  right: auto;\n  top: 0;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: top left;\n          transform-origin: top left;\n}\n\n.fa-lg {\n  font-size: 1.3333333333em;\n  line-height: 0.75em;\n  vertical-align: -0.0667em;\n}\n\n.fa-xs {\n  font-size: 0.75em;\n}\n\n.fa-sm {\n  font-size: 0.875em;\n}\n\n.fa-1x {\n  font-size: 1em;\n}\n\n.fa-2x {\n  font-size: 2em;\n}\n\n.fa-3x {\n  font-size: 3em;\n}\n\n.fa-4x {\n  font-size: 4em;\n}\n\n.fa-5x {\n  font-size: 5em;\n}\n\n.fa-6x {\n  font-size: 6em;\n}\n\n.fa-7x {\n  font-size: 7em;\n}\n\n.fa-8x {\n  font-size: 8em;\n}\n\n.fa-9x {\n  font-size: 9em;\n}\n\n.fa-10x {\n  font-size: 10em;\n}\n\n.fa-fw {\n  text-align: center;\n  width: 1.25em;\n}\n\n.fa-ul {\n  list-style-type: none;\n  margin-left: 2.5em;\n  padding-left: 0;\n}\n.fa-ul > li {\n  position: relative;\n}\n\n.fa-li {\n  left: -2em;\n  position: absolute;\n  text-align: center;\n  width: 2em;\n  line-height: inherit;\n}\n\n.fa-border {\n  border: solid 0.08em #eee;\n  border-radius: 0.1em;\n  padding: 0.2em 0.25em 0.15em;\n}\n\n.fa-pull-left {\n  float: left;\n}\n\n.fa-pull-right {\n  float: right;\n}\n\n.fa.fa-pull-left,\n.fas.fa-pull-left,\n.far.fa-pull-left,\n.fal.fa-pull-left,\n.fab.fa-pull-left {\n  margin-right: 0.3em;\n}\n.fa.fa-pull-right,\n.fas.fa-pull-right,\n.far.fa-pull-right,\n.fal.fa-pull-right,\n.fab.fa-pull-right {\n  margin-left: 0.3em;\n}\n\n.fa-spin {\n  -webkit-animation: fa-spin 2s infinite linear;\n          animation: fa-spin 2s infinite linear;\n}\n\n.fa-pulse {\n  -webkit-animation: fa-spin 1s infinite steps(8);\n          animation: fa-spin 1s infinite steps(8);\n}\n\n@-webkit-keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n\n@keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n.fa-rotate-90 {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)\";\n  -webkit-transform: rotate(90deg);\n          transform: rotate(90deg);\n}\n\n.fa-rotate-180 {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=2)\";\n  -webkit-transform: rotate(180deg);\n          transform: rotate(180deg);\n}\n\n.fa-rotate-270 {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)\";\n  -webkit-transform: rotate(270deg);\n          transform: rotate(270deg);\n}\n\n.fa-flip-horizontal {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)\";\n  -webkit-transform: scale(-1, 1);\n          transform: scale(-1, 1);\n}\n\n.fa-flip-vertical {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)\";\n  -webkit-transform: scale(1, -1);\n          transform: scale(1, -1);\n}\n\n.fa-flip-both, .fa-flip-horizontal.fa-flip-vertical {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)\";\n  -webkit-transform: scale(-1, -1);\n          transform: scale(-1, -1);\n}\n\n:root .fa-rotate-90,\n:root .fa-rotate-180,\n:root .fa-rotate-270,\n:root .fa-flip-horizontal,\n:root .fa-flip-vertical,\n:root .fa-flip-both {\n  -webkit-filter: none;\n          filter: none;\n}\n\n.fa-stack {\n  display: inline-block;\n  height: 2em;\n  position: relative;\n  width: 2.5em;\n}\n\n.fa-stack-1x,\n.fa-stack-2x {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.svg-inline--fa.fa-stack-1x {\n  height: 1em;\n  width: 1.25em;\n}\n.svg-inline--fa.fa-stack-2x {\n  height: 2em;\n  width: 2.5em;\n}\n\n.fa-inverse {\n  color: #fff;\n}\n\n.sr-only {\n  border: 0;\n  clip: rect(0, 0, 0, 0);\n  height: 1px;\n  margin: -1px;\n  overflow: hidden;\n  padding: 0;\n  position: absolute;\n  width: 1px;\n}\n\n.sr-only-focusable:active, .sr-only-focusable:focus {\n  clip: auto;\n  height: auto;\n  margin: 0;\n  overflow: visible;\n  position: static;\n  width: auto;\n}";

function css () {
  var dfp = DEFAULT_FAMILY_PREFIX;
  var drc = DEFAULT_REPLACEMENT_CLASS;
  var fp = config.familyPrefix;
  var rc = config.replacementClass;
  var s = baseStyles;

  if (fp !== dfp || rc !== drc) {
    var dPatt = new RegExp("\\.".concat(dfp, "\\-"), 'g');
    var rPatt = new RegExp("\\.".concat(drc), 'g');
    s = s.replace(dPatt, ".".concat(fp, "-")).replace(rPatt, ".".concat(rc));
  }

  return s;
}

var Library =
/*#__PURE__*/
function () {
  function Library() {
    _classCallCheck(this, Library);

    this.definitions = {};
  }

  _createClass(Library, [{
    key: "add",
    value: function add() {
      var _this = this;

      for (var _len = arguments.length, definitions = new Array(_len), _key = 0; _key < _len; _key++) {
        definitions[_key] = arguments[_key];
      }

      var additions = definitions.reduce(this._pullDefinitions, {});
      Object.keys(additions).forEach(function (key) {
        _this.definitions[key] = _objectSpread({}, _this.definitions[key] || {}, additions[key]);
        defineIcons(key, additions[key]);
        build();
      });
    }
  }, {
    key: "reset",
    value: function reset() {
      this.definitions = {};
    }
  }, {
    key: "_pullDefinitions",
    value: function _pullDefinitions(additions, definition) {
      var normalized = definition.prefix && definition.iconName && definition.icon ? {
        0: definition
      } : definition;
      Object.keys(normalized).map(function (key) {
        var _normalized$key = normalized[key],
            prefix = _normalized$key.prefix,
            iconName = _normalized$key.iconName,
            icon = _normalized$key.icon;
        if (!additions[prefix]) additions[prefix] = {};
        additions[prefix][iconName] = icon;
      });
      return additions;
    }
  }]);

  return Library;
}();

function prepIcon(icon) {
  var width = icon[0];
  var height = icon[1];
  var vectorData = icon.slice(4);
  return {
    found: true,
    width: width,
    height: height,
    icon: {
      tag: 'path',
      attributes: {
        fill: 'currentColor',
        d: vectorData[0]
      }
    }
  };
}

function ensureCss() {
  if (config.autoAddCss && !_cssInserted) {
    insertCss(css());

    _cssInserted = true;
  }
}

function apiObject(val, abstractCreator) {
  Object.defineProperty(val, 'abstract', {
    get: abstractCreator
  });
  Object.defineProperty(val, 'html', {
    get: function get() {
      return val.abstract.map(function (a) {
        return toHtml(a);
      });
    }
  });
  Object.defineProperty(val, 'node', {
    get: function get() {
      if (!IS_DOM) return;
      var container = DOCUMENT.createElement('div');
      container.innerHTML = val.html;
      return container.children;
    }
  });
  return val;
}

function findIconDefinition(iconLookup) {
  var _iconLookup$prefix = iconLookup.prefix,
      prefix = _iconLookup$prefix === void 0 ? 'fa' : _iconLookup$prefix,
      iconName = iconLookup.iconName;
  if (!iconName) return;
  return iconFromMapping(library.definitions, prefix, iconName) || iconFromMapping(namespace.styles, prefix, iconName);
}

function resolveIcons(next) {
  return function (maybeIconDefinition) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var iconDefinition = (maybeIconDefinition || {}).icon ? maybeIconDefinition : findIconDefinition(maybeIconDefinition || {});
    var mask = params.mask;

    if (mask) {
      mask = (mask || {}).icon ? mask : findIconDefinition(mask || {});
    }

    return next(iconDefinition, _objectSpread({}, params, {
      mask: mask
    }));
  };
}

var library = new Library();
var noAuto = function noAuto() {
  config.autoReplaceSvg = false;
  config.observeMutations = false;
  disconnect();
};
var _cssInserted = false;
var dom = {
  i2svg: function i2svg() {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (IS_DOM) {
      ensureCss();
      var _params$node = params.node,
          node = _params$node === void 0 ? DOCUMENT : _params$node,
          _params$callback = params.callback,
          callback = _params$callback === void 0 ? function () {} : _params$callback;

      if (config.searchPseudoElements) {
        searchPseudoElements(node);
      }

      return onTree(node, callback);
    } else {
      return picked.reject('Operation requires a DOM of some kind.');
    }
  },
  css: css,
  insertCss: function insertCss$$1() {
    if (!_cssInserted) {
      insertCss(css());

      _cssInserted = true;
    }
  },
  watch: function watch() {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var autoReplaceSvgRoot = params.autoReplaceSvgRoot,
        observeMutationsRoot = params.observeMutationsRoot;

    if (config.autoReplaceSvg === false) {
      config.autoReplaceSvg = true;
    }

    config.observeMutations = true;
    domready(function () {
      autoReplace({
        autoReplaceSvgRoot: autoReplaceSvgRoot
      });
      observe({
        treeCallback: onTree,
        nodeCallback: onNode,
        pseudoElementsCallback: searchPseudoElements,
        observeMutationsRoot: observeMutationsRoot
      });
    });
  }
};
var parse = {
  transform: function transform(transformString) {
    return parseTransformString(transformString);
  }
};
var icon = resolveIcons(function (iconDefinition) {
  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _params$transform = params.transform,
      transform = _params$transform === void 0 ? meaninglessTransform : _params$transform,
      _params$symbol = params.symbol,
      symbol = _params$symbol === void 0 ? false : _params$symbol,
      _params$mask = params.mask,
      mask = _params$mask === void 0 ? null : _params$mask,
      _params$title = params.title,
      title = _params$title === void 0 ? null : _params$title,
      _params$classes = params.classes,
      classes = _params$classes === void 0 ? [] : _params$classes,
      _params$attributes = params.attributes,
      attributes = _params$attributes === void 0 ? {} : _params$attributes,
      _params$styles = params.styles,
      styles = _params$styles === void 0 ? {} : _params$styles;
  if (!iconDefinition) return;
  var prefix = iconDefinition.prefix,
      iconName = iconDefinition.iconName,
      icon = iconDefinition.icon;
  return apiObject(_objectSpread({
    type: 'icon'
  }, iconDefinition), function () {
    ensureCss();

    if (config.autoA11y) {
      if (title) {
        attributes['aria-labelledby'] = "".concat(config.replacementClass, "-title-").concat(nextUniqueId());
      } else {
        attributes['aria-hidden'] = 'true';
        attributes['focusable'] = 'false';
      }
    }

    return makeInlineSvgAbstract({
      icons: {
        main: prepIcon(icon),
        mask: mask ? prepIcon(mask.icon) : {
          found: false,
          width: null,
          height: null,
          icon: {}
        }
      },
      prefix: prefix,
      iconName: iconName,
      transform: _objectSpread({}, meaninglessTransform, transform),
      symbol: symbol,
      title: title,
      extra: {
        attributes: attributes,
        styles: styles,
        classes: classes
      }
    });
  });
});
var text = function text(content) {
  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _params$transform2 = params.transform,
      transform = _params$transform2 === void 0 ? meaninglessTransform : _params$transform2,
      _params$title2 = params.title,
      title = _params$title2 === void 0 ? null : _params$title2,
      _params$classes2 = params.classes,
      classes = _params$classes2 === void 0 ? [] : _params$classes2,
      _params$attributes2 = params.attributes,
      attributes = _params$attributes2 === void 0 ? {} : _params$attributes2,
      _params$styles2 = params.styles,
      styles = _params$styles2 === void 0 ? {} : _params$styles2;
  return apiObject({
    type: 'text',
    content: content
  }, function () {
    ensureCss();
    return makeLayersTextAbstract({
      content: content,
      transform: _objectSpread({}, meaninglessTransform, transform),
      title: title,
      extra: {
        attributes: attributes,
        styles: styles,
        classes: ["".concat(config.familyPrefix, "-layers-text")].concat(_toConsumableArray(classes))
      }
    });
  });
};
var counter = function counter(content) {
  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _params$title3 = params.title,
      title = _params$title3 === void 0 ? null : _params$title3,
      _params$classes3 = params.classes,
      classes = _params$classes3 === void 0 ? [] : _params$classes3,
      _params$attributes3 = params.attributes,
      attributes = _params$attributes3 === void 0 ? {} : _params$attributes3,
      _params$styles3 = params.styles,
      styles = _params$styles3 === void 0 ? {} : _params$styles3;
  return apiObject({
    type: 'counter',
    content: content
  }, function () {
    ensureCss();
    return makeLayersCounterAbstract({
      content: content.toString(),
      title: title,
      extra: {
        attributes: attributes,
        styles: styles,
        classes: ["".concat(config.familyPrefix, "-layers-counter")].concat(_toConsumableArray(classes))
      }
    });
  });
};
var layer = function layer(assembler) {
  return apiObject({
    type: 'layer'
  }, function () {
    ensureCss();
    var children = [];
    assembler(function (args) {
      Array.isArray(args) ? args.map(function (a) {
        children = children.concat(a.abstract);
      }) : children = children.concat(args.abstract);
    });
    return [{
      tag: 'span',
      attributes: {
        class: "".concat(config.familyPrefix, "-layers")
      },
      children: children
    }];
  });
};
var api = {
  noAuto: noAuto,
  config: config,
  dom: dom,
  library: library,
  parse: parse,
  findIconDefinition: findIconDefinition,
  icon: icon,
  text: text,
  counter: counter,
  layer: layer,
  toHtml: toHtml
};

var autoReplace = function autoReplace() {
  var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var _params$autoReplaceSv = params.autoReplaceSvgRoot,
      autoReplaceSvgRoot = _params$autoReplaceSv === void 0 ? DOCUMENT : _params$autoReplaceSv;
  if ((Object.keys(namespace.styles).length > 0 || config.autoFetchSvg) && IS_DOM && config.autoReplaceSvg) api.dom.i2svg({
    node: autoReplaceSvgRoot
  });
};



/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../webpack/buildin/global.js */ "./node_modules/webpack/buildin/global.js"), __webpack_require__(/*! ./../../timers-browserify/main.js */ "./node_modules/timers-browserify/main.js").setImmediate))

/***/ }),

/***/ "./node_modules/@fortawesome/pro-regular-svg-icons/index.es.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@fortawesome/pro-regular-svg-icons/index.es.js ***!
  \*********************************************************************/
/*! exports provided: far, prefix, faAbacus, faAcorn, faAd, faAddressBook, faAddressCard, faAdjust, faAirFreshener, faAlarmClock, faAlarmExclamation, faAlarmPlus, faAlarmSnooze, faAlicorn, faAlignCenter, faAlignJustify, faAlignLeft, faAlignRight, faAlignSlash, faAllergies, faAmbulance, faAmericanSignLanguageInterpreting, faAnalytics, faAnchor, faAngel, faAngleDoubleDown, faAngleDoubleLeft, faAngleDoubleRight, faAngleDoubleUp, faAngleDown, faAngleLeft, faAngleRight, faAngleUp, faAngry, faAnkh, faAppleAlt, faAppleCrate, faArchive, faArchway, faArrowAltCircleDown, faArrowAltCircleLeft, faArrowAltCircleRight, faArrowAltCircleUp, faArrowAltDown, faArrowAltFromBottom, faArrowAltFromLeft, faArrowAltFromRight, faArrowAltFromTop, faArrowAltLeft, faArrowAltRight, faArrowAltSquareDown, faArrowAltSquareLeft, faArrowAltSquareRight, faArrowAltSquareUp, faArrowAltToBottom, faArrowAltToLeft, faArrowAltToRight, faArrowAltToTop, faArrowAltUp, faArrowCircleDown, faArrowCircleLeft, faArrowCircleRight, faArrowCircleUp, faArrowDown, faArrowFromBottom, faArrowFromLeft, faArrowFromRight, faArrowFromTop, faArrowLeft, faArrowRight, faArrowSquareDown, faArrowSquareLeft, faArrowSquareRight, faArrowSquareUp, faArrowToBottom, faArrowToLeft, faArrowToRight, faArrowToTop, faArrowUp, faArrows, faArrowsAlt, faArrowsAltH, faArrowsAltV, faArrowsH, faArrowsV, faAssistiveListeningSystems, faAsterisk, faAt, faAtlas, faAtom, faAtomAlt, faAudioDescription, faAward, faAxe, faAxeBattle, faBaby, faBabyCarriage, faBackpack, faBackspace, faBackward, faBacon, faBadge, faBadgeCheck, faBadgeDollar, faBadgePercent, faBadgerHoney, faBagsShopping, faBalanceScale, faBalanceScaleLeft, faBalanceScaleRight, faBallPile, faBallot, faBallotCheck, faBan, faBandAid, faBarcode, faBarcodeAlt, faBarcodeRead, faBarcodeScan, faBars, faBaseball, faBaseballBall, faBasketballBall, faBasketballHoop, faBat, faBath, faBatteryBolt, faBatteryEmpty, faBatteryFull, faBatteryHalf, faBatteryQuarter, faBatterySlash, faBatteryThreeQuarters, faBed, faBeer, faBell, faBellExclamation, faBellPlus, faBellSchool, faBellSchoolSlash, faBellSlash, faBells, faBezierCurve, faBible, faBicycle, faBiking, faBikingMountain, faBinoculars, faBiohazard, faBirthdayCake, faBlanket, faBlender, faBlenderPhone, faBlind, faBlog, faBold, faBolt, faBomb, faBone, faBoneBreak, faBong, faBook, faBookAlt, faBookDead, faBookHeart, faBookMedical, faBookOpen, faBookReader, faBookSpells, faBookUser, faBookmark, faBooks, faBooksMedical, faBoot, faBoothCurtain, faBorderAll, faBorderBottom, faBorderInner, faBorderLeft, faBorderNone, faBorderOuter, faBorderRight, faBorderStyle, faBorderStyleAlt, faBorderTop, faBowArrow, faBowlingBall, faBowlingPins, faBox, faBoxAlt, faBoxBallot, faBoxCheck, faBoxFragile, faBoxFull, faBoxHeart, faBoxOpen, faBoxUp, faBoxUsd, faBoxes, faBoxesAlt, faBoxingGlove, faBrackets, faBracketsCurly, faBraille, faBrain, faBreadLoaf, faBreadSlice, faBriefcase, faBriefcaseMedical, faBringForward, faBringFront, faBroadcastTower, faBroom, faBrowser, faBrush, faBug, faBuilding, faBullhorn, faBullseye, faBullseyeArrow, faBullseyePointer, faBurgerSoda, faBurn, faBurrito, faBus, faBusAlt, faBusSchool, faBusinessTime, faCabinetFiling, faCalculator, faCalculatorAlt, faCalendar, faCalendarAlt, faCalendarCheck, faCalendarDay, faCalendarEdit, faCalendarExclamation, faCalendarMinus, faCalendarPlus, faCalendarStar, faCalendarTimes, faCalendarWeek, faCamera, faCameraAlt, faCameraRetro, faCampfire, faCampground, faCandleHolder, faCandyCane, faCandyCorn, faCannabis, faCapsules, faCar, faCarAlt, faCarBattery, faCarBuilding, faCarBump, faCarBus, faCarCrash, faCarGarage, faCarMechanic, faCarSide, faCarTilt, faCarWash, faCaretCircleDown, faCaretCircleLeft, faCaretCircleRight, faCaretCircleUp, faCaretDown, faCaretLeft, faCaretRight, faCaretSquareDown, faCaretSquareLeft, faCaretSquareRight, faCaretSquareUp, faCaretUp, faCarrot, faCars, faCartArrowDown, faCartPlus, faCashRegister, faCat, faCauldron, faCertificate, faChair, faChairOffice, faChalkboard, faChalkboardTeacher, faChargingStation, faChartArea, faChartBar, faChartLine, faChartLineDown, faChartNetwork, faChartPie, faChartPieAlt, faChartScatter, faCheck, faCheckCircle, faCheckDouble, faCheckSquare, faCheese, faCheeseSwiss, faCheeseburger, faChess, faChessBishop, faChessBishopAlt, faChessBoard, faChessClock, faChessClockAlt, faChessKing, faChessKingAlt, faChessKnight, faChessKnightAlt, faChessPawn, faChessPawnAlt, faChessQueen, faChessQueenAlt, faChessRook, faChessRookAlt, faChevronCircleDown, faChevronCircleLeft, faChevronCircleRight, faChevronCircleUp, faChevronDoubleDown, faChevronDoubleLeft, faChevronDoubleRight, faChevronDoubleUp, faChevronDown, faChevronLeft, faChevronRight, faChevronSquareDown, faChevronSquareLeft, faChevronSquareRight, faChevronSquareUp, faChevronUp, faChild, faChimney, faChurch, faCircle, faCircleNotch, faCity, faClawMarks, faClinicMedical, faClipboard, faClipboardCheck, faClipboardList, faClipboardListCheck, faClipboardPrescription, faClipboardUser, faClock, faClone, faClosedCaptioning, faCloud, faCloudDownload, faCloudDownloadAlt, faCloudDrizzle, faCloudHail, faCloudHailMixed, faCloudMeatball, faCloudMoon, faCloudMoonRain, faCloudRain, faCloudRainbow, faCloudShowers, faCloudShowersHeavy, faCloudSleet, faCloudSnow, faCloudSun, faCloudSunRain, faCloudUpload, faCloudUploadAlt, faClouds, faCloudsMoon, faCloudsSun, faClub, faCocktail, faCode, faCodeBranch, faCodeCommit, faCodeMerge, faCoffee, faCoffeeTogo, faCoffin, faCog, faCogs, faCoin, faCoins, faColumns, faComment, faCommentAlt, faCommentAltCheck, faCommentAltDollar, faCommentAltDots, faCommentAltEdit, faCommentAltExclamation, faCommentAltLines, faCommentAltMedical, faCommentAltMinus, faCommentAltPlus, faCommentAltSlash, faCommentAltSmile, faCommentAltTimes, faCommentCheck, faCommentDollar, faCommentDots, faCommentEdit, faCommentExclamation, faCommentLines, faCommentMedical, faCommentMinus, faCommentPlus, faCommentSlash, faCommentSmile, faCommentTimes, faComments, faCommentsAlt, faCommentsAltDollar, faCommentsDollar, faCompactDisc, faCompass, faCompassSlash, faCompress, faCompressAlt, faCompressArrowsAlt, faCompressWide, faConciergeBell, faConstruction, faContainerStorage, faConveyorBelt, faConveyorBeltAlt, faCookie, faCookieBite, faCopy, faCopyright, faCorn, faCouch, faCow, faCreditCard, faCreditCardBlank, faCreditCardFront, faCricket, faCroissant, faCrop, faCropAlt, faCross, faCrosshairs, faCrow, faCrown, faCrutch, faCrutches, faCube, faCubes, faCurling, faCut, faDagger, faDatabase, faDeaf, faDebug, faDeer, faDeerRudolph, faDemocrat, faDesktop, faDesktopAlt, faDewpoint, faDharmachakra, faDiagnoses, faDiamond, faDice, faDiceD10, faDiceD12, faDiceD20, faDiceD4, faDiceD6, faDiceD8, faDiceFive, faDiceFour, faDiceOne, faDiceSix, faDiceThree, faDiceTwo, faDigging, faDigitalTachograph, faDiploma, faDirections, faDisease, faDivide, faDizzy, faDna, faDoNotEnter, faDog, faDogLeashed, faDollarSign, faDolly, faDollyEmpty, faDollyFlatbed, faDollyFlatbedAlt, faDollyFlatbedEmpty, faDonate, faDoorClosed, faDoorOpen, faDotCircle, faDove, faDownload, faDraftingCompass, faDragon, faDrawCircle, faDrawPolygon, faDrawSquare, faDreidel, faDrone, faDroneAlt, faDrum, faDrumSteelpan, faDrumstick, faDrumstickBite, faDryer, faDryerAlt, faDuck, faDumbbell, faDumpster, faDumpsterFire, faDungeon, faEar, faEarMuffs, faEclipse, faEclipseAlt, faEdit, faEgg, faEggFried, faEject, faElephant, faEllipsisH, faEllipsisHAlt, faEllipsisV, faEllipsisVAlt, faEmptySet, faEngineWarning, faEnvelope, faEnvelopeOpen, faEnvelopeOpenDollar, faEnvelopeOpenText, faEnvelopeSquare, faEquals, faEraser, faEthernet, faEuroSign, faExchange, faExchangeAlt, faExclamation, faExclamationCircle, faExclamationSquare, faExclamationTriangle, faExpand, faExpandAlt, faExpandArrows, faExpandArrowsAlt, faExpandWide, faExternalLink, faExternalLinkAlt, faExternalLinkSquare, faExternalLinkSquareAlt, faEye, faEyeDropper, faEyeEvil, faEyeSlash, faFan, faFarm, faFastBackward, faFastForward, faFax, faFeather, faFeatherAlt, faFemale, faFieldHockey, faFighterJet, faFile, faFileAlt, faFileArchive, faFileAudio, faFileCertificate, faFileChartLine, faFileChartPie, faFileCheck, faFileCode, faFileContract, faFileCsv, faFileDownload, faFileEdit, faFileExcel, faFileExclamation, faFileExport, faFileImage, faFileImport, faFileInvoice, faFileInvoiceDollar, faFileMedical, faFileMedicalAlt, faFileMinus, faFilePdf, faFilePlus, faFilePowerpoint, faFilePrescription, faFileSearch, faFileSignature, faFileSpreadsheet, faFileTimes, faFileUpload, faFileUser, faFileVideo, faFileWord, faFilesMedical, faFill, faFillDrip, faFilm, faFilmAlt, faFilter, faFingerprint, faFire, faFireAlt, faFireExtinguisher, faFireSmoke, faFireplace, faFirstAid, faFish, faFishCooked, faFistRaised, faFlag, faFlagAlt, faFlagCheckered, faFlagUsa, faFlame, faFlask, faFlaskPoison, faFlaskPotion, faFlower, faFlowerDaffodil, faFlowerTulip, faFlushed, faFog, faFolder, faFolderMinus, faFolderOpen, faFolderPlus, faFolderTimes, faFolderTree, faFolders, faFont, faFontAwesomeLogoFull, faFontCase, faFootballBall, faFootballHelmet, faForklift, faForward, faFragile, faFrenchFries, faFrog, faFrostyHead, faFrown, faFrownOpen, faFunction, faFunnelDollar, faFutbol, faGameBoard, faGameBoardAlt, faGamepad, faGasPump, faGasPumpSlash, faGavel, faGem, faGenderless, faGhost, faGift, faGiftCard, faGifts, faGingerbreadMan, faGlass, faGlassChampagne, faGlassCheers, faGlassCitrus, faGlassMartini, faGlassMartiniAlt, faGlassWhiskey, faGlassWhiskeyRocks, faGlasses, faGlassesAlt, faGlobe, faGlobeAfrica, faGlobeAmericas, faGlobeAsia, faGlobeEurope, faGlobeSnow, faGlobeStand, faGolfBall, faGolfClub, faGopuram, faGraduationCap, faGreaterThan, faGreaterThanEqual, faGrimace, faGrin, faGrinAlt, faGrinBeam, faGrinBeamSweat, faGrinHearts, faGrinSquint, faGrinSquintTears, faGrinStars, faGrinTears, faGrinTongue, faGrinTongueSquint, faGrinTongueWink, faGrinWink, faGripHorizontal, faGripLines, faGripLinesVertical, faGripVertical, faGuitar, faHSquare, faH1, faH2, faH3, faH4, faHamburger, faHammer, faHammerWar, faHamsa, faHandHeart, faHandHolding, faHandHoldingBox, faHandHoldingHeart, faHandHoldingMagic, faHandHoldingSeedling, faHandHoldingUsd, faHandHoldingWater, faHandLizard, faHandMiddleFinger, faHandPaper, faHandPeace, faHandPointDown, faHandPointLeft, faHandPointRight, faHandPointUp, faHandPointer, faHandReceiving, faHandRock, faHandScissors, faHandSpock, faHands, faHandsHeart, faHandsHelping, faHandsUsd, faHandshake, faHandshakeAlt, faHanukiah, faHardHat, faHashtag, faHatChef, faHatSanta, faHatWinter, faHatWitch, faHatWizard, faHaykal, faHdd, faHeadSide, faHeadSideBrain, faHeadSideMedical, faHeadVr, faHeading, faHeadphones, faHeadphonesAlt, faHeadset, faHeart, faHeartBroken, faHeartCircle, faHeartRate, faHeartSquare, faHeartbeat, faHelicopter, faHelmetBattle, faHexagon, faHighlighter, faHiking, faHippo, faHistory, faHockeyMask, faHockeyPuck, faHockeySticks, faHollyBerry, faHome, faHomeAlt, faHomeHeart, faHomeLg, faHomeLgAlt, faHoodCloak, faHorizontalRule, faHorse, faHorseHead, faHospital, faHospitalAlt, faHospitalSymbol, faHospitalUser, faHospitals, faHotTub, faHotdog, faHotel, faHourglass, faHourglassEnd, faHourglassHalf, faHourglassStart, faHouseDamage, faHouseFlood, faHryvnia, faHumidity, faHurricane, faICursor, faIceCream, faIceSkate, faIcicles, faIcons, faIconsAlt, faIdBadge, faIdCard, faIdCardAlt, faIgloo, faImage, faImages, faInbox, faInboxIn, faInboxOut, faIndent, faIndustry, faIndustryAlt, faInfinity, faInfo, faInfoCircle, faInfoSquare, faInhaler, faIntegral, faIntersection, faInventory, faIslandTropical, faItalic, faJackOLantern, faJedi, faJoint, faJournalWhills, faKaaba, faKerning, faKey, faKeySkeleton, faKeyboard, faKeynote, faKhanda, faKidneys, faKiss, faKissBeam, faKissWinkHeart, faKite, faKiwiBird, faKnifeKitchen, faLambda, faLamp, faLandmark, faLandmarkAlt, faLanguage, faLaptop, faLaptopCode, faLaptopMedical, faLaugh, faLaughBeam, faLaughSquint, faLaughWink, faLayerGroup, faLayerMinus, faLayerPlus, faLeaf, faLeafHeart, faLeafMaple, faLeafOak, faLemon, faLessThan, faLessThanEqual, faLevelDown, faLevelDownAlt, faLevelUp, faLevelUpAlt, faLifeRing, faLightbulb, faLightbulbDollar, faLightbulbExclamation, faLightbulbOn, faLightbulbSlash, faLightsHoliday, faLineColumns, faLineHeight, faLink, faLips, faLiraSign, faList, faListAlt, faListOl, faListUl, faLocation, faLocationArrow, faLocationCircle, faLocationSlash, faLock, faLockAlt, faLockOpen, faLockOpenAlt, faLongArrowAltDown, faLongArrowAltLeft, faLongArrowAltRight, faLongArrowAltUp, faLongArrowDown, faLongArrowLeft, faLongArrowRight, faLongArrowUp, faLoveseat, faLowVision, faLuchador, faLuggageCart, faLungs, faMace, faMagic, faMagnet, faMailBulk, faMailbox, faMale, faMandolin, faMap, faMapMarked, faMapMarkedAlt, faMapMarker, faMapMarkerAlt, faMapMarkerAltSlash, faMapMarkerCheck, faMapMarkerEdit, faMapMarkerExclamation, faMapMarkerMinus, faMapMarkerPlus, faMapMarkerQuestion, faMapMarkerSlash, faMapMarkerSmile, faMapMarkerTimes, faMapPin, faMapSigns, faMarker, faMars, faMarsDouble, faMarsStroke, faMarsStrokeH, faMarsStrokeV, faMask, faMeat, faMedal, faMedkit, faMegaphone, faMeh, faMehBlank, faMehRollingEyes, faMemory, faMenorah, faMercury, faMeteor, faMicrochip, faMicrophone, faMicrophoneAlt, faMicrophoneAltSlash, faMicrophoneSlash, faMicroscope, faMindShare, faMinus, faMinusCircle, faMinusHexagon, faMinusOctagon, faMinusSquare, faMistletoe, faMitten, faMobile, faMobileAlt, faMobileAndroid, faMobileAndroidAlt, faMoneyBill, faMoneyBillAlt, faMoneyBillWave, faMoneyBillWaveAlt, faMoneyCheck, faMoneyCheckAlt, faMoneyCheckEdit, faMoneyCheckEditAlt, faMonitorHeartRate, faMonkey, faMonument, faMoon, faMoonCloud, faMoonStars, faMortarPestle, faMosque, faMotorcycle, faMountain, faMountains, faMousePointer, faMug, faMugHot, faMugMarshmallows, faMugTea, faMusic, faNarwhal, faNetworkWired, faNeuter, faNewspaper, faNotEqual, faNotesMedical, faObjectGroup, faObjectUngroup, faOctagon, faOilCan, faOilTemp, faOm, faOmega, faOrnament, faOtter, faOutdent, faOverline, faPageBreak, faPager, faPaintBrush, faPaintBrushAlt, faPaintRoller, faPalette, faPallet, faPalletAlt, faPaperPlane, faPaperclip, faParachuteBox, faParagraph, faParagraphRtl, faParking, faParkingCircle, faParkingCircleSlash, faParkingSlash, faPassport, faPastafarianism, faPaste, faPause, faPauseCircle, faPaw, faPawAlt, faPawClaws, faPeace, faPegasus, faPen, faPenAlt, faPenFancy, faPenNib, faPenSquare, faPencil, faPencilAlt, faPencilPaintbrush, faPencilRuler, faPennant, faPeopleCarry, faPepperHot, faPercent, faPercentage, faPersonBooth, faPersonCarry, faPersonDolly, faPersonDollyEmpty, faPersonSign, faPhone, faPhoneAlt, faPhoneLaptop, faPhoneOffice, faPhonePlus, faPhoneSlash, faPhoneSquare, faPhoneSquareAlt, faPhoneVolume, faPhotoVideo, faPi, faPie, faPig, faPiggyBank, faPills, faPizza, faPizzaSlice, faPlaceOfWorship, faPlane, faPlaneAlt, faPlaneArrival, faPlaneDeparture, faPlay, faPlayCircle, faPlug, faPlus, faPlusCircle, faPlusHexagon, faPlusOctagon, faPlusSquare, faPodcast, faPodium, faPodiumStar, faPoll, faPollH, faPollPeople, faPoo, faPooStorm, faPoop, faPopcorn, faPortrait, faPoundSign, faPowerOff, faPray, faPrayingHands, faPrescription, faPrescriptionBottle, faPrescriptionBottleAlt, faPresentation, faPrint, faPrintSearch, faPrintSlash, faProcedures, faProjectDiagram, faPumpkin, faPuzzlePiece, faQrcode, faQuestion, faQuestionCircle, faQuestionSquare, faQuidditch, faQuoteLeft, faQuoteRight, faQuran, faRabbit, faRabbitFast, faRacquet, faRadiation, faRadiationAlt, faRainbow, faRaindrops, faRam, faRampLoading, faRandom, faReceipt, faRectangleLandscape, faRectanglePortrait, faRectangleWide, faRecycle, faRedo, faRedoAlt, faRegistered, faRemoveFormat, faRepeat, faRepeat1, faRepeat1Alt, faRepeatAlt, faReply, faReplyAll, faRepublican, faRestroom, faRetweet, faRetweetAlt, faRibbon, faRing, faRingsWedding, faRoad, faRobot, faRocket, faRoute, faRouteHighway, faRouteInterstate, faRss, faRssSquare, faRubleSign, faRuler, faRulerCombined, faRulerHorizontal, faRulerTriangle, faRulerVertical, faRunning, faRupeeSign, faRv, faSack, faSackDollar, faSadCry, faSadTear, faSalad, faSandwich, faSatellite, faSatelliteDish, faSausage, faSave, faScalpel, faScalpelPath, faScanner, faScannerKeyboard, faScannerTouchscreen, faScarecrow, faScarf, faSchool, faScrewdriver, faScroll, faScrollOld, faScrubber, faScythe, faSdCard, faSearch, faSearchDollar, faSearchLocation, faSearchMinus, faSearchPlus, faSeedling, faSendBack, faSendBackward, faServer, faShapes, faShare, faShareAll, faShareAlt, faShareAltSquare, faShareSquare, faSheep, faShekelSign, faShield, faShieldAlt, faShieldCheck, faShieldCross, faShip, faShippingFast, faShippingTimed, faShishKebab, faShoePrints, faShoppingBag, faShoppingBasket, faShoppingCart, faShovel, faShovelSnow, faShower, faShredder, faShuttleVan, faShuttlecock, faSickle, faSigma, faSign, faSignIn, faSignInAlt, faSignLanguage, faSignOut, faSignOutAlt, faSignal, faSignal1, faSignal2, faSignal3, faSignal4, faSignalAlt, faSignalAlt1, faSignalAlt2, faSignalAlt3, faSignalAltSlash, faSignalSlash, faSignature, faSimCard, faSitemap, faSkating, faSkeleton, faSkiJump, faSkiLift, faSkiing, faSkiingNordic, faSkull, faSkullCrossbones, faSlash, faSledding, faSleigh, faSlidersH, faSlidersHSquare, faSlidersV, faSlidersVSquare, faSmile, faSmileBeam, faSmilePlus, faSmileWink, faSmog, faSmoke, faSmoking, faSmokingBan, faSms, faSnake, faSnooze, faSnowBlowing, faSnowboarding, faSnowflake, faSnowflakes, faSnowman, faSnowmobile, faSnowplow, faSocks, faSolarPanel, faSort, faSortAlphaDown, faSortAlphaDownAlt, faSortAlphaUp, faSortAlphaUpAlt, faSortAlt, faSortAmountDown, faSortAmountDownAlt, faSortAmountUp, faSortAmountUpAlt, faSortDown, faSortNumericDown, faSortNumericDownAlt, faSortNumericUp, faSortNumericUpAlt, faSortShapesDown, faSortShapesDownAlt, faSortShapesUp, faSortShapesUpAlt, faSortSizeDown, faSortSizeDownAlt, faSortSizeUp, faSortSizeUpAlt, faSortUp, faSoup, faSpa, faSpaceShuttle, faSpade, faSparkles, faSpellCheck, faSpider, faSpiderBlackWidow, faSpiderWeb, faSpinner, faSpinnerThird, faSplotch, faSprayCan, faSquare, faSquareFull, faSquareRoot, faSquareRootAlt, faSquirrel, faStaff, faStamp, faStar, faStarAndCrescent, faStarChristmas, faStarExclamation, faStarHalf, faStarHalfAlt, faStarOfDavid, faStarOfLife, faStars, faSteak, faSteeringWheel, faStepBackward, faStepForward, faStethoscope, faStickyNote, faStocking, faStomach, faStop, faStopCircle, faStopwatch, faStore, faStoreAlt, faStream, faStreetView, faStretcher, faStrikethrough, faStroopwafel, faSubscript, faSubway, faSuitcase, faSuitcaseRolling, faSun, faSunCloud, faSunDust, faSunHaze, faSunglasses, faSunrise, faSunset, faSuperscript, faSurprise, faSwatchbook, faSwimmer, faSwimmingPool, faSword, faSwords, faSynagogue, faSync, faSyncAlt, faSyringe, faTable, faTableTennis, faTablet, faTabletAlt, faTabletAndroid, faTabletAndroidAlt, faTabletRugged, faTablets, faTachometer, faTachometerAlt, faTachometerAltAverage, faTachometerAltFast, faTachometerAltFastest, faTachometerAltSlow, faTachometerAltSlowest, faTachometerAverage, faTachometerFast, faTachometerFastest, faTachometerSlow, faTachometerSlowest, faTaco, faTag, faTags, faTally, faTanakh, faTape, faTasks, faTasksAlt, faTaxi, faTeeth, faTeethOpen, faTemperatureFrigid, faTemperatureHigh, faTemperatureHot, faTemperatureLow, faTenge, faTennisBall, faTerminal, faText, faTextHeight, faTextSize, faTextWidth, faTh, faThLarge, faThList, faTheaterMasks, faThermometer, faThermometerEmpty, faThermometerFull, faThermometerHalf, faThermometerQuarter, faThermometerThreeQuarters, faTheta, faThumbsDown, faThumbsUp, faThumbtack, faThunderstorm, faThunderstormMoon, faThunderstormSun, faTicket, faTicketAlt, faTilde, faTimes, faTimesCircle, faTimesHexagon, faTimesOctagon, faTimesSquare, faTint, faTintSlash, faTire, faTireFlat, faTirePressureWarning, faTireRugged, faTired, faToggleOff, faToggleOn, faToilet, faToiletPaper, faToiletPaperAlt, faTombstone, faTombstoneAlt, faToolbox, faTools, faTooth, faToothbrush, faTorah, faToriiGate, faTornado, faTractor, faTrademark, faTrafficCone, faTrafficLight, faTrafficLightGo, faTrafficLightSlow, faTrafficLightStop, faTrain, faTram, faTransgender, faTransgenderAlt, faTrash, faTrashAlt, faTrashRestore, faTrashRestoreAlt, faTrashUndo, faTrashUndoAlt, faTreasureChest, faTree, faTreeAlt, faTreeChristmas, faTreeDecorated, faTreeLarge, faTreePalm, faTrees, faTriangle, faTrophy, faTrophyAlt, faTruck, faTruckContainer, faTruckCouch, faTruckLoading, faTruckMonster, faTruckMoving, faTruckPickup, faTruckPlow, faTruckRamp, faTshirt, faTty, faTurkey, faTurtle, faTv, faTvRetro, faUmbrella, faUmbrellaBeach, faUnderline, faUndo, faUndoAlt, faUnicorn, faUnion, faUniversalAccess, faUniversity, faUnlink, faUnlock, faUnlockAlt, faUpload, faUsdCircle, faUsdSquare, faUser, faUserAlt, faUserAltSlash, faUserAstronaut, faUserChart, faUserCheck, faUserCircle, faUserClock, faUserCog, faUserCrown, faUserEdit, faUserFriends, faUserGraduate, faUserHardHat, faUserHeadset, faUserInjured, faUserLock, faUserMd, faUserMdChat, faUserMinus, faUserNinja, faUserNurse, faUserPlus, faUserSecret, faUserShield, faUserSlash, faUserTag, faUserTie, faUserTimes, faUsers, faUsersClass, faUsersCog, faUsersCrown, faUsersMedical, faUtensilFork, faUtensilKnife, faUtensilSpoon, faUtensils, faUtensilsAlt, faValueAbsolute, faVectorSquare, faVenus, faVenusDouble, faVenusMars, faVial, faVials, faVideo, faVideoPlus, faVideoSlash, faVihara, faVoicemail, faVolcano, faVolleyballBall, faVolume, faVolumeDown, faVolumeMute, faVolumeOff, faVolumeSlash, faVolumeUp, faVoteNay, faVoteYea, faVrCardboard, faWalker, faWalking, faWallet, faWand, faWandMagic, faWarehouse, faWarehouseAlt, faWasher, faWatch, faWatchFitness, faWater, faWaterLower, faWaterRise, faWaveSine, faWaveSquare, faWaveTriangle, faWebcam, faWebcamSlash, faWeight, faWeightHanging, faWhale, faWheat, faWheelchair, faWhistle, faWifi, faWifi1, faWifi2, faWifiSlash, faWind, faWindTurbine, faWindWarning, faWindow, faWindowAlt, faWindowClose, faWindowMaximize, faWindowMinimize, faWindowRestore, faWindsock, faWineBottle, faWineGlass, faWineGlassAlt, faWonSign, faWreath, faWrench, faXRay, faYenSign, faYinYang */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "far", function() { return _iconsCache; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "prefix", function() { return prefix; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAbacus", function() { return faAbacus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAcorn", function() { return faAcorn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAd", function() { return faAd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAddressBook", function() { return faAddressBook; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAddressCard", function() { return faAddressCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAdjust", function() { return faAdjust; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAirFreshener", function() { return faAirFreshener; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlarmClock", function() { return faAlarmClock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlarmExclamation", function() { return faAlarmExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlarmPlus", function() { return faAlarmPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlarmSnooze", function() { return faAlarmSnooze; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlicorn", function() { return faAlicorn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlignCenter", function() { return faAlignCenter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlignJustify", function() { return faAlignJustify; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlignLeft", function() { return faAlignLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlignRight", function() { return faAlignRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAlignSlash", function() { return faAlignSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAllergies", function() { return faAllergies; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAmbulance", function() { return faAmbulance; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAmericanSignLanguageInterpreting", function() { return faAmericanSignLanguageInterpreting; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAnalytics", function() { return faAnalytics; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAnchor", function() { return faAnchor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngel", function() { return faAngel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngleDoubleDown", function() { return faAngleDoubleDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngleDoubleLeft", function() { return faAngleDoubleLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngleDoubleRight", function() { return faAngleDoubleRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngleDoubleUp", function() { return faAngleDoubleUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngleDown", function() { return faAngleDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngleLeft", function() { return faAngleLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngleRight", function() { return faAngleRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngleUp", function() { return faAngleUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAngry", function() { return faAngry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAnkh", function() { return faAnkh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAppleAlt", function() { return faAppleAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAppleCrate", function() { return faAppleCrate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArchive", function() { return faArchive; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArchway", function() { return faArchway; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltCircleDown", function() { return faArrowAltCircleDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltCircleLeft", function() { return faArrowAltCircleLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltCircleRight", function() { return faArrowAltCircleRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltCircleUp", function() { return faArrowAltCircleUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltDown", function() { return faArrowAltDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltFromBottom", function() { return faArrowAltFromBottom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltFromLeft", function() { return faArrowAltFromLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltFromRight", function() { return faArrowAltFromRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltFromTop", function() { return faArrowAltFromTop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltLeft", function() { return faArrowAltLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltRight", function() { return faArrowAltRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltSquareDown", function() { return faArrowAltSquareDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltSquareLeft", function() { return faArrowAltSquareLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltSquareRight", function() { return faArrowAltSquareRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltSquareUp", function() { return faArrowAltSquareUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltToBottom", function() { return faArrowAltToBottom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltToLeft", function() { return faArrowAltToLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltToRight", function() { return faArrowAltToRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltToTop", function() { return faArrowAltToTop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowAltUp", function() { return faArrowAltUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowCircleDown", function() { return faArrowCircleDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowCircleLeft", function() { return faArrowCircleLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowCircleRight", function() { return faArrowCircleRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowCircleUp", function() { return faArrowCircleUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowDown", function() { return faArrowDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowFromBottom", function() { return faArrowFromBottom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowFromLeft", function() { return faArrowFromLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowFromRight", function() { return faArrowFromRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowFromTop", function() { return faArrowFromTop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowLeft", function() { return faArrowLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowRight", function() { return faArrowRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowSquareDown", function() { return faArrowSquareDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowSquareLeft", function() { return faArrowSquareLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowSquareRight", function() { return faArrowSquareRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowSquareUp", function() { return faArrowSquareUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowToBottom", function() { return faArrowToBottom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowToLeft", function() { return faArrowToLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowToRight", function() { return faArrowToRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowToTop", function() { return faArrowToTop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowUp", function() { return faArrowUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrows", function() { return faArrows; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowsAlt", function() { return faArrowsAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowsAltH", function() { return faArrowsAltH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowsAltV", function() { return faArrowsAltV; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowsH", function() { return faArrowsH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faArrowsV", function() { return faArrowsV; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAssistiveListeningSystems", function() { return faAssistiveListeningSystems; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAsterisk", function() { return faAsterisk; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAt", function() { return faAt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAtlas", function() { return faAtlas; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAtom", function() { return faAtom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAtomAlt", function() { return faAtomAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAudioDescription", function() { return faAudioDescription; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAward", function() { return faAward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAxe", function() { return faAxe; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faAxeBattle", function() { return faAxeBattle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBaby", function() { return faBaby; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBabyCarriage", function() { return faBabyCarriage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBackpack", function() { return faBackpack; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBackspace", function() { return faBackspace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBackward", function() { return faBackward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBacon", function() { return faBacon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBadge", function() { return faBadge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBadgeCheck", function() { return faBadgeCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBadgeDollar", function() { return faBadgeDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBadgePercent", function() { return faBadgePercent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBadgerHoney", function() { return faBadgerHoney; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBagsShopping", function() { return faBagsShopping; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBalanceScale", function() { return faBalanceScale; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBalanceScaleLeft", function() { return faBalanceScaleLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBalanceScaleRight", function() { return faBalanceScaleRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBallPile", function() { return faBallPile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBallot", function() { return faBallot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBallotCheck", function() { return faBallotCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBan", function() { return faBan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBandAid", function() { return faBandAid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBarcode", function() { return faBarcode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBarcodeAlt", function() { return faBarcodeAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBarcodeRead", function() { return faBarcodeRead; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBarcodeScan", function() { return faBarcodeScan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBars", function() { return faBars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBaseball", function() { return faBaseball; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBaseballBall", function() { return faBaseballBall; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBasketballBall", function() { return faBasketballBall; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBasketballHoop", function() { return faBasketballHoop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBat", function() { return faBat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBath", function() { return faBath; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBatteryBolt", function() { return faBatteryBolt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBatteryEmpty", function() { return faBatteryEmpty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBatteryFull", function() { return faBatteryFull; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBatteryHalf", function() { return faBatteryHalf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBatteryQuarter", function() { return faBatteryQuarter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBatterySlash", function() { return faBatterySlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBatteryThreeQuarters", function() { return faBatteryThreeQuarters; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBed", function() { return faBed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBeer", function() { return faBeer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBell", function() { return faBell; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBellExclamation", function() { return faBellExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBellPlus", function() { return faBellPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBellSchool", function() { return faBellSchool; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBellSchoolSlash", function() { return faBellSchoolSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBellSlash", function() { return faBellSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBells", function() { return faBells; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBezierCurve", function() { return faBezierCurve; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBible", function() { return faBible; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBicycle", function() { return faBicycle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBiking", function() { return faBiking; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBikingMountain", function() { return faBikingMountain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBinoculars", function() { return faBinoculars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBiohazard", function() { return faBiohazard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBirthdayCake", function() { return faBirthdayCake; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBlanket", function() { return faBlanket; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBlender", function() { return faBlender; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBlenderPhone", function() { return faBlenderPhone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBlind", function() { return faBlind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBlog", function() { return faBlog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBold", function() { return faBold; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBolt", function() { return faBolt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBomb", function() { return faBomb; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBone", function() { return faBone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoneBreak", function() { return faBoneBreak; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBong", function() { return faBong; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBook", function() { return faBook; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookAlt", function() { return faBookAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookDead", function() { return faBookDead; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookHeart", function() { return faBookHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookMedical", function() { return faBookMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookOpen", function() { return faBookOpen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookReader", function() { return faBookReader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookSpells", function() { return faBookSpells; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookUser", function() { return faBookUser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBookmark", function() { return faBookmark; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBooks", function() { return faBooks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBooksMedical", function() { return faBooksMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoot", function() { return faBoot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoothCurtain", function() { return faBoothCurtain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderAll", function() { return faBorderAll; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderBottom", function() { return faBorderBottom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderInner", function() { return faBorderInner; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderLeft", function() { return faBorderLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderNone", function() { return faBorderNone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderOuter", function() { return faBorderOuter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderRight", function() { return faBorderRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderStyle", function() { return faBorderStyle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderStyleAlt", function() { return faBorderStyleAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBorderTop", function() { return faBorderTop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBowArrow", function() { return faBowArrow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBowlingBall", function() { return faBowlingBall; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBowlingPins", function() { return faBowlingPins; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBox", function() { return faBox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxAlt", function() { return faBoxAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxBallot", function() { return faBoxBallot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxCheck", function() { return faBoxCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxFragile", function() { return faBoxFragile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxFull", function() { return faBoxFull; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxHeart", function() { return faBoxHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxOpen", function() { return faBoxOpen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxUp", function() { return faBoxUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxUsd", function() { return faBoxUsd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxes", function() { return faBoxes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxesAlt", function() { return faBoxesAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBoxingGlove", function() { return faBoxingGlove; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBrackets", function() { return faBrackets; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBracketsCurly", function() { return faBracketsCurly; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBraille", function() { return faBraille; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBrain", function() { return faBrain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBreadLoaf", function() { return faBreadLoaf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBreadSlice", function() { return faBreadSlice; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBriefcase", function() { return faBriefcase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBriefcaseMedical", function() { return faBriefcaseMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBringForward", function() { return faBringForward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBringFront", function() { return faBringFront; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBroadcastTower", function() { return faBroadcastTower; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBroom", function() { return faBroom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBrowser", function() { return faBrowser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBrush", function() { return faBrush; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBug", function() { return faBug; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBuilding", function() { return faBuilding; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBullhorn", function() { return faBullhorn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBullseye", function() { return faBullseye; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBullseyeArrow", function() { return faBullseyeArrow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBullseyePointer", function() { return faBullseyePointer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBurgerSoda", function() { return faBurgerSoda; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBurn", function() { return faBurn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBurrito", function() { return faBurrito; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBus", function() { return faBus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBusAlt", function() { return faBusAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBusSchool", function() { return faBusSchool; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faBusinessTime", function() { return faBusinessTime; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCabinetFiling", function() { return faCabinetFiling; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalculator", function() { return faCalculator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalculatorAlt", function() { return faCalculatorAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendar", function() { return faCalendar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarAlt", function() { return faCalendarAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarCheck", function() { return faCalendarCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarDay", function() { return faCalendarDay; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarEdit", function() { return faCalendarEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarExclamation", function() { return faCalendarExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarMinus", function() { return faCalendarMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarPlus", function() { return faCalendarPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarStar", function() { return faCalendarStar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarTimes", function() { return faCalendarTimes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCalendarWeek", function() { return faCalendarWeek; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCamera", function() { return faCamera; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCameraAlt", function() { return faCameraAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCameraRetro", function() { return faCameraRetro; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCampfire", function() { return faCampfire; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCampground", function() { return faCampground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCandleHolder", function() { return faCandleHolder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCandyCane", function() { return faCandyCane; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCandyCorn", function() { return faCandyCorn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCannabis", function() { return faCannabis; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCapsules", function() { return faCapsules; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCar", function() { return faCar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarAlt", function() { return faCarAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarBattery", function() { return faCarBattery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarBuilding", function() { return faCarBuilding; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarBump", function() { return faCarBump; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarBus", function() { return faCarBus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarCrash", function() { return faCarCrash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarGarage", function() { return faCarGarage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarMechanic", function() { return faCarMechanic; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarSide", function() { return faCarSide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarTilt", function() { return faCarTilt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarWash", function() { return faCarWash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretCircleDown", function() { return faCaretCircleDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretCircleLeft", function() { return faCaretCircleLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretCircleRight", function() { return faCaretCircleRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretCircleUp", function() { return faCaretCircleUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretDown", function() { return faCaretDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretLeft", function() { return faCaretLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretRight", function() { return faCaretRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretSquareDown", function() { return faCaretSquareDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretSquareLeft", function() { return faCaretSquareLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretSquareRight", function() { return faCaretSquareRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretSquareUp", function() { return faCaretSquareUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCaretUp", function() { return faCaretUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCarrot", function() { return faCarrot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCars", function() { return faCars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCartArrowDown", function() { return faCartArrowDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCartPlus", function() { return faCartPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCashRegister", function() { return faCashRegister; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCat", function() { return faCat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCauldron", function() { return faCauldron; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCertificate", function() { return faCertificate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChair", function() { return faChair; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChairOffice", function() { return faChairOffice; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChalkboard", function() { return faChalkboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChalkboardTeacher", function() { return faChalkboardTeacher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChargingStation", function() { return faChargingStation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChartArea", function() { return faChartArea; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChartBar", function() { return faChartBar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChartLine", function() { return faChartLine; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChartLineDown", function() { return faChartLineDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChartNetwork", function() { return faChartNetwork; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChartPie", function() { return faChartPie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChartPieAlt", function() { return faChartPieAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChartScatter", function() { return faChartScatter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCheck", function() { return faCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCheckCircle", function() { return faCheckCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCheckDouble", function() { return faCheckDouble; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCheckSquare", function() { return faCheckSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCheese", function() { return faCheese; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCheeseSwiss", function() { return faCheeseSwiss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCheeseburger", function() { return faCheeseburger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChess", function() { return faChess; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessBishop", function() { return faChessBishop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessBishopAlt", function() { return faChessBishopAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessBoard", function() { return faChessBoard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessClock", function() { return faChessClock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessClockAlt", function() { return faChessClockAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessKing", function() { return faChessKing; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessKingAlt", function() { return faChessKingAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessKnight", function() { return faChessKnight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessKnightAlt", function() { return faChessKnightAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessPawn", function() { return faChessPawn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessPawnAlt", function() { return faChessPawnAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessQueen", function() { return faChessQueen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessQueenAlt", function() { return faChessQueenAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessRook", function() { return faChessRook; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChessRookAlt", function() { return faChessRookAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronCircleDown", function() { return faChevronCircleDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronCircleLeft", function() { return faChevronCircleLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronCircleRight", function() { return faChevronCircleRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronCircleUp", function() { return faChevronCircleUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronDoubleDown", function() { return faChevronDoubleDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronDoubleLeft", function() { return faChevronDoubleLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronDoubleRight", function() { return faChevronDoubleRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronDoubleUp", function() { return faChevronDoubleUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronDown", function() { return faChevronDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronLeft", function() { return faChevronLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronRight", function() { return faChevronRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronSquareDown", function() { return faChevronSquareDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronSquareLeft", function() { return faChevronSquareLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronSquareRight", function() { return faChevronSquareRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronSquareUp", function() { return faChevronSquareUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChevronUp", function() { return faChevronUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChild", function() { return faChild; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChimney", function() { return faChimney; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faChurch", function() { return faChurch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCircle", function() { return faCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCircleNotch", function() { return faCircleNotch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCity", function() { return faCity; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClawMarks", function() { return faClawMarks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClinicMedical", function() { return faClinicMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClipboard", function() { return faClipboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClipboardCheck", function() { return faClipboardCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClipboardList", function() { return faClipboardList; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClipboardListCheck", function() { return faClipboardListCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClipboardPrescription", function() { return faClipboardPrescription; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClipboardUser", function() { return faClipboardUser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClock", function() { return faClock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClone", function() { return faClone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClosedCaptioning", function() { return faClosedCaptioning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloud", function() { return faCloud; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudDownload", function() { return faCloudDownload; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudDownloadAlt", function() { return faCloudDownloadAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudDrizzle", function() { return faCloudDrizzle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudHail", function() { return faCloudHail; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudHailMixed", function() { return faCloudHailMixed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudMeatball", function() { return faCloudMeatball; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudMoon", function() { return faCloudMoon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudMoonRain", function() { return faCloudMoonRain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudRain", function() { return faCloudRain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudRainbow", function() { return faCloudRainbow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudShowers", function() { return faCloudShowers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudShowersHeavy", function() { return faCloudShowersHeavy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudSleet", function() { return faCloudSleet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudSnow", function() { return faCloudSnow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudSun", function() { return faCloudSun; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudSunRain", function() { return faCloudSunRain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudUpload", function() { return faCloudUpload; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudUploadAlt", function() { return faCloudUploadAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClouds", function() { return faClouds; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudsMoon", function() { return faCloudsMoon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCloudsSun", function() { return faCloudsSun; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faClub", function() { return faClub; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCocktail", function() { return faCocktail; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCode", function() { return faCode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCodeBranch", function() { return faCodeBranch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCodeCommit", function() { return faCodeCommit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCodeMerge", function() { return faCodeMerge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCoffee", function() { return faCoffee; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCoffeeTogo", function() { return faCoffeeTogo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCoffin", function() { return faCoffin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCog", function() { return faCog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCogs", function() { return faCogs; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCoin", function() { return faCoin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCoins", function() { return faCoins; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faColumns", function() { return faColumns; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faComment", function() { return faComment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAlt", function() { return faCommentAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltCheck", function() { return faCommentAltCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltDollar", function() { return faCommentAltDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltDots", function() { return faCommentAltDots; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltEdit", function() { return faCommentAltEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltExclamation", function() { return faCommentAltExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltLines", function() { return faCommentAltLines; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltMedical", function() { return faCommentAltMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltMinus", function() { return faCommentAltMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltPlus", function() { return faCommentAltPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltSlash", function() { return faCommentAltSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltSmile", function() { return faCommentAltSmile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentAltTimes", function() { return faCommentAltTimes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentCheck", function() { return faCommentCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentDollar", function() { return faCommentDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentDots", function() { return faCommentDots; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentEdit", function() { return faCommentEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentExclamation", function() { return faCommentExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentLines", function() { return faCommentLines; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentMedical", function() { return faCommentMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentMinus", function() { return faCommentMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentPlus", function() { return faCommentPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentSlash", function() { return faCommentSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentSmile", function() { return faCommentSmile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentTimes", function() { return faCommentTimes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faComments", function() { return faComments; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentsAlt", function() { return faCommentsAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentsAltDollar", function() { return faCommentsAltDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCommentsDollar", function() { return faCommentsDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCompactDisc", function() { return faCompactDisc; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCompass", function() { return faCompass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCompassSlash", function() { return faCompassSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCompress", function() { return faCompress; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCompressAlt", function() { return faCompressAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCompressArrowsAlt", function() { return faCompressArrowsAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCompressWide", function() { return faCompressWide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faConciergeBell", function() { return faConciergeBell; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faConstruction", function() { return faConstruction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faContainerStorage", function() { return faContainerStorage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faConveyorBelt", function() { return faConveyorBelt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faConveyorBeltAlt", function() { return faConveyorBeltAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCookie", function() { return faCookie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCookieBite", function() { return faCookieBite; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCopy", function() { return faCopy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCopyright", function() { return faCopyright; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCorn", function() { return faCorn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCouch", function() { return faCouch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCow", function() { return faCow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCreditCard", function() { return faCreditCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCreditCardBlank", function() { return faCreditCardBlank; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCreditCardFront", function() { return faCreditCardFront; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCricket", function() { return faCricket; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCroissant", function() { return faCroissant; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCrop", function() { return faCrop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCropAlt", function() { return faCropAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCross", function() { return faCross; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCrosshairs", function() { return faCrosshairs; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCrow", function() { return faCrow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCrown", function() { return faCrown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCrutch", function() { return faCrutch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCrutches", function() { return faCrutches; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCube", function() { return faCube; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCubes", function() { return faCubes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCurling", function() { return faCurling; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faCut", function() { return faCut; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDagger", function() { return faDagger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDatabase", function() { return faDatabase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDeaf", function() { return faDeaf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDebug", function() { return faDebug; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDeer", function() { return faDeer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDeerRudolph", function() { return faDeerRudolph; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDemocrat", function() { return faDemocrat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDesktop", function() { return faDesktop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDesktopAlt", function() { return faDesktopAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDewpoint", function() { return faDewpoint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDharmachakra", function() { return faDharmachakra; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiagnoses", function() { return faDiagnoses; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiamond", function() { return faDiamond; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDice", function() { return faDice; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceD10", function() { return faDiceD10; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceD12", function() { return faDiceD12; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceD20", function() { return faDiceD20; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceD4", function() { return faDiceD4; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceD6", function() { return faDiceD6; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceD8", function() { return faDiceD8; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceFive", function() { return faDiceFive; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceFour", function() { return faDiceFour; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceOne", function() { return faDiceOne; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceSix", function() { return faDiceSix; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceThree", function() { return faDiceThree; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiceTwo", function() { return faDiceTwo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDigging", function() { return faDigging; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDigitalTachograph", function() { return faDigitalTachograph; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDiploma", function() { return faDiploma; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDirections", function() { return faDirections; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDisease", function() { return faDisease; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDivide", function() { return faDivide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDizzy", function() { return faDizzy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDna", function() { return faDna; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDoNotEnter", function() { return faDoNotEnter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDog", function() { return faDog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDogLeashed", function() { return faDogLeashed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDollarSign", function() { return faDollarSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDolly", function() { return faDolly; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDollyEmpty", function() { return faDollyEmpty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDollyFlatbed", function() { return faDollyFlatbed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDollyFlatbedAlt", function() { return faDollyFlatbedAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDollyFlatbedEmpty", function() { return faDollyFlatbedEmpty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDonate", function() { return faDonate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDoorClosed", function() { return faDoorClosed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDoorOpen", function() { return faDoorOpen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDotCircle", function() { return faDotCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDove", function() { return faDove; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDownload", function() { return faDownload; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDraftingCompass", function() { return faDraftingCompass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDragon", function() { return faDragon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDrawCircle", function() { return faDrawCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDrawPolygon", function() { return faDrawPolygon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDrawSquare", function() { return faDrawSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDreidel", function() { return faDreidel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDrone", function() { return faDrone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDroneAlt", function() { return faDroneAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDrum", function() { return faDrum; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDrumSteelpan", function() { return faDrumSteelpan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDrumstick", function() { return faDrumstick; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDrumstickBite", function() { return faDrumstickBite; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDryer", function() { return faDryer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDryerAlt", function() { return faDryerAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDuck", function() { return faDuck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDumbbell", function() { return faDumbbell; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDumpster", function() { return faDumpster; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDumpsterFire", function() { return faDumpsterFire; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faDungeon", function() { return faDungeon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEar", function() { return faEar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEarMuffs", function() { return faEarMuffs; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEclipse", function() { return faEclipse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEclipseAlt", function() { return faEclipseAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEdit", function() { return faEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEgg", function() { return faEgg; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEggFried", function() { return faEggFried; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEject", function() { return faEject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faElephant", function() { return faElephant; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEllipsisH", function() { return faEllipsisH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEllipsisHAlt", function() { return faEllipsisHAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEllipsisV", function() { return faEllipsisV; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEllipsisVAlt", function() { return faEllipsisVAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEmptySet", function() { return faEmptySet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEngineWarning", function() { return faEngineWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEnvelope", function() { return faEnvelope; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEnvelopeOpen", function() { return faEnvelopeOpen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEnvelopeOpenDollar", function() { return faEnvelopeOpenDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEnvelopeOpenText", function() { return faEnvelopeOpenText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEnvelopeSquare", function() { return faEnvelopeSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEquals", function() { return faEquals; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEraser", function() { return faEraser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEthernet", function() { return faEthernet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEuroSign", function() { return faEuroSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExchange", function() { return faExchange; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExchangeAlt", function() { return faExchangeAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExclamation", function() { return faExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExclamationCircle", function() { return faExclamationCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExclamationSquare", function() { return faExclamationSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExclamationTriangle", function() { return faExclamationTriangle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExpand", function() { return faExpand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExpandAlt", function() { return faExpandAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExpandArrows", function() { return faExpandArrows; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExpandArrowsAlt", function() { return faExpandArrowsAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExpandWide", function() { return faExpandWide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExternalLink", function() { return faExternalLink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExternalLinkAlt", function() { return faExternalLinkAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExternalLinkSquare", function() { return faExternalLinkSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faExternalLinkSquareAlt", function() { return faExternalLinkSquareAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEye", function() { return faEye; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEyeDropper", function() { return faEyeDropper; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEyeEvil", function() { return faEyeEvil; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faEyeSlash", function() { return faEyeSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFan", function() { return faFan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFarm", function() { return faFarm; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFastBackward", function() { return faFastBackward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFastForward", function() { return faFastForward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFax", function() { return faFax; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFeather", function() { return faFeather; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFeatherAlt", function() { return faFeatherAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFemale", function() { return faFemale; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFieldHockey", function() { return faFieldHockey; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFighterJet", function() { return faFighterJet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFile", function() { return faFile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileAlt", function() { return faFileAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileArchive", function() { return faFileArchive; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileAudio", function() { return faFileAudio; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileCertificate", function() { return faFileCertificate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileChartLine", function() { return faFileChartLine; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileChartPie", function() { return faFileChartPie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileCheck", function() { return faFileCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileCode", function() { return faFileCode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileContract", function() { return faFileContract; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileCsv", function() { return faFileCsv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileDownload", function() { return faFileDownload; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileEdit", function() { return faFileEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileExcel", function() { return faFileExcel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileExclamation", function() { return faFileExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileExport", function() { return faFileExport; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileImage", function() { return faFileImage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileImport", function() { return faFileImport; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileInvoice", function() { return faFileInvoice; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileInvoiceDollar", function() { return faFileInvoiceDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileMedical", function() { return faFileMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileMedicalAlt", function() { return faFileMedicalAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileMinus", function() { return faFileMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFilePdf", function() { return faFilePdf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFilePlus", function() { return faFilePlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFilePowerpoint", function() { return faFilePowerpoint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFilePrescription", function() { return faFilePrescription; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileSearch", function() { return faFileSearch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileSignature", function() { return faFileSignature; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileSpreadsheet", function() { return faFileSpreadsheet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileTimes", function() { return faFileTimes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileUpload", function() { return faFileUpload; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileUser", function() { return faFileUser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileVideo", function() { return faFileVideo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFileWord", function() { return faFileWord; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFilesMedical", function() { return faFilesMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFill", function() { return faFill; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFillDrip", function() { return faFillDrip; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFilm", function() { return faFilm; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFilmAlt", function() { return faFilmAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFilter", function() { return faFilter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFingerprint", function() { return faFingerprint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFire", function() { return faFire; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFireAlt", function() { return faFireAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFireExtinguisher", function() { return faFireExtinguisher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFireSmoke", function() { return faFireSmoke; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFireplace", function() { return faFireplace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFirstAid", function() { return faFirstAid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFish", function() { return faFish; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFishCooked", function() { return faFishCooked; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFistRaised", function() { return faFistRaised; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlag", function() { return faFlag; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlagAlt", function() { return faFlagAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlagCheckered", function() { return faFlagCheckered; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlagUsa", function() { return faFlagUsa; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlame", function() { return faFlame; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlask", function() { return faFlask; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlaskPoison", function() { return faFlaskPoison; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlaskPotion", function() { return faFlaskPotion; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlower", function() { return faFlower; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlowerDaffodil", function() { return faFlowerDaffodil; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlowerTulip", function() { return faFlowerTulip; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFlushed", function() { return faFlushed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFog", function() { return faFog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFolder", function() { return faFolder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFolderMinus", function() { return faFolderMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFolderOpen", function() { return faFolderOpen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFolderPlus", function() { return faFolderPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFolderTimes", function() { return faFolderTimes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFolderTree", function() { return faFolderTree; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFolders", function() { return faFolders; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFont", function() { return faFont; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFontAwesomeLogoFull", function() { return faFontAwesomeLogoFull; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFontCase", function() { return faFontCase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFootballBall", function() { return faFootballBall; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFootballHelmet", function() { return faFootballHelmet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faForklift", function() { return faForklift; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faForward", function() { return faForward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFragile", function() { return faFragile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFrenchFries", function() { return faFrenchFries; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFrog", function() { return faFrog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFrostyHead", function() { return faFrostyHead; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFrown", function() { return faFrown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFrownOpen", function() { return faFrownOpen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFunction", function() { return faFunction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFunnelDollar", function() { return faFunnelDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faFutbol", function() { return faFutbol; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGameBoard", function() { return faGameBoard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGameBoardAlt", function() { return faGameBoardAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGamepad", function() { return faGamepad; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGasPump", function() { return faGasPump; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGasPumpSlash", function() { return faGasPumpSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGavel", function() { return faGavel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGem", function() { return faGem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGenderless", function() { return faGenderless; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGhost", function() { return faGhost; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGift", function() { return faGift; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGiftCard", function() { return faGiftCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGifts", function() { return faGifts; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGingerbreadMan", function() { return faGingerbreadMan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlass", function() { return faGlass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlassChampagne", function() { return faGlassChampagne; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlassCheers", function() { return faGlassCheers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlassCitrus", function() { return faGlassCitrus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlassMartini", function() { return faGlassMartini; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlassMartiniAlt", function() { return faGlassMartiniAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlassWhiskey", function() { return faGlassWhiskey; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlassWhiskeyRocks", function() { return faGlassWhiskeyRocks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlasses", function() { return faGlasses; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlassesAlt", function() { return faGlassesAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlobe", function() { return faGlobe; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlobeAfrica", function() { return faGlobeAfrica; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlobeAmericas", function() { return faGlobeAmericas; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlobeAsia", function() { return faGlobeAsia; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlobeEurope", function() { return faGlobeEurope; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlobeSnow", function() { return faGlobeSnow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGlobeStand", function() { return faGlobeStand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGolfBall", function() { return faGolfBall; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGolfClub", function() { return faGolfClub; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGopuram", function() { return faGopuram; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGraduationCap", function() { return faGraduationCap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGreaterThan", function() { return faGreaterThan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGreaterThanEqual", function() { return faGreaterThanEqual; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrimace", function() { return faGrimace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrin", function() { return faGrin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinAlt", function() { return faGrinAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinBeam", function() { return faGrinBeam; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinBeamSweat", function() { return faGrinBeamSweat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinHearts", function() { return faGrinHearts; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinSquint", function() { return faGrinSquint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinSquintTears", function() { return faGrinSquintTears; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinStars", function() { return faGrinStars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinTears", function() { return faGrinTears; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinTongue", function() { return faGrinTongue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinTongueSquint", function() { return faGrinTongueSquint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinTongueWink", function() { return faGrinTongueWink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGrinWink", function() { return faGrinWink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGripHorizontal", function() { return faGripHorizontal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGripLines", function() { return faGripLines; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGripLinesVertical", function() { return faGripLinesVertical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGripVertical", function() { return faGripVertical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faGuitar", function() { return faGuitar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHSquare", function() { return faHSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faH1", function() { return faH1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faH2", function() { return faH2; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faH3", function() { return faH3; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faH4", function() { return faH4; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHamburger", function() { return faHamburger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHammer", function() { return faHammer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHammerWar", function() { return faHammerWar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHamsa", function() { return faHamsa; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandHeart", function() { return faHandHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandHolding", function() { return faHandHolding; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandHoldingBox", function() { return faHandHoldingBox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandHoldingHeart", function() { return faHandHoldingHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandHoldingMagic", function() { return faHandHoldingMagic; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandHoldingSeedling", function() { return faHandHoldingSeedling; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandHoldingUsd", function() { return faHandHoldingUsd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandHoldingWater", function() { return faHandHoldingWater; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandLizard", function() { return faHandLizard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandMiddleFinger", function() { return faHandMiddleFinger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandPaper", function() { return faHandPaper; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandPeace", function() { return faHandPeace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandPointDown", function() { return faHandPointDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandPointLeft", function() { return faHandPointLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandPointRight", function() { return faHandPointRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandPointUp", function() { return faHandPointUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandPointer", function() { return faHandPointer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandReceiving", function() { return faHandReceiving; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandRock", function() { return faHandRock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandScissors", function() { return faHandScissors; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandSpock", function() { return faHandSpock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHands", function() { return faHands; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandsHeart", function() { return faHandsHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandsHelping", function() { return faHandsHelping; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandsUsd", function() { return faHandsUsd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandshake", function() { return faHandshake; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHandshakeAlt", function() { return faHandshakeAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHanukiah", function() { return faHanukiah; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHardHat", function() { return faHardHat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHashtag", function() { return faHashtag; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHatChef", function() { return faHatChef; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHatSanta", function() { return faHatSanta; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHatWinter", function() { return faHatWinter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHatWitch", function() { return faHatWitch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHatWizard", function() { return faHatWizard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHaykal", function() { return faHaykal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHdd", function() { return faHdd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeadSide", function() { return faHeadSide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeadSideBrain", function() { return faHeadSideBrain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeadSideMedical", function() { return faHeadSideMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeadVr", function() { return faHeadVr; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeading", function() { return faHeading; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeadphones", function() { return faHeadphones; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeadphonesAlt", function() { return faHeadphonesAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeadset", function() { return faHeadset; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeart", function() { return faHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeartBroken", function() { return faHeartBroken; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeartCircle", function() { return faHeartCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeartRate", function() { return faHeartRate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeartSquare", function() { return faHeartSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHeartbeat", function() { return faHeartbeat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHelicopter", function() { return faHelicopter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHelmetBattle", function() { return faHelmetBattle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHexagon", function() { return faHexagon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHighlighter", function() { return faHighlighter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHiking", function() { return faHiking; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHippo", function() { return faHippo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHistory", function() { return faHistory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHockeyMask", function() { return faHockeyMask; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHockeyPuck", function() { return faHockeyPuck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHockeySticks", function() { return faHockeySticks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHollyBerry", function() { return faHollyBerry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHome", function() { return faHome; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHomeAlt", function() { return faHomeAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHomeHeart", function() { return faHomeHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHomeLg", function() { return faHomeLg; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHomeLgAlt", function() { return faHomeLgAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHoodCloak", function() { return faHoodCloak; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHorizontalRule", function() { return faHorizontalRule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHorse", function() { return faHorse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHorseHead", function() { return faHorseHead; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHospital", function() { return faHospital; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHospitalAlt", function() { return faHospitalAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHospitalSymbol", function() { return faHospitalSymbol; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHospitalUser", function() { return faHospitalUser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHospitals", function() { return faHospitals; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHotTub", function() { return faHotTub; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHotdog", function() { return faHotdog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHotel", function() { return faHotel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHourglass", function() { return faHourglass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHourglassEnd", function() { return faHourglassEnd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHourglassHalf", function() { return faHourglassHalf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHourglassStart", function() { return faHourglassStart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHouseDamage", function() { return faHouseDamage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHouseFlood", function() { return faHouseFlood; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHryvnia", function() { return faHryvnia; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHumidity", function() { return faHumidity; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faHurricane", function() { return faHurricane; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faICursor", function() { return faICursor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIceCream", function() { return faIceCream; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIceSkate", function() { return faIceSkate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIcicles", function() { return faIcicles; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIcons", function() { return faIcons; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIconsAlt", function() { return faIconsAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIdBadge", function() { return faIdBadge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIdCard", function() { return faIdCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIdCardAlt", function() { return faIdCardAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIgloo", function() { return faIgloo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faImage", function() { return faImage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faImages", function() { return faImages; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInbox", function() { return faInbox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInboxIn", function() { return faInboxIn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInboxOut", function() { return faInboxOut; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIndent", function() { return faIndent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIndustry", function() { return faIndustry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIndustryAlt", function() { return faIndustryAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInfinity", function() { return faInfinity; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInfo", function() { return faInfo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInfoCircle", function() { return faInfoCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInfoSquare", function() { return faInfoSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInhaler", function() { return faInhaler; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIntegral", function() { return faIntegral; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIntersection", function() { return faIntersection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faInventory", function() { return faInventory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faIslandTropical", function() { return faIslandTropical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faItalic", function() { return faItalic; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faJackOLantern", function() { return faJackOLantern; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faJedi", function() { return faJedi; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faJoint", function() { return faJoint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faJournalWhills", function() { return faJournalWhills; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKaaba", function() { return faKaaba; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKerning", function() { return faKerning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKey", function() { return faKey; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKeySkeleton", function() { return faKeySkeleton; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKeyboard", function() { return faKeyboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKeynote", function() { return faKeynote; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKhanda", function() { return faKhanda; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKidneys", function() { return faKidneys; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKiss", function() { return faKiss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKissBeam", function() { return faKissBeam; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKissWinkHeart", function() { return faKissWinkHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKite", function() { return faKite; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKiwiBird", function() { return faKiwiBird; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faKnifeKitchen", function() { return faKnifeKitchen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLambda", function() { return faLambda; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLamp", function() { return faLamp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLandmark", function() { return faLandmark; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLandmarkAlt", function() { return faLandmarkAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLanguage", function() { return faLanguage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLaptop", function() { return faLaptop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLaptopCode", function() { return faLaptopCode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLaptopMedical", function() { return faLaptopMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLaugh", function() { return faLaugh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLaughBeam", function() { return faLaughBeam; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLaughSquint", function() { return faLaughSquint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLaughWink", function() { return faLaughWink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLayerGroup", function() { return faLayerGroup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLayerMinus", function() { return faLayerMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLayerPlus", function() { return faLayerPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLeaf", function() { return faLeaf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLeafHeart", function() { return faLeafHeart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLeafMaple", function() { return faLeafMaple; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLeafOak", function() { return faLeafOak; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLemon", function() { return faLemon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLessThan", function() { return faLessThan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLessThanEqual", function() { return faLessThanEqual; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLevelDown", function() { return faLevelDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLevelDownAlt", function() { return faLevelDownAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLevelUp", function() { return faLevelUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLevelUpAlt", function() { return faLevelUpAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLifeRing", function() { return faLifeRing; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLightbulb", function() { return faLightbulb; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLightbulbDollar", function() { return faLightbulbDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLightbulbExclamation", function() { return faLightbulbExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLightbulbOn", function() { return faLightbulbOn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLightbulbSlash", function() { return faLightbulbSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLightsHoliday", function() { return faLightsHoliday; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLineColumns", function() { return faLineColumns; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLineHeight", function() { return faLineHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLink", function() { return faLink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLips", function() { return faLips; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLiraSign", function() { return faLiraSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faList", function() { return faList; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faListAlt", function() { return faListAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faListOl", function() { return faListOl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faListUl", function() { return faListUl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLocation", function() { return faLocation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLocationArrow", function() { return faLocationArrow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLocationCircle", function() { return faLocationCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLocationSlash", function() { return faLocationSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLock", function() { return faLock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLockAlt", function() { return faLockAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLockOpen", function() { return faLockOpen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLockOpenAlt", function() { return faLockOpenAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLongArrowAltDown", function() { return faLongArrowAltDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLongArrowAltLeft", function() { return faLongArrowAltLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLongArrowAltRight", function() { return faLongArrowAltRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLongArrowAltUp", function() { return faLongArrowAltUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLongArrowDown", function() { return faLongArrowDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLongArrowLeft", function() { return faLongArrowLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLongArrowRight", function() { return faLongArrowRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLongArrowUp", function() { return faLongArrowUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLoveseat", function() { return faLoveseat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLowVision", function() { return faLowVision; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLuchador", function() { return faLuchador; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLuggageCart", function() { return faLuggageCart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faLungs", function() { return faLungs; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMace", function() { return faMace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMagic", function() { return faMagic; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMagnet", function() { return faMagnet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMailBulk", function() { return faMailBulk; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMailbox", function() { return faMailbox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMale", function() { return faMale; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMandolin", function() { return faMandolin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMap", function() { return faMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarked", function() { return faMapMarked; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkedAlt", function() { return faMapMarkedAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarker", function() { return faMapMarker; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerAlt", function() { return faMapMarkerAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerAltSlash", function() { return faMapMarkerAltSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerCheck", function() { return faMapMarkerCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerEdit", function() { return faMapMarkerEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerExclamation", function() { return faMapMarkerExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerMinus", function() { return faMapMarkerMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerPlus", function() { return faMapMarkerPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerQuestion", function() { return faMapMarkerQuestion; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerSlash", function() { return faMapMarkerSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerSmile", function() { return faMapMarkerSmile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapMarkerTimes", function() { return faMapMarkerTimes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapPin", function() { return faMapPin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMapSigns", function() { return faMapSigns; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMarker", function() { return faMarker; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMars", function() { return faMars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMarsDouble", function() { return faMarsDouble; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMarsStroke", function() { return faMarsStroke; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMarsStrokeH", function() { return faMarsStrokeH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMarsStrokeV", function() { return faMarsStrokeV; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMask", function() { return faMask; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMeat", function() { return faMeat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMedal", function() { return faMedal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMedkit", function() { return faMedkit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMegaphone", function() { return faMegaphone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMeh", function() { return faMeh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMehBlank", function() { return faMehBlank; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMehRollingEyes", function() { return faMehRollingEyes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMemory", function() { return faMemory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMenorah", function() { return faMenorah; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMercury", function() { return faMercury; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMeteor", function() { return faMeteor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMicrochip", function() { return faMicrochip; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMicrophone", function() { return faMicrophone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMicrophoneAlt", function() { return faMicrophoneAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMicrophoneAltSlash", function() { return faMicrophoneAltSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMicrophoneSlash", function() { return faMicrophoneSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMicroscope", function() { return faMicroscope; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMindShare", function() { return faMindShare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMinus", function() { return faMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMinusCircle", function() { return faMinusCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMinusHexagon", function() { return faMinusHexagon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMinusOctagon", function() { return faMinusOctagon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMinusSquare", function() { return faMinusSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMistletoe", function() { return faMistletoe; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMitten", function() { return faMitten; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMobile", function() { return faMobile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMobileAlt", function() { return faMobileAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMobileAndroid", function() { return faMobileAndroid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMobileAndroidAlt", function() { return faMobileAndroidAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoneyBill", function() { return faMoneyBill; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoneyBillAlt", function() { return faMoneyBillAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoneyBillWave", function() { return faMoneyBillWave; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoneyBillWaveAlt", function() { return faMoneyBillWaveAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoneyCheck", function() { return faMoneyCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoneyCheckAlt", function() { return faMoneyCheckAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoneyCheckEdit", function() { return faMoneyCheckEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoneyCheckEditAlt", function() { return faMoneyCheckEditAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMonitorHeartRate", function() { return faMonitorHeartRate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMonkey", function() { return faMonkey; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMonument", function() { return faMonument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoon", function() { return faMoon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoonCloud", function() { return faMoonCloud; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMoonStars", function() { return faMoonStars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMortarPestle", function() { return faMortarPestle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMosque", function() { return faMosque; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMotorcycle", function() { return faMotorcycle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMountain", function() { return faMountain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMountains", function() { return faMountains; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMousePointer", function() { return faMousePointer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMug", function() { return faMug; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMugHot", function() { return faMugHot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMugMarshmallows", function() { return faMugMarshmallows; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMugTea", function() { return faMugTea; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faMusic", function() { return faMusic; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faNarwhal", function() { return faNarwhal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faNetworkWired", function() { return faNetworkWired; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faNeuter", function() { return faNeuter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faNewspaper", function() { return faNewspaper; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faNotEqual", function() { return faNotEqual; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faNotesMedical", function() { return faNotesMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faObjectGroup", function() { return faObjectGroup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faObjectUngroup", function() { return faObjectUngroup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOctagon", function() { return faOctagon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOilCan", function() { return faOilCan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOilTemp", function() { return faOilTemp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOm", function() { return faOm; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOmega", function() { return faOmega; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOrnament", function() { return faOrnament; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOtter", function() { return faOtter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOutdent", function() { return faOutdent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faOverline", function() { return faOverline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPageBreak", function() { return faPageBreak; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPager", function() { return faPager; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPaintBrush", function() { return faPaintBrush; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPaintBrushAlt", function() { return faPaintBrushAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPaintRoller", function() { return faPaintRoller; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPalette", function() { return faPalette; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPallet", function() { return faPallet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPalletAlt", function() { return faPalletAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPaperPlane", function() { return faPaperPlane; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPaperclip", function() { return faPaperclip; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faParachuteBox", function() { return faParachuteBox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faParagraph", function() { return faParagraph; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faParagraphRtl", function() { return faParagraphRtl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faParking", function() { return faParking; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faParkingCircle", function() { return faParkingCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faParkingCircleSlash", function() { return faParkingCircleSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faParkingSlash", function() { return faParkingSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPassport", function() { return faPassport; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPastafarianism", function() { return faPastafarianism; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPaste", function() { return faPaste; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPause", function() { return faPause; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPauseCircle", function() { return faPauseCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPaw", function() { return faPaw; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPawAlt", function() { return faPawAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPawClaws", function() { return faPawClaws; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPeace", function() { return faPeace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPegasus", function() { return faPegasus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPen", function() { return faPen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPenAlt", function() { return faPenAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPenFancy", function() { return faPenFancy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPenNib", function() { return faPenNib; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPenSquare", function() { return faPenSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPencil", function() { return faPencil; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPencilAlt", function() { return faPencilAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPencilPaintbrush", function() { return faPencilPaintbrush; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPencilRuler", function() { return faPencilRuler; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPennant", function() { return faPennant; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPeopleCarry", function() { return faPeopleCarry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPepperHot", function() { return faPepperHot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPercent", function() { return faPercent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPercentage", function() { return faPercentage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPersonBooth", function() { return faPersonBooth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPersonCarry", function() { return faPersonCarry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPersonDolly", function() { return faPersonDolly; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPersonDollyEmpty", function() { return faPersonDollyEmpty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPersonSign", function() { return faPersonSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhone", function() { return faPhone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhoneAlt", function() { return faPhoneAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhoneLaptop", function() { return faPhoneLaptop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhoneOffice", function() { return faPhoneOffice; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhonePlus", function() { return faPhonePlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhoneSlash", function() { return faPhoneSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhoneSquare", function() { return faPhoneSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhoneSquareAlt", function() { return faPhoneSquareAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhoneVolume", function() { return faPhoneVolume; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPhotoVideo", function() { return faPhotoVideo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPi", function() { return faPi; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPie", function() { return faPie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPig", function() { return faPig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPiggyBank", function() { return faPiggyBank; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPills", function() { return faPills; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPizza", function() { return faPizza; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPizzaSlice", function() { return faPizzaSlice; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlaceOfWorship", function() { return faPlaceOfWorship; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlane", function() { return faPlane; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlaneAlt", function() { return faPlaneAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlaneArrival", function() { return faPlaneArrival; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlaneDeparture", function() { return faPlaneDeparture; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlay", function() { return faPlay; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlayCircle", function() { return faPlayCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlug", function() { return faPlug; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlus", function() { return faPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlusCircle", function() { return faPlusCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlusHexagon", function() { return faPlusHexagon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlusOctagon", function() { return faPlusOctagon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPlusSquare", function() { return faPlusSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPodcast", function() { return faPodcast; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPodium", function() { return faPodium; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPodiumStar", function() { return faPodiumStar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPoll", function() { return faPoll; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPollH", function() { return faPollH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPollPeople", function() { return faPollPeople; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPoo", function() { return faPoo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPooStorm", function() { return faPooStorm; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPoop", function() { return faPoop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPopcorn", function() { return faPopcorn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPortrait", function() { return faPortrait; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPoundSign", function() { return faPoundSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPowerOff", function() { return faPowerOff; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPray", function() { return faPray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPrayingHands", function() { return faPrayingHands; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPrescription", function() { return faPrescription; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPrescriptionBottle", function() { return faPrescriptionBottle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPrescriptionBottleAlt", function() { return faPrescriptionBottleAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPresentation", function() { return faPresentation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPrint", function() { return faPrint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPrintSearch", function() { return faPrintSearch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPrintSlash", function() { return faPrintSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faProcedures", function() { return faProcedures; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faProjectDiagram", function() { return faProjectDiagram; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPumpkin", function() { return faPumpkin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faPuzzlePiece", function() { return faPuzzlePiece; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faQrcode", function() { return faQrcode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faQuestion", function() { return faQuestion; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faQuestionCircle", function() { return faQuestionCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faQuestionSquare", function() { return faQuestionSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faQuidditch", function() { return faQuidditch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faQuoteLeft", function() { return faQuoteLeft; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faQuoteRight", function() { return faQuoteRight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faQuran", function() { return faQuran; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRabbit", function() { return faRabbit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRabbitFast", function() { return faRabbitFast; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRacquet", function() { return faRacquet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRadiation", function() { return faRadiation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRadiationAlt", function() { return faRadiationAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRainbow", function() { return faRainbow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRaindrops", function() { return faRaindrops; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRam", function() { return faRam; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRampLoading", function() { return faRampLoading; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRandom", function() { return faRandom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faReceipt", function() { return faReceipt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRectangleLandscape", function() { return faRectangleLandscape; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRectanglePortrait", function() { return faRectanglePortrait; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRectangleWide", function() { return faRectangleWide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRecycle", function() { return faRecycle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRedo", function() { return faRedo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRedoAlt", function() { return faRedoAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRegistered", function() { return faRegistered; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRemoveFormat", function() { return faRemoveFormat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRepeat", function() { return faRepeat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRepeat1", function() { return faRepeat1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRepeat1Alt", function() { return faRepeat1Alt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRepeatAlt", function() { return faRepeatAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faReply", function() { return faReply; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faReplyAll", function() { return faReplyAll; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRepublican", function() { return faRepublican; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRestroom", function() { return faRestroom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRetweet", function() { return faRetweet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRetweetAlt", function() { return faRetweetAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRibbon", function() { return faRibbon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRing", function() { return faRing; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRingsWedding", function() { return faRingsWedding; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRoad", function() { return faRoad; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRobot", function() { return faRobot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRocket", function() { return faRocket; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRoute", function() { return faRoute; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRouteHighway", function() { return faRouteHighway; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRouteInterstate", function() { return faRouteInterstate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRss", function() { return faRss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRssSquare", function() { return faRssSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRubleSign", function() { return faRubleSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRuler", function() { return faRuler; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRulerCombined", function() { return faRulerCombined; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRulerHorizontal", function() { return faRulerHorizontal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRulerTriangle", function() { return faRulerTriangle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRulerVertical", function() { return faRulerVertical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRunning", function() { return faRunning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRupeeSign", function() { return faRupeeSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faRv", function() { return faRv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSack", function() { return faSack; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSackDollar", function() { return faSackDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSadCry", function() { return faSadCry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSadTear", function() { return faSadTear; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSalad", function() { return faSalad; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSandwich", function() { return faSandwich; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSatellite", function() { return faSatellite; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSatelliteDish", function() { return faSatelliteDish; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSausage", function() { return faSausage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSave", function() { return faSave; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScalpel", function() { return faScalpel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScalpelPath", function() { return faScalpelPath; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScanner", function() { return faScanner; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScannerKeyboard", function() { return faScannerKeyboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScannerTouchscreen", function() { return faScannerTouchscreen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScarecrow", function() { return faScarecrow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScarf", function() { return faScarf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSchool", function() { return faSchool; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScrewdriver", function() { return faScrewdriver; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScroll", function() { return faScroll; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScrollOld", function() { return faScrollOld; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScrubber", function() { return faScrubber; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faScythe", function() { return faScythe; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSdCard", function() { return faSdCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSearch", function() { return faSearch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSearchDollar", function() { return faSearchDollar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSearchLocation", function() { return faSearchLocation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSearchMinus", function() { return faSearchMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSearchPlus", function() { return faSearchPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSeedling", function() { return faSeedling; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSendBack", function() { return faSendBack; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSendBackward", function() { return faSendBackward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faServer", function() { return faServer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShapes", function() { return faShapes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShare", function() { return faShare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShareAll", function() { return faShareAll; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShareAlt", function() { return faShareAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShareAltSquare", function() { return faShareAltSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShareSquare", function() { return faShareSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSheep", function() { return faSheep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShekelSign", function() { return faShekelSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShield", function() { return faShield; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShieldAlt", function() { return faShieldAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShieldCheck", function() { return faShieldCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShieldCross", function() { return faShieldCross; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShip", function() { return faShip; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShippingFast", function() { return faShippingFast; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShippingTimed", function() { return faShippingTimed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShishKebab", function() { return faShishKebab; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShoePrints", function() { return faShoePrints; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShoppingBag", function() { return faShoppingBag; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShoppingBasket", function() { return faShoppingBasket; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShoppingCart", function() { return faShoppingCart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShovel", function() { return faShovel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShovelSnow", function() { return faShovelSnow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShower", function() { return faShower; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShredder", function() { return faShredder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShuttleVan", function() { return faShuttleVan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faShuttlecock", function() { return faShuttlecock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSickle", function() { return faSickle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSigma", function() { return faSigma; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSign", function() { return faSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignIn", function() { return faSignIn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignInAlt", function() { return faSignInAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignLanguage", function() { return faSignLanguage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignOut", function() { return faSignOut; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignOutAlt", function() { return faSignOutAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignal", function() { return faSignal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignal1", function() { return faSignal1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignal2", function() { return faSignal2; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignal3", function() { return faSignal3; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignal4", function() { return faSignal4; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignalAlt", function() { return faSignalAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignalAlt1", function() { return faSignalAlt1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignalAlt2", function() { return faSignalAlt2; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignalAlt3", function() { return faSignalAlt3; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignalAltSlash", function() { return faSignalAltSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignalSlash", function() { return faSignalSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSignature", function() { return faSignature; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSimCard", function() { return faSimCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSitemap", function() { return faSitemap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSkating", function() { return faSkating; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSkeleton", function() { return faSkeleton; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSkiJump", function() { return faSkiJump; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSkiLift", function() { return faSkiLift; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSkiing", function() { return faSkiing; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSkiingNordic", function() { return faSkiingNordic; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSkull", function() { return faSkull; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSkullCrossbones", function() { return faSkullCrossbones; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSlash", function() { return faSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSledding", function() { return faSledding; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSleigh", function() { return faSleigh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSlidersH", function() { return faSlidersH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSlidersHSquare", function() { return faSlidersHSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSlidersV", function() { return faSlidersV; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSlidersVSquare", function() { return faSlidersVSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSmile", function() { return faSmile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSmileBeam", function() { return faSmileBeam; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSmilePlus", function() { return faSmilePlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSmileWink", function() { return faSmileWink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSmog", function() { return faSmog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSmoke", function() { return faSmoke; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSmoking", function() { return faSmoking; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSmokingBan", function() { return faSmokingBan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSms", function() { return faSms; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnake", function() { return faSnake; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnooze", function() { return faSnooze; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnowBlowing", function() { return faSnowBlowing; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnowboarding", function() { return faSnowboarding; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnowflake", function() { return faSnowflake; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnowflakes", function() { return faSnowflakes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnowman", function() { return faSnowman; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnowmobile", function() { return faSnowmobile; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSnowplow", function() { return faSnowplow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSocks", function() { return faSocks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSolarPanel", function() { return faSolarPanel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSort", function() { return faSort; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAlphaDown", function() { return faSortAlphaDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAlphaDownAlt", function() { return faSortAlphaDownAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAlphaUp", function() { return faSortAlphaUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAlphaUpAlt", function() { return faSortAlphaUpAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAlt", function() { return faSortAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAmountDown", function() { return faSortAmountDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAmountDownAlt", function() { return faSortAmountDownAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAmountUp", function() { return faSortAmountUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortAmountUpAlt", function() { return faSortAmountUpAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortDown", function() { return faSortDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortNumericDown", function() { return faSortNumericDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortNumericDownAlt", function() { return faSortNumericDownAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortNumericUp", function() { return faSortNumericUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortNumericUpAlt", function() { return faSortNumericUpAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortShapesDown", function() { return faSortShapesDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortShapesDownAlt", function() { return faSortShapesDownAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortShapesUp", function() { return faSortShapesUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortShapesUpAlt", function() { return faSortShapesUpAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortSizeDown", function() { return faSortSizeDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortSizeDownAlt", function() { return faSortSizeDownAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortSizeUp", function() { return faSortSizeUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortSizeUpAlt", function() { return faSortSizeUpAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSortUp", function() { return faSortUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSoup", function() { return faSoup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpa", function() { return faSpa; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpaceShuttle", function() { return faSpaceShuttle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpade", function() { return faSpade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSparkles", function() { return faSparkles; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpellCheck", function() { return faSpellCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpider", function() { return faSpider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpiderBlackWidow", function() { return faSpiderBlackWidow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpiderWeb", function() { return faSpiderWeb; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpinner", function() { return faSpinner; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSpinnerThird", function() { return faSpinnerThird; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSplotch", function() { return faSplotch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSprayCan", function() { return faSprayCan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSquare", function() { return faSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSquareFull", function() { return faSquareFull; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSquareRoot", function() { return faSquareRoot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSquareRootAlt", function() { return faSquareRootAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSquirrel", function() { return faSquirrel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStaff", function() { return faStaff; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStamp", function() { return faStamp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStar", function() { return faStar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStarAndCrescent", function() { return faStarAndCrescent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStarChristmas", function() { return faStarChristmas; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStarExclamation", function() { return faStarExclamation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStarHalf", function() { return faStarHalf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStarHalfAlt", function() { return faStarHalfAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStarOfDavid", function() { return faStarOfDavid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStarOfLife", function() { return faStarOfLife; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStars", function() { return faStars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSteak", function() { return faSteak; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSteeringWheel", function() { return faSteeringWheel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStepBackward", function() { return faStepBackward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStepForward", function() { return faStepForward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStethoscope", function() { return faStethoscope; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStickyNote", function() { return faStickyNote; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStocking", function() { return faStocking; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStomach", function() { return faStomach; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStop", function() { return faStop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStopCircle", function() { return faStopCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStopwatch", function() { return faStopwatch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStore", function() { return faStore; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStoreAlt", function() { return faStoreAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStream", function() { return faStream; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStreetView", function() { return faStreetView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStretcher", function() { return faStretcher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStrikethrough", function() { return faStrikethrough; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faStroopwafel", function() { return faStroopwafel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSubscript", function() { return faSubscript; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSubway", function() { return faSubway; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSuitcase", function() { return faSuitcase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSuitcaseRolling", function() { return faSuitcaseRolling; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSun", function() { return faSun; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSunCloud", function() { return faSunCloud; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSunDust", function() { return faSunDust; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSunHaze", function() { return faSunHaze; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSunglasses", function() { return faSunglasses; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSunrise", function() { return faSunrise; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSunset", function() { return faSunset; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSuperscript", function() { return faSuperscript; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSurprise", function() { return faSurprise; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSwatchbook", function() { return faSwatchbook; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSwimmer", function() { return faSwimmer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSwimmingPool", function() { return faSwimmingPool; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSword", function() { return faSword; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSwords", function() { return faSwords; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSynagogue", function() { return faSynagogue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSync", function() { return faSync; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSyncAlt", function() { return faSyncAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faSyringe", function() { return faSyringe; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTable", function() { return faTable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTableTennis", function() { return faTableTennis; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTablet", function() { return faTablet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTabletAlt", function() { return faTabletAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTabletAndroid", function() { return faTabletAndroid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTabletAndroidAlt", function() { return faTabletAndroidAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTabletRugged", function() { return faTabletRugged; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTablets", function() { return faTablets; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometer", function() { return faTachometer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerAlt", function() { return faTachometerAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerAltAverage", function() { return faTachometerAltAverage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerAltFast", function() { return faTachometerAltFast; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerAltFastest", function() { return faTachometerAltFastest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerAltSlow", function() { return faTachometerAltSlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerAltSlowest", function() { return faTachometerAltSlowest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerAverage", function() { return faTachometerAverage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerFast", function() { return faTachometerFast; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerFastest", function() { return faTachometerFastest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerSlow", function() { return faTachometerSlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTachometerSlowest", function() { return faTachometerSlowest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTaco", function() { return faTaco; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTag", function() { return faTag; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTags", function() { return faTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTally", function() { return faTally; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTanakh", function() { return faTanakh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTape", function() { return faTape; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTasks", function() { return faTasks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTasksAlt", function() { return faTasksAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTaxi", function() { return faTaxi; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTeeth", function() { return faTeeth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTeethOpen", function() { return faTeethOpen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTemperatureFrigid", function() { return faTemperatureFrigid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTemperatureHigh", function() { return faTemperatureHigh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTemperatureHot", function() { return faTemperatureHot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTemperatureLow", function() { return faTemperatureLow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTenge", function() { return faTenge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTennisBall", function() { return faTennisBall; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTerminal", function() { return faTerminal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faText", function() { return faText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTextHeight", function() { return faTextHeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTextSize", function() { return faTextSize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTextWidth", function() { return faTextWidth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTh", function() { return faTh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThLarge", function() { return faThLarge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThList", function() { return faThList; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTheaterMasks", function() { return faTheaterMasks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThermometer", function() { return faThermometer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThermometerEmpty", function() { return faThermometerEmpty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThermometerFull", function() { return faThermometerFull; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThermometerHalf", function() { return faThermometerHalf; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThermometerQuarter", function() { return faThermometerQuarter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThermometerThreeQuarters", function() { return faThermometerThreeQuarters; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTheta", function() { return faTheta; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThumbsDown", function() { return faThumbsDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThumbsUp", function() { return faThumbsUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThumbtack", function() { return faThumbtack; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThunderstorm", function() { return faThunderstorm; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThunderstormMoon", function() { return faThunderstormMoon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faThunderstormSun", function() { return faThunderstormSun; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTicket", function() { return faTicket; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTicketAlt", function() { return faTicketAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTilde", function() { return faTilde; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTimes", function() { return faTimes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTimesCircle", function() { return faTimesCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTimesHexagon", function() { return faTimesHexagon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTimesOctagon", function() { return faTimesOctagon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTimesSquare", function() { return faTimesSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTint", function() { return faTint; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTintSlash", function() { return faTintSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTire", function() { return faTire; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTireFlat", function() { return faTireFlat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTirePressureWarning", function() { return faTirePressureWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTireRugged", function() { return faTireRugged; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTired", function() { return faTired; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faToggleOff", function() { return faToggleOff; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faToggleOn", function() { return faToggleOn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faToilet", function() { return faToilet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faToiletPaper", function() { return faToiletPaper; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faToiletPaperAlt", function() { return faToiletPaperAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTombstone", function() { return faTombstone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTombstoneAlt", function() { return faTombstoneAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faToolbox", function() { return faToolbox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTools", function() { return faTools; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTooth", function() { return faTooth; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faToothbrush", function() { return faToothbrush; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTorah", function() { return faTorah; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faToriiGate", function() { return faToriiGate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTornado", function() { return faTornado; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTractor", function() { return faTractor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrademark", function() { return faTrademark; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrafficCone", function() { return faTrafficCone; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrafficLight", function() { return faTrafficLight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrafficLightGo", function() { return faTrafficLightGo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrafficLightSlow", function() { return faTrafficLightSlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrafficLightStop", function() { return faTrafficLightStop; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrain", function() { return faTrain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTram", function() { return faTram; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTransgender", function() { return faTransgender; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTransgenderAlt", function() { return faTransgenderAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrash", function() { return faTrash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrashAlt", function() { return faTrashAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrashRestore", function() { return faTrashRestore; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrashRestoreAlt", function() { return faTrashRestoreAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrashUndo", function() { return faTrashUndo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrashUndoAlt", function() { return faTrashUndoAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTreasureChest", function() { return faTreasureChest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTree", function() { return faTree; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTreeAlt", function() { return faTreeAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTreeChristmas", function() { return faTreeChristmas; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTreeDecorated", function() { return faTreeDecorated; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTreeLarge", function() { return faTreeLarge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTreePalm", function() { return faTreePalm; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrees", function() { return faTrees; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTriangle", function() { return faTriangle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrophy", function() { return faTrophy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTrophyAlt", function() { return faTrophyAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruck", function() { return faTruck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruckContainer", function() { return faTruckContainer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruckCouch", function() { return faTruckCouch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruckLoading", function() { return faTruckLoading; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruckMonster", function() { return faTruckMonster; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruckMoving", function() { return faTruckMoving; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruckPickup", function() { return faTruckPickup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruckPlow", function() { return faTruckPlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTruckRamp", function() { return faTruckRamp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTshirt", function() { return faTshirt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTty", function() { return faTty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTurkey", function() { return faTurkey; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTurtle", function() { return faTurtle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTv", function() { return faTv; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faTvRetro", function() { return faTvRetro; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUmbrella", function() { return faUmbrella; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUmbrellaBeach", function() { return faUmbrellaBeach; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUnderline", function() { return faUnderline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUndo", function() { return faUndo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUndoAlt", function() { return faUndoAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUnicorn", function() { return faUnicorn; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUnion", function() { return faUnion; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUniversalAccess", function() { return faUniversalAccess; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUniversity", function() { return faUniversity; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUnlink", function() { return faUnlink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUnlock", function() { return faUnlock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUnlockAlt", function() { return faUnlockAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUpload", function() { return faUpload; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUsdCircle", function() { return faUsdCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUsdSquare", function() { return faUsdSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUser", function() { return faUser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserAlt", function() { return faUserAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserAltSlash", function() { return faUserAltSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserAstronaut", function() { return faUserAstronaut; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserChart", function() { return faUserChart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserCheck", function() { return faUserCheck; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserCircle", function() { return faUserCircle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserClock", function() { return faUserClock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserCog", function() { return faUserCog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserCrown", function() { return faUserCrown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserEdit", function() { return faUserEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserFriends", function() { return faUserFriends; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserGraduate", function() { return faUserGraduate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserHardHat", function() { return faUserHardHat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserHeadset", function() { return faUserHeadset; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserInjured", function() { return faUserInjured; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserLock", function() { return faUserLock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserMd", function() { return faUserMd; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserMdChat", function() { return faUserMdChat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserMinus", function() { return faUserMinus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserNinja", function() { return faUserNinja; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserNurse", function() { return faUserNurse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserPlus", function() { return faUserPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserSecret", function() { return faUserSecret; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserShield", function() { return faUserShield; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserSlash", function() { return faUserSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserTag", function() { return faUserTag; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserTie", function() { return faUserTie; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUserTimes", function() { return faUserTimes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUsers", function() { return faUsers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUsersClass", function() { return faUsersClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUsersCog", function() { return faUsersCog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUsersCrown", function() { return faUsersCrown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUsersMedical", function() { return faUsersMedical; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUtensilFork", function() { return faUtensilFork; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUtensilKnife", function() { return faUtensilKnife; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUtensilSpoon", function() { return faUtensilSpoon; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUtensils", function() { return faUtensils; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faUtensilsAlt", function() { return faUtensilsAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faValueAbsolute", function() { return faValueAbsolute; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVectorSquare", function() { return faVectorSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVenus", function() { return faVenus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVenusDouble", function() { return faVenusDouble; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVenusMars", function() { return faVenusMars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVial", function() { return faVial; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVials", function() { return faVials; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVideo", function() { return faVideo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVideoPlus", function() { return faVideoPlus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVideoSlash", function() { return faVideoSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVihara", function() { return faVihara; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVoicemail", function() { return faVoicemail; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVolcano", function() { return faVolcano; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVolleyballBall", function() { return faVolleyballBall; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVolume", function() { return faVolume; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVolumeDown", function() { return faVolumeDown; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVolumeMute", function() { return faVolumeMute; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVolumeOff", function() { return faVolumeOff; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVolumeSlash", function() { return faVolumeSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVolumeUp", function() { return faVolumeUp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVoteNay", function() { return faVoteNay; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVoteYea", function() { return faVoteYea; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faVrCardboard", function() { return faVrCardboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWalker", function() { return faWalker; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWalking", function() { return faWalking; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWallet", function() { return faWallet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWand", function() { return faWand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWandMagic", function() { return faWandMagic; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWarehouse", function() { return faWarehouse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWarehouseAlt", function() { return faWarehouseAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWasher", function() { return faWasher; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWatch", function() { return faWatch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWatchFitness", function() { return faWatchFitness; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWater", function() { return faWater; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWaterLower", function() { return faWaterLower; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWaterRise", function() { return faWaterRise; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWaveSine", function() { return faWaveSine; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWaveSquare", function() { return faWaveSquare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWaveTriangle", function() { return faWaveTriangle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWebcam", function() { return faWebcam; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWebcamSlash", function() { return faWebcamSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWeight", function() { return faWeight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWeightHanging", function() { return faWeightHanging; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWhale", function() { return faWhale; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWheat", function() { return faWheat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWheelchair", function() { return faWheelchair; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWhistle", function() { return faWhistle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWifi", function() { return faWifi; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWifi1", function() { return faWifi1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWifi2", function() { return faWifi2; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWifiSlash", function() { return faWifiSlash; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWind", function() { return faWind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindTurbine", function() { return faWindTurbine; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindWarning", function() { return faWindWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindow", function() { return faWindow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindowAlt", function() { return faWindowAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindowClose", function() { return faWindowClose; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindowMaximize", function() { return faWindowMaximize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindowMinimize", function() { return faWindowMinimize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindowRestore", function() { return faWindowRestore; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWindsock", function() { return faWindsock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWineBottle", function() { return faWineBottle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWineGlass", function() { return faWineGlass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWineGlassAlt", function() { return faWineGlassAlt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWonSign", function() { return faWonSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWreath", function() { return faWreath; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faWrench", function() { return faWrench; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faXRay", function() { return faXRay; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faYenSign", function() { return faYenSign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "faYinYang", function() { return faYinYang; });
var prefix = "far";
var faAbacus = {
  prefix: 'far',
  iconName: 'abacus',
  icon: [576, 512, [], "f640", "M552 0c-13.25 0-24 10.74-24 24v48h-48V48c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24H240V48c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24h-48V48c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24H48V24C48 10.74 37.25 0 24 0S0 10.74 0 24v476c0 6.63 5.37 12 12 12h24c6.63 0 12-5.37 12-12v-60h48v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h48v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h192v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h48v60c0 6.63 5.37 12 12 12h24c6.63 0 12-5.37 12-12V24c0-13.26-10.75-24-24-24zM96 120v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h48v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h192v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h48v112H336v-24c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24h-48v-24c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24h-48v-24c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24H48V120h48zm384 272v-24c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24H240v-24c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24h-48v-24c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v24H48V280h48v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h48v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h48v24c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24h192v112h-48z"]
};
var faAcorn = {
  prefix: 'far',
  iconName: 'acorn',
  icon: [448, 512, [], "f6ae", "M352 64H251.5c3.4-9.4 8.47-18.18 15.16-26.04 5.56-6.52 5.31-15.91-.62-21.86L254.69 4.78c-3.12-3.16-7.72-5.14-11.97-4.72-4.38.14-8.5 2.08-11.31 5.3-14.75 16.8-24.55 37.06-29.39 58.65H96c-53.02 0-96 42.98-96 96v32c0 17.67 14.33 32 32 32v32c0 98.06 55.4 187.7 143.11 231.55L224 512l48.89-24.45C360.6 443.7 416 354.06 416 256v-32c17.67 0 32-14.33 32-32v-32c0-53.02-42.98-96-96-96zM48 160c0-26.47 21.53-48 48-48h256c26.47 0 48 21.53 48 48v16H48v-16zm320 96c0 80.39-44.67 152.67-116.57 188.62L224 458.33l-27.43-13.71C124.67 408.67 80 336.39 80 256v-32h288v32z"]
};
var faAd = {
  prefix: 'far',
  iconName: 'ad',
  icon: [512, 512, [], "f641", "M101.42 352h16.94c6.81 0 12.88-4.32 15.12-10.75l7.38-21.25h70.29l7.38 21.25A16 16 0 0 0 233.65 352h16.94c11.01 0 18.73-10.85 15.12-21.25L212 176.13A24.004 24.004 0 0 0 189.33 160h-26.66c-10.22 0-19.32 6.47-22.67 16.12L86.31 330.75C82.7 341.15 90.42 352 101.42 352zM176 218.78L194.48 272h-36.96L176 218.78zM352 352c9.93 0 19.4-2.02 28.02-5.68 2.94 3.41 7.13 5.68 11.98 5.68h16c8.84 0 16-7.16 16-16V176c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v36.42c-7.54-2.69-15.54-4.42-24-4.42-39.7 0-72 32.3-72 72s32.3 72 72 72zm0-96c13.23 0 24 10.77 24 24s-10.77 24-24 24-24-10.77-24-24 10.77-24 24-24zM464 64H48C21.5 64 0 85.5 0 112v288c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zm0 336H48V112h416v288z"]
};
var faAddressBook = {
  prefix: 'far',
  iconName: 'address-book',
  icon: [448, 512, [], "f2b9", "M436 160c6.6 0 12-5.4 12-12v-40c0-6.6-5.4-12-12-12h-20V48c0-26.5-21.5-48-48-48H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h320c26.5 0 48-21.5 48-48v-48h20c6.6 0 12-5.4 12-12v-40c0-6.6-5.4-12-12-12h-20v-64h20c6.6 0 12-5.4 12-12v-40c0-6.6-5.4-12-12-12h-20v-64h20zm-68 304H48V48h320v416zM208 256c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64zm-89.6 128h179.2c12.4 0 22.4-8.6 22.4-19.2v-19.2c0-31.8-30.1-57.6-67.2-57.6-10.8 0-18.7 8-44.8 8-26.9 0-33.4-8-44.8-8-37.1 0-67.2 25.8-67.2 57.6v19.2c0 10.6 10 19.2 22.4 19.2z"]
};
var faAddressCard = {
  prefix: 'far',
  iconName: 'address-card',
  icon: [576, 512, [], "f2bb", "M528 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h480c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm0 400H48V80h480v352zM208 256c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64zm-89.6 128h179.2c12.4 0 22.4-8.6 22.4-19.2v-19.2c0-31.8-30.1-57.6-67.2-57.6-10.8 0-18.7 8-44.8 8-26.9 0-33.4-8-44.8-8-37.1 0-67.2 25.8-67.2 57.6v19.2c0 10.6 10 19.2 22.4 19.2zM360 320h112c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8H360c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8zm0-64h112c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8H360c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8zm0-64h112c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8H360c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8z"]
};
var faAdjust = {
  prefix: 'far',
  iconName: 'adjust',
  icon: [512, 512, [], "f042", "M256 56c110.549 0 200 89.468 200 200 0 110.549-89.468 200-200 200-110.549 0-200-89.468-200-200 0-110.549 89.468-200 200-200m0-48C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 96c-83.947 0-152 68.053-152 152s68.053 152 152 152V104z"]
};
var faAirFreshener = {
  prefix: 'far',
  iconName: 'air-freshener',
  icon: [384, 512, [], "f5d0", "M373.02 285.8l-49.36-42.78c9.88-3.5 18.06-10.81 22.41-20.53 6.06-13.58 3.62-28.95-6.38-40.12L236.18 66.78A47.92 47.92 0 0 0 240 48c0-26.51-21.49-48-48-48s-48 21.49-48 48c0 6.67 1.37 13.01 3.83 18.78L44.31 182.36c-10 11.17-12.44 26.55-6.38 40.12 4.34 9.72 12.53 17.03 22.41 20.53l-49.36 42.8c-10.91 11.3-13.97 27.12-7.94 41.3 6.41 15.11 21.75 24.88 39.06 24.88H168V384H48c-8.84 0-16 7.16-16 16v96c0 8.84 7.16 16 16 16h288c8.84 0 16-7.16 16-16v-96c0-8.84-7.16-16-16-16H216v-32.02h125.89c17.31 0 32.66-9.77 39.06-24.88 6.03-14.16 2.97-29.99-7.93-41.3zM192 32.02c8.83 0 15.98 7.16 15.98 15.98S200.83 63.98 192 63.98 176.02 56.83 176.02 48s7.15-15.98 15.98-15.98zM304 432v32H80v-32h224zM60.17 303.98l111.2-106.67H95.34l91.24-101.86c1.8.21 3.56.54 5.42.54s3.62-.34 5.42-.54l91.24 101.86h-76.03l111.2 106.67H60.17z"]
};
var faAlarmClock = {
  prefix: 'far',
  iconName: 'alarm-clock',
  icon: [512, 512, [], "f34e", "M256 64C132.26 64 32 164.29 32 288a222.69 222.69 0 0 0 44.75 134l-40.1 40.09a16 16 0 0 0 0 22.63l22.63 22.62a16 16 0 0 0 22.62 0l40.1-40.12a222.82 222.82 0 0 0 268 0l40.1 40.09a16 16 0 0 0 22.63 0l22.62-22.62a16 16 0 0 0 0-22.63L435.21 422A222.7 222.7 0 0 0 480 288c0-123.71-100.3-224-224-224zm0 400a176 176 0 1 1 176-176 176 176 0 0 1-176 176zM96 0A96 96 0 0 0 0 96a94.81 94.81 0 0 0 15.3 51.26L161.2 25.68A95.63 95.63 0 0 0 96 0zm184 292.47V168a8 8 0 0 0-8-8h-32a8 8 0 0 0-8 8v132.16a32 32 0 0 0 12 25l64.54 51.57a8.58 8.58 0 0 0 5.87 1.72 8 8 0 0 0 5.35-2.95l20-25a8 8 0 0 0-1.25-11.27zM416 0a95.66 95.66 0 0 0-65.18 25.66l145.89 121.57A94.85 94.85 0 0 0 512 96a96 96 0 0 0-96-96z"]
};
var faAlarmExclamation = {
  prefix: 'far',
  iconName: 'alarm-exclamation',
  icon: [512, 512, [], "f843", "M256 64C132.3 64 32 164.29 32 288a222.7 222.7 0 0 0 44.79 134l-40.1 40.09a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0L122 467.22a222.82 222.82 0 0 0 268 0l40.1 40.09a16 16 0 0 0 22.62 0l22.63-22.62a16 16 0 0 0 0-22.63L435.25 422A222.69 222.69 0 0 0 480 288c0-123.71-100.26-224-224-224zm0 400a176 176 0 1 1 176-176 176 176 0 0 1-176 176zM96 0A96 96 0 0 0 0 96a94.81 94.81 0 0 0 15.3 51.26L161.2 25.68A95.63 95.63 0 0 0 96 0zm320 0a95.66 95.66 0 0 0-65.18 25.66l145.89 121.57A94.85 94.85 0 0 0 512 96a96 96 0 0 0-96-96zM256 352a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm22.3-192h-44.6a16.06 16.06 0 0 0-15.9 17.6l12.8 128a16 16 0 0 0 15.9 14.4h19a16 16 0 0 0 15.9-14.4l12.8-128a16 16 0 0 0-15.89-17.6z"]
};
var faAlarmPlus = {
  prefix: 'far',
  iconName: 'alarm-plus',
  icon: [512, 512, [], "f844", "M256 64C132.3 64 32 164.29 32 288a222.7 222.7 0 0 0 44.79 134l-40.1 40.09a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0L122 467.22a222.82 222.82 0 0 0 268 0l40.1 40.09a16 16 0 0 0 22.62 0l22.63-22.62a16 16 0 0 0 0-22.63L435.25 422A222.69 222.69 0 0 0 480 288c0-123.71-100.26-224-224-224zm0 400a176 176 0 1 1 176-176 176 176 0 0 1-176 176zm96-200h-72v-72a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v72h-72a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h72v72a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-72h72a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM96 0A96 96 0 0 0 0 96a94.81 94.81 0 0 0 15.3 51.26L161.2 25.68A95.63 95.63 0 0 0 96 0zm320 0a95.66 95.66 0 0 0-65.18 25.66l145.89 121.57A94.85 94.85 0 0 0 512 96a96 96 0 0 0-96-96z"]
};
var faAlarmSnooze = {
  prefix: 'far',
  iconName: 'alarm-snooze',
  icon: [512, 512, [], "f845", "M256 64C132.3 64 32 164.29 32 288a222.7 222.7 0 0 0 44.79 134l-40.1 40.09a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0L122 467.22a222.82 222.82 0 0 0 268 0l40.1 40.09a16 16 0 0 0 22.62 0l22.63-22.62a16 16 0 0 0 0-22.63L435.25 422A222.69 222.69 0 0 0 480 288c0-123.71-100.26-224-224-224zm0 400a176 176 0 1 1 176-176 176 176 0 0 1-176 176zm64-280H192a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h78.07l-96.83 121A24 24 0 0 0 192 392h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-78.08l96.8-121A24 24 0 0 0 320 184zM96 0A96 96 0 0 0 0 96a94.81 94.81 0 0 0 15.3 51.26L161.2 25.68A95.63 95.63 0 0 0 96 0zm320 0a95.66 95.66 0 0 0-65.18 25.66l145.89 121.57A94.85 94.85 0 0 0 512 96a96 96 0 0 0-96-96z"]
};
var faAlicorn = {
  prefix: 'far',
  iconName: 'alicorn',
  icon: [640, 512, [], "f6b0", "M448 96c0-8.84-7.16-16-16-16s-16 7.16-16 16 7.16 16 16 16 16-7.16 16-16zm183.98-32H526.61l-15.28-18.57c16.37-5.23 29.03-18.72 32.51-35.79C544.85 4.68 540.96 0 535.9 0H399.95c-68.22 0-125.48 47.71-140.26 111.5-36.9-1.23-73.89-13.34-98.32-40.94-4.02-4.54-9.17-6.56-14.21-6.56-9.78 0-19.16 7.6-19.16 19.06 0 86.09 59.76 162.72 140.01 183.21 10.11 2.58 19.99-5.19 19.99-15.63v-16.36c0-6.96-4.44-13.34-11.15-15.21-37.34-10.46-68.92-37.67-86.32-73.34 23.38 9.37 48.83 14.27 75.24 14.27h38.18v-16c0-53.02 42.98-96 96-96h51.33l44.67 54.28.05 65.35c0 4.77-3.03 9.01-7.54 10.55l-31.02 10.59c-1.51.52-9.71 2.95-16.48-3.83L416 160h-32v80c0 26.09-12.68 49.03-32 63.64V464h-48V320l-107.91-30.83-28.65 79.78L191.53 464H150l-21.13-87.86a31.698 31.698 0 0 1 .37-16.18l22.7-76.72C128.54 273.72 112 250.83 112 224c0-14.93 5.32-28.49 13.9-39.38-9.05-14.37-15.81-30.08-20.87-46.54-7.91 6.56-15.17 13.86-21.04 22.32C37.36 162.55 0 200.84 0 248v56c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-56c0-13.22 6.87-24.39 16.78-31.68-.18 2.59-.78 5.05-.78 7.68 0 30.13 11.9 58.09 32.16 78.58l-12.95 43.76a78.913 78.913 0 0 0-1.05 40.84l24.12 100.29c3.46 14.38 16.32 24.52 31.11 24.52h74.7c20.86 0 36.14-19.64 31.02-39.86l-25.53-100.76 8.51-23.71L256 356.2V480c0 17.67 14.33 32 32 32h80c17.67 0 32-14.33 32-32V324.35c20.57-23.15 32-52.8 32-84.35v-5.62c20.95 6.97 38.32.72 40.93-.17l31.03-10.59c23.96-8.18 40.05-30.7 40.04-56.01l-.04-52.28 92.46-36.67c6.59-4.39 3.48-14.66-4.44-14.66z"]
};
var faAlignCenter = {
  prefix: 'far',
  iconName: 'align-center',
  icon: [448, 512, [], "f037", "M108.1 88h231.81A12.09 12.09 0 0 0 352 75.9V52.09A12.09 12.09 0 0 0 339.91 40H108.1A12.09 12.09 0 0 0 96 52.09V75.9A12.1 12.1 0 0 0 108.1 88zM432 424H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm0-256H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm-92.09 176A12.09 12.09 0 0 0 352 331.9v-23.81A12.09 12.09 0 0 0 339.91 296H108.1A12.09 12.09 0 0 0 96 308.09v23.81a12.1 12.1 0 0 0 12.1 12.1z"]
};
var faAlignJustify = {
  prefix: 'far',
  iconName: 'align-justify',
  icon: [448, 512, [], "f039", "M432 424H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm0-128H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm0-128H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm0-128H16A16 16 0 0 0 0 56v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V56a16 16 0 0 0-16-16z"]
};
var faAlignLeft = {
  prefix: 'far',
  iconName: 'align-left',
  icon: [448, 512, [], "f036", "M12.83 344h262.34A12.82 12.82 0 0 0 288 331.17v-22.34A12.82 12.82 0 0 0 275.17 296H12.83A12.82 12.82 0 0 0 0 308.83v22.34A12.82 12.82 0 0 0 12.83 344zm0-256h262.34A12.82 12.82 0 0 0 288 75.17V52.83A12.82 12.82 0 0 0 275.17 40H12.83A12.82 12.82 0 0 0 0 52.83v22.34A12.82 12.82 0 0 0 12.83 88zM432 168H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm0 256H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z"]
};
var faAlignRight = {
  prefix: 'far',
  iconName: 'align-right',
  icon: [448, 512, [], "f038", "M16 216h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16zm416 208H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm3.17-384H172.83A12.82 12.82 0 0 0 160 52.83v22.34A12.82 12.82 0 0 0 172.83 88h262.34A12.82 12.82 0 0 0 448 75.17V52.83A12.82 12.82 0 0 0 435.17 40zm0 256H172.83A12.82 12.82 0 0 0 160 308.83v22.34A12.82 12.82 0 0 0 172.83 344h262.34A12.82 12.82 0 0 0 448 331.17v-22.34A12.82 12.82 0 0 0 435.17 296z"]
};
var faAlignSlash = {
  prefix: 'far',
  iconName: 'align-slash',
  icon: [640, 512, [], "f846", "M634 471L36 3.5A16 16 0 0 0 13.49 6l-10 12.5A16 16 0 0 0 6 41l598 467.5a16 16 0 0 0 22.5-2.5l10-12.5A16 16 0 0 0 634 471zM528 296h-39.94l52.69 41.19A15.6 15.6 0 0 0 544 328v-16a16 16 0 0 0-16-16zm16-112a16 16 0 0 0-16-16H324.34l61.39 48H528a16 16 0 0 0 16-16zm-16-96a16 16 0 0 0 16-16V56a16 16 0 0 0-16-16H160.61L222 88zM112 424a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h367.37L418 424zm0-80h203.65l-61.39-48H112a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16z"]
};
var faAllergies = {
  prefix: 'far',
  iconName: 'allergies',
  icon: [480, 512, [], "f461", "M256 304c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm-64-16c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm64 112c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm152-288c-2.7 0-5.4.2-8 .4V104c0-39.7-32.3-72-72-72-6.4 0-12.7.8-18.6 2.4C296.7 13.8 273.9 0 248 0s-48.7 13.8-61.4 34.4c-5.9-1.6-12.2-2.4-18.6-2.4-39.7 0-72 32.3-72 72v92.1c-10.5-3.7-38.1-10.2-65.3 8.9C-1.8 227.8-9.8 272.8 13 305.3l113.5 171c14.9 22.4 39.8 35.7 66.6 35.7h180.6c38 0 71-27 78.5-64.3l20.6-103.2c4.7-23.7 7.1-48 7.1-72.2V184c.1-39.7-32.2-72-71.9-72zm24 160.3c0 21.1-2.1 42.1-6.2 62.8l-20.6 103.2c-3 15-16.1 25.7-31.4 25.7H193.1c-10.7 0-20.7-5.4-26.7-14.3L52.3 277.8c-18-25.7 20.7-54.1 39.3-27.5l37.8 54.4c4.5 6.5 14.6 3.2 14.6-4.6V104c0-31.8 48-31.7 48 0v144c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V72c0-31.8 48-31.7 48 0v176c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V104c0-31.8 48-31.7 48 0v144c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-64c0-31.8 48-31.7 48 0v88.3zM192 368c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm192-80c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm-32 112c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm-32-64c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16z"]
};
var faAmbulance = {
  prefix: 'far',
  iconName: 'ambulance',
  icon: [640, 512, [], "f0f9", "M296 160h-56v-56c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v56h-56c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h56v56c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-56h56c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm328 208h-16V251.9c0-19-7.7-37.5-21.1-50.9L503 117.1C489.6 103.7 471 96 452.1 96H416V56c0-30.9-25.1-56-56-56H56C25.1 0 0 25.1 0 56v304c0 30.9 25.1 56 56 56h8c0 53 43 96 96 96s96-43 96-96h128c0 53 43 96 96 96s96-43 96-96h48c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm-464 96c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm208-96H242.7c-16.6-28.6-47.2-48-82.7-48s-66.1 19.4-82.7 48H56c-4.4 0-8-3.6-8-8V56c0-4.4 3.6-8 8-8h304c4.4 0 8 3.6 8 8v312zm48-224h36.1c6.3 0 12.5 2.6 17 7l73 73H416v-80zm64 320c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm80-100.9c-17.2-25.9-46.6-43.1-80-43.1-24.7 0-47 9.6-64 24.9V272h144v91.1z"]
};
var faAmericanSignLanguageInterpreting = {
  prefix: 'far',
  iconName: 'american-sign-language-interpreting',
  icon: [640, 512, [], "f2a3", "M635.1 210.8c-.1-.1-40.2-80.4-40.2-80.4-11.4-22.7-39.9-33.6-64.4-21.3L478.9 135s-76.4-7-77.4-7c-18.7 0-36.6 4.3-52.7 12.5-6.6-8.8-14.3-14.1-23.5-18.3 11.4-35.6-14.8-73.5-53.5-73.2-3.2-26.4-25.9-49-55.5-49-13 0-25.6 4.5-35.7 12.8-45.4 37.3-74.4 89.6-82.4 146.6l-29.7 53.5s-44.7 25.4-44.8 25.5C2.1 251.1-6.1 278.5 4.9 301.2c.1.1 40.2 80.4 40.2 80.4 11.5 22.9 40.1 33.5 64.4 21.3l51.6-25.9c76.9 7 76.9 7 78.8 7 18.1 0 35.6-4.5 51.2-12.5 6.6 8.8 14.3 14.1 23.5 18.3-11.8 37 17.1 73.8 53.5 73.4 3.4 27.1 26.7 48.9 55.6 48.9 13 0 25.7-4.5 35.6-12.8 45.4-37.3 74.4-89.6 82.4-146.6l29.7-53.5s44.7-25.4 44.8-25.5c21.7-12.8 29.9-40.1 18.9-62.9zM297 188.6c-19.9-9.9-43.4-11.3-64.5-3.9-8.4 3-6.3 15.5 2.7 15.5 32.4 0 57.2 14.5 69.8 41 9 18.8-19.8 32.9-28.8 13.6l-.1-.1c-6.9-14-20.7-22.7-36.2-22.7-22.1 0-40 17.9-40 40 0 24.7 20.8 40 40 40 15.5 0 29.3-8.7 36.2-22.7l.1-.1c9.1-19.2 37.8-5.2 28.8 13.6-11.9 24.9-37.3 41.1-64.7 41.2-4.6-.4-62.2-5.7-84.6-7.7-1.5-.1-3 .1-4.3.8l-59.8 30c-4.5 2.2-9.1 0-10.8-3.4l-40-79.9c-1.9-3.9-.5-8.7 3.1-10.8l52.2-29.7c1.3-.7 2.3-1.8 3-3.1l37-66.7c.5-.9.8-1.9 1-3 5.6-49.8 30-94.8 68.9-126.7 6.7-5.6 16.9-4.8 22.4 2.1 6 7.5 4.4 17.2-2.2 22.6-12.1 10.2-22.4 21.5-30.6 33.5-4.9 7.3 3.8 16.1 11.1 11.1C226 100 247.3 92 270 89.2c8.2-1.1 16.4 4.1 17.8 13.9 1.1 8.7-4.8 16.7-13.8 17.8-15 1.8-29.4 6.8-42.9 14.8-7.8 4.6-3 16.6 5.8 14.7 23.6-5.2 51.3-1.7 74 9.3 19.2 9.5 5.1 38.1-13.9 28.9zm299.1 50.5l-52.2 29.7c-1.3.7-2.3 1.8-3 3.1l-37 66.7c-.5.9-.8 1.9-1 3-5.6 49.8-30 94.8-68.9 126.7-16 13.4-36.8-11-20.2-24.7 12.2-10.3 22.5-21.6 30.7-33.6 5-7.4-4-16-11.1-11.1-19.3 13.1-40.6 21.2-63.2 23.9-21.2 2.6-24.9-29.3-4.1-31.6 15-1.8 29.4-6.8 42.9-14.8 7.8-4.6 3-16.6-5.8-14.7-23.6 5.2-51.3 1.7-74-9.3-19.2-9.6-5-38.2 13.9-28.9 19.9 9.9 43.4 11.4 64.5 3.9 8.4-3 6.3-15.5-2.7-15.5-32.4 0-57.2-14.5-69.8-41-9-18.8 19.8-32.9 28.8-13.6l.1.1c6.9 14 20.7 22.7 36.2 22.7 22.1 0 40-17.9 40-40 0-24.7-20.8-40-40-40-15.5 0-29.3 8.7-36.2 22.7l-.1.1c-9.1 19.2-37.8 5.2-28.8-13.6 12.1-25.3 37.4-41.1 66.2-41.2l83.1 7.7c1.5.1 3-.1 4.3-.8l59.8-30c4.5-2.2 9.1 0 10.8 3.4l40 79.9c1.7 3.9.4 8.6-3.2 10.8z"]
};
var faAnalytics = {
  prefix: 'far',
  iconName: 'analytics',
  icon: [608, 512, [], "f643", "M416 320h-64c-17.67 0-32 14.33-32 32v128c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V352c0-17.67-14.33-32-32-32zm-16 144h-32v-96h32v96zm176-272h-64c-17.67 0-32 14.33-32 32v256c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V224c0-17.67-14.33-32-32-32zm-16 272h-32V240h32v224zM256 192h-64c-17.67 0-32 14.33-32 32v256c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V224c0-17.67-14.33-32-32-32zm-16 272h-32V240h32v224zM96 352H32c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-96c0-17.67-14.33-32-32-32zM80 464H48v-64h32v64zM64 256c26.51 0 48-21.49 48-48 0-4.27-.74-8.34-1.78-12.28l101.5-101.5C215.66 95.26 219.73 96 224 96c6.15 0 11.97-1.26 17.38-3.37l95.34 76.27c-.35 2.33-.71 4.67-.71 7.1 0 26.51 21.49 48 48 48s48-21.49 48-48c0-2.43-.37-4.76-.71-7.09l95.34-76.27C532.03 94.74 537.85 96 544 96c26.51 0 48-21.49 48-48S570.51 0 544 0s-48 21.49-48 48c0 2.43.37 4.76.71 7.09l-95.34 76.27c-5.4-2.11-11.23-3.37-17.38-3.37s-11.97 1.26-17.38 3.37L271.29 55.1c.35-2.33.71-4.67.71-7.1 0-26.51-21.49-48-48-48s-48 21.49-48 48c0 4.27.74 8.34 1.78 12.28l-101.5 101.5C72.34 160.74 68.27 160 64 160c-26.51 0-48 21.49-48 48s21.49 48 48 48z"]
};
var faAnchor = {
  prefix: 'far',
  iconName: 'anchor',
  icon: [576, 512, [], "f13d", "M571.515 331.515l-67.029-67.029c-4.686-4.686-12.284-4.686-16.971 0l-67.029 67.029c-7.56 7.56-2.206 20.485 8.485 20.485h44.268C453.531 417.326 380.693 456.315 312 462.865V216h60c6.627 0 12-5.373 12-12v-24c0-6.627-5.373-12-12-12h-60v-11.668c32.456-10.195 56-40.512 56-76.332 0-44.183-35.817-80-80-80s-80 35.817-80 80c0 35.82 23.544 66.138 56 76.332V168h-60c-6.627 0-12 5.373-12 12v24c0 6.627 5.373 12 12 12h60v246.865C195.192 456.304 122.424 417.176 102.762 352h44.268c10.691 0 16.045-12.926 8.485-20.485l-67.029-67.029c-4.686-4.686-12.284-4.686-16.971 0l-67.03 67.029C-3.074 339.074 2.28 352 12.971 352h40.284C73.657 451.556 181.238 512 288 512c113.135 0 215.338-65.3 234.745-160h40.284c10.691 0 16.045-12.926 8.486-20.485zM288 48c17.645 0 32 14.355 32 32s-14.355 32-32 32-32-14.355-32-32 14.355-32 32-32z"]
};
var faAngel = {
  prefix: 'far',
  iconName: 'angel',
  icon: [576, 512, [], "f779", "M571.7 453.1l-38.2-78.6c-6.6-13.5-6.6-29.6 0-43.1 16.2-33.4 26.4-37.5 26.4-75.3 0-51.1-46.9-96-100.4-96-25.1 0-48.7 10-66.3 28.1l-72.7 73.4c-10.3-3.4-21.2-5.4-32.5-5.4-11.2 0-22.1 2-32.4 5.4l-72.7-73.3c-17.6-18-41.2-28.1-66.3-28.1-53.5 0-100.4 44.9-100.4 96 0 37.9 10.2 42 26.4 75.3 6.6 13.5 6.6 29.6 0 43.1L4.4 453.1c-14.5 29.8 9.3 58.9 36.3 58.9h494.7c27.6 0 50.4-29.9 36.3-58.9zM52.4 464l33.4-68.6c12.9-26.6 12.9-58.5 0-85.1-5.4-11.2-9.9-18.9-13.5-25.1-7.2-12.4-8.1-14-8.1-29.2 0-24.7 25.5-48 52.4-48 12.1 0 23.5 4.9 32.1 13.7l65.2 65.8c-7.3 7.5-13.6 16.1-18.4 25.7L120.1 464H52.4zm121.4 0l64.6-129.3c9.5-18.9 28.5-30.7 49.7-30.7 21.2 0 40.2 11.8 49.7 30.7L402.3 464H173.8zm282.1 0l-75.3-150.8c-4.8-9.7-11.1-18.2-18.4-25.7l65.2-65.8c8.6-8.9 20-13.7 32.1-13.7 27 0 52.4 23.3 52.4 48 0 15.2-.9 16.8-8.1 29.2-3.6 6.2-8.1 13.9-13.5 25.1-12.9 26.6-12.9 58.5 0 85.1l33.4 68.6h-67.8zM208 144c0 44.2 35.8 80 80 80s80-35.8 80-80-35.8-80-80-80-80 35.8-80 80zm112 0c0 17.6-14.4 32-32 32s-32-14.4-32-32 14.4-32 32-32 32 14.4 32 32zm-143.3-6.7l.2-.1c.8-13 3.9-25.2 8.8-36.6-11-6-17.6-13-17.6-20.6 0-22.1 53.7-40 120-40s120 17.9 120 40c0 7.6-6.7 14.6-17.6 20.6 4.9 11.4 8 23.6 8.8 36.6l.2.1C429.3 122.8 448 102.5 448 80c0-44.2-71.6-80-160-80S128 35.8 128 80c0 22.5 18.7 42.8 48.7 57.3z"]
};
var faAngleDoubleDown = {
  prefix: 'far',
  iconName: 'angle-double-down',
  icon: [320, 512, [], "f103", "M151.5 427.8L3.5 281c-4.7-4.7-4.7-12.3 0-17l19.8-19.8c4.7-4.7 12.3-4.7 17 0L160 362.7l119.7-118.5c4.7-4.7 12.3-4.7 17 0l19.8 19.8c4.7 4.7 4.7 12.3 0 17l-148 146.8c-4.7 4.7-12.3 4.7-17 0zm17-160l148-146.8c4.7-4.7 4.7-12.3 0-17l-19.8-19.8c-4.7-4.7-12.3-4.7-17 0L160 202.7 40.3 84.2c-4.7-4.7-12.3-4.7-17 0L3.5 104c-4.7 4.7-4.7 12.3 0 17l148 146.8c4.7 4.7 12.3 4.7 17 0z"]
};
var faAngleDoubleLeft = {
  prefix: 'far',
  iconName: 'angle-double-left',
  icon: [384, 512, [], "f100", "M20.2 247.5L167 99.5c4.7-4.7 12.3-4.7 17 0l19.8 19.8c4.7 4.7 4.7 12.3 0 17L85.3 256l118.5 119.7c4.7 4.7 4.7 12.3 0 17L184 412.5c-4.7 4.7-12.3 4.7-17 0l-146.8-148c-4.7-4.7-4.7-12.3 0-17zm160 17l146.8 148c4.7 4.7 12.3 4.7 17 0l19.8-19.8c4.7-4.7 4.7-12.3 0-17L245.3 256l118.5-119.7c4.7-4.7 4.7-12.3 0-17L344 99.5c-4.7-4.7-12.3-4.7-17 0l-146.8 148c-4.7 4.7-4.7 12.3 0 17z"]
};
var faAngleDoubleRight = {
  prefix: 'far',
  iconName: 'angle-double-right',
  icon: [384, 512, [], "f101", "M363.8 264.5L217 412.5c-4.7 4.7-12.3 4.7-17 0l-19.8-19.8c-4.7-4.7-4.7-12.3 0-17L298.7 256 180.2 136.3c-4.7-4.7-4.7-12.3 0-17L200 99.5c4.7-4.7 12.3-4.7 17 0l146.8 148c4.7 4.7 4.7 12.3 0 17zm-160-17L57 99.5c-4.7-4.7-12.3-4.7-17 0l-19.8 19.8c-4.7 4.7-4.7 12.3 0 17L138.7 256 20.2 375.7c-4.7 4.7-4.7 12.3 0 17L40 412.5c4.7 4.7 12.3 4.7 17 0l146.8-148c4.7-4.7 4.7-12.3 0-17z"]
};
var faAngleDoubleUp = {
  prefix: 'far',
  iconName: 'angle-double-up',
  icon: [320, 512, [], "f102", "M168.5 84.2l148 146.8c4.7 4.7 4.7 12.3 0 17l-19.8 19.8c-4.7 4.7-12.3 4.7-17 0L160 149.3 40.3 267.8c-4.7 4.7-12.3 4.7-17 0L3.5 248c-4.7-4.7-4.7-12.3 0-17l148-146.8c4.7-4.7 12.3-4.7 17 0zm-17 160L3.5 391c-4.7 4.7-4.7 12.3 0 17l19.8 19.8c4.7 4.7 12.3 4.7 17 0L160 309.3l119.7 118.5c4.7 4.7 12.3 4.7 17 0l19.8-19.8c4.7-4.7 4.7-12.3 0-17l-148-146.8c-4.7-4.7-12.3-4.7-17 0z"]
};
var faAngleDown = {
  prefix: 'far',
  iconName: 'angle-down',
  icon: [320, 512, [], "f107", "M151.5 347.8L3.5 201c-4.7-4.7-4.7-12.3 0-17l19.8-19.8c4.7-4.7 12.3-4.7 17 0L160 282.7l119.7-118.5c4.7-4.7 12.3-4.7 17 0l19.8 19.8c4.7 4.7 4.7 12.3 0 17l-148 146.8c-4.7 4.7-12.3 4.7-17 0z"]
};
var faAngleLeft = {
  prefix: 'far',
  iconName: 'angle-left',
  icon: [192, 512, [], "f104", "M4.2 247.5L151 99.5c4.7-4.7 12.3-4.7 17 0l19.8 19.8c4.7 4.7 4.7 12.3 0 17L69.3 256l118.5 119.7c4.7 4.7 4.7 12.3 0 17L168 412.5c-4.7 4.7-12.3 4.7-17 0L4.2 264.5c-4.7-4.7-4.7-12.3 0-17z"]
};
var faAngleRight = {
  prefix: 'far',
  iconName: 'angle-right',
  icon: [192, 512, [], "f105", "M187.8 264.5L41 412.5c-4.7 4.7-12.3 4.7-17 0L4.2 392.7c-4.7-4.7-4.7-12.3 0-17L122.7 256 4.2 136.3c-4.7-4.7-4.7-12.3 0-17L24 99.5c4.7-4.7 12.3-4.7 17 0l146.8 148c4.7 4.7 4.7 12.3 0 17z"]
};
var faAngleUp = {
  prefix: 'far',
  iconName: 'angle-up',
  icon: [320, 512, [], "f106", "M168.5 164.2l148 146.8c4.7 4.7 4.7 12.3 0 17l-19.8 19.8c-4.7 4.7-12.3 4.7-17 0L160 229.3 40.3 347.8c-4.7 4.7-12.3 4.7-17 0L3.5 328c-4.7-4.7-4.7-12.3 0-17l148-146.8c4.7-4.7 12.3-4.7 17 0z"]
};
var faAngry = {
  prefix: 'far',
  iconName: 'angry',
  icon: [496, 512, [], "f556", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm0-144c-33.6 0-65.2 14.8-86.8 40.6-8.5 10.2-7.1 25.3 3.1 33.8s25.3 7.2 33.8-3c24.8-29.7 75-29.7 99.8 0 8.1 9.7 23.2 11.9 33.8 3 10.2-8.5 11.5-23.6 3.1-33.8-21.6-25.8-53.2-40.6-86.8-40.6zm-48-72c10.3 0 19.9-6.7 23-17.1 3.8-12.7-3.4-26.1-16.1-29.9l-80-24c-12.8-3.9-26.1 3.4-29.9 16.1-3.8 12.7 3.4 26.1 16.1 29.9l28.2 8.5c-3.1 4.9-5.3 10.4-5.3 16.6 0 17.7 14.3 32 32 32s32-14.4 32-32.1zm199-54.9c-3.8-12.7-17.1-19.9-29.9-16.1l-80 24c-12.7 3.8-19.9 17.2-16.1 29.9 3.1 10.4 12.7 17.1 23 17.1 0 17.7 14.3 32 32 32s32-14.3 32-32c0-6.2-2.2-11.7-5.3-16.6l28.2-8.5c12.7-3.7 19.9-17.1 16.1-29.8z"]
};
var faAnkh = {
  prefix: 'far',
  iconName: 'ankh',
  icon: [320, 512, [], "f644", "M304 272h-76.92c29.46-36.35 54.82-87.85 54.82-134.86C281.9 52.98 227.33 0 160 0S38.1 52.98 38.1 137.14c0 47 25.36 98.51 54.82 134.86H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h120v176c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16V320h120c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zM160 48c44.21 0 73.9 35.82 73.9 89.14 0 53.83-49.69 119.49-73.9 133.35-24.21-13.85-73.9-79.52-73.9-133.35C86.1 83.82 115.8 48 160 48z"]
};
var faAppleAlt = {
  prefix: 'far',
  iconName: 'apple-alt',
  icon: [448, 512, [], "f5d1", "M415.22 177.62c-18.53-26.47-43.99-43.17-73.58-48.28h-.03c-34.49-5.98-86.14 9.16-117.6 23.77-31.46-14.61-82.95-29.77-117.64-23.77-29.59 5.11-55.05 21.81-73.58 48.28C4.85 217.5-6.55 280.12 3.73 337.17 18.97 421.69 69.96 512 167.23 512c13.44 0 27.62-4.03 42.21-11.97 9-4.88 20.12-4.88 29.12 0 14.59 7.94 28.78 11.97 42.21 11.97 97.26 0 148.25-90.31 163.5-174.84 10.28-57.04-1.12-119.66-29.05-159.54zm-18.19 151.02C392.97 351.25 368.19 464 280.77 464c-5.25 0-11.9-2.12-19.28-6.12-11.56-6.3-24.53-9.45-37.49-9.45s-25.93 3.16-37.49 9.45c-7.37 4-14.03 6.12-19.28 6.12-87.42 0-112.2-112.75-116.26-135.34-8-44.39.5-94.03 21.12-123.5 11.19-15.98 25.46-25.58 42.43-28.5 12.55-2.16 53.83-.07 109.48 30.75 55.68-30.84 97-32.94 109.48-30.75 16.97 2.92 31.24 12.52 42.43 28.5 20.62 29.46 29.12 79.11 21.12 123.48zM222.41 112c18.66 0 52.09-3.26 73.2-24.38C326.17 57.06 319.32.65 319.32.65S313.93 0 305.57 0c-18.66 0-52.09 3.27-73.19 24.38-30.56 30.57-23.71 86.97-23.71 86.97s5.39.65 13.74.65z"]
};
var faAppleCrate = {
  prefix: 'far',
  iconName: 'apple-crate',
  icon: [576, 512, [], "f6b1", "M434.22 50.47c11.29-12.19 14.43-32.03 13.22-50.22-12.88-.86-35.67-.12-50.02 13.28-16.53 16.6-13.77 46.36-13.22 50.22 18.47 1.23 37.77-1.85 50.02-13.28zm-191.69 0c11.29-12.19 14.43-32.03 13.22-50.22-12.88-.86-35.67-.12-50.02 13.28-16.53 16.6-13.77 46.36-13.22 50.22 18.47 1.23 37.77-1.85 50.02-13.28zM560 192h-49.71c3.97-26.97.44-63.55-17.22-89.06-11.25-16.31-27.09-26.7-45.78-30.06l-.29-.05c-18.22-3.02-43.56 3.02-63 11.41-19.5-8.39-44.91-14.39-63.28-11.36-12.35 2.23-23.3 7.82-32.68 15.9-9.39-8.09-20.36-13.67-32.76-15.9l-.28-.05c-18.22-3.02-43.56 3.02-63 11.41-19.47-8.41-45-14.36-63.28-11.36-18.62 3.36-34.44 13.73-45.69 30.03-17.76 25.71-21.32 62.47-17.34 89.09H16c-8.84 0-16 7.16-16 16v288c0 8.84 7.16 16 16 16h544c8.84 0 16-7.16 16-16V208c0-8.84-7.16-16-16-16zm-245.5-61.8c5.25-7.61 10.91-9.41 14.44-10.03 6.78-1.17 28.5 3.37 43.38 11.69l11.69 6.55 11.72-6.56c14.78-8.27 36.19-12.81 43.25-11.69 3.81.7 9.44 2.56 14.62 10.06 10.12 14.66 12.22 40.64 9 58.03-.23 1.37-.76 2.42-1.02 3.75H318.29c2.64-17.95 1.48-40.01-4.47-60.38.27-.42.4-1.01.68-1.42zm-191.97 0c5.25-7.61 10.91-9.41 14.38-10.03 7.03-.95 28.5 3.36 43.38 11.67l11.72 6.56 11.72-6.56c14.78-8.27 36.16-12.81 43.25-11.69 6 1.12 10.69 4.33 14.66 10.09 10.12 14.64 12.19 40.61 8.97 58-.23 1.37-.76 2.42-1.02 3.75h-155.1c-.29-1.47-.87-2.62-1.12-4.14-3.18-16.94-1.03-42.93 9.16-57.65zM528 464H48v-88h480v88zm0-136H48v-88h480v88zM96 304c8.84 0 16-7.16 16-16s-7.16-16-16-16-16 7.16-16 16 7.16 16 16 16zm384 128c8.84 0 16-7.16 16-16s-7.16-16-16-16-16 7.16-16 16 7.16 16 16 16zm-384 0c8.84 0 16-7.16 16-16s-7.16-16-16-16-16 7.16-16 16 7.16 16 16 16zm384-128c8.84 0 16-7.16 16-16s-7.16-16-16-16-16 7.16-16 16 7.16 16 16 16z"]
};
var faArchive = {
  prefix: 'far',
  iconName: 'archive',
  icon: [512, 512, [], "f187", "M464 32H48C21.5 32 0 53.5 0 80v80c0 8.8 7.2 16 16 16h16v272c0 17.7 14.3 32 32 32h384c17.7 0 32-14.3 32-32V176h16c8.8 0 16-7.2 16-16V80c0-26.5-21.5-48-48-48zm-32 400H80V176h352v256zm32-304H48V80h416v48zM204 272h104c6.6 0 12-5.4 12-12v-24c0-6.6-5.4-12-12-12H204c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12z"]
};
var faArchway = {
  prefix: 'far',
  iconName: 'archway',
  icon: [576, 512, [], "f557", "M560 48c8.84 0 16-7.16 16-16V16c0-8.84-7.16-16-16-16H16C7.16 0 0 7.16 0 16v16c0 8.84 7.16 16 16 16h16v416H16.02c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16H176c8.84 0 16-7.16 16-16V320c0-53.02 42.98-96 96-96s96 42.98 96 96v160h.02v16c0 8.84 7.16 16 16 16H560c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16h-16V48h16zm-64 0v40H80V48h416zm-64 416V320c0-79.4-64.6-144-144-144s-144 64.6-144 144v144H80V136h416v328h-64z"]
};
var faArrowAltCircleDown = {
  prefix: 'far',
  iconName: 'arrow-alt-circle-down',
  icon: [512, 512, [], "f358", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.5 0-200-89.5-200-200S145.5 56 256 56s200 89.5 200 200-89.5 200-200 200zm-32-316v116h-67c-10.7 0-16 12.9-8.5 20.5l99 99c4.7 4.7 12.3 4.7 17 0l99-99c7.6-7.6 2.2-20.5-8.5-20.5h-67V140c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12z"]
};
var faArrowAltCircleLeft = {
  prefix: 'far',
  iconName: 'arrow-alt-circle-left',
  icon: [512, 512, [], "f359", "M8 256c0 137 111 248 248 248s248-111 248-248S393 8 256 8 8 119 8 256zm448 0c0 110.5-89.5 200-200 200S56 366.5 56 256 145.5 56 256 56s200 89.5 200 200zm-72-20v40c0 6.6-5.4 12-12 12H256v67c0 10.7-12.9 16-20.5 8.5l-99-99c-4.7-4.7-4.7-12.3 0-17l99-99c7.6-7.6 20.5-2.2 20.5 8.5v67h116c6.6 0 12 5.4 12 12z"]
};
var faArrowAltCircleRight = {
  prefix: 'far',
  iconName: 'arrow-alt-circle-right',
  icon: [512, 512, [], "f35a", "M504 256C504 119 393 8 256 8S8 119 8 256s111 248 248 248 248-111 248-248zm-448 0c0-110.5 89.5-200 200-200s200 89.5 200 200-89.5 200-200 200S56 366.5 56 256zm72 20v-40c0-6.6 5.4-12 12-12h116v-67c0-10.7 12.9-16 20.5-8.5l99 99c4.7 4.7 4.7 12.3 0 17l-99 99c-7.6 7.6-20.5 2.2-20.5-8.5v-67H140c-6.6 0-12-5.4-12-12z"]
};
var faArrowAltCircleUp = {
  prefix: 'far',
  iconName: 'arrow-alt-circle-up',
  icon: [512, 512, [], "f35b", "M256 504c137 0 248-111 248-248S393 8 256 8 8 119 8 256s111 248 248 248zm0-448c110.5 0 200 89.5 200 200s-89.5 200-200 200S56 366.5 56 256 145.5 56 256 56zm20 328h-40c-6.6 0-12-5.4-12-12V256h-67c-10.7 0-16-12.9-8.5-20.5l99-99c4.7-4.7 12.3-4.7 17 0l99 99c7.6 7.6 2.2 20.5-8.5 20.5h-67v116c0 6.6-5.4 12-12 12z"]
};
var faArrowAltDown = {
  prefix: 'far',
  iconName: 'arrow-alt-down',
  icon: [448, 512, [], "f354", "M400 208h-73.8V80c0-26.5-21.5-48-48-48H169.8c-26.5 0-48 21.5-48 48v128H48.1c-42.6 0-64.2 51.7-33.9 81.9l175.9 176c18.7 18.7 49.1 18.7 67.9 0l176-176c30-30.1 8.7-81.9-34-81.9zM224 432L48 256h121.8V80h108.3v176H400L224 432z"]
};
var faArrowAltFromBottom = {
  prefix: 'far',
  iconName: 'arrow-alt-from-bottom',
  icon: [384, 512, [], "f346", "M384 444v24c0 6.6-5.4 12-12 12H12c-6.6 0-12-5.4-12-12v-24c0-6.6 5.4-12 12-12h360c6.6 0 12 5.4 12 12zM14.1 190.1l144-144c18.7-18.7 49.1-18.7 67.9 0l143.9 144c30.2 30.2 8.7 81.9-33.9 81.9h-51.6v80c0 26.5-21.5 48-48 48h-88.6c-26.5 0-48-21.5-48-48v-80H48c-42.7 0-64-51.8-33.9-81.9zM48 224h99.7v128h88.6V224H336L192 80 48 224z"]
};
var faArrowAltFromLeft = {
  prefix: 'far',
  iconName: 'arrow-alt-from-left',
  icon: [448, 512, [], "f347", "M36 448H12c-6.6 0-12-5.4-12-12V76c0-6.6 5.4-12 12-12h24c6.6 0 12 5.4 12 12v360c0 6.6-5.4 12-12 12zM289.9 78.1l144 144c18.7 18.7 18.7 49.1 0 67.9l-144 143.9c-30.2 30.2-81.9 8.7-81.9-33.9v-51.6h-80c-26.5 0-48-21.5-48-48v-88.6c0-26.5 21.5-48 48-48h80V112c0-42.7 51.8-64 81.9-33.9zM256 112v99.7H128v88.6h128V400l144-144-144-144z"]
};
var faArrowAltFromRight = {
  prefix: 'far',
  iconName: 'arrow-alt-from-right',
  icon: [448, 512, [], "f348", "M412 64h24c6.6 0 12 5.4 12 12v360c0 6.6-5.4 12-12 12h-24c-6.6 0-12-5.4-12-12V76c0-6.6 5.4-12 12-12zM158.1 433.9l-144-144c-18.7-18.7-18.7-49.1 0-67.9l144-143.9C188.3 47.9 240 69.4 240 112v51.6h80c26.5 0 48 21.5 48 48v88.6c0 26.5-21.5 48-48 48h-80V400c0 42.7-51.8 64-81.9 33.9zM192 400v-99.7h128v-88.6H192V112L48 256l144 144z"]
};
var faArrowAltFromTop = {
  prefix: 'far',
  iconName: 'arrow-alt-from-top',
  icon: [384, 512, [], "f349", "M0 68V44c0-6.6 5.4-12 12-12h360c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12H12C5.4 80 0 74.6 0 68zm369.9 253.9l-144 144c-18.7 18.7-49.1 18.7-67.9 0l-143.9-144c-30.2-30.2-8.7-81.9 34-81.9h51.6v-80c0-26.5 21.5-48 48-48h88.6c26.5 0 48 21.5 48 48v80H336c42.7 0 64 51.8 33.9 81.9zM336 288h-99.7V160h-88.6v128H48l144 144 144-144z"]
};
var faArrowAltLeft = {
  prefix: 'far',
  iconName: 'arrow-alt-left',
  icon: [448, 512, [], "f355", "M272 431.952v-73.798h128c26.51 0 48-21.49 48-48V201.846c0-26.51-21.49-48-48-48H272V80.057c0-42.638-51.731-64.15-81.941-33.941l-176 175.943c-18.745 18.745-18.746 49.137 0 67.882l176 175.952C220.208 496.042 272 474.675 272 431.952zM48 256L224 80v121.846h176v108.308H224V432L48 256z"]
};
var faArrowAltRight = {
  prefix: 'far',
  iconName: 'arrow-alt-right',
  icon: [448, 512, [], "f356", "M176 80.048v73.798H48c-26.51 0-48 21.49-48 48v108.308c0 26.51 21.49 48 48 48h128v73.789c0 42.638 51.731 64.151 81.941 33.941l176-175.943c18.745-18.745 18.746-49.137 0-67.882l-176-175.952C227.792 15.958 176 37.325 176 80.048zM400 256L224 432V310.154H48V201.846h176V80l176 176z"]
};
var faArrowAltSquareDown = {
  prefix: 'far',
  iconName: 'arrow-alt-square-down',
  icon: [448, 512, [], "f350", "M204 128h40c6.6 0 12 5.4 12 12v116h67c10.7 0 16 12.9 8.5 20.5l-99 99c-4.7 4.7-12.3 4.7-17 0l-99-99c-7.6-7.6-2.2-20.5 8.5-20.5h67V140c0-6.6 5.4-12 12-12zm244-48v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faArrowAltSquareLeft = {
  prefix: 'far',
  iconName: 'arrow-alt-square-left',
  icon: [448, 512, [], "f351", "M352 236v40c0 6.6-5.4 12-12 12H224v67c0 10.7-12.9 16-20.5 8.5l-99-99c-4.7-4.7-4.7-12.3 0-17l99-99c7.6-7.6 20.5-2.2 20.5 8.5v67h116c6.6 0 12 5.4 12 12zm96-156v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faArrowAltSquareRight = {
  prefix: 'far',
  iconName: 'arrow-alt-square-right',
  icon: [448, 512, [], "f352", "M96 276v-40c0-6.6 5.4-12 12-12h116v-67c0-10.7 12.9-16 20.5-8.5l99 99c4.7 4.7 4.7 12.3 0 17l-99 99c-7.6 7.6-20.5 2.2-20.5-8.5v-67H108c-6.6 0-12-5.4-12-12zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faArrowAltSquareUp = {
  prefix: 'far',
  iconName: 'arrow-alt-square-up',
  icon: [448, 512, [], "f353", "M244 384h-40c-6.6 0-12-5.4-12-12V256h-67c-10.7 0-16-12.9-8.5-20.5l99-99c4.7-4.7 12.3-4.7 17 0l99 99c7.6 7.6 2.2 20.5-8.5 20.5h-67v116c0 6.6-5.4 12-12 12zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faArrowAltToBottom = {
  prefix: 'far',
  iconName: 'arrow-alt-to-bottom',
  icon: [384, 512, [], "f34a", "M336 176h-51.6V80c0-26.5-21.5-48-48-48h-88.6c-26.5 0-48 21.5-48 48v96H48.1c-42.6 0-64.2 51.7-33.9 81.9l143.9 144c18.7 18.7 49.1 18.7 67.9 0l144-144c30-30.1 8.7-81.9-34-81.9zM192 368L48 224h99.7V80h88.6v144H336L192 368zm192 76v24c0 6.6-5.4 12-12 12H12c-6.6 0-12-5.4-12-12v-24c0-6.6 5.4-12 12-12h360c6.6 0 12 5.4 12 12z"]
};
var faArrowAltToLeft = {
  prefix: 'far',
  iconName: 'arrow-alt-to-left',
  icon: [448, 512, [], "f34b", "M304 400v-51.6h96c26.5 0 48-21.5 48-48v-88.6c0-26.5-21.5-48-48-48h-96v-51.6c0-42.6-51.7-64.2-81.9-33.9l-144 143.9c-18.7 18.7-18.7 49.1 0 67.9l144 144C252.2 464 304 442.7 304 400zM112 256l144-144v99.7h144v88.6H256V400L112 256zM36 448H12c-6.6 0-12-5.4-12-12V76c0-6.6 5.4-12 12-12h24c6.6 0 12 5.4 12 12v360c0 6.6-5.4 12-12 12z"]
};
var faArrowAltToRight = {
  prefix: 'far',
  iconName: 'arrow-alt-to-right',
  icon: [448, 512, [], "f34c", "M144 112v51.6H48c-26.5 0-48 21.5-48 48v88.6c0 26.5 21.5 48 48 48h96v51.6c0 42.6 51.7 64.2 81.9 33.9l144-143.9c18.7-18.7 18.7-49.1 0-67.9l-144-144C195.8 48 144 69.3 144 112zm192 144L192 400v-99.7H48v-88.6h144V112l144 144zm76-192h24c6.6 0 12 5.4 12 12v360c0 6.6-5.4 12-12 12h-24c-6.6 0-12-5.4-12-12V76c0-6.6 5.4-12 12-12z"]
};
var faArrowAltToTop = {
  prefix: 'far',
  iconName: 'arrow-alt-to-top',
  icon: [384, 512, [], "f34d", "M48 336h51.6v96c0 26.5 21.5 48 48 48h88.6c26.5 0 48-21.5 48-48v-96h51.6c42.6 0 64.2-51.7 33.9-81.9l-143.9-144c-18.7-18.7-49.1-18.7-67.9 0l-144 144C-16 284.2 5.3 336 48 336zm144-192l144 144h-99.7v144h-88.6V288H48l144-144zM0 68V44c0-6.6 5.4-12 12-12h360c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12H12C5.4 80 0 74.6 0 68z"]
};
var faArrowAltUp = {
  prefix: 'far',
  iconName: 'arrow-alt-up',
  icon: [448, 512, [], "f357", "M48.048 304h73.798v128c0 26.51 21.49 48 48 48h108.308c26.51 0 48-21.49 48-48V304h73.789c42.638 0 64.151-51.731 33.941-81.941l-175.943-176c-18.745-18.745-49.137-18.746-67.882 0l-175.952 176C-16.042 252.208 5.325 304 48.048 304zM224 80l176 176H278.154v176H169.846V256H48L224 80z"]
};
var faArrowCircleDown = {
  prefix: 'far',
  iconName: 'arrow-circle-down',
  icon: [512, 512, [], "f0ab", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.5 0-200-89.5-200-200S145.5 56 256 56s200 89.5 200 200-89.5 200-200 200zm129.9-206.1l-19.6-19.6c-4.8-4.8-12.5-4.7-17.2.2L282 300.8V140c0-6.6-5.4-12-12-12h-28c-6.6 0-12 5.4-12 12v160.8l-67.1-70.3c-4.7-4.9-12.4-5-17.2-.2l-19.6 19.6c-4.7 4.7-4.7 12.3 0 17l121.4 121.4c4.7 4.7 12.3 4.7 17 0l121.4-121.4c4.7-4.7 4.7-12.3 0-17z"]
};
var faArrowCircleLeft = {
  prefix: 'far',
  iconName: 'arrow-circle-left',
  icon: [512, 512, [], "f0a8", "M504 256C504 119 393 8 256 8S8 119 8 256s111 248 248 248 248-111 248-248zm-448 0c0-110.5 89.5-200 200-200s200 89.5 200 200-89.5 200-200 200S56 366.5 56 256zm189.1 129.9L123.7 264.5c-4.7-4.7-4.7-12.3 0-17l121.4-121.4c4.7-4.7 12.3-4.7 17 0l19.6 19.6c4.8 4.8 4.7 12.5-.2 17.2L211.2 230H372c6.6 0 12 5.4 12 12v28c0 6.6-5.4 12-12 12H211.2l70.3 67.1c4.9 4.7 5 12.4.2 17.2l-19.6 19.6c-4.7 4.7-12.3 4.7-17 0z"]
};
var faArrowCircleRight = {
  prefix: 'far',
  iconName: 'arrow-circle-right',
  icon: [512, 512, [], "f0a9", "M8 256c0 137 111 248 248 248s248-111 248-248S393 8 256 8 8 119 8 256zm448 0c0 110.5-89.5 200-200 200S56 366.5 56 256 145.5 56 256 56s200 89.5 200 200zM266.9 126.1l121.4 121.4c4.7 4.7 4.7 12.3 0 17L266.9 385.9c-4.7 4.7-12.3 4.7-17 0l-19.6-19.6c-4.8-4.8-4.7-12.5.2-17.2l70.3-67.1H140c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h160.8l-70.3-67.1c-4.9-4.7-5-12.4-.2-17.2l19.6-19.6c4.7-4.7 12.3-4.7 17 0z"]
};
var faArrowCircleUp = {
  prefix: 'far',
  iconName: 'arrow-circle-up',
  icon: [512, 512, [], "f0aa", "M256 504c137 0 248-111 248-248S393 8 256 8 8 119 8 256s111 248 248 248zm0-448c110.5 0 200 89.5 200 200s-89.5 200-200 200S56 366.5 56 256 145.5 56 256 56zM126.1 245.1l121.4-121.4c4.7-4.7 12.3-4.7 17 0l121.4 121.4c4.7 4.7 4.7 12.3 0 17l-19.6 19.6c-4.8 4.8-12.5 4.7-17.2-.2L282 211.2V372c0 6.6-5.4 12-12 12h-28c-6.6 0-12-5.4-12-12V211.2l-67.1 70.3c-4.7 4.9-12.4 5-17.2.2l-19.6-19.6c-4.7-4.7-4.7-12.3 0-17z"]
};
var faArrowDown = {
  prefix: 'far',
  iconName: 'arrow-down',
  icon: [448, 512, [], "f063", "M441.9 250.1l-19.8-19.8c-4.7-4.7-12.3-4.7-17 0L250 385.4V44c0-6.6-5.4-12-12-12h-28c-6.6 0-12 5.4-12 12v341.4L42.9 230.3c-4.7-4.7-12.3-4.7-17 0L6.1 250.1c-4.7 4.7-4.7 12.3 0 17l209.4 209.4c4.7 4.7 12.3 4.7 17 0l209.4-209.4c4.7-4.7 4.7-12.3 0-17z"]
};
var faArrowFromBottom = {
  prefix: 'far',
  iconName: 'arrow-from-bottom',
  icon: [384, 512, [], "f342", "M35.5 183.9l148-148.4c4.7-4.7 12.3-4.7 17 0l148 148.4c4.7 4.7 4.7 12.3 0 17l-19.6 19.6c-4.8 4.8-12.5 4.7-17.1-.2L218 123.2V372c0 6.6-5.4 12-12 12h-28c-6.6 0-12-5.4-12-12V123.2l-93.7 97.1c-4.7 4.8-12.4 4.9-17.1.2l-19.6-19.6c-4.8-4.7-4.8-12.3-.1-17zM372 428H12c-6.6 0-12 5.4-12 12v28c0 6.6 5.4 12 12 12h360c6.6 0 12-5.4 12-12v-28c0-6.6-5.4-12-12-12z"]
};
var faArrowFromLeft = {
  prefix: 'far',
  iconName: 'arrow-from-left',
  icon: [448, 512, [], "f343", "M296.1 99.5l148.4 148c4.7 4.7 4.7 12.3 0 17l-148.4 148c-4.7 4.7-12.3 4.7-17 0l-19.6-19.6c-4.8-4.8-4.7-12.5.2-17.1l97.1-93.7H108c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h248.8l-97.1-93.7c-4.8-4.7-4.9-12.4-.2-17.1l19.6-19.6c4.7-4.9 12.3-4.9 17-.2zM52 436V76c0-6.6-5.4-12-12-12H12C5.4 64 0 69.4 0 76v360c0 6.6 5.4 12 12 12h28c6.6 0 12-5.4 12-12z"]
};
var faArrowFromRight = {
  prefix: 'far',
  iconName: 'arrow-from-right',
  icon: [448, 512, [], "f344", "M151.9 412.5L3.5 264.5c-4.7-4.7-4.7-12.3 0-17l148.4-148c4.7-4.7 12.3-4.7 17 0l19.6 19.6c4.8 4.8 4.7 12.5-.2 17.1L91.2 230H340c6.6 0 12 5.4 12 12v28c0 6.6-5.4 12-12 12H91.2l97.1 93.7c4.8 4.7 4.9 12.4.2 17.1l-19.6 19.6c-4.7 4.8-12.3 4.8-17 .1zM396 76v360c0 6.6 5.4 12 12 12h28c6.6 0 12-5.4 12-12V76c0-6.6-5.4-12-12-12h-28c-6.6 0-12 5.4-12 12z"]
};
var faArrowFromTop = {
  prefix: 'far',
  iconName: 'arrow-from-top',
  icon: [384, 512, [], "f345", "M348.5 328.1l-148 148.4c-4.7 4.7-12.3 4.7-17 0l-148-148.4c-4.7-4.7-4.7-12.3 0-17l19.6-19.6c4.8-4.8 12.5-4.7 17.1.2l93.7 97.1V140c0-6.6 5.4-12 12-12h28c6.6 0 12 5.4 12 12v248.8l93.7-97.1c4.7-4.8 12.4-4.9 17.1-.2l19.6 19.6c4.9 4.7 4.9 12.3.2 17zM12 84h360c6.6 0 12-5.4 12-12V44c0-6.6-5.4-12-12-12H12C5.4 32 0 37.4 0 44v28c0 6.6 5.4 12 12 12z"]
};
var faArrowLeft = {
  prefix: 'far',
  iconName: 'arrow-left',
  icon: [448, 512, [], "f060", "M229.9 473.899l19.799-19.799c4.686-4.686 4.686-12.284 0-16.971L94.569 282H436c6.627 0 12-5.373 12-12v-28c0-6.627-5.373-12-12-12H94.569l155.13-155.13c4.686-4.686 4.686-12.284 0-16.971L229.9 38.101c-4.686-4.686-12.284-4.686-16.971 0L3.515 247.515c-4.686 4.686-4.686 12.284 0 16.971L212.929 473.9c4.686 4.686 12.284 4.686 16.971-.001z"]
};
var faArrowRight = {
  prefix: 'far',
  iconName: 'arrow-right',
  icon: [448, 512, [], "f061", "M218.101 38.101L198.302 57.9c-4.686 4.686-4.686 12.284 0 16.971L353.432 230H12c-6.627 0-12 5.373-12 12v28c0 6.627 5.373 12 12 12h341.432l-155.13 155.13c-4.686 4.686-4.686 12.284 0 16.971l19.799 19.799c4.686 4.686 12.284 4.686 16.971 0l209.414-209.414c4.686-4.686 4.686-12.284 0-16.971L235.071 38.101c-4.686-4.687-12.284-4.687-16.97 0z"]
};
var faArrowSquareDown = {
  prefix: 'far',
  iconName: 'arrow-square-down',
  icon: [448, 512, [], "f339", "M353.9 266.9L232.5 388.3c-4.7 4.7-12.3 4.7-17 0L94.1 266.9c-4.7-4.7-4.7-12.3 0-17l19.6-19.6c4.8-4.8 12.5-4.7 17.2.2l67.1 70.3V140c0-6.6 5.4-12 12-12h28c6.6 0 12 5.4 12 12v160.8l67.1-70.3c4.7-4.9 12.4-5 17.2-.2l19.6 19.6c4.7 4.7 4.7 12.3 0 17zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faArrowSquareLeft = {
  prefix: 'far',
  iconName: 'arrow-square-left',
  icon: [448, 512, [], "f33a", "M213.1 385.9L91.7 264.5c-4.7-4.7-4.7-12.3 0-17l121.4-121.4c4.7-4.7 12.3-4.7 17 0l19.6 19.6c4.8 4.8 4.7 12.5-.2 17.2L179.2 230H340c6.6 0 12 5.4 12 12v28c0 6.6-5.4 12-12 12H179.2l70.3 67.1c4.9 4.7 5 12.4.2 17.2l-19.6 19.6c-4.7 4.7-12.3 4.7-17 0zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faArrowSquareRight = {
  prefix: 'far',
  iconName: 'arrow-square-right',
  icon: [448, 512, [], "f33b", "M234.9 126.1l121.4 121.4c4.7 4.7 4.7 12.3 0 17L234.9 385.9c-4.7 4.7-12.3 4.7-17 0l-19.6-19.6c-4.8-4.8-4.7-12.5.2-17.2l70.3-67.1H108c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h160.8l-70.3-67.1c-4.9-4.7-5-12.4-.2-17.2l19.6-19.6c4.7-4.7 12.3-4.7 17 0zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faArrowSquareUp = {
  prefix: 'far',
  iconName: 'arrow-square-up',
  icon: [448, 512, [], "f33c", "M94.1 245.1l121.4-121.4c4.7-4.7 12.3-4.7 17 0l121.4 121.4c4.7 4.7 4.7 12.3 0 17l-19.6 19.6c-4.8 4.8-12.5 4.7-17.2-.2L250 211.2V372c0 6.6-5.4 12-12 12h-28c-6.6 0-12-5.4-12-12V211.2l-67.1 70.3c-4.7 4.9-12.4 5-17.2.2l-19.6-19.6c-4.7-4.7-4.7-12.3 0-17zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faArrowToBottom = {
  prefix: 'far',
  iconName: 'arrow-to-bottom',
  icon: [384, 512, [], "f33d", "M348.5 232.1l-148 148.4c-4.7 4.7-12.3 4.7-17 0l-148-148.4c-4.7-4.7-4.7-12.3 0-17l19.6-19.6c4.8-4.8 12.5-4.7 17.1.2l93.7 97.1V44c0-6.6 5.4-12 12-12h28c6.6 0 12 5.4 12 12v248.8l93.7-97.1c4.7-4.8 12.4-4.9 17.1-.2l19.6 19.6c4.9 4.7 4.9 12.3.2 17zM372 428H12c-6.6 0-12 5.4-12 12v28c0 6.6 5.4 12 12 12h360c6.6 0 12-5.4 12-12v-28c0-6.6-5.4-12-12-12z"]
};
var faArrowToLeft = {
  prefix: 'far',
  iconName: 'arrow-to-left',
  icon: [448, 512, [], "f33e", "M247.9 412.5l-148.4-148c-4.7-4.7-4.7-12.3 0-17l148.4-148c4.7-4.7 12.3-4.7 17 0l19.6 19.6c4.8 4.8 4.7 12.5-.2 17.1L187.2 230H436c6.6 0 12 5.4 12 12v28c0 6.6-5.4 12-12 12H187.2l97.1 93.7c4.8 4.7 4.9 12.4.2 17.1l-19.6 19.6c-4.7 4.8-12.3 4.8-17 .1zM52 436V76c0-6.6-5.4-12-12-12H12C5.4 64 0 69.4 0 76v360c0 6.6 5.4 12 12 12h28c6.6 0 12-5.4 12-12z"]
};
var faArrowToRight = {
  prefix: 'far',
  iconName: 'arrow-to-right',
  icon: [448, 512, [], "f340", "M200.1 99.5l148.4 148c4.7 4.7 4.7 12.3 0 17l-148.4 148c-4.7 4.7-12.3 4.7-17 0l-19.6-19.6c-4.8-4.8-4.7-12.5.2-17.1l97.1-93.7H12c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h248.8l-97.1-93.7c-4.8-4.7-4.9-12.4-.2-17.1l19.6-19.6c4.7-4.9 12.3-4.9 17-.2zM396 76v360c0 6.6 5.4 12 12 12h28c6.6 0 12-5.4 12-12V76c0-6.6-5.4-12-12-12h-28c-6.6 0-12 5.4-12 12z"]
};
var faArrowToTop = {
  prefix: 'far',
  iconName: 'arrow-to-top',
  icon: [384, 512, [], "f341", "M35.5 279.9l148-148.4c4.7-4.7 12.3-4.7 17 0l148 148.4c4.7 4.7 4.7 12.3 0 17l-19.6 19.6c-4.8 4.8-12.5 4.7-17.1-.2L218 219.2V468c0 6.6-5.4 12-12 12h-28c-6.6 0-12-5.4-12-12V219.2l-93.7 97.1c-4.7 4.8-12.4 4.9-17.1.2l-19.6-19.6c-4.8-4.7-4.8-12.3-.1-17zM12 84h360c6.6 0 12-5.4 12-12V44c0-6.6-5.4-12-12-12H12C5.4 32 0 37.4 0 44v28c0 6.6 5.4 12 12 12z"]
};
var faArrowUp = {
  prefix: 'far',
  iconName: 'arrow-up',
  icon: [448, 512, [], "f062", "M6.101 261.899L25.9 281.698c4.686 4.686 12.284 4.686 16.971 0L198 126.568V468c0 6.627 5.373 12 12 12h28c6.627 0 12-5.373 12-12V126.568l155.13 155.13c4.686 4.686 12.284 4.686 16.971 0l19.799-19.799c4.686-4.686 4.686-12.284 0-16.971L232.485 35.515c-4.686-4.686-12.284-4.686-16.971 0L6.101 244.929c-4.687 4.686-4.687 12.284 0 16.97z"]
};
var faArrows = {
  prefix: 'far',
  iconName: 'arrows',
  icon: [512, 512, [], "f047", "M360.549 412.216l-96.064 96.269c-4.686 4.686-12.284 4.686-16.971 0l-96.064-96.269c-4.686-4.686-4.686-12.284 0-16.971l19.626-19.626c4.753-4.753 12.484-4.675 17.14.173L230 420.78h2V280H91.22v2l44.986 41.783c4.849 4.656 4.927 12.387.173 17.14l-19.626 19.626c-4.686 4.686-12.284 4.686-16.971 0L3.515 264.485c-4.686-4.686-4.686-12.284 0-16.971l96.269-96.064c4.686-4.686 12.284-4.686 16.97 0l19.626 19.626c4.753 4.753 4.675 12.484-.173 17.14L91.22 230v2H232V91.22h-2l-41.783 44.986c-4.656 4.849-12.387 4.927-17.14.173l-19.626-19.626c-4.686-4.686-4.686-12.284 0-16.971l96.064-96.269c4.686-4.686 12.284-4.686 16.971 0l96.064 96.269c4.686 4.686 4.686 12.284 0 16.971l-19.626 19.626c-4.753 4.753-12.484 4.675-17.14-.173L282 91.22h-2V232h140.78v-2l-44.986-41.783c-4.849-4.656-4.927-12.387-.173-17.14l19.626-19.626c4.686-4.686 12.284-4.686 16.971 0l96.269 96.064c4.686 4.686 4.686 12.284 0 16.971l-96.269 96.064c-4.686 4.686-12.284 4.686-16.971 0l-19.626-19.626c-4.753-4.753-4.675-12.484.173-17.14L420.78 282v-2H280v140.78h2l41.783-44.986c4.656-4.849 12.387-4.927 17.14-.173l19.626 19.626c4.687 4.685 4.687 12.283 0 16.969z"]
};
var faArrowsAlt = {
  prefix: 'far',
  iconName: 'arrows-alt',
  icon: [512, 512, [], "f0b2", "M276 236.075h115.85v-76.15c0-10.691 12.926-16.045 20.485-8.485l96.149 96.149c4.686 4.686 4.686 12.284 0 16.971l-96.149 96.149c-7.56 7.56-20.485 2.206-20.485-8.485v-76.149H275.999v115.776h76.15c10.691 0 16.045 12.926 8.485 20.485l-96.149 96.15c-4.686 4.686-12.284 4.686-16.971 0l-96.149-96.149c-7.56-7.56-2.206-20.485 8.485-20.485H236V276.075H120.149v76.149c0 10.691-12.926 16.045-20.485 8.485L3.515 264.56c-4.686-4.686-4.686-12.284 0-16.971l96.149-96.149c7.56-7.56 20.485-2.206 20.485 8.485v76.15H236V120.15h-76.149c-10.691 0-16.045-12.926-8.485-20.485l96.149-96.149c4.686-4.686 12.284-4.686 16.971 0l96.149 96.149c7.56 7.56 2.206 20.485-8.485 20.485H276v115.925z"]
};
var faArrowsAltH = {
  prefix: 'far',
  iconName: 'arrows-alt-h',
  icon: [512, 512, [], "f337", "M508.485 247.515l-99.03-99.029c-7.56-7.56-20.485-2.206-20.485 8.485V228H123.03v-71.03c0-10.691-12.926-16.045-20.485-8.485l-99.03 99.029c-4.686 4.686-4.686 12.284 0 16.971l99.03 99.029c7.56 7.56 20.485 2.206 20.485-8.485V284h265.941v71.03c0 10.691 12.926 16.045 20.485 8.485l99.03-99.029c4.686-4.687 4.686-12.285-.001-16.971z"]
};
var faArrowsAltV = {
  prefix: 'far',
  iconName: 'arrows-alt-v',
  icon: [256, 512, [], "f338", "M227.03 388.97H156V123.03h71.03c10.691 0 16.045-12.926 8.485-20.485l-99.029-99.03c-4.686-4.686-12.284-4.686-16.971 0l-99.029 99.03c-7.56 7.56-2.206 20.485 8.485 20.485H100v265.94H28.97c-10.691 0-16.045 12.926-8.485 20.485l99.029 99.03c4.686 4.686 12.284 4.686 16.971 0l99.029-99.03c7.56-7.559 2.206-20.485-8.484-20.485z"]
};
var faArrowsH = {
  prefix: 'far',
  iconName: 'arrows-h',
  icon: [512, 512, [], "f07e", "M347.404 142.86c-4.753 4.753-4.675 12.484.173 17.14l73.203 70H91.22l73.203-70c4.849-4.656 4.927-12.387.173-17.14l-19.626-19.626c-4.686-4.686-12.284-4.686-16.971 0L3.515 247.515c-4.686 4.686-4.686 12.284 0 16.971L128 388.766c4.686 4.686 12.284 4.686 16.971 0l19.626-19.626c4.753-4.753 4.675-12.484-.173-17.14L91.22 282h329.56l-73.203 70c-4.849 4.656-4.927 12.387-.173 17.14l19.626 19.626c4.686 4.686 12.284 4.686 16.971 0l124.485-124.281c4.686-4.686 4.686-12.284 0-16.971L384 123.234c-4.686-4.686-12.284-4.686-16.971 0l-19.625 19.626z"]
};
var faArrowsV = {
  prefix: 'far',
  iconName: 'arrows-v',
  icon: [320, 512, [], "f07d", "M273.1 347.4c-4.8-4.8-12.5-4.7-17.1.2l-70 73.2V91.2l70 73.2c4.7 4.8 12.4 4.9 17.1.2l19.6-19.6c4.7-4.7 4.7-12.3 0-17L168.5 3.5c-4.7-4.7-12.3-4.7-17 0L27.2 128c-4.7 4.7-4.7 12.3 0 17l19.6 19.6c4.8 4.8 12.5 4.7 17.1-.2l70-73.2v329.6l-70-73.2c-4.7-4.8-12.4-4.9-17.1-.2L27.2 367c-4.7 4.7-4.7 12.3 0 17l124.3 124.5c4.7 4.7 12.3 4.7 17 0L292.8 384c4.7-4.7 4.7-12.3 0-17l-19.7-19.6z"]
};
var faAssistiveListeningSystems = {
  prefix: 'far',
  iconName: 'assistive-listening-systems',
  icon: [512, 512, [], "f2a2", "M189.149 512c-13.255 0-24-10.745-24-24s10.745-24 24-24c36.393 0 66-30.016 66-66.909l.002-.334C256.157 324.62 328 312.824 328 264c0-66.918-53.497-120-120-120-66.38 0-120 52.95-120 120 0 13.255-10.745 24-24 24s-24-10.745-24-24c0-93.338 74.866-168 168-168 92.97 0 168 74.484 168 168 0 74.659-72.099 87.835-72.851 133.282-.106 63.272-51.205 114.718-114 114.718zM296 264c0-48.523-39.477-88-88-88s-88 39.477-88 88c0 13.255 10.745 24 24 24s24-10.745 24-24c0-22.056 17.944-40 40-40s40 17.944 40 40c0 13.255 10.745 24 24 24s24-10.745 24-24zm130.99-71c11.94-5.755 16.955-20.1 11.2-32.04-17.206-35.699-42.929-67.404-74.385-91.688-10.495-8.099-25.564-6.16-33.664 4.333s-6.16 25.563 4.332 33.664c25.581 19.748 46.493 45.521 60.477 74.532 5.759 11.946 20.109 16.951 32.04 11.199zm71.404-35.37c11.945-5.744 16.974-20.083 11.23-32.029-23.882-49.678-55.813-90.241-94.916-120.565-10.475-8.122-25.549-6.218-33.674 4.258-8.122 10.474-6.216 25.55 4.258 33.673 33.17 25.723 60.443 60.522 81.073 103.432 5.744 11.949 20.084 16.972 32.029 11.231zM208 280c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm-64 64c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zM24 464c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm104.971-16.971l-64-64L31.03 416.97l64 64 33.941-33.941z"]
};
var faAsterisk = {
  prefix: 'far',
  iconName: 'asterisk',
  icon: [512, 512, [], "f069", "M479.31 357.216L303.999 256l175.31-101.215c5.74-3.314 7.706-10.653 4.392-16.392l-12-20.785c-3.314-5.74-10.653-7.706-16.392-4.392L280 214.431V12c0-6.627-5.373-12-12-12h-24c-6.627 0-12 5.373-12 12v202.431L56.69 113.215c-5.74-3.314-13.079-1.347-16.392 4.392l-12 20.785c-3.314 5.74-1.347 13.079 4.392 16.392L208 256 32.69 357.216c-5.74 3.314-7.706 10.653-4.392 16.392l12 20.784c3.314 5.739 10.653 7.706 16.392 4.392L232 297.569V500c0 6.627 5.373 12 12 12h24c6.627 0 12-5.373 12-12V297.569l175.31 101.215c5.74 3.314 13.078 1.347 16.392-4.392l12-20.784c3.314-5.739 1.347-13.079-4.392-16.392z"]
};
var faAt = {
  prefix: 'far',
  iconName: 'at',
  icon: [512, 512, [], "f1fa", "M504 232C504 95.751 394.053 8 256 8 118.94 8 8 118.919 8 256c0 137.059 110.919 248 248 248 52.926 0 104.681-17.079 147.096-48.321 5.501-4.052 6.423-11.924 2.095-17.211l-15.224-18.597c-4.055-4.954-11.249-5.803-16.428-2.041C339.547 442.517 298.238 456 256 456c-110.28 0-200-89.72-200-200S145.72 56 256 56c109.469 0 200 65.02 200 176 0 63.106-42.478 98.29-83.02 98.29-19.505 0-20.133-12.62-16.366-31.463l28.621-148.557c1.426-7.402-4.245-14.27-11.783-14.27h-39.175a12.005 12.005 0 0 0-11.784 9.735c-1.102 5.723-1.661 8.336-2.28 13.993-11.923-19.548-35.878-31.068-65.202-31.068C183.412 128.66 120 191.149 120 281.53c0 61.159 32.877 102.11 93.18 102.11 29.803 0 61.344-16.833 79.749-42.239 4.145 30.846 28.497 38.01 59.372 38.01C451.467 379.41 504 315.786 504 232zm-273.9 97.35c-28.472 0-45.47-19.458-45.47-52.05 0-57.514 39.56-93.41 74.61-93.41 30.12 0 45.471 21.532 45.471 51.58 0 46.864-33.177 93.88-74.611 93.88z"]
};
var faAtlas = {
  prefix: 'far',
  iconName: 'atlas',
  icon: [448, 512, [], "f558", "M224 320c66.28 0 120-53.73 120-120 0-66.28-53.72-120-120-120-66.27 0-120 53.72-120 120 0 66.27 53.73 120 120 120zm86.38-136h-34.59c-1.39-23.68-5.75-44.99-12.27-62.19 24.05 12.21 41.81 34.87 46.86 62.19zm-34.59 32h34.59c-5.05 27.32-22.82 49.98-46.86 62.19 6.53-17.21 10.88-38.51 12.27-62.19zM224 114.24c6.91 8.37 17.51 32.39 19.96 69.76h-39.93c2.46-37.37 13.06-61.39 19.97-69.76zM243.96 216c-2.45 37.37-13.05 61.39-19.96 69.76-6.91-8.37-17.51-32.39-19.96-69.76h39.92zm-59.49-94.19c-6.52 17.2-10.87 38.51-12.27 62.19h-34.59c5.06-27.32 22.82-49.98 46.86-62.19zM172.21 216c1.4 23.68 5.75 44.98 12.27 62.19-24.04-12.21-41.8-34.87-46.86-62.19h34.59zM448 384V16c0-8.8-7.2-16-16-16H80C35.8 0 0 35.8 0 80v352c0 44.2 35.8 80 80 80h352c8.8 0 16-7.2 16-16v-16c0-7.8-5.6-14.3-12.9-15.7-4.2-13-4.2-51.6 0-64.6 7.4-1.5 12.9-7.9 12.9-15.7zm-54 80H80c-17.7 0-32-14.3-32-32 0-17.6 14.4-32 32-32h314c-2.7 17.3-2.7 46.7 0 64zm6-112H80c-11.4 0-22.2 2.4-32 6.7V80c0-17.7 14.3-32 32-32h320v304z"]
};
var faAtom = {
  prefix: 'far',
  iconName: 'atom',
  icon: [448, 512, [], "f5d2", "M439.22 128.31C409.26 74.65 326.97 88.8 316.7 90.36 296.45 37.14 265.31 0 224 0s-72.44 37.13-92.69 90.34c-10.29-1.56-92.57-15.67-122.53 37.97C-10.17 162.29 2.39 208.82 38.5 256 2.39 303.18-10.17 349.71 8.78 383.69c30.5 54.62 114.75 38.99 122.47 37.82C151.5 474.8 182.65 512 224 512s72.5-37.21 92.75-90.49c7.75 1.17 91.97 16.79 122.47-37.82 18.95-33.97 6.39-80.51-29.73-127.69 36.12-47.18 48.68-93.71 29.73-127.69zm-388.46 232c-7.39-13.23-.43-38.3 20.47-67.82 11.16 10.91 23.5 21.65 36.91 32.14 2.16 17.27 5.21 34.11 8.99 50.26-20.39 2.42-56.34 3.45-66.37-14.58zm57.38-172.95c-13.41 10.49-25.75 21.24-36.91 32.14-20.9-29.52-27.86-54.59-20.47-67.82 3.68-6.62 17.52-20.47 66.39-14.66a487.708 487.708 0 0 0-9.01 50.34zM224 48c14.28 0 31.68 19.27 45.82 53.53-14.97 4.58-30.22 10.01-45.8 16.77-15.59-6.77-30.85-12.21-45.83-16.79C192.33 67.26 209.73 48 224 48zm0 416c-14.26 0-31.63-19.22-45.76-53.39 14.92-4.57 30.23-10.27 45.76-17.01 15.53 6.74 30.83 12.44 45.76 17.01C255.63 444.78 238.26 464 224 464zm70.36-165.26c-29.95 21.38-51.76 32.89-70.36 42.01-18.57-9.11-40.39-20.61-70.36-42.01-1.37-17.08-3.07-47.12 0-85.48 30.02-21.44 51.7-32.85 70.36-42 18.72 9.18 40.39 20.6 70.36 42 1.37 17.08 3.07 47.12 0 85.48zm102.88 61.57c-10.02 18.01-45.92 17-66.37 14.58 3.78-16.15 6.83-32.99 8.99-50.26 13.41-10.49 25.75-21.24 36.91-32.14 20.9 29.52 27.85 54.59 20.47 67.82zm-20.48-140.8c-11.16-10.91-23.5-21.65-36.91-32.14a486.552 486.552 0 0 0-9.01-50.33c48.87-5.81 62.71 8.04 66.39 14.66 7.39 13.22.44 38.29-20.47 67.81zM224 224c-17.69 0-32.04 14.33-32.04 32s14.34 32 32.04 32 32.04-14.33 32.04-32-14.35-32-32.04-32z"]
};
var faAtomAlt = {
  prefix: 'far',
  iconName: 'atom-alt',
  icon: [448, 512, [], "f5d3", "M424.99 55.03C385.37 15.43 307.46 28.48 224 82.08 140.54 28.51 62.65 15.49 23.01 55.03c-39.58 39.55-26.55 117.39 27.1 200.81-53.64 83.41-66.67 161.25-27.1 200.81 61.04 60.99 182.86-15.37 200.99-27 18.19 11.68 139.91 87.96 200.99 27 39.58-39.55 26.55-117.39-27.1-200.81 53.64-83.42 66.67-161.26 27.1-200.81zm-33.98 33.94c16.76 16.74 10.58 64.65-23.71 124.33-40.03-50.33-78.23-82.79-100.77-100.67 42.11-24.17 102.23-45.83 124.48-23.66zm-334.02 0c22.34-22.27 82.67-.34 124.47 23.65-50.38 40-82.89 78.21-100.76 100.68-34.29-59.68-40.47-107.59-23.71-124.33zm0 333.72c-16.76-16.74-10.58-64.65 23.71-124.33 40.53 50.97 78.19 82.61 100.82 100.57-59.74 34.29-107.72 40.48-124.53 23.76zm167-52c-45.05-33.43-80.97-69.13-114.96-114.85 19.24-25.88 55.93-71.52 114.96-115.35 59.05 43.84 95.82 89.59 114.96 115.35-33.7 45.35-69.55 81.17-114.96 114.85zm167.02 52c-16.83 16.73-64.8 10.54-124.54-23.75 22.63-17.95 60.3-49.62 100.83-100.58 34.29 59.68 40.47 107.6 23.71 124.33zM224 223.82c-17.69 0-32.04 14.33-32.04 32.01s14.34 32.01 32.04 32.01 32.04-14.33 32.04-32.01-14.35-32.01-32.04-32.01z"]
};
var faAudioDescription = {
  prefix: 'far',
  iconName: 'audio-description',
  icon: [512, 512, [], "f29e", "M464 64H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zm-6 336H54a6 6 0 0 1-6-6V118a6 6 0 0 1 6-6h404a6 6 0 0 1 6 6v276a6 6 0 0 1-6 6zm-212.541-63.861l-57.097-168A12.001 12.001 0 0 0 177 160h-35.894a12.001 12.001 0 0 0-11.362 8.139l-57.097 168C70.003 343.922 75.789 352 84.009 352h29.133a12 12 0 0 0 11.535-8.693l8.574-29.906h51.367l8.793 29.977A12 12 0 0 0 204.926 352h29.172c8.22 0 14.006-8.078 11.361-15.861zm-82.534-97.43l8.822 30.655h-25.606l9.041-30.652c1.277-4.421 2.651-9.994 3.872-15.245 1.22 5.251 2.594 10.823 3.871 15.242zM331.2 160h-57.366c-6.627 0-12 5.373-12 12v168c0 6.627 5.373 12 12 12H331.2c61.041 0 98.96-36.933 98.96-96.386 0-58.977-37.919-95.614-98.96-95.614zm-1.801 145.39h-14.523v-98.78h14.523c28.685 0 46.175 16.767 46.175 49.005 0 32.098-16.399 49.775-46.175 49.775z"]
};
var faAward = {
  prefix: 'far',
  iconName: 'award',
  icon: [448, 512, [], "f559", "M446.34 433.21l-62.35-137.6c4.44-11.43 8.32-14.17 22.34-28.19a44.715 44.715 0 0 0 11.57-43.18c-8.29-30.95-8.3-26.65 0-57.62a44.721 44.721 0 0 0-11.57-43.18c-22.68-22.7-20.52-18.94-28.82-49.92a44.68 44.68 0 0 0-31.61-31.61c-30.96-8.29-27.22-6.13-49.9-28.81a44.714 44.714 0 0 0-43.19-11.58c-30.87 8.27-26.69 8.29-57.62 0A44.72 44.72 0 0 0 152 13.1c-22.66 22.66-18.93 20.51-49.9 28.81a44.68 44.68 0 0 0-31.61 31.61c-8.29 30.96-6.13 27.22-28.81 49.9-11.29 11.29-15.71 27.76-11.57 43.18 8.29 30.95 8.3 26.65 0 57.62a44.715 44.715 0 0 0 11.57 43.18c15.1 15.11 18.02 17.06 22.34 28.19L1.66 433.21c-5.96 13.15 4.85 27.44 20.45 27.44.29 0 .59-.01.88-.02l72.86-2.51 50.13 47.65C150.45 510 156.26 512 162 512c8.53 0 16.92-4.39 20.55-12.4L224 408.13l41.45 91.47c3.63 8.01 12.02 12.4 20.55 12.4 5.75 0 11.56-2 16.01-6.23l50.13-47.65 72.86 2.51c.3.01.59.02.88.02 15.6-.01 26.42-14.29 20.46-27.44zM153.73 446.9l-39.4-37.44-49.99 1.72 29.72-65.59c2.59 1.28 5.18 2.57 8.04 3.34 25.14 6.74 26.79 5.7 43.06 21.97 8.63 8.63 20.07 13.1 31.63 13.1 1.95 0 3.87-.55 5.81-.8l-28.87 63.7zm23.55-111.76c-22.02-22.08-33.74-24.8-60.92-32.09-11.34-42.3-17.04-45.88-39.4-68.24 11.51-42.93 7.89-49.38 0-78.79 30.96-30.96 31.22-37.69 39.41-68.24 29.09-7.78 37.07-8.22 68.25-39.4 42.62 11.42 49.19 7.94 78.79 0 21.29 21.29 25.65 27.98 68.24 39.4 11.34 42.3 17.04 45.88 39.4 68.25-11.33 42.3-8.19 48.26 0 78.81-21.29 21.29-27.98 25.66-39.4 68.25-26.27 7.04-38.28 9.44-60.93 32.09-31.14-18.18-67.02-15.45-93.44-.04zm176.51 75.01l-20.12-.69-39.4 37.44-28.87-63.7c1.94.26 3.86.8 5.81.8 11.55 0 23-4.47 31.63-13.1 16.41-16.41 17.81-15.2 43.06-21.97 2.85-.76 5.44-2.06 8.04-3.34l29.72 65.58-29.87-1.02zM320 192c0-53.02-42.98-96-96-96s-96 42.98-96 96 42.98 96 96 96 96-42.98 96-96zm-96 48c-26.47 0-48-21.53-48-48s21.53-48 48-48 48 21.53 48 48-21.53 48-48 48z"]
};
var faAxe = {
  prefix: 'far',
  iconName: 'axe',
  icon: [640, 512, [], "f6b2", "M525.74 160l-58.59-58.59 39.92-39.92c6.25-6.25 6.25-16.38 0-22.63L473.13 4.93c-6.25-6.25-16.38-6.25-22.63 0l-39.92 39.92-35.46-35.48C368.87 3.12 360.68 0 352.49 0s-16.38 3.12-22.63 9.37l-96.49 96.49c-12.5 12.5-12.5 32.76 0 45.25l35.47 35.47L4.69 450.74c-6.25 6.25-6.25 16.38 0 22.63l33.94 33.94c6.25 6.25 16.38 6.25 22.63 0l264.16-264.16L384 301.74V416h32c123.71 0 224-100.29 224-224v-32H525.74zM432 367.28v-85.42l-4.69-4.69-148.68-148.68 73.85-73.87 148.7 148.7 4.69 4.69h85.42c-7.64 84.3-74.98 151.64-159.29 159.27z"]
};
var faAxeBattle = {
  prefix: 'far',
  iconName: 'axe-battle',
  icon: [512, 512, [], "f6b3", "M512 176.38c-3.73-68.04-31.19-128.82-73.55-171.67-3.19-3.23-7.04-4.7-10.83-4.7-7.08 0-13.96 5.14-16.01 13.66-4.69 19.52-30.54 106.3-131.61 106.3V80c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v39.96c-100.01 0-126.17-86.81-130.85-106.3C99.1 5.15 92.21 0 85.13 0c-3.79 0-7.64 1.48-10.83 4.7C28.71 50.83 0 117.62 0 192c0 74.38 28.71 141.17 74.31 187.3 3.19 3.22 7.04 4.7 10.83 4.7 7.08 0 13.96-5.14 16.01-13.66 4.69-19.5 30.84-106.3 130.85-106.3V496c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16V264.03c101.07 0 126.91 86.78 131.61 106.3 2.05 8.52 8.93 13.66 16.01 13.66 3.79 0 7.64-1.48 10.83-4.7 42.36-42.85 69.82-103.63 73.55-171.67L496.73 192 512 176.38zM76.88 303.53C58.27 270.65 48.07 231.96 48.07 192c0-39.97 10.2-78.65 28.81-111.53 31.76 53.46 84.2 87.5 155.12 87.5v48.07c-70.69-.01-123.23 33.82-155.12 87.49zm385.16-78.3c-3.96 28.21-12.87 54.77-26.17 78.31-31.48-53.01-83.46-87.51-155.87-87.51v-48.07c71.15 0 123.69-33.33 155.87-87.5 13.29 23.54 22.21 50.1 26.17 78.31L429.56 192l32.48 33.23z"]
};
var faBaby = {
  prefix: 'far',
  iconName: 'baby',
  icon: [384, 512, [], "f77c", "M192 160c44.2 0 80-35.8 80-80S236.2 0 192 0s-80 35.8-80 80 35.8 80 80 80zm135.6 56.2l42.8-30c14.5-10.1 18-30.1 7.8-44.6-10.1-14.5-30.1-18-44.6-7.8l-42.8 30c-58.9 41.3-138.9 41.3-197.8 0l-42.8-30c-14.5-10.2-34.5-6.6-44.6 7.8-10.2 14.5-6.7 34.4 7.8 44.6l42.8 30c17.4 12.2 36.2 21.4 55.6 28.5v40.2c-9.4 5.6-16 15.4-16 27.1v18.7c0 6.2 2.3 11.9 5.6 17L63 396c-9.1 11.4-9.3 27.5-.6 39.2l48 64c6.3 8.4 15.9 12.8 25.6 12.8 6.7 0 13.4-2.1 19.2-6.4 14.2-10.6 17-30.7 6.4-44.8l-33.1-44.2 18.3-22.9c11.3 9 25.2 14.2 39.8 14.2h11c14.6 0 28.5-5.2 39.8-14.2l18.3 22.9-33.1 44.2c-10.6 14.1-7.8 34.2 6.4 44.8 5.8 4.3 12.5 6.4 19.2 6.4 9.8 0 19.3-4.4 25.6-12.8l48-64c8.8-11.7 8.5-27.8-.6-39.2l-38.6-48.3c3.3-5.1 5.6-10.8 5.6-17V312c0-11.7-6.6-21.5-16-27.1v-40.2c19.3-7.1 38-16.3 55.4-28.5zM256 330.7l-35.9 35.9c-6 6-14.1 9.4-22.6 9.4h-11c-8.5 0-16.6-3.3-22.6-9.4L128 330.7V312h128v18.7z"]
};
var faBabyCarriage = {
  prefix: 'far',
  iconName: 'baby-carriage',
  icon: [512, 512, [], "f77d", "M496 96h-40c-30.9 0-56 25.1-56 56v40H293.2L189.1 28.2C179.9 13.7 164.7 3.8 147.3.9c-17.2-2.8-34.4 1.6-47.5 12C41.1 59.8-.3 138.8 0 216c.2 50.1 17.6 99.5 60.3 138.7C25.7 363.6 0 394.7 0 432c0 44.2 35.8 80 80 80s80-35.8 80-80c0-8.9-1.8-17.2-4.4-25.2 21.6 5.9 44.6 9.2 68.4 9.2s46.9-3.3 68.4-9.2c-2.7 8-4.4 16.3-4.4 25.2 0 44.2 35.8 80 80 80s80-35.8 80-80c0-37.3-25.7-68.4-60.3-77.3C425 320.4 448 274.6 448 224v-72c0-4.4 3.6-8 8-8h40c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zM129.8 50.4c3.5-2.7 7.5-2.5 9.7-2.2 3.8.6 7.3 2.8 9.2 5.7L236.3 192H49.4c6.5-54.7 35-105.4 80.4-141.6zM80 464c-17.6 0-32-14.4-32-32s14.4-32 32-32 32 14.4 32 32-14.4 32-32 32zm320-32c0 17.6-14.4 32-32 32s-32-14.4-32-32 14.4-32 32-32 32 14.4 32 32zm-176-64c-90.4 0-165.2-56.1-174.9-128h349.8c-9.7 71.9-84.5 128-174.9 128z"]
};
var faBackpack = {
  prefix: 'far',
  iconName: 'backpack',
  icon: [448, 512, [], "f5d4", "M320 80h-8V56c0-30.88-25.12-56-56-56h-64c-30.88 0-56 25.12-56 56v24h-8C57.31 80 0 137.31 0 208v240c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V208c0-70.69-57.31-128-128-128zM184 56c0-4.41 3.59-8 8-8h64c4.41 0 8 3.59 8 8v24h-80V56zm136 408H128v-64h192v64zm0-112H128v-32c0-17.67 14.33-32 32-32h128c17.67 0 32 14.33 32 32v32zm80 96c0 8.82-7.18 16-16 16h-16V320c0-44.11-35.89-80-80-80H160c-44.11 0-80 35.89-80 80v144H64c-8.82 0-16-7.18-16-16V208c0-44.11 35.89-80 80-80h192c44.11 0 80 35.89 80 80v240zm-96-288H144c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h160c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16z"]
};
var faBackspace = {
  prefix: 'far',
  iconName: 'backspace',
  icon: [640, 512, [], "f55a", "M469.65 181.65l-11.31-11.31c-6.25-6.25-16.38-6.25-22.63 0L384 222.06l-51.72-51.72c-6.25-6.25-16.38-6.25-22.63 0l-11.31 11.31c-6.25 6.25-6.25 16.38 0 22.63L350.06 256l-51.72 51.72c-6.25 6.25-6.25 16.38 0 22.63l11.31 11.31c6.25 6.25 16.38 6.25 22.63 0L384 289.94l51.72 51.72c6.25 6.25 16.38 6.25 22.63 0l11.31-11.31c6.25-6.25 6.25-16.38 0-22.63L417.94 256l51.72-51.72c6.24-6.25 6.24-16.38-.01-22.63zM576 64H205.26C188.28 64 172 70.74 160 82.74L9.37 233.37c-12.5 12.5-12.5 32.76 0 45.25L160 429.25c12 12 28.28 18.75 45.25 18.75H576c35.35 0 64-28.65 64-64V128c0-35.35-28.65-64-64-64zm16 320c0 8.82-7.18 16-16 16H205.26c-4.27 0-8.29-1.66-11.31-4.69L54.63 256l139.31-139.31c3.02-3.02 7.04-4.69 11.31-4.69H576c8.82 0 16 7.18 16 16v256z"]
};
var faBackward = {
  prefix: 'far',
  iconName: 'backward',
  icon: [512, 512, [], "f04a", "M267.5 281.2l192 159.4c20.6 17.2 52.5 2.8 52.5-24.6V96c0-27.4-31.9-41.8-52.5-24.6L267.5 232c-15.3 12.8-15.3 36.4 0 49.2zM464 130.3V382L313 256.6l151-126.3zM11.5 281.2l192 159.4c20.6 17.2 52.5 2.8 52.5-24.6V96c0-27.4-31.9-41.8-52.5-24.6L11.5 232c-15.3 12.8-15.3 36.4 0 49.2zM208 130.3V382L57 256.6l151-126.3z"]
};
var faBacon = {
  prefix: 'far',
  iconName: 'bacon',
  icon: [576, 512, [], "f7e5", "M566.93 104.4L470.81 8.91a31 31 0 0 0-40.18-2.83c-13.64 10.1-25.15 14.39-41 20.3C247 79.52 209.26 191.29 200.65 214.11c-29.75 78.82-89.55 94.67-98.72 98.08-24.86 9.26-54.73 20.38-91.07 50.36C-3 374-3.63 395 9.07 407.61l96.14 95.49a30.73 30.73 0 0 0 21.71 8.9 31.05 31.05 0 0 0 18.47-6.08c13.6-10.06 25.09-14.34 40.94-20.24 142.2-53 180-164.1 188.94-187.69C405 219.18 464.8 203.3 474 199.86c24.87-9.26 54.74-20.4 91.11-50.41 13.89-11.4 14.52-32.45 1.82-45.05zM83.14 413.53l-26.06-25.89c23.06-16.11 42.75-23.44 62.56-30.79 74.36-25.31 109.53-82.38 125.91-125.79l1-2.57c28-75.17 81.75-128 159.85-157.13 13.55-5 26.5-9.87 40.61-18.47l22.41 22.27c-13.09 7.23-25.26 11.84-37.73 16.55-28.28 10.6-57.57 21.59-97.35 61.37s-50.78 69.06-61.34 97.36c-9.88 26.27-19.16 51.06-54 85.95s-59.66 44.16-85.91 54c-15.82 5.9-31.95 12.1-49.95 23.14zm373.17-258.32C381.87 180.56 346.73 237.64 330.36 281l-.91 2.42c-28.06 75.28-81.86 128.18-159.9 157.25-13.51 5-26.43 9.84-40.51 18.41l-22.41-22.27c13-7.21 25.17-11.83 37.62-16.5 28.28-10.6 57.53-21.57 97.31-61.33s50.75-69 61.35-97.35c9.87-26.26 19.15-51.06 54.06-86s59.69-44.19 86-54c15.76-5.91 31.9-12.13 49.92-23.19l26.07 25.9c-23.12 16.18-42.82 23.51-62.65 30.87z"]
};
var faBadge = {
  prefix: 'far',
  iconName: 'badge',
  icon: [512, 512, [], "f335", "M256 512c-36.2 0-68.2-18.6-86.7-46.7-33.1 6.8-68.7-2.6-94.3-28.3-25.6-25.6-35.1-61.4-28.3-94.3C18.7 324.3 0 292.3 0 256c0-36.2 18.6-68.2 46.7-86.7-6.8-32.8 2.6-68.7 28.3-94.3 25.6-25.6 61.4-35.1 94.3-28.3C187.7 18.7 219.7 0 256 0c36.3 0 68.2 18.7 86.7 46.7 32.8-6.8 68.7 2.6 94.3 28.3 25.6 25.6 35.1 61.4 28.3 94.3 27.9 18.3 46.7 50.2 46.7 86.7 0 36.2-18.6 68.2-46.7 86.7 6.8 32.8-2.6 68.7-28.3 94.3-25.6 25.6-61.2 35.1-94.3 28.3-18.4 27.9-50.3 46.7-86.7 46.7zm-61.2-108.2c6.5 17.4 15.9 60.2 61.2 60.2 43.9 0 53.5-39.6 61.2-60.2 30.5 13.8 57.8 27.3 85.8-.7 31-31 9.8-65.9.7-85.8 17.4-6.5 60.2-15.9 60.2-61.2 0-43.9-39.6-53.5-60.2-61.2 7.7-16.9 31.3-53.8-.7-85.8-31-31-65.9-9.8-85.8-.7C310.7 90.8 301.3 48 256 48c-43.9 0-53.5 39.6-61.2 60.2-16.9-7.7-53.8-31.3-85.8.7-31 31-9.8 65.9-.7 85.8-17.5 6.6-60.3 16-60.3 61.3 0 43.9 39.6 53.5 60.2 61.2-7.7 16.9-31.3 53.8.7 85.8 31 31 64.8 10.4 85.9.8z"]
};
var faBadgeCheck = {
  prefix: 'far',
  iconName: 'badge-check',
  icon: [512, 512, [], "f336", "M332.73 178.37c-3.85-3.88-10.11-3.9-13.98-.06l-87.36 86.66-37.88-38.19c-3.84-3.88-10.11-3.9-13.98-.06l-23.4 23.21c-3.88 3.85-3.9 10.11-.06 13.98l68.05 68.6c3.85 3.88 10.11 3.9 13.98.06l117.78-116.83c3.88-3.85 3.9-10.11.06-13.98l-23.21-23.39zM512 256c0-36.5-18.8-68.4-46.7-86.7 6.8-32.9-2.7-68.7-28.3-94.3-25.6-25.7-61.5-35.1-94.3-28.3C324.2 18.7 292.3 0 256 0s-68.3 18.7-86.7 46.7C136.4 39.9 100.6 49.4 75 75c-25.7 25.6-35.1 61.5-28.3 94.3C18.6 187.8 0 219.8 0 256c0 36.3 18.7 68.3 46.7 86.7-6.8 32.9 2.7 68.7 28.3 94.3 25.6 25.7 61.2 35.1 94.3 28.3 18.5 28.1 50.5 46.7 86.7 46.7 36.4 0 68.3-18.8 86.7-46.7 33.1 6.8 68.7-2.7 94.3-28.3 25.7-25.6 35.1-61.5 28.3-94.3 28.1-18.5 46.7-50.5 46.7-86.7zm-108.3 61.3c9.1 19.9 30.3 54.8-.7 85.8-28 28-55.3 14.5-85.8.7-7.7 20.6-17.3 60.2-61.2 60.2-45.3 0-54.7-42.8-61.2-60.2-21.1 9.6-54.9 30.2-85.9-.8-32-32-8.4-68.9-.7-85.8C87.6 309.5 48 299.9 48 256c0-45.3 42.8-54.7 60.3-61.3-9.1-19.9-30.3-54.8.7-85.8 32-32 68.9-8.4 85.8-.7C202.5 87.6 212.1 48 256 48c45.3 0 54.7 42.8 61.2 60.4 19.9-9.1 54.8-30.3 85.8.7 32 32 8.4 68.9.7 85.8 20.6 7.7 60.2 17.3 60.2 61.2 0 45.3-42.8 54.7-60.2 61.2z"]
};
var faBadgeDollar = {
  prefix: 'far',
  iconName: 'badge-dollar',
  icon: [512, 512, [], "f645", "M286.41 239.72l-50.07-14.3a8.46 8.46 0 0 1-6.12-8.11c0-4.64 3.78-8.42 8.44-8.42h32.78c3.6 0 7.08.77 10.26 2.22 4.8 2.21 10.37 1.71 14.11-2.03l17.52-17.52c5.27-5.27 4.67-14.28-1.55-18.38-9.5-6.27-20.35-10.11-31.78-11.46V144c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v17.56c-30.29 3.62-53.37 30.98-49.32 63.05 2.9 22.95 20.66 41.31 42.91 47.67l50.07 14.3a8.46 8.46 0 0 1 6.12 8.11c0 4.64-3.78 8.42-8.44 8.42h-32.78c-3.6 0-7.08-.77-10.26-2.22-4.8-2.21-10.37-1.71-14.11 2.03l-17.52 17.52c-5.27 5.27-4.67 14.28 1.55 18.38 9.5 6.27 20.35 10.11 31.78 11.46V368c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-17.56c30.29-3.62 53.37-30.98 49.32-63.05-2.9-22.95-20.66-41.31-42.91-47.67zM512 256c0-36.5-18.8-68.4-46.7-86.7 6.8-32.9-2.7-68.7-28.3-94.3-25.6-25.7-61.5-35.1-94.3-28.3C324.2 18.7 292.3 0 256 0s-68.3 18.7-86.7 46.7C136.4 39.9 100.6 49.4 75 75c-25.7 25.6-35.1 61.5-28.3 94.3C18.6 187.8 0 219.8 0 256c0 36.3 18.7 68.3 46.7 86.7-6.8 32.9 2.7 68.7 28.3 94.3 25.6 25.7 61.2 35.1 94.3 28.3 18.5 28.1 50.5 46.7 86.7 46.7 36.4 0 68.3-18.8 86.7-46.7 33.1 6.8 68.7-2.7 94.3-28.3 25.7-25.6 35.1-61.5 28.3-94.3 28.1-18.5 46.7-50.5 46.7-86.7zm-108.3 61.3c9.1 19.9 30.3 54.8-.7 85.8-28 28-55.3 14.5-85.8.7-7.7 20.6-17.3 60.2-61.2 60.2-45.3 0-54.7-42.8-61.2-60.2-21.1 9.6-54.9 30.2-85.9-.8-32-32-8.4-68.9-.7-85.8C87.6 309.5 48 299.9 48 256c0-45.3 42.8-54.7 60.3-61.3-9.1-19.9-30.3-54.8.7-85.8 32-32 68.9-8.4 85.8-.7C202.5 87.6 212.1 48 256 48c45.3 0 54.7 42.8 61.2 60.4 19.9-9.1 54.8-30.3 85.8.7 32 32 8.4 68.9.7 85.8 20.6 7.7 60.2 17.3 60.2 61.2 0 45.3-42.8 54.7-60.2 61.2z"]
};
var faBadgePercent = {
  prefix: 'far',
  iconName: 'badge-percent',
  icon: [512, 512, [], "f646", "M341.65 181.65l-11.31-11.31c-6.25-6.25-16.38-6.25-22.63 0L170.35 307.72c-6.25 6.25-6.25 16.38 0 22.63l11.31 11.31c6.25 6.25 16.38 6.25 22.63 0l137.37-137.37c6.24-6.26 6.24-16.39-.01-22.64zM192 224c17.67 0 32-14.33 32-32s-14.33-32-32-32-32 14.33-32 32 14.33 32 32 32zm128 64c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm192-32c0-36.5-18.8-68.4-46.7-86.7 6.8-32.9-2.7-68.7-28.3-94.3-25.6-25.7-61.5-35.1-94.3-28.3C324.2 18.7 292.3 0 256 0s-68.3 18.7-86.7 46.7C136.4 39.9 100.6 49.4 75 75c-25.7 25.6-35.1 61.5-28.3 94.3C18.6 187.8 0 219.8 0 256c0 36.3 18.7 68.3 46.7 86.7-6.8 32.9 2.7 68.7 28.3 94.3 25.6 25.7 61.2 35.1 94.3 28.3 18.5 28.1 50.5 46.7 86.7 46.7 36.4 0 68.3-18.8 86.7-46.7 33.1 6.8 68.7-2.7 94.3-28.3 25.7-25.6 35.1-61.5 28.3-94.3 28.1-18.5 46.7-50.5 46.7-86.7zm-108.3 61.3c9.1 19.9 30.3 54.8-.7 85.8-28 28-55.3 14.5-85.8.7-7.7 20.6-17.3 60.2-61.2 60.2-45.3 0-54.7-42.8-61.2-60.2-21.1 9.6-54.9 30.2-85.9-.8-32-32-8.4-68.9-.7-85.8C87.6 309.5 48 299.9 48 256c0-45.3 42.8-54.7 60.3-61.3-9.1-19.9-30.3-54.8.7-85.8 32-32 68.9-8.4 85.8-.7C202.5 87.6 212.1 48 256 48c45.3 0 54.7 42.8 61.2 60.4 19.9-9.1 54.8-30.3 85.8.7 32 32 8.4 68.9.7 85.8 20.6 7.7 60.2 17.3 60.2 61.2 0 45.3-42.8 54.7-60.2 61.2z"]
};
var faBadgerHoney = {
  prefix: 'far',
  iconName: 'badger-honey',
  icon: [640, 512, [], "f6b4", "M622.25 142.46c-25.64-14.52-42.75-26.42-70.68-45.37-14.21-9.64-29.74-18.01-44.88-24.55C493.37 66.79 479.4 64 465.45 64c-19.05 0-38.09 5.21-55.47 15.21C392.89 89.04 374.06 96 354.96 96H128C57.31 96 0 153.31 0 224v16c0 8.84 7.16 16 16 16h20.03c7.09 30.4 23.81 55.89 45.93 73.08l-12.39 33.03c-6.25 16.83-7.28 34.88-1.97 55.23l13.66 34.23c5.06 16.83 20.53 28.42 38.28 28.42h63.1c12.25 0 24.04-5.28 31.74-14.8 7.99-9.87 10.78-22.65 7.72-34.92l-12.72-34.14L231.14 352h55.08l19.18 95.86c3.75 18.62 20.22 32.14 39.22 32.14h62.66c11.73 0 23.07-4.82 30.79-13.65 8.23-9.42 11.56-21.95 9.14-34.19L421.77 304.9c52.93-31.81 91.06-46.85 119.35-54.67L560 288l23.06-46.11c22.4-2.82 32.95-2.82 40.79-19 7.32-15.11 16.16-35.79 16.16-47.62-.01-13.93-6.89-26.65-17.76-32.81zM128 144h226.96c25.67 0 52.24-7.8 78.97-23.19 10.02-5.77 20.92-8.81 31.53-8.81 7.65 0 15.12 1.55 22.22 4.62 24.46 10.56 33.51 18.62 48.47 27.38H460c-31.69 0-61.5 13.05-93.12 28.33l-100.62 61.02c-9.22 4.42-18.91 6.66-28.75 6.66H192c-36.94 0-71.81-43.97-78.58-94.63 4.73-.89 9.6-1.38 14.58-1.38zm456.67 49.32c-98.73 12.31-162.93 55.59-216.6 87.84 8.85 44.28 4.93 24.65 30.16 150.83h-47.05c-22.36-111.76-15.68-78.35-25.61-128H201.29c-30.77 62.39-23.89 48.44-44.13 89.49 7.88 21.15 5.08 13.63 14.35 38.51h-46.39l-11.69-29.3c-2.54-11.53-.77-18.78 1.07-23.73 14.89-39.67 8.33-22.19 24.81-66.12l-27.91-21.68c-14.08-10.94-24.25-27.3-28.63-46.08L74.12 208H49.61c4.22-20.73 16.66-38.34 33.55-49.88C94.18 216.67 135.67 272 192 272h45.5c14.69 0 29-3.3 43.94-10.55l100.66-61.02C408.91 187.56 435.03 176 460 176h16.81c1.91 9.06 9.56 16 19.19 16s17.29-6.94 19.19-16h80.45c-3.4 5.19-8.99 12.91-10.97 17.32z"]
};
var faBagsShopping = {
  prefix: 'far',
  iconName: 'bags-shopping',
  icon: [576, 512, [], "f847", "M272 240a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-32h80v48h48v-64a32 32 0 0 0-32-32h-96V96a96 96 0 0 0-192 0v64H32a32 32 0 0 0-32 32v256a32 32 0 0 0 32 32h128v-48H48V208h80v32a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-32h96zm-96-80V96a48 48 0 0 1 96 0v64zm368 128H224a32 32 0 0 0-32 32v160a32 32 0 0 0 32 32h320a32 32 0 0 0 32-32V320a32 32 0 0 0-32-32zm-112 48a48 48 0 0 1-96 0zm96 128H240V336h48.3c1.57 47.4 35.8 89.12 83.07 95.19A96.12 96.12 0 0 0 480 336h48z"]
};
var faBalanceScale = {
  prefix: 'far',
  iconName: 'balance-scale',
  icon: [640, 512, [], "f24e", "M256 336h-.02c0-16.18 1.34-8.73-85.05-181.51-8.83-17.65-25.89-26.49-42.95-26.49-17.04 0-34.08 8.82-42.92 26.49C-2.06 328.75.02 320.33.02 336H0c0 44.18 57.31 80 128 80s128-35.82 128-80zM83.24 265.13c11.4-22.65 26.02-51.69 44.46-89.1.03-.01.13-.03.29-.03l.02-.04c19.82 39.64 35.03 69.81 46.7 92.96 11.28 22.38 19.7 39.12 25.55 51.08H55.83c6.2-12.68 15.24-30.69 27.41-54.87zM528 464H344V155.93c27.42-8.67 48.59-31.36 54.39-59.93H528c8.84 0 16-7.16 16-16V64c0-8.84-7.16-16-16-16H393.25C380.89 19.77 352.79 0 320 0s-60.89 19.77-73.25 48H112c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h129.61c5.8 28.57 26.97 51.26 54.39 59.93V464H112c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h416c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zM320 112c-17.64 0-32-14.36-32-32s14.36-32 32-32 32 14.36 32 32-14.36 32-32 32zm319.98 224c0-16.18 1.34-8.73-85.05-181.51-8.83-17.65-25.89-26.49-42.95-26.49-17.04 0-34.08 8.82-42.92 26.49-87.12 174.26-85.04 165.84-85.04 181.51H384c0 44.18 57.31 80 128 80s128-35.82 128-80h-.02zm-200.15-16c6.19-12.68 15.23-30.69 27.4-54.87 11.4-22.65 26.02-51.69 44.46-89.1.03-.01.13-.03.29-.03l.02-.04c19.82 39.64 35.03 69.81 46.7 92.96 11.28 22.38 19.7 39.12 25.55 51.08H439.83z"]
};
var faBalanceScaleLeft = {
  prefix: 'far',
  iconName: 'balance-scale-left',
  icon: [640, 512, [], "f515", "M512 384c70.69 0 128-35.82 128-80h-.02c0-16.18 1.34-8.73-85.05-181.51C546.11 104.84 529.04 96 511.99 96c-17.04 0-34.08 8.82-42.92 26.49-87.13 174.26-85.05 165.84-85.05 181.51H384c0 44.18 57.31 80 128 80zm72.25-96H439.83c6.19-12.68 72-144 72.15-144l.02-.04c19.82 39.64 66.4 132.08 72.25 144.04zM130.36 178.35l131.29-43.93c9.28 9.95 21.06 17.31 34.34 21.51V496c0 8.84 7.16 16 16 16h216c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16H344V155.93c29.77-9.42 51.76-35.54 55.15-67.52l125.71-42.06c8.38-2.8 12.9-11.87 10.1-20.25l-5.08-15.17c-2.8-8.38-11.87-12.9-20.25-10.1L389.47 41.04C375.76 16.66 349.96 0 320 0c-44.18 0-80 35.82-80 80 0 3.66.6 7.16 1.08 10.69l-125.95 42.14c-8.38 2.8-12.9 11.87-10.1 20.25l5.08 15.17c2.81 8.38 11.87 12.9 20.25 10.1zM288 80c0-17.64 14.36-32 32-32s32 14.36 32 32-14.36 32-32 32-32-14.35-32-32zM0 432c0 44.18 57.31 80 128 80s128-35.82 128-80h-.02c0-16.18 1.34-8.73-85.05-181.51-8.83-17.65-25.89-26.49-42.95-26.49-17.04 0-34.08 8.82-42.92 26.49C-2.06 424.75.02 416.33.02 432H0zm55.83-16c6.19-12.68 53.43-106.56 71.87-143.97.03-.01.13-.03.29-.03l.02-.04c19.82 39.64 66.4 132.08 72.25 144.04H55.83z"]
};
var faBalanceScaleRight = {
  prefix: 'far',
  iconName: 'balance-scale-right',
  icon: [640, 512, [], "f516", "M256 304h-.02c0-15.67 2.08-7.25-85.05-181.51C162.1 104.82 145.05 96 128.01 96c-17.06 0-34.12 8.84-42.95 26.49C-1.32 295.27.02 287.82.02 304H0c0 44.18 57.31 80 128 80s128-35.82 128-80zM128 143.96l.02.04c.15 0 65.96 131.32 72.15 144H55.75c5.85-11.96 52.43-104.4 72.25-144.04zm401.89 24.29l5.08-15.17c2.8-8.38-1.72-17.45-10.1-20.25L398.92 90.69C399.4 87.16 400 83.66 400 80c0-44.18-35.82-80-80-80-29.96 0-55.76 16.66-69.47 41.04L130.36.83c-8.38-2.8-17.45 1.72-20.25 10.1l-5.08 15.17c-2.8 8.38 1.72 17.45 10.1 20.25l125.71 42.06c3.39 31.98 25.38 58.1 55.15 67.52V464H112c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h216c8.84 0 16-7.16 16-16V155.93c13.29-4.2 25.06-11.57 34.34-21.51l131.29 43.93c8.39 2.8 17.45-1.72 20.26-10.1zM320 112c-17.64 0-32-14.36-32-32s14.36-32 32-32 32 14.36 32 32-14.36 32-32 32zm319.98 320c0-15.67 2.08-7.25-85.05-181.51-8.84-17.67-25.88-26.5-42.92-26.49-17.06 0-34.12 8.84-42.95 26.49-86.38 172.78-85.04 165.33-85.04 181.51H384c0 44.18 57.31 80 128 80s128-35.82 128-80h-.02zm-200.23-16c5.85-11.96 52.43-104.4 72.25-144.04l.02.04c.15 0 .26.03.29.03 18.44 37.41 65.67 131.29 71.87 143.97H439.75z"]
};
var faBallPile = {
  prefix: 'far',
  iconName: 'ball-pile',
  icon: [576, 512, [], "f77e", "M480 320c-10.4 0-20.3 2.1-29.7 5.2 18.2-17.5 29.7-41.9 29.7-69.2 0-53-43-96-96-96-10.4 0-20.3 2.1-29.7 5.2 18.3-17.5 29.7-42 29.7-69.2 0-53-43-96-96-96s-96 43-96 96c0 27.2 11.4 51.7 29.7 69.2-9.4-3.1-19.2-5.2-29.7-5.2-53 0-96 43-96 96 0 27.2 11.4 51.7 29.7 69.2-9.4-3.1-19.2-5.2-29.7-5.2-53 0-96 43-96 96s43 96 96 96 96-43 96-96c0-27.2-11.4-51.7-29.7-69.2 9.4 3.1 19.2 5.2 29.7 5.2s20.3-2.1 29.7-5.2c-18.3 17.5-29.7 42-29.7 69.2 0 53 43 96 96 96s96-43 96-96c0-27.2-11.4-51.7-29.7-69.2 9.4 3.1 19.2 5.2 29.7 5.2s20.3-2.1 29.7-5.2c-18.3 17.5-29.7 42-29.7 69.2 0 53 43 96 96 96s96-43 96-96-43-96-96-96zM288 48c26.5 0 48 21.5 48 48s-21.5 48-48 48-48-21.5-48-48 21.5-48 48-48zm29.7 277.2c-9.4-3.1-19.2-5.2-29.7-5.2s-20.3 2.1-29.7 5.2c18.2-17.5 29.7-41.9 29.7-69.2s-11.4-51.7-29.7-69.2c9.4 3.1 19.2 5.2 29.7 5.2s20.3-2.1 29.7-5.2c-18.3 17.5-29.7 42-29.7 69.2s11.4 51.7 29.7 69.2zM96 464c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm96-160c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm96 160c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm96-160c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm96 160c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48z"]
};
var faBallot = {
  prefix: 'far',
  iconName: 'ballot',
  icon: [448, 512, [], "f732", "M200 408h144c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8H200c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8zm-88 8h32c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16zm0-128h32c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16zm88-8h144c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8H200c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8zm-88-120h32c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16zm88-8h144c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8H200c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8zM416 0H32C14.3 0 0 14.3 0 32v448c0 17.7 14.3 32 32 32h384c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32zm-16 464H48V48h352v416z"]
};
var faBallotCheck = {
  prefix: 'far',
  iconName: 'ballot-check',
  icon: [448, 512, [], "f733", "M344 360H200c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h144c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8zm-232 56h32c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16zm0-256h32c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16zm88-8h144c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8H200c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8zM416 0H32C14.3 0 0 14.3 0 32v448c0 17.7 14.3 32 32 32h384c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32zm-16 464H48V48h352v416zM134.6 286.4c2.1 2.1 5.5 2.1 7.6 0l64.2-63.6c2.1-2.1 2.1-5.5 0-7.6l-12.6-12.7c-2.1-2.1-5.5-2.1-7.6 0l-47.6 47.2-20.6-20.9c-2.1-2.1-5.5-2.1-7.6 0l-12.7 12.6c-2.1 2.1-2.1 5.5 0 7.6l36.9 37.4zM344 232H237.4c-1.9 5-4.6 9.7-8.5 13.5L194.2 280H344c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8z"]
};
var faBan = {
  prefix: 'far',
  iconName: 'ban',
  icon: [512, 512, [], "f05e", "M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm141.421 106.579c73.176 73.175 77.05 187.301 15.964 264.865L132.556 98.615c77.588-61.105 191.709-57.193 264.865 15.964zM114.579 397.421c-73.176-73.175-77.05-187.301-15.964-264.865l280.829 280.829c-77.588 61.105-191.709 57.193-264.865-15.964z"]
};
var faBandAid = {
  prefix: 'far',
  iconName: 'band-aid',
  icon: [640, 512, [], "f462", "M552 96H88c-48.5 0-88 39.5-88 88v144c0 48.5 39.5 88 88 88h464c48.5 0 88-39.5 88-88V184c0-48.5-39.5-88-88-88zM88 368c-22.1 0-40-17.9-40-40V184c0-22.1 17.9-40 40-40h104v224H88zm184-88c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24zm-24-72c0-13.3 10.7-24 24-24s24 10.7 24 24-10.7 24-24 24-24-10.7-24-24zm96 96c0-13.3 10.7-24 24-24s24 10.7 24 24-10.7 24-24 24-24-10.7-24-24zm24-72c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm224 96c0 22.1-17.9 40-40 40H448V144h104c22.1 0 40 17.9 40 40v144z"]
};
var faBarcode = {
  prefix: 'far',
  iconName: 'barcode',
  icon: [512, 512, [], "f02a", "M0 448V64h18v384H0zm26.857-.273V64H36v383.727h-9.143zm27.143 0V64h8.857v383.727H54zm44.857 0V64h8.857v383.727h-8.857zm36 0V64h17.714v383.727h-17.714zm44.857 0V64h8.857v383.727h-8.857zm18 0V64h8.857v383.727h-8.857zm18 0V64h8.857v383.727h-8.857zm35.715 0V64h18v383.727h-18zm44.857 0V64h18v383.727h-18zm35.999 0V64h18.001v383.727h-18.001zm36.001 0V64h18.001v383.727h-18.001zm26.857 0V64h18v383.727h-18zm45.143 0V64h26.857v383.727h-26.857zm35.714 0V64h9.143v383.727H476zm18 .273V64h18v384h-18z"]
};
var faBarcodeAlt = {
  prefix: 'far',
  iconName: 'barcode-alt',
  icon: [640, 512, [], "f463", "M360 384h48c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8zm96 0h48c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8zm-160 0h16c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8zM592 0H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h544c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48zm0 464H48V48h544v416zm-456-80h48c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8zm96 0h16c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8z"]
};
var faBarcodeRead = {
  prefix: 'far',
  iconName: 'barcode-read',
  icon: [640, 512, [], "f464", "M248 128h-16c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8zm-64 0h-48c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8zm-40 336H48v-96c0-8.8-7.2-16-16-16H16c-8.8 0-16 7.2-16 16v128c0 8.8 7.2 16 16 16h128c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zM16 160h16c8.8 0 16-7.2 16-16V48h96c8.8 0 16-7.2 16-16V16c0-8.8-7.2-16-16-16H16C7.2 0 0 7.2 0 16v128c0 8.8 7.2 16 16 16zm496 216V136c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8zM312 128h-16c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8zm312 224h-16c-8.8 0-16 7.2-16 16v96h-96c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h128c8.8 0 16-7.2 16-16V368c0-8.8-7.2-16-16-16zm0-352H496c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h96v96c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V16c0-8.8-7.2-16-16-16zM408 128h-48c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8z"]
};
var faBarcodeScan = {
  prefix: 'far',
  iconName: 'barcode-scan',
  icon: [640, 512, [], "f465", "M632 232H8c-4.4 0-8 2.7-8 6v36c0 3.3 3.6 6 8 6h624c4.4 0 8-2.7 8-6v-36c0-3.3-3.6-6-8-6zM288 8c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152h64V8zm96 0c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v152h32V8zm96 0c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152h64V8zM160 8c0-4.4-3.6-8-8-8H72c-4.4 0-8 3.6-8 8v152h96V8zm416 0c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152h64V8zm-64 496c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V352h-64v152zm-160 0c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V352h-32v152zm64 0c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V352h-64v152zm-192 0c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V352h-64v152zm-160 0c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V352H64v152z"]
};
var faBars = {
  prefix: 'far',
  iconName: 'bars',
  icon: [448, 512, [], "f0c9", "M436 124H12c-6.627 0-12-5.373-12-12V80c0-6.627 5.373-12 12-12h424c6.627 0 12 5.373 12 12v32c0 6.627-5.373 12-12 12zm0 160H12c-6.627 0-12-5.373-12-12v-32c0-6.627 5.373-12 12-12h424c6.627 0 12 5.373 12 12v32c0 6.627-5.373 12-12 12zm0 160H12c-6.627 0-12-5.373-12-12v-32c0-6.627 5.373-12 12-12h424c6.627 0 12 5.373 12 12v32c0 6.627-5.373 12-12 12z"]
};
var faBaseball = {
  prefix: 'far',
  iconName: 'baseball',
  icon: [640, 512, [], "f432", "M625.6 54.5l-16.7-22c-27.1-37-77.6-41.9-112.3-16.9L308.8 152.2c-48.1 34.7-92 73.3-131 117.8-54.8 62.6-106 101.2-135.6 122.5-8.4-9.8-23-11.3-33.2-3.3-10.3 8.3-12 23.4-3.7 33.7l64 80c7.8 9.8 22.9 12.4 33.8 3.7 9.3-7.5 11.2-20.4 5.4-30.4 29.1-21 81.9-56.6 156-87.9 54.7-23.1 106.5-52.2 154.6-86.9L605 166c35.9-25.9 46.7-75.9 20.6-111.5zm-547 383.4l-7.1-8.9c35.9-27 77.4-61.6 111.6-95.1l21.6 29.5c-42.8 21.5-89.1 49.1-126.1 74.5zM576 128.4L390.9 264c-75 52.8-136.4 76-161.7 87.6l-27.1-37.1c18.9-20.2 59.8-69.3 134.8-123.4L524.7 54.9c13.6-9.8 34.3-8.9 45.5 6.3l13 21.5c10.3 14.3 7.2 34-7.2 45.7zM512 320c-52.9 0-96 43.1-96 96s43.1 96 96 96 96-43.1 96-96-43.1-96-96-96zm0 144c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48z"]
};
var faBaseballBall = {
  prefix: 'far',
  iconName: 'baseball-ball',
  icon: [496, 512, [], "f433", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zM114 404c12-14.4 22.5-30 30.8-47.1l-26.8-13c-6.8 13.9-15.3 26.5-24.9 38.4-55.4-67.7-64.8-173.4 0-252.7 9.6 11.8 18.1 24.4 24.8 38.2l26.8-13.1c-8.3-17-18.7-32.5-30.7-46.8 73.3-66.4 188.4-72 268 0-12 14.3-22.4 29.9-30.7 47l26.8 13c6.8-13.9 15.3-26.5 24.8-38.3 55.8 68.3 64.4 173.9.1 252.7-9.6-11.8-18.1-24.4-24.9-38.3l-26.8 13.1c8.3 17 18.7 32.6 30.8 46.9-73.6 66.7-188.8 71.9-268.1 0zm42.7-76.5l-28.3-9.2c12.2-37.5 14-81.5-.1-124.7l28.3-9.2c16.3 50 14 100.4.1 143.1zm211-9.2l-28.3 9.2c-16.3-50-14-100.5-.1-143.1l28.3 9.2c-12.2 37.4-14 81.5.1 124.7z"]
};
var faBasketballBall = {
  prefix: 'far',
  iconName: 'basketball-ball',
  icon: [496, 512, [], "f434", "M248 8C111 8 0 118.9 0 256c0 137.9 111.6 248 248 248 136.2 0 248-110 248-248C496 119 385.2 8 248 8zm-13.9 447.3c-38.9-2.7-77.1-16.7-109.4-42L248 290l43 43c-29.2 35.1-48.9 77.4-56.9 122.3zm91.5-87.7l45.7 45.7c-26.1 20.5-56.1 33.6-87.2 39.3 7.3-31.1 21.6-59.9 41.5-85zm34-33.9c25-20 53.9-34.2 85.1-41.5-5.8 31.9-19.2 61.7-39.4 87.3l-45.7-45.8zm87.7-91.6c-45 8.1-87.2 27.8-122.4 57l-43-43 123.3-123.4c24.8 31.4 39.4 69.2 42.1 109.4zM139 181c-25.8 20.6-55.8 35-88.1 42.1 5.5-33 19-63.9 39.8-90.4L139 181zm-14.3-82.3C151.1 77.9 182 64.4 215 58.9c-7.1 32.3-21.5 62.3-42.1 88.1l-48.2-48.3zm140.2-41.9c39.1 3.3 75.8 17.8 106.4 41.9L248 222.1l-40.4-40.4c29.7-35.8 49.6-78.9 57.3-124.9zM48.8 273c46-7.8 89.1-27.6 124.8-57.3l40.4 40.4L90.7 379.4C66.6 348.7 52.1 312 48.8 273z"]
};
var faBasketballHoop = {
  prefix: 'far',
  iconName: 'basketball-hoop',
  icon: [640, 512, [], "f435", "M639.9 336.9c0 22.8-13.6 43.2-34.7 51.8l-103.5 42.5 3.8-53.4 81.4-33.5c3-1.2 5-4.2 5-7.4V218.6C509.1 1.6 133.4.7 48 218.7V337c0 3.3 2 6.2 5 7.4l81.4 33.5 3.8 53.4-103.5-42.5C13.6 380.1 0 359.8 0 336.9L1.2 207C1.8 205 68.7 8 320 8s318.1 197 318.8 199c1.6 10.2 1.1-8.5 1.1 129.9zM461.2 512l-75.4-71.6L320 512l-65.8-71.6-75.4 71.6-18.2-224H136c-4.4 0-8-3.6-8-8v-32c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8h-24.6l-18.2 224zM206.7 352.4l46.7 43.6 44-44-42.1-42.1-48.6 42.5zm113.3-23l41.4-41.4h-82.8l41.4 41.4zm22.6 22.6l44 44 46.7-43.6-48.6-42.5-42.1 42.1zm104.7-64h-39l36.5 31.9 2.5-31.9zm-254.6 0l2.6 31.9 36.5-31.9h-39.1zm38.1 130.6l-29.9-27.9 4.3 53.5 25.6-25.6zm132.4-.8L320 374.6l-43.2 43.2 43.2 40.3 43.2-40.3zm71.6 26.4l4.3-53.5-29.9 27.9 25.6 25.6zM464 208v-80H176v80h32v-48h224v48h32z"]
};
var faBat = {
  prefix: 'far',
  iconName: 'bat',
  icon: [640, 512, [], "f6b5", "M638.61 287.25L568.3 129.7c-5.47-12.27-17.85-19.4-30.67-19.4-5.81 0-11.71 1.46-17.1 4.57l-104.9 60.44L384 64l-58.12 48h-11.77L256 64l-31.62 111.3-104.9-60.44a34.122 34.122 0 0 0-17.1-4.57c-12.83 0-25.2 7.13-30.67 19.4L1.39 287.25c-4.91 10.99 3.9 22.34 15.21 22.34 1.75 0 3.55-.27 5.38-.85l16.48-5.28a69.085 69.085 0 0 1 21.07-3.29c21.83 0 42.85 10.33 55.46 28.51l38.4 55.32 12.31-11.82c13.11-12.59 30.14-18.75 47.08-18.75 20.13 0 40.15 8.69 53.36 25.6L320 448l53.86-68.97c13.21-16.91 33.23-25.6 53.36-25.6 16.95 0 33.98 6.16 47.09 18.75l12.3 11.82 38.41-55.33c12.61-18.17 33.63-28.51 55.46-28.51 7.02 0 14.13 1.07 21.07 3.29l16.48 5.28c1.82.58 3.63.85 5.38.85 11.3.01 20.11-11.34 15.2-22.33zM485.59 301.3l-10.08 14.51c-14.95-6.8-31.36-10.38-48.3-10.38-36.08 0-69.32 16.06-91.19 44.06L320 370.02l-16.03-20.53c-21.87-28-55.1-44.06-91.19-44.06-16.94 0-33.35 3.58-48.3 10.38l-10.07-14.51c-19.49-28.08-50.74-45.83-84.98-48.72l39.46-88.42 91.53 52.74 53.32 30.72 16.82-59.2 11.54-40.62 1.46 1.2 13.29 11h46.29l13.31-10.99 1.46-1.2 11.54 40.62 16.82 59.2 53.32-30.72 91.53-52.74 39.46 88.43c-34.25 2.87-65.49 20.62-84.99 48.7z"]
};
var faBath = {
  prefix: 'far',
  iconName: 'bath',
  icon: [512, 512, [], "f2cd", "M500 256H80V112c0-17.645 14.355-32 32-32 11.351 0 21.332 5.945 27.015 14.88-16.492 25.207-14.687 59.576 6.838 83.035-4.176 4.713-4.021 11.916.491 16.428l11.314 11.314c4.686 4.686 12.284 4.686 16.971 0l95.03-95.029c4.686-4.686 4.686-12.284 0-16.971l-11.314-11.314c-4.512-4.512-11.715-4.666-16.428-.491-17.949-16.469-42.294-21.429-64.178-15.365C163.281 45.667 139.212 32 112 32c-44.112 0-80 35.888-80 80v144H12c-6.627 0-12 5.373-12 12v24c0 6.627 5.373 12 12 12h20v48c0 32.119 15.777 60.55 40 77.977V468c0 6.627 5.373 12 12 12h24c6.627 0 12-5.373 12-12v-20.334c2.638.218 5.305.334 8 .334h256c2.695 0 5.362-.117 8-.334V468c0 6.627 5.373 12 12 12h24c6.627 0 12-5.373 12-12v-38.023c24.223-17.427 40-45.858 40-77.977v-48h20c6.627 0 12-5.373 12-12v-24c0-6.627-5.373-12-12-12zM176.202 112.201c10.396-10.397 26.553-10.726 37.338-2.025l-39.363 39.363c-8.725-10.813-8.348-26.966 2.025-37.338zM432 352c0 26.467-21.533 48-48 48H128c-26.467 0-48-21.533-48-48v-48h352v48z"]
};
var faBatteryBolt = {
  prefix: 'far',
  iconName: 'battery-bolt',
  icon: [640, 512, [], "f376", "M445.394 223.522L304.616 469.519c-3.522 6.654-9.943 10.481-16.623 10.481-12.266 0-21.553-12.557-18.677-25.843l36.847-166.382h-94.961c-11.6 0-20.566-11.186-19.031-23.775l25.597-213.775C219.04 39.792 227.177 32 236.8 32h108.8c12.604 0 21.8 13.087 18.552 26.411L336.458 192h92.321c14.785 0 24.011 17.55 16.615 31.522zM48 144h110.197l5.747-48H48c-26.51 0-48 21.49-48 48v224c0 26.51 21.49 48 48 48h180.604l10.63-48H48V144zm568 16h-8v-16c0-26.51-21.49-48-48-48H405.38l-9.951 48H560v64h32v96h-32v64H418.017l-27.469 48H560c26.51 0 48-21.49 48-48v-16h8c13.255 0 24-10.745 24-24V184c0-13.255-10.745-24-24-24z"]
};
var faBatteryEmpty = {
  prefix: 'far',
  iconName: 'battery-empty',
  icon: [640, 512, [], "f244", "M560 144v64h32v96h-32v64H48V144h512m0-48H48c-26.51 0-48 21.49-48 48v224c0 26.51 21.49 48 48 48h512c26.51 0 48-21.49 48-48v-16h8c13.255 0 24-10.745 24-24V184c0-13.255-10.745-24-24-24h-8v-16c0-26.51-21.49-48-48-48z"]
};
var faBatteryFull = {
  prefix: 'far',
  iconName: 'battery-full',
  icon: [640, 512, [], "f240", "M560 144v64h32v96h-32v64H48V144h512m0-48H48c-26.51 0-48 21.49-48 48v224c0 26.51 21.49 48 48 48h512c26.51 0 48-21.49 48-48v-16h8c13.255 0 24-10.745 24-24V184c0-13.255-10.745-24-24-24h-8v-16c0-26.51-21.49-48-48-48zm-48 96H96v128h416V192z"]
};
var faBatteryHalf = {
  prefix: 'far',
  iconName: 'battery-half',
  icon: [640, 512, [], "f242", "M320 320H96V192h224v128zm240-176H48v224h512v-64h32v-96h-32v-64m0-48c26.51 0 48 21.49 48 48v16h8c13.255 0 24 10.745 24 24v144c0 13.255-10.745 24-24 24h-8v16c0 26.51-21.49 48-48 48H48c-26.51 0-48-21.49-48-48V144c0-26.51 21.49-48 48-48h512z"]
};
var faBatteryQuarter = {
  prefix: 'far',
  iconName: 'battery-quarter',
  icon: [640, 512, [], "f243", "M224 320H96V192h128v128zm336-176H48v224h512v-64h32v-96h-32v-64m0-48c26.51 0 48 21.49 48 48v16h8c13.255 0 24 10.745 24 24v144c0 13.255-10.745 24-24 24h-8v16c0 26.51-21.49 48-48 48H48c-26.51 0-48-21.49-48-48V144c0-26.51 21.49-48 48-48h512z"]
};
var faBatterySlash = {
  prefix: 'far',
  iconName: 'battery-slash',
  icon: [640, 512, [], "f377", "M36 3.51A16 16 0 0 0 13.51 6l-10 12.49A16 16 0 0 0 6 41l598 467.49a16 16 0 0 0 22.49-2.49l10-12.49A16 16 0 0 0 634 471zM616 160h-8v-16a48 48 0 0 0-48-48H232.24l61.39 48H560v64h32v96h-32v48.25l44.18 34.53A47.74 47.74 0 0 0 608 368v-16h8a24 24 0 0 0 24-24V184a24 24 0 0 0-24-24zM48 368V134.74l-32.79-25.63A47.74 47.74 0 0 0 0 144v224a48 48 0 0 0 48 48h359.76l-61.39-48z"]
};
var faBatteryThreeQuarters = {
  prefix: 'far',
  iconName: 'battery-three-quarters',
  icon: [640, 512, [], "f241", "M416 320H96V192h320v128zm144-176H48v224h512v-64h32v-96h-32v-64m0-48c26.51 0 48 21.49 48 48v16h8c13.255 0 24 10.745 24 24v144c0 13.255-10.745 24-24 24h-8v16c0 26.51-21.49 48-48 48H48c-26.51 0-48-21.49-48-48V144c0-26.51 21.49-48 48-48h512z"]
};
var faBed = {
  prefix: 'far',
  iconName: 'bed',
  icon: [640, 512, [], "f236", "M168 304c48.52 0 88-39.48 88-88s-39.48-88-88-88-88 39.48-88 88 39.48 88 88 88zm0-128c22.06 0 40 17.94 40 40s-17.94 40-40 40-40-17.94-40-40 17.94-40 40-40zm360-48H304c-8.84 0-16 7.16-16 16v192H48V80c0-8.84-7.16-16-16-16H16C7.16 64 0 71.16 0 80v352c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-48h544v48c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16V240c0-61.86-50.14-112-112-112zm64 208H336V176h192c35.29 0 64 28.71 64 64v96z"]
};
var faBeer = {
  prefix: 'far',
  iconName: 'beer',
  icon: [448, 512, [], "f0fc", "M152 152v208c0 13.255-10.745 24-24 24s-24-10.745-24-24V152c0-13.255 10.745-24 24-24s24 10.745 24 24zm72-24c-13.255 0-24 10.745-24 24v208c0 13.255 10.745 24 24 24s24-10.745 24-24V152c0-13.255-10.745-24-24-24zm224 40v145.288c0 27.985-16.418 53.646-41.827 65.373L352 403.664V432c0 26.51-21.49 48-48 48H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h256c26.51 0 48 21.49 48 48v16h24c39.701 0 72 32.299 72 72zM298 80H54c-3.314 0-6 2.678-6 5.992v340.016A5.993 5.993 0 0 0 54 432h244a6 6 0 0 0 6-6V86a6 6 0 0 0-6-6zm102 88c0-13.233-10.767-24-24-24h-24v206.798l34.058-15.719c8.47-3.909 13.942-12.463 13.942-21.791V168z"]
};
var faBell = {
  prefix: 'far',
  iconName: 'bell',
  icon: [448, 512, [], "f0f3", "M439.39 362.29c-19.32-20.76-55.47-51.99-55.47-154.29 0-77.7-54.48-139.9-127.94-155.16V32c0-17.67-14.32-32-31.98-32s-31.98 14.33-31.98 32v20.84C118.56 68.1 64.08 130.3 64.08 208c0 102.3-36.15 133.53-55.47 154.29-6 6.45-8.66 14.16-8.61 21.71.11 16.4 12.98 32 32.1 32h383.8c19.12 0 32-15.6 32.1-32 .05-7.55-2.61-15.27-8.61-21.71zM67.53 368c21.22-27.97 44.42-74.33 44.53-159.42 0-.2-.06-.38-.06-.58 0-61.86 50.14-112 112-112s112 50.14 112 112c0 .2-.06.38-.06.58.11 85.1 23.31 131.46 44.53 159.42H67.53zM224 512c35.32 0 63.97-28.65 63.97-64H160.03c0 35.35 28.65 64 63.97 64z"]
};
var faBellExclamation = {
  prefix: 'far',
  iconName: 'bell-exclamation',
  icon: [448, 512, [], "f848", "M236.46 290.51a31.94 31.94 0 1 0 17 17 31.92 31.92 0 0 0-17-17zM246.29 128h-44.6a16.06 16.06 0 0 0-15.9 17.6l12.8 96a16 16 0 0 0 15.9 14.4h19a16 16 0 0 0 15.9-14.4l12.8-96a16 16 0 0 0-15.9-17.6zM224 512a64 64 0 0 0 64-64H160a64 64 0 0 0 64 64zm215.37-149.7c-19.31-20.77-55.46-52-55.46-154.3 0-77.7-54.47-139.91-127.94-155.16V32A32 32 0 1 0 192 32v20.84C118.56 68.09 64.09 130.3 64.09 208c0 102.3-36.15 133.53-55.46 154.3A31.17 31.17 0 0 0 0 384c.13 16.41 13 32 32.09 32h383.82c19.12 0 32-15.59 32.09-32a31.17 31.17 0 0 0-8.63-21.7zM67.53 368c21.22-28 44.41-74.33 44.53-159.42 0-.2-.06-.38-.06-.58a112 112 0 0 1 224 0c0 .2-.06.38-.06.58.12 85.11 23.31 131.47 44.53 159.42z"]
};
var faBellPlus = {
  prefix: 'far',
  iconName: 'bell-plus',
  icon: [448, 512, [], "f849", "M224 512a64 64 0 0 0 64-64H160a64 64 0 0 0 64 64zm215.37-149.7c-19.31-20.77-55.46-52-55.46-154.3 0-77.7-54.47-139.91-127.94-155.16V32A32 32 0 1 0 192 32v20.84C118.56 68.09 64.09 130.3 64.09 208c0 102.3-36.15 133.53-55.46 154.3A31.17 31.17 0 0 0 0 384c.13 16.41 13 32 32.09 32h383.82c19.12 0 32-15.59 32.09-32a31.17 31.17 0 0 0-8.63-21.7zM67.53 368c21.22-28 44.41-74.33 44.53-159.42 0-.2-.06-.38-.06-.58a112 112 0 0 1 224 0c0 .2-.06.38-.06.58.12 85.11 23.31 131.47 44.53 159.42zM288 216h-40v-40a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v40h-40a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h40v40a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-40h40a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z"]
};
var faBellSchool = {
  prefix: 'far',
  iconName: 'bell-school',
  icon: [512, 512, [], "f5d5", "M208 112c-52.94 0-96 43.06-96 96s43.06 96 96 96 96-43.06 96-96-43.06-96-96-96zm0 144c-26.47 0-48-21.53-48-48s21.53-48 48-48 48 21.53 48 48-21.53 48-48 48zm256 32c-26.51 0-48 21.49-48 48 0 16.43 8.27 30.89 20.86 39.55C430.78 389.9 416.55 400 400 400h-48v-42.26c39.36-37.87 64-90.94 64-149.74C416 93.31 322.69 0 208 0S0 93.31 0 208c0 58.8 24.64 111.88 64 149.74V480c0 17.67 14.33 32 32 32h224c17.67 0 32-14.33 32-32v-32h48c42.2 0 77.48-29.87 85.98-69.56 15.39-8 26.02-23.9 26.02-42.44 0-26.51-21.49-48-48-48zM304 464H112v-71.67c28.75 15.04 61.37 23.67 96 23.67s67.25-8.63 96-23.67V464zm-96-96c-88.22 0-160-71.78-160-160S119.78 48 208 48s160 71.78 160 160-71.78 160-160 160z"]
};
var faBellSchoolSlash = {
  prefix: 'far',
  iconName: 'bell-school-slash',
  icon: [640, 512, [], "f5d6", "M633.99 471.02L36 3.51C29.1-2.01 19.03-.9 13.51 6l-10 12.49C-2.02 25.39-.9 35.46 6 40.98l598 467.51c6.9 5.52 16.96 4.4 22.49-2.49l10-12.49c5.52-6.9 4.41-16.97-2.5-22.49zM576 336c0-26.51-21.49-48-48-48-12.86 0-24.47 5.12-33.09 13.36l74.54 58.28c4.05-6.98 6.55-14.97 6.55-23.64zm-304 32c-88.22 0-160-71.78-160-160 0-7.37 1.21-14.42 2.18-21.53l-42.6-33.31C66.78 170.67 64 189 64 208c0 58.8 24.64 111.87 64 149.74V480c0 17.67 14.33 32 32 32h224c17.67 0 32-14.33 32-32v-57.56l-84.61-66.15C312.99 363.69 293.01 368 272 368zm96 96H176v-71.67c28.75 15.04 61.37 23.67 96 23.67s67.25-8.63 96-23.67V464zM272 48c88.22 0 160 71.78 160 160 0 13.81-2.31 26.99-5.61 39.78L467 279.53c8.25-22.33 13-46.35 13-71.53C480 93.31 386.69 0 272 0c-43.2 0-83.35 13.26-116.64 35.89l40.96 32.02C218.95 55.62 244.48 48 272 48zm-17.08 65.73l112.44 87.91C364.01 151.71 322.76 112 272 112c-5.85 0-11.52.72-17.08 1.73z"]
};
var faBellSlash = {
  prefix: 'far',
  iconName: 'bell-slash',
  icon: [640, 512, [], "f1f6", "M633.99 471.02L36 3.51C29.1-2.01 19.03-.9 13.51 6l-10 12.49C-2.02 25.39-.9 35.46 6 40.98l598 467.51c6.9 5.52 16.96 4.4 22.49-2.49l10-12.49c5.52-6.9 4.41-16.97-2.5-22.49zM163.53 368c16.71-22.03 34.48-55.8 41.4-110.58l-45.47-35.55c-3.27 90.73-36.47 120.68-54.84 140.42-6 6.45-8.66 14.16-8.61 21.71.11 16.4 12.98 32 32.1 32h279.66l-61.4-48H163.53zM320 96c61.86 0 112 50.14 112 112 0 .2-.06.38-.06.58.02 16.84 1.16 31.77 2.79 45.73l59.53 46.54c-8.31-22.13-14.34-51.49-14.34-92.85 0-77.7-54.48-139.9-127.94-155.16V32c0-17.67-14.32-32-31.98-32s-31.98 14.33-31.98 32v20.84c-26.02 5.41-49.45 16.94-69.13 32.72l38.17 29.84C275 103.18 296.65 96 320 96zm0 416c35.32 0 63.97-28.65 63.97-64H256.03c0 35.35 28.65 64 63.97 64z"]
};
var faBells = {
  prefix: 'far',
  iconName: 'bells',
  icon: [640, 512, [], "f77f", "M638.4 313.9c-2.1-5.9-6.4-11.2-12.9-14.5-21-10.8-58.3-24.9-87.4-105-.8-2.2-14.7-40.5-15.4-42.6C503 97.6 451.8 64 397.4 64c-15.1 0-30.5 2.6-45.6 8.1-3.6 1.3-6.6 3.3-10 4.8-14.2-16-32.1-29-53.5-36.8-15-5.5-30.5-8.1-45.6-8.1-54.5 0-105.6 33.6-125.3 87.8-.8 2.1-14.6 40.4-15.4 42.6-29.2 80.1-66.4 94.3-87.4 105-6.5 3.3-10.8 8.6-12.9 14.5-4.6 12.9 1 28.8 16 34.2L99.5 346c-2.1 7-3.5 14.3-3.5 22 0 44.2 35.8 80 80 80 32.6 0 60.5-19.6 72.9-47.6l42.1 15.3c-2.8 6.5-7.5 14.8-3.4 26 4.9 13.1 19.6 21.3 34.3 15.9l76.3-27.8C410 459.1 438.4 480 472 480c44.2 0 80-35.8 80-80 0-8.7-1.9-16.8-4.5-24.6l75-27.3c14.9-5.4 20.5-21.3 15.9-34.2zM176 400c-17.6 0-32-14.4-32-32 0-1.9.6-3.7.9-5.5l58.4 21.2c-5.6 9.6-15.5 16.3-27.3 16.3zM76.1 286.4c23.2-18.2 49.7-49.3 70.9-107.5 9.1-25 5.6-15.6 15.4-42.6 12.2-33.6 44.5-56.2 80.2-56.2 21.5 0 42.5 7.8 59.4 24.8-34.4 35.5-48 88.6-30 138.2.8 2.1 14.8 40.4 15.6 42.6 13.1 36.1 16.2 62.6 15 83.3L76.1 286.4zM504 400c0 17.6-14.4 32-32 32-12.8 0-23.5-7.8-28.4-18.7l58.9-21.5c.8 2.6 1.5 5.3 1.5 8.2zm-156.5-2.9c6-28.8 6.4-69.7-14.8-128-8.6-23.5-5.5-15-15.6-42.6-16.1-44.2 6.8-93.3 51-109.4 44.6-16.2 93.4 7.1 109.4 51 9.7 26.7 5 13.8 15.4 42.6 21.2 58.3 47.8 89.3 70.9 107.6l-216.3 78.8z"]
};
var faBezierCurve = {
  prefix: 'far',
  iconName: 'bezier-curve',
  icon: [640, 512, [], "f55b", "M576 176c35.35 0 64-28.65 64-64s-28.65-64-64-64c-26.8 0-49.45 16.61-58.95 40H400V64c0-17.67-14.33-32-32-32h-96c-17.67 0-32 14.33-32 32v24H122.95C113.45 64.61 90.8 48 64 48 28.65 48 0 76.65 0 112s28.65 64 64 64c26.8 0 49.45-16.61 58.95-40H203C138.68 173.78 94.2 241.52 88.81 320H64c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-96c0-17.67-14.33-32-32-32h-23.19c5.79-66.78 47.39-123.33 105.47-150.54C246.33 182.38 257.73 192 272 192h96c14.27 0 25.67-9.62 29.72-22.54C455.8 196.67 497.4 253.22 503.19 320H480c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-96c0-17.67-14.33-32-32-32h-24.81c-5.39-78.48-49.87-146.22-114.18-184h80.05c9.49 23.39 32.14 40 58.94 40zm-16-65.59l.62-2.4C562.45 100.94 568.78 96 576 96c8.82 0 16 7.18 16 16s-7.18 16-16 16c-7.22 0-13.55-4.94-15.38-12.01l-.62-2.4v-3.18zm-480 3.18l-.62 2.4C77.55 123.06 71.22 128 64 128c-8.82 0-16-7.18-16-16s7.18-16 16-16c7.22 0 13.55 4.94 15.38 12.01l.62 2.39v3.19zM144 368v64H80v-64h64zm208-224h-64V80h64v64zm208 224v64h-64v-64h64z"]
};
var faBible = {
  prefix: 'far',
  iconName: 'bible',
  icon: [448, 512, [], "f647", "M160 208h48v96c0 8.84 7.16 16 16 16h32c8.84 0 16-7.16 16-16v-96h48c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16h-48V96c0-8.84-7.16-16-16-16h-32c-8.84 0-16 7.16-16 16v48h-48c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16zm288 176V16c0-8.8-7.2-16-16-16H80C35.8 0 0 35.8 0 80v352c0 44.2 35.8 80 80 80h352c8.8 0 16-7.2 16-16v-16c0-7.8-5.6-14.3-12.9-15.7-4.2-13-4.2-51.6 0-64.6 7.4-1.5 12.9-7.9 12.9-15.7zm-54 80H80c-17.7 0-32-14.3-32-32 0-17.6 14.4-32 32-32h314c-2.7 17.3-2.7 46.7 0 64zm6-112H80c-11.4 0-22.2 2.4-32 6.7V80c0-17.7 14.3-32 32-32h320v304z"]
};
var faBicycle = {
  prefix: 'far',
  iconName: 'bicycle',
  icon: [640, 512, [], "f206", "M514.115 192.017c-17.637-.285-34.469 3.005-49.832 9.181l-79.29-127.746A20 20 0 0 0 368 64h-68c-6.627 0-12 5.373-12 12v16c0 6.627 5.373 12 12 12h56.874l32.276 52H256v-16c0-6.627-5.373-12-12-12h-96c-11.046 0-20 8.954-20 20s8.954 20 20 20h61.187l-25.65 36.644c-16.797-8.102-35.634-12.643-55.532-12.644C57.375 191.998-.443 250.196.003 320.824.446 391.137 57.583 448 128 448c58.192 0 107.306-38.835 122.859-92H284a20.005 20.005 0 0 0 16.385-8.53l110.038-157.197 19.539 31.48c-28.136 23.519-46.021 58.892-45.962 98.445.104 68.88 57.908 127.158 126.785 127.797 71.601.664 129.787-57.467 129.21-129.048-.556-69.152-56.736-125.812-125.88-126.93zM128 408c-48.523 0-88-39.477-88-88s39.477-88 88-88a87.552 87.552 0 0 1 32.134 6.075L99.615 324.53C90.342 337.781 99.857 356 116 356h92.294c-13.785 30.625-44.589 52-80.294 52zm26.413-92l38.641-55.201c13.409 14.722 21.898 33.997 22.852 55.201h-61.493zm119.174 0h-17.655c-1.069-34.805-16.026-66.113-39.524-88.563L238.413 196h119.174l-84 120zm234.284 91.905c-45.514-2.092-82.216-39.219-83.815-84.752-.924-26.302 9.764-50.177 27.328-66.888l47.843 77.08c3.495 5.631 10.894 7.362 16.524 3.867l13.594-8.438c5.631-3.495 7.362-10.893 3.867-16.524l-47.351-76.287c9.012-2.809 18.641-4.205 28.626-3.928 45.797 1.27 83.314 38.07 85.418 83.837 2.379 51.775-40.258 94.413-92.034 92.033z"]
};
var faBiking = {
  prefix: 'far',
  iconName: 'biking',
  icon: [640, 512, [], "f84a", "M400 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zM128 256a128 128 0 1 0 128 128 128 128 0 0 0-128-128zm0 208a80 80 0 1 1 80-80 80.09 80.09 0 0 1-80 80zm384-208a128 128 0 1 0 128 128 128 128 0 0 0-128-128zm0 208a80 80 0 1 1 80-80 80.09 80.09 0 0 1-80 80zM401 210.73a24 24 0 0 0 15 5.27h64a24 24 0 0 0 0-48h-55.59L351 109.27a24 24 0 0 0-30.62.51l-104 89.11a32 32 0 0 0 3.06 50.94l76.53 51V416a24 24 0 0 0 48 0V288a24 24 0 0 0-10.69-20l-50.11-33.4 71.29-61.1z"]
};
var faBikingMountain = {
  prefix: 'far',
  iconName: 'biking-mountain',
  icon: [640, 512, [], "f84b", "M400 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm224 256h-5.2a110.19 110.19 0 0 0-8.65-20.89l3.67-3.67a16 16 0 0 0 0-22.63l-22.63-22.63a16 16 0 0 0-22.63 0l-3.66 3.67a110.72 110.72 0 0 0-20.9-8.65V272a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v5.2a110.19 110.19 0 0 0-20.89 8.65l-3.67-3.67a16 16 0 0 0-22.63 0l-22.62 22.63a16 16 0 0 0 0 22.63l3.67 3.67A110.45 110.45 0 0 0 405.2 352H400a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h5.2a110.19 110.19 0 0 0 8.65 20.89l-3.67 3.67a16 16 0 0 0 0 22.63l22.62 22.63a16 16 0 0 0 22.63 0l3.67-3.67a110.94 110.94 0 0 0 20.9 8.65v5.2a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-5.2a110.56 110.56 0 0 0 20.9-8.65l3.67 3.67a16 16 0 0 0 22.62 0l22.63-22.63a16 16 0 0 0 0-22.63l-3.67-3.67A110.45 110.45 0 0 0 618.8 416h5.2a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-112 96a64 64 0 1 1 64-64 64 64 0 0 1-64 64zm-272-96h-5.2a110.19 110.19 0 0 0-8.65-20.89l3.67-3.67a16 16 0 0 0 0-22.63l-22.63-22.63a16 16 0 0 0-22.63 0l-3.66 3.67a110.72 110.72 0 0 0-20.9-8.65V272a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v5.2a110.19 110.19 0 0 0-20.89 8.65l-3.67-3.67a16 16 0 0 0-22.63 0l-22.63 22.63a16 16 0 0 0 0 22.63l3.67 3.67A110.45 110.45 0 0 0 21.2 352H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h5.2a110.19 110.19 0 0 0 8.65 20.89l-3.67 3.67a16 16 0 0 0 0 22.63l22.62 22.63a16 16 0 0 0 22.63 0l3.67-3.67A110.94 110.94 0 0 0 96 490.8v5.2a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-5.2a110.56 110.56 0 0 0 20.9-8.65l3.67 3.67a16 16 0 0 0 22.62 0l22.63-22.63a16 16 0 0 0 0-22.63l-3.67-3.67A110.45 110.45 0 0 0 234.8 416h5.2a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-112 96a64 64 0 1 1 64-64 64 64 0 0 1-64 64zm273-237.27a24 24 0 0 0 15 5.27h64a24 24 0 0 0 0-48h-55.59L351 109.27a24 24 0 0 0-30.62.51l-112 96a24 24 0 0 0 2.31 38.22L296 300.84V416a24 24 0 0 0 48 0V288a24 24 0 0 0-10.69-20l-43.23-28.82 70.73-60.63zM159.19 172a35.53 35.53 0 0 0 49.45 3.77l87.3-74.45c16.82-14.24 14.56-37 3.27-49.84C270 18.45 219 13.88 185.93 42L132.2 87.91a34.9 34.9 0 0 0-3.26 49.85zm57.88-93.5c9.92-8.42 24-9.35 35.65-3.43l-65.64 56-13.54-15.31z"]
};
var faBinoculars = {
  prefix: 'far',
  iconName: 'binoculars',
  icon: [512, 512, [], "f1e5", "M511.67 388c-3.46-129.77-61.06-150.16-63.58-243.98-.48-17.65-14.28-32.02-31.93-32.02H416V64c0-17.67-14.33-32-32-32h-80c-17.67 0-32 14.33-32 32v48h-32V64c0-17.67-14.33-32-32-32h-80c-17.67 0-32 14.33-32 32v48h-.16c-17.65 0-31.45 14.38-31.93 32.02C61.39 237.84 3.79 258.23.33 388L0 432c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48V288h64v144c0 26.51 21.49 48 48 48h128c26.51 0 48-21.49 48-48l-.33-44zM320 80h48v32h-48V80zm-176 0h48v32h-48V80zm32 352l-128 .36.31-43.08c1.61-60.24 16.07-91.47 31.39-124.54 13.05-28.17 27.67-59.73 31.4-104.74H176v272zm48-192v-80h64v80h-64zm112 192V160h64.9c3.73 45.01 18.35 76.58 31.4 104.74 15.32 33.07 29.78 64.3 31.37 123.61L464 432H336z"]
};
var faBiohazard = {
  prefix: 'far',
  iconName: 'biohazard',
  icon: [576, 512, [], "f780", "M287.9 112c18.6 0 36.2 3.8 52.8 9.6 13.3-10.3 23.6-24.3 29.5-40.7-25.2-10.9-53-17-82.2-17-29.1 0-56.9 6-82.1 16.9 5.9 16.4 16.2 30.4 29.5 40.7 16.5-5.7 34-9.5 52.5-9.5zM163.6 438.7c12-11.8 20.4-26.4 24.5-42.4-32.9-26.4-54.8-65.3-58.9-109.6-8.5-2.8-17.2-4.6-26.4-4.6-7.6 0-15.2 1-22.5 3.1 4.1 62.8 35.8 118 83.3 153.5zm224.2-42.6c4.1 16 12.5 30.7 24.5 42.5 47.4-35.5 79.1-90.7 83-153.5-7.2-2-14.7-3-22.2-3-9.2 0-18 1.9-26.6 4.7-4.1 44.2-26 82.9-58.7 109.3zm113.5-205c-17.6-10.4-36.3-16.6-55.3-19.9 6-17.7 10-36.4 10-56.2 0-41-14.5-80.8-41-112.2-2.5-3-6.6-3.7-10-1.8-3.3 1.9-4.8 6-3.6 9.7 4.5 13.8 6.6 26.3 6.6 38.5 0 67.8-53.8 122.9-120 122.9S168 117 168 49.2c0-12.1 2.2-24.7 6.6-38.5 1.2-3.7-.3-7.8-3.6-9.7-3.4-1.9-7.5-1.2-10 1.8C134.6 34.2 120 74 120 115c0 19.8 3.9 38.5 10 56.2-18.9 3.3-37.7 9.5-55.3 19.9-34.6 20.5-61 53.3-74.3 92.4-1.3 3.7.2 7.7 3.5 9.8 3.3 2 7.5 1.3 10-1.6 9.4-10.8 19-19.1 29.2-25.1 57.3-33.9 130.8-13.7 163.9 45 33.1 58.7 13.4 134-43.9 167.9-10.2 6.1-22 10.4-35.8 13.4-3.7.8-6.4 4.2-6.4 8.1.1 4 2.7 7.3 6.5 8 39.7 7.8 80.6.8 115.2-19.7 18-10.6 32.9-24.5 45.3-40.1 12.4 15.6 27.3 29.5 45.3 40.1 34.6 20.5 75.5 27.5 115.2 19.7 3.8-.7 6.4-4 6.5-8 0-3.9-2.6-7.3-6.4-8.1-13.9-2.9-25.6-7.3-35.8-13.4-57.3-33.9-77-109.2-43.9-167.9s106.6-78.9 163.9-45c10.2 6.1 19.8 14.3 29.2 25.1 2.5 2.9 6.7 3.6 10 1.6s4.8-6.1 3.5-9.8c-13.1-39.1-39.5-72-74.1-92.4zm-213.4 129c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48z"]
};
var faBirthdayCake = {
  prefix: 'far',
  iconName: 'birthday-cake',
  icon: [448, 512, [], "f1fd", "M192 64c0-31 32-23 32-64 12 0 32 29.5 32 56s-14.25 40-32 40-32-14.25-32-32zm160 32c17.75 0 32-13.5 32-40S364 0 352 0c0 41-32 33-32 64 0 17.75 14.25 32 32 32zm96 176v240H0V272c0-26.5 21.5-48 48-48h24V112h48v112h80V112h48v112h80V112h48v112h24c26.5 0 48 21.5 48 48zm-400 6v56.831c8.352 7 15.27 13.169 26.75 13.169 25.378 0 30.13-32 74.75-32 43.974 0 49.754 32 74.5 32 25.588 0 30.061-32 74.75-32 44.473 0 49.329 32 74.75 32 11.258 0 18.135-6.18 26.5-13.187v-56.805a6 6 0 0 0-6-6L54 272a6 6 0 0 0-6 6zm352 186v-80.87c-7.001 2.914-15.54 4.87-26.5 4.87-44.544 0-49.389-32-74.75-32-25.144 0-30.329 32-74.75 32-43.974 0-49.755-32-74.5-32-25.587 0-30.062 32-74.75 32-11.084 0-19.698-1.974-26.75-4.911V464h352zM96 96c17.75 0 32-13.5 32-40S108 0 96 0c0 41-32 33-32 64 0 17.75 14.25 32 32 32z"]
};
var faBlanket = {
  prefix: 'far',
  iconName: 'blanket',
  icon: [512, 512, [], "f498", "M440 368H112c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h328c39.8 0 71.7-32.5 71.6-72.4l.4.4V88c0-48.5-39.5-88-88-88H88C39.5 0 0 39.5 0 88v304l.3-.5c0 8.4.5 17 2.3 25.7C14.1 473.3 66.2 512 123.4 512H496c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16H120c-42.2 0-76-36.5-71.6-79.5C52.2 347 86.6 320 124.3 320H440c13.2 0 24 10.8 24 24s-10.8 24-24 24zm-4.3-96H120c-27 0-51.9 9.2-72 24.3V88c0-22.1 17.9-40 40-40h336c22.1 0 40 17.9 40 40v189.3c-8.9-3.4-18.4-5.3-28.3-5.3z"]
};
var faBlender = {
  prefix: 'far',
  iconName: 'blender',
  icon: [512, 512, [], "f517", "M425.91 330.01L512 0H48C21.49 0 0 21.49 0 48v160c0 26.51 21.49 48 48 48h102.26l6.17 70.99C121.06 341.14 96 375.57 96 416v64c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32v-64c0-37.92-22.17-70.39-54.09-85.99zM48 208V48h84.17l13.91 160H48zM449.87 48l-12.52 48H296c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h133l-16.7 64H296c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h107.96l-25.04 96H204.01L180.36 48h269.51zM432 464H144v-48c0-26.47 21.53-48 48-48h192c26.47 0 48 21.53 48 48v48zm-144-72c-13.26 0-24 10.74-24 24 0 13.25 10.74 24 24 24s24-10.75 24-24c0-13.26-10.74-24-24-24z"]
};
var faBlenderPhone = {
  prefix: 'far',
  iconName: 'blender-phone',
  icon: [576, 512, [], "f6b6", "M352 392c-13.26 0-24 10.74-24 24 0 13.25 10.74 24 24 24s24-10.75 24-24c0-13.26-10.74-24-24-24zm137.91-61.99L576 0H192l28.43 326.99C185.06 341.14 160 375.57 160 416v64c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32v-64c0-37.92-22.17-70.39-54.09-85.99zM513.87 48l-12.52 48H360c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h133l-16.7 64H360c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h107.96l-25.04 96H268.01L244.36 48h269.51zM496 464H208v-48c0-26.47 21.53-48 48-48h192c26.47 0 48 21.53 48 48v48zM115.78 122.61c7.43.73 14.46-3.46 17.24-10.26l25.78-63.26c3.02-7.39.2-15.85-6.68-20.07l-39.28-24.1C98.51-3.87 80.09-.5 68.95 11.97c-92.57 103.6-92 259.55 2.1 362.49 9.87 10.8 29.12 12.48 41.65 4.8l39.41-24.18c6.88-4.22 9.7-12.67 6.68-20.07l-25.78-63.26c-2.78-6.81-9.8-10.99-17.24-10.26l-45.03 4.42c-17.28-46.94-17.65-99.78 0-147.72l45.04 4.42z"]
};
var faBlind = {
  prefix: 'far',
  iconName: 'blind',
  icon: [384, 512, [], "f29d", "M192.913 510.276c-12.325 4.929-26.281-1.079-31.196-13.37l-50.539-126.341 22.976-71.801 72.129 180.316c4.923 12.307-1.063 26.274-13.37 31.196zM96 0C71.699 0 52 19.699 52 44s19.699 44 44 44 44-19.699 44-44S120.301 0 96 0zm12.53 140.603a4.002 4.002 0 0 1 5.605.802L219.2 281.6c5.429 7.239 15.514 8.364 22.399 3.2 7.051-5.288 8.472-15.373 3.2-22.399l-120-160c-3.14-4.188-7.939-6.385-12.8-6.386L80 96v.009c-4.69.003-9.336 2.049-12.494 5.996L0 186.388v85.161c0 8.616 6.621 16.029 15.227 16.433C24.416 288.414 32 281.093 32 272v-74.388l32-40v176.64L17.142 480.679c-4.039 12.624 2.92 26.133 15.544 30.173 12.63 4.041 26.134-2.924 30.173-15.544L128 291.746V173.333l-20.275-27.132a4.003 4.003 0 0 1 .805-5.598zm274.307 359.245L252.28 284.813a24.013 24.013 0 0 1-12.67 9.96L369.161 508.15a8 8 0 0 0 10.989 2.687 7.998 7.998 0 0 0 2.687-10.989z"]
};
var faBlog = {
  prefix: 'far',
  iconName: 'blog',
  icon: [512, 512, [], "f781", "M208.8 96c-9.1-.7-16.8 7-16.8 16.2v16c0 8.6 6.8 15.3 15.4 15.8 85.3 5.9 153.2 75.3 160.4 160.7.7 8.5 7.3 15.2 15.8 15.2h16.2c9.1 0 16.8-7.7 16.2-16.8-8.3-110.4-96.7-198.9-207.2-207.1zm-.1-96C199.6-.4 192 7.2 192 16.3v16c0 8.6 6.8 15.3 15.4 15.8C345.6 55.8 457.2 166.4 464 304.5c.4 8.6 7.2 15.5 15.8 15.5h16c9.1 0 16.7-7.6 16.3-16.7C503.5 139.9 372.1 8.5 208.7 0zM137 224h-9c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h10.9c47 0 88 38.4 84.9 85.3-2.6 39.9-34.6 71.8-74.4 74.5C102.4 451 64 410 64 362.9V112c0-8.8-7.2-16-16-16H16c-8.8 0-16 7.2-16 16v249c0 82.6 66.5 153.7 149 150.9 75.4-2.6 136.3-63.5 138.9-138.9 2.9-82.5-68.3-149-150.9-149z"]
};
var faBold = {
  prefix: 'far',
  iconName: 'bold',
  icon: [384, 512, [], "f032", "M314.52 238.78A119.76 119.76 0 0 0 232 32H48a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16v352H48a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h208a128 128 0 0 0 128-128c0-49.49-28.38-91.92-69.48-113.22zM128 80h88a72 72 0 0 1 0 144h-88zm112 352H128V272h112a80 80 0 0 1 0 160z"]
};
var faBolt = {
  prefix: 'far',
  iconName: 'bolt',
  icon: [384, 512, [], "f0e7", "M377.8 167.9c-8.2-14.3-23.1-22.9-39.6-22.9h-94.4l28.7-87.5c3.7-13.8.8-28.3-7.9-39.7C255.8 6.5 242.5 0 228.2 0H97.7C74.9 0 55.4 17.1 52.9 37.1L.5 249.3c-1.9 13.8 2.2 27.7 11.3 38.2C20.9 298 34.1 304 48 304h98.1l-34.9 151.7c-3.2 13.7-.1 27.9 8.6 38.9 8.7 11.1 21.8 17.4 35.9 17.4 16.3 0 31.5-8.8 38.8-21.6l183.2-276.7c8.4-14.3 8.4-31.5.1-45.8zM160.1 457.4L206.4 256H47.5L97.7 48l127.6-.9L177.5 193H334L160.1 457.4z"]
};
var faBomb = {
  prefix: 'far',
  iconName: 'bomb',
  icon: [512, 512, [], "f1e2", "M384.5 144.5l56-56-17-17-56 56-52.2-52.2c-6.2-6.2-16.4-6.2-22.6 0l-28.4 28.4c-17.9-5-36.8-7.7-56.3-7.7C93.1 96 0 189.1 0 304s93.1 208 208 208 208-93.1 208-208c0-19.5-2.7-38.4-7.7-56.3l28.4-28.4c6.2-6.2 6.2-16.4 0-22.6l-52.2-52.2zm-30 89.1c7.9 28.2 13.5 43.9 13.5 70.4 0 88.4-71.6 160-160 160S48 392.4 48 304s71.6-160 160-160c26.3 0 41.4 5.4 70.4 13.5l25.6-25.6 76.1 76.1-25.6 25.6zM512 72c0 6.6-5.4 12-12 12h-24c-6.6 0-12-5.4-12-12s5.4-12 12-12h24c6.6 0 12 5.4 12 12zm-60-60v24c0 6.6-5.4 12-12 12s-12-5.4-12-12V12c0-6.6 5.4-12 12-12s12 5.4 12 12zm5 43c-4.7-4.7-4.7-12.3 0-17l17-17c4.7-4.7 12.3-4.7 17 0 4.7 4.7 4.7 12.3 0 17l-17 17c-4.7 4.7-12.3 4.7-17 0zm-67.9-16.9c-4.7-4.7-4.7-12.3 0-17 4.7-4.7 12.3-4.7 17 0l17 17c4.7 4.7 4.7 12.3 0 17-4.7 4.7-12.3 4.7-17 0l-17-17zm101.8 67.8c4.7 4.7 4.7 12.3 0 17-4.7 4.7-12.3 4.7-17 0l-17-17c-4.7-4.7-4.7-12.3 0-17 4.7-4.7 12.3-4.7 17 0l17 17zM216 208c0 13.3-10.7 24-24 24-30.9 0-56 25.1-56 56 0 13.3-10.7 24-24 24s-24-10.7-24-24c0-57.3 46.7-104 104-104 13.3 0 24 10.7 24 24z"]
};
var faBone = {
  prefix: 'far',
  iconName: 'bone',
  icon: [640, 512, [], "f5d7", "M640 183.23C640 135.14 598.38 96 547.19 96c-39.72 0-75 23.73-87.84 59.06C458.23 158.3 452.72 176 448 176H192c-4.72 0-10.23-17.7-11.34-20.94C167.81 119.73 132.53 96 92.81 96 41.62 96 0 135.14 0 183.23c0 29.45 8.09 53.34 32.34 72.77C7.93 275.57 0 299.54 0 328.77 0 376.86 41.62 416 92.81 416c39.72 0 75-23.73 87.84-59.05 1.09-3.23 6.89-20.95 11.34-20.95h256c4.45 0 10.25 17.73 11.34 20.95 12.84 35.31 48.12 59.05 87.84 59.05 51.19 0 92.81-39.14 92.81-87.23 0-29.23-7.93-53.19-32.34-72.77 24.27-19.43 32.36-43.31 32.36-72.77zm-72.06 104.3c19.34 8.88 24.06 23.12 24.06 41.23 0 21.64-20.09 39.23-44.81 39.23-19.59 0-36.75-11.02-42.72-27.41C494.42 310.66 483.78 288 448 288H192c-35.78 0-46.42 22.66-56.47 52.59-5.97 16.39-23.12 27.41-42.72 27.41C68.09 368 48 350.41 48 328.77c0-18.12 4.72-32.36 24.06-41.23 12.62-5.81 20.5-17.89 20.5-31.53s-7.84-25.7-20.5-31.53C52.28 215.39 48 200.72 48 183.23 48 161.59 68.09 144 92.81 144c19.59 0 36.75 11.02 42.72 27.42C154.17 225.19 176.64 224 192 224h256c15.36 0 37.83 1.19 56.47-52.58 5.97-16.41 23.12-27.42 42.72-27.42 24.72 0 44.81 17.59 44.81 39.23 0 17.48-4.28 32.16-24.06 41.23-12.66 5.83-20.5 17.89-20.5 31.53s7.87 25.73 20.5 31.54z"]
};
var faBoneBreak = {
  prefix: 'far',
  iconName: 'bone-break',
  icon: [640, 512, [], "f5d8", "M640 87.23C640 39.14 598.37 0 547.19 0c-39.72 0-75 23.73-87.84 59.06C458.23 62.3 452.72 80 448 80h-80c-26.51 0-48 21.49-48 48h128c15.36 0 37.83 1.19 56.47-52.58C510.44 59.02 527.59 48 547.19 48 571.91 48 592 65.59 592 87.23c0 17.48-4.28 32.16-24.06 41.23-12.66 5.83-20.5 17.89-20.5 31.53s7.88 25.72 20.5 31.53c19.34 8.88 24.06 23.12 24.06 41.23 0 21.64-20.09 39.23-44.81 39.23-19.59 0-36.75-11.02-42.72-27.41C494.42 214.66 483.78 192 448 192h-16c-26.51 0-48 21.49-48 48h64c4.45 0 10.25 17.73 11.34 20.95 12.84 35.31 48.12 59.05 87.84 59.05 51.19 0 92.81-39.14 92.81-87.23 0-29.23-7.93-53.19-32.34-72.77C631.91 140.57 640 116.69 640 87.23zM234.24 323.01c-10.86 10.86-27.6 25.91-2.75 77.11 7.38 15.82 3.04 35.74-10.82 49.6-17.48 17.48-44.13 19.25-59.43 3.95-12.36-12.36-19.71-25.77-12.14-46.17 4.83-13.07 1.85-27.15-7.8-36.79s-23.76-12.62-36.79-7.8c-19.95 7.4-33.36.67-46.17-12.14-15.3-15.3-13.53-41.95 3.95-59.43 13.85-13.85 33.78-18.2 49.59-10.83 28.27 14.06 51.82 22.56 77.12-2.74l58.45-58.45c18.74-18.74 18.74-49.14 0-67.88l-92.38 92.38c-3.15 3.15-19.79-5.28-22.84-6.79-34.05-15.89-75.78-7.72-103.87 20.36-36.2 36.19-37.95 93.3-3.95 127.31 20.67 20.67 43.22 32 74.32 28.58-3.41 30.89 7.76 53.5 28.58 74.32 34.01 34.01 91.12 32.25 127.31-3.94 28.09-28.09 36.25-69.82 20.35-103.88-1.5-3.07-10.12-19.49-6.78-22.83l26.44-26.44c18.75-18.75 18.75-49.14 0-67.88l-60.39 60.38z"]
};
var faBong = {
  prefix: 'far',
  iconName: 'bong',
  icon: [448, 512, [], "f55c", "M443.31 217.37l-52.69-52.69c-6.25-6.25-16.38-6.25-22.63 0l-11.31 11.31c-6.25 6.25-6.25 16.38 0 22.63l9.38 9.38-39.41 39.41c-11.56-11.37-24.53-21.33-38.65-29.51V47.74l15.97-.02c8.82-.01 15.97-7.16 15.98-15.98l.04-15.72C320 7.17 312.82-.01 303.97 0L80.03.26c-8.82.01-15.97 7.16-15.98 15.98l-.04 15.73c-.01 8.85 7.17 16.02 16.02 16.01L96 47.96v169.93C38.67 251.1 0 312.97 0 384c0 43.81 14.8 84.07 39.52 116.35C45.34 507.96 54.73 512 64.31 512h255.37c9.58 0 18.97-4.04 24.79-11.65C369.21 468.07 384 427.8 384 384c0-36.12-10.08-69.81-27.44-98.62L400 241.94l9.38 9.38c6.25 6.25 16.38 6.25 22.63 0l11.3-11.32c6.25-6.25 6.25-16.38 0-22.63zm-323.25 42.06L144 245.56V47.99h96v197.57l23.94 13.87c24.81 14.37 44.12 35.73 56.56 60.57h-257c12.45-24.84 31.75-46.2 56.56-60.57zM311.53 464H72.47C56.43 440.25 48 412.77 48 384c0-5.39.47-10.71 1.07-16h285.85c.6 5.29 1.07 10.61 1.07 16 .01 28.77-8.42 56.25-24.46 80z"]
};
var faBook = {
  prefix: 'far',
  iconName: 'book',
  icon: [448, 512, [], "f02d", "M128 152v-32c0-4.4 3.6-8 8-8h208c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H136c-4.4 0-8-3.6-8-8zm8 88h208c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8H136c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8zm299.1 159.7c-4.2 13-4.2 51.6 0 64.6 7.3 1.4 12.9 7.9 12.9 15.7v16c0 8.8-7.2 16-16 16H80c-44.2 0-80-35.8-80-80V80C0 35.8 35.8 0 80 0h352c8.8 0 16 7.2 16 16v368c0 7.8-5.5 14.2-12.9 15.7zm-41.1.3H80c-17.6 0-32 14.4-32 32 0 17.7 14.3 32 32 32h314c-2.7-17.3-2.7-46.7 0-64zm6-352H80c-17.7 0-32 14.3-32 32v278.7c9.8-4.3 20.6-6.7 32-6.7h320V48z"]
};
var faBookAlt = {
  prefix: 'far',
  iconName: 'book-alt',
  icon: [448, 512, [], "f5d9", "M435.1 399.7c-4.2 13-4.2 51.6 0 64.6 7.3 1.4 12.9 7.9 12.9 15.7v16c0 8.8-7.2 16-16 16H80c-44.2 0-80-35.8-80-80V80C0 35.8 35.8 0 80 0h352c8.8 0 16 7.2 16 16v368c0 7.8-5.5 14.2-12.9 15.7zm-41.1.3H80c-17.6 0-32 14.4-32 32 0 17.7 14.3 32 32 32h314c-2.7-17.3-2.7-46.7 0-64zm6-352H80c-17.7 0-32 14.3-32 32v278.7c9.8-4.3 20.6-6.7 32-6.7h320V48z"]
};
var faBookDead = {
  prefix: 'far',
  iconName: 'book-dead',
  icon: [448, 512, [], "f6b7", "M128.3 297.64l4.31 16.24c1.19 4.48 5.52 7.07 9.67 5.79L240 289.56l97.71 30.11c4.15 1.28 8.48-1.31 9.67-5.79l4.31-16.24c1.19-4.48-1.21-9.16-5.37-10.44L296.99 272l49.33-15.2c4.16-1.28 6.56-5.95 5.37-10.44l-4.31-16.24c-1.19-4.48-5.52-7.07-9.67-5.79L240 254.44l-97.71-30.11c-4.15-1.28-8.48 1.31-9.67 5.79l-4.31 16.24c-1.19 4.48 1.21 9.16 5.37 10.44l49.33 15.2-49.33 15.2c-4.16 1.28-6.57 5.95-5.38 10.44zM192 194.91V208c0 8.84 7.16 16 16 16h64c8.84 0 16-7.16 16-16v-13.09c19.32-11.68 32-30.04 32-50.91 0-35.35-35.82-64-80-64s-80 28.65-80 64c0 20.87 12.68 39.23 32 50.91zM272 128c8.84 0 16 7.16 16 16s-7.16 16-16 16-16-7.16-16-16 7.16-16 16-16zm-64 0c8.84 0 16 7.16 16 16s-7.16 16-16 16-16-7.16-16-16 7.16-16 16-16zm240 256V16c0-8.8-7.2-16-16-16H80C35.8 0 0 35.8 0 80v352c0 44.2 35.8 80 80 80h352c8.8 0 16-7.2 16-16v-16c0-7.8-5.6-14.3-12.9-15.7-4.2-13-4.2-51.6 0-64.6 7.4-1.5 12.9-7.9 12.9-15.7zm-54 80H80c-17.7 0-32-14.3-32-32 0-17.6 14.4-32 32-32h314c-2.7 17.3-2.7 46.7 0 64zm6-112H80c-11.4 0-22.2 2.4-32 6.7V80c0-17.7 14.3-32 32-32h320v304z"]
};
var faBookHeart = {
  prefix: 'far',
  iconName: 'book-heart',
  icon: [448, 512, [], "f499", "M448 384V16c0-8.8-7.2-16-16-16H80C35.8 0 0 35.8 0 80v352c0 44.2 35.8 80 80 80h352c8.8 0 16-7.2 16-16v-16c0-7.8-5.6-14.3-12.9-15.7-4.2-13-4.2-51.6 0-64.6 7.4-1.5 12.9-7.9 12.9-15.7zm-54 80H80c-17.7 0-32-14.3-32-32 0-17.6 14.4-32 32-32h314c-2.7 17.3-2.7 46.7 0 64zm6-112H80c-11.4 0-22.2 2.4-32 6.7V80c0-17.7 14.3-32 32-32h320v304zm-184.5-67.5c4.7 4.6 12.3 4.6 17 0l72.6-71.3c21.1-20.7 19.8-55.1-3.7-74.2s-54.3-10.6-70 4.8l-7.4 7.3-7.4-7.3c-15.3-15.1-46.2-24.1-70-4.8-23.6 19.1-24.8 53.5-3.7 74.2l72.6 71.3z"]
};
var faBookMedical = {
  prefix: 'far',
  iconName: 'book-medical',
  icon: [448, 512, [], "f7e6", "M448 384V16a16 16 0 0 0-16-16H80A80 80 0 0 0 0 80v352a80 80 0 0 0 80 80h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-12.9-15.7c-4.2-13-4.2-51.6 0-64.6A16 16 0 0 0 448 384zm-54 80H80a32 32 0 0 1 0-64h314c-2.7 17.3-2.7 46.7 0 64zm6-112H80a79.37 79.37 0 0 0-32 6.7V80a32 32 0 0 1 32-32h320zM136 224h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8z"]
};
var faBookOpen = {
  prefix: 'far',
  iconName: 'book-open',
  icon: [640, 512, [], "f518", "M561.91 0C549.44 0 406.51 6.49 320 56.89 233.49 6.49 90.56 0 78.09 0 35.03 0 0 34.34 0 76.55v313.72c0 40.73 32.47 74.3 73.92 76.41 36.78 1.91 128.81 9.5 187.73 38.69 8.19 4.05 17.25 6.29 26.34 6.58v.05h64.02v-.05c9.09-.29 18.15-2.53 26.34-6.58 58.92-29.19 150.95-36.78 187.73-38.69C607.53 464.57 640 431 640 390.27V76.55C640 34.34 604.97 0 561.91 0zM296 438.15c0 11.09-10.96 18.91-21.33 14.96-64.53-24.54-153.96-32.07-198.31-34.38-15.9-.8-28.36-13.3-28.36-28.46V76.55C48 60.81 61.5 48 78.06 48c19.93.1 126.55 7.81 198.53 40.49 11.63 5.28 19.27 16.66 19.28 29.44L296 224v214.15zm296-47.88c0 15.16-12.46 27.66-28.36 28.47-44.35 2.3-133.78 9.83-198.31 34.38-10.37 3.94-21.33-3.87-21.33-14.96V224l.14-106.08c.02-12.78 7.65-24.15 19.28-29.44C435.4 55.81 542.02 48.1 561.94 48 578.5 48 592 60.81 592 76.55v313.72z"]
};
var faBookReader = {
  prefix: 'far',
  iconName: 'book-reader',
  icon: [512, 512, [], "f5da", "M459.91 192.02c-.7 0-1.39.02-2.06.05-49.8 2.84-140.51 13-201.84 47.57-61.33-34.57-152.05-44.73-201.84-47.57-.67-.04-1.36-.05-2.06-.05C31.71 192.01 0 206.36 0 242.22v178.05c0 26.69 21.25 48.7 48.34 50.12 34.41 1.81 120.56 9.08 177 37.47 5.47 2.77 11.34 4.14 17.19 4.14h26.94c5.84 0 11.72-1.37 17.19-4.14 56.44-28.39 142.59-35.65 177-37.47 27.09-1.42 48.34-23.44 48.34-50.12V242.22c0-35.86-31.71-50.2-52.09-50.2zM232 458.43c-60.63-25.8-138.17-33.71-181.14-35.97-1.71-.09-2.86-1.21-2.86-2.19l-.46-178.45c.76-.76 3.29-1.74 3.88-1.84 35.86 2.04 125.09 10.18 180.58 41.26v177.19zm232-38.16c0 .98-1.15 2.1-2.87 2.19-42.94 2.26-120.43 10.16-181.13 35.98v-177.2c55.32-30.98 144.17-39.16 179.93-41.22 1.4.13 3.78 1.09 4.07 2.2v178.05zM256 191.99c53.02 0 96-42.98 96-95.99S309.02 0 256 0s-96 42.98-96 95.99 42.98 96 96 96zM256 48c26.47 0 48 21.53 48 48s-21.53 48-48 48-48-21.53-48-48 21.53-48 48-48z"]
};
var faBookSpells = {
  prefix: 'far',
  iconName: 'book-spells',
  icon: [448, 512, [], "f6b8", "M448 384V16c0-8.8-7.2-16-16-16H80C35.8 0 0 35.8 0 80v352c0 44.2 35.8 80 80 80h352c8.8 0 16-7.2 16-16v-16c0-7.8-5.6-14.3-12.9-15.7-4.2-13-4.2-51.6 0-64.6 7.4-1.5 12.9-7.9 12.9-15.7zm-54 80H80c-17.7 0-32-14.3-32-32 0-17.6 14.4-32 32-32h314c-2.7 17.3-2.7 46.7 0 64zm6-112H80c-11.4 0-22.2 2.4-32 6.7V80c0-17.7 14.3-32 32-32h320v304zm-154.66-85.33L272 320l26.66-53.33L352 240l-53.34-26.67L272 160l-26.66 53.33L192 240l53.34 26.67zM160 200l18.66-37.33L216 144l-37.34-18.67L160 88l-18.67 37.33L104 144l37.33 18.67L160 200z"]
};
var faBookUser = {
  prefix: 'far',
  iconName: 'book-user',
  icon: [448, 512, [], "f7e7", "M240 208a64 64 0 1 0-64-64 64 64 0 0 0 64 64zm208 176V16a16 16 0 0 0-16-16H80A80 80 0 0 0 0 80v352a80 80 0 0 0 80 80h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-12.9-15.7c-4.2-13-4.2-51.6 0-64.6A16 16 0 0 0 448 384zm-54 80H80a32 32 0 0 1 0-64h314c-2.7 17.3-2.7 46.7 0 64zm6-112H80a79.37 79.37 0 0 0-32 6.7V80a32 32 0 0 1 32-32h320zm-256-32h192a16 16 0 0 0 16-16v-22.4c0-31.81-30.09-57.6-67.2-57.6h-4.95a103.25 103.25 0 0 1-79.7 0h-5c-37.11 0-67.2 25.79-67.2 57.6V304A16 16 0 0 0 144 320z"]
};
var faBookmark = {
  prefix: 'far',
  iconName: 'bookmark',
  icon: [384, 512, [], "f02e", "M336 0H48C21.49 0 0 21.49 0 48v464l192-112 192 112V48c0-26.51-21.49-48-48-48zm0 428.43l-144-84-144 84V54a6 6 0 0 1 6-6h276c3.314 0 6 2.683 6 5.996V428.43z"]
};
var faBooks = {
  prefix: 'far',
  iconName: 'books',
  icon: [576, 512, [], "f5db", "M575.46 454.59L458.55 11.86c-2.28-8.5-11.1-13.59-19.6-11.31L423.5 4.68c-7.54 2.02-12.37 9.11-11.83 16.53-11.47 7.42-64.22 21.55-77.85 20.86-3.24-6.69-10.97-10.42-18.5-8.4L304 36.7V32c0-17.67-14.33-32-40-32H24C14.33 0 0 14.33 0 32v448c0 17.67 14.33 32 24 32h240c25.67 0 40-14.33 40-32V115.94l101.45 384.2c2.28 8.5 11.1 13.59 19.6 11.31l15.46-4.14c7.54-2.02 12.37-9.11 11.83-16.52 11.47-7.42 64.21-21.55 77.85-20.86 3.24 6.69 10.97 10.42 18.5 8.4l15.46-4.14c8.49-2.28 13.58-11.1 11.31-19.6zM128 464H48v-48h80v48zm0-96H48V144h80v224zm0-272H48V48h80v48zm128 368h-80v-48h80v48zm0-96h-80V144h80v224zm0-272h-80V48h80v48zm185.98 355.01L344.74 81.69c16.76-1.8 60.74-13.39 77.28-20.71l97.24 369.32c-16.76 1.81-60.74 13.4-77.28 20.71z"]
};
var faBooksMedical = {
  prefix: 'far',
  iconName: 'books-medical',
  icon: [640, 512, [], "f7e8", "M256 256a128 128 0 1 0-128 128 128 128 0 0 0 128-128zm-149.33 58.67v-37.34H69.33A5.33 5.33 0 0 1 64 272v-32a5.33 5.33 0 0 1 5.33-5.33h37.34v-37.34A5.33 5.33 0 0 1 112 192h32a5.33 5.33 0 0 1 5.33 5.33v37.34h37.34A5.33 5.33 0 0 1 192 240v32a5.33 5.33 0 0 1-5.33 5.33h-37.34v37.34A5.33 5.33 0 0 1 144 320h-32a5.33 5.33 0 0 1-5.33-5.33zm532.79 139.92L522.55 11.86A16 16 0 0 0 503 .55l-15.5 4.13a16 16 0 0 0-11.83 16.53c-11.47 7.42-64.22 21.55-77.85 20.86a16 16 0 0 0-18.5-8.4L368 36.7V32c0-17.67-14.33-32-40-32H88c-9.67 0-24 14.33-24 32v77.56c14.91-6.56 31.14-10.24 48-11.94V48h80v61.56A160.44 160.44 0 0 1 242 144h78v224h-78a160.44 160.44 0 0 1-50 34.44V464h-80v-49.62c-16.86-1.7-33.09-5.4-48-11.94V480c0 17.67 14.33 32 24 32h240c25.67 0 40-14.33 40-32V115.94l101.45 384.2a16 16 0 0 0 19.6 11.31l15.46-4.14a16 16 0 0 0 11.83-16.52c11.47-7.42 64.21-21.55 77.85-20.86a16 16 0 0 0 18.5 8.4l15.46-4.14a16.06 16.06 0 0 0 11.31-19.6zM320 464h-80v-48h80zm0-368h-80V48h80zm186 355L408.74 81.69C425.5 79.89 469.48 68.3 486 61l97.26 369.3c-16.76 1.81-60.74 13.4-77.26 20.7z"]
};
var faBoot = {
  prefix: 'far',
  iconName: 'boot',
  icon: [512, 512, [], "f782", "M415 263.8L352 248V144c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H32C14.3 0 0 14.3 0 32v434.7c0 8.5 3.4 16.6 9.4 22.6L32 512h64l32-32 32 32h64l32-32 32 32h64l32-32 32 32h64l22.6-22.6c6-6 9.4-14.1 9.4-22.6V388c0-58.8-40-110-97-124.2zM48 48h288v48H48V48zm416 368H48V144h256v48h-72c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h72v32h-72c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h82.1l89.3 22.3c35.7 8.9 60.6 40.8 60.6 77.6V416z"]
};
var faBoothCurtain = {
  prefix: 'far',
  iconName: 'booth-curtain',
  icon: [512, 512, [], "f734", "M0 32v464c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V48h56v328c0 39.7 32.3 72 72 72 16.3 0 31.7-5.5 44-15 24.7 19.1 63.3 19.1 88 0 24.7 19.1 63.3 19.1 88 0 12.3 9.5 27.7 15 44 15 8.5 0 16.5-1.7 24-4.4V496c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V24c0-13.2-10.8-24-24-24H32C14.3 0 0 14.3 0 32zm152 16h312v328c0 13.2-10.8 24-24 24-9.5 0-18.2-5.7-22-14.5-7.6-17.5-36.4-17.5-44 0-7.6 17.6-36.4 17.6-44 0-7.6-17.5-36.4-17.5-44 0-7.6 17.6-36.4 17.6-44 0-3.8-8.8-12.4-14.4-22-14.4s-18.2 5.7-22 14.4c-3.8 8.8-12.5 14.5-22 14.5-13.2 0-24-10.8-24-24V48z"]
};
var faBorderAll = {
  prefix: 'far',
  iconName: 'border-all',
  icon: [448, 512, [], "f84c", "M416 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zm-16 48v152H248V80zm-200 0v152H48V80zM48 432V280h152v152zm200 0V280h152v152z"]
};
var faBorderBottom = {
  prefix: 'far',
  iconName: 'border-bottom',
  icon: [448, 512, [], "f84d", "M432 432H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM112 88h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm0 196h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm100 0h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm100 0h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zM212 184h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm100-96h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm-100 0h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm0 296h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm220-156h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 100h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-200h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM16 384h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm0-200h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm0-96h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48v24a16 16 0 0 0 16 16zm0 196h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16z"]
};
var faBorderInner = {
  prefix: 'far',
  iconName: 'border-inner',
  icon: [448, 512, [], "f84e", "M432 232H248V48a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v184H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h184v184a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V280h184a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM40 424H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM16 184h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm24 144H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm72-240h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm-96 0h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48v24a16 16 0 0 0 16 16zm296 0h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm120 240h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm-296 96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM432 32h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm0 96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm-96 296h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm96 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16z"]
};
var faBorderLeft = {
  prefix: 'far',
  iconName: 'border-left',
  icon: [448, 512, [], "f84f", "M32 32H16A16 16 0 0 0 0 48v416a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm204 392h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-200h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM136 32h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm100 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM136 424h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm100 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm196-100h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 100h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm-96 392h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm96-96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm-96-100h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm96 196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM336 32h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]
};
var faBorderNone = {
  prefix: 'far',
  iconName: 'border-none',
  icon: [448, 512, [], "f850", "M336 228h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm96 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm-296 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm200 196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm96 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-200h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM136 424h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm100-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-200h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm100 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM40 228H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 196H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-96H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-200H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-96H16A16 16 0 0 0 0 48v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]
};
var faBorderOuter = {
  prefix: 'far',
  iconName: 'border-outer',
  icon: [448, 512, [], "f851", "M416 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zm-16 400H48V80h352zM212 184h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm100 100h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm-200 0h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm100 0h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm0 100h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16z"]
};
var faBorderRight = {
  prefix: 'far',
  iconName: 'border-right',
  icon: [448, 512, [], "f852", "M432 32h-16a16 16 0 0 0-16 16v416a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM40 32H16A16 16 0 0 0 0 48v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm0 392h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM40 128H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 296H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-196H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 100H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm296 96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm-100 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm100-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm-100 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm0 96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 200h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-100h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16z"]
};
var faBorderStyle = {
  prefix: 'far',
  iconName: 'border-style',
  icon: [448, 512, [], "f853", "M432 32H32A32 32 0 0 0 0 64v400a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V80h384a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM236 424h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm-100 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm200 0h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm96-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 100h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-200h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 296h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16z"]
};
var faBorderStyleAlt = {
  prefix: 'far',
  iconName: 'border-style-alt',
  icon: [448, 512, [], "f854", "M432 32h-16a16 16 0 0 0-16 16v384H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h400a32 32 0 0 0 32-32V48a16 16 0 0 0-16-16zM312 88h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm-100 0h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zM16 384h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm0-100h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm96-196h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm-96 96h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16zm0-96h24a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48v24a16 16 0 0 0 16 16z"]
};
var faBorderTop = {
  prefix: 'far',
  iconName: 'border-top',
  icon: [448, 512, [], "f855", "M432 32H16A16 16 0 0 0 0 48v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM136 424h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm100 196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM40 228H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0 196H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-96H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-200H16a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm196 200h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm100 96h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm96-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm0-100h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM236 228h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm196 100h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zM236 128h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm196 296h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16zm-96-196h-24a16 16 0 0 0-16 16v24a16 16 0 0 0 16 16h24a16 16 0 0 0 16-16v-24a16 16 0 0 0-16-16z"]
};
var faBowArrow = {
  prefix: 'far',
  iconName: 'bow-arrow',
  icon: [512, 512, [], "f6b9", "M145.78 286.65l33.94-33.9-99.54-99.42c33.83-24.46 74.26-37.85 116.85-37.85 34.01 0 66.7 8.5 95.73 24.37l34.96-34.91c-38.88-24.21-83.72-37.4-130.69-37.4-55.44 0-107.96 18.26-151.12 51.56l-7.28-7.27c-6.25-6.24-16.38-6.24-22.63 0l-11.31 11.3c-6.25 6.24-6.25 16.36 0 22.6l141.09 140.92zM493.2.3L364.62 25.98c-12.29 2.45-16.88 17.6-8.02 26.45l34.47 34.42-250.63 250.33-49.7-16.55c-1.93-.64-12.39-3.68-21.03 4.96l-63.68 63.6c-10.8 10.79-6.46 29.17 8.04 33.99l55.65 18.53 18.55 55.58c2.99 8.97 11.19 14.05 19.57 14.05 5.14 0 10.36-1.92 14.47-6.02l63.67-63.59a20.51 20.51 0 0 0 4.97-21.01l-16.57-49.64L425 120.75l34.46 34.42c8.92 8.91 24.04 4.2 26.48-8.01l25.72-128.43C514.02 7 503.46-1.74 493.2.3zM116.27 454.85l-14.93-44.72-44.78-14.91 32.92-32.88 44.78 14.91 14.93 44.72-32.92 32.88zM455.64 94.86L417 56.26l48.3-9.65-9.66 48.25zm-48.57 89l-34.96 34.91c16.19 29.21 24.9 62.14 24.9 96.45 0 42.53-13.42 82.9-37.91 116.69L258.9 331.83l-33.94 33.9 141.75 141.58c6.25 6.24 16.38 6.24 22.62 0l11.31-11.3c6.25-6.24 6.25-16.36 0-22.6l-7.28-7.27c33.35-43.1 51.64-95.55 51.64-150.92.01-47.23-13.36-92.33-37.93-131.36z"]
};
var faBowlingBall = {
  prefix: 'far',
  iconName: 'bowling-ball',
  icon: [496, 512, [], "f436", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-96-296c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm112-32c0-17.7-14.3-32-32-32s-32 14.3-32 32 14.3 32 32 32 32-14.3 32-32zm-16 64c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32z"]
};
var faBowlingPins = {
  prefix: 'far',
  iconName: 'bowling-pins',
  icon: [496, 512, [], "f437", "M491 308.2c-13.4-54-49.4-87.4-53.8-132-3-30.5 21.4-53.1 18.8-95.8C453.1 34 419.5.1 376 0c-43.4.1-77 34-79.9 80.5-2.8 42.7 21.7 65.3 18.7 95.8-4.4 44.5-40.5 78.1-53.7 131.9-13 52.5.3 140.1 29.1 191.5l6.9 12.3h158.1l6.9-12.3c28.6-51.4 41.9-139.1 28.9-191.5zM408.1 83.5c1.5 24.2-14.9 43.4-18.4 76.6h-27.4c-3.5-33.4-19.9-52.2-18.4-76.6 3-47.5 61.2-47.5 64.2 0zm18.1 380.4H325.9c-18.8-42.2-27.4-107-18.2-144.2 10.7-43.1 43.5-75 52.9-127.7h31c9.4 52.7 42.2 84.6 52.9 127.7 9.1 37.2.4 102-18.3 144.2zm-245-287.6c-3-30.5 21.4-53.1 18.7-95.8C197 34 163.4.2 119.9.1 76.5.2 42.9 34 40 80.5c-2.7 42.8 21.8 65.2 18.7 95.8C54.3 221 18.4 254.2 5 308.2c-13 52.5.3 140.2 29 191.5l6.9 12.3H199l6.9-12.3c28.7-51.3 42-139 29-191.5-13.3-54-49.3-87.2-53.7-131.9zM152 83.5c1.5 24.3-14.9 43.2-18.4 76.5h-27.4c-3.5-33.5-19.9-52-18.4-76.5 3.1-47.4 61.3-47.4 64.2 0zM170.1 464H69.8C51 421.7 42.4 356.9 51.6 319.7c10.6-43 43.4-74.8 52.9-127.7h30.9c9.5 53 42.3 84.7 52.9 127.8 9.2 37.2.6 101.9-18.2 144.2z"]
};
var faBox = {
  prefix: 'far',
  iconName: 'box',
  icon: [512, 512, [], "f466", "M509.5 184.6L458.9 32.8C452.4 13.2 434.1 0 413.4 0H98.6c-20.7 0-39 13.2-45.5 32.8L2.5 184.6c-1.6 4.9-2.5 10-2.5 15.2V464c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V199.8c0-5.2-.8-10.3-2.5-15.2zm-48.1 7.4H280V48h133.4l48 144zM98.6 48H232v144H50.6l48-144zM48 464V240h416v224H48z"]
};
var faBoxAlt = {
  prefix: 'far',
  iconName: 'box-alt',
  icon: [448, 512, [], "f49a", "M447.9 176c0-10.6-2.6-21-7.6-30.3l-49.1-91.9c-4.3-13-16.5-21.8-30.3-21.8H87.1c-13.8 0-26 8.8-30.4 21.9L7.6 145.8c-5 9.3-7.6 19.7-7.6 30.3C.1 236.6 0 448 0 448c0 17.7 14.3 32 32 32h384c17.7 0 32-14.3 32-32 0 0-.1-211.4-.1-272zm-97.1-96l42.8 80H278.4l-24-80h96.4zM97.2 80h96.4l-24 80H54.4l42.8-80zM48 432c0-42.3.1-157.9.1-224H160v64c0 8.8 7.2 16 16 16h96c8.8 0 16-7.2 16-16v-64h111.9c0 66.1 0 181.8.1 224H48z"]
};
var faBoxBallot = {
  prefix: 'far',
  iconName: 'box-ballot',
  icon: [576, 512, [], "f735", "M573.8 282.5L520 148.3c-4.8-12.3-16.6-20.3-29.8-20.3H448V32c0-17.7-14.3-32-32-32H160c-17.7 0-32 14.3-32 32v96H85.8c-13.2 0-25 8.1-29.8 20.3L2.2 282.4C.8 286.1 0 290 0 294l.2 185.9c-.1 17.7 14.3 32.2 32 32.2h511.6c17.7 0 32.1-14.4 32-32.2L576 294c0-4-.8-7.9-2.2-11.5zM176 48h224v144H176V48zM96.7 176H128v64h320v-64h31.3L520 280H55.9l40.8-104zM48.3 464l.7-136h478l.8 136H48.3z"]
};
var faBoxCheck = {
  prefix: 'far',
  iconName: 'box-check',
  icon: [640, 512, [], "f467", "M492.5 133.4L458.9 32.8C452.4 13.2 434.1 0 413.4 0H98.6c-20.7 0-39 13.2-45.5 32.8L2.5 184.6c-1.6 4.9-2.5 10-2.5 15.2V464c0 26.5 21.5 48 48 48h400c106 0 192-86 192-192 0-90.7-63-166.5-147.5-186.6zM280 48h133.4l26.8 80.4c-49.8 2-94.7 22.7-127.7 55.6H280V48zM98.6 48H232v136H53.3L98.6 48zM48 464V232h229.5c-13.6 26.4-21.5 56.3-21.5 88 0 57.4 25.3 108.8 65.3 144H48zm400 0c-79.4 0-144-64.6-144-144s64.6-144 144-144 144 64.6 144 144-64.6 144-144 144zm64.6-205.7c-3.1-3.1-8.1-3.1-11.2 0l-69.9 69.3-30.3-30.6c-3.1-3.1-8.1-3.1-11.2 0l-18.7 18.6c-3.1 3.1-3.1 8.1 0 11.2l54.4 54.9c3.1 3.1 8.1 3.1 11.2 0l94.2-93.5c3.1-3.1 3.1-8.1 0-11.2l-18.5-18.7z"]
};
var faBoxFragile = {
  prefix: 'far',
  iconName: 'box-fragile',
  icon: [512, 512, [], "f49b", "M448 0H64C28.7 0 0 28.7 0 64v384c0 35.3 28.7 64 64 64h384c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 448c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v384zM336 96h-43.9l22.9 36.4-64 32 37 59.6-91-68.4 64-32L236.4 96H176c-8.8 0-16 7.2-16 16v97.6c0 44.7 30.7 81.6 72 92.3V368h-24c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h96c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16h-24v-66.1c41.3-10.7 72-47.6 72-92.3V112c0-8.8-7.2-16-16-16z"]
};
var faBoxFull = {
  prefix: 'far',
  iconName: 'box-full',
  icon: [640, 512, [], "f49c", "M638.3 239.8L586.8 137c-4-8.1-12.1-9.5-16.7-8.9l-50.7 6.5L541.5 74c3.7-10 3.2-20.9-1.3-30.6-4.5-9.7-12.5-17-22.6-20.7L462.1 2.4c-20.7-7.6-43.7 3.2-51.3 23.9l-30.9 84.9C365 47.5 308.2 0 240 0 164.7 0 103.6 58 97.2 131.6l-27.4-3.5c-4.6-.6-12.6.9-16.7 8.9L1.7 239.8c-4.6 9.2.3 20.2 10.1 23L64 277.7V425c0 14.7 10 27.5 24.2 31l216.2 54.1c13.6 3.4 25 1.5 31 0L551.8 456c14.2-3.6 24.2-16.4 24.2-31V277.7l52.1-14.9c9.9-2.8 14.7-13.8 10.2-23zM453.2 50.3L493.7 65l-27.8 76.4-48.2 6.1 35.5-97.2zM61.7 227.2L86 178.6l154.8 19.7-41.2 68.3-137.9-39.4zM296 458.5l-184-46V291.4l97.8 27.9c8 2.3 15.2-1.8 18.5-7.3L296 199.8v258.7zm38.6-300.4L320 160l-175.4-22.3C148 87.7 189.2 48 240 48c52.9 0 96 43.1 96 96 0 4.8-.7 9.5-1.4 14.1zM528 412.5l-184 46V199.8l67.7 112.3c3.3 5.5 10.6 9.6 18.5 7.3l97.8-27.9v121zm-87.7-145.9l-41.2-68.3L554 178.6l24.3 48.6-138 39.4z"]
};
var faBoxHeart = {
  prefix: 'far',
  iconName: 'box-heart',
  icon: [448, 512, [], "f49d", "M301.3 243c-23.5-19.1-54.3-10.6-70 4.8l-7.4 7.3-7.4-7.3c-15.3-15.1-46.2-24.1-70-4.8-23.6 19.1-24.8 53.5-3.7 74.2l72.6 71.3c4.7 4.6 12.3 4.6 17 0l72.6-71.3c21.1-20.7 19.9-55.1-3.7-74.2zm146.6-67c0-10.6-2.6-21-7.6-30.3l-49.1-91.9c-4.3-13-16.5-21.8-30.3-21.8H87.1c-13.8 0-26 8.8-30.4 21.9L7.6 145.8c-5 9.3-7.6 19.7-7.6 30.3C.1 236.6 0 448 0 448c0 17.7 14.3 32 32 32h384c17.7 0 32-14.3 32-32 0 0-.1-211.4-.1-272zM248 80h102.8l34.2 64H248V80zM97.2 80H200v64H63l34.2-64zM48 432c0-36.5.1-163.5.1-240h351.8c0 76.5.1 203.5.1 240H48z"]
};
var faBoxOpen = {
  prefix: 'far',
  iconName: 'box-open',
  icon: [640, 512, [], "f49e", "M638.3 143.8L586.8 41c-4-8-12.1-9.5-16.7-8.9L320 64 69.8 32.1c-4.6-.6-12.6.9-16.6 8.9L1.7 143.8c-4.6 9.2.3 20.2 10.1 23L64 181.7V393c0 14.7 10 27.5 24.2 31l216.2 54.1c6 1.5 17.4 3.4 31 0L551.8 424c14.2-3.6 24.2-16.4 24.2-31V181.7l52.1-14.9c9.9-2.8 14.7-13.8 10.2-23zM86 82.6l154.8 19.7-41.2 68.3-138-39.4L86 82.6zm26 112.8l97.8 27.9c8 2.3 15.2-1.8 18.5-7.3L296 103.8v322.7l-184-46V195.4zm416 185.1l-184 46V103.8l67.7 112.3c3.3 5.5 10.6 9.6 18.5 7.3l97.8-27.9v185zm-87.7-209.9l-41.2-68.3L554 82.6l24.3 48.6-138 39.4z"]
};
var faBoxUp = {
  prefix: 'far',
  iconName: 'box-up',
  icon: [512, 512, [], "f49f", "M400 368H112c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h288c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zM448 0H64C28.7 0 0 28.7 0 64v384c0 35.3 28.7 64 64 64h384c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 448c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v384zM358.2 99c-3.1-3.8-9.4-3.8-12.5 0l-64 80c-4.2 5.3-.4 13 6.2 13h32v112c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V192h32c6.7 0 10.4-7.7 6.2-13l-63.9-80zM128 192v112c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V192h32c6.7 0 10.4-7.7 6.2-13l-64-80c-3.1-3.8-9.4-3.8-12.5 0l-64 80c-4.2 5.3-.4 13 6.2 13H128z"]
};
var faBoxUsd = {
  prefix: 'far',
  iconName: 'box-usd',
  icon: [448, 512, [], "f4a0", "M447.9 176c0-10.6-2.6-21-7.6-30.3l-49.1-91.9c-4.3-13-16.5-21.8-30.3-21.8H87.1c-13.8 0-26 8.8-30.4 21.9L7.6 145.8c-5 9.3-7.6 19.7-7.6 30.3C.1 236.6 0 448 0 448c0 17.7 14.3 32 32 32h384c17.7 0 32-14.3 32-32 0 0-.1-211.4-.1-272zM248 80h102.8l34.2 64H248V80zM97.2 80H200v64H63l34.2-64zM48 432c0-36.5.1-163.5.1-240h351.8c0 76.5.1 203.5.1 240H48zm201.3-129.7l-42.2-11.4c-4.2-1.1-7.1-4.5-7.1-8.3 0-4.8 4.5-8.7 10.1-8.7h26.3c4.1 0 8.2 1 11.8 3 3.1 1.7 6.8 1.4 9.2-1.2l12.1-12.7c3.1-3.3 2.6-8.6-1.1-11.2-8.3-5.7-18.1-8.9-28.3-9.5V232c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v10.2c-22.2 1.1-40 18.6-40 40.3 0 18.2 12.6 34.3 30.7 39.2l42.2 11.4c4.2 1.1 7.1 4.5 7.1 8.3 0 4.8-4.5 8.7-10.1 8.7h-26.3c-4.1 0-8.2-1-11.8-3-3.1-1.7-6.8-1.4-9.2 1.2L178.6 361c-3.1 3.3-2.6 8.6 1.1 11.2 8.3 5.7 18.1 8.9 28.3 9.5V392c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-10.2c22.2-1.1 40-18.6 40-40.3 0-18.2-12.6-34.3-30.7-39.2z"]
};
var faBoxes = {
  prefix: 'far',
  iconName: 'boxes',
  icon: [640, 512, [], "f468", "M592 224H480V48c0-26.5-21.5-48-48-48H208c-26.5 0-48 21.5-48 48v176H48c-26.5 0-48 21.5-48 48v192c0 26.5 21.5 48 48 48h544c26.5 0 48-21.5 48-48V272c0-26.5-21.5-48-48-48zM208 48h64v90.7l48-21.3 48 21.3V48h64v176H208V48zm88 416H48V272h80v90.7l48-21.3 48 21.3V272h72v192zm296 0H344V272h72v90.7l48-21.3 48 21.3V272h80v192z"]
};
var faBoxesAlt = {
  prefix: 'far',
  iconName: 'boxes-alt',
  icon: [640, 512, [], "f4a1", "M592 224H480V48c0-26.5-21.5-48-48-48H208c-26.5 0-48 21.5-48 48v176H48c-26.5 0-48 21.5-48 48v192c0 26.5 21.5 48 48 48h544c26.5 0 48-21.5 48-48V272c0-26.5-21.5-48-48-48zM208 48h80v72c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V48h80v176H208V48zm88 416H48V272h96v72c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-72h88v192zm296 0H344V272h88v72c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-72h96v192z"]
};
var faBoxingGlove = {
  prefix: 'far',
  iconName: 'boxing-glove',
  icon: [448, 512, [], "f438", "M252.4 360.8l7.2 14.3c2 4 .4 8.8-3.6 10.7L227.8 400l28.2 14.1c4 2 5.6 6.8 3.6 10.7l-7.2 14.3c-2 4-6.8 5.6-10.7 3.6L192 417.9l-49.7 24.8c-4 2-8.8.4-10.7-3.6l-7.2-14.3c-2-4-.4-8.8 3.6-10.7l28.2-14.1-28.2-14.1c-4-2-5.6-6.8-3.6-10.7l7.2-14.3c2-4 6.8-5.6 10.7-3.6l49.7 24.8 49.7-24.8c3.9-2 8.7-.4 10.7 3.5zM448 229.5c0 55.7-23.3 110.2-63.9 149.6L368 394.7v77.9c0 21.8-17.9 39.5-40 39.5H72c-22.1 0-40-17.7-40-39.5v-82.8l-17-102C5 229.5 0 170 0 111 0 49.8 50.8 0 113.2 0H288c61.8 0 112 49.8 112 111v33.2c28.8 18.1 48 49.5 48 85.3zm-48 0c0-29.5-25.1-53.5-56-53.5h-31.3c-21.5 0-40.2 17.6-40.7 39.1-.5 20.2 14.2 37.2 33.4 40.4 3.8.6 6.6 4 6.6 7.9v32.3c0 4.7-4.1 8.4-8.8 8-44.4-4.4-79.2-42-79.2-87.6 0-8.4 1.6-16.3 3.7-24h-70.5c-30.6 0-59.5-10.9-82.3-30.8-3.5-3.1-3.7-8.4-.4-11.7l11.3-11.3c3-3 7.7-3.1 10.9-.4 16.9 14.4 38.1 22.3 60.5 22.3h87.4c16.2-19.4 40.2-32 67.3-32h32c10.2 0 8 6 8-17 0-35.3-28.1-63-64-63H113.2C77.2 48 48 76.2 48 111c0 95.9 11.4 151 31.4 273H104c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H80v48h240v-48h-24c-4.4 0-8-3.6-8-8v-16c0-4.4 3.6-8 8-8h24c0-6.2 2.5-12.1 6.9-16.4l23.8-23.1c31.8-30.7 49.3-71.6 49.3-115z"]
};
var faBrackets = {
  prefix: 'far',
  iconName: 'brackets',
  icon: [448, 512, [], "f7e9", "M128 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h96a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16H48V80h80a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm288 0h-96a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h80v352h-80a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h96a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32z"]
};
var faBracketsCurly = {
  prefix: 'far',
  iconName: 'brackets-curly',
  icon: [576, 512, [], "f7ea", "M208 32h-88a56 56 0 0 0-56 56v77.49a40 40 0 0 1-11.72 28.29L7 239a24 24 0 0 0 0 34l45.24 45.24A40 40 0 0 1 64 346.52V424a56 56 0 0 0 56 56h88a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-88a8 8 0 0 1-8-8v-77.48a88.06 88.06 0 0 0-25.78-62.24L57.93 256l28.29-28.28A88.06 88.06 0 0 0 112 165.48V88a8 8 0 0 1 8-8h88a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm361 207l-45.25-45.24A40.07 40.07 0 0 1 512 165.48V88a56 56 0 0 0-56-56h-88a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h88a8 8 0 0 1 8 8v77.48a88 88 0 0 0 25.78 62.24L518.06 256l-28.28 28.28A88 88 0 0 0 464 346.52V424a8 8 0 0 1-8 8h-88a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h88a56 56 0 0 0 56-56v-77.49a40 40 0 0 1 11.72-28.29L569 273a24 24 0 0 0 0-34z"]
};
var faBraille = {
  prefix: 'far',
  iconName: 'braille',
  icon: [640, 512, [], "f2a1", "M112 256c0 26.51-21.49 48-48 48s-48-21.49-48-48 21.49-48 48-48 48 21.49 48 48zM64 392c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm0-344c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm160 184c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm0 160c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm0-344c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm224 184c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm0 160c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm0-344c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm160 184c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm0 160c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24zm0-320c-13.255 0-24 10.745-24 24s10.745 24 24 24 24-10.745 24-24-10.745-24-24-24z"]
};
var faBrain = {
  prefix: 'far',
  iconName: 'brain',
  icon: [544, 512, [], "f5dc", "M511.9 228.2c1.9-7.5 2.9-15.2 2.9-23 0-33-16.7-63-43.7-80.6-.4-39.7-29.4-72.8-67.5-79.8C389.9 17.8 361.8 0 330.3 0c-22.8 0-43.4 9.2-58.3 24.1A82.316 82.316 0 0 0 213.7 0c-31.4 0-59.6 17.8-73.3 44.9-38.1 7-67.1 40.1-67.5 79.8-27.1 17.6-43.7 47.6-43.7 80.6 0 7.7 1 15.4 2.9 23C11.9 246.3 0 272.2 0 299.5c0 33 16.7 63 43.7 80.6.5 47.5 38.5 86.2 85.8 88.3 15.9 26.7 44.9 43.6 76.8 43.6 26 0 49.2-11.2 65.6-28.8 16.4 17.6 39.6 28.8 65.6 28.8 31.9 0 60.9-16.9 76.8-43.6 47.4-2 85.4-40.8 85.9-88.3 27-17.6 43.7-47.7 43.7-80.6.1-27.3-11.8-53.2-32-71.3zm-264 194.6c0 22.8-18.6 41.2-41.5 41.2-32.9 0-39.5-29.5-45.6-47.6l-20.3 3.4c-24 4-48.5-15.3-48.5-40.5 0-2.8 4.7-27.4 4.7-27.4l-18.2-7.5c-36.9-15.2-41.3-66.1-5.5-86.6l19.5-11.2-9.9-20.1C65 190.7 94 166 107.7 160.4l18.9-7.7c-5-21.9-5.5-22.8-5.5-27.2 0-18.8 15.3-34 31.9-34.1l22.9 1.2 4.8-18.9c3.9-15.1 17.4-25.6 32.9-25.6 18.9 0 34.2 15.2 34.2 34l.1 340.7zm217.7-78.5l-18.3 7.5s4.6 24.6 4.6 27.4c0 25.2-24.5 44.4-48.5 40.5l-20.3-3.4c-6.1 18.2-12.7 47.6-45.6 47.6-22.9 0-41.5-18.5-41.5-41.2V82c0-18.8 15.3-34 34.2-34 15.5 0 29.1 10.5 32.9 25.6l4.8 18.9 22.9-1.2c16.5.1 31.9 15.4 31.9 34.1 0 4.4-.4 5.3-5.5 27.2l18.9 7.7c13.7 5.6 42.7 30.2 25.1 65.9l-9.9 20.1 19.5 11.2c36.1 20.7 31.7 71.6-5.2 86.8z"]
};
var faBreadLoaf = {
  prefix: 'far',
  iconName: 'bread-loaf',
  icon: [640, 512, [], "f7eb", "M400 32H240C107.45 32 0 103.63 0 192c0 35.35 26.86 64 60 64h4v192a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V256h4c33.14 0 60-28.65 60-64 0-88.37-107.45-160-240-160zm20 176h-52v224H112V208H60c-5.79 0-12-6.43-12-16 0-59.66 89.72-112 192-112s192 52.34 192 112c0 9.57-6.21 16-12 16z"]
};
var faBreadSlice = {
  prefix: 'far',
  iconName: 'bread-slice',
  icon: [576, 512, [], "f7ec", "M288 0C110.12 0 0 93.77 0 180.66c0 37.74 26 66.42 64 73.54V480a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V254.41c39.71-6.85 64-35.73 64-73.75C576 93.77 465.88 0 288 0zm215.84 207.11L464 208v256H112V208l-39.16-1C65.37 205.62 48 200.25 48 180.66 48 126.44 133.46 48 288 48s240 78.44 240 132.66c0 14.99-7.9 23.64-24.16 26.45z"]
};
var faBriefcase = {
  prefix: 'far',
  iconName: 'briefcase',
  icon: [512, 512, [], "f0b1", "M464 128h-80V80c0-26.51-21.49-48-48-48H176c-26.51 0-48 21.49-48 48v48H48c-26.51 0-48 21.49-48 48v256c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V176c0-26.51-21.49-48-48-48zM176 80h160v48H176V80zM54 176h404c3.31 0 6 2.69 6 6v74H48v-74c0-3.31 2.69-6 6-6zm404 256H54c-3.31 0-6-2.69-6-6V304h144v24c0 13.25 10.75 24 24 24h80c13.25 0 24-10.75 24-24v-24h144v122c0 3.31-2.69 6-6 6z"]
};
var faBriefcaseMedical = {
  prefix: 'far',
  iconName: 'briefcase-medical',
  icon: [512, 512, [], "f469", "M344 288h-56v-56c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v56h-56c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h56v56c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-56h56c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm120-160H352V80c0-26.5-21.5-48-48-48h-96c-26.5 0-48 21.5-48 48v48H48c-26.5 0-48 21.5-48 48v288c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V176c0-26.5-21.5-48-48-48zM208 80h96v48h-96V80zm256 378c0 3.3-2.7 6-6 6H54c-3.3 0-6-2.7-6-6V182c0-3.3 2.7-6 6-6h404c3.3 0 6 2.7 6 6v276z"]
};
var faBringForward = {
  prefix: 'far',
  iconName: 'bring-forward',
  icon: [512, 512, [], "f856", "M352 304V48a48 48 0 0 0-48-48H48A48 48 0 0 0 0 48v256a48 48 0 0 0 48 48h256a48 48 0 0 0 48-48zM48 48h256v256H48zm416 112h-80v48h80v256H208v-80h-48v80a48 48 0 0 0 48 48h256a48 48 0 0 0 48-48V208a48 48 0 0 0-48-48zM240 416a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16V256a16 16 0 0 0-16-16h-32v144H240z"]
};
var faBringFront = {
  prefix: 'far',
  iconName: 'bring-front',
  icon: [640, 512, [], "f857", "M480 368V144a48 48 0 0 0-48-48H208a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h224a48 48 0 0 0 48-48zM208 144h224v224H208zM48 48h160v16h48V48a48 48 0 0 0-48-48H48A48 48 0 0 0 0 48v160a48 48 0 0 0 48 48h80v-48H48zm544 208h-80v48h80v160H432v-16h-48v16a48 48 0 0 0 48 48h160a48 48 0 0 0 48-48V304a48 48 0 0 0-48-48zM96 160h32v-16a79.24 79.24 0 0 1 16.41-48H96zm448 192h-32v16a79.24 79.24 0 0 1-16.41 48H544z"]
};
var faBroadcastTower = {
  prefix: 'far',
  iconName: 'broadcast-tower',
  icon: [640, 512, [], "f519", "M168.67 192c11 0 18.61-10.83 14.85-21.18-4.93-13.58-7.55-27.98-7.55-42.82s2.62-29.24 7.55-42.82C187.29 74.83 179.68 64 168.67 64h-17.73c-7.01 0-13.46 4.49-15.41 11.23C130.64 92.21 128 109.88 128 128c0 18.12 2.64 35.79 7.54 52.76 1.94 6.74 8.39 11.24 15.4 11.24h17.73zm-120.8-64c0-37.81 9.46-73.41 26.05-104.66C79.56 12.72 71.97 0 59.97 0H40.61c-6.27 0-12.13 3.59-14.73 9.31C8.22 48.13-1.31 91.41.15 137.12c1.24 38.89 10.78 75.94 26.53 109.73 2.62 5.63 8.41 9.14 14.61 9.14h18.87c12.02 0 19.6-12.74 13.94-23.37C57.43 201.39 47.87 165.84 47.87 128zM614.07 9.29C611.46 3.58 605.61 0 599.34 0h-19.43c-11.98 0-19.66 12.66-14.02 23.25 23.26 43.67 32.56 95.83 21.53 150.66-4.16 20.72-11.49 40.35-21.26 58.57-5.72 10.68 1.8 23.52 13.91 23.52h19.24c6.27 0 12.13-3.58 14.73-9.29C630.57 210.48 640 170.36 640 128s-9.42-82.48-25.93-118.71zM489.06 64h-17.73c-11.01 0-18.61 10.83-14.86 21.18 4.93 13.58 7.55 27.98 7.55 42.82s-2.62 29.24-7.55 42.82c-3.76 10.35 3.85 21.18 14.86 21.18h17.73c7.01 0 13.46-4.49 15.41-11.24 4.9-16.97 7.53-34.64 7.53-52.76 0-18.12-2.64-35.79-7.54-52.76-1.94-6.75-8.39-11.24-15.4-11.24zM372.7 187.76C389.31 173.1 400 151.89 400 128c0-44.18-35.82-80-80.01-80-5.52 0-10.92.56-16.12 1.62a79.525 79.525 0 0 0-28.61 12.04c-21.28 14.38-35.27 38.72-35.27 66.34 0 23.86 10.83 44.86 27.4 59.52L143.98 483.68c-3.4 8.16.46 17.52 8.62 20.92l14.78 6.16c8.16 3.4 17.53-.46 20.93-8.62L245.26 368h149.47l56.96 134.15c3.4 8.16 12.77 12.02 20.93 8.62l14.78-6.16c8.16-3.4 12.01-12.77 8.62-20.92L372.7 187.76zM320 96c17.65 0 32 14.36 32 32s-14.36 32-32 32-32-14.36-32-32 14.35-32 32-32zm-54.35 224l47.84-112.66c2.19.18 4.28.66 6.51.66 2.23 0 4.33-.48 6.52-.66L374.35 320h-108.7z"]
};
var faBroom = {
  prefix: 'far',
  iconName: 'broom',
  icon: [640, 512, [], "f51a", "M636.52 31.02l-19.92-25c-5.5-6.9-15.57-8.05-22.49-2.56L363.38 181.38l-34.72-43.56c-4.82-6.05-14.03-6.02-18.81.06l-57.61 73.18c-31.09.74-103.98 6.65-151.87 44.66C38.28 304.99 0 511.31 0 511.31c15.1.66 212.37 7.35 272.15-40.1 47.71-37.87 70-107.39 77.79-137.63l84.34-39.52c7.02-3.29 9.13-12.28 4.29-18.35l-35.34-44.34 230.73-177.9c6.92-5.5 8.06-15.54 2.56-22.45zM242.27 433.73c-16.64 13.21-74.29 28.51-182.8 30.21 4.76-19.1 10.1-38.18 15.8-56.35l45.29-35.95c4.96-3.94 1.23-11.88-4.97-10.57l-26.06 5.5c13.43-35.28 27.73-63.05 40.72-73.36 27.04-21.46 71.32-31.04 109.74-33.53l59.81 75.03c-9.44 30.94-28.14 75.69-57.53 99.02zm88.06-143.88l-39.78-49.91 24.22-30.77c2.39-3.04 7-3.05 9.41-.03l43.77 54.91c2.42 3.03 1.37 7.53-2.15 9.17l-35.47 16.63z"]
};
var faBrowser = {
  prefix: 'far',
  iconName: 'browser',
  icon: [512, 512, [], "f37e", "M464 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM48 92c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12H60c-6.6 0-12-5.4-12-12V92zm416 334c0 3.3-2.7 6-6 6H54c-3.3 0-6-2.7-6-6V168h416v258zm0-310c0 6.6-5.4 12-12 12H172c-6.6 0-12-5.4-12-12V92c0-6.6 5.4-12 12-12h280c6.6 0 12 5.4 12 12v24z"]
};
var faBrush = {
  prefix: 'far',
  iconName: 'brush',
  icon: [384, 512, [], "f55d", "M352 0H32C14.33 0 0 14.33 0 32v288c0 35.35 28.65 64 64 64h48v48c0 44.18 35.82 80 80 80s80-35.82 80-80v-48h48c35.35 0 64-28.65 64-64V32c0-17.67-14.33-32-32-32zm-16 48v176H48V48h288zm-16 288h-96v96c0 17.64-14.36 32-32 32s-32-14.36-32-32v-96H64c-8.82 0-16-7.18-16-16v-48h288v48c0 8.82-7.18 16-16 16z"]
};
var faBug = {
  prefix: 'far',
  iconName: 'bug',
  icon: [576, 512, [], "f188", "M536 264h-64v-94.059l40.971-40.971c9.372-9.373 9.372-24.569 0-33.941-9.373-9.372-24.568-9.372-33.941 0L438.059 136H425C425 60.87 364.091 0 289 0c-75.13 0-136 60.909-136 136h-15.059l-40.97-40.971c-9.373-9.372-24.568-9.372-33.941 0-9.373 9.373-9.373 24.569 0 33.941L104 169.941V264H40c-13.255 0-24 10.745-24 24s10.745 24 24 24h64v24c0 29.275 7.91 56.733 21.694 80.365L71.029 471.03c-9.373 9.373-9.373 24.568 0 33.941 9.371 9.372 24.568 9.373 33.941 0l51.029-51.029C184.482 480.046 222.411 496 264 496h48c41.589 0 79.518-15.954 108.001-42.058l51.029 51.029c9.372 9.372 24.568 9.373 33.941 0 9.372-9.373 9.372-24.568 0-33.941l-54.665-54.665C464.09 392.734 472 365.275 472 336v-24h64c13.255 0 24-10.745 24-24s-10.745-24-24-24zM289 48c48.601 0 88 39.399 88 88H201c0-48.601 39.399-88 88-88zm23 400V260c0-6.627-5.373-12-12-12h-24c-6.627 0-12 5.373-12 12v188c-61.757 0-112-50.243-112-112V184h272v152c0 61.757-50.243 112-112 112z"]
};
var faBuilding = {
  prefix: 'far',
  iconName: 'building',
  icon: [448, 512, [], "f1ad", "M128 148v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12zm140 12h40c6.6 0 12-5.4 12-12v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12zm-128 96h40c6.6 0 12-5.4 12-12v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12zm128 0h40c6.6 0 12-5.4 12-12v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12zm-76 84v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm76 12h40c6.6 0 12-5.4 12-12v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12zm180 124v36H0v-36c0-6.6 5.4-12 12-12h19.5V24c0-13.3 10.7-24 24-24h337c13.3 0 24 10.7 24 24v440H436c6.6 0 12 5.4 12 12zM79.5 463H192v-67c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v67h112.5V49L80 48l-.5 415z"]
};
var faBullhorn = {
  prefix: 'far',
  iconName: 'bullhorn',
  icon: [576, 512, [], "f0a1", "M544 184.88V32.01C544 23.26 537.02 0 512.01 0H512c-7.12 0-14.19 2.38-19.98 7.02l-85.03 68.03C364.28 109.19 310.66 128 256 128H64c-35.35 0-64 28.65-64 64v96c0 35.35 28.65 64 64 64l-.48 32c0 39.77 9.26 77.35 25.56 110.94 5.19 10.69 16.52 17.06 28.4 17.06h106.28c26.05 0 41.69-29.84 25.9-50.56-16.4-21.52-26.15-48.36-26.15-77.44 0-11.11 1.62-21.79 4.41-32H256c54.66 0 108.28 18.81 150.98 52.95l85.03 68.03a32.023 32.023 0 0 0 19.98 7.02c24.92 0 32-22.78 32-32V295.13c19.05-11.09 32-31.49 32-55.12.01-23.64-12.94-44.04-31.99-55.13zM127.73 464c-10.76-25.45-16.21-52.31-16.21-80 0-14.22 1.72-25.34 2.6-32h64.91c-2.09 10.7-3.52 21.41-3.52 32 0 28.22 6.58 55.4 19.21 80h-66.99zM240 304H64c-8.82 0-16-7.18-16-16v-96c0-8.82 7.18-16 16-16h176v128zm256 110.7l-59.04-47.24c-42.8-34.22-94.79-55.37-148.96-61.45V173.99c54.17-6.08 106.16-27.23 148.97-61.46L496 65.3v349.4z"]
};
var faBullseye = {
  prefix: 'far',
  iconName: 'bullseye',
  icon: [496, 512, [], "f140", "M248 104c-84.02 0-152 68-152 152 0 84.02 68 152 152 152 84.02 0 152-68 152-152 0-84.02-68-152-152-152zm0 256c-57.35 0-104-46.65-104-104s46.65-104 104-104 104 46.65 104 104-46.65 104-104 104zm0-352C111.03 8 0 119.03 0 256s111.03 248 248 248 248-111.03 248-248S384.97 8 248 8zm0 448c-110.28 0-200-89.72-200-200S137.72 56 248 56s200 89.72 200 200-89.72 200-200 200zm0-256c-30.88 0-56 25.12-56 56s25.12 56 56 56 56-25.12 56-56-25.12-56-56-56z"]
};
var faBullseyeArrow = {
  prefix: 'far',
  iconName: 'bullseye-arrow',
  icon: [496, 512, [], "f648", "M305.05 98.74l16.57 49.7-90.59 90.59c-9.38 9.38-9.38 24.56 0 33.94 9.37 9.37 24.56 9.38 33.94 0l90.59-90.59 49.7 16.57c7.39 2.46 15.53.54 21.04-4.96l63.67-63.67c10.8-10.8 6.46-29.2-8.04-34.04l-55.66-18.55-18.55-55.65c-4.83-14.5-23.23-18.84-34.04-8.04L310.02 77.7a20.582 20.582 0 0 0-4.97 21.04zM248 152c7.66 0 15.08.96 22.27 2.54l14.74-14.74-10.32-30.95c-.24-.73-.2-1.47-.41-2.21-8.57-1.5-17.28-2.65-26.29-2.65-84.02 0-152 68-152 152 0 84.02 68 152 152 152 84.02 0 152-68 152-152 0-9.03-1.15-17.75-2.65-26.34-.72-.21-1.49-.12-2.2-.36l-30.94-10.31-14.74 14.74c1.58 7.19 2.53 14.61 2.53 22.27 0 57.35-46.65 104-104 104s-104-46.65-104-104S190.65 152 248 152zm236.43 29.1l-35.5 35.5c-1.34 1.34-2.87 2.38-4.32 3.55 2.12 11.65 3.39 23.59 3.39 35.84 0 110.28-89.72 200-200 200s-200-89.72-200-200 89.72-200 200-200c12.34 0 24.37 1.28 36.1 3.43 1.16-1.42 1.98-3.04 3.3-4.36l35.5-35.5A248.155 248.155 0 0 0 248 8C111.03 8 0 119.03 0 256s111.03 248 248 248 248-111.03 248-248c0-26.11-4.09-51.26-11.57-74.9z"]
};
var faBullseyePointer = {
  prefix: 'far',
  iconName: 'bullseye-pointer',
  icon: [496, 512, [], "f649", "M242.16 240.67L27.98 301.55c-15.17 4.31-16.95 25.1-2.73 31.92l68.47 32.89-89.17 89.17c-6.07 6.06-6.07 15.9 0 21.96l21.96 21.96c6.07 6.06 15.9 6.06 21.96 0l89.17-89.17 32.89 68.47c6.83 14.22 27.61 12.44 31.92-2.73l60.87-214.18c3.68-12.91-8.25-24.83-21.16-21.17zm27.36 117.03l-14.08 49.55C335.92 403.3 400 337.46 400 256c0-84.02-68-152-152-152-81.47 0-147.3 64.1-151.25 144.57l49.55-14.08C156.25 187.44 198.04 152 248 152c57.35 0 104 46.65 104 104 0 49.96-35.44 91.75-82.48 101.7zM248 8C111.03 8 0 119.03 0 256c0 7.3.47 14.49 1.09 21.63 3.46-1.97 7-3.87 10.99-5l36.24-10.3c-.07-2.12-.32-4.19-.32-6.33 0-110.28 89.72-200 200-200s200 89.72 200 200-89.72 200-200 200c-2.14 0-4.21-.25-6.33-.32l-10.3 36.24c-1.14 4.02-3.15 7.5-5.14 10.98 7.19.63 14.42 1.1 21.77 1.1 136.97 0 248-111.03 248-248S384.97 8 248 8z"]
};
var faBurgerSoda = {
  prefix: 'far',
  iconName: 'burger-soda',
  icon: [640, 512, [], "f858", "M110.47 464L81.72 176H336a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16H206.74l20-80H272a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-51.5a40 40 0 0 0-38.81 30.3L157.26 128H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h17.48l30.57 306.29A31.88 31.88 0 0 0 96 512h160a31.56 31.56 0 0 0 10.11-1.94A115.79 115.79 0 0 1 238.3 464zM528 312a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-80-16a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm192 80c0-12.92-6.53-23.88-16-31.19a71.86 71.86 0 0 0-5.11-74.32C585.46 222.87 518.41 192.06 448 192c-70.36.06-137.41 30.87-170.82 78.49a71.83 71.83 0 0 0-5.18 74.32c-9.51 7.31-16 18.27-16 31.19a39.64 39.64 0 0 0 12.65 28.91A59.64 59.64 0 0 0 264 428a84.09 84.09 0 0 0 84 84h200a84.09 84.09 0 0 0 84-84 59.64 59.64 0 0 0-4.65-23.09A39.64 39.64 0 0 0 640 376zm-323.56-77.95c22.77-32.45 72.89-58 131.56-58.05s108.8 25.6 131.57 58.06A24.07 24.07 0 0 1 559.84 336H336.17a24.07 24.07 0 0 1-19.73-37.95zM548 464H348a36 36 0 0 1-36-36 12 12 0 0 1 12-12h248a12 12 0 0 1 12 12 36 36 0 0 1-36 36zM368 312a16 16 0 1 0-16-16 16 16 0 0 0 16 16z"]
};
var faBurn = {
  prefix: 'far',
  iconName: 'burn',
  icon: [384, 512, [], "f46a", "M192 0C86.2 93.5 0 214.4 0 298.1 0 424 79 512 192 512s192-88 192-213.9c0-84-87.3-205.6-192-298.1zm0 65.2c51.4 51.1 144 158.5 144 232.9 0 29.5-5.6 55.6-15.1 78.4-3.5-74.7-83.7-157.9-128.9-208.8-45.8 51.5-125.4 133.8-128.9 208.8-9.4-22.8-15.1-49-15.1-78.4 0-74.2 92.6-181.7 144-232.9zm-18.1 397c-38.1-7.5-63.4-38.7-63.4-81.1 0-20.6 13.5-64.6 81.5-141.1 68 76.5 81.5 120.5 81.5 141.1 0 42.4-25.3 73.7-63.4 81.1-20.9 2.4-15.4 2.4-36.2 0z"]
};
var faBurrito = {
  prefix: 'far',
  iconName: 'burrito',
  icon: [512, 512, [], "f7ed", "M512 123a74.13 74.13 0 0 0-52.26-70.74A74.05 74.05 0 0 0 358.12 6.73a80.49 80.49 0 0 0-106 41.57L34 266.45a116 116 0 0 0 0 164.05L81.5 478a116 116 0 0 0 164.05 0L463.7 259.87a80.49 80.49 0 0 0 41.57-106A73.46 73.46 0 0 0 512 123zM163.52 464a67.54 67.54 0 0 1-48.08-19.92l-47.52-47.52a67.27 67.27 0 0 1-17.1-29.71A216.16 216.16 0 0 0 112 376c92.14 0 170.78-58.11 201.75-139.52a171.27 171.27 0 0 1 98.57 6.9l-200.7 200.7a67.55 67.55 0 0 1-48.1 19.92zM268.43 99.88A167.07 167.07 0 0 1 280 160c0 92.64-75.38 168-168 168a168 168 0 0 1-56.44-10.07 67.89 67.89 0 0 1 12.37-17.54z"]
};
var faBus = {
  prefix: 'far',
  iconName: 'bus',
  icon: [512, 512, [], "f207", "M368 368c17.67 0 32-14.33 32-32s-14.33-32-32-32-32 14.33-32 32 14.33 32 32 32zm-224 0c17.67 0 32-14.33 32-32s-14.33-32-32-32-32 14.33-32 32 14.33 32 32 32zm344-240h-8V80c0-44.8-99.2-80-224-80S32 35.2 32 80v48h-8c-13.25 0-24 10.74-24 24v80c0 13.25 10.75 24 24 24h8v160c0 17.67 14.33 32 32 32v32c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32v-32h224v32c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32v-32c17.67 0 32-14.33 32-32V256h8c13.25 0 24-10.75 24-24v-80c0-13.26-10.75-24-24-24zm-56 272H80V272h352v128zm0-176H80v-64h352v64zm0-112H80V85.43C94.18 71.6 156.69 48 256 48s161.82 23.6 176 37.43V112z"]
};
var faBusAlt = {
  prefix: 'far',
  iconName: 'bus-alt',
  icon: [512, 512, [], "f55e", "M144 304c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm344-176h-8V80c0-44.8-99.2-80-224-80S32 35.2 32 80v48h-8c-13.25 0-24 10.74-24 24v80c0 13.25 10.75 24 24 24h8v160c0 17.67 14.33 32 32 32v32c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32v-32h224v32c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32v-32c17.67 0 32-14.33 32-32V256h8c13.25 0 24-10.75 24-24v-80c0-13.26-10.75-24-24-24zM80 160h152v64H80v-64zm352 240H80V272h352v128zm0-176H280v-64h152v64zm0-112h-96c0-17.67-14.33-32-32-32h-96c-17.67 0-32 14.33-32 32H80V85.43C94.18 71.6 156.69 48 256 48s161.82 23.6 176 37.43V112zm-64 256c17.67 0 32-14.33 32-32s-14.33-32-32-32-32 14.33-32 32 14.33 32 32 32z"]
};
var faBusSchool = {
  prefix: 'far',
  iconName: 'bus-school',
  icon: [512, 512, [], "f5dd", "M488 128h-24V80c0-44.8-92.11-80-208-80S48 35.2 48 80v48H24c-13.25 0-24 10.74-24 24v80c0 13.25 10.75 24 24 24h16.91C25.59 273.01 16 295.3 16 320v64c0 29.95 20.65 54.88 48.43 61.87-.05.74-.43 1.37-.43 2.13v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-32h192v32c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32v-32c0-.76-.38-1.39-.43-2.13C475.35 438.88 496 413.95 496 384v-64c0-24.7-9.59-46.99-24.91-64H488c13.25 0 24-10.75 24-24v-80c0-13.26-10.75-24-24-24zM96 84.4C108.24 71.08 164.99 48 256 48s147.76 23.08 160 36.4V112h-80c0-17.67-14.33-32-32-32h-96c-17.67 0-32 14.33-32 32H96V84.4zM416 160v64H272v-64h144zm-320 0h144v64H96v-64zm352 224c0 8.82-7.18 16-16 16H80c-8.82 0-16-7.18-16-16v-64c0-26.47 21.53-48 48-48h288c26.47 0 48 21.53 48 48v64zm-80-80c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm-224 0c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faBusinessTime = {
  prefix: 'far',
  iconName: 'business-time',
  icon: [640, 512, [], "f64a", "M496 224c-79.59 0-144 64.41-144 144s64.41 144 144 144 144-64.41 144-144-64.41-144-144-144zm64 150.29c0 5.34-4.37 9.71-9.71 9.71h-60.57c-5.34 0-9.71-4.37-9.71-9.71v-76.57c0-5.34 4.37-9.71 9.71-9.71h12.57c5.34 0 9.71 4.37 9.71 9.71V352h38.29c5.34 0 9.71 4.37 9.71 9.71v12.58zM216 320h80c13.25 0 24-10.75 24-24v-24h28.68a177.277 177.277 0 0 1 46.45-48H48v-74c0-3.31 2.69-6 6-6h404c3.31 0 6 2.69 6 6v45.06c10.39-1.92 21.06-3.06 32-3.06 5.4 0 10.72.33 16 .81V144c0-26.51-21.49-48-48-48h-80V48c0-26.51-21.49-48-48-48H176c-26.51 0-48 21.49-48 48v48H48c-26.51 0-48 21.49-48 48v256c0 26.51 21.49 48 48 48h291.43a174.578 174.578 0 0 1-16.37-48H54c-3.31 0-6-2.69-6-6V272h144v24c0 13.25 10.75 24 24 24zM176 48h160v48H176V48z"]
};
var faCabinetFiling = {
  prefix: 'far',
  iconName: 'cabinet-filing',
  icon: [512, 512, [], "f64b", "M464 0H48C21.49 0 0 21.49 0 48v416c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V48c0-26.51-21.49-48-48-48zm0 464H48V280h416v184zm0-232H48V48h416v184zm-304-56h16c8.84 0 16-7.16 16-16v-8h128v8c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24c0-17.67-14.33-32-32-32H176c-17.67 0-32 14.33-32 32v24c0 8.84 7.16 16 16 16zm0 232h16c8.84 0 16-7.16 16-16v-8h128v8c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-24c0-17.67-14.33-32-32-32H176c-17.67 0-32 14.33-32 32v24c0 8.84 7.16 16 16 16z"]
};
var faCalculator = {
  prefix: 'far',
  iconName: 'calculator',
  icon: [448, 512, [], "f1ec", "M400 0H48C22.4 0 0 22.4 0 48v416c0 25.6 22.4 48 48 48h352c25.6 0 48-22.4 48-48V48c0-25.6-22.4-48-48-48zm0 464H48V208h352v256zm0-304H48V48h352v112zM108.8 320h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8zm192 96h38.4c6.4 0 12.8-6.4 12.8-12.8V268.8c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v134.4c0 6.4 6.4 12.8 12.8 12.8zm-192 0h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8zm96-96h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8zm0 96h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8z"]
};
var faCalculatorAlt = {
  prefix: 'far',
  iconName: 'calculator-alt',
  icon: [512, 512, [], "f64c", "M477.71 0H34.29C15.35 0 0 15.35 0 34.29v443.43C0 496.65 15.35 512 34.29 512h443.43c18.94 0 34.29-15.35 34.29-34.29V34.29C512 15.35 496.65 0 477.71 0zM232 464H48V280h184v184zm0-232H48V48h184v184zm232 232H280V280h184v184zm0-232H280V48h184v184zm-360-72h80c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-80c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8zm224 248h80c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-80c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8zm0-48h80c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-80c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8zm0-200h24v24c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-24h24c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-24v-24c0-4.42-3.58-8-8-8h-16c-4.42 0-8 3.58-8 8v24h-24c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8zM104.4 396.28l11.31 11.31c3.12 3.12 8.19 3.12 11.31 0L144 390.63l16.97 16.97c3.12 3.12 8.19 3.12 11.31 0l11.31-11.31c3.12-3.12 3.12-8.19 0-11.31L166.63 368l16.97-16.97c3.12-3.12 3.12-8.19 0-11.31l-11.31-11.31c-3.12-3.12-8.19-3.12-11.31 0L144 345.37l-16.97-16.97c-3.12-3.12-8.19-3.12-11.31 0l-11.31 11.31c-3.12 3.12-3.12 8.19 0 11.31L121.37 368l-16.97 16.97c-3.12 3.12-3.12 8.19 0 11.31z"]
};
var faCalendar = {
  prefix: 'far',
  iconName: 'calendar',
  icon: [448, 512, [], "f133", "M400 64h-48V12c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v52H160V12c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v52H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zm-6 400H54c-3.3 0-6-2.7-6-6V160h352v298c0 3.3-2.7 6-6 6z"]
};
var faCalendarAlt = {
  prefix: 'far',
  iconName: 'calendar-alt',
  icon: [448, 512, [], "f073", "M148 288h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40c0 6.6-5.4 12-12 12zm108-12v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm96 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm-96 96v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm-96 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm192 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm96-260v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h48V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h128V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h48c26.5 0 48 21.5 48 48zm-48 346V160H48v298c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCalendarCheck = {
  prefix: 'far',
  iconName: 'calendar-check',
  icon: [448, 512, [], "f274", "M400 64h-48V12c0-6.627-5.373-12-12-12h-40c-6.627 0-12 5.373-12 12v52H160V12c0-6.627-5.373-12-12-12h-40c-6.627 0-12 5.373-12 12v52H48C21.49 64 0 85.49 0 112v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zm-6 400H54a6 6 0 0 1-6-6V160h352v298a6 6 0 0 1-6 6zm-52.849-200.65L198.842 404.519c-4.705 4.667-12.303 4.637-16.971-.068l-75.091-75.699c-4.667-4.705-4.637-12.303.068-16.971l22.719-22.536c4.705-4.667 12.303-4.637 16.97.069l44.104 44.461 111.072-110.181c4.705-4.667 12.303-4.637 16.971.068l22.536 22.718c4.667 4.705 4.636 12.303-.069 16.97z"]
};
var faCalendarDay = {
  prefix: 'far',
  iconName: 'calendar-day',
  icon: [448, 512, [], "f783", "M112 368h96c8.8 0 16-7.2 16-16v-96c0-8.8-7.2-16-16-16h-96c-8.8 0-16 7.2-16 16v96c0 8.8 7.2 16 16 16zM400 64h-48V16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v48H160V16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v48H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zm0 394c0 3.3-2.7 6-6 6H54c-3.3 0-6-2.7-6-6V160h352v298z"]
};
var faCalendarEdit = {
  prefix: 'far',
  iconName: 'calendar-edit',
  icon: [448, 512, [], "f333", "M243.1 234.1l46.8 46.8c2 2 2 5.2 0 7.2L175.4 402.6l-48.2 5.4c-6.4.7-11.9-4.7-11.2-11.2l5.4-48.2 114.5-114.5c2-2 5.2-2 7.2 0zm83-10.8l-25.4-25.4c-7.9-7.9-20.7-7.9-28.6 0l-19.5 19.5c-2 2-2 5.2 0 7.2l46.8 46.8c2 2 5.2 2 7.2 0l19.5-19.5c7.9-7.9 7.9-20.7 0-28.6zM448 112v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h48V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h128V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h48c26.5 0 48 21.5 48 48zm-48 346V160H48v298c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCalendarExclamation = {
  prefix: 'far',
  iconName: 'calendar-exclamation',
  icon: [448, 512, [], "f334", "M188.6 212.7l6.5 104c.4 6.3 5.6 11.3 12 11.3h33.8c6.3 0 11.6-4.9 12-11.3l6.5-104c.4-6.9-5.1-12.7-12-12.7h-46.8c-6.9 0-12.4 5.8-12 12.7zM264 384c0 22.1-17.9 40-40 40s-40-17.9-40-40 17.9-40 40-40 40 17.9 40 40zM400 64h-48V12c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v52H160V12c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v52H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zm-6 400H54c-3.3 0-6-2.7-6-6V160h352v298c0 3.3-2.7 6-6 6z"]
};
var faCalendarMinus = {
  prefix: 'far',
  iconName: 'calendar-minus',
  icon: [448, 512, [], "f272", "M124 328c-6.6 0-12-5.4-12-12v-24c0-6.6 5.4-12 12-12h200c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12H124zm324-216v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h48V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h128V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h48c26.5 0 48 21.5 48 48zm-48 346V160H48v298c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCalendarPlus = {
  prefix: 'far',
  iconName: 'calendar-plus',
  icon: [448, 512, [], "f271", "M336 292v24c0 6.6-5.4 12-12 12h-76v76c0 6.6-5.4 12-12 12h-24c-6.6 0-12-5.4-12-12v-76h-76c-6.6 0-12-5.4-12-12v-24c0-6.6 5.4-12 12-12h76v-76c0-6.6 5.4-12 12-12h24c6.6 0 12 5.4 12 12v76h76c6.6 0 12 5.4 12 12zm112-180v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h48V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h128V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h48c26.5 0 48 21.5 48 48zm-48 346V160H48v298c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCalendarStar = {
  prefix: 'far',
  iconName: 'calendar-star',
  icon: [448, 512, [], "f736", "M167 331.4l-9.4 54.6c-1.7 9.9 8.7 17.2 17.4 12.6l48.9-25.8 48.9 25.8c8.7 4.6 19.1-2.8 17.4-12.6l-9.4-54.6 39.6-38.6c7.1-6.9 3.2-19-6.6-20.5l-54.7-8-24.5-49.6c-4.4-8.8-17.1-9-21.5 0l-24.5 49.6-54.7 8c-9.8 1.4-13.7 13.5-6.6 20.5l39.7 38.6zM400 64h-48V16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v48H160V16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v48H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zm0 394c0 3.3-2.7 6-6 6H54c-3.3 0-6-2.7-6-6V160h352v298z"]
};
var faCalendarTimes = {
  prefix: 'far',
  iconName: 'calendar-times',
  icon: [448, 512, [], "f273", "M311.7 374.7l-17 17c-4.7 4.7-12.3 4.7-17 0L224 337.9l-53.7 53.7c-4.7 4.7-12.3 4.7-17 0l-17-17c-4.7-4.7-4.7-12.3 0-17l53.7-53.7-53.7-53.7c-4.7-4.7-4.7-12.3 0-17l17-17c4.7-4.7 12.3-4.7 17 0l53.7 53.7 53.7-53.7c4.7-4.7 12.3-4.7 17 0l17 17c4.7 4.7 4.7 12.3 0 17L257.9 304l53.7 53.7c4.8 4.7 4.8 12.3.1 17zM448 112v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h48V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h128V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h48c26.5 0 48 21.5 48 48zm-48 346V160H48v298c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCalendarWeek = {
  prefix: 'far',
  iconName: 'calendar-week',
  icon: [448, 512, [], "f784", "M112 304h224c8.8 0 16-7.2 16-16v-64c0-8.8-7.2-16-16-16H112c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16zM400 64h-48V16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v48H160V16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v48H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zm0 394c0 3.3-2.7 6-6 6H54c-3.3 0-6-2.7-6-6V160h352v298z"]
};
var faCamera = {
  prefix: 'far',
  iconName: 'camera',
  icon: [512, 512, [], "f030", "M342.7 144H464v288H48V144h121.3l24-64h125.5l23.9 64zM324.3 32h-131c-20 0-37.9 12.4-44.9 31.1L136 96H48c-26.5 0-48 21.5-48 48v288c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V144c0-26.5-21.5-48-48-48h-88l-14.3-38c-5.8-15.7-20.7-26-37.4-26zM256 408c-66.2 0-120-53.8-120-120s53.8-120 120-120 120 53.8 120 120-53.8 120-120 120zm0-192c-39.7 0-72 32.3-72 72s32.3 72 72 72 72-32.3 72-72-32.3-72-72-72z"]
};
var faCameraAlt = {
  prefix: 'far',
  iconName: 'camera-alt',
  icon: [512, 512, [], "f332", "M256 408c-66.2 0-120-53.8-120-120s53.8-120 120-120 120 53.8 120 120-53.8 120-120 120zm0-192c-39.7 0-72 32.3-72 72s32.3 72 72 72 72-32.3 72-72-32.3-72-72-72zm-24 72c0-13.2 10.8-24 24-24 8.8 0 16-7.2 16-16s-7.2-16-16-16c-30.9 0-56 25.1-56 56 0 8.8 7.2 16 16 16s16-7.2 16-16zm110.7-145H464v288H48V143h121.3l24-64h125.5l23.9 64zM324.3 31h-131c-20 0-37.9 12.4-44.9 31.1L136 95H48c-26.5 0-48 21.5-48 48v288c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V143c0-26.5-21.5-48-48-48h-88l-14.3-38c-5.8-15.7-20.7-26-37.4-26z"]
};
var faCameraRetro = {
  prefix: 'far',
  iconName: 'camera-retro',
  icon: [512, 512, [], "f083", "M154 80H38c-3.3 0-6-2.7-6-6V38c0-3.3 2.7-6 6-6h116c3.3 0 6 2.7 6 6v36c0 3.3-2.7 6-6 6zm358 0v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V144c0-26.5 21.5-48 48-48h136l33.6-44.8C226.7 39.1 240.9 32 256 32h208c26.5 0 48 21.5 48 48zm-48 64H48v288h416V144zm0-64H256l-12 16h220V80zm-88 208c0-66.2-53.8-120-120-120s-120 53.8-120 120 53.8 120 120 120 120-53.8 120-120zm-48 0c0 39.7-32.3 72-72 72s-72-32.3-72-72 32.3-72 72-72 72 32.3 72 72zm-96 0c0-13.2 10.8-24 24-24 8.8 0 16-7.2 16-16s-7.2-16-16-16c-30.9 0-56 25.1-56 56 0 8.8 7.2 16 16 16s16-7.2 16-16z"]
};
var faCampfire = {
  prefix: 'far',
  iconName: 'campfire',
  icon: [512, 512, [], "f6ba", "M256 320c79.53 0 144-64.47 144-144 0-33.29-33.42-101.96-80-144-13.37 12.06-25.45 24.75-36.14 37.48C266.34 46.01 244.61 22.21 220 0c-63.17 56.98-108 131.22-108 176 0 79.53 64.47 144 144 144zM220.26 67.87c9.13 10.02 17.58 20.21 25.14 30.33l36.26 48.56 36.85-43.89C339.82 133.29 352 165.07 352 176c0 52.93-43.06 96-96 96-52.93 0-96-43.07-96-96 0-19.32 20.77-63.38 60.26-108.13zM500.9 465.46l-165.41-52.32 165.41-52.32c8.33-2.64 12.98-11.61 10.38-20.04l-4.71-15.27c-2.6-8.43-11.47-13.14-19.8-10.5L256 387.99 25.24 315c-8.33-2.64-17.2 2.07-19.8 10.5L.73 340.77c-2.6 8.43 2.04 17.41 10.37 20.04l165.41 52.32L11.1 465.46C2.77 468.09-1.88 477.07.73 485.5l4.71 15.27c2.6 8.44 11.47 13.14 19.8 10.5L256 438.28l230.76 72.99c8.33 2.63 17.2-2.07 19.8-10.5l4.71-15.27c2.61-8.44-2.03-17.41-10.37-20.04z"]
};
var faCampground = {
  prefix: 'far',
  iconName: 'campground',
  icon: [640, 512, [], "f6bb", "M624 464h-28.53l-245.9-341.21 63.33-87.88c5.22-7.12 3.68-17.14-3.44-22.36L396.58 3.1c-7.13-5.23-17.14-3.69-22.37 3.44L320 81.76 265.79 6.54c-5.22-7.13-15.24-8.67-22.37-3.44l-12.88 9.45c-7.12 5.22-8.67 15.24-3.44 22.36l63.33 87.88L44.53 464H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h608c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zM320 163.82L536.33 464h-99.97L320 304 203.64 464h-99.97L320 163.82z"]
};
var faCandleHolder = {
  prefix: 'far',
  iconName: 'candle-holder',
  icon: [448, 512, [], "f6bc", "M160 192c45.93 0 78-32.61 78-79.29C238 82.72 205.41 37.82 160 0c-45.62 38-78 82.84-78 112.71 0 46.68 32.07 79.29 78 79.29zm0-125.83c20.01 22.07 29.44 39.99 30 46.53 0 11.69-3.9 31.29-30 31.29s-30-19.61-30.01-31c.56-6.74 10-24.73 30.01-46.82zM376 368c-39.7 0-72 32.3-72 72 0 8.46 1.73 16.46 4.42 24H272V256c0-17.67-14.33-32-32-32H80c-17.67 0-32 14.33-32 32v208H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h360c39.7 0 72-32.3 72-72s-32.3-72-72-72zm-152 96H96V272h32v56c0 13.25 10.75 24 24 24s24-10.75 24-24v-56h48v192zm152 0c-13.23 0-24-10.77-24-24s10.77-24 24-24 24 10.77 24 24-10.77 24-24 24z"]
};
var faCandyCane = {
  prefix: 'far',
  iconName: 'candy-cane',
  icon: [512, 512, [], "f786", "M497.1 95.4C469.2 36.6 411.5 0 346.5 0c-29.9 0-59.2 8.1-85 23.5l-25.8 15.4c-21.8 13-28.9 41.3-15.9 63.1l30.8 51.5c12.1 20.2 39.9 29.7 63.1 15.9l25.8-15.4c16-9.6 30.1 14.6 14.4 24L22.5 375c-10.6 6.3-18 16.4-21 28.3s-1.2 24.3 5.1 34.8l30.8 51.5c8.3 13.8 23.4 22.4 39.5 22.4 8.3 0 16.4-2.3 23.6-6.5l325.7-193.6c75.7-45.3 106.9-140.4 70.9-216.5zM212.4 383.3L156 351.5l64.2-38.2 56.4 31.8-64.2 38.2zm111.8-66.5L267.8 285l59.4-35.3 56.3 31.7-59.3 35.4zM395.1 128c-3.2-4.1-6.8-7.7-10.9-10.8V54.3c30.1 10 55.3 31.6 69.5 61.7 1.9 3.9 2.9 8 4.3 12.1h-62.9zm-59-79.3v56.7c-15.9 2.8-19.3 6.2-45.1 22l-28.9-48.3c27.6-16.5 42.6-27.6 74-30.4zM108.4 379.8l56.5 31.8-87.2 51.9-28.9-48.3 59.6-35.4zm318.2-129.2l-51.8-29.2c17.9-10.6 29.2-23.2 32.9-45.4h55.4c-3.1 27.5-15.9 53.9-36.5 74.6z"]
};
var faCandyCorn = {
  prefix: 'far',
  iconName: 'candy-corn',
  icon: [640, 512, [], "f6bd", "M480 0C314.19 1.62 315.52 39.54 322.11 72.47 352.45 224.02 416.18 416 479.91 416h.09c63.77-.18 127.53-191.9 157.89-343.53C644.48 39.54 645.81 1.62 480 0zm-.07 365.62c-12.06-10.3-29.27-39.56-47.6-84.11 31.25-1.83 64.03-1.83 95.28 0-18.35 44.56-35.59 73.82-47.68 84.11zM591 63c-3.27 16.31-6.73 31.93-10.29 47.16-63.77-8.07-137.65-8.07-201.42 0C375.73 94.93 372.26 79.31 369 63c-.12-.62-.23-1.19-.33-1.72 10.2-4.34 38.91-12.52 111.34-13.26 72.42.74 101.13 8.92 111.34 13.26-.11.53-.22 1.1-.35 1.72zM84.94 205.81c-116.1 118.4-88.35 144.26-60.4 162.89 128.62 85.71 309.43 176.4 354.49 131.34l.06-.06c44.96-45.22-45.52-225.87-131.27-354.56-18.62-27.96-44.48-55.71-162.88 60.39zm6.69 149.12c-13.29-8.26-26.78-16.85-40.62-26.07-.53-.35-1.01-.68-1.45-.98 4.14-10.28 18.66-36.37 69.35-88.1 51.74-50.69 77.82-65.21 88.1-69.35.3.44.63.93.98 1.45 9.23 13.84 17.81 27.34 26.07 40.63-50.81 39.37-103.05 91.61-142.43 142.42zm226.04 16.27c18.53 44.49 27.03 77.37 25.76 93.2-15.81 1.24-48.68-7.28-93.13-25.82 20.81-23.39 43.98-46.57 67.37-67.38z"]
};
var faCannabis = {
  prefix: 'far',
  iconName: 'cannabis',
  icon: [544, 512, [], "f55f", "M516.88 312.08c-2.16-1.05-11.9-5.64-27.19-10.96 39.01-57.61 52.25-110.92 52.98-113.95 3.85-15.95-.78-32.74-12.27-44.54-9.21-9.45-21.8-14.64-34.78-14.64-3.21 0-6.45.32-9.66.97-3.1.63-55.54 11.56-114.37 43.47-14.48-85.81-57.6-148.6-59.79-151.74C302.76 7.74 287.89 0 272 0s-30.76 7.74-39.79 20.7c-2.19 3.14-45.31 65.92-59.79 151.74-58.83-31.91-111.27-42.85-114.37-43.47a48.7 48.7 0 0 0-9.66-.97c-12.98 0-25.57 5.19-34.78 14.64-11.5 11.79-16.13 28.58-12.28 44.53.73 3.03 13.98 56.34 52.98 113.95-15.29 5.32-25.03 9.91-27.19 10.96C10.54 320.13.01 336.85 0 355.17c-.01 18.32 10.49 35.05 27.06 43.12 2.17 1.05 46.28 22.24 105.46 28.67a47.751 47.751 0 0 0 13.09 38.15c9.26 9.65 21.98 14.89 35.03 14.89 4.47 0 8.97-.62 13.4-1.88 3.67-1.05 25.83-7.77 53.96-22.27V496c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-40.15c28.13 14.5 50.29 21.22 53.96 22.27 4.42 1.27 8.93 1.88 13.4 1.88 13.05 0 25.77-5.24 35.03-14.89 9.91-10.32 14.56-24.32 13.09-38.15 59.18-6.44 103.29-27.62 105.46-28.67 16.57-8.07 27.07-24.8 27.06-43.12-.01-18.32-10.54-35.04-27.12-43.09zM378.22 380.8c-17.3 0-31.13-.86-42.42-2.33-.22.11-.4.15-.62.27 19.77 28.81 28.18 53.26 28.18 53.26s-48-13.73-91.36-48.48C228.63 418.27 180.64 432 180.64 432s8.42-24.45 28.18-53.26c-.22-.11-.4-.15-.62-.27-11.29 1.46-25.12 2.33-42.42 2.33-64.84 0-117.4-25.6-117.4-25.6s40.88-19.84 94.97-24.56c-.85-.77-1.57-1.3-2.43-2.09C69.37 263.02 48.38 176 48.38 176s95.02 19.22 166.57 84.75c.93.85 1.57 1.57 2.48 2.41-.85-10.83-1.33-22.72-1.33-35.96C216.1 128.23 272 48 272 48s55.9 80.23 55.9 179.2c0 13.23-.48 25.13-1.33 35.96.91-.84 1.54-1.56 2.48-2.41C400.6 195.22 495.62 176 495.62 176s-20.99 87.02-92.54 152.55c-.86.79-1.58 1.32-2.43 2.09 54.09 4.71 94.97 24.56 94.97 24.56s-52.56 25.6-117.4 25.6z"]
};
var faCapsules = {
  prefix: 'far',
  iconName: 'capsules',
  icon: [544, 512, [], "f46b", "M529 296.8l-111.5-193C386.8 50.4 318.6 32.2 265.3 63c-21.2 12.3-36.6 30.5-45.8 51.3C206.4 67 163.5 32 112 32 50.1 32 0 82.1 0 144v224c0 61.9 50.1 112 112 112s112-50.1 112-112V214c.2.4.3.8.5 1.2l111.5 193c30.8 53.3 98.9 71.6 152.3 40.8s71.5-98.9 40.7-152.2zM176 256H48V144c0-84.7 128-84.7 128 0v112zm89.9-64.7c-42.1-73 68.2-136.7 110.3-63.7l43.8 75.8-110.3 63.7-43.8-75.8z"]
};
var faCar = {
  prefix: 'far',
  iconName: 'car',
  icon: [512, 512, [], "f1b9", "M499.99 192.01h-52.21l-31.36-77.88C404.24 83.84 374.86 64 342.22 64H169.78c-32.64 0-62.02 19.84-74.21 50.12L64.21 192h-52.2C4.2 192-1.53 199.34.37 206.91l6 24A12.01 12.01 0 0 0 18.01 240h11.31C21.04 254.16 16 270.41 16 287.99V424c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24v-24h352v24c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24V288c0-17.59-5.04-33.84-13.31-47.99H494c5.51 0 10.31-3.75 11.64-9.09l6-24c1.89-7.58-3.84-14.91-11.65-14.91zM140.1 132.05C145 119.87 156.65 112 169.78 112h172.44c13.13 0 24.78 7.87 29.68 20.05l24.13 59.94H115.97l24.13-59.94zM448 336c0 8.82-7.18 16-16 16H80c-8.82 0-16-7.18-16-16v-48c0-26.47 21.53-48 48-48h288c26.47 0 48 21.53 48 48v48zm-320-72.01c-19.2 0-32 12.76-32 31.91s12.8 31.91 32 31.91 48 3.19 48-15.96c0-19.14-28.8-47.86-48-47.86zm256 0c-19.2 0-48 28.72-48 47.86 0 19.15 28.8 15.96 48 15.96s32-12.76 32-31.91c0-19.14-12.8-31.91-32-31.91z"]
};
var faCarAlt = {
  prefix: 'far',
  iconName: 'car-alt',
  icon: [480, 512, [], "f5de", "M438.73 209.26l-38.3-95.14C388.24 83.84 358.87 64 326.22 64H153.78c-32.64 0-62.02 19.84-74.21 50.12l-38.31 95.14C16.37 226.6 0 255.35 0 287.99V424c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24v-24h352v24c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24V288c0-32.65-16.37-61.4-41.27-78.74zM124.1 132.05C129 119.87 140.65 112 153.78 112h172.44c13.13 0 24.78 7.87 29.68 20.05l24.13 59.94H99.97l24.13-59.94zM432 336c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16v-48c0-26.47 21.53-48 48-48h288c26.47 0 48 21.53 48 48v48zm-320-72.01c-19.2 0-32 12.76-32 31.91s12.8 31.91 32 31.91 48 3.19 48-15.96c0-19.14-28.8-47.86-48-47.86zm256 0c-19.2 0-48 28.72-48 47.86 0 19.15 28.8 15.96 48 15.96s32-12.76 32-31.91c0-19.14-12.8-31.91-32-31.91z"]
};
var faCarBattery = {
  prefix: 'far',
  iconName: 'car-battery',
  icon: [512, 512, [], "f5df", "M480 96h-48V80c0-8.84-7.16-16-16-16h-96c-8.84 0-16 7.16-16 16v15.98L208 96V80c0-8.84-7.16-16-16-16H96c-8.84 0-16 7.16-16 16v16H32c-17.67 0-32 14.33-32 32v288c0 17.67 14.33 32 32 32h448c17.67 0 32-14.33 32-32V128c0-17.67-14.33-32-32-32zm-16 304H48V144h416v256zM200 232H88c-4.42 0-8 3.58-8 8v32c0 4.42 3.58 8 8 8h112c4.42 0 8-3.58 8-8v-32c0-4.42-3.58-8-8-8zm224 0h-32v-32c0-4.42-3.58-8-8-8h-32c-4.42 0-8 3.58-8 8v32h-32c-4.42 0-8 3.58-8 8v32c0 4.42 3.58 8 8 8h32v32c0 4.42 3.58 8 8 8h32c4.42 0 8-3.58 8-8v-32h32c4.42 0 8-3.58 8-8v-32c0-4.42-3.58-8-8-8z"]
};
var faCarBuilding = {
  prefix: 'far',
  iconName: 'car-building',
  icon: [640, 512, [], "f859", "M148 192h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0 96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-192h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm156 80.14a143.45 143.45 0 0 1 48-25.81V32a32 32 0 0 0-32-32H32A32 32 0 0 0 0 32v400a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V48h256zM204 96a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm324 248a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm58.77-67.4l-14-32.72A111.86 111.86 0 0 0 469.8 176h-75.6a111.86 111.86 0 0 0-102.94 67.88l-14 32.72A80.15 80.15 0 0 0 224 352v32a79.67 79.67 0 0 0 32.07 63.65c0 .12-.07.23-.07.35v32a32 32 0 0 0 32 32h16a32 32 0 0 0 32-32v-16h192v16a32 32 0 0 0 32 32h16a32 32 0 0 0 32-32v-32c0-.12-.07-.23-.07-.35A79.67 79.67 0 0 0 640 384v-32a80.16 80.16 0 0 0-53.23-75.4zM592 384a32 32 0 0 1-32 32H304a32 32 0 0 1-32-32v-32a32 32 0 0 1 32-32h6.86l24.52-57.21A64 64 0 0 1 394.2 224h75.6a64 64 0 0 1 58.82 38.79L553.14 320H560a32 32 0 0 1 32 32zM256 244v-40a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12zm80 100a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm163.32-68.35A32.06 32.06 0 0 0 469.8 256h-75.6a32 32 0 0 0-29.41 19.4L345.2 320h173.6z"]
};
var faCarBump = {
  prefix: 'far',
  iconName: 'car-bump',
  icon: [576, 512, [], "f5e0", "M101.98 308.12c-17.69 8.02-23.99 24.81-15.77 41.96 8.22 17.15 25.5 23.24 43.18 15.22 17.69-8.02 45.59-17.2 37.37-34.35-8.22-17.16-47.09-30.86-64.78-22.83zm235.83-106.97c-17.69 8.02-31.88 45.79-23.66 62.94 8.22 17.15 33.38 2.26 51.07-5.76 17.69-8.02 23.99-24.81 15.77-41.96-8.22-17.15-25.5-23.24-43.18-15.22zM116.19 450.03l324.26-147.08 10.31 21.51c5.69 11.88 20.21 17.01 32.42 11.48l14.74-6.69c12.21-5.54 17.49-19.66 11.8-31.53l-44.67-93.19-13.75-28.67c-14.02-29.25-41.45-48.16-71.83-53.3l-76.15-69.24c-24.24-22.04-59.82-27.54-89.89-13.9L54.57 111.46C24.5 125.1 5.96 155.15 7.73 187.38l5.58 101.25c-15.48 25.94-18.22 58.54-4.19 87.79l58.42 121.86c5.69 11.88 20.21 17.02 32.42 11.48l14.74-6.69c12.21-5.54 17.49-19.66 11.8-31.53l-10.31-21.51zm-41-295.56l158.85-72.05c12.09-5.49 26.21-3.3 35.96 5.56l47.98 43.62-122.81 55.71-135.2 61.32-3.52-63.79c-.71-12.96 6.64-24.88 18.74-30.37zm20.38 252.55c-8.13 3.69-17.82.25-21.61-7.65l-20.62-43.01c-11.37-23.72-.78-52.01 23.6-63.07l265.3-120.33c24.38-11.06 53.47-.76 64.83 22.95l20.62 43.01c3.79 7.91.26 17.34-7.87 21.02L95.57 407.02zM464 384c-61.75 0-112 46.65-112 104 0 13.25 10.75 24 24 24s24-10.75 24-24c0-30.87 28.72-56 64-56s64 25.12 64 56c0 13.25 10.75 24 24 24s24-10.75 24-24c0-57.34-50.25-104-112-104z"]
};
var faCarBus = {
  prefix: 'far',
  iconName: 'car-bus',
  icon: [640, 512, [], "f85a", "M336 344.48a23.93 23.93 0 1 0 24 23.93 24 24 0 0 0-24-23.93zm163.32-68.16a32.06 32.06 0 0 0-29.52-19.59h-75.6a32 32 0 0 0-29.41 19.34l-19.59 44.47h173.6zM528 344.48a23.93 23.93 0 1 0 24 23.93 24 24 0 0 0-24-23.93zm58.77-67.21l-14-32.63A111.88 111.88 0 0 0 469.8 177h-75.6a111.88 111.88 0 0 0-102.94 67.69l-14 32.63A79.93 79.93 0 0 0 224 352.45v31.91c0 26 12.72 48.9 32.07 63.47 0 .13-.07.23-.07.35v31.91A32 32 0 0 0 288 512h16a32 32 0 0 0 32-31.91v-15.95h192v15.95A32 32 0 0 0 560 512h16a32 32 0 0 0 32-31.91v-31.91c0-.12-.07-.22-.07-.35 19.35-14.57 32.07-37.48 32.07-63.47v-31.91a79.93 79.93 0 0 0-53.23-75.18zM592 384.36a32 32 0 0 1-32 31.91H304a32 32 0 0 1-32-31.91v-31.91a32 32 0 0 1 32-31.91h6.86l24.52-57a64 64 0 0 1 58.82-38.68h75.6a64 64 0 0 1 58.82 38.68l24.52 57H560a32 32 0 0 1 32 31.91zM176 97.18H96a16 16 0 0 0-16 15.95v111.69a16 16 0 0 0 16 16h80zM48 328.52V99.15c0-28.72 63.77-51.29 144-51.29s144 22.57 144 51.29v58.33a144.12 144.12 0 0 1 48-11.69V99.15C384 26 280.57 0 192 0S0 26 0 99.15v229.37a56 56 0 0 0 56 55.84h8v31.91a32 32 0 0 0 32 31.91h16a32 32 0 0 0 32-31.91v-31.91h48v-31.91a110.91 110.91 0 0 1 1.18-15.95H56a8 8 0 0 1-8-7.98zm32-39.89a24 24 0 1 0 24-23.93 24 24 0 0 0-24 23.93zm181.84-56.56a143.19 143.19 0 0 1 42.16-55v-64a16 16 0 0 0-16-15.95h-80v143.65h50.11z"]
};
var faCarCrash = {
  prefix: 'far',
  iconName: 'car-crash',
  icon: [640, 512, [], "f5e1", "M136.89 123.07a31.77 31.77 0 0 0 12.66-22.45l2.16-21.95 12.19 18.36a31.944 31.944 0 0 0 21.75 13.86c9 1.28 17.94-1.17 24.97-6.89l52.16-42.94c10.25-8.42 11.72-23.55 3.28-33.78-8.47-10.23-23.56-11.66-33.78-3.28l-38.31 31.55-27.47-41.31C159.09 3.02 145.28-2.32 132.25.97c-13.06 3.28-22.66 14.47-23.91 27.78l-4.81 49.41-48.66-9.81c-13.09-2.56-26.66 3.3-33.56 14.84-6.94 11.53-5.81 26.23 2.72 36.56l31.53 38.31-41.34 27.48C2.88 193.1-2.31 206.52 1 219.74c3.28 13.22 14.19 22.62 27.78 23.97l49.41 4.78-9.81 48.66c-2.62 12.98 5.78 25.64 18.78 28.27 1.62.31 3.22.47 4.78.47 11.19 0 21.19-7.86 23.5-19.27l13.34-66.27c1.75-8.8-.31-17.97-5.62-25.17-5.34-7.2-13.53-11.84-22.5-12.73l-21.94-2.12 18.31-12.17c7.5-4.95 12.56-12.89 13.91-21.78a32.07 32.07 0 0 0-6.91-24.97l-14-17.02 21.62 4.36c8.68 1.76 17.99-.32 25.24-5.68zm397.86 187.6c-18.54-4.97-53.8 15.31-58.75 33.81s23.69 22.87 42.23 27.83c18.54 4.97 34.21-4.04 39.17-22.54s-4.11-34.13-22.65-39.1zm82.49-34.56L604.86 174.3c-3.94-32.41-27.18-59.17-58.71-67.62L379.59 62.06c-31.53-8.45-65.04 3.11-84.65 29.21l-61.62 81.98c-28.54 10.31-51.79 33.84-60.24 65.37l-35.2 131.37c-3.43 12.8 4.17 25.96 16.97 29.39l15.45 4.14c12.8 3.43 25.96-4.17 29.39-16.97l6.21-23.18 340.01 91.11-6.21 23.18c-3.43 12.8 4.17 25.96 16.97 29.39l15.46 4.14c12.8 3.43 25.96-4.17 29.39-16.97l26.92-100.46 8.28-30.91c8.45-31.54.08-63.54-19.48-86.74zM333.31 120.1c7.89-10.5 21.18-15.08 33.86-11.68l166.56 44.63c12.68 3.4 21.9 14.01 23.48 27.04l7.8 64.14-270.53-72.49 38.83-51.64zm257.05 230.32l-12.42 46.37c-2.28 8.52-11.07 13.6-19.6 11.31L218.33 317c-8.52-2.28-13.6-11.07-11.31-19.6l12.42-46.37c6.85-25.56 33.22-40.79 58.79-33.94l278.19 74.54c25.56 6.85 40.79 33.22 33.94 58.79zM287.47 244.41c-18.54-4.97-34.21 4.05-39.17 22.54s4.11 34.13 22.65 39.1c18.55 4.97 45.54 15.5 50.49-2.99 4.96-18.49-15.42-53.68-33.97-58.65z"]
};
var faCarGarage = {
  prefix: 'far',
  iconName: 'car-garage',
  icon: [640, 512, [], "f5e2", "M631.76 168.24L331.67 3.02a24.06 24.06 0 0 0-23.35 0L8.24 168.24c-7.74 4.3-10.52 14.05-6.23 21.79l7.78 14.01c4.3 7.74 14.05 10.52 21.79 6.23L320 51.53l288.41 158.73c7.74 4.3 17.49 1.51 21.79-6.23l7.78-14.01c4.3-7.73 1.51-17.49-6.22-21.78zM192 328c-19.2 0-32 12.76-32 31.91 0 19.14 12.8 31.91 32 31.91s48 3.19 48-15.96c0-19.14-28.8-47.86-48-47.86zm256 0c-19.2 0-48 28.72-48 47.86s28.8 15.96 48 15.96 32-12.76 32-31.91S467.2 328 448 328zm58.21-61.83l-25.79-64.04c-12.19-30.28-41.56-50.12-74.21-50.12H233.78c-32.65 0-62.02 19.84-74.21 50.12l-25.79 64.04C102.04 281.83 80 314.2 80 352v136c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24v-24h352v24c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24V352c0-37.8-22.04-70.17-53.79-85.83zM204.1 220.06c4.9-12.18 16.56-20.05 29.69-20.05h172.44c13.13 0 24.78 7.87 29.69 20.05L450.37 256H189.63l14.47-35.94zM512 400c0 8.82-7.18 16-16 16H144c-8.82 0-16-7.18-16-16v-48c0-26.47 21.53-48 48-48h288c26.47 0 48 21.53 48 48v48z"]
};
var faCarMechanic = {
  prefix: 'far',
  iconName: 'car-mechanic',
  icon: [512, 512, [], "f5e3", "M503.91 104h-55.98l-24-24 24-24h55.97c5.95 0 9.9-6.31 7.25-11.64-15.19-30.52-49.01-50.04-86.84-42.88-25.65 4.87-46.72 22.99-57.05 46.52H145.01c-12.38-28.17-40.2-48-72.94-48C40.75 0 13.9 18.12.84 44.37-1.81 49.7 2.15 56 8.09 56h55.98l24 24-24 24H8.09c-5.95 0-9.9 6.31-7.25 11.64 15.19 30.52 49.01 50.04 86.84 42.88 25.65-4.86 46.73-22.99 57.05-46.52h222.25c12.38 28.17 40.2 48 72.94 48 31.32 0 58.17-18.12 71.23-44.38 2.66-5.31-1.3-11.62-7.24-11.62zm-69.7 162.17l-25.79-64.04c-12.18-30.29-41.55-50.13-74.2-50.13H161.78c-32.65 0-62.02 19.84-74.21 50.12l-25.79 64.04C30.04 281.83 8 314.2 8 352v136c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24v-24h352v24c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24V352c0-37.8-22.04-70.17-53.79-85.83zM132.1 220.05C137 207.87 148.66 200 161.79 200h172.44c13.13 0 24.78 7.87 29.69 20.05l14.47 35.94H117.63l14.47-35.94zM440 400c0 8.82-7.18 16-16 16H72c-8.82 0-16-7.18-16-16v-48c0-26.47 21.53-48 48-48h288c26.47 0 48 21.53 48 48v48zm-320-72.01c-19.2 0-32 12.76-32 31.91s12.8 31.91 32 31.91 48 3.19 48-15.96-28.8-47.86-48-47.86zm256 0c-19.2 0-48 28.72-48 47.86s28.8 15.96 48 15.96 32-12.76 32-31.91-12.8-31.91-32-31.91z"]
};
var faCarSide = {
  prefix: 'far',
  iconName: 'car-side',
  icon: [640, 512, [], "f5e4", "M544 192h-16L419.21 56.02A63.99 63.99 0 0 0 369.24 32H155.33c-26.17 0-49.7 15.93-59.42 40.23L48 192v2.26C20.44 201.4 0 226.21 0 256v112c0 8.84 7.16 16 16 16h48c0 53.02 42.98 96 96 96s96-42.98 96-96h128c0 53.02 42.98 96 96 96s96-42.98 96-96h48c8.84 0 16-7.16 16-16v-80c0-53.02-42.98-96-96-96zM280 80h89.24c4.89 0 9.44 2.19 12.49 6l84.8 106H280V80zM140.47 90.06c2.45-6.11 8.28-10.06 14.86-10.06H232v112H99.7l40.77-101.94zM160 432c-26.51 0-48-21.49-48-48s21.49-48 48-48 48 21.49 48 48-21.49 48-48 48zm320 0c-26.51 0-48-21.49-48-48s21.49-48 48-48 48 21.49 48 48-21.49 48-48 48zm112-96h-29.31c-16.63-28.57-47.24-48-82.69-48s-66.05 19.43-82.69 48H242.69c-16.63-28.57-47.24-48-82.69-48s-66.05 19.43-82.69 48H48v-80c0-8.82 7.18-16 16-16h480c26.47 0 48 21.53 48 48v48z"]
};
var faCarTilt = {
  prefix: 'far',
  iconName: 'car-tilt',
  icon: [640, 512, [], "f5e5", "M198.33 314.05c-13.48 13.48-13.51 31.43-.06 44.87 13.44 13.44 31.39 13.42 44.87-.06 13.48-13.48 35.94-31.46 22.5-44.9-13.45-13.45-53.83-13.39-67.31.09zm179.73-179.72c-13.48 13.48-13.54 53.86-.1 67.3 13.44 13.44 31.42-9.02 44.9-22.5 13.48-13.48 13.51-31.42.06-44.87-13.43-13.43-31.38-13.41-44.86.07zM624 464H280.38l-20.26-20.77 247.12-247.12 16.85 16.85c9.3 9.3 24.39 9.3 33.7 0l11.23-11.23c9.3-9.3 9.3-24.39 0-33.7l-95.48-95.48c-22.92-22.92-54.59-31.6-84.24-26.3l-93.68-39.9C265.8-6.35 231.25.34 208.33 23.26L87.27 144.32c-22.92 22.92-29.61 57.46-16.91 87.28l39.9 93.68c-5.3 29.65 3.38 61.32 26.3 84.24L191.03 464H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h608c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zM114.2 212.94c-5.11-11.99-2.45-25.7 6.76-34.91L242.03 56.96c9.22-9.22 22.92-11.87 34.91-6.77l59.02 25.14-196.62 196.62-25.14-59.01zm89.75 196.59l-33.7-33.7c-18.58-18.58-18.58-48.81 0-67.39l202.19-202.19c18.58-18.58 48.82-18.58 67.4 0l33.7 33.7c6.19 6.19 6.19 16.27 0 22.46L226.42 409.53c-6.2 6.19-16.28 6.19-22.47 0z"]
};
var faCarWash = {
  prefix: 'far',
  iconName: 'car-wash',
  icon: [480, 512, [], "f5e6", "M80 128c23.56 0 42.67-19.1 42.67-42.67S80 0 80 0 37.33 61.77 37.33 85.33 56.44 128 80 128zm160 0c23.56 0 42.67-19.1 42.67-42.67S240 0 240 0s-42.67 61.77-42.67 85.33S216.44 128 240 128zm160 0c23.56 0 42.67-19.1 42.67-42.67S400 0 400 0s-42.67 61.77-42.67 85.33S376.44 128 400 128zm26.21 138.17l-25.79-64.04c-12.18-30.29-41.55-50.13-74.2-50.13H153.78c-32.65 0-62.02 19.84-74.21 50.12l-25.79 64.04C22.04 281.83 0 314.2 0 352v136c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24v-24h352v24c0 13.25 10.75 24 24 24h16c13.25 0 24-10.75 24-24V352c0-37.8-22.04-70.17-53.79-85.83zM124.1 220.05C129 207.87 140.66 200 153.79 200h172.44c13.13 0 24.78 7.87 29.69 20.05l14.47 35.94H109.63l14.47-35.94zM432 400c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16v-48c0-26.47 21.53-48 48-48h288c26.47 0 48 21.53 48 48v48zm-64-72.01c-19.2 0-48 28.72-48 47.86s28.8 15.96 48 15.96 32-12.76 32-31.91-12.8-31.91-32-31.91zm-256 0c-19.2 0-32 12.76-32 31.91s12.8 31.91 32 31.91 48 3.19 48-15.96-28.8-47.86-48-47.86z"]
};
var faCaretCircleDown = {
  prefix: 'far',
  iconName: 'caret-circle-down',
  icon: [512, 512, [], "f32d", "M157.1 216h197.8c10.7 0 16.1 13 8.5 20.5l-98.9 98.3c-4.7 4.7-12.2 4.7-16.9 0l-98.9-98.3c-7.7-7.5-2.3-20.5 8.4-20.5zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-48 0c0-110.5-89.5-200-200-200S56 145.5 56 256s89.5 200 200 200 200-89.5 200-200z"]
};
var faCaretCircleLeft = {
  prefix: 'far',
  iconName: 'caret-circle-left',
  icon: [512, 512, [], "f32e", "M296 157.1v197.8c0 10.7-13 16.1-20.5 8.5l-98.3-98.9c-4.7-4.7-4.7-12.2 0-16.9l98.3-98.9c7.5-7.7 20.5-2.3 20.5 8.4zM256 504C119 504 8 393 8 256S119 8 256 8s248 111 248 248-111 248-248 248zm0-48c110.5 0 200-89.5 200-200S366.5 56 256 56 56 145.5 56 256s89.5 200 200 200z"]
};
var faCaretCircleRight = {
  prefix: 'far',
  iconName: 'caret-circle-right',
  icon: [512, 512, [], "f330", "M216 354.9V157.1c0-10.7 13-16.1 20.5-8.5l98.3 98.9c4.7 4.7 4.7 12.2 0 16.9l-98.3 98.9c-7.5 7.7-20.5 2.3-20.5-8.4zM256 8c137 0 248 111 248 248S393 504 256 504 8 393 8 256 119 8 256 8zm0 48C145.5 56 56 145.5 56 256s89.5 200 200 200 200-89.5 200-200S366.5 56 256 56z"]
};
var faCaretCircleUp = {
  prefix: 'far',
  iconName: 'caret-circle-up',
  icon: [512, 512, [], "f331", "M354.9 296H157.1c-10.7 0-16.1-13-8.5-20.5l98.9-98.3c4.7-4.7 12.2-4.7 16.9 0l98.9 98.3c7.7 7.5 2.3 20.5-8.4 20.5zM8 256C8 119 119 8 256 8s248 111 248 248-111 248-248 248S8 393 8 256zm48 0c0 110.5 89.5 200 200 200s200-89.5 200-200S366.5 56 256 56 56 145.5 56 256z"]
};
var faCaretDown = {
  prefix: 'far',
  iconName: 'caret-down',
  icon: [320, 512, [], "f0d7", "M272 160H48.1c-42.6 0-64.2 51.7-33.9 81.9l111.9 112c18.7 18.7 49.1 18.7 67.9 0l112-112c30-30.1 8.7-81.9-34-81.9zM160 320L48 208h224L160 320z"]
};
var faCaretLeft = {
  prefix: 'far',
  iconName: 'caret-left',
  icon: [224, 512, [], "f0d9", "M224 367.952V144.057c0-42.638-51.731-64.151-81.941-33.941l-112 111.943c-18.745 18.745-18.746 49.137 0 67.882l112 111.952C172.208 432.042 224 410.675 224 367.952zM64 256l112-112v224L64 256z"]
};
var faCaretRight = {
  prefix: 'far',
  iconName: 'caret-right',
  icon: [224, 512, [], "f0da", "M0 144.048v223.895c0 42.638 51.731 64.151 81.941 33.941l112-111.943c18.745-18.745 18.746-49.137 0-67.882l-112-111.952C51.792 79.958 0 101.325 0 144.048zM160 256L48 368V144l112 112z"]
};
var faCaretSquareDown = {
  prefix: 'far',
  iconName: 'caret-square-down',
  icon: [448, 512, [], "f150", "M125.1 208h197.8c10.7 0 16.1 13 8.5 20.5l-98.9 98.3c-4.7 4.7-12.2 4.7-16.9 0l-98.9-98.3c-7.7-7.5-2.3-20.5 8.4-20.5zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCaretSquareLeft = {
  prefix: 'far',
  iconName: 'caret-square-left',
  icon: [448, 512, [], "f191", "M272 157.1v197.8c0 10.7-13 16.1-20.5 8.5l-98.3-98.9c-4.7-4.7-4.7-12.2 0-16.9l98.3-98.9c7.5-7.7 20.5-2.3 20.5 8.4zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCaretSquareRight = {
  prefix: 'far',
  iconName: 'caret-square-right',
  icon: [448, 512, [], "f152", "M176 354.9V157.1c0-10.7 13-16.1 20.5-8.5l98.3 98.9c4.7 4.7 4.7 12.2 0 16.9l-98.3 98.9c-7.5 7.7-20.5 2.3-20.5-8.4zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCaretSquareUp = {
  prefix: 'far',
  iconName: 'caret-square-up',
  icon: [448, 512, [], "f151", "M322.9 304H125.1c-10.7 0-16.1-13-8.5-20.5l98.9-98.3c4.7-4.7 12.2-4.7 16.9 0l98.9 98.3c7.7 7.5 2.3 20.5-8.4 20.5zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faCaretUp = {
  prefix: 'far',
  iconName: 'caret-up',
  icon: [320, 512, [], "f0d8", "M48.048 352h223.895c42.638 0 64.151-51.731 33.941-81.941l-111.943-112c-18.745-18.745-49.137-18.746-67.882 0l-111.952 112C-16.042 300.208 5.325 352 48.048 352zM160 192l112 112H48l112-112z"]
};
var faCarrot = {
  prefix: 'far',
  iconName: 'carrot',
  icon: [512, 512, [], "f787", "M369.8 142.2c22.7-47.5 11-103.8-35.4-142.2-44.5 36.9-56.7 90-37.4 136.1-14-4.9-28.3-8.1-42.5-8.1-48 0-94.1 26.8-116.6 72.8L2.4 478.3c-3 6.2-3.3 13.8 0 20.5 4.1 8.3 12.4 13.1 21 13.1 3.4 0 6.9-.8 10.3-2.4L311.3 374c25-12.2 46.4-32.6 59.6-59.6 15.7-32.1 16.9-67.6 6.1-98.9 45.9 18.7 98.4 6.3 135.1-37.9-38.6-46.4-94.8-58.1-142.3-35.4zm-42.1 151.2c-8.1 16.5-21 29.5-37.5 37.5l-57.3 28L209 335c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l12.2 12.2-110.4 54L173 238.3l34 34.7c4.7 4.7 10.8 7 17 7s12.3-2.3 17-7c9.4-9.4 9.4-24.6 0-33.9l-41.6-40.9c14.8-13.7 34-22.1 55.1-22.1 12.4 0 24.4 2.8 35.7 8.3 19.6 9.6 34.3 26.2 41.4 46.8 7 20.5 5.7 42.7-3.9 62.2z"]
};
var faCars = {
  prefix: 'far',
  iconName: 'cars',
  icon: [640, 512, [], "f85b", "M499.32 275.65A32.06 32.06 0 0 0 469.8 256h-75.6a32 32 0 0 0-29.41 19.4L345.2 320h173.6zM336 344a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm250.77-67.4l-14-32.72A111.86 111.86 0 0 0 469.8 176h-75.6a111.86 111.86 0 0 0-102.94 67.88l-14 32.72A80.16 80.16 0 0 0 224 352v32a79.67 79.67 0 0 0 32.07 63.65c0 .12-.07.23-.07.35v32a32 32 0 0 0 32 32h16a32 32 0 0 0 32-32v-16h192v16a32 32 0 0 0 32 32h16a32 32 0 0 0 32-32v-32c0-.12-.07-.23-.07-.35A79.67 79.67 0 0 0 640 384v-32a80.16 80.16 0 0 0-53.23-75.4zM592 384a32 32 0 0 1-32 32H304a32 32 0 0 1-32-32v-32a32 32 0 0 1 32-32h6.86l24.52-57.21A64 64 0 0 1 394.2 224h75.6a64 64 0 0 1 58.82 38.79L553.14 320H560a32 32 0 0 1 32 32zm-64-40a24 24 0 1 0 24 24 24 24 0 0 0-24-24zM275.32 99.65A32.06 32.06 0 0 0 245.8 80h-75.6a32 32 0 0 0-29.41 19.4L121.2 144h173.6zM252.79 252.4l5.32-12.4H80a32 32 0 0 1-32-32v-32a32 32 0 0 1 32-32h6.86l24.52-57.21A64 64 0 0 1 170.2 48h75.6a64 64 0 0 1 58.82 38.79L329.14 144H336c6.62 0 12.41 2.49 17.52 5.93A143.81 143.81 0 0 1 394.2 144h14.88a80.3 80.3 0 0 0-46.31-43.4l-14-32.72A111.86 111.86 0 0 0 245.8 0h-75.6A111.86 111.86 0 0 0 67.26 67.88l-14 32.72A80.16 80.16 0 0 0 0 176v32a79.67 79.67 0 0 0 32.07 63.65c0 .12-.07.23-.07.35v32a32 32 0 0 0 32 32h16a32 32 0 0 0 32-32v-16h100.46a112 112 0 0 1 40.33-35.6zM88 192a24 24 0 1 0 24-24 24 24 0 0 0-24 24z"]
};
var faCartArrowDown = {
  prefix: 'far',
  iconName: 'cart-arrow-down',
  icon: [576, 512, [], "f218", "M551.991 64H144.28l-8.726-44.608C133.35 8.128 123.478 0 112 0H12C5.373 0 0 5.373 0 12v24c0 6.627 5.373 12 12 12h80.24l69.594 355.701C150.796 415.201 144 430.802 144 448c0 35.346 28.654 64 64 64s64-28.654 64-64a63.681 63.681 0 0 0-8.583-32h145.167a63.681 63.681 0 0 0-8.583 32c0 35.346 28.654 64 64 64 35.346 0 64-28.654 64-64 0-18.136-7.556-34.496-19.676-46.142l1.035-4.757c3.254-14.96-8.142-29.101-23.452-29.101H203.76l-9.39-48h312.405c11.29 0 21.054-7.869 23.452-18.902l45.216-208C578.695 78.139 567.299 64 551.991 64zM208 472c-13.234 0-24-10.766-24-24s10.766-24 24-24 24 10.766 24 24-10.766 24-24 24zm256 0c-13.234 0-24-10.766-24-24s10.766-24 24-24 24 10.766 24 24-10.766 24-24 24zm23.438-200H184.98l-31.31-160h368.548l-34.78 160zm-91.923-59.515l-51.029 51.029c-4.686 4.686-12.284 4.686-16.971 0l-51.029-51.029c-7.56-7.56-2.206-20.485 8.485-20.485H312v-52c0-6.627 5.373-12 12-12h24c6.627 0 12 5.373 12 12v52h27.029c10.691 0 16.045 12.926 8.486 20.485z"]
};
var faCartPlus = {
  prefix: 'far',
  iconName: 'cart-plus',
  icon: [576, 512, [], "f217", "M551.991 64H144.28l-8.726-44.608C133.35 8.128 123.478 0 112 0H12C5.373 0 0 5.373 0 12v24c0 6.627 5.373 12 12 12h80.24l69.594 355.701C150.796 415.201 144 430.802 144 448c0 35.346 28.654 64 64 64s64-28.654 64-64a63.681 63.681 0 0 0-8.583-32h145.167a63.681 63.681 0 0 0-8.583 32c0 35.346 28.654 64 64 64s64-28.654 64-64c0-18.136-7.556-34.496-19.676-46.142l1.035-4.757c3.254-14.96-8.142-29.101-23.452-29.101H203.76l-9.39-48h312.405c11.29 0 21.054-7.869 23.452-18.902l45.216-208C578.695 78.139 567.299 64 551.991 64zM464 424c13.234 0 24 10.766 24 24s-10.766 24-24 24-24-10.766-24-24 10.766-24 24-24zm-256 0c13.234 0 24 10.766 24 24s-10.766 24-24 24-24-10.766-24-24 10.766-24 24-24zm279.438-152H184.98l-31.31-160h368.548l-34.78 160zM272 200v-16c0-6.627 5.373-12 12-12h32v-32c0-6.627 5.373-12 12-12h16c6.627 0 12 5.373 12 12v32h32c6.627 0 12 5.373 12 12v16c0 6.627-5.373 12-12 12h-32v32c0 6.627-5.373 12-12 12h-16c-6.627 0-12-5.373-12-12v-32h-32c-6.627 0-12-5.373-12-12z"]
};
var faCashRegister = {
  prefix: 'far',
  iconName: 'cash-register',
  icon: [512, 512, [], "f788", "M168 296h-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm-32-48c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-16zm96 0c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-16zm128 48h-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm48-64h-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm103.4 147.5l-25.5-178.3c-3.4-23.6-23.6-41.2-47.5-41.2H208v-32h96c8.8 0 16-7.2 16-16V16c0-8.8-7.2-16-16-16H48c-8.8 0-16 7.2-16 16v96c0 8.8 7.2 16 16 16h96v32H73.6c-23.9 0-44.1 17.6-47.5 41.2L.6 379.5c-.4 3-.6 6-.6 9.1V464c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48v-75.5c0-3-.2-6-.6-9zM80 80V48h192v32H80zm-6.4 128h364.7l22.9 160H50.8l22.8-160zM464 464H48v-48h416v48zM328 248c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-16zm-64 48h-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16z"]
};
var faCat = {
  prefix: 'far',
  iconName: 'cat',
  icon: [576, 512, [], "f6be", "M416 128c-8.84 0-16 7.16-16 16s7.16 16 16 16 16-7.16 16-16-7.16-16-16-16zM547.53 4.15A47.971 47.971 0 0 0 528.01 0c-11.64 0-23.13 4.23-32.12 12.32L456.25 48h-16.49l-39.64-35.68a48.032 48.032 0 0 0-51.65-8.17C331.16 11.87 320 29.04 320 48v112c0 4.24.85 8.24 1.25 12.38l-47 7.12c-67.48 10.23-124.62 46.4-162.25 97.52V184c0-48.53-39.47-88-88-88-13.25 0-24 10.75-24 24 0 13.47 11.12 24.37 24.68 23.99C47.02 143.37 64 164.57 64 186.92V399.3c0 73.41 39.4 112.7 88 112.7h184c8.84 0 16-7.16 16-16 0-17.67-14.33-32-32-32h-16.14c-.11-7.37-.78-14.63-1.85-21.81L384 393.95V480c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V270.2c38.07-22.2 64-63.03 64-110.19V48c0-18.95-11.16-36.13-28.47-43.85zM464 464h-32v-98.02c0-11.45-6.16-22.09-16.09-27.77-9.91-5.69-22.22-5.62-32.12.19l-96.35 56.68c-12.08-24.98-30.23-46.88-53.45-63.11-7.52-5.26-18.07-2.21-22.53 5.81l-7.44 13.39c-3.97 7.15-2.55 16.49 4.07 21.29 29.22 21.17 46.87 55.04 47.63 91.54H152c-22.06 0-40-17.94-40-40 0-99.28 71.25-182.16 169.44-197.03l53.57-8.12C356.4 259.74 398.75 288 448 288c5.48 0 10.7-.95 16-1.62V464zm64-304c0 44.18-35.82 80-80 80s-80-35.82-80-80V48l53.33 48h53.33L528 48v112zm-64-16c0 8.84 7.16 16 16 16s16-7.16 16-16-7.16-16-16-16-16 7.16-16 16z"]
};
var faCauldron = {
  prefix: 'far',
  iconName: 'cauldron',
  icon: [448, 512, [], "f6bf", "M448 196v-24c0-6.63-6.27-12-14-12H14c-7.73 0-14 5.37-14 12v24c0 6.63 6.27 12 14 12h29.63C16.35 250.46 0 299.55 0 345.6c0 39.08 11.82 70.65 32 95.53V488c0 13.25 10.75 24 24 24s24-10.75 24-24v-7.49c38.95 21.3 89.14 31.49 144 31.49s105.05-10.19 144-31.49V488c0 13.25 10.75 24 24 24s24-10.75 24-24v-46.87c20.18-24.88 32-56.45 32-95.53 0-46.04-16.35-95.13-43.63-137.6H434c7.73 0 14-5.37 14-12zm-54.51 188H392c.49 0 .89.25 1.37.28C367.36 455.26 269.65 464 224 464s-143.36-8.74-169.37-79.72c.48-.03.88-.28 1.37-.28h-1.49C50.44 372.78 48 360.14 48 345.6c0-45.61 21.15-97.83 54.92-137.6h242.17C378.85 247.77 400 299.99 400 345.6c0 14.54-2.44 27.18-6.51 38.4zM160 64c17.67 0 32-14.33 32-32S177.67 0 160 0s-32 14.33-32 32 14.33 32 32 32zm112 64c26.51 0 48-21.49 48-48s-21.49-48-48-48-48 21.49-48 48 21.49 48 48 48z"]
};
var faCertificate = {
  prefix: 'far',
  iconName: 'certificate',
  icon: [512, 512, [], "f0a3", "M489.199 255.927c41.041-40.173 24.263-102.49-31.145-116.634C473.43 85.289 427.935 38 372.589 53.775 358.41-1.828 295.346-17.915 256 22.621 242.445 8.655 226.954.019 205.706.018c-29.388-.001-57.144 17.868-66.295 53.757-54.95-15.663-100.976 31.042-85.465 85.518-55.295 14.115-72.274 76.374-31.145 116.634-40.946 40.08-24.367 102.464 31.145 116.634-15.512 54.481 30.59 101.158 85.465 85.518C153.747 514.3 216.434 529.714 256 489.25c39.511 40.408 102.326 24.759 116.589-31.171 55.007 15.678 100.937-31.177 85.465-85.518 55.295-14.115 72.274-76.374 31.145-116.634zm-31.205 36.574c11.133 10.539 5.95 29.28-8.665 32.775l-50.903 12.992 14.349 50.387c4.055 14.491-9.607 28.165-24.099 24.108l-50.37-14.354-12.987 50.92c-3.525 14.75-22.608 19.626-32.764 8.668L256 420.621l-36.554 37.376c-10.263 10.849-29.158 6.421-32.764-8.668l-12.987-50.92-50.37 14.354c-14.489 4.056-28.154-9.615-24.099-24.108l14.349-50.387-50.903-12.992c-14.609-3.494-19.803-22.231-8.665-32.775l37.363-36.566-37.363-36.566c-11.133-10.539-5.95-29.28 8.665-32.775l50.903-12.992-14.349-50.387c-4.054-14.49 9.605-28.166 24.099-24.108l50.37 14.354 12.987-50.92c3.476-14.546 22.503-19.514 32.764-8.668L256 91.525l36.554-37.652c10.382-10.974 29.328-5.71 32.764 8.668l12.987 50.92 50.37-14.354c14.488-4.056 28.154 9.615 24.099 24.108l-14.349 50.387 50.903 12.992c14.609 3.494 19.802 22.231 8.665 32.775l-37.363 36.566 37.364 36.566z"]
};
var faChair = {
  prefix: 'far',
  iconName: 'chair',
  icon: [448, 512, [], "f6c0", "M445.13 326.27l-10.66-31.97c-7.33-22.02-27.44-36.74-50.44-37.87L384 128C384 57.31 326.69 0 256 0h-64C121.31 0 64 57.31 64 128l-.03 128.43c-23 1.13-43.11 15.85-50.41 37.84L2.85 326.3c-5.66 17.03-2.78 35.89 7.72 50.44 5.57 7.73 13.02 13.65 21.41 17.65L32 496c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-96h288.04l-.04 96c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16l.04-101.61c8.39-4 15.84-9.92 21.41-17.65 10.49-14.55 13.37-33.41 7.68-50.47zM296 59.13c23.8 13.88 40 39.39 40 68.87v128h-40V59.13zM200 48h48v208h-48V48zm-48 11.13V256h-40V128c0-29.48 16.2-54.99 40-68.87zM48.38 341.48l10.72-32.03c1.06-3.27 4.12-5.45 7.56-5.45h314.69c3.44 0 6.5 2.19 7.59 5.48l10.66 31.97c1.77 5.33-2.24 10.55-7.59 10.55H56c-5.42 0-9.33-5.28-7.62-10.52z"]
};
var faChairOffice = {
  prefix: 'far',
  iconName: 'chair-office',
  icon: [448, 512, [], "f6c1", "M64 224v-64c0-17.67-14.33-32-32-32S0 142.33 0 160v64c0 17.67 14.33 32 32 32s32-14.33 32-32zm352-96c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32s32-14.33 32-32v-64c0-17.67-14.33-32-32-32zm-13.53 166.3c-7.34-22.03-27.46-36.75-50.47-37.88V64c0-35.35-28.65-64-64-64H160c-35.35 0-64 28.65-64 64v192.42c-23.01 1.12-43.13 15.84-50.43 37.84L34.85 326.3c-5.66 17.03-2.78 35.89 7.72 50.44C53.07 391.31 70.04 400 88.01 400H200v50.01c-31.93 4.97-57.99 19.43-69.85 38.56-6.41 10.34 2.41 23.43 15.02 23.43h157.66c12.61 0 21.44-13.09 15.02-23.43-11.86-19.13-37.92-33.59-69.85-38.56V400h112c17.97 0 34.94-8.69 45.45-23.27 10.5-14.55 13.38-33.41 7.69-50.47l-10.67-31.96zM144 64c0-8.82 7.18-16 16-16h128c8.82 0 16 7.18 16 16v192H144V64zm216 288H88.01c-5.42 0-9.33-5.28-7.62-10.52l10.72-32.03c1.06-3.27 4.12-5.45 7.56-5.45h250.67c3.44 0 6.5 2.19 7.6 5.48l10.66 31.97c1.77 5.35-2.26 10.55-7.6 10.55z"]
};
var faChalkboard = {
  prefix: 'far',
  iconName: 'chalkboard',
  icon: [640, 512, [], "f51b", "M80 48h480v368h48V40c0-22.06-17.94-40-40-40H72C49.94 0 32 17.94 32 40v376h48V48zm544 416H512v-80c0-17.67-14.33-32-32-32H288c-17.67 0-32 14.33-32 32v80H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h608c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zm-160 0H304v-64h160v64z"]
};
var faChalkboardTeacher = {
  prefix: 'far',
  iconName: 'chalkboard-teacher',
  icon: [640, 512, [], "f51c", "M226.79 342.02C199 342.02 192.02 352 160 352c-31.97 0-38.95-9.98-66.79-9.98C21.12 342.02 0 403 0 434.67V472c0 22.09 17.91 40 40 40h240c22.09 0 40-17.91 40-40v-37.33c0-42.72-30.58-92.65-93.21-92.65zM272 464H48v-29.33c0-14.01 8.15-44.65 45.21-44.65 17.24 0 29.56 9.98 66.79 9.98 37.37 0 49.49-9.98 66.79-9.98 37.02 0 45.21 30.58 45.21 44.65V464zM160 320c53.02 0 96-42.98 96-96s-42.98-96-96-96-96 42.98-96 96 42.98 96 96 96zm0-144c26.47 0 48 21.53 48 48s-21.53 48-48 48-48-21.53-48-48 21.53-48 48-48zM592 0H208c-26.47 0-48 22.25-48 49.59V96c9.69 0 32.27 3.13 48 9.52V48h384v320h-48v-48c0-17.67-14.33-32-32-32H384c-17.67 0-32 14.33-32 32v96h240c26.47 0 48-22.25 48-49.59V49.59C640 22.25 618.47 0 592 0zm-96 368h-96v-32h96v32z"]
};
var faChargingStation = {
  prefix: 'far',
  iconName: 'charging-station',
  icon: [576, 512, [], "f5e7", "M120.57 224h42.39l-8.78 54.77c-1.28 4.74 2.86 9.23 8.34 9.23 2.98 0 5.85-1.37 7.42-3.74l66.93-99.28c3.3-4.99-.82-11.26-7.42-11.26h-41.22l8.28-36.28c1.45-4.76-2.66-9.43-8.28-9.43h-48.57c-4.3 0-7.93 2.78-8.5 6.51l-19.1 81c-.67 4.49 3.33 8.48 8.51 8.48zM560 128h-16V80c0-8.84-7.16-16-16-16s-16 7.16-16 16v48h-32V80c0-8.84-7.16-16-16-16s-16 7.16-16 16v48h-16c-8.84 0-16 7.16-16 16v48c0 35.76 23.62 65.69 56 75.93V372c0 15.44-12.56 28-28 28s-28-12.56-28-28v-28c0-48.53-39.47-88-88-88h-8V48c0-26.51-21.49-48-48-48H80C53.49 0 32 21.49 32 48v416H8c-4.42 0-8 3.58-8 8v32c0 4.42 3.58 8 8 8h336c4.42 0 8-3.58 8-8v-32c0-4.42-3.58-8-8-8h-24V304h8c22.06 0 40 17.94 40 40v28c0 41.91 34.09 76 76 76s76-34.09 76-76V267.93c32.38-10.24 56-40.17 56-75.93v-48c0-8.84-7.16-16-16-16zM272 464H80V48h192v416zm256-272c0 17.64-14.36 32-32 32s-32-14.36-32-32v-16h64v16z"]
};
var faChartArea = {
  prefix: 'far',
  iconName: 'chart-area',
  icon: [512, 512, [], "f1fe", "M500 400c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12H12c-6.6 0-12-5.4-12-12V76c0-6.6 5.4-12 12-12h24c6.6 0 12 5.4 12 12v324h452zM372 128.7l-84 56-85.1-85.1c-5.5-5.5-14.8-4.4-18.8 2.3L96 256v96h384l-90.3-218.1c-3-6.9-11.5-9.4-17.7-5.2zM144 269.3l57.5-103.2 80.4 80.4c71.8-47.9 8.2-5.4 80.7-53.8L407.2 304H144v-34.7z"]
};
var faChartBar = {
  prefix: 'far',
  iconName: 'chart-bar',
  icon: [512, 512, [], "f080", "M396.8 352h22.4c6.4 0 12.8-6.4 12.8-12.8V108.8c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v230.4c0 6.4 6.4 12.8 12.8 12.8zm-192 0h22.4c6.4 0 12.8-6.4 12.8-12.8V140.8c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v198.4c0 6.4 6.4 12.8 12.8 12.8zm96 0h22.4c6.4 0 12.8-6.4 12.8-12.8V204.8c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v134.4c0 6.4 6.4 12.8 12.8 12.8zM496 400H48V80c0-8.84-7.16-16-16-16H16C7.16 64 0 71.16 0 80v336c0 17.67 14.33 32 32 32h464c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zm-387.2-48h22.4c6.4 0 12.8-6.4 12.8-12.8v-70.4c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v70.4c0 6.4 6.4 12.8 12.8 12.8z"]
};
var faChartLine = {
  prefix: 'far',
  iconName: 'chart-line',
  icon: [512, 512, [], "f201", "M117.65 277.65c6.25 6.25 16.38 6.25 22.63 0L192 225.94l84.69 84.69c6.25 6.25 16.38 6.25 22.63 0L409.54 200.4l29.49 29.5c15.12 15.12 40.97 4.41 40.97-16.97V112c0-8.84-7.16-16-16-16H363.07c-21.38 0-32.09 25.85-16.97 40.97l29.5 29.49-87.6 87.6-84.69-84.69c-6.25-6.25-16.38-6.25-22.63 0l-74.34 74.34c-6.25 6.25-6.25 16.38 0 22.63l11.31 11.31zM496 400H48V80c0-8.84-7.16-16-16-16H16C7.16 64 0 71.16 0 80v336c0 17.67 14.33 32 32 32h464c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16z"]
};
var faChartLineDown = {
  prefix: 'far',
  iconName: 'chart-line-down',
  icon: [512, 512, [], "f64d", "M180.69 246.62c6.25 6.25 16.38 6.25 22.63 0L288 161.94l87.6 87.6-29.5 29.49c-15.12 15.12-4.41 40.97 16.97 40.97H464c8.84 0 16-7.16 16-16V203.07c0-21.38-25.85-32.09-40.97-16.97l-29.49 29.5-110.23-110.22c-6.25-6.25-16.38-6.25-22.63 0L192 190.06l-51.72-51.72c-6.25-6.25-16.38-6.25-22.63 0l-11.31 11.31c-6.25 6.25-6.25 16.38 0 22.63l74.35 74.34zM496 400H48V80c0-8.84-7.16-16-16-16H16C7.16 64 0 71.16 0 80v336c0 17.67 14.33 32 32 32h464c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16z"]
};
var faChartNetwork = {
  prefix: 'far',
  iconName: 'chart-network',
  icon: [640, 512, [], "f78a", "M568 368c-19.1 0-36.3 7.6-49.2 19.7L440.6 343c4.5-12.2 7.4-25.2 7.4-39 0-61.9-50.1-112-112-112-8.4 0-16.6 1.1-24.4 2.9l-32.2-69c15-13.2 24.6-32.3 24.6-53.8 0-39.8-32.2-72-72-72s-72 32.2-72 72 32.2 72 72 72c.9 0 1.8-.2 2.7-.3l33.5 71.7C241.5 235.9 224 267.8 224 304c0 61.9 50.1 112 112 112 30.7 0 58.6-12.4 78.8-32.5l82.2 47c-.4 3.1-1 6.3-1 9.5 0 39.8 32.2 72 72 72s72-32.2 72-72-32.2-72-72-72zM232 96c-13.2 0-24-10.8-24-24s10.8-24 24-24 24 10.8 24 24-10.8 24-24 24zm104 272c-35.3 0-64-28.7-64-64s28.7-64 64-64 64 28.7 64 64-28.7 64-64 64zm232 96c-13.2 0-24-10.8-24-24s10.8-24 24-24 24 10.8 24 24-10.8 24-24 24zm-54.4-261.2l-19.2-25.6-48 36 19.2 25.6 48-36zM576 192c35.3 0 64-28.7 64-64s-28.7-64-64-64-64 28.7-64 64 28.7 64 64 64zM152 320h48v-32h-48v32zm-88-80c-35.3 0-64 28.7-64 64s28.7 64 64 64 64-28.7 64-64-28.7-64-64-64z"]
};
var faChartPie = {
  prefix: 'far',
  iconName: 'chart-pie',
  icon: [544, 512, [], "f200", "M511.96 223.2C503.72 103.74 408.26 8.28 288.8.04c-.35-.03-.7-.04-1.04-.04C279.11 0 272 7.44 272 16.23V240h223.77c9.14 0 16.82-7.68 16.19-16.8zM320 192V53.51C387.56 70.95 441.05 124.44 458.49 192H320zm-96 96V50.72c0-8.83-7.18-16.21-15.74-16.21-.7 0-1.4.05-2.11.15C86.99 51.49-4.1 155.6.14 280.37 4.47 407.53 113.18 512 240.12 512c.98 0 1.93-.01 2.91-.02 50.4-.63 96.97-16.87 135.26-44.03 7.9-5.6 8.42-17.23 1.57-24.08L224 288zm18.44 175.99l-2.31.01c-100.66 0-188.59-84.84-192.01-185.26-2.91-85.4 50.15-160.37 127.88-187.6v216.74l14.06 14.06 126.22 126.22c-23.16 10.1-48.16 15.5-73.84 15.83zM527.79 288H290.5l158.03 158.03c3.17 3.17 7.41 4.81 11.62 4.81 3.82 0 7.62-1.35 10.57-4.13 38.7-36.46 65.32-85.61 73.13-140.86 1.34-9.46-6.51-17.85-16.06-17.85z"]
};
var faChartPieAlt = {
  prefix: 'far',
  iconName: 'chart-pie-alt',
  icon: [512, 512, [], "f64e", "M461.29 288H224V50.71c0-8.83-7.18-16.21-15.74-16.21-.7 0-1.4.05-2.11.15C87.08 51.47-3.96 155.43.13 280.07 4.2 404.1 107.91 507.8 231.93 511.87c2.69.09 5.39.13 8.07.13 121.04 0 220.89-89.66 237.35-206.16 1.33-9.45-6.52-17.84-16.06-17.84zM240 464c-2.15 0-4.33-.04-6.5-.11-98.98-3.25-182.15-86.42-185.4-185.4C45.31 193.22 98.36 118.35 176 91.14V336h244.78C394.15 411.06 322.06 464 240 464zM288.8.04c-.35-.03-.7-.04-1.04-.04C279.1 0 272 7.44 272 16.23V240h223.77c9.14 0 16.82-7.69 16.2-16.8C503.72 103.74 408.26 8.28 288.8.04z"]
};
var faChartScatter = {
  prefix: 'far',
  iconName: 'chart-scatter',
  icon: [512, 512, [], "f7ee", "M496 400H48V80a16 16 0 0 0-16-16H16A16 16 0 0 0 0 80v336a32 32 0 0 0 32 32h464a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm-336-80a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm256-160a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm-224 0a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm192 160a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm-96-64a32 32 0 1 0-32-32 32 32 0 0 0 32 32z"]
};
var faCheck = {
  prefix: 'far',
  iconName: 'check',
  icon: [512, 512, [], "f00c", "M435.848 83.466L172.804 346.51l-96.652-96.652c-4.686-4.686-12.284-4.686-16.971 0l-28.284 28.284c-4.686 4.686-4.686 12.284 0 16.971l133.421 133.421c4.686 4.686 12.284 4.686 16.971 0l299.813-299.813c4.686-4.686 4.686-12.284 0-16.971l-28.284-28.284c-4.686-4.686-12.284-4.686-16.97 0z"]
};
var faCheckCircle = {
  prefix: 'far',
  iconName: 'check-circle',
  icon: [512, 512, [], "f058", "M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 48c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m140.204 130.267l-22.536-22.718c-4.667-4.705-12.265-4.736-16.97-.068L215.346 303.697l-59.792-60.277c-4.667-4.705-12.265-4.736-16.97-.069l-22.719 22.536c-4.705 4.667-4.736 12.265-.068 16.971l90.781 91.516c4.667 4.705 12.265 4.736 16.97.068l172.589-171.204c4.704-4.668 4.734-12.266.067-16.971z"]
};
var faCheckDouble = {
  prefix: 'far',
  iconName: 'check-double',
  icon: [448, 512, [], "f560", "M444.09 166.99l-27.39-28.37c-2.6-1.96-5.53-2.93-8.8-2.93-3.27 0-5.87.98-7.82 2.93L142.81 396.86l-94.88-94.88c-1.96-2.61-4.55-3.91-7.82-3.91-3.27 0-6.21 1.3-8.8 3.91l-27.4 27.38c-2.6 2.61-3.91 5.55-3.91 8.8s1.31 5.87 3.91 7.82l130.1 131.07c2.6 1.96 5.53 2.94 8.8 2.94 3.27 0 5.87-.98 7.82-2.94L444.08 183.6c2.6-2.61 3.91-5.55 3.91-8.8.01-3.24-1.3-5.86-3.9-7.81zM131.88 285.04c2.62 1.97 5.58 2.96 8.88 2.96s5.92-.99 7.89-2.96L353.34 80.35c2.62-2.64 3.95-5.6 3.95-8.88 0-3.28-1.33-5.92-3.95-7.89l-27.63-28.62c-2.62-1.97-5.58-2.96-8.88-2.96s-5.92.99-7.89 2.96L140.76 204.12l-60.41-60.41c-1.97-2.64-4.59-3.95-7.89-3.95s-6.26 1.31-8.88 3.95l-27.63 27.63c-2.62 2.64-3.95 5.6-3.95 8.88 0 3.29 1.33 5.92 3.95 7.89l95.93 96.93z"]
};
var faCheckSquare = {
  prefix: 'far',
  iconName: 'check-square',
  icon: [448, 512, [], "f14a", "M400 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zm0 400H48V80h352v352zm-35.864-241.724L191.547 361.48c-4.705 4.667-12.303 4.637-16.97-.068l-90.781-91.516c-4.667-4.705-4.637-12.303.069-16.971l22.719-22.536c4.705-4.667 12.303-4.637 16.97.069l59.792 60.277 141.352-140.216c4.705-4.667 12.303-4.637 16.97.068l22.536 22.718c4.667 4.706 4.637 12.304-.068 16.971z"]
};
var faCheese = {
  prefix: 'far',
  iconName: 'cheese',
  icon: [512, 512, [], "f7ef", "M299.83 32h-1.49a32.27 32.27 0 0 0-19.64 7L0 255.87V448a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V255.87C512 136.05 418 38.2 299.83 32zm3.77 48.4c87.74 7.67 155.63 79.47 159.64 167.42H88.47zM464 432H48V295.89h416z"]
};
var faCheeseSwiss = {
  prefix: 'far',
  iconName: 'cheese-swiss',
  icon: [512, 512, [], "f7f0", "M176 319.9a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM299.83 32h-1.49a32.27 32.27 0 0 0-19.64 7L0 255.87V448a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V255.87C512 136.05 418 38.2 299.83 32zM196.48 163.8A47.9 47.9 0 1 0 270 106.59l33.6-26.15c87.74 7.67 155.63 79.47 159.64 167.42h-53.9a47.59 47.59 0 0 0-82.68 0H88.47zM464 432H48V295.89h278.66a47.59 47.59 0 0 0 82.68 0H464z"]
};
var faCheeseburger = {
  prefix: 'far',
  iconName: 'cheeseburger',
  icon: [512, 512, [], "f7f1", "M352 176a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-96-32a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-96 32a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm352 112a79.33 79.33 0 0 0-28.1-60.4 8.78 8.78 0 0 0 1.2-1.5 72.49 72.49 0 0 0 .6-75.4C442.3 78.7 352.19 32.1 256 32c-96.1.1-186.31 46.7-229.71 118.7a72.45 72.45 0 0 0 .6 75.4 15.76 15.76 0 0 0 1.2 1.5 79.35 79.35 0 0 0-9.3 111.8 78.09 78.09 0 0 0 15 13.7c-.7 2.8-1.7 5.5-1.7 8.5v34.7a83.73 83.73 0 0 0 83.7 83.7h280.6a83.8 83.8 0 0 0 83.71-83.7v-34.7c0-3-1.1-5.7-1.7-8.5A80 80 0 0 0 512 288zM67.37 175.5c34.9-57.9 109-95.4 188.61-95.5 79.71.1 153.81 37.6 188.72 95.5a24.51 24.51 0 0 1-.2 25.2c-2.9 4.7-7.41 7.4-12.21 7.4H79.67c-4.8 0-9.3-2.7-12.2-7.4a24.73 24.73 0 0 1-.1-25.2zM432 396.3a35.72 35.72 0 0 1-35.7 35.7H115.67A35.72 35.72 0 0 1 80 396.3v-25.6h352zm0-76.3H80a32 32 0 0 1 0-64h144l96 48 96-48h16a32 32 0 1 1 0 64z"]
};
var faChess = {
  prefix: 'far',
  iconName: 'chess',
  icon: [512, 512, [], "f439", "M497.59 279.17A31.92 31.92 0 0 0 512 252.44V192a32 32 0 0 0-32-32H288a32 32 0 0 0-32 32v60.5c0 10.92 5.47 21 12.75 25.52L296 299.61v74.77a23.69 23.69 0 0 0-8 17.62v24l-25.6 19.2A16 16 0 0 0 256 448a16 16 0 0 0-6.4-12.8L224 416v-24a23.73 23.73 0 0 0-16.83-22.55c-3.84-25-6.41-50.14-6.41-75.42V256H208a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-3.1l26.91-80.41A24 24 0 0 0 209 96h-64.24V64h24a8 8 0 0 0 8-8V40a8 8 0 0 0-8-8h-24V8a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v24h-24a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h24v32H48.5a24 24 0 0 0-22.78 31.59l27 80.41H48a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h8.76v38c0 25.17-2.56 50.23-6.36 75.1C39.93 371.71 32 380.73 32 392v24L6.4 435.2A16 16 0 0 0 0 448v48a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16 16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-48a16 16 0 0 0-6.4-12.8L480 416v-24a23.69 23.69 0 0 0-8-17.62v-74.82zM175.71 144l-16.33 48.76-5.1 15.24h-50.92l-5.14-15.28L81.87 144zm-17 224H98.82c3.55-25.22 5.94-50.12 5.94-74v-38h48v38c0 23.92 2.4 48.81 5.94 74zM48 464l12.8-9.6L80 440v-24h96v24l19.2 14.4L208 464zm256 0l12.8-9.6L336 440v-24h96v24l19.2 14.4L464 464zm160-219.33l-40 31.74V368h-80v-91.61l-40-31.56V208h32v24h32v-24h32v24h32v-24h32zM384 288a16 16 0 0 0-16 16v32h32v-32a16 16 0 0 0-16-16z"]
};
var faChessBishop = {
  prefix: 'far',
  iconName: 'chess-bishop',
  icon: [320, 512, [], "f43a", "M304 464H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM0 304c0 51.64 30.14 85.24 64 96v32h48v-67.11l-33.46-10.64C63.78 349.56 48 333.9 48 304c0-74.57 66.13-165.78 101.33-201.84a15.81 15.81 0 0 1 22.27-.24c12.64 11.8 34 35.52 59.22 81.33l-66.13 66.13a16 16 0 0 0 0 22.62L176 283.31a16 16 0 0 0 22.62 0L252.94 229c11.43 27.7 19.06 54.54 19.06 75 0 29.9-15.78 45.56-30.54 50.25L208 364.89V432h48v-32c33.86-10.76 64-44.36 64-96 0-73.38-67.81-197.2-120.6-241.49C213.4 59.09 224 47.05 224 32a32 32 0 0 0-32-32h-64a32 32 0 0 0-32 32c0 15 10.6 27.09 24.6 30.51C67.81 106.8 0 230.62 0 304z"]
};
var faChessBishopAlt = {
  prefix: 'far',
  iconName: 'chess-bishop-alt',
  icon: [256, 512, [], "f43b", "M249.6 435.2L224 416v-24c0-12.1-9.1-21.68-20.74-23.34a460.24 460.24 0 0 1-3.2-48.66H208a16 16 0 0 0 16-16v-16a15.8 15.8 0 0 0-13.62-15.52C224 261.59 232 243.33 232 211.37c0-41.66-25.85-100.61-57.95-132.6C184.27 76 192 67.06 192 56a24.07 24.07 0 0 0-24-24H88a24.07 24.07 0 0 0-24 24c0 11.06 7.73 20 18 22.77-32.15 31.99-58 90.94-58 132.6 0 32 8 50.22 21.62 61.11A15.8 15.8 0 0 0 32 288v16a16 16 0 0 0 16 16h7.94a460.24 460.24 0 0 1-3.2 48.66C41.1 370.31 32 379.9 32 392v24L6.4 435.2A16 16 0 0 0 0 448v48a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-48a16 16 0 0 0-6.4-12.8zM115.21 110.39a16.3 16.3 0 0 1 25.58 0 220.39 220.39 0 0 1 17.78 26.27L121 174.28a8 8 0 0 0 0 11.32l13.45 13.45a8 8 0 0 0 11.32 0l28.66-28.67c5.8 15.3 9.62 29.88 9.62 41v.55A49.85 49.85 0 0 1 169 247l-9 9v16H96v-16l-9-9a49.83 49.83 0 0 1-15-35.1v-.59c0-25.71 17.81-68.97 43.21-100.92zM154.9 368h-53.8c1.58-16 2.78-31.95 2.84-48h48.12c.06 16.05 1.26 32 2.84 48zM48 464l32-24v-24h96v24l32 24z"]
};
var faChessBoard = {
  prefix: 'far',
  iconName: 'chess-board',
  icon: [512, 512, [], "f43c", "M448 384v-64h-64v64zm0-127.93v-64h-64v64zM320.07 448h64v-64h-64zm-127.94 0h64v-64h-64zM64.2 256.1v64h64v-64zM448 64.2h-64v64h64zm-255.87 0h-64v64h64zm-127.93 64v64h64v-64zm255.87-64h-64v64h64zm-64 255.87v64h64v-64zm-64 0h-64v64h64zM384 192.13v-64h-64v64zm-64 127.94h64v-64h-64zm-64-127.94v-64h-64v64zm64 64v-64h-64v64zm-64 0h-64v64h64zm-64-64h-64v64h64zm-64 191.9H64v64h64zM480 0H32A32 32 0 0 0 0 32v448a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-16 464H48V48h416z"]
};
var faChessClock = {
  prefix: 'far',
  iconName: 'chess-clock',
  icon: [640, 512, [], "f43d", "M448.22 416.06a112 112 0 1 0-112-111.95 112 112 0 0 0 112 111.95zm-12.67-122.19L486.46 243a12 12 0 0 1 17 0l5.66 5.65a12 12 0 0 1 0 17l-50.91 50.9a12 12 0 0 1-17 0l-5.65-5.66a12 12 0 0 1-.01-17.02zM600 96h-55.79V80a16 16 0 0 0-16-16h-128a16 16 0 0 0-16 16v16H200.08V48h40a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H112a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h40v48H40a40 40 0 0 0-40 40v336a40 40 0 0 0 40 40h560a40 40 0 0 0 40-40V136a40 40 0 0 0-40-40zm-8 368H48V144h544zm-399.88-48.09a112 112 0 1 0-112-112 112 112 0 0 0 112 112zm-16-179.91a12 12 0 0 1 12-12h8a12 12 0 0 1 12 12v72a12 12 0 0 1-12 12h-8a12 12 0 0 1-12-12z"]
};
var faChessClockAlt = {
  prefix: 'far',
  iconName: 'chess-clock-alt',
  icon: [640, 512, [], "f43e", "M600 96H487.94V48h40a16 16 0 0 0 16-16V16A16 16 0 0 0 528 0H400a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h40v48H256V80a16 16 0 0 0-16-16H112a16 16 0 0 0-16 16v16H40a40 40 0 0 0-40 40v336a40 40 0 0 0 40 40h560a40 40 0 0 0 40-40V136a40 40 0 0 0-40-40zm-8 368H48V144h544zm-400-47.94A112 112 0 1 0 80 304.11a112 112 0 0 0 112 111.95zm-12.67-122.19L230.24 243a12 12 0 0 1 17 0l5.65 5.65a12 12 0 0 1 0 17L202 316.49a12 12 0 0 1-17 0l-5.66-5.66a12 12 0 0 1-.01-16.96zM448 415.91A112 112 0 1 0 336 304a112 112 0 0 0 112 111.91zM432 236a12 12 0 0 1 12-12h8a12 12 0 0 1 12 12v72a12 12 0 0 1-12 12h-8a12 12 0 0 1-12-12z"]
};
var faChessKing = {
  prefix: 'far',
  iconName: 'chess-king',
  icon: [448, 512, [], "f43f", "M400 464H48a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm37.05-281.16A55.37 55.37 0 0 0 391.93 160H248v-56h48a8 8 0 0 0 8-8V64a8 8 0 0 0-8-8h-48V8a8 8 0 0 0-8-8h-32a8 8 0 0 0-8 8v48h-48a8 8 0 0 0-8 8v32a8 8 0 0 0 8 8h48v56H56a55.95 55.95 0 0 0-53.31 73.06L68.51 432h50.54L48.38 218.38A8 8 0 0 1 56 208h335.93a8 8 0 0 1 7.78 10l-70.82 214h50.55l66-199.31a55.35 55.35 0 0 0-8.39-49.85z"]
};
var faChessKingAlt = {
  prefix: 'far',
  iconName: 'chess-king-alt',
  icon: [320, 512, [], "f440", "M281.6 435.2L256 416v-24a23.73 23.73 0 0 0-16.83-22.55c-3.83-25-6.41-50.14-6.41-75.42V256H240a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-3.1l26.92-80.41A24 24 0 0 0 241 96h-64.24V64h24a8 8 0 0 0 8-8V40a8 8 0 0 0-8-8h-24V8a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v24h-24a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h24v32H80.5a24 24 0 0 0-22.78 31.59l27 80.41H80a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h8.76v38c0 25.17-2.56 50.23-6.36 75.1C71.93 371.71 64 380.73 64 392v24l-25.6 19.2A16 16 0 0 0 32 448v48a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-48a16 16 0 0 0-6.4-12.8zM207.72 144l-21.52 64h-50.88l-21.5-64zm-17.29 224H131.1c3.37-24.53 5.66-49.2 5.66-74v-38h48v38c0 24.8 2.29 49.47 5.67 74zM80 464l32-24v-24h96v24l32 24z"]
};
var faChessKnight = {
  prefix: 'far',
  iconName: 'chess-knight',
  icon: [384, 512, [], "f441", "M44.05 320.68l14.41 6.41A113 113 0 0 0 32.07 400v32h48v-32a65.49 65.49 0 0 1 36.18-58.57L154.36 318a39.31 39.31 0 0 0 21.71-35.15v-58.78l-15.27 9.06a19.64 19.64 0 0 0-10.26 12.8L143 271a26.2 26.2 0 0 1-15.35 16.78L117.17 292a26.12 26.12 0 0 1-20.36-.38l-33.26-14.8A26.21 26.21 0 0 1 48 252.88V140.53a19.67 19.67 0 0 1 5.75-13.9l7.34-7.34L49.46 96A14 14 0 0 1 48 89.82 9.82 9.82 0 0 1 57.82 80h105.09c86.76 0 157 70.37 157 157.17V432h48V237.17C367.93 124 276 32 162.91 32H57.82A57.89 57.89 0 0 0 0 89.82a62.22 62.22 0 0 0 5.15 24.72 67.51 67.51 0 0 0-5.15 26v112.34a74.26 74.26 0 0 0 44.05 67.8zM80.07 164a20 20 0 1 0 20-20 20 20 0 0 0-20 20zM368 464H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z"]
};
var faChessKnightAlt = {
  prefix: 'far',
  iconName: 'chess-knight-alt',
  icon: [320, 512, [], "f442", "M89.69 195.2a13.87 13.87 0 1 0-13.81-13.87 13.84 13.84 0 0 0 13.81 13.87zm223.91 240L288 416v-30.13a78.67 78.67 0 0 0 16-47.13V232.61C304 139.64 228.38 64 135.42 64h-80a55.65 55.65 0 0 0-52.31 74.15 62.19 62.19 0 0 0-3.06 19.56v84.84a67.88 67.88 0 0 0 37 60.43q-15.76 22.09-20.2 51.52A75.61 75.61 0 0 0 32 411.57V416L6.4 435.2A16 16 0 0 0 0 448v48a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-48a16 16 0 0 0-6.4-12.8zM55.43 112h80C201.74 112 256 166.27 256 232.61v106.13a32 32 0 0 1-9.37 22.63L240 368H64.8c-.19-2.14-.78-4.23-.45-6.4 4.34-29 21.48-45.89 46.18-57l34.85-10.86A24.76 24.76 0 0 0 160 271.19v-48.26l-27.12 4.7a14.88 14.88 0 0 0-7.72 9.68l-5.68 18.95A19.76 19.76 0 0 1 108 268.93c-5.54 2.22-10.22 4.61-15.48 4.61a18.67 18.67 0 0 1-7.71-1.74l-25-11.15A19.83 19.83 0 0 1 48 242.55v-84.84c0-7.37 4.39-10.55 9.85-16l-8.71-17.61c-3.3-6.63 1.14-12.1 6.29-12.1zM48 464l32-24v-24h160v24l32 24z"]
};
var faChessPawn = {
  prefix: 'far',
  iconName: 'chess-pawn',
  icon: [320, 512, [], "f443", "M304 464H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM48 288h32v29.5c0 40.29-3.51 81.23-23.43 114.5h53.57c15-37 17.86-77.35 17.86-114.5V288h64v29.5c0 37.15 2.91 77.49 17.86 114.5h53.57C243.51 398.73 240 357.79 240 317.5V288h32a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-31c23.8-21.93 39-53.08 39-88a120 120 0 0 0-240 0c0 34.92 15.16 66.07 39 88H48a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16zM160 80a72 72 0 1 1-72 72 72.08 72.08 0 0 1 72-72z"]
};
var faChessPawnAlt = {
  prefix: 'far',
  iconName: 'chess-pawn-alt',
  icon: [256, 512, [], "f444", "M249.6 435.2L224 416v-24a24 24 0 0 0-24-24h2.61c-1.54-16-2.61-32-2.61-48v-32h8a16 16 0 0 0 16-16v-16a15.76 15.76 0 0 0-13.61-15.46A95 95 0 0 0 224 192a96 96 0 1 0-178.42 48.49A15.79 15.79 0 0 0 32 256v16a16 16 0 0 0 16 16h8v32c0 16-1.07 32-2.61 48H56a24 24 0 0 0-24 24v24L6.4 435.2A16 16 0 0 0 0 448v48a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-48a16 16 0 0 0-6.4-12.8zM152 288v30c0 16.69 1 33.35 2.54 50h-53.08c1.54-16.62 2.54-33.28 2.54-50v-30zm-24-144a48 48 0 1 1-48 48 48.05 48.05 0 0 1 48-48zM48 464l32-24v-24h96v24l32 24z"]
};
var faChessQueen = {
  prefix: 'far',
  iconName: 'chess-queen',
  icon: [512, 512, [], "f445", "M256 112a56 56 0 1 0-56-56 56 56 0 0 0 56 56zm248.87 72.16l-28.51-15.92a15.09 15.09 0 0 0-8.45-2.59 17.59 17.59 0 0 0-13.84 7.27A47.48 47.48 0 0 1 416 192a50.79 50.79 0 0 1-9.16-.85C383.7 186.86 368 164.93 368 141.4a13.4 13.4 0 0 0-13.4-13.4h-38.77c-6 0-11.61 4-12.86 9.91a48 48 0 0 1-93.94 0c-1.25-5.92-6.82-9.91-12.86-9.91H157.4a13.4 13.4 0 0 0-13.4 13.4c0 25.69-19 48.75-44.67 50.49-1.12.07-2.23.11-3.33.11a47.47 47.47 0 0 1-38.21-19.26 17.17 17.17 0 0 0-13.61-7.13 15.16 15.16 0 0 0-8.48 2.59l-28.57 16a16 16 0 0 0-5.44 20.47L109.84 432H163L69.91 236.32A94.78 94.78 0 0 0 96 240c2.17 0 4.37-.07 6.57-.22 34.06-2.31 63.1-23 78.23-52.22a95.81 95.81 0 0 0 150.29.14c13.29 26 37.51 45.18 67 50.64A98.41 98.41 0 0 0 416 240a96.13 96.13 0 0 0 26-3.55L349 432h53.16l108.15-227.37a16 16 0 0 0-5.44-20.47zM432 464H80a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z"]
};
var faChessQueenAlt = {
  prefix: 'far',
  iconName: 'chess-queen-alt',
  icon: [256, 512, [], "f446", "M223.67 416v-24c0-11.22-7.86-20.21-18.25-22.84-3.12-22.26-5.34-44.64-5.34-67.13V256h24a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-7.5l38.59-105a8.16 8.16 0 0 0-2.76-10.42l-12.15-8.11c-3.8-2.53-8.61-1.24-11.33 2.39-14 18.65-43.76 9-43.76-16.06a6.82 6.82 0 0 0-6.85-6.8h-19.71a6.6 6.6 0 0 0-6.54 5 24.4 24.4 0 0 1-47.76 0 6.59 6.59 0 0 0-6.54-5H78.06a6.82 6.82 0 0 0-6.82 6.82c0 25.32-30 34.55-43.83 16-2.44-3.28-7.21-5-11.23-2.31L4 92.6A8.16 8.16 0 0 0 1.24 103l38.59 105h-7.5a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h24v46c0 22.44-2.21 44.76-5.33 67-10.78 2.35-19 11.5-19 23v24L6.39 435.2A16 16 0 0 0 0 448v48a16 16 0 0 0 16 16h223.64a16 16 0 0 0 16-16v-48a16 16 0 0 0-6.39-12.8zM93.26 127.36a71.71 71.71 0 0 0 69.71.08 70.83 70.83 0 0 0 26.82 14.43L166.92 208H89.46l-22.89-66.19a71.44 71.44 0 0 0 26.69-14.45zM156.92 368H99.46c2.78-21.9 4.77-43.89 4.77-66v-46h47.92v46c0 22.11 1.99 44.1 4.77 66zm-109 96l31.95-24v-24h95.86v24l31.95 24zm80.27-408a28 28 0 1 0-28-28 28 28 0 0 0 28 28z"]
};
var faChessRook = {
  prefix: 'far',
  iconName: 'chess-rook',
  icon: [384, 512, [], "f447", "M368 464H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM346 32H38A38 38 0 0 0 0 70v139.43a32 32 0 0 0 11 24.14l37 32.21c0 48.49 1.54 93-11.85 166.22h49C98 356.41 96 309.53 96 238.22l-48-41.78V80h64v48h48V80h64v48h48V80h64v116.44l-48 41.78C288 309 286 356.6 298.86 432h49C334.47 358.81 336 314 336 265.78l37-32.21a32 32 0 0 0 11-24.14V70a38 38 0 0 0-38-38zM192 224a32 32 0 0 0-32 32v64h64v-64a32 32 0 0 0-32-32z"]
};
var faChessRookAlt = {
  prefix: 'far',
  iconName: 'chess-rook-alt',
  icon: [320, 512, [], "f448", "M313.6 435.2L288 416v-24c0-11.17-7.79-20.14-18.13-22.81l-5.34-117.63 26.73-20.15A32 32 0 0 0 304 205.86V96a32 32 0 0 0-32-32H48a32 32 0 0 0-32 32v110a32 32 0 0 0 12.78 25.58l26.69 20.05-5.34 117.6C39.79 371.86 32 380.83 32 392v24L6.4 435.2A16 16 0 0 0 0 448v48a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-48a16 16 0 0 0-6.4-12.8zM64 112h40v32h32v-32h48v32h32v-32h40v85.88l-40.53 30.56L221.55 368H98.45l6.08-139.59L64 197.94zM48 464l32-24v-24h160v24l32 24zm136-216.41a23.59 23.59 0 0 0-47.18 0V288H184z"]
};
var faChevronCircleDown = {
  prefix: 'far',
  iconName: 'chevron-circle-down',
  icon: [512, 512, [], "f13a", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.5 0-200-89.5-200-200S145.5 56 256 56s200 89.5 200 200-89.5 200-200 200zm8.5-107.5l122.8-122.8c4.7-4.7 4.7-12.3 0-17l-22.6-22.6c-4.7-4.7-12.3-4.7-17 0L256 277.8l-91.7-91.7c-4.7-4.7-12.3-4.7-17 0l-22.6 22.6c-4.7 4.7-4.7 12.3 0 17l122.8 122.8c4.7 4.7 12.3 4.7 17 0z"]
};
var faChevronCircleLeft = {
  prefix: 'far',
  iconName: 'chevron-circle-left',
  icon: [512, 512, [], "f137", "M504 256C504 119 393 8 256 8S8 119 8 256s111 248 248 248 248-111 248-248zm-448 0c0-110.5 89.5-200 200-200s200 89.5 200 200-89.5 200-200 200S56 366.5 56 256zm107.5-8.5l122.8-122.8c4.7-4.7 12.3-4.7 17 0l22.6 22.6c4.7 4.7 4.7 12.3 0 17L234.2 256l91.7 91.7c4.7 4.7 4.7 12.3 0 17l-22.6 22.6c-4.7 4.7-12.3 4.7-17 0L163.5 264.5c-4.7-4.7-4.7-12.3 0-17z"]
};
var faChevronCircleRight = {
  prefix: 'far',
  iconName: 'chevron-circle-right',
  icon: [512, 512, [], "f138", "M8 256c0 137 111 248 248 248s248-111 248-248S393 8 256 8 8 119 8 256zm448 0c0 110.5-89.5 200-200 200S56 366.5 56 256 145.5 56 256 56s200 89.5 200 200zm-107.5 8.5L225.7 387.3c-4.7 4.7-12.3 4.7-17 0l-22.6-22.6c-4.7-4.7-4.7-12.3 0-17l91.7-91.7-91.7-91.7c-4.7-4.7-4.7-12.3 0-17l22.6-22.6c4.7-4.7 12.3-4.7 17 0l122.8 122.8c4.7 4.7 4.7 12.3 0 17z"]
};
var faChevronCircleUp = {
  prefix: 'far',
  iconName: 'chevron-circle-up',
  icon: [512, 512, [], "f139", "M264.5 163.5l122.8 122.8c4.7 4.7 4.7 12.3 0 17l-22.6 22.6c-4.7 4.7-12.3 4.7-17 0L256 234.2l-91.7 91.7c-4.7 4.7-12.3 4.7-17 0l-22.6-22.6c-4.7-4.7-4.7-12.3 0-17l122.8-122.8c4.7-4.7 12.3-4.7 17 0zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-48 0c0-110.5-89.5-200-200-200S56 145.5 56 256s89.5 200 200 200 200-89.5 200-200z"]
};
var faChevronDoubleDown = {
  prefix: 'far',
  iconName: 'chevron-double-down',
  icon: [448, 512, [], "f322", "M441.9 89.7L232.5 299.1c-4.7 4.7-12.3 4.7-17 0L6.1 89.7c-4.7-4.7-4.7-12.3 0-17l19.8-19.8c4.7-4.7 12.3-4.7 17 0L224 233.6 405.1 52.9c4.7-4.7 12.3-4.7 17 0l19.8 19.8c4.7 4.7 4.7 12.3 0 17zm0 143l-19.8-19.8c-4.7-4.7-12.3-4.7-17 0L224 393.6 42.9 212.9c-4.7-4.7-12.3-4.7-17 0L6.1 232.7c-4.7 4.7-4.7 12.3 0 17l209.4 209.4c4.7 4.7 12.3 4.7 17 0l209.4-209.4c4.7-4.7 4.7-12.3 0-17z"]
};
var faChevronDoubleLeft = {
  prefix: 'far',
  iconName: 'chevron-double-left',
  icon: [448, 512, [], "f323", "M390.3 473.9L180.9 264.5c-4.7-4.7-4.7-12.3 0-17L390.3 38.1c4.7-4.7 12.3-4.7 17 0l19.8 19.8c4.7 4.7 4.7 12.3 0 17L246.4 256l180.7 181.1c4.7 4.7 4.7 12.3 0 17l-19.8 19.8c-4.7 4.7-12.3 4.7-17 0zm-143 0l19.8-19.8c4.7-4.7 4.7-12.3 0-17L86.4 256 267.1 74.9c4.7-4.7 4.7-12.3 0-17l-19.8-19.8c-4.7-4.7-12.3-4.7-17 0L20.9 247.5c-4.7 4.7-4.7 12.3 0 17l209.4 209.4c4.7 4.7 12.3 4.7 17 0z"]
};
var faChevronDoubleRight = {
  prefix: 'far',
  iconName: 'chevron-double-right',
  icon: [448, 512, [], "f324", "M57.7 38.1l209.4 209.4c4.7 4.7 4.7 12.3 0 17L57.7 473.9c-4.7 4.7-12.3 4.7-17 0l-19.8-19.8c-4.7-4.7-4.7-12.3 0-17L201.6 256 20.9 74.9c-4.7-4.7-4.7-12.3 0-17l19.8-19.8c4.7-4.7 12.3-4.7 17 0zm143 0l-19.8 19.8c-4.7 4.7-4.7 12.3 0 17L361.6 256 180.9 437.1c-4.7 4.7-4.7 12.3 0 17l19.8 19.8c4.7 4.7 12.3 4.7 17 0l209.4-209.4c4.7-4.7 4.7-12.3 0-17L217.7 38.1c-4.7-4.7-12.3-4.7-17 0z"]
};
var faChevronDoubleUp = {
  prefix: 'far',
  iconName: 'chevron-double-up',
  icon: [448, 512, [], "f325", "M6.1 422.3l209.4-209.4c4.7-4.7 12.3-4.7 17 0l209.4 209.4c4.7 4.7 4.7 12.3 0 17l-19.8 19.8c-4.7 4.7-12.3 4.7-17 0L224 278.4 42.9 459.1c-4.7 4.7-12.3 4.7-17 0L6.1 439.3c-4.7-4.7-4.7-12.3 0-17zm0-143l19.8 19.8c4.7 4.7 12.3 4.7 17 0L224 118.4l181.1 180.7c4.7 4.7 12.3 4.7 17 0l19.8-19.8c4.7-4.7 4.7-12.3 0-17L232.5 52.9c-4.7-4.7-12.3-4.7-17 0L6.1 262.3c-4.7 4.7-4.7 12.3 0 17z"]
};
var faChevronDown = {
  prefix: 'far',
  iconName: 'chevron-down',
  icon: [448, 512, [], "f078", "M441.9 167.3l-19.8-19.8c-4.7-4.7-12.3-4.7-17 0L224 328.2 42.9 147.5c-4.7-4.7-12.3-4.7-17 0L6.1 167.3c-4.7 4.7-4.7 12.3 0 17l209.4 209.4c4.7 4.7 12.3 4.7 17 0l209.4-209.4c4.7-4.7 4.7-12.3 0-17z"]
};
var faChevronLeft = {
  prefix: 'far',
  iconName: 'chevron-left',
  icon: [256, 512, [], "f053", "M231.293 473.899l19.799-19.799c4.686-4.686 4.686-12.284 0-16.971L70.393 256 251.092 74.87c4.686-4.686 4.686-12.284 0-16.971L231.293 38.1c-4.686-4.686-12.284-4.686-16.971 0L4.908 247.515c-4.686 4.686-4.686 12.284 0 16.971L214.322 473.9c4.687 4.686 12.285 4.686 16.971-.001z"]
};
var faChevronRight = {
  prefix: 'far',
  iconName: 'chevron-right',
  icon: [256, 512, [], "f054", "M24.707 38.101L4.908 57.899c-4.686 4.686-4.686 12.284 0 16.971L185.607 256 4.908 437.13c-4.686 4.686-4.686 12.284 0 16.971L24.707 473.9c4.686 4.686 12.284 4.686 16.971 0l209.414-209.414c4.686-4.686 4.686-12.284 0-16.971L41.678 38.101c-4.687-4.687-12.285-4.687-16.971 0z"]
};
var faChevronSquareDown = {
  prefix: 'far',
  iconName: 'chevron-square-down',
  icon: [448, 512, [], "f329", "M215.5 348.5L92.7 225.7c-4.7-4.7-4.7-12.3 0-17l22.6-22.6c4.7-4.7 12.3-4.7 17 0l91.7 91.7 91.7-91.7c4.7-4.7 12.3-4.7 17 0l22.6 22.6c4.7 4.7 4.7 12.3 0 17L232.5 348.5c-4.7 4.7-12.3 4.7-17 0zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faChevronSquareLeft = {
  prefix: 'far',
  iconName: 'chevron-square-left',
  icon: [448, 512, [], "f32a", "M131.5 247.5l122.8-122.8c4.7-4.7 12.3-4.7 17 0l22.6 22.6c4.7 4.7 4.7 12.3 0 17L202.2 256l91.7 91.7c4.7 4.7 4.7 12.3 0 17l-22.6 22.6c-4.7 4.7-12.3 4.7-17 0L131.5 264.5c-4.7-4.7-4.7-12.3 0-17zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faChevronSquareRight = {
  prefix: 'far',
  iconName: 'chevron-square-right',
  icon: [448, 512, [], "f32b", "M316.5 264.5L193.7 387.3c-4.7 4.7-12.3 4.7-17 0l-22.6-22.6c-4.7-4.7-4.7-12.3 0-17l91.7-91.7-91.7-91.7c-4.7-4.7-4.7-12.3 0-17l22.6-22.6c4.7-4.7 12.3-4.7 17 0l122.8 122.8c4.7 4.7 4.7 12.3 0 17zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faChevronSquareUp = {
  prefix: 'far',
  iconName: 'chevron-square-up',
  icon: [448, 512, [], "f32c", "M232.5 163.5l122.8 122.8c4.7 4.7 4.7 12.3 0 17l-22.6 22.6c-4.7 4.7-12.3 4.7-17 0L224 234.2l-91.7 91.7c-4.7 4.7-12.3 4.7-17 0l-22.6-22.6c-4.7-4.7-4.7-12.3 0-17l122.8-122.8c4.7-4.7 12.3-4.7 17 0zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"]
};
var faChevronUp = {
  prefix: 'far',
  iconName: 'chevron-up',
  icon: [448, 512, [], "f077", "M6.101 359.293L25.9 379.092c4.686 4.686 12.284 4.686 16.971 0L224 198.393l181.13 180.698c4.686 4.686 12.284 4.686 16.971 0l19.799-19.799c4.686-4.686 4.686-12.284 0-16.971L232.485 132.908c-4.686-4.686-12.284-4.686-16.971 0L6.101 342.322c-4.687 4.687-4.687 12.285 0 16.971z"]
};
var faChild = {
  prefix: 'far',
  iconName: 'child',
  icon: [448, 512, [], "f1ae", "M410.947 101.089c-22.433-22.431-55.179-26.458-81.062-14.53C320.167 38.057 277.177 0 224 0c-53.179 0-96.168 38.06-105.885 86.559-25.929-11.95-58.664-7.866-81.06 14.527-28.074 28.075-28.074 73.752-.003 101.825L96 261.823V440c0 39.701 32.299 72 72 72h8c18.423 0 35.253-6.955 48-18.378C236.747 505.045 253.577 512 272 512h8c39.701 0 72-32.299 72-72V261.823l58.946-58.912c28.072-28.073 28.072-73.75.001-101.822zM224 48c33.137 0 60 26.863 60 60s-26.863 60-60 60-60-26.863-60-60 26.863-60 60-60zm152.971 120.971L304 241.941V440c0 13.255-10.745 24-24 24h-8c-13.255 0-24-10.745-24-24v-96h-48v96c0 13.255-10.745 24-24 24h-8c-13.255 0-24-10.745-24-24V241.941L71.029 168.97c-9.372-9.373-9.372-24.569 0-33.942 9.373-9.372 24.568-9.372 33.941 0L177.941 208h92.117l72.971-72.971c9.373-9.372 24.568-9.372 33.941 0 9.373 9.373 9.373 24.569.001 33.942z"]
};
var faChimney = {
  prefix: 'far',
  iconName: 'chimney',
  icon: [512, 512, [], "f78b", "M480 0H32C14.3 0 0 14.3 0 32v160c0 17.7 14.3 32 32 32v256c0 17.7 14.3 32 32 32h384c17.7 0 32-14.3 32-32V224c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32zM304 464H80v-80h224v80zM80 336V224h80v112H80zm352 128h-80v-80h80v80zm0-128H208V224h224v112zm32-160H48V48h416v128z"]
};
var faChurch = {
  prefix: 'far',
  iconName: 'church',
  icon: [576, 512, [], "f51d", "M281.71 320.3c-33.27 3.17-57.71 33.02-57.71 66.45V496c0 8.84 7.16 16 16 16h96c8.84 0 16-7.16 16-16V384c0-37.42-32.12-67.34-70.29-63.7zm276.86 19.69L448 292.58v-34.46c0-11.24-5.9-21.66-15.54-27.44L312 158.4V112h60c6.63 0 12-5.37 12-12V76c0-6.63-5.37-12-12-12h-60V12c0-6.63-5.37-12-12-12h-24c-6.63 0-12 5.37-12 12v52h-60c-6.63 0-12 5.37-12 12v24c0 6.63 5.37 12 12 12h60v46.4l-120.46 72.28A31.997 31.997 0 0 0 128 258.12v34.47l-110.57 47.4C6.96 344.99 0 357.89 0 372.32v122.44C0 504.28 5.97 512 13.33 512H32c8.84 0 16-7.16 16-16V379.11l80-34.3V496c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16V267.17l112-67.2 112 67.2V496c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16V344.81l80 34.3V496c0 8.84 7.16 16 16 16h18.67c7.37 0 13.33-7.71 13.33-17.23V372.32c0-14.43-6.96-27.33-17.43-32.33z"]
};
var faCircle = {
  prefix: 'far',
  iconName: 'circle',
  icon: [512, 512, [], "f111", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.5 0-200-89.5-200-200S145.5 56 256 56s200 89.5 200 200-89.5 200-200 200z"]
};
var faCircleNotch = {
  prefix: 'far',
  iconName: 'circle-notch',
  icon: [512, 512, [], "f1ce", "M288 28.977v16.391c0 7.477 5.182 13.945 12.474 15.598C389.568 81.162 456 160.742 456 256c0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-95.244 66.422-174.837 155.526-195.034C218.818 59.313 224 52.845 224 45.368V28.981c0-10.141-9.322-17.76-19.246-15.675C91.959 37.004 7.373 137.345 8.004 257.332c.72 137.052 111.477 246.956 248.531 246.667C393.255 503.711 504 392.788 504 256c0-119.349-84.308-219.003-196.617-242.665C297.403 11.232 288 18.779 288 28.977z"]
};
var faCity = {
  prefix: 'far',
  iconName: 'city',
  icon: [640, 512, [], "f64f", "M244 384h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm0-192h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm-96 0h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm0 192h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm0-96h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm96 0h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm288 96h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm0-96h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm84-96H512V24c0-13.26-10.74-24-24-24H280c-13.26 0-24 10.74-24 24v72h-32V16c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v80h-64V16c0-8.84-7.16-16-16-16H80c-8.84 0-16 7.16-16 16v80H24c-13.26 0-24 10.74-24 24v376c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16V144h256V48h160v192h128v256c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16V216c0-13.26-10.75-24-24-24zM404 96h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm0 192h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12zm0-96h-40c-6.63 0-12 5.37-12 12v40c0 6.63 5.37 12 12 12h40c6.63 0 12-5.37 12-12v-40c0-6.63-5.37-12-12-12z"]
};
var faClawMarks = {
  prefix: 'far',
  iconName: 'claw-marks',
  icon: [512, 512, [], "f6c2", "M7.11 224.51c-4.99-2.37-9.39 4.09-5.49 8l85.11 85.13c6 6 9.37 14.14 9.37 22.63V384h43.73c8.49 0 16.62 3.37 22.62 9.37l117.13 117.16c3.86 3.86 10.31-.56 7.98-5.49C206.47 333.11 63.46 251.26 7.11 224.51zM246.69 29.63c6 6 9.37 14.14 9.37 22.63V96h43.73c8.49 0 16.62 3.37 22.62 9.37l52.25 52.26c6 6 9.37 14.14 9.37 22.63V224h43.72c8.49 0 16.62 3.37 22.62 9.37l53.14 53.16c3.86 3.86 10.31-.56 7.98-5.49C430.42 109.11 287.41 27.26 231.05.51c-4.99-2.37-9.39 4.09-5.49 8l21.13 21.12zm262.25 436.9l-1.44-3.03C453.42 347.77 321.51 134.06 45.64 3.14 31.74-3.47 15.02.89 6.06 13.53-2.97 26.3-1.51 43.59 7.8 52.74l144.28 179.7V296h62.05l65.92 65.94V424h64.42l114.97 80.47a31.741 31.741 0 0 0 20.5 7.48c6.44 0 12.87-1.92 18.46-5.86 12.69-8.93 17.13-25.56 10.54-39.56zM359.6 376h-31.56v-33.94L234 248h-33.93v-32.44L92.85 82.16C277.03 188.93 382.78 335.35 435.9 429.43L359.6 376z"]
};
var faClinicMedical = {
  prefix: 'far',
  iconName: 'clinic-medical',
  icon: [576, 512, [], "f7f2", "M256 200v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8zm314.24 15.44L323.87 13a56 56 0 0 0-71.74 0L5.76 215.42a16 16 0 0 0-2 22.54L14 250.26a16 16 0 0 0 22.53 2L64 229.71V288h-.31v208a16.13 16.13 0 0 0 16.1 16H496a16 16 0 0 0 16-16V229.71l27.5 22.59a16 16 0 0 0 22.53-2l10.26-12.3a16 16 0 0 0-2.05-22.58zM464 224h-.21v240h-352.1V194.48l.31-.25v-4L288 45.65l176 144.62z"]
};
var faClipboard = {
  prefix: 'far',
  iconName: 'clipboard',
  icon: [384, 512, [], "f328", "M336 64h-80c0-35.3-28.7-64-64-64s-64 28.7-64 64H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM192 40c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24zm144 418c0 3.3-2.7 6-6 6H54c-3.3 0-6-2.7-6-6V118c0-3.3 2.7-6 6-6h42v36c0 6.6 5.4 12 12 12h168c6.6 0 12-5.4 12-12v-36h42c3.3 0 6 2.7 6 6z"]
};
var faClipboardCheck = {
  prefix: 'far',
  iconName: 'clipboard-check',
  icon: [384, 512, [], "f46c", "M269.3 225.8c-3.9-3.9-10.2-3.9-14.1-.1l-88 87.3-38.1-38.5c-3.9-3.9-10.2-3.9-14.1-.1l-23.6 23.4c-3.9 3.9-3.9 10.2-.1 14.1l68.5 69.1c3.9 3.9 10.2 3.9 14.1.1l118.6-117.6c3.9-3.9 3.9-10.2.1-14.1l-23.3-23.6zM336 64h-80c0-35.3-28.7-64-64-64s-64 28.7-64 64H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM192 48c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm144 408c0 4.4-3.6 8-8 8H56c-4.4 0-8-3.6-8-8V120c0-4.4 3.6-8 8-8h40v32c0 8.8 7.2 16 16 16h160c8.8 0 16-7.2 16-16v-32h40c4.4 0 8 3.6 8 8v336z"]
};
var faClipboardList = {
  prefix: 'far',
  iconName: 'clipboard-list',
  icon: [384, 512, [], "f46d", "M280 240H168c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h112c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8zm0 96H168c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h112c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8zM112 232c-13.3 0-24 10.7-24 24s10.7 24 24 24 24-10.7 24-24-10.7-24-24-24zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24 24-10.7 24-24-10.7-24-24-24zM336 64h-80c0-35.3-28.7-64-64-64s-64 28.7-64 64H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM192 48c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm144 408c0 4.4-3.6 8-8 8H56c-4.4 0-8-3.6-8-8V120c0-4.4 3.6-8 8-8h40v32c0 8.8 7.2 16 16 16h160c8.8 0 16-7.2 16-16v-32h40c4.4 0 8 3.6 8 8v336z"]
};
var faClipboardListCheck = {
  prefix: 'far',
  iconName: 'clipboard-list-check',
  icon: [384, 512, [], "f737", "M126.2 286.4l64.2-63.6c2.1-2.1 2.1-5.5 0-7.6l-12.6-12.7c-2.1-2.1-5.5-2.1-7.6 0l-47.6 47.2-20.6-20.9c-2.1-2.1-5.5-2.1-7.6 0l-12.7 12.6c-2.1 2.1-2.1 5.5 0 7.6l37.1 37.4c1.9 2.1 5.3 2.1 7.4 0zM336 64h-80c0-35.3-28.7-64-64-64s-64 28.7-64 64H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM192 48c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm144 408c0 4.4-3.6 8-8 8H56c-4.4 0-8-3.6-8-8V120c0-4.4 3.6-8 8-8h40v32c0 8.8 7.2 16 16 16h160c8.8 0 16-7.2 16-16v-32h40c4.4 0 8 3.6 8 8v336zM112 328c-13.3 0-24 10.7-24 24s10.7 24 24 24 24-10.7 24-24-10.7-24-24-24zm168-88h-63.3c-1.3 1.8-2.1 3.9-3.7 5.5L186.2 272H280c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8zm0 96H168c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h112c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8z"]
};
var faClipboardPrescription = {
  prefix: 'far',
  iconName: 'clipboard-prescription',
  icon: [384, 512, [], "f5e8", "M336 64h-80c0-35.35-28.65-64-64-64s-64 28.65-64 64H48C21.49 64 0 85.49 0 112v352c0 26.51 21.49 48 48 48h288c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zM192 48c8.82 0 16 7.18 16 16s-7.18 16-16 16-16-7.18-16-16 7.18-16 16-16zm144 408c0 4.42-3.58 8-8 8H56c-4.42 0-8-3.58-8-8V120c0-4.42 3.58-8 8-8h40v32c0 8.84 7.16 16 16 16h160c8.84 0 16-7.16 16-16v-32h40c4.42 0 8 3.58 8 8v336zm-50.34-127.03c3.12-3.12 3.12-8.19 0-11.31l-11.31-11.31c-3.12-3.12-8.19-3.12-11.31 0l-36.69 36.69c-.91.91-.99 2.16-1.37 3.31l-32.3-32.3C211.17 304.9 224 286.03 224 264c0-30.93-25.07-56-56-56h-64c-4.42 0-8 3.58-8 8v144c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-40h25.37l48.97 48.97c-1.15.38-2.4.46-3.31 1.37l-36.69 36.69c-3.12 3.12-3.12 8.19 0 11.31l11.31 11.31c3.12 3.12 8.19 3.12 11.31 0l36.69-36.69c.92-.92.99-2.16 1.37-3.31l40 40c3.12 3.12 8.19 3.12 11.31 0l11.31-11.31c3.12-3.12 3.12-8.19 0-11.31l-40-40c1.15-.38 2.4-.46 3.31-1.37l36.71-36.69zM168 288h-40v-48h40c13.23 0 24 10.77 24 24s-10.77 24-24 24z"]
};
var faClipboardUser = {
  prefix: 'far',
  iconName: 'clipboard-user',
  icon: [384, 512, [], "f7f3", "M336 64h-80a64 64 0 0 0-128 0H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zM192 40a24 24 0 1 1-24 24 24 24 0 0 1 24-24zm144 418a6 6 0 0 1-6 6H54a6 6 0 0 1-6-6V118a6 6 0 0 1 6-6h42v36a12 12 0 0 0 12 12h168a12 12 0 0 0 12-12v-36h42a6 6 0 0 1 6 6zm-99.2-106h-5a103.25 103.25 0 0 1-79.7 0h-5c-37.01 0-67.1 25.79-67.1 57.6v6.4a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-6.4c0-31.81-30.09-57.6-67.2-57.6zM192 336a64 64 0 1 0-64-64 64 64 0 0 0 64 64z"]
};
var faClock = {
  prefix: 'far',
  iconName: 'clock',
  icon: [512, 512, [], "f017", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.5 0-200-89.5-200-200S145.5 56 256 56s200 89.5 200 200-89.5 200-200 200zm61.8-104.4l-84.9-61.7c-3.1-2.3-4.9-5.9-4.9-9.7V116c0-6.6 5.4-12 12-12h32c6.6 0 12 5.4 12 12v141.7l66.8 48.6c5.4 3.9 6.5 11.4 2.6 16.8L334.6 349c-3.9 5.3-11.4 6.5-16.8 2.6z"]
};
var faClone = {
  prefix: 'far',
  iconName: 'clone',
  icon: [512, 512, [], "f24d", "M464 0H144c-26.51 0-48 21.49-48 48v48H48c-26.51 0-48 21.49-48 48v320c0 26.51 21.49 48 48 48h320c26.51 0 48-21.49 48-48v-48h48c26.51 0 48-21.49 48-48V48c0-26.51-21.49-48-48-48zM362 464H54a6 6 0 0 1-6-6V150a6 6 0 0 1 6-6h42v224c0 26.51 21.49 48 48 48h224v42a6 6 0 0 1-6 6zm96-96H150a6 6 0 0 1-6-6V54a6 6 0 0 1 6-6h308a6 6 0 0 1 6 6v308a6 6 0 0 1-6 6z"]
};
var faClosedCaptioning = {
  prefix: 'far',
  iconName: 'closed-captioning',
  icon: [512, 512, [], "f20a", "M464 64H48C21.5 64 0 85.5 0 112v288c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zm-6 336H54c-3.3 0-6-2.7-6-6V118c0-3.3 2.7-6 6-6h404c3.3 0 6 2.7 6 6v276c0 3.3-2.7 6-6 6zm-211.1-85.7c1.7 2.4 1.5 5.6-.5 7.7-53.6 56.8-172.8 32.1-172.8-67.9 0-97.3 121.7-119.5 172.5-70.1 2.1 2 2.5 3.2 1 5.7l-17.5 30.5c-1.9 3.1-6.2 4-9.1 1.7-40.8-32-94.6-14.9-94.6 31.2 0 48 51 70.5 92.2 32.6 2.8-2.5 7.1-2.1 9.2.9l19.6 27.7zm190.4 0c1.7 2.4 1.5 5.6-.5 7.7-53.6 56.9-172.8 32.1-172.8-67.9 0-97.3 121.7-119.5 172.5-70.1 2.1 2 2.5 3.2 1 5.7L420 220.2c-1.9 3.1-6.2 4-9.1 1.7-40.8-32-94.6-14.9-94.6 31.2 0 48 51 70.5 92.2 32.6 2.8-2.5 7.1-2.1 9.2.9l19.6 27.7z"]
};
var faCloud = {
  prefix: 'far',
  iconName: 'cloud',
  icon: [640, 512, [], "f0c2", "M543.7 200.1C539.7 142.1 491.4 96 432 96c-7.6 0-15.1.8-22.4 2.3C377.7 58.3 328.1 32 272 32c-84.6 0-155.5 59.7-172.3 139.8C39.9 196.1 0 254.4 0 320c0 88.4 71.6 160 160 160h336c79.5 0 144-64.5 144-144 0-61.8-39.2-115.8-96.3-135.9zM496 432H160c-61.9 0-112-50.1-112-112 0-56.4 41.7-103.1 96-110.9V208c0-70.7 57.3-128 128-128 53.5 0 99.3 32.8 118.4 79.4 11.2-9.6 25.7-15.4 41.6-15.4 35.3 0 64 28.7 64 64 0 11.8-3.2 22.9-8.8 32.4 2.9-.3 5.9-.4 8.8-.4 53 0 96 43 96 96s-43 96-96 96z"]
};
var faCloudDownload = {
  prefix: 'far',
  iconName: 'cloud-download',
  icon: [640, 512, [], "f0ed", "M543.7 200.1C539.7 142.1 491.4 96 432 96c-7.6 0-15.1.8-22.4 2.3C377.7 58.3 328.1 32 272 32c-84.6 0-155.5 59.7-172.3 139.8C39.9 196.1 0 254.4 0 320c0 88.4 71.6 160 160 160h336c79.5 0 144-64.5 144-144 0-61.8-39.2-115.8-96.3-135.9zM496 432H160c-61.9 0-112-50.1-112-112 0-56.4 41.7-103.1 96-110.9V208c0-70.7 57.3-128 128-128 53.5 0 99.3 32.8 118.4 79.4 11.2-9.6 25.7-15.4 41.6-15.4 35.3 0 64 28.7 64 64 0 11.8-3.2 22.9-8.8 32.4 2.9-.3 5.9-.4 8.8-.4 53 0 96 43 96 96s-43 96-96 96zM383.6 255.6c-4.7-4.7-12.4-4.7-17.1.1L312 311.5V172c0-6.6-5.4-12-12-12h-24c-6.6 0-12 5.4-12 12v139.5l-54.5-55.8c-4.7-4.8-12.3-4.8-17.1-.1l-16.9 16.9c-4.7 4.7-4.7 12.3 0 17l104 104c4.7 4.7 12.3 4.7 17 0l104-104c4.7-4.7 4.7-12.3 0-17l-16.9-16.9z"]
};
var faCloudDownloadAlt = {
  prefix: 'far',
  iconName: 'cloud-download-alt',
  icon: [640, 512, [], "f381", "M543.7 200.1C539.7 142.1 491.4 96 432 96c-7.6 0-15.1.8-22.4 2.3C377.7 58.3 328.1 32 272 32c-84.6 0-155.5 59.7-172.3 139.8C39.9 196.1 0 254.4 0 320c0 88.4 71.6 160 160 160h336c79.5 0 144-64.5 144-144 0-61.8-39.2-115.8-96.3-135.9zM496 432H160c-61.9 0-112-50.1-112-112 0-56.4 41.7-103.1 96-110.9V208c0-70.7 57.3-128 128-128 53.5 0 99.3 32.8 118.4 79.4 11.2-9.6 25.7-15.4 41.6-15.4 35.3 0 64 28.7 64 64 0 11.8-3.2 22.9-8.8 32.4 2.9-.3 5.9-.4 8.8-.4 53 0 96 43 96 96s-43 96-96 96zM387 256h-67v-84c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v84h-67c-10.7 0-16 12.9-8.5 20.5l99 99c4.7 4.7 12.3 4.7 17 0l99-99c7.6-7.6 2.2-20.5-8.5-20.5z"]
};
var faCloudDrizzle = {
  prefix: 'far',
  iconName: 'cloud-drizzle',
  icon: [512, 512, [], "f738", "M48 360c-8.8 0-16 7.2-16 16v40c0 8.8 7.2 16 16 16s16-7.2 16-16v-40c0-8.8-7.2-16-16-16zm96 80c-8.8 0-16 7.2-16 16v40c0 8.8 7.2 16 16 16s16-7.2 16-16v-40c0-8.8-7.2-16-16-16zm96-80c-8.8 0-16 7.2-16 16v40c0 8.8 7.2 16 16 16s16-7.2 16-16v-40c0-8.8-7.2-16-16-16zm96 80c-8.8 0-16 7.2-16 16v40c0 8.8 7.2 16 16 16s16-7.2 16-16v-40c0-8.8-7.2-16-16-16zm96-80c-8.8 0-16 7.2-16 16v40c0 8.8 7.2 16 16 16s16-7.2 16-16v-40c0-8.8-7.2-16-16-16zm-21.3-255.8C397.2 61.8 358 32 312 32c-13.5 0-26.8 2.6-39.2 7.7C250.3 14.5 218.4 0 184 0 120 0 67.6 50.3 64.2 113.4 25.6 130.4 0 168.5 0 212c0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108 0-57.3-44.9-104.3-101.3-107.8zM404 272H108c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C289.4 83.6 300.5 80 312 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60z"]
};
var faCloudHail = {
  prefix: 'far',
  iconName: 'cloud-hail',
  icon: [512, 512, [], "f739", "M384 352c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-192 96c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm128 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-64-96c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM64 448c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm64-96c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm282.7-247.8C397.2 61.8 358 32 312 32c-13.5 0-26.8 2.6-39.2 7.7C250.3 14.5 218.4 0 184 0 120 0 67.6 50.3 64.2 113.4 25.6 130.4 0 168.5 0 212c0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108 0-57.3-44.9-104.3-101.3-107.8zM404 272H108c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C289.4 83.6 300.5 80 312 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60z"]
};
var faCloudHailMixed = {
  prefix: 'far',
  iconName: 'cloud-hail-mixed',
  icon: [512, 512, [], "f73a", "M410.7 104.2C397.2 61.8 358 32 312 32c-13.5 0-26.8 2.6-39.2 7.7C250.3 14.5 218.4 0 184 0 120 0 67.6 50.3 64.2 113.4 25.6 130.4 0 168.5 0 212c0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108 0-57.3-44.9-104.3-101.3-107.8zM404 272H108c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C289.4 83.6 300.5 80 312 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60zM87.2 369.7c-7.9-3.9-17.5-.8-21.5 7.2l-16 32c-3.9 7.9-.8 17.5 7.2 21.5 2.3 1.1 4.8 1.7 7.2 1.7 5.8 0 11.5-3.2 14.3-8.8l16-32c3.8-8.1.7-17.7-7.2-21.6zm384 0c-7.9-3.9-17.5-.8-21.5 7.2l-16 32c-3.9 7.9-.8 17.5 7.2 21.5 2.3 1.1 4.8 1.7 7.2 1.7 5.8 0 11.5-3.2 14.3-8.8l16-32c3.8-8.1.7-17.7-7.2-21.6zm-95.3.4c-7.6-4.4-17.4-1.8-21.8 6l-64 112c-4.4 7.7-1.7 17.5 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l64-112c4.4-7.6 1.7-17.4-6-21.8zm-96.7-.4c-7.9-3.9-17.5-.8-21.5 7.2l-16 32c-3.9 7.9-.8 17.5 7.2 21.5 2.3 1.1 4.8 1.7 7.2 1.7 5.8 0 11.5-3.2 14.3-8.8l16-32c3.8-8.1.7-17.7-7.2-21.6zm-95.3.4c-7.6-4.4-17.4-1.8-21.8 6l-64 112c-4.4 7.7-1.7 17.5 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l64-112c4.4-7.6 1.7-17.4-6-21.8zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32z"]
};
var faCloudMeatball = {
  prefix: 'far',
  iconName: 'cloud-meatball',
  icon: [576, 512, [], "f73b", "M384.5 375.6l-16.7-8.7 5.7-18c6.1-19.2-7.5-35.9-25.3-35.9-6 0-8.5 1.2-27.1 7.1l-8.7-16.7c-10.8-20.7-38.1-20.6-48.8 0l-8.7 16.7c-17.7-5.6-20.8-7.1-27.1-7.1-17.8 0-31.4 16.7-25.3 35.9l5.7 18-16.7 8.7c-20.5 10.7-20.8 38 0 48.8l16.7 8.7-5.7 18c-6.3 19.9 8.6 36.4 26.1 36.4 3.7 0 12.5-3.2 26.3-7.6l8.7 16.7c10.8 20.7 38.1 20.6 48.8 0l8.7-16.7c13.9 4.4 22.6 7.6 26.3 7.6 17.6 0 32.4-16.4 26.1-36.4l-5.7-18 16.7-8.7c20.7-10.8 20.6-38.1 0-48.8zM576 256c0-59.2-41.5-110.1-97.6-123.8C468.9 75.4 419.4 32 360 32c-12.8 0-25.6 2.2-38 6.5C293.6 13.5 258 0 220 0 137.7 0 70.1 64.1 64.4 145 24.8 167.6 0 209.6 0 256c0 70.6 57.4 128 128 128h18.5c3.8-13.1 12-24.8 23.7-32.8-1-5.1-1.1-10.2-.8-15.2H128c-44.1 0-80-35.9-80-80 0-32.5 19.4-61.5 49.6-73.9l15.6-6.4-.8-16.9c-.1-1.4-.2-2.8-.4-2.8 0-59.5 48.4-108 108-108 30.1 0 58.2 12.4 79.1 35l12.3 13.3 16.2-8.2c49-24.9 103.5 12.6 104.4 62.5l-2.8 24.1 24.9 1.9c41.5 3.2 73.9 38 73.9 79.3 0 44.1-35.9 80-80 80h-41.4c.3 5 .2 10.1-.7 15.2 11.7 8 19.9 19.7 23.7 32.8H448c70.6.1 128-57.3 128-127.9zM64 416c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm448 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32z"]
};
var faCloudMoon = {
  prefix: 'far',
  iconName: 'cloud-moon',
  icon: [640, 512, [], "f6c3", "M390.8 296.4C383.3 246.4 340 208 288 208c-5.1 0-10.2.4-15.2 1.1C248.5 188 217.2 176 184 176c-64 0-118.3 45.2-132.4 105.3C19.6 305.1 0 343 0 384c0 70.6 57.4 128 128 128h204c64 0 116-52 116-116 0-41.8-22.8-79.3-57.2-99.6zM332 464H128c-44.2 0-80-35.8-80-80 0-32.8 19.8-61 48.1-73.3.7-48 39.7-86.7 87.9-86.7 31.2 0 58.4 16.3 74.1 40.8 8.7-5.5 18.9-8.8 29.9-8.8 30.9 0 56 25.1 56 56 0 5.9-1.2 11.5-2.9 16.9 33.2 4.5 58.9 32.6 58.9 67.1 0 37.6-30.5 68-68 68zm305.6-176.8c-4.1-8.6-12.4-13.9-21.8-13.9-1.5 0-3 .1-4.6.4-7.7 1.5-15.5 2.2-23.2 2.2-67 0-121.5-54.7-121.5-121.9 0-43.7 23.6-84.3 61.6-106 8.9-5.1 13.6-15 11.9-25.1-1.7-10.2-9.4-17.9-19.5-19.8-11.5-2-23.2-3.1-35-3.1-100.5 0-183.1 77.9-191 176.6 16.8.8 32.8 4.8 47.6 11.3 1.9-66.3 48.5-121.6 110.8-136.1-21.9 29.1-34.4 64.9-34.4 102.4 0 81.1 57 149.1 132.9 165.9-20.1 10.4-42.6 16-65.9 16-6.7 0-13.1-1.1-19.6-2 7.3 15.5 11.8 32.3 13.3 49.7 2.1.1 4.2.3 6.3.3 58.1 0 112.4-25.9 149-71.1 6-7.4 7.2-17.3 3.1-25.8z"]
};
var faCloudMoonRain = {
  prefix: 'far',
  iconName: 'cloud-moon-rain',
  icon: [640, 512, [], "f73c", "M268.5 418.1c-7.6-4.3-17.4-1.8-21.8 6l-36.6 64c-4.4 7.7-1.7 17.4 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l36.6-64c4.3-7.7 1.7-17.4-6-21.8zm-96 0c-7.6-4.3-17.4-1.8-21.8 6l-36.6 64c-4.4 7.7-1.7 17.4 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l36.6-64c4.3-7.7 1.7-17.4-6-21.8zm-96 0c-7.6-4.3-17.4-1.8-21.8 6l-36.6 64c-4.4 7.7-1.7 17.4 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l36.6-64c4.3-7.7 1.7-17.4-6-21.8zm288 0c-7.6-4.3-17.4-1.8-21.8 6l-36.6 64c-4.4 7.7-1.7 17.4 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l36.6-64c4.3-7.7 1.7-17.4-6-21.8zm-1.1-234.7c-12-36.8-46.7-63.4-87.4-63.4-3.1 0-6.1.2-9.1.5C245.3 104.7 219.2 96 192 96c-52.4 0-97.6 31.3-117.2 77.2C31.4 187.3 0 228 0 276c0 59.6 48.4 108 108 108h200c59.6 0 108-48.4 108-108 0-38.8-20.8-73.6-52.6-92.6zM308 336H108c-33.1 0-60-26.9-60-60s26.9-60 60-60c1.6 0 3.2.4 4.8.5 3.8-40.6 37.6-72.5 79.2-72.5 25.2 0 47.4 11.9 62.1 30.1 6.5-3.8 13.9-6.1 21.9-6.1 24.3 0 44 19.7 44 44 0 1.8-.3 3.4-.5 5.2 27.6 5.4 48.5 29.6 48.5 58.8 0 33.1-26.9 60-60 60zm329.8-99.3c-3.8-7.9-11.8-13-20.5-13h-1.5l-2.8.4c-6.1 1.2-12.3 1.8-18.4 1.8-53.2 0-96.5-43.4-96.5-96.8 0-34.7 18.8-67 49-84.2 8.4-4.8 12.8-14 11.2-23.6-1.6-9.5-8.8-16.8-18.3-18.6C530.3.9 520.5 0 510.7 0c-73.6 0-135.1 50.3-153.6 118.2 13.8 11.9 25 26.8 32.6 44.1.6.4 1 .9 1.6 1.3 0-1.2-.4-2.4-.4-3.6 0-58.9 42.6-108 98.6-118.1-19.9 24.2-31.3 54.9-31.3 87.1 0 67.4 48.8 123.5 112.9 134.8-18 10.5-38.7 16.2-60.2 16.2-23.4 0-45.1-7-63.6-18.7.5 4.9.9 9.8.9 14.7 0 10.1-1.3 19.8-3.3 29.3 20.2 9.2 42.4 14.7 66.1 14.7 48.4 0 93.6-21.6 124.2-59.2 5.3-6.9 6.4-16.1 2.6-24.1z"]
};
var faCloudRain = {
  prefix: 'far',
  iconName: 'cloud-rain',
  icon: [512, 512, [], "f73d", "M88 374.2c-12.8 44.4-40 56.4-40 87.7 0 27.7 21.5 50.1 48 50.1s48-22.4 48-50.1c0-31.4-27.2-43.1-40-87.7-2.2-8.1-13.5-8.5-16 0zm160 0c-12.8 44.4-40 56.4-40 87.7 0 27.7 21.5 50.1 48 50.1s48-22.4 48-50.1c0-31.4-27.2-43.1-40-87.7-2.2-8.1-13.5-8.5-16 0zm160 0c-12.8 44.4-40 56.4-40 87.7 0 27.7 21.5 50.1 48 50.1s48-22.4 48-50.1c0-31.4-27.2-43.1-40-87.7-2.2-8.1-13.5-8.5-16 0zm2.7-270C397.2 61.8 358 32 312 32c-13.5 0-26.8 2.6-39.2 7.7C250.3 14.5 218.4 0 184 0 120 0 67.6 50.3 64.2 113.4 25.6 130.4 0 168.5 0 212c0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108 0-57.3-44.9-104.3-101.3-107.8zM404 272H108c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C289.4 83.6 300.5 80 312 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60z"]
};
var faCloudRainbow = {
  prefix: 'far',
  iconName: 'cloud-rainbow',
  icon: [576, 512, [], "f73e", "M560.6 48c8.6-.4 15.4-7.1 15.4-15.7V16.2c0-9-7.6-16.6-16.6-16.2-140.2 6-260.9 87.3-323.5 204.2C220 196.4 202.4 192 184 192c-64 0-116.4 50.3-119.8 113.4C25.6 322.4 0 360.5 0 404c0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108 0-38.5-20.4-71.9-50.8-91.1 23.7-30.7 59.1-52 99.7-56.2 8.4-.9 15.1-7.4 15.1-15.9v-16.1c0-9.2-7.7-16.9-16.8-16.1-61 5.3-113.8 39.2-145.5 87.9-1-.1-1.9-.4-3-.5-5.6-17.8-16-33.1-29.3-45.2 41.2-56 105.7-93.9 179.3-98.5 8.5-.5 15.3-7.2 15.3-15.8v-16c0-9.1-7.6-16.7-16.7-16.2-91.1 5.2-170.7 53-220.1 123.4-8.7-2.4-17.8-3.9-27.2-3.9-12 0-23.8 2.4-35 6.5C331.2 126.5 436.9 53.6 560.6 48zM312 272c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60H108c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9c9.6-6.7 20.7-10.3 32.2-10.3z"]
};
var faCloudShowers = {
  prefix: 'far',
  iconName: 'cloud-showers',
  icon: [512, 512, [], "f73f", "M48 368c-8.8 0-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16v-80c0-8.8-7.2-16-16-16zm96 32c-8.8 0-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16v-80c0-8.8-7.2-16-16-16zm96-32c-8.8 0-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16v-80c0-8.8-7.2-16-16-16zm96 32c-8.8 0-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16v-80c0-8.8-7.2-16-16-16zm96-32c-8.8 0-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16v-80c0-8.8-7.2-16-16-16zm-21.3-263.8C397.2 61.8 358 32 312 32c-13.5 0-26.8 2.6-39.2 7.7C250.3 14.5 218.4 0 184 0 120 0 67.6 50.3 64.2 113.4 25.6 130.4 0 168.5 0 212c0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108 0-57.3-44.9-104.3-101.3-107.8zM404 272H108c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C289.4 83.6 300.5 80 312 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60z"]
};
var faCloudShowersHeavy = {
  prefix: 'far',
  iconName: 'cloud-showers-heavy',
  icon: [512, 512, [], "f740", "M87.9 370.1c-7.6-4.4-17.4-1.8-21.8 6l-64 112c-4.4 7.7-1.7 17.5 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l64-112c4.4-7.6 1.7-17.4-6-21.8zm384 0c-7.6-4.4-17.4-1.8-21.8 6l-64 112c-4.4 7.7-1.7 17.5 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l64-112c4.4-7.6 1.7-17.4-6-21.8zm-96 0c-7.6-4.4-17.4-1.8-21.8 6l-64 112c-4.4 7.7-1.7 17.5 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l64-112c4.4-7.6 1.7-17.4-6-21.8zm-96 0c-7.6-4.4-17.4-1.8-21.8 6l-64 112c-4.4 7.7-1.7 17.5 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l64-112c4.4-7.6 1.7-17.4-6-21.8zm-96 0c-7.6-4.4-17.4-1.8-21.8 6l-64 112c-4.4 7.7-1.7 17.5 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l64-112c4.4-7.6 1.7-17.4-6-21.8zm226.8-265.9C397.2 61.8 358 32 312 32c-13.5 0-26.8 2.6-39.2 7.7C250.3 14.5 218.4 0 184 0 120 0 67.6 50.3 64.2 113.4 25.6 130.4 0 168.5 0 212c0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108 0-57.3-44.9-104.3-101.3-107.8zM404 272H108c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3l20.7-4.8-2.7-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C289.4 83.6 300.5 80 312 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60z"]
};
var faCloudSleet = {
  prefix: 'far',
  iconName: 'cloud-sleet',
  icon: [512, 512, [], "f741", "M87.2 353.7c-7.9-3.9-17.5-.7-21.5 7.2l-64 128c-3.9 7.9-.8 17.5 7.2 21.5 2.3 1.1 4.8 1.7 7.2 1.7 5.8 0 11.5-3.2 14.3-8.8l64-128c3.8-8.1.7-17.7-7.2-21.6zm256 0c-7.9-3.9-17.5-.7-21.5 7.2l-64 128c-3.9 7.9-.8 17.5 7.2 21.5 2.3 1.1 4.8 1.7 7.2 1.7 5.8 0 11.5-3.2 14.3-8.8l64-128c3.8-8.1.7-17.7-7.2-21.6zm151.7 35.4l-8-13.9c-2.2-3.8-7.1-5.1-10.9-2.9l-28 16.1V360c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v28.4l-28-16.1c-3.8-2.2-8.7-.9-10.9 2.9l-8 13.9c-2.2 3.8-.9 8.7 2.9 10.9l27.9 16-27.9 16c-3.8 2.2-5.1 7.1-2.9 10.9l8 13.9c2.2 3.8 7.1 5.1 10.9 2.9l28-16.1V472c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-28.4l28 16.1c3.8 2.2 8.7.9 10.9-2.9l8-13.9c2.2-3.8.9-8.7-2.9-10.9l-27.9-16 27.9-16c3.8-2.2 5.1-7.1 2.9-10.9zm-256 0l-8-13.9c-2.2-3.8-7.1-5.1-10.9-2.9l-28 16.1V360c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v28.4l-28-16.1c-3.8-2.2-8.7-.9-10.9 2.9l-8 13.9c-2.2 3.8-.9 8.7 2.9 10.9l27.9 16-27.9 16c-3.8 2.2-5.1 7.1-2.9 10.9l8 13.9c2.2 3.8 7.1 5.1 10.9 2.9l28-16.1V472c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-28.4l28 16.1c3.8 2.2 8.7.9 10.9-2.9l8-13.9c2.2-3.8.9-8.7-2.9-10.9l-27.9-16 27.9-16c3.8-2.2 5.1-7.1 2.9-10.9zM512 212c0-57.3-44.9-104.3-101.3-107.8C397.2 61.8 358 32 312 32c-13.5 0-26.8 2.6-39.2 7.7C250.3 14.5 218.4 0 184 0 120 0 67.6 50.3 64.2 113.4 25.6 130.4 0 168.5 0 212c0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108zm-464 0c0-28 19.1-52 46.4-58.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C289.4 83.6 300.5 80 312 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60H108c-33.1 0-60-26.9-60-60z"]
};
var faCloudSnow = {
  prefix: 'far',
  iconName: 'cloud-snow',
  icon: [512, 512, [], "f742", "M510.9 389.1l-8-13.9c-2.2-3.8-7.1-5.1-10.9-2.9l-28 16.1V360c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v28.4l-28-16.1c-3.8-2.2-8.7-.9-10.9 2.9l-8 13.9c-2.2 3.8-.9 8.7 2.9 10.9l27.9 16-27.9 16c-3.8 2.2-5.1 7.1-2.9 10.9l8 13.9c2.2 3.8 7.1 5.1 10.9 2.9l28-16.1V472c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-28.4l28 16.1c3.8 2.2 8.7.9 10.9-2.9l8-13.9c2.2-3.8.9-8.7-2.9-10.9l-27.9-16 27.9-16c3.8-2.2 5.1-7.1 2.9-10.9zm-384 0l-8-13.9c-2.2-3.8-7.1-5.1-10.9-2.9l-28 16.1V360c0-4.4-3.6-8-8-8H56c-4.4 0-8 3.6-8 8v28.4l-28-16.1c-3.8-2.2-8.7-.9-10.9 2.9l-8 13.9c-2.2 3.8-.9 8.7 2.9 10.9l27.9 16L4 432c-3.8 2.2-5.1 7.1-2.9 10.9l8 13.9c2.2 3.8 7.1 5.1 10.9 2.9l28-16.1V472c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-28.4l28 16.1c3.8 2.2 8.7.9 10.9-2.9l8-13.9c2.2-3.8.9-8.7-2.9-10.9l-27.9-16 27.9-16c3.8-2.2 5.1-7.1 2.9-10.9zm192 32l-8-13.9c-2.2-3.8-7.1-5.1-10.9-2.9l-28 16.1V392c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v28.4l-28-16.1c-3.8-2.2-8.7-.9-10.9 2.9l-8 13.9c-2.2 3.8-.9 8.7 2.9 10.9l27.9 16-27.9 16c-3.8 2.2-5.1 7.1-2.9 10.9l8 13.9c2.2 3.8 7.1 5.1 10.9 2.9l28-16.1V504c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-28.4l28 16.1c3.8 2.2 8.7.9 10.9-2.9l8-13.9c2.2-3.8.9-8.7-2.9-10.9l-27.9-16 27.9-16c3.8-2.2 5.1-7.1 2.9-10.9zM108 320h296c59.6 0 108-48.5 108-108 0-57.3-44.9-104.3-101.3-107.8C397.2 61.8 358 32 312 32c-13.5 0-26.8 2.6-39.2 7.7C250.3 14.5 218.4 0 184 0 120 0 67.6 50.3 64.2 113.4 25.6 130.4 0 168.5 0 212c0 59.5 48.4 108 108 108zM94.4 153.7l20.7-4.8-2.7-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C289.4 83.6 300.5 80 312 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H404c33.1 0 60 26.9 60 60s-26.9 60-60 60H108c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3z"]
};
var faCloudSun = {
  prefix: 'far',
  iconName: 'cloud-sun',
  icon: [640, 512, [], "f6c4", "M582.8 296.4C575.3 246.4 532 208 480 208c-5.1 0-10.2.4-15.2 1.1C440.5 188 409.2 176 376 176c-64 0-118.3 45.2-132.4 105.3C211.6 305.1 192 343 192 384c0 70.6 57.4 128 128 128h204c64 0 116-52 116-116 0-41.8-22.8-79.3-57.2-99.6zM524 464H320c-44.2 0-80-35.8-80-80 0-32.8 19.8-61 48.1-73.3.7-48 39.7-86.7 87.9-86.7 31.2 0 58.4 16.3 74.1 40.8 8.7-5.5 18.9-8.8 29.9-8.8 30.9 0 56 25.1 56 56 0 5.9-1.2 11.5-2.9 16.9 33.2 4.5 58.9 32.6 58.9 67.1 0 37.6-30.4 68-68 68zM106.5 341.3l8.5-43.9 6-31.1-26.2-17.8-37-25.1 37-25.1 26.2-17.8-6-31.1-8.5-43.9 43.7 8.5 31.2 6 17.8-26.3L224 57v1l24.9 36.9 17.8 26.3 31.2-6 43.6-8.5-8.4 43.6c13.9-3.8 28.2-6.3 42.9-6.3 2.4 0 4.7.5 7 .6l9.1-47c2.2-11.6-1.4-23.5-9.7-31.8-6.7-6.7-15.6-10.4-25-10.4-2.2 0-4.5.2-6.8.6l-62 12-35.4-52.4C246.7 5.8 235.8 0 224 0c-11.4 0-22.7 4.9-29.3 14.7l-35.4 52.4-62-12c-2.3-.4-4.5-.7-6.8-.7-9.3 0-18.3 3.7-25 10.4-8.3 8.4-11.9 20.2-9.7 31.8l12 62.1-52.3 35.5C5.8 200.8 0 211.8 0 223.5c0 11.8 5.8 22.7 15.6 29.3l52.3 35.4-12 62.1c-2.2 11.6 1.4 23.5 9.7 31.8 6.7 6.7 15.6 10.4 25 10.4 2.2 0 4.5-.2 6.8-.6l62-12 .8 1.3c.3-18 3.8-35.6 9.9-52.2l-19.8 3.8-43.8 8.5zm109.2-79c-18-3.9-31.7-19.2-31.7-38.3 0-22.1 17.9-40 40-40 12 0 22.4 5.5 29.7 13.9 11-11.8 23.7-21.7 37.5-29.9-16.1-19.4-40.1-32-67.2-32-48.5 0-88 39.5-88 88 0 33.7 19.2 62.7 47.1 77.5 8.7-14.4 19.5-27.4 32.4-38.5.1-.3.2-.5.2-.7z"]
};
var faCloudSunRain = {
  prefix: 'far',
  iconName: 'cloud-sun-rain',
  icon: [640, 512, [], "f743", "M588.5 418.1c-7.6-4.3-17.4-1.8-21.8 6l-36.6 64c-4.4 7.7-1.7 17.4 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l36.6-64c4.3-7.7 1.7-17.4-6-21.8zm-96 0c-7.6-4.3-17.4-1.8-21.8 6l-36.6 64c-4.4 7.7-1.7 17.4 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l36.6-64c4.3-7.7 1.7-17.4-6-21.8zm-96 0c-7.6-4.3-17.4-1.8-21.8 6l-36.6 64c-4.4 7.7-1.7 17.4 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l36.6-64c4.3-7.7 1.7-17.4-6-21.8zm-96 0c-7.6-4.3-17.4-1.8-21.8 6l-36.6 64c-4.4 7.7-1.7 17.4 6 21.8 2.5 1.4 5.2 2.1 7.9 2.1 5.5 0 10.9-2.9 13.9-8.1l36.6-64c4.3-7.7 1.7-17.4-6-21.8zm286.9-234.7c-12-36.8-46.7-63.4-87.4-63.4-3.1 0-6.1.2-9.1.5C469.3 104.7 443.2 96 416 96c-52.4 0-97.6 31.3-117.2 77.2C255.4 187.3 224 228 224 276c0 59.6 48.4 108 108 108h200c59.6 0 108-48.4 108-108 0-38.8-20.8-73.6-52.6-92.6zM532 336H332c-33.1 0-60-26.9-60-60s26.9-60 60-60c1.6 0 3.2.4 4.8.5 3.8-40.6 37.6-72.5 79.2-72.5 25.2 0 47.4 11.9 62.1 30.1 6.5-3.8 13.9-6.1 21.9-6.1 24.3 0 44 19.7 44 44 0 1.8-.3 3.4-.5 5.2 27.6 5.4 48.5 29.6 48.5 58.8 0 33.1-26.9 60-60 60zm-339.1-72.3l-5.9 8.7-10.8 16-11.2-16.7-17.8-26.3-31.2 6-19.4 3.8 3.8-19.6 6-31.1-26.2-17.8-16.5-11.2 16.5-11.2 26.2-17.8-6-31.1-3.8-19.5 19.4 3.8 31.2 6L165 79.5l10.8-16L187 80.3l17.8 26.3 31.2-6 19.4-3.7-3.8 19.6-6 31.1 13.5 9.2c5.3-3.2 10.7-6.2 16.4-8.7 7-13 15.7-24.8 25.7-35.2l7-36.1c1.8-9.1-1.1-18.4-7.6-25-5.2-5.3-12.3-8.2-19.6-8.2-1.8 0-3.6.2-5.3.5L227 53.5l-28-41.3C193.9 4.6 185.2 0 176 0c-8.9 0-17.9 3.8-23 11.5l-27.8 41.2-48.7-9.4c-1.8-.3-3.6-.5-5.3-.5-7.3 0-14.3 2.9-19.6 8.2-6.5 6.6-9.4 15.9-7.6 25l9.4 48.8-41.1 27.9C4.6 157.8 0 166.4 0 175.6s4.6 17.9 12.2 23.1l41.1 27.8-9.4 48.8c-1.8 9.1 1.1 18.4 7.6 25 5.2 5.3 12.3 8.2 19.6 8.2 1.8 0 3.6-.2 5.3-.5l48.7-9.4 27.8 41.2c5.2 7.7 13.8 12.3 23 12.3 8.9 0 17.9-3.8 23-11.5l5.2-7.8c-7.8-17.4-12.3-36.5-12.3-56.7.2-4.3.7-8.3 1.1-12.4zM176 136c-22.1 0-40 17.9-40 40s17.9 40 40 40 40-17.9 40-40-17.9-40-40-40z"]
};
var faCloudUpload = {
  prefix: 'far',
  iconName: 'cloud-upload',
  icon: [640, 512, [], "f0ee", "M543.7 200.1C539.7 142.1 491.4 96 432 96c-7.6 0-15.1.8-22.4 2.3C377.7 58.3 328.1 32 272 32c-84.6 0-155.5 59.7-172.3 139.8C39.9 196.1 0 254.4 0 320c0 88.4 71.6 160 160 160h336c79.5 0 144-64.5 144-144 0-61.8-39.2-115.8-96.3-135.9zM496 432H160c-61.9 0-112-50.1-112-112 0-56.4 41.7-103.1 96-110.9V208c0-70.7 57.3-128 128-128 53.5 0 99.3 32.8 118.4 79.4 11.2-9.6 25.7-15.4 41.6-15.4 35.3 0 64 28.7 64 64 0 11.8-3.2 22.9-8.8 32.4 2.9-.3 5.9-.4 8.8-.4 53 0 96 43 96 96s-43 96-96 96zM296.5 150.5c-4.7-4.7-12.3-4.7-17 0l-104 104c-4.7 4.7-4.7 12.3 0 17l16.9 16.9c4.7 4.7 12.4 4.7 17.1-.1l54.5-55.8V372c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12V232.5l54.5 55.8c4.7 4.8 12.3 4.8 17.1.1l16.9-16.9c4.7-4.7 4.7-12.3 0-17l-104-104z"]
};
var faCloudUploadAlt = {
  prefix: 'far',
  iconName: 'cloud-upload-alt',
  icon: [640, 512, [], "f382", "M395.5 267.5l-99-99c-4.7-4.7-12.3-4.7-17 0l-99 99c-7.6 7.6-2.2 20.5 8.5 20.5h67v84c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12v-84h67c10.7 0 16.1-12.9 8.5-20.5zm148.2-67.4C539.7 142.1 491.4 96 432 96c-7.6 0-15.1.8-22.4 2.3C377.7 58.3 328.1 32 272 32c-84.6 0-155.5 59.7-172.3 139.8C39.9 196.1 0 254.4 0 320c0 88.4 71.6 160 160 160h336c79.5 0 144-64.5 144-144 0-61.8-39.2-115.8-96.3-135.9zM496 432H160c-61.9 0-112-50.1-112-112 0-56.4 41.7-103.1 96-110.9V208c0-70.7 57.3-128 128-128 53.5 0 99.3 32.8 118.4 79.4 11.2-9.6 25.7-15.4 41.6-15.4 35.3 0 64 28.7 64 64 0 11.8-3.2 22.9-8.8 32.4 2.9-.3 5.9-.4 8.8-.4 53 0 96 43 96 96s-43 96-96 96z"]
};
var faClouds = {
  prefix: 'far',
  iconName: 'clouds',
  icon: [640, 512, [], "f744", "M538.7 296.2C525.2 253.8 486 224 440 224c-13.5 0-26.8 2.6-39.2 7.7-1.8-2.1-4.1-3.6-6-5.5 17-19 26.5-43.6 26.5-68.9 0-57.3-46.7-104-104-104-7 0-13.9.7-20.7 2.1C275.5 21.6 238 0 197.3 0c-51.2 0-96 33.9-111.3 81.6C37.2 90.1 0 132.8 0 184c0 57.3 46.7 104 104 104h90.8c-1.2 5.7-2.3 11.4-2.7 17.4-38.6 17-64.2 55.1-64.2 98.6 0 59.5 48.4 108 108 108h296c59.6 0 108-48.5 108-108 .1-57.3-44.8-104.3-101.2-107.8zM104 240c-30.9 0-56-25.1-56-56 0-30.4 24.4-55.3 54.7-56l23.4.8 3-21.3c4.8-33.9 34.2-59.5 68.2-59.5 29 0 54.3 17.7 64.6 45l9 24 23.3-10.6c7.5-3.4 15.2-5.1 23-5.1 30.9 0 56 25.1 56 56 0 15.8-6.7 30.5-18.8 41.4l-1.3 1.2c-13-4.8-26.8-7.9-41.3-7.9-39.1 0-73.8 18.9-95.7 48H104zm428 224H236c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9c9.6-6.8 20.7-10.3 32.2-10.3 28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H532c33.1 0 60 26.9 60 60s-26.9 60-60 60z"]
};
var faCloudsMoon = {
  prefix: 'far',
  iconName: 'clouds-moon',
  icon: [640, 512, [], "f745", "M382.8 273.9c-3.8-5.8-8.5-10.7-13.2-15.6 7.4-14.1 11.9-29.9 11.9-47 0-56.1-44.4-102-99.7-103.9-23.7-29.7-60-48.1-99-48.1-40.1 0-77.2 19-100.9 50.3C35.1 119.5 0 161.4 0 211.3c0 37 19.5 69.1 48.6 87.5C21.4 320.7 4.2 354.3 4.2 392c0 66.2 53.5 120 119.2 120h238.4c65.7 0 119.2-53.8 119.2-120 0-59-42.4-108.2-98.2-118.1zM47.7 211.3c0-30.9 24.9-56 55.6-56h6.7c12.3-28.2 40.2-48 72.8-48 34.2 0 63 21.8 74.3 52.2 6.5-2.7 13.6-4.2 21.1-4.2 30.7 0 55.6 25.1 55.6 56 0 7.4-1.8 14.2-4.4 20.7-12.3-4.7-25.2-8-39-8-9.6 0-19 1.2-28.1 3.6-20-12.7-43.3-19.6-67.2-19.6-43.5 0-82.8 22.4-105.8 57.2-24-6.3-41.6-27.9-41.6-53.9zM361.8 464H123.4c-39.5 0-71.5-32.2-71.5-72 0-37.6 28.7-68 65.1-71.3 7.1-36.8 39.3-64.7 77.9-64.7 23.7 0 44.8 10.7 59.4 27.3 10.2-7.1 22.6-11.3 36-11.3 30 0 54.9 20.9 61.6 49 3.3-.5 6.5-1 9.9-1 39.5 0 71.5 32.2 71.5 72 .1 39.8-32 72-71.5 72zm275.9-202c-3.9-8.2-12.1-13.4-21-13.4h-1.5l-2.9.4c-6.9 1.3-13.8 2-20.7 2-59.7 0-108.3-49.1-108.3-109.4 0-39.2 21-75.7 54.9-95.1 8.6-4.9 13.1-14.5 11.4-24.3-1.7-9.8-9-17.4-18.8-19.2-10.3-2-21.1-3-31.7-3-66.6 0-124.6 37.8-154 93.1 14.6 8.3 27.3 19.4 37.8 32.4 14.8-34.4 43.7-61.2 79.8-72.1-17.2 25.6-26.9 56.3-26.9 88.2 0 72.3 48.5 133.3 114.4 151.7-15.9 7-33.2 10.7-51 10.7-5.4 0-10.4-1.1-15.6-1.8 10.7 14.7 18.5 31.4 23.5 49.3 49.9-2.2 96.1-25.4 127.8-64.7 5.6-7.1 6.7-16.6 2.8-24.8z"]
};
var faCloudsSun = {
  prefix: 'far',
  iconName: 'clouds-sun',
  icon: [640, 512, [], "f746", "M640 236.8c0-50.8-38.5-92.9-87.8-98.6C532 103.4 494.4 80 452 80c-46 0-85.9 26.4-104.5 66-31.7 13.8-54.4 43.6-58.6 79-22.3 12.7-40.7 31.8-52.1 55.3C191.4 297.6 160 341.1 160 392c0 66.2 53.8 120 120 120h240c66.2 0 120-53.8 120-120 0-32-12.8-60.8-33.3-82.3 20.1-18.1 33.3-43.7 33.3-72.9zM520 464H280c-39.8 0-72-32.2-72-72 0-37.6 28.9-68 65.5-71.3C280.7 283.9 313 256 352 256c23.9 0 45.1 10.7 59.8 27.3 10.3-7.1 22.8-11.3 36.2-11.3 30.2 0 55.3 20.9 62 49 3.3-.5 6.5-1 10-1 39.8 0 72 32.2 72 72s-32.2 72-72 72zm45.6-182.7c-7.8-3.2-15.9-6-24.5-7.5-20.3-30.5-54.7-49.8-93.1-49.8-9.6 0-19.2 1.2-28.3 3.6-20.2-12.7-43.6-19.6-67.7-19.6-2.2 0-4.2.4-6.4.5 8.8-12.9 22.8-21.9 39.4-22.6 4.9-32.7 32.9-57.8 67-57.8 35.8 0 64.8 27.8 67.5 62.9 6.5-3.1 13.6-5.3 21.3-5.3 28.3 0 51.2 22.9 51.2 51.2 0 19.1-10.7 35.7-26.4 44.4zM115 297.4l6-31.1-26.2-17.8-37-25.1 37-25.1 26.2-17.8-6-31.1-8.5-43.9 43.7 8.5 31.2 6 17.8-26.3L224 57v1l24.9 36.9 17.8 26.3 31.2-6 35.1-6.8c13.1-18 29.9-32.5 49.2-42.8-6.6-6.5-15.4-10.2-24.6-10.2-2.2 0-4.5.2-6.8.6l-62 12-35.4-52.4C246.7 5.8 235.8 0 224 0c-11.4 0-22.7 4.9-29.3 14.7l-35.4 52.4-62-12c-2.3-.4-4.5-.7-6.8-.7-9.3 0-18.3 3.7-25 10.4-8.3 8.4-11.9 20.2-9.7 31.8l12 62.1-52.3 35.5C5.8 200.8 0 211.8 0 223.5c0 11.8 5.8 22.7 15.6 29.3l52.3 35.4-12 62.1c-2.2 11.6 1.4 23.5 9.7 31.8 6.7 6.7 15.6 10.4 25 10.4 2.2 0 4.5-.2 6.8-.6l31.1-6c.7-17.9 4.4-35.1 10.8-51l-32.7 6.3 8.4-43.8zM224 184c15.5 0 28.7 9.1 35.3 22.1.3-.2.6-.4.8-.6 4.2-17.1 11.6-33.1 22-47.1-15.5-13.7-35.7-22.4-58.1-22.4-48.5 0-88 39.5-88 88 0 26.7 12.2 50.3 31 66.5 11.1-12.3 24.4-22.7 39.5-31C193.3 253 184 239.7 184 224c0-22.1 17.9-40 40-40z"]
};
var faClub = {
  prefix: 'far',
  iconName: 'club',
  icon: [512, 512, [], "f327", "M256 48c60.3 0 101.3 60.9 79.6 116.5L321 201.9c-1.6 4 1.4 8.2 5.6 8.2.3 0 .5 0 .8-.1l39.8-5.3c3.9-.5 7.7-.8 11.5-.8 46.8 0 85.5 38.2 85.3 85.8-.2 47.3-39.4 85.1-86.6 85.1h-.8c-38.1-.3-48.9-6-78.4-36.2-1.2-1.3-2.7-1.8-4.2-1.8-3.1 0-6 2.4-6 6V360c0 37.7-2.3 48.8 24.7 82.9 6.8 8.5.7 21.1-10.2 21.1h-93.1c-10.9 0-16.9-12.6-10.2-21.1 27-34 24.7-45.2 24.7-82.9v-17.1c0-3.6-3-6-6-6-1.5 0-3 .6-4.2 1.8-29.2 29.9-40.1 35.8-78.3 36.2h-.8c-47.2 0-86.5-37.9-86.6-85.2-.1-47.5 38.6-85.6 85.3-85.6 3.8 0 7.6.2 11.5.8l39.8 5.3c.3 0 .5.1.8.1 4.1 0 7.1-4.2 5.6-8.2l-14.6-37.4C154.6 108.8 195.8 48 256 48m0-48c-22.4 0-44.5 5.6-63.9 16.2-18.3 10-34.3 24.6-46.2 42-11.9 17.4-19.6 37.6-22.3 58.4-1.7 13.2-1.4 26.6.9 39.7-14.8 1-29.3 4.4-43.1 10.3-15.9 6.8-30.2 16.4-42.4 28.7-25.2 25.3-39.1 58.8-39 94.5.2 73.4 60.5 133.1 134.6 133.1h1.2c6.9-.1 13.5-.3 19.9-.8-3.9 7.2-6.3 15.2-7.1 23.5-1 11 1 22.1 5.9 32 4.8 10 12.2 18.4 21.4 24.5 9.9 6.5 21.5 10 33.5 10h93.1c12 0 23.6-3.5 33.5-10 9.2-6.1 16.6-14.5 21.4-24.5 4.8-10 6.8-21 5.9-32-.7-8.3-3.2-16.2-7.1-23.5 6.4.5 13 .8 20 .8h1.2c73.9 0 134.3-59.6 134.6-132.9.1-35.7-13.7-69.3-38.9-94.6-12.3-12.3-26.5-22-42.5-28.7-13.8-5.9-28.3-9.3-43.1-10.3 2.3-13.1 2.6-26.5.9-39.7-2.7-20.8-10.4-41-22.3-58.4s-27.9-31.9-46.2-41.9C300.5 5.6 278.4 0 256 0z"]
};
var faCocktail = {
  prefix: 'far',
  iconName: 'cocktail',
  icon: [576, 512, [], "f561", "M296 464h-64V346.78l176.74-176.73c15.52-15.52 4.53-42.05-17.42-42.05H24.68c-21.95 0-32.94 26.53-17.42 42.05L184 346.78V464h-64c-22.09 0-40 17.91-40 40 0 4.42 3.58 8 8 8h240c4.42 0 8-3.58 8-8 0-22.09-17.91-40-40-40zM81.1 176h253.8L208 302.9 81.1 176zM432 0c-62.61 0-115.35 40.2-135.18 96h52.54c16.65-28.55 47.27-48 82.64-48 52.93 0 96 43.06 96 96s-43.07 96-96 96c-14.04 0-27.29-3.2-39.32-8.64l-35.26 35.26C379.23 279.92 404.59 288 432 288c79.53 0 144-64.47 144-144S511.53 0 432 0z"]
};
var faCode = {
  prefix: 'far',
  iconName: 'code',
  icon: [576, 512, [], "f121", "M234.8 511.7L196 500.4c-4.2-1.2-6.7-5.7-5.5-9.9L331.3 5.8c1.2-4.2 5.7-6.7 9.9-5.5L380 11.6c4.2 1.2 6.7 5.7 5.5 9.9L244.7 506.2c-1.2 4.3-5.6 6.7-9.9 5.5zm-83.2-121.1l27.2-29c3.1-3.3 2.8-8.5-.5-11.5L72.2 256l106.1-94.1c3.4-3 3.6-8.2.5-11.5l-27.2-29c-3-3.2-8.1-3.4-11.3-.4L2.5 250.2c-3.4 3.2-3.4 8.5 0 11.7L140.3 391c3.2 3 8.2 2.8 11.3-.4zm284.1.4l137.7-129.1c3.4-3.2 3.4-8.5 0-11.7L435.7 121c-3.2-3-8.3-2.9-11.3.4l-27.2 29c-3.1 3.3-2.8 8.5.5 11.5L503.8 256l-106.1 94.1c-3.4 3-3.6 8.2-.5 11.5l27.2 29c3.1 3.2 8.1 3.4 11.3.4z"]
};
var faCodeBranch = {
  prefix: 'far',
  iconName: 'code-branch',
  icon: [384, 512, [], "f126", "M384 144c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 36.4 24.3 67.1 57.5 76.8-.6 16.1-4.2 28.5-11 36.9-15.4 19.2-49.3 22.4-85.2 25.7-28.2 2.6-57.4 5.4-81.3 16.9v-144c32.5-10.2 56-40.5 56-76.3 0-44.2-35.8-80-80-80S0 35.8 0 80c0 35.8 23.5 66.1 56 76.3v199.3C23.5 365.9 0 396.2 0 432c0 44.2 35.8 80 80 80s80-35.8 80-80c0-34-21.2-63.1-51.2-74.6 3.1-5.2 7.8-9.8 14.9-13.4 16.2-8.2 40.4-10.4 66.1-12.8 42.2-3.9 90-8.4 118.2-43.5 14-17.4 21.1-39.8 21.6-67.9 31.6-10.7 54.4-40.6 54.4-75.8zM80 48c17.6 0 32 14.4 32 32s-14.4 32-32 32-32-14.4-32-32 14.4-32 32-32zm0 416c-17.6 0-32-14.4-32-32s14.4-32 32-32 32 14.4 32 32-14.4 32-32 32zm224-288c-17.6 0-32-14.4-32-32s14.4-32 32-32 32 14.4 32 32-14.4 32-32 32z"]
};
var faCodeCommit = {
  prefix: 'far',
  iconName: 'code-commit',
  icon: [640, 512, [], "f386", "M128 256c0 10.8.9 21.5 2.6 32H12c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h118.6c-1.7 10.5-2.6 21.2-2.6 32zm500-32H509.4c1.8 10.5 2.6 21.2 2.6 32s-.9 21.5-2.6 32H628c6.6 0 12-5.4 12-12v-40c0-6.6-5.4-12-12-12zm-308-80c-29.9 0-58 11.7-79.2 32.8C219.6 198 208 226.1 208 256s11.6 58 32.8 79.2C262 356.3 290.1 368 320 368s58-11.7 79.2-32.8C420.4 314 432 285.9 432 256s-11.6-58-32.8-79.2C378 155.7 349.9 144 320 144m0-48c88.4 0 160 71.6 160 160s-71.6 160-160 160-160-71.6-160-160S231.6 96 320 96z"]
};
var faCodeMerge = {
  prefix: 'far',
  iconName: 'code-merge',
  icon: [384, 512, [], "f387", "M304 192c-38 0-69.8 26.5-77.9 62-23.9-3.5-58-12.9-83.9-37.6-16.6-15.9-27.9-36.5-33.7-61.6C138.6 143.3 160 114.1 160 80c0-44.2-35.8-80-80-80S0 35.8 0 80c0 35.8 23.5 66.1 56 76.3v199.3C23.5 365.9 0 396.2 0 432c0 44.2 35.8 80 80 80s80-35.8 80-80c0-35.8-23.5-66.1-56-76.3V246.1c1.6 1.7 3.3 3.4 5 5 39.3 37.5 90.4 48.6 121.2 51.8 12.1 28.9 40.6 49.2 73.8 49.2 44.2 0 80-35.8 80-80S348.2 192 304 192zM80 48c17.6 0 32 14.4 32 32s-14.4 32-32 32-32-14.4-32-32 14.4-32 32-32zm0 416c-17.6 0-32-14.4-32-32s14.4-32 32-32 32 14.4 32 32-14.4 32-32 32zm224-160c-17.6 0-32-14.4-32-32s14.4-32 32-32 32 14.4 32 32-14.4 32-32 32z"]
};
var faCoffee = {
  prefix: 'far',
  iconName: 'coffee',
  icon: [640, 512, [], "f0f4", "M512 32H112c-8.8 0-16 7.2-16 16v256c0 44.2 35.8 80 80 80h224c44.2 0 80-35.8 80-80v-16h32c70.6 0 128-57.4 128-128S582.6 32 512 32zm-80 272c0 17.6-14.4 32-32 32H176c-17.6 0-32-14.4-32-32V80h288v224zm80-64h-32V80h32c44.1 0 80 35.9 80 80s-35.9 80-80 80zm55.8 240H40.2c-37.3 0-50.2-48-32-48h591.7c18.1 0 5.2 48-32.1 48z"]
};
var faCoffeeTogo = {
  prefix: 'far',
  iconName: 'coffee-togo',
  icon: [448, 512, [], "f6c5", "M432 96h-16l-24.71-74.12C386.94 8.81 374.71 0 360.94 0h-274C73.16 0 61.07 8.81 56.71 21.88L32 96H16c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16h19.84l25.8 322.55C62.97 499.18 76.86 512 93.54 512h260.92c16.68 0 30.57-12.82 31.9-29.45L412.16 160H432c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16zM98.6 48h250.8l21.33 64H77.26L98.6 48zm9.71 416l-7.68-96h246.73l-7.68 96H108.31zm250.58-240H89.11l-5.12-64H364l-5.11 64z"]
};
var faCoffin = {
  prefix: 'far',
  iconName: 'coffin',
  icon: [384, 512, [], "f6c6", "M374.45 115.19L266.71 9.37c-6.11-6-14.4-9.37-23.04-9.37H140.33c-8.64 0-16.93 3.37-23.04 9.37L9.55 115.19C1.46 123.14-1.8 134.67.98 145.58l87.11 342.18C91.71 502.01 104.75 512 119.7 512h144.62c14.95 0 27.98-9.99 31.61-24.24l87.11-342.18c2.76-10.91-.49-22.44-8.59-30.39zM252.44 464H131.56L49.82 142.91 146.46 48h91.08l96.64 94.91L252.44 464zM216 112c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v48h-56c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h56v128c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16V208h56c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16h-56v-48z"]
};
var faCog = {
  prefix: 'far',
  iconName: 'cog',
  icon: [512, 512, [], "f013", "M452.515 237l31.843-18.382c9.426-5.441 13.996-16.542 11.177-27.054-11.404-42.531-33.842-80.547-64.058-110.797-7.68-7.688-19.575-9.246-28.985-3.811l-31.785 18.358a196.276 196.276 0 0 0-32.899-19.02V39.541a24.016 24.016 0 0 0-17.842-23.206c-41.761-11.107-86.117-11.121-127.93-.001-10.519 2.798-17.844 12.321-17.844 23.206v36.753a196.276 196.276 0 0 0-32.899 19.02l-31.785-18.358c-9.41-5.435-21.305-3.877-28.985 3.811-30.216 30.25-52.654 68.265-64.058 110.797-2.819 10.512 1.751 21.613 11.177 27.054L59.485 237a197.715 197.715 0 0 0 0 37.999l-31.843 18.382c-9.426 5.441-13.996 16.542-11.177 27.054 11.404 42.531 33.842 80.547 64.058 110.797 7.68 7.688 19.575 9.246 28.985 3.811l31.785-18.358a196.202 196.202 0 0 0 32.899 19.019v36.753a24.016 24.016 0 0 0 17.842 23.206c41.761 11.107 86.117 11.122 127.93.001 10.519-2.798 17.844-12.321 17.844-23.206v-36.753a196.34 196.34 0 0 0 32.899-19.019l31.785 18.358c9.41 5.435 21.305 3.877 28.985-3.811 30.216-30.25 52.654-68.266 64.058-110.797 2.819-10.512-1.751-21.613-11.177-27.054L452.515 275c1.22-12.65 1.22-25.35 0-38zm-52.679 63.019l43.819 25.289a200.138 200.138 0 0 1-33.849 58.528l-43.829-25.309c-31.984 27.397-36.659 30.077-76.168 44.029v50.599a200.917 200.917 0 0 1-67.618 0v-50.599c-39.504-13.95-44.196-16.642-76.168-44.029l-43.829 25.309a200.15 200.15 0 0 1-33.849-58.528l43.819-25.289c-7.63-41.299-7.634-46.719 0-88.038l-43.819-25.289c7.85-21.229 19.31-41.049 33.849-58.529l43.829 25.309c31.984-27.397 36.66-30.078 76.168-44.029V58.845a200.917 200.917 0 0 1 67.618 0v50.599c39.504 13.95 44.196 16.642 76.168 44.029l43.829-25.309a200.143 200.143 0 0 1 33.849 58.529l-43.819 25.289c7.631 41.3 7.634 46.718 0 88.037zM256 160c-52.935 0-96 43.065-96 96s43.065 96 96 96 96-43.065 96-96-43.065-96-96-96zm0 144c-26.468 0-48-21.532-48-48 0-26.467 21.532-48 48-48s48 21.533 48 48c0 26.468-21.532 48-48 48z"]
};
var faCogs = {
  prefix: 'far',
  iconName: 'cogs',
  icon: [640, 512, [], "f085", "M217.1 478.1c-23.8 0-41.6-3.5-57.5-7.5-10.6-2.7-18.1-12.3-18.1-23.3v-31.7c-9.4-4.4-18.4-9.6-26.9-15.6l-26.7 15.4c-9.6 5.6-21.9 3.8-29.5-4.3-35.4-37.6-44.2-58.6-57.2-98.5-3.6-10.9 1.1-22.7 11-28.4l26.8-15c-.9-10.3-.9-20.7 0-31.1L12.2 223c-10-5.6-14.6-17.5-11-28.4 13.1-40 21.9-60.9 57.2-98.5 7.6-8.1 19.8-9.9 29.5-4.3l26.7 15.4c8.5-6 17.5-11.2 26.9-15.6V61.4c0-11.1 7.6-20.8 18.4-23.3 44.2-10.5 70-10.5 114.3 0 10.8 2.6 18.4 12.2 18.4 23.3v30.4c9.4 4.4 18.4 9.6 26.9 15.6L346.2 92c9.7-5.6 21.9-3.7 29.6 4.4 26.1 27.9 48.4 58.5 56.8 100.3 2 9.8-2.4 19.8-10.9 25.1l-26.6 16.5c.9 10.3.9 20.7 0 31.1l26.6 16.5c8.4 5.2 12.9 15.2 10.9 24.9-8.1 40.5-29.6 71.3-56.9 100.6-7.6 8.1-19.8 9.9-29.5 4.3l-26.7-15.4c-8.5 6-17.5 11.2-26.9 15.6v31.7c0 11-7.4 20.6-18.1 23.3-15.8 3.8-33.6 7.2-57.4 7.2zm-27.6-50.7c18.3 2.9 36.9 2.9 55.1 0v-44.8l16-5.7c15.2-5.4 29.1-13.4 41.3-23.9l12.9-11 38.8 22.4c11.7-14.4 21-30.5 27.6-47.7l-38.8-22.4 3.1-16.7c2.9-15.9 2.9-32 0-47.9l-3.1-16.7 38.8-22.4c-6.6-17.2-15.9-33.3-27.6-47.7l-38.8 22.4-12.9-11c-12.3-10.5-26.2-18.6-41.3-23.9l-16-5.7V80c-18.3-2.9-36.9-2.9-55.1 0v44.8l-16 5.7c-15.2 5.4-29.1 13.4-41.3 23.9l-12.9 11L80.5 143c-11.7 14.4-21 30.5-27.6 47.7l38.8 22.4-3.1 16.7c-2.9 15.9-2.9 32 0 47.9l3.1 16.7-38.8 22.4c6.6 17.2 15.9 33.4 27.6 47.7l38.8-22.4 12.9 11c12.3 10.5 26.2 18.6 41.3 23.9l16 5.7v44.7zm27.1-85.1c-22.6 0-45.2-8.6-62.4-25.8-34.4-34.4-34.4-90.4 0-124.8 34.4-34.4 90.4-34.4 124.8 0 34.4 34.4 34.4 90.4 0 124.8-17.3 17.2-39.9 25.8-62.4 25.8zm0-128.4c-10.3 0-20.6 3.9-28.5 11.8-15.7 15.7-15.7 41.2 0 56.9 15.7 15.7 41.2 15.7 56.9 0 15.7-15.7 15.7-41.2 0-56.9-7.8-7.9-18.1-11.8-28.4-11.8zM638.5 85c-1-5.8-6-10-11.9-10h-16.1c-3.5-9.9-8.8-19-15.5-26.8l8-13.9c2.9-5.1 1.8-11.6-2.7-15.3C591 11.3 580.5 5.1 569 .8c-5.5-2.1-11.8.1-14.7 5.3l-8 13.9c-10.2-1.9-20.7-1.9-30.9 0l-8-13.9c-3-5.1-9.2-7.3-14.7-5.3-11.5 4.3-22.1 10.5-31.4 18.2-4.5 3.7-5.7 10.2-2.7 15.3l8 13.9c-6.7 7.8-12 16.9-15.5 26.8H435c-5.9 0-11 4.3-11.9 10.2-2 12.2-1.9 24.5 0 36.2 1 5.8 6 10 11.9 10h16.1c3.5 9.9 8.8 19 15.5 26.8l-8 13.9c-2.9 5.1-1.8 11.6 2.7 15.3 9.3 7.7 19.9 13.9 31.4 18.2 5.5 2.1 11.8-.1 14.7-5.3l8-13.9c10.2 1.9 20.7 1.9 30.9 0l8 13.9c3 5.1 9.2 7.3 14.7 5.3 11.5-4.3 22.1-10.5 31.4-18.2 4.5-3.7 5.7-10.2 2.7-15.3l-8-13.9c6.7-7.8 12-16.9 15.5-26.8h16.1c5.9 0 11-4.3 11.9-10.2 1.9-12.2 1.9-24.4-.1-36.2zm-107.8 50.2c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm107.8 255.4c-1-5.8-6-10-11.9-10h-16.1c-3.5-9.9-8.8-19-15.5-26.8l8-13.9c2.9-5.1 1.8-11.6-2.7-15.3-9.3-7.7-19.9-13.9-31.4-18.2-5.5-2.1-11.8.1-14.7 5.3l-8 13.9c-10.2-1.9-20.7-1.9-30.9 0l-8-13.9c-3-5.1-9.2-7.3-14.7-5.3-11.5 4.3-22.1 10.5-31.4 18.2-4.5 3.7-5.7 10.2-2.7 15.3l8 13.9c-6.7 7.8-12 16.9-15.5 26.8h-16.1c-5.9 0-11 4.3-11.9 10.2-2 12.2-1.9 24.5 0 36.2 1 5.8 6 10 11.9 10H451c3.5 9.9 8.8 19 15.5 26.8l-8 13.9c-2.9 5.1-1.8 11.6 2.7 15.3 9.3 7.7 19.9 13.9 31.4 18.2 5.5 2.1 11.8-.1 14.7-5.3l8-13.9c10.2 1.9 20.7 1.9 30.9 0l8 13.9c3 5.1 9.2 7.3 14.7 5.3 11.5-4.3 22.1-10.5 31.4-18.2 4.5-3.7 5.7-10.2 2.7-15.3l-8-13.9c6.7-7.8 12-16.9 15.5-26.8h16.1c5.9 0 11-4.3 11.9-10.2 2-12.1 2-24.4 0-36.2zm-107.8 50.2c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32z"]
};
var faCoin = {
  prefix: 'far',
  iconName: 'coin',
  icon: [512, 512, [], "f85c", "M256 64C114.67 64 0 128.44 0 208v112c0 70.72 114.67 128 256 128s256-57.28 256-128V208c0-79.56-114.67-144-256-144zM88 363.37C62.42 349.16 48 333.2 48 320v-28.27a226 226 0 0 0 40 24.75zm96 30.88a348.83 348.83 0 0 1-64-16.32v-48.09a373.73 373.73 0 0 0 64 16.28zm112 4c-12.81 1.1-26.1 1.78-40 1.78s-27.19-.68-40-1.78v-48.18c13.07 1.16 26.36 1.93 40 1.93s26.93-.77 40-1.93zm96-20.29a348.83 348.83 0 0 1-64 16.32v-48.16a373.73 373.73 0 0 0 64-16.28zM464 320c0 13.2-14.42 29.16-40 43.37v-46.89a226 226 0 0 0 40-24.75zm-208-16c-119 0-208-50.68-208-96s89-96 208-96 208 50.68 208 96-88.95 96-208 96z"]
};
var faCoins = {
  prefix: 'far',
  iconName: 'coins',
  icon: [512, 512, [], "f51e", "M320 0C214 0 128 35.8 128 80v52.6C53.5 143.6 0 173.2 0 208v224c0 44.2 86 80 192 80s192-35.8 192-80v-52.7c74.5-11 128-40.5 128-75.3V80c0-44.2-86-80-192-80zm16 428.3C326 440 275.6 464 192 464S58 440 48 428.3v-39.5c35.2 16.6 86.6 27.2 144 27.2s108.8-10.6 144-27.2v39.5zm0-96C326 344 275.6 368 192 368S58 344 48 332.3v-44.9c35.2 20 86.6 32.6 144 32.6s108.8-12.7 144-32.6v44.9zM192 272c-79.5 0-144-21.5-144-48s64.5-48 144-48 144 21.5 144 48-64.5 48-144 48zm272 28.3c-7.1 8.3-34.9 22.6-80 30.4V283c31-4.6 58.7-12.1 80-22.2v39.5zm0-96c-7.1 8.3-34.9 22.6-80 30.4V208c0-7.2-2.5-14.2-6.8-20.9 33.8-5.3 64-14.8 86.8-27.8v45zM320 144c-5 0-9.8-.3-14.7-.5-26-7.9-56.8-13.2-90.4-14.9C191 120 176 108.6 176 96c0-26.5 64.5-48 144-48s144 21.5 144 48-64.5 48-144 48z"]
};
var faColumns = {
  prefix: 'far',
  iconName: 'columns',
  icon: [512, 512, [], "f0db", "M464 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zM232 432H54a6 6 0 0 1-6-6V112h184v320zm226 0H280V112h184v314a6 6 0 0 1-6 6z"]
};
var faComment = {
  prefix: 'far',
  iconName: 'comment',
  icon: [512, 512, [], "f075", "M256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentAlt = {
  prefix: 'far',
  iconName: 'comment-alt',
  icon: [512, 512, [], "f27a", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288z"]
};
var faCommentAltCheck = {
  prefix: 'far',
  iconName: 'comment-alt-check',
  icon: [512, 512, [], "f4a2", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zM332.7 130.4c-3.8-3.9-10.1-3.9-14-.1L231.4 217l-37.9-38.2c-3.8-3.9-10.1-3.9-14-.1l-23.4 23.2c-3.9 3.8-3.9 10.1-.1 14l68.1 68.6c3.8 3.9 10.1 3.9 14 .1l117.8-116.8c3.9-3.8 3.9-10.1.1-14l-23.3-23.4z"]
};
var faCommentAltDollar = {
  prefix: 'far',
  iconName: 'comment-alt-dollar',
  icon: [512, 512, [], "f650", "M448 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h96v83.98c0 7.1 5.83 12.02 12.05 12.02 2.41 0 4.88-.74 7.08-2.37L304 416h144c35.35 0 64-28.65 64-64V64c0-35.35-28.65-64-64-64zm16 352c0 8.82-7.18 16-16 16H288l-12.8 9.6-67.2 50.39V368H64c-8.82 0-16-7.18-16-16V64c0-8.82 7.18-16 16-16h384c8.82 0 16 7.18 16 16v288zM286.41 191.72l-50.07-14.3a8.46 8.46 0 0 1-6.12-8.11c0-4.64 3.78-8.42 8.44-8.42h32.78c3.6 0 7.08.77 10.26 2.22 4.8 2.21 10.37 1.71 14.11-2.03l17.52-17.52c5.27-5.27 4.67-14.28-1.55-18.38-9.5-6.27-20.35-10.11-31.78-11.46V96c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v17.56c-30.29 3.62-53.37 30.98-49.32 63.05 2.9 22.95 20.66 41.31 42.91 47.67l50.07 14.3a8.46 8.46 0 0 1 6.12 8.11c0 4.64-3.78 8.42-8.44 8.42h-32.78c-3.6 0-7.08-.77-10.26-2.22-4.8-2.21-10.37-1.71-14.11 2.03l-17.52 17.52c-5.27 5.27-4.68 14.28 1.55 18.38 9.5 6.27 20.35 10.11 31.78 11.46V320c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-17.56c30.29-3.62 53.37-30.98 49.32-63.05-2.9-22.95-20.66-41.31-42.91-47.67z"]
};
var faCommentAltDots = {
  prefix: 'far',
  iconName: 'comment-alt-dots',
  icon: [512, 512, [], "f4a3", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zM128 176c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm128 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm128 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32z"]
};
var faCommentAltEdit = {
  prefix: 'far',
  iconName: 'comment-alt-edit',
  icon: [512, 512, [], "f4a4", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zM164.9 243.2l-4.8 42.8c-.6 5.7 4.2 10.6 10 10l42.8-4.8 85.5-85.5-48-48-85.5 85.5zm159.3-133.9c-7-7-18.4-7-25.4 0l-28.3 28.3 48 48 28.3-28.3c7-7 7-18.4 0-25.4l-22.6-22.6z"]
};
var faCommentAltExclamation = {
  prefix: 'far',
  iconName: 'comment-alt-exclamation',
  icon: [512, 512, [], "f4a5", "M256 256c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zM284.7 96h-57.4c-10 0-17.6 9.1-15.7 18.9l18 96c1.4 7.6 8 13.1 15.7 13.1h21.4c7.7 0 14.3-5.5 15.7-13.1l18-96c1.9-9.8-5.7-18.9-15.7-18.9z"]
};
var faCommentAltLines = {
  prefix: 'far',
  iconName: 'comment-alt-lines',
  icon: [512, 512, [], "f4a6", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zm-96-216H144c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h224c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm-96 96H144c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h128c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16z"]
};
var faCommentAltMedical = {
  prefix: 'far',
  iconName: 'comment-alt-medical',
  icon: [512, 512, [], "f7f4", "M448 0H64A64 64 0 0 0 0 64v288a64 64 0 0 0 64 64h96v84a12 12 0 0 0 12.05 12 11.84 11.84 0 0 0 7.08-2.37L304 416h144a64 64 0 0 0 64-64V64a64 64 0 0 0-64-64zm16 352a16 16 0 0 1-16 16H288l-12.79 9.6L208 428v-60H64a16 16 0 0 1-16-16V64a16 16 0 0 1 16-16h384a16 16 0 0 1 16 16zM344 176h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8z"]
};
var faCommentAltMinus = {
  prefix: 'far',
  iconName: 'comment-alt-minus',
  icon: [512, 512, [], "f4a7", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zM336 184H176c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h160c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16z"]
};
var faCommentAltPlus = {
  prefix: 'far',
  iconName: 'comment-alt-plus',
  icon: [512, 512, [], "f4a8", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zM336 184h-56v-56c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v56h-56c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h56v56c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-56h56c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16z"]
};
var faCommentAltSlash = {
  prefix: 'far',
  iconName: 'comment-alt-slash',
  icon: [640, 512, [], "f4a9", "M634 471L36 3.5C29.1-2 19-.9 13.5 6l-10 12.5C-2 25.4-.9 35.5 6 41l58 45.3 41.6 32.5L604 508.5c6.9 5.5 17 4.4 22.5-2.5l10-12.5c5.5-6.9 4.4-17-2.5-22.5zM512 48c8.8 0 16 7.2 16 16v263.2l46.8 36.6c.7-3.8 1.2-7.8 1.2-11.8V64c0-35.3-28.7-64-64-64H128c-5.5 0-10.7.9-15.8 2.2L170.8 48H512zM339.2 377.6L272 428v-60H128c-8.8 0-16-7.2-16-16V184.8l-48-37.5V352c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L368 416h39.8l-58.6-45.8-10 7.4z"]
};
var faCommentAltSmile = {
  prefix: 'far',
  iconName: 'comment-alt-smile',
  icon: [512, 512, [], "f4aa", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zM325.8 240.2C308.5 260.4 283.1 272 256 272s-52.5-11.6-69.8-31.8c-8.6-10.1-23.8-11.3-33.8-2.7s-11.2 23.8-2.7 33.8c26.5 31 65.2 48.7 106.3 48.7s79.8-17.8 106.2-48.7c8.6-10.1 7.4-25.2-2.7-33.8-10-8.6-25.1-7.4-33.7 2.7zM192 192c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32z"]
};
var faCommentAltTimes = {
  prefix: 'far',
  iconName: 'comment-alt-times',
  icon: [512, 512, [], "f4ab", "M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64zm16 352c0 8.8-7.2 16-16 16H288l-12.8 9.6L208 428v-60H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h384c8.8 0 16 7.2 16 16v288zM329.5 145.8l-11.3-11.3c-6.2-6.2-16.4-6.2-22.6 0L256 174.1l-39.6-39.6c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-6.2 6.2-6.2 16.4 0 22.6l39.6 39.6-39.6 39.6c-6.2 6.2-6.2 16.4 0 22.6l11.3 11.3c6.2 6.2 16.4 6.2 22.6 0l39.6-39.6 39.6 39.6c6.2 6.2 16.4 6.2 22.6 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6L289.9 208l39.6-39.6c6.3-6.2 6.3-16.4 0-22.6z"]
};
var faCommentCheck = {
  prefix: 'far',
  iconName: 'comment-check',
  icon: [512, 512, [], "f4ac", "M332.7 162.4c-3.8-3.9-10.1-3.9-14-.1L231.4 249l-37.9-38.2c-3.8-3.9-10.1-3.9-14-.1l-23.4 23.2c-3.9 3.8-3.9 10.1-.1 14l68.1 68.6c3.8 3.9 10.1 3.9 14 .1l117.8-116.8c3.9-3.8 3.9-10.1.1-14l-23.3-23.4zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentDollar = {
  prefix: 'far',
  iconName: 'comment-dollar',
  icon: [512, 512, [], "f651", "M256 32C114.62 32 0 125.13 0 240c0 47.55 19.86 91.23 52.9 126.27C38 405.72 6.97 439.06 6.54 439.5c-6.56 6.95-8.38 17.19-4.59 25.98S14.39 480 23.98 480c61.51 0 110.02-25.72 139.15-46.33C191.95 442.8 223.2 448 256 448c141.38 0 256-93.12 256-208S397.38 32 256 32zm0 368c-26.69 0-53.05-4.07-78.37-12.09l-22.74-7.21-19.48 13.78c-14.34 10.15-33.88 21.45-57.47 28.97 7.29-12.06 14.38-25.7 19.86-40.22l10.61-28.07-20.59-21.83C69.65 314.07 48 282.25 48 240c0-88.22 93.31-160 208-160s208 71.78 208 160-93.31 160-208 160zm30.41-176.28l-50.07-14.3a8.46 8.46 0 0 1-6.12-8.11c0-4.64 3.78-8.42 8.44-8.42h32.78c3.6 0 7.08.77 10.26 2.22 4.8 2.21 10.37 1.71 14.11-2.03l17.52-17.52c5.27-5.27 4.67-14.28-1.55-18.38-9.5-6.27-20.35-10.11-31.78-11.46V128c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v17.56c-30.29 3.62-53.37 30.98-49.32 63.05 2.9 22.95 20.66 41.31 42.91 47.67l50.07 14.3a8.46 8.46 0 0 1 6.12 8.11c0 4.64-3.78 8.42-8.44 8.42h-32.78c-3.6 0-7.08-.77-10.26-2.22-4.8-2.21-10.37-1.71-14.11 2.03l-17.52 17.52c-5.27 5.27-4.68 14.28 1.55 18.38 9.5 6.27 20.35 10.11 31.78 11.46V352c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-17.56c30.29-3.62 53.37-30.98 49.32-63.05-2.9-22.95-20.66-41.31-42.91-47.67z"]
};
var faCommentDots = {
  prefix: 'far',
  iconName: 'comment-dots',
  icon: [512, 512, [], "f4ad", "M144 208c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm112 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm112 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentEdit = {
  prefix: 'far',
  iconName: 'comment-edit',
  icon: [512, 512, [], "f4ae", "M164.9 275.2l-4.8 42.8c-.6 5.7 4.2 10.6 10 10l42.8-4.8 85.5-85.5-48-48-85.5 85.5zm159.3-133.9c-7-7-18.4-7-25.4 0l-28.3 28.3 48 48 28.3-28.3c7-7 7-18.4 0-25.4l-22.6-22.6zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentExclamation = {
  prefix: 'far',
  iconName: 'comment-exclamation',
  icon: [512, 512, [], "f4af", "M256 288c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm28.7-160h-57.4c-10 0-17.6 9.1-15.7 18.9l18 96c1.4 7.6 8 13.1 15.7 13.1h21.4c7.7 0 14.3-5.5 15.7-13.1l18-96c1.9-9.8-5.7-18.9-15.7-18.9zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentLines = {
  prefix: 'far',
  iconName: 'comment-lines',
  icon: [512, 512, [], "f4b0", "M368 168H144c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h224c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm-96 96H144c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h128c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentMedical = {
  prefix: 'far',
  iconName: 'comment-medical',
  icon: [512, 512, [], "f7f5", "M344 208h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8zM256 32C114.62 32 0 125.12 0 240c0 47.55 19.86 91.23 52.9 126.27C38 405.72 7 439.06 6.54 439.5A24 24 0 0 0 24 480c61.51 0 110-25.72 139.15-46.33A307.33 307.33 0 0 0 256 448c141.38 0 256-93.13 256-208S397.38 32 256 32zm0 368a259.17 259.17 0 0 1-78.37-12.09l-22.75-7.21-19.47 13.78a212 212 0 0 1-57.47 29 247.26 247.26 0 0 0 19.86-40.25l10.61-28.07-20.59-21.83C69.65 314.07 48 282.25 48 240c0-88.22 93.31-160 208-160s208 71.78 208 160-93.31 160-208 160z"]
};
var faCommentMinus = {
  prefix: 'far',
  iconName: 'comment-minus',
  icon: [512, 512, [], "f4b1", "M336 216H176c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h160c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentPlus = {
  prefix: 'far',
  iconName: 'comment-plus',
  icon: [512, 512, [], "f4b2", "M336 216h-56v-56c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v56h-56c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h56v56c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-56h56c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentSlash = {
  prefix: 'far',
  iconName: 'comment-slash',
  icon: [640, 512, [], "f4b3", "M320 80c114.7 0 208 71.8 208 160 0 25.3-7.9 49.1-21.5 70.4l37.9 29.6c20.1-29.6 31.6-63.7 31.6-100 0-114.9-114.6-208-256-208-48.2 0-93 11-131.5 29.8l43 33.6C258.4 85.6 288.3 80 320 80zm0 320c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C133.7 314.1 112 282.2 112 240c0-16.6 3.3-32.7 9.5-47.8L82.8 162c-12 24.1-18.8 50.4-18.8 78 0 47.6 19.9 91.2 52.9 126.3-14.9 39.4-45.9 72.8-46.4 73.2-6.6 7-8.4 17.2-4.6 26S78.4 480 88 480c61.5 0 110-25.7 139.1-46.3C256 442.8 287.2 448 320 448c37.5 0 73-6.7 105.1-18.5l-46.2-36.2c-18.7 4.3-38.5 6.7-58.9 6.7zm314 71L481.6 351.8l-6.8-5.3L36 3.5C29.1-2 19-.9 13.5 6l-10 12.5C-2 25.4-.9 35.5 6 41l598 467.5c6.9 5.5 17 4.4 22.5-2.5l10-12.5c5.5-6.9 4.4-17-2.5-22.5z"]
};
var faCommentSmile = {
  prefix: 'far',
  iconName: 'comment-smile',
  icon: [512, 512, [], "f4b4", "M325.8 272.2C308.5 292.4 283.1 304 256 304s-52.5-11.6-69.8-31.8c-8.6-10.1-23.8-11.2-33.8-2.7-10.1 8.6-11.2 23.8-2.7 33.8 26.5 31 65.2 48.7 106.3 48.7s79.8-17.8 106.2-48.7c8.6-10.1 7.4-25.2-2.7-33.8-10-8.6-25.1-7.4-33.7 2.7zM192 224c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faCommentTimes = {
  prefix: 'far',
  iconName: 'comment-times',
  icon: [512, 512, [], "f4b5", "M329.5 177.8l-11.3-11.3c-6.2-6.2-16.4-6.2-22.6 0L256 206.1l-39.6-39.6c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-6.2 6.2-6.2 16.4 0 22.6l39.6 39.6-39.6 39.6c-6.2 6.2-6.2 16.4 0 22.6l11.3 11.3c6.2 6.2 16.4 6.2 22.6 0l39.6-39.6 39.6 39.6c6.2 6.2 16.4 6.2 22.6 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6L289.9 240l39.6-39.6c6.3-6.2 6.3-16.4 0-22.6zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"]
};
var faComments = {
  prefix: 'far',
  iconName: 'comments',
  icon: [576, 512, [], "f086", "M532 386.2c27.5-27.1 44-61.1 44-98.2 0-80-76.5-146.1-176.2-157.9C368.3 72.5 294.3 32 208 32 93.1 32 0 103.6 0 192c0 37 16.5 71 44 98.2-15.3 30.7-37.3 54.5-37.7 54.9-6.3 6.7-8.1 16.5-4.4 25 3.6 8.5 12 14 21.2 14 53.5 0 96.7-20.2 125.2-38.8 9.2 2.1 18.7 3.7 28.4 4.9C208.1 407.6 281.8 448 368 448c20.8 0 40.8-2.4 59.8-6.8C456.3 459.7 499.4 480 553 480c9.2 0 17.5-5.5 21.2-14 3.6-8.5 1.9-18.3-4.4-25-.4-.3-22.5-24.1-37.8-54.8zm-392.8-92.3L122.1 305c-14.1 9.1-28.5 16.3-43.1 21.4 2.7-4.7 5.4-9.7 8-14.8l15.5-31.1L77.7 256C64.2 242.6 48 220.7 48 192c0-60.7 73.3-112 160-112s160 51.3 160 112-73.3 112-160 112c-16.5 0-33-1.9-49-5.6l-19.8-4.5zM498.3 352l-24.7 24.4 15.5 31.1c2.6 5.1 5.3 10.1 8 14.8-14.6-5.1-29-12.3-43.1-21.4l-17.1-11.1-19.9 4.6c-16 3.7-32.5 5.6-49 5.6-54 0-102.2-20.1-131.3-49.7C338 339.5 416 272.9 416 192c0-3.4-.4-6.7-.7-10C479.7 196.5 528 238.8 528 288c0 28.7-16.2 50.6-29.7 64z"]
};
var faCommentsAlt = {
  prefix: 'far',
  iconName: 'comments-alt',
  icon: [576, 512, [], "f4b6", "M512 160h-96V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64v160c0 35.3 28.7 64 64 64h32v52c0 7.1 5.8 12 12 12 2.4 0 4.9-.7 7.1-2.4l76.9-43.5V384c0 35.3 28.7 64 64 64h96l108.9 61.6c2.2 1.6 4.7 2.4 7.1 2.4 6.2 0 12-4.9 12-12v-52h32c35.3 0 64-28.7 64-64V224c0-35.3-28.7-64-64-64zM96 240H64c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16h288c8.8 0 16 7.2 16 16v160c0 8.8-7.2 16-16 16H211.4l-11 6.2-56.4 31.9V240H96zm432 144c0 8.8-7.2 16-16 16h-80v38.1l-56.4-31.9-11-6.2H256c-8.8 0-16-7.2-16-16v-96h112c35.3 0 64-28.7 64-64v-16h96c8.8 0 16 7.2 16 16v160z"]
};
var faCommentsAltDollar = {
  prefix: 'far',
  iconName: 'comments-alt-dollar',
  icon: [576, 512, [], "f652", "M512 160h-96V64c0-35.35-28.65-64-64-64H64C28.65 0 0 28.65 0 64v208c0 35.35 28.65 64 64 64h32v51.98c0 7.1 5.83 12.02 12.05 12.02 2.41 0 4.87-.74 7.08-2.37L192 354.12V384c0 35.35 28.65 64 64 64h96l108.87 61.63c2.21 1.63 4.68 2.37 7.08 2.37 6.22 0 12.05-4.92 12.05-12.02V448h32c35.35 0 64-28.65 64-64V224c0-35.35-28.65-64-64-64zM200.35 294.23L144 326.13V288H64c-8.82 0-16-7.18-16-16V64c0-8.82 7.18-16 16-16h288c8.82 0 16 7.18 16 16v208c0 8.82-7.18 16-16 16H211.36l-11.01 6.23zM528 384c0 8.82-7.18 16-16 16h-80v38.13l-56.35-31.9-11-6.23H256c-8.82 0-16-7.18-16-16v-48h112c35.35 0 64-28.65 64-64v-64h96c8.82 0 16 7.18 16 16v160zM233.28 158.28l-42.19-11.44c-4.19-1.14-7.09-4.55-7.09-8.3 0-4.8 4.5-8.7 10.06-8.7h26.34c4.15 0 8.23 1.04 11.77 2.95 3.08 1.66 6.84 1.37 9.24-1.18l12.07-12.73c3.11-3.28 2.6-8.64-1.13-11.19-8.3-5.65-18.06-8.88-28.35-9.52V88c0-4.42-3.58-8-8-8h-16c-4.42 0-8 3.58-8 8v10.25c-22.18 1.1-40 18.57-40 40.3 0 18.17 12.62 34.28 30.72 39.17l42.19 11.44c4.19 1.14 7.09 4.55 7.09 8.3 0 4.8-4.5 8.7-10.06 8.7H195.6c-4.15 0-8.23-1.04-11.77-2.95-3.08-1.67-6.84-1.37-9.24 1.18l-12.07 12.73c-3.11 3.28-2.6 8.64 1.13 11.19 8.3 5.65 18.06 8.88 28.35 9.52V248c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-10.25c22.18-1.1 40-18.57 40-40.3 0-18.17-12.62-34.28-30.72-39.17z"]
};
var faCommentsDollar = {
  prefix: 'far',
  iconName: 'comments-dollar',
  icon: [576, 512, [], "f653", "M532.01 386.17C559.48 359.05 576 325.04 576 288c0-80.02-76.45-146.13-176.18-157.94C368.35 72.46 294.32 32 208 32 93.12 32 0 103.64 0 192c0 37.04 16.52 71.05 43.99 98.17-15.3 30.74-37.34 54.53-37.7 54.89-6.31 6.69-8.05 16.53-4.42 24.99A23.085 23.085 0 0 0 23.06 384c53.54 0 96.67-20.24 125.17-38.78 9.21 2.12 18.69 3.74 28.37 4.89C208.11 407.58 281.8 448 368 448c20.79 0 40.83-2.41 59.77-6.78C456.27 459.76 499.4 480 552.94 480c9.22 0 17.55-5.5 21.18-13.96 3.64-8.46 1.89-18.3-4.42-24.99-.35-.36-22.39-24.14-37.69-54.88zm-372.99-87.72l-19.87-4.58-17.09 11.12c-14.07 9.15-28.46 16.29-43.1 21.41a258.5 258.5 0 0 0 8-14.84l15.49-31.12-24.74-24.42C64.16 242.63 48 220.66 48 192c0-60.71 73.27-112 160-112s160 51.29 160 112-73.27 112-160 112c-16.52 0-33-1.87-48.98-5.55zm339.27 53.56l-24.74 24.42 15.49 31.12c2.56 5.15 5.26 10.11 8 14.84-14.64-5.11-29.03-12.26-43.1-21.4l-17.09-11.12-19.87 4.58A218.576 218.576 0 0 1 368 400c-53.96 0-102.22-20.06-131.3-49.7C337.96 339.53 416 272.86 416 192c0-3.37-.39-6.66-.65-9.97C479.7 196.49 528 238.85 528 288c0 28.66-16.16 50.63-29.71 64.01zM233.28 182.28l-42.19-11.44c-4.19-1.14-7.09-4.55-7.09-8.3 0-4.8 4.5-8.7 10.06-8.7h26.34c4.15 0 8.23 1.04 11.77 2.95 3.08 1.66 6.84 1.37 9.24-1.18l12.07-12.73c3.11-3.28 2.6-8.64-1.13-11.19-8.3-5.65-18.06-8.88-28.35-9.52V112c0-4.42-3.58-8-8-8h-16c-4.42 0-8 3.58-8 8v10.25c-22.18 1.1-40 18.57-40 40.3 0 18.17 12.62 34.28 30.72 39.17l42.19 11.44c4.19 1.14 7.09 4.55 7.09 8.3 0 4.8-4.5 8.7-10.06 8.7H195.6c-4.15 0-8.23-1.04-11.77-2.95-3.08-1.67-6.84-1.37-9.24 1.18l-12.07 12.73c-3.11 3.28-2.6 8.64 1.13 11.19 8.3 5.65 18.06 8.88 28.35 9.52V272c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-10.25c22.18-1.1 40-18.57 40-40.3 0-18.17-12.62-34.28-30.72-39.17z"]
};
var faCompactDisc = {
  prefix: 'far',
  iconName: 'compact-disc',
  icon: [496, 512, [], "f51f", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm0-360c-88.2 0-160 71.8-160 160h32c0-70.6 57.4-128 128-128V96zm0 72c-48.6 0-88 39.4-88 88s39.4 88 88 88 88-39.4 88-88-39.4-88-88-88zm0 120c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32z"]
};
var faCompass = {
  prefix: 'far',
  iconName: 'compass',
  icon: [496, 512, [], "f14e", "M347.94 129.86L203.6 195.83a31.938 31.938 0 0 0-15.77 15.77l-65.97 144.34c-7.61 16.65 9.54 33.81 26.2 26.2l144.34-65.97a31.938 31.938 0 0 0 15.77-15.77l65.97-144.34c7.61-16.66-9.54-33.81-26.2-26.2zm-77.36 148.72c-12.47 12.47-32.69 12.47-45.16 0-12.47-12.47-12.47-32.69 0-45.16 12.47-12.47 32.69-12.47 45.16 0 12.47 12.47 12.47 32.69 0 45.16zM248 8C111.03 8 0 119.03 0 256s111.03 248 248 248 248-111.03 248-248S384.97 8 248 8zm0 448c-110.28 0-200-89.72-200-200S137.72 56 248 56s200 89.72 200 200-89.72 200-200 200z"]
};
var faCompassSlash = {
  prefix: 'far',
  iconName: 'compass-slash',
  icon: [640, 512, [], "f5e9", "M633.99 471.02L36 3.51C29.1-2.01 19.03-.9 13.51 6l-10 12.49C-2.02 25.39-.9 35.46 6 40.98l598 467.51c6.9 5.52 16.96 4.4 22.49-2.49l10-12.49c5.52-6.9 4.41-16.97-2.5-22.49zM320 56c110.28 0 200 89.72 200 200 0 20.23-3.07 39.75-8.69 58.18l39.84 31.15C561.88 317.58 568 287.53 568 256 568 119.03 456.97 8 320 8c-53.08 0-102.15 16.82-142.49 45.21l40.06 31.32C247.58 66.54 282.54 56 320 56zm99.94 73.86l-91.12 41.65 81.23 63.51 36.09-78.96c7.61-16.66-9.54-33.81-26.2-26.2zM220.06 382.14l91.13-41.65-81.23-63.51-36.09 78.96c-7.62 16.65 9.53 33.81 26.19 26.2zM320 456c-110.28 0-200-89.72-200-200 0-20.24 3.08-39.76 8.69-58.18l-39.84-31.15C78.12 194.42 72 224.47 72 256c0 136.97 111.03 248 248 248 53.08 0 102.15-16.82 142.49-45.22l-40.06-31.32C392.42 445.46 357.46 456 320 456z"]
};
var faCompress = {
  prefix: 'far',
  iconName: 'compress',
  icon: [448, 512, [], "f066", "M436 192H312c-13.3 0-24-10.7-24-24V44c0-6.6 5.4-12 12-12h24c6.6 0 12 5.4 12 12v100h100c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12zm-276-24V44c0-6.6-5.4-12-12-12h-24c-6.6 0-12 5.4-12 12v100H12c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h124c13.3 0 24-10.7 24-24zm0 300V344c0-13.3-10.7-24-24-24H12c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h100v100c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12zm176 0V368h100c6.6 0 12-5.4 12-12v-24c0-6.6-5.4-12-12-12H312c-13.3 0-24 10.7-24 24v124c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12z"]
};
var faCompressAlt = {
  prefix: 'far',
  iconName: 'compress-alt',
  icon: [448, 512, [], "f422", "M224 232v-95.005c0-21.382 25.851-32.09 40.971-16.971l27.704 27.704L404.888 35.515c4.686-4.686 12.284-4.686 16.971 0l22.627 22.627c4.686 4.686 4.686 12.284 0 16.971L332.272 187.326l27.704 27.704c15.119 15.119 4.411 40.97-16.971 40.97H248c-13.255 0-24-10.745-24-24zM43.112 476.485l112.213-112.213 27.704 27.704c15.12 15.119 40.971 4.411 40.971-16.971V280c0-13.255-10.745-24-24-24h-95.005c-21.382 0-32.09 25.851-16.971 40.971l27.704 27.704L3.515 436.888c-4.686 4.686-4.686 12.284 0 16.971l22.627 22.627c4.686 4.686 12.284 4.686 16.97-.001z"]
};
var faCompressArrowsAlt = {
  prefix: 'far',
  iconName: 'compress-arrows-alt',
  icon: [512, 512, [], "f78c", "M300 224h136c10.7 0 16-12.9 8.4-20.5l-50.9-51L507.3 38.6c6.2-6.2 6.2-16.4 0-22.6L496 4.7c-6.2-6.2-16.4-6.2-22.6 0L359.5 118.6l-51-51C300.9 60 288 65.3 288 76v136c0 6.6 5.4 12 12 12zm93.4 135.5l51-51c7.5-7.6 2.2-20.5-8.5-20.5H300c-6.6 0-12 5.4-12 12v136c0 10.7 12.9 16 20.5 8.4l51-50.9 113.9 113.9c6.2 6.2 16.4 6.2 22.6 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-113.9-114zM212 288H76c-10.7 0-16 12.9-8.4 20.5l50.9 51L4.7 473.4c-6.2 6.2-6.2 16.4 0 22.6L16 507.3c6.2 6.2 16.4 6.2 22.6 0l113.9-113.9 51 51c7.6 7.5 20.5 2.2 20.5-8.5V300c0-6.6-5.4-12-12-12zm-93.4-135.5l-51 51C60 211.1 65.3 224 76 224h136c6.6 0 12-5.4 12-12V76c0-10.7-12.9-16-20.5-8.4l-51 50.9L38.6 4.7c-6.2-6.2-16.4-6.2-22.6 0L4.7 16c-6.2 6.2-6.2 16.4 0 22.6l113.9 113.9z"]
};
var faCompressWide = {
  prefix: 'far',
  iconName: 'compress-wide',
  icon: [512, 512, [], "f326", "M500 224H376c-13.3 0-24-10.7-24-24V76c0-6.6 5.4-12 12-12h24c6.6 0 12 5.4 12 12v100h100c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12zm-340-24V76c0-6.6-5.4-12-12-12h-24c-6.6 0-12 5.4-12 12v100H12c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h124c13.3 0 24-10.7 24-24zm0 236V312c0-13.3-10.7-24-24-24H12c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h100v100c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12zm240 0V336h100c6.6 0 12-5.4 12-12v-24c0-6.6-5.4-12-12-12H376c-13.3 0-24 10.7-24 24v124c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12z"]
};
var faConciergeBell = {
  prefix: 'far',
  iconName: 'concierge-bell',
  icon: [512, 512, [], "f562", "M496 400h-16v-48c0-112.82-83.49-205.89-192-221.46V112h48c8.84 0 16-7.16 16-16V80c0-8.84-7.16-16-16-16H176c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h48v18.54C115.49 146.11 32 239.18 32 352v48H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h480c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zm-64 0H80v-48c0-97.05 78.95-176 176-176s176 78.95 176 176v48z"]
};
var faConstruction = {
  prefix: 'far',
  iconName: 'construction',
  icon: [640, 512, [], "f85d", "M324 216a28 28 0 1 0-28-28 28 28 0 0 0 28 28zm-18.62 140.36l-83-53.67-29.8 109.11a16 16 0 0 0 11.22 19.64 15.8 15.8 0 0 0 4.2.56 16 16 0 0 0 15.43-11.8l18.25-66.89L288 383.23V416a16 16 0 0 0 32 0v-32.77a31.92 31.92 0 0 0-14.62-26.87zm135-9.26l-14 20.86L358.31 326l-10.53-52.75c-3.75-18.61-18.13-33.3-35.56-37.12l-24.59-7.3a48 48 0 0 0-48.78 18l-11.62 15.48a16 16 0 0 0 4.41 23.23l103.92 64 .09.07 70.67 43.48H385a19.13 19.13 0 0 0-18.21 12.51l-9.2 26.4h163.89l-54.32-84.64a16 16 0 0 0-26.75-.26zm190.67 80.78L367.37 25.3a57 57 0 0 0-94.71 0L8.89 427.89a52.87 52.87 0 0 0-2.31 54.88A56.23 56.23 0 0 0 56.29 512h527.45a56.23 56.23 0 0 0 49.71-29.27 52.82 52.82 0 0 0-2.37-54.85zm-39.84 32c-.66 1.24-2.72 4.08-7.5 4.08H56.29c-4.78 0-6.84-2.84-7.5-4.06a5.25 5.25 0 0 1 .25-5.75l263.77-402.6a9.06 9.06 0 0 1 14.41 0L591 454.19a5.27 5.27 0 0 1 .24 5.73z"]
};
var faContainerStorage = {
  prefix: 'far',
  iconName: 'container-storage',
  icon: [640, 512, [], "f4b7", "M640 64V48c0-8.8-7.2-16-16-16H16C7.2 32 0 39.2 0 48v16c0 8.8 7.2 16 16 16v352c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h608c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16V80c8.8 0 16-7.2 16-16zm-64 368H64V80h512v352zm-440-48h32c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-32c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8zm224 0h32c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-32c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8zm112 0h32c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-32c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8zm-224 0h32c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8h-32c-4.4 0-8 3.6-8 8v240c0 4.4 3.6 8 8 8z"]
};
var faConveyorBelt = {
  prefix: 'far',
  iconName: 'conveyor-belt',
  icon: [640, 512, [], "f46e", "M544 320H96c-53 0-96 43-96 96s43 96 96 96h448c53 0 96-43 96-96s-43-96-96-96zm0 144H96c-26.5 0-48-21.5-48-48s21.5-48 48-48h448c26.5 0 48 21.5 48 48s-21.5 48-48 48zm-416-80c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm384 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-176-96h352c8.8 0 16-7.2 16-16V16c0-8.8-7.2-16-16-16H144c-8.8 0-16 7.2-16 16v256c0 8.8 7.2 16 16 16zm32-240h80v112l64-32 64 32V48h80v192H176V48z"]
};
var faConveyorBeltAlt = {
  prefix: 'far',
  iconName: 'conveyor-belt-alt',
  icon: [640, 512, [], "f46f", "M544 320H96c-53 0-96 43-96 96s43 96 96 96h448c53 0 96-43 96-96s-43-96-96-96zm0 144H96c-26.5 0-48-21.5-48-48s21.5-48 48-48h448c26.5 0 48 21.5 48 48s-21.5 48-48 48zm-416-80c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm384 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-208-96h416c8.8 0 16-7.2 16-16V80c0-8.8-7.2-16-16-16H384V16c0-8.8-7.2-16-16-16H112c-8.8 0-16 7.2-16 16v256c0 8.8 7.2 16 16 16zm272-176h112v128H384V112zM144 48h192v192H144V48z"]
};
var faCookie = {
  prefix: 'far',
  iconName: 'cookie',
  icon: [512, 512, [], "f563", "M352 320c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm-32-160c17.67 0 32-14.33 32-32s-14.33-32-32-32-32 14.33-32 32 14.33 32 32 32zm-128 32c0-17.67-14.33-32-32-32s-32 14.33-32 32 14.33 32 32 32 32-14.33 32-32zm0 128c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm96-96c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm222.37 30.79l-12.08-76.26a132.493 132.493 0 0 0-37.16-72.95l-54.76-54.75c-19.73-19.72-45.18-32.7-72.71-37.05l-76.7-12.15A131.26 131.26 0 0 0 236.34 0c-20.72 0-41.25 4.88-59.89 14.38l-69.12 35.21a132.25 132.25 0 0 0-57.79 57.8l-35.1 68.87A132.602 132.602 0 0 0 1.62 257.2l12.08 76.27a132.493 132.493 0 0 0 37.16 72.95l54.76 54.75a132.087 132.087 0 0 0 72.71 37.05l76.7 12.14c6.86 1.09 13.75 1.62 20.63 1.62 20.72 0 41.25-4.88 59.88-14.38l69.12-35.21a132.302 132.302 0 0 0 57.79-57.8l35.1-68.87a132.56 132.56 0 0 0 12.82-80.93zm-55.59 59.15l-35.1 68.88c-8.13 15.97-20.86 28.7-36.81 36.82l-69.12 35.21C302 460.83 288.83 464 275.66 464a84.8 84.8 0 0 1-13.12-1.03l-76.69-12.14c-17.63-2.79-33.64-10.95-46.28-23.59l-54.76-54.76c-12.69-12.68-20.88-28.77-23.69-46.51L49.04 249.7c-2.81-17.76.01-35.62 8.18-51.64l35.1-68.88c8.13-15.97 20.86-28.7 36.81-36.82l69.12-35.21C210 51.17 223.17 48 236.35 48c4.38 0 8.79.35 13.12 1.03l76.7 12.15c17.63 2.79 33.63 10.95 46.27 23.59l54.76 54.75c12.69 12.69 20.88 28.77 23.69 46.52l12.08 76.26c2.8 17.76-.02 35.62-8.19 51.64z"]
};
var faCookieBite = {
  prefix: 'far',
  iconName: 'cookie-bite',
  icon: [512, 512, [], "f564", "M352 320c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zM192 192c0-17.67-14.33-32-32-32s-32 14.33-32 32 14.33 32 32 32 32-14.33 32-32zm0 128c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm96-96c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm222.52 31.82c-69.97-.85-126.47-57.69-126.47-127.86-70.17 0-127-56.49-127.86-126.45C249.57.5 242.9 0 236.26 0c-20.68 0-41.18 4.85-59.79 14.33l-69.13 35.22a132.221 132.221 0 0 0-57.79 57.81l-35.1 68.88a132.645 132.645 0 0 0-12.82 80.95l12.08 76.28a132.555 132.555 0 0 0 37.16 72.96l54.77 54.76a132.036 132.036 0 0 0 72.71 37.06l76.71 12.14c6.86 1.09 13.76 1.62 20.64 1.62 20.72 0 41.25-4.88 59.89-14.38l69.13-35.22a132.221 132.221 0 0 0 57.79-57.81l35.1-68.88c12.56-24.63 17.01-52.57 12.91-79.9zm-55.68 58.1l-35.1 68.88c-8.14 15.97-20.87 28.7-36.81 36.83l-69.13 35.22c-11.74 5.98-24.92 9.15-38.1 9.15-4.38 0-8.8-.35-13.13-1.03l-76.71-12.14c-17.64-2.79-33.64-10.95-46.28-23.59l-54.77-54.76c-12.69-12.69-20.88-28.77-23.69-46.52l-12.08-76.27c-2.81-17.77.01-35.62 8.18-51.64l35.1-68.88c8.14-15.97 20.87-28.71 36.81-36.83l69.13-35.22c5.52-2.81 11.36-5 17.38-6.52 17.83 58.88 65.85 104.96 125.69 120.09 15.12 59.85 61.22 107.87 120.11 125.69a83.485 83.485 0 0 1-6.6 17.54z"]
};
var faCopy = {
  prefix: 'far',
  iconName: 'copy',
  icon: [448, 512, [], "f0c5", "M433.941 65.941l-51.882-51.882A48 48 0 0 0 348.118 0H176c-26.51 0-48 21.49-48 48v48H48c-26.51 0-48 21.49-48 48v320c0 26.51 21.49 48 48 48h224c26.51 0 48-21.49 48-48v-48h80c26.51 0 48-21.49 48-48V99.882a48 48 0 0 0-14.059-33.941zM266 464H54a6 6 0 0 1-6-6V150a6 6 0 0 1 6-6h74v224c0 26.51 21.49 48 48 48h96v42a6 6 0 0 1-6 6zm128-96H182a6 6 0 0 1-6-6V54a6 6 0 0 1 6-6h106v88c0 13.255 10.745 24 24 24h88v202a6 6 0 0 1-6 6zm6-256h-64V48h9.632c1.591 0 3.117.632 4.243 1.757l48.368 48.368a6 6 0 0 1 1.757 4.243V112z"]
};
var faCopyright = {
  prefix: 'far',
  iconName: 'copyright',
  icon: [512, 512, [], "f1f9", "M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 448c-110.532 0-200-89.451-200-200 0-110.531 89.451-200 200-200 110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200zm107.351-101.064c-9.614 9.712-45.53 41.396-104.065 41.396-82.43 0-140.484-61.425-140.484-141.567 0-79.152 60.275-139.401 139.762-139.401 55.531 0 88.738 26.62 97.593 34.779a11.965 11.965 0 0 1 1.936 15.322l-18.155 28.113c-3.841 5.95-11.966 7.282-17.499 2.921-8.595-6.776-31.814-22.538-61.708-22.538-48.303 0-77.916 35.33-77.916 80.082 0 41.589 26.888 83.692 78.277 83.692 32.657 0 56.843-19.039 65.726-27.225 5.27-4.857 13.596-4.039 17.82 1.738l19.865 27.17a11.947 11.947 0 0 1-1.152 15.518z"]
};
var faCorn = {
  prefix: 'far',
  iconName: 'corn',
  icon: [512, 512, [], "f6c7", "M441.79.32c-2.07-.2-4.57-.32-7.04-.32-12.1 0-23.73 2.82-34.13 8.01-3.53-.5-7.11-.75-10.72-.75-7.27 0-14.52 1.05-21.53 3.12a76.524 76.524 0 0 0-25.45 12.79c-9.17.42-18.11 2.45-26.63 6.07-8.9 4.01-16.77 9.4-23.38 15.86a76.438 76.438 0 0 0-26.06 9.58c-7.6 4.3-14.32 9.96-19.91 16.61-8.69 2.35-16.93 6.25-24.4 11.58-5.01 3.53-8.85 8.24-12.81 12.8-4.79-5.68-9.5-11.39-14.94-16.82L152.63 36.7c-9.01-9.01-24.43-4.34-26.93 8.15L98.51 180.72l-61.48 61.46c-47.25 47.23-49.15 122.14-6.51 171.46l60.7 61.97c27.39 27.38 65.59 40.41 105.41 35.3 29.25-3.75 55.89-18.9 76.75-39.75l57.83-57.81 135.93-27.18c12.5-2.5 17.17-17.91 8.15-26.92l-42.16-42.15c-5.32-5.32-10.89-10.28-16.62-14.96 3.61-3.4 7.61-6.35 10.55-10.46 5.29-7.4 9.13-15.55 11.49-24.04a76.011 76.011 0 0 0 17.39-20.81c4.6-7.74 7.69-16.19 9.24-24.91a76.238 76.238 0 0 0 15.55-22.55c3.97-8.82 6.19-18.12 6.68-27.45a77.528 77.528 0 0 0 12.88-24.7 78.082 78.082 0 0 0 2.61-31.7 77.244 77.244 0 0 0 8.93-32.94l.04-1v-1c2.4-41.1-28.34-76.61-70.08-80.26zM64.38 379.79c-24.07-30.62-21.7-75.58 6.5-103.78l71.73-71.7 18.33-91.64c45.96 45.94 62.27 102.09 48.95 155.23-33.79 12.01-65.48 31.89-92.77 59.17l-52.74 52.72zm243.24-10.53l-71.73 71.7c-30.38 30.37-80.44 31.18-110.82.81l-27.5-27.49 53.39-53.37c37.92-37.91 86.06-58.39 133.48-58.39 41.21 0 81.88 15.47 114.84 48.42l-91.66 18.32zM447.95 105.4c6.45 7.13 9.43 17.47 6.45 27.58-3 9.65-10.59 16.78-19.55 19.53 5.05 7.82 6.21 17.93 2.07 27.12-4.14 9.19-12.42 14.94-21.61 16.55 4.14 8.27 3.91 18.38-1.14 26.89-4.84 8.51-13.57 13.56-22.77 14.25 3.22 8.5 2.3 18.38-3.44 26.43-4.12 5.77-10.05 8.77-16.29 10.44-27.19-12.65-56.74-19.53-87.22-19.53-7.91 0-15.79.47-23.62 1.32 4.84-38.96-2.36-78.56-21.29-115.62 1.36-7.19 4.66-13.99 10.93-18.41 9.49-6.78 20.02-5.96 26.66-3.46.69-8.96 5.75-17.7 14.26-22.53 13.58-8.05 26.54-1.31 26.9-1.14 1.61-8.97 7.59-17.24 16.78-21.38 11.56-4.9 21.83-1.13 27.13 2.3 2.76-9.19 10.11-16.54 19.77-19.3 2.58-.76 16.01-4.31 27.59 6.89 23.37-44.68 85.4 17.95 38.39 42.07z"]
};
var faCouch = {
  prefix: 'far',
  iconName: 'couch',
  icon: [640, 512, [], "f4b8", "M576 196.6V128c0-53-43-96-96-96H160c-53 0-96 43-96 96v68.6C29.4 207.3 3.1 236.9.3 273-2 302 9.9 329.5 32 347.6V440c0 22.1 17.9 40 40 40h88c4 0 30.2-.9 31.9-32h256.2c1.4 30.8 28 32 31.9 32h88c22.1 0 40-17.9 40-40v-92.4c22-18.1 34-45.5 31.7-74.6-2.8-36.1-29.1-65.7-63.7-76.4zM144 432H80V321.3l-11.9-7C54.6 306.5 47 292 48.2 276.7 49.7 256.5 69.4 240 92 240h12c22.1 0 40 17.9 40 40v152zm304-128v96H192v-96h256zm3.7-48H188.2c-9.8-34.3-39.7-59.8-76.2-63.2V128c0-26.5 21.5-48 48-48h320c26.5 0 48 21.5 48 48v64.8c-36.6 3.4-66.5 28.9-76.3 63.2zm120.2 58.4l-11.9 7V432h-64V280c0-22.1 17.9-40 40-40h12c22.6 0 42.3 16.5 43.9 36.8 1.1 15.3-6.5 29.7-20 37.6z"]
};
var faCow = {
  prefix: 'far',
  iconName: 'cow',
  icon: [640, 512, [], "f6c8", "M624.48 237.99l-16.51-19.15v-42.82c0-11.89-12.52-19.63-23.15-14.31-6.08 3.04-11.32 7.1-16.1 11.58l-59.99-69.6A96.044 96.044 0 0 0 430.96 64H111.99c-48.6 0-88 39.4-88 88v86.41C9.48 250.14 0 267.88 0 288v32c39.76 0 72-32.24 72-72v-96c0-16.88 10.57-31.18 25.38-37.04-.87 4.21-1.35 8.57-1.35 13.04v288c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-39.98c2.55.87 5.4 1.3 8.04 2.05V392c0 8.84 7.16 16 16 16s16-7.16 16-16v-8.68c2.68.15 13.27.14 16-.01V392c0 8.84 7.16 16 16 16s16-7.16 16-16v-13.98c2.62-.74 5.44-1.17 7.96-2.03V416c0 17.67 14.33 32 32 32h63.96c17.67 0 31.99-14.32 32-31.99l.04-143.97L463.97 288v41.98c0 12.32 3.56 24.38 10.24 34.73l35.46 54.89a62.08 62.08 0 0 0 52.14 28.4H576c35.34 0 64-28.65 64-64V279.78c0-15.34-5.51-30.17-15.52-41.79zm-414.37 82.58c6.95-27.82 31.97-48.57 61.9-48.57 29.92 0 54.92 20.73 61.89 48.53-61.3 20.93-62.19 21.03-123.79.04zM592 384c0 8.82-7.18 16-16 16h-14.19c-4.8 0-9.22-2.41-11.83-6.44l-35.46-54.9c-.87-2.95-1.69-5.72-2.56-8.68v-61.87l-75.77-75.77c-13.35-13.35-36.17-3.9-36.17 14.98L399.98 400h-31.97v-64c0-45.59-38.14-96-95.99-96-58.15 0-95.99 50.69-95.99 96v64h-32V128c0-8.82 7.18-16 16-16h4.32c.8 1.5 25.36 34.82 25.36 34.82C211.52 175.75 241.1 192 271.94 192h.17c30.84 0 60.42-16.25 82.23-45.18 0 0 24.56-33.32 25.36-34.82h51.27c15.34 0 29.87 7.42 38.87 19.85l118.28 137.49c2.5 2.91 3.88 6.62 3.88 10.46V384zm-32-80c-8.84 0-16 7.16-16 16s7.16 16 16 16 16-7.16 16-16-7.16-16-16-16z"]
};
var faCreditCard = {
  prefix: 'far',
  iconName: 'credit-card',
  icon: [576, 512, [], "f09d", "M527.9 32H48.1C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48.1 48h479.8c26.6 0 48.1-21.5 48.1-48V80c0-26.5-21.5-48-48.1-48zM54.1 80h467.8c3.3 0 6 2.7 6 6v42H48.1V86c0-3.3 2.7-6 6-6zm467.8 352H54.1c-3.3 0-6-2.7-6-6V256h479.8v170c0 3.3-2.7 6-6 6zM192 332v40c0 6.6-5.4 12-12 12h-72c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h72c6.6 0 12 5.4 12 12zm192 0v40c0 6.6-5.4 12-12 12H236c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h136c6.6 0 12 5.4 12 12z"]
};
var faCreditCardBlank = {
  prefix: 'far',
  iconName: 'credit-card-blank',
  icon: [576, 512, [], "f389", "M527.9 32H48.1C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48.1 48h479.8c26.6 0 48.1-21.5 48.1-48V80c0-26.5-21.5-48-48.1-48zm-6 400H54.1c-3.3 0-6-2.7-6-6V86c0-3.3 2.7-6 6-6h467.8c3.3 0 6 2.7 6 6v340c0 3.3-2.7 6-6 6zM192 364v8c0 6.6-5.4 12-12 12h-72c-6.6 0-12-5.4-12-12v-8c0-6.6 5.4-12 12-12h72c6.6 0 12 5.4 12 12zm192 0v8c0 6.6-5.4 12-12 12H236c-6.6 0-12-5.4-12-12v-8c0-6.6 5.4-12 12-12h136c6.6 0 12 5.4 12 12z"]
};
var faCreditCardFront = {
  prefix: 'far',
  iconName: 'credit-card-front',
  icon: [576, 512, [], "f38a", "M527.9 32H48.1C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48.1 48h479.8c26.6 0 48.1-21.5 48.1-48V80c0-26.5-21.5-48-48.1-48zm-6 400H54.1c-3.3 0-6-2.7-6-6V86c0-3.3 2.7-6 6-6h467.8c3.3 0 6 2.7 6 6v340c0 3.3-2.7 6-6 6zM192 364v8c0 6.6-5.4 12-12 12h-72c-6.6 0-12-5.4-12-12v-8c0-6.6 5.4-12 12-12h72c6.6 0 12 5.4 12 12zm192 0v8c0 6.6-5.4 12-12 12H236c-6.6 0-12-5.4-12-12v-8c0-6.6 5.4-12 12-12h136c6.6 0 12 5.4 12 12zm-124-44h-56c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v40c0 6.6-5.4 12-12 12zm28-12v-40c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v40c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12zm-192 0v-40c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12v40c0 6.6-5.4 12-12 12h-56c-6.6 0-12-5.4-12-12zm384-40v40c0 6.6-5.4 12-12 12h-72c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h72c6.6 0 12 5.4 12 12zm0-132v48c0 13.3-10.7 24-24 24h-80c-13.3 0-24-10.7-24-24v-48c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24z"]
};
var faCricket = {
  prefix: 'far',
  iconName: 'cricket',
  icon: [640, 512, [], "f449", "M635.7 31.9l-15.2-21.6c-7.6-10.8-22.6-13.5-33.4-5.9L442.6 105.9c-14.5 10.1-34.4 6.6-44.5-7.8L385.4 80c-9.9-14-29.7-18.2-44.5-7.8L13.8 300.7C4.9 306.9-.7 317.2.1 328c5.6 79.3 54.7 149.2 127.4 181.6 15.4 6.9 28.9-2.5 30.4-3.5L485 277.6c14.5-10.1 18-30 7.9-44.4l-15.3-21.8c-10.1-14.4-6.6-34.3 7.9-44.4L629.8 65.2c10.8-7.6 13.5-22.5 5.9-33.3zM138 461.5c-48.8-25.3-82-72.6-89.1-126.9l224.8-157.1-19.1 107.9 108.2 19L138 461.5zM437.8 252l-37.9 26.5-108.2-19 19.1-107.9 37.9-26.5c3.6-2.5 8.6-1.6 11.1 2L439.7 241c2.6 3.5 1.7 8.5-1.9 11zm73.8 68.5c-52.9 0-95.9 42.9-95.9 95.7s43 95.7 95.9 95.7 95.9-42.9 95.9-95.7-43-95.7-95.9-95.7zm0 143.6c-26.4 0-48-21.5-48-47.9s21.5-47.9 48-47.9c26.4 0 48 21.5 48 47.9 0 26.5-21.5 47.9-48 47.9z"]
};
var faCroissant = {
  prefix: 'far',
  iconName: 'croissant',
  icon: [512, 512, [], "f7f6", "M507.72 168a161 161 0 0 0-73.48-84 71.07 71.07 0 0 0-26.18-42.49A203.31 203.31 0 0 0 285.49 0a199 199 0 0 0-46.12 5.77 72.23 72.23 0 0 0-46-3.57A262.32 262.32 0 0 0 2.13 193.38a73 73 0 0 0 3.5 45.5 201.29 201.29 0 0 0 35.73 168.36 71 71 0 0 0 41.5 25.95 161.71 161.71 0 0 0 85.06 74.52c46.79 17.71 95.34-22 87.11-71.4l-15.85-95.07a69.94 69.94 0 0 0 4.32-5.7 72.79 72.79 0 0 0 48.24-21.17l22.64-22.62c12.94-12.94 19.78-29.95 20.85-47.58a69.1 69.1 0 0 0 6.62-4.83l94.45 15.74c49.82 8.3 89.02-40.72 71.42-87.08zM111.81 382.26c-11.51 9-25.79 4.39-32.28-4.12-21.85-28.64-31.86-63.25-30.84-97.94 1.1.39 2.06 1 3.18 1.33l135.28 41.61zm73.13 80.58a113.44 113.44 0 0 1-50.43-38.27 70.28 70.28 0 0 0 6.94-4.56l55-43.16 11.23 67.35a17 17 0 0 1-22.74 18.64zm95.49-205l-22.62 22.62a25.57 25.57 0 0 1-25.6 6.36L66 235.66A25.58 25.58 0 0 1 48.7 205 214.41 214.41 0 0 1 205 48.76 25.57 25.57 0 0 1 235.64 66l51.15 166.18a25.56 25.56 0 0 1-6.36 25.63zm42.95-69.89l-41.85-136c-.39-1.24-1-2.36-1.42-3.56 1.79-.08 3.58-.38 5.37-.38a154 154 0 0 1 93.46 31.63c8.58 6.54 13.08 20.85 4.12 32.27zm120.82 19.79l-66.64-11.1 43.26-55.12a69.1 69.1 0 0 0 4.31-6.55 113.54 113.54 0 0 1 37.71 50 17 17 0 0 1-18.64 22.77z"]
};
var faCrop = {
  prefix: 'far',
  iconName: 'crop',
  icon: [512, 512, [], "f125", "M496 352h-80V141.25l91.31-91.31c6.25-6.25 6.25-16.38 0-22.63L484.69 4.69c-6.25-6.25-16.38-6.25-22.63 0L370.75 96H192v64h114.75L160 306.75V16c0-8.84-7.16-16-16-16h-32c-8.84 0-16 7.16-16 16v80H16c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16h80v224c0 17.67 14.33 32 32 32h192v-64H205.25L352 205.25V496c0 8.84 7.16 16 16 16h32c8.84 0 16-7.16 16-16v-80h80c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16z"]
};
var faCropAlt = {
  prefix: 'far',
  iconName: 'crop-alt',
  icon: [512, 512, [], "f565", "M160 16c0-8.84-7.16-16-16-16h-32c-8.84 0-16 7.16-16 16v80H16c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16h80v224c0 17.67 14.33 32 32 32h192v-64H160V16zm336 336h-80V128c0-17.67-14.33-32-32-32H192v64h160v336c0 8.84 7.16 16 16 16h32c8.84 0 16-7.16 16-16v-80h80c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16z"]
};
var faCross = {
  prefix: 'far',
  iconName: 'cross',
  icon: [384, 512, [], "f654", "M344 104h-64V40c0-22.06-17.94-40-40-40h-96c-22.06 0-40 17.94-40 40v64H40c-22.06 0-40 17.94-40 40v96c0 22.06 17.94 40 40 40h64v192c0 22.06 17.94 40 40 40h96c22.06 0 40-17.94 40-40V280h64c22.06 0 40-17.94 40-40v-96c0-22.06-17.94-40-40-40zm-8 128H232v232h-80V232H48v-80h104V48h80v104h104v80z"]
};
var faCrosshairs = {
  prefix: 'far',
  iconName: 'crosshairs',
  icon: [512, 512, [], "f05b", "M500 232h-29.334C459.597 131.885 380.115 52.403 280 41.334V12c0-6.627-5.373-12-12-12h-24c-6.627 0-12 5.373-12 12v29.334C131.885 52.403 52.403 131.885 41.334 232H12c-6.627 0-12 5.373-12 12v24c0 6.627 5.373 12 12 12h29.334C52.403 380.115 131.885 459.597 232 470.666V500c0 6.627 5.373 12 12 12h24c6.627 0 12-5.373 12-12v-29.334C380.115 459.597 459.597 380.115 470.666 280H500c6.627 0 12-5.373 12-12v-24c0-6.627-5.373-12-12-12zM280 422.301V380c0-6.627-5.373-12-12-12h-24c-6.627 0-12 5.373-12 12v42.301C158.427 411.84 100.154 353.532 89.699 280H132c6.627 0 12-5.373 12-12v-24c0-6.627-5.373-12-12-12H89.699C100.16 158.427 158.468 100.154 232 89.699V132c0 6.627 5.373 12 12 12h24c6.627 0 12-5.373 12-12V89.699C353.573 100.16 411.846 158.468 422.301 232H380c-6.627 0-12 5.373-12 12v24c0 6.627 5.373 12 12 12h42.301C411.84 353.573 353.532 411.846 280 422.301zM288 256c0 17.673-14.327 32-32 32s-32-14.327-32-32c0-17.673 14.327-32 32-32s32 14.327 32 32z"]
};
var faCrow = {
  prefix: 'far',
  iconName: 'crow',
  icon: [640, 512, [], "f520", "M448 72c-13.25 0-24 10.74-24 24 0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24zm96-40h-24.91C501.51 12.49 476.32 0 448 0c-53.02 0-96 42.98-96 96v30.16L12.09 393.57A30.216 30.216 0 0 0 0 417.74C0 435.26 14.37 448 30.23 448c4.48 0 9.08-1.02 13.5-3.23L165.27 384h96.49l44.41 120.1c2.27 6.23 9.15 9.44 15.38 7.17l22.55-8.21c6.23-2.27 9.44-9.15 7.17-15.38L312.94 384H352c1.91 0 3.76-.23 5.66-.29l44.51 120.38c2.27 6.23 9.15 9.44 15.38 7.17l22.55-8.21c6.23-2.27 9.44-9.15 7.17-15.38l-41.24-111.53C485.74 352.8 544 279.26 544 192v-80l96-16c0-35.35-42.98-64-96-64zm-48 160c0 79.4-64.6 144-144 144h-77.74l45.33-12.95c48.03-13.73 88.41-47.23 110.72-91.89 3.94-7.91.75-17.52-7.16-21.47-7.91-3.91-17.5-.73-21.47 7.16-18.31 36.66-51.44 64.16-90.91 75.42l-144.93 41.41 215.83-169.8L400 149.47V96c0-26.47 21.53-48 48-48s48 21.53 48 48v96z"]
};
var faCrown = {
  prefix: 'far',
  iconName: 'crown',
  icon: [640, 512, [], "f521", "M528 464H112c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h416c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm64-336c-26.5 0-48 21.5-48 48 0 7.1 1.6 13.7 4.4 19.8L476 239.2c-5.2 3.1-10.8 4.6-16.4 4.6-11.1 0-21.9-5.8-27.8-16.1L350.3 85C361 76.2 368 63 368 48c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 15 7 28.2 17.7 37l-81.5 142.6c-5.9 10.4-16.7 16.1-27.8 16.1-5.6 0-11.3-1.5-16.4-4.6l-72.3-43.4c2.7-6 4.4-12.7 4.4-19.8 0-26.5-21.5-48-48-48S0 149.5 0 176s21.5 48 48 48c2.6 0 5.2-.4 7.7-.8L128 416h384l72.3-192.8c2.5.4 5.1.8 7.7.8 26.5 0 48-21.5 48-48s-21.5-48-48-48zM478.7 368H161.3l-36-96.1 14 8.4c12.4 7.5 26.7 11.4 41.1 11.4 28.7 0 55.3-15.4 69.5-40.3L320 128.7l70.1 122.7c14.2 24.9 40.8 40.3 69.5 40.3 14.5 0 28.7-3.9 41.1-11.4l14-8.4-36 96.1z"]
};
var faCrutch = {
  prefix: 'far',
  iconName: 'crutch',
  icon: [512, 512, [], "f7f7", "M507.31 185.59L326.29 4.68a16 16 0 0 0-22.62 0L292.35 16a16 16 0 0 0 0 22.61l181 180.9a16 16 0 0 0 22.63 0l11.31-11.3a16 16 0 0 0 .02-22.62zm-178.75 77.2l-79.19-79.15 71.43-71.38-33.94-33.92-121.14 121a87.62 87.62 0 0 0-23.5 42.43l-28.31 122.47L5.27 472.81a18 18 0 0 0 0 25.44l8.49 8.48a18 18 0 0 0 25.45 0l108.66-108.59 122.5-28.24a87.85 87.85 0 0 0 42.41-23.51l121.16-121.06L400 191.41zm-49.75 49.7a39.75 39.75 0 0 1-19.25 10.66l-91.78 21.18L189 252.59a39.74 39.74 0 0 1 10.69-19.27l15.77-15.76 79.19 79.14z"]
};
var faCrutches = {
  prefix: 'far',
  iconName: 'crutches',
  icon: [640, 512, [], "f7f8", "M635.31 185.59L454.29 4.68a16 16 0 0 0-22.62 0L420.35 16a16 16 0 0 0 0 22.61l181 180.9a16 16 0 0 0 22.63 0l11.31-11.3a16 16 0 0 0 .02-22.62zm-178.75 77.2l-79.19-79.15 71.43-71.38-33.94-33.92-121.14 121a87.62 87.62 0 0 0-23.5 42.43l-28.31 122.47-108.64 108.57a18 18 0 0 0 0 25.44l8.49 8.48a18 18 0 0 0 25.45 0l108.67-108.59 122.49-28.24a87.85 87.85 0 0 0 42.41-23.51l121.16-121.06L528 191.41zm-49.75 49.7a39.75 39.75 0 0 1-19.25 10.66l-91.78 21.18L317 252.59a39.74 39.74 0 0 1 10.69-19.27l15.77-15.76 79.19 79.14zM207.93 353l4.87-4.86 10.51-45.47L89.38 168.79l79.2-79.15L264 185c2.33-2.79 4.57-5.64 7.15-8.22l26.27-26.25-94.9-94.81 17.13-17.12a16 16 0 0 0 0-22.61L208.33 4.68a16 16 0 0 0-22.62 0L4.69 185.59a16 16 0 0 0 0 22.61L16 219.5a16 16 0 0 0 22.63 0l16.81-16.79 143.78 143.68c2.59 2.61 5.83 4.33 8.71 6.61zm219.43 40.53a120.22 120.22 0 0 1-21.8 7.6l-31.27 7.21 98.5 98.43a18 18 0 0 0 25.45 0l8.49-8.48a18 18 0 0 0 0-25.44z"]
};
var faCube = {
  prefix: 'far',
  iconName: 'cube',
  icon: [512, 512, [], "f1b2", "M239.1 7.5l-208 78c-18.7 7-31.1 25-31.1 45v225.1c0 18.2 10.3 34.8 26.5 42.9l208 104c13.5 6.8 29.4 6.8 42.9 0l208-104c16.3-8.1 26.5-24.8 26.5-42.9V130.5c0-20-12.4-37.9-31.1-44.9l-208-78C262 3.4 250 3.4 239.1 7.5zm16.9 45l208 78v.3l-208 84.5-208-84.5v-.3l208-78zM48 182.6l184 74.8v190.2l-184-92v-173zm232 264.9V257.4l184-74.8v172.9l-184 92z"]
};
var faCubes = {
  prefix: 'far',
  iconName: 'cubes',
  icon: [512, 512, [], "f1b3", "M384 215.1V102.5c0-15-9.3-28.4-23.4-33.7l-92-34.5c-8.1-3.1-17.1-3.1-25.3 0l-92 34.5c-14.1 5.3-23.4 18.7-23.4 33.7v112.6L23.4 254.4C9.3 259.6 0 273.1 0 288.1v106.6c0 13.6 7.7 26.1 19.9 32.2l98.6 49.3c10.1 5.1 22.1 5.1 32.2 0L256 423.6l105.3 52.6c10.1 5.1 22.1 5.1 32.2 0l98.6-49.3c12.2-6.1 19.9-18.6 19.9-32.2V288.1c0-15-9.3-28.4-23.4-33.7L384 215.1zm-116 34.8V152l92-31.7v97.6l-92 32zM152 94.2l104-39 104 39v.2L256 131 152 94.3v-.1zm0 26.1l92 31.7v97.9l-92-32v-97.6zm-30 329.4l-96.8-48.4V308l96.8 39.3v102.4zM25.2 280.8v-.2l109.4-41 108.1 40.5v1.2l-108.1 43.9-109.4-44.4zm122 66.5l95.5-38.8V402l-95.5 47.8V347.3zm217.6 102.4L269.3 402v-93.4l95.5 38.8v102.3zm122-48.4L390 449.7V347.3l96.8-39.3v93.3zm0-120.5l-109.4 44.4-108.1-43.9v-1.2l108.1-40.5 109.4 41v.2z"]
};
var faCurling = {
  prefix: 'far',
  iconName: 'curling',
  icon: [640, 512, [], "f44a", "M540.5 199.7C529.7 158.5 492.6 128 448 128H288v-16c0-26.5 21.5-48 48-48h128c8.8 0 16-7.2 16-16V16c0-8.8-7.2-16-16-16H336c-61.9 0-112 50.1-112 112v16h-32c-44.6 0-81.7 30.5-92.5 71.7C41.9 218.6 0 272.1 0 336v32c0 79.5 64.5 144 144 144h352c79.5 0 144-64.5 144-144v-32c0-63.9-41.9-117.4-99.5-136.3zM144 240h352c52.9 0 96 43.1 96 96H48c0-52.9 43.1-96 96-96zm352 224H144c-52.9 0-96-43.1-96-96h544c0 52.9-43.1 96-96 96z"]
};
var faCut = {
  prefix: 'far',
  iconName: 'cut',
  icon: [448, 512, [], "f0c4", "M263.39 256L445.66 73.37c3.12-3.12 3.12-8.19 0-11.31-18.74-18.74-49.14-18.74-67.88 0L223.82 216.35l-43.1-43.18C187.92 159.71 192 144.33 192 128c0-53.02-42.98-96-96-96S0 74.98 0 128s42.98 96 96 96c16.31 0 31.66-4.07 45.11-11.24L184.26 256l-43.15 43.24C127.66 292.07 112.31 288 96 288c-53.02 0-96 42.98-96 96s42.98 96 96 96 96-42.98 96-96c0-16.33-4.08-31.71-11.28-45.17l43.1-43.18 153.95 154.29c18.74 18.74 49.14 18.74 67.88 0 3.12-3.12 3.12-8.19 0-11.31L263.39 256zM96 176c-26.47 0-48-21.53-48-48s21.53-48 48-48 48 21.53 48 48-21.53 48-48 48zm0 256c-26.47 0-48-21.53-48-48s21.53-48 48-48 48 21.53 48 48-21.53 48-48 48z"]
};
var faDagger = {
  prefix: 'far',
  iconName: 'dagger',
  icon: [384, 512, [], "f6cb", "M344 96H216V16c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v80H40c-22.09 0-40 17.91-40 40s17.91 40 40 40c19.25 0 34.57-13.88 38.38-32H112v264.05l63.36 95.04c3.96 5.94 10.3 8.91 16.64 8.91s12.68-2.97 16.64-8.91L272 408.05V144h33.62c3.81 18.12 19.13 32 38.38 32 22.09 0 40-17.91 40-40s-17.91-40-40-40zM224 393.52l-32 48-32-48V144h64v249.52z"]
};
var faDatabase = {
  prefix: 'far',
  iconName: 'database',
  icon: [448, 512, [], "f1c0", "M224 48c97.167 0 176 27.723 176 61.714v4.571C400 148.277 321.167 176 224 176S48 148.277 48 114.286v-4.571C48 75.723 126.833 48 224 48m176 135.018v26.399c0 33.991-78.833 61.714-176 61.714S48 243.408 48 209.417v-26.399C85.813 210.982 155.021 224 224 224s138.187-13.018 176-40.982m0 96v26.834c0 33.991-78.833 61.714-176 61.714S48 339.842 48 305.851v-26.834C85.813 306.982 155.021 320 224 320s138.187-13.018 176-40.982m0 96v27.268C400 436.277 321.167 464 224 464S48 436.277 48 402.286v-27.268C85.813 402.982 155.021 416 224 416s138.187-13.018 176-40.982M224 0C137.052 0 0 23.26 0 109.714v292.571C0 488.758 137.03 512 224 512c86.948 0 224-23.26 224-109.714V109.714C448 23.242 310.97 0 224 0z"]
};
var faDeaf = {
  prefix: 'far',
  iconName: 'deaf',
  icon: [512, 512, [], "f2a4", "M404.486 124.485l-16.971-16.971c-4.686-4.686-4.686-12.284 0-16.971l87.029-87.029c4.686-4.686 12.284-4.686 16.971 0l16.971 16.971c4.686 4.686 4.686 12.284 0 16.971l-87.029 87.029c-4.687 4.687-12.285 4.687-16.971 0zm-367.03 384l151.029-151.029c4.686-4.686 4.686-12.284 0-16.971l-16.971-16.971c-4.686-4.686-12.284-4.686-16.971 0L3.515 474.544c-4.686 4.686-4.686 12.284 0 16.971l16.971 16.971c4.686 4.686 12.284 4.686 16.97-.001zM351.15 397.282C351.901 351.835 424 338.659 424 264c0-93.516-75.03-168-168-168-93.134 0-168 74.662-168 168 0 13.255 10.745 24 24 24s24-10.745 24-24c0-67.05 53.62-120 120-120 66.503 0 120 53.082 120 120 0 48.824-71.843 60.62-72.849 132.757l-.002.334c0 36.894-29.607 66.909-66 66.909-13.255 0-24 10.745-24 24s10.745 24 24 24c62.796 0 113.894-51.446 114.001-114.718zM320 288c-13.255 0-24-10.745-24-24 0-22.056-17.944-40-40-40s-40 17.944-40 40c0 13.255-10.745 24-24 24s-24-10.745-24-24c0-48.523 39.477-88 88-88s88 39.477 88 88c0 13.255-10.745 24-24 24z"]
};
var faDebug = {
  prefix: 'far',
  iconName: 'debug',
  icon: [512, 512, [], "f7f9", "M117.75 271a16 16 0 1 0 4.5 31.68l42.75-6.09a90.21 90.21 0 0 0 10.81 39l-35.51 23.69a16 16 0 1 0 17.7 26.61l37.64-25.1a87.82 87.82 0 0 0 83.24 19.94L162.77 264.58zM256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.28 0-200-89.72-200-200a198.86 198.86 0 0 1 42.81-123.25l280.44 280.44A198.86 198.86 0 0 1 256 456zm157.19-76.75L345 311.08a89.64 89.64 0 0 0 2-14.49l42.73 6.11a16 16 0 1 0 4.5-31.68l-46.82-6.69v-24.65l46.82-6.7a16 16 0 1 0-4.5-31.68l-43.52 6.22a90.15 90.15 0 0 0-10-31.1l35.51-23.69A16 16 0 1 0 354 126.11l-37.64 25.1a90.27 90.27 0 0 0-126.08 5.1l-57.5-57.5A198.86 198.86 0 0 1 256 56c110.28 0 200 89.72 200 200a198.86 198.86 0 0 1-42.81 123.25z"]
};
var faDeer = {
  prefix: 'far',
  iconName: 'deer',
  icon: [512, 512, [], "f78e", "M384 160c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm81.4-51.5l-68.7-19.4c3-3.3 6.2-6.3 8.7-10L423.5 52c4.9-7.3 2.9-17.3-4.4-22.2l-13.3-8.9c-7.4-4.9-17.3-2.9-22.2 4.4l-18.1 27.2c-3.9 5.8-9.2 10.5-15.4 13.6l-48.8 24.4-9.5-2.8c7.9-9.9 12.3-22.3 12.3-35V16c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v36.8c0 1.8-.6 3.6-1.7 5L241 74.6l-11-3.1c-3.4-1-5.8-4.1-5.8-7.7V16c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v47.8c0 25 16.8 47.2 40.9 53.9l63.8 17.9-14.6 24.4H88c-48.5 0-88 39.5-88 88v64h48v7.2L37.6 347c-6.2 16.8-7.3 34.9-2.6 53.3l24.5 81.5c4.5 17.8 20.4 30.3 38.8 30.3h63.8c12.4 0 23.9-5.6 31.5-15.3 7.6-9.8 10.3-22.3 7-35.4l-24-80.7 10.7-28.6H240v120c0 22.1 17.9 40 40 40h64c22.1 0 40-17.9 40-40V295.3l20.8-31.3H448c35.3 0 64-28.7 64-64v-29.9c0-28.5-19.2-53.8-46.6-61.6zM464 200c0 8.8-7.2 16-16 16h-68.8L336 280.7V464h-48V304H154l-28.1 74.8 25.4 85.2h-47.1l-23.1-76.5c-2-7.9-1.5-16.1 1.3-23.7L96.5 332l-.5-68H48v-16c0-22.1 17.9-40 40-40h205.7l34.5-58.8c7.5-15 24.6-22.5 40.8-18l83.3 23.5c6.9 1.9 11.7 8.3 11.7 15.4V200z"]
};
var faDeerRudolph = {
  prefix: 'far',
  iconName: 'deer-rudolph',
  icon: [576, 512, [], "f78f", "M400 160c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm136-64c-15.5 0-28.5 9.1-35.2 22-5.8-4.1-12.3-7.4-19.4-9.4l-68.7-19.4c3-3.3 6.2-6.3 8.7-10L439.5 52c4.9-7.4 2.9-17.3-4.4-22.2l-13.3-8.9c-7.4-4.9-17.3-2.9-22.2 4.4l-18.1 27.2c-3.9 5.8-9.2 10.5-15.4 13.6l-48.8 24.4-1.3.6-9-2.5.7-.9c7.9-9.9 12.3-22.3 12.3-35V16c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v36.8c0 1.8-.6 3.6-1.7 5l-13.4 16.8-11-3.1c-3.4-1-5.8-4.1-5.8-7.7V16c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v47.8c0 25 16.8 47.2 40.9 53.9l63.8 17.9-14.5 24.4H88c-48.5 0-88 39.5-88 88v64h48v7.2L37.6 347c-6.2 16.8-7.3 34.9-2.6 53.3l24.5 81.5c4.5 17.8 20.4 30.3 38.8 30.3h63.8c12.4 0 23.9-5.6 31.5-15.3 7.6-9.8 10.3-22.3 7-35.4l-24-80.7 10.7-28.6H256v120c0 22.1 17.9 40 40 40h64c22.1 0 40-17.9 40-40V302.4l21.9-38.4H464c35.3 0 64-28.7 64-64v-25.6c2.7.6 5.2 1.6 8 1.6 22.1 0 40-17.9 40-40s-17.9-40-40-40zm-56 104c0 8.8-7.2 16-16 16h-69.9L352 289.6V464h-48V304H154l-28.1 74.8 25.4 85.2h-47.1l-23.1-76.5c-2-7.9-1.5-16.1 1.3-23.7L96.5 332l-.5-68H48v-16c0-22.1 17.9-40 40-40h221.7l34.5-58.8c7.5-15 24.6-22.5 40.8-18l83.3 23.5c6.9 1.9 11.7 8.3 11.7 15.4V200z"]
};
var faDemocrat = {
  prefix: 'far',
  iconName: 'democrat',
  icon: [640, 512, [], "f747", "M638.7 221.2L619 191.7c-25.2-37.8-66.5-61.2-111.6-63.7h-219l-73.6-61.2c11.3-19.2 11.5-43.1-.9-61.9-3.4-5.2-10.8-5.9-15.2-1.5l-40.9 40.8-41.9-41.8c-3.6-3.6-9.6-3-12.4 1.2-11.4 17.2-9.9 39.7 3.1 56l-93 108.7C-1.1 185.4-4 209.6 6.1 229.7l13.7 27.4c9.6 19.1 28.8 30.9 50.1 30.9h31c14.8 0 29.2-6 38.2-15.1l10.3-8.7 26.3 68.3V472c0 22.1 18 40 40 40h72.1c22.1 0 40-17.9 40-40v-40h96.1v40c0 22.1 18 40 40 40H536c22.1 0 40-17.9 40-40V216c0-.5-.1-1-.2-1.5 1 1.4 2.3 2.4 3.3 3.9l19.6 29.4c1.2 1.8 3 3 5.1 3.4 2.2.5 4.2 0 6-1.2l26.7-17.7c3.6-2.5 4.6-7.5 2.2-11.1zM527.9 464h-56.1v-64c0-8.8-7.2-16-16-16H295.7c-8.8 0-16 7.2-16 16v64h-56.1V352h304.3v112zm0-160H214.7l-36.9-98.8c-3.9-10.4-16.9-13.8-25.4-6.6l-46 39.1c-1.5 1.5-3.6 2.3-5.7 2.3h-31c-3.1 0-5.8-1.7-7.2-4.4l-13.7-27.3c-1.4-2.9-1-6.3 1.1-8.8L138.6 96h36.3l96.1 80h216.9c22.1 0 40 17.9 40 40v88zm-244.2-77.2l-8.2-16.5c-1.5-3-5.7-3-7.2 0l-8.2 16.5-18.3 2.7c-3.3.5-4.6 4.5-2.2 6.8l13.2 12.9-3.1 18.2c-.6 3.3 2.9 5.8 5.8 4.2l16.3-8.6 16.3 8.6c2.9 1.5 6.4-.9 5.8-4.2l-3.1-18.2 13.2-12.9c2.4-2.3 1.1-6.3-2.2-6.8l-18.1-2.7zm95.8 0l-8.2-16.5c-1.5-3-5.7-3-7.2 0l-8.2 16.5-18.3 2.7c-3.3.5-4.6 4.5-2.2 6.8l13.2 12.9-3.1 18.2c-.6 3.3 2.9 5.8 5.8 4.2l16.3-8.6 16.3 8.6c2.9 1.5 6.4-.9 5.8-4.2l-3.1-18.2 13.2-12.9c2.4-2.3 1.1-6.3-2.2-6.8l-18.1-2.7zm96.2 0l-8.2-16.5c-1.5-3-5.7-3-7.2 0l-8.2 16.5-18.3 2.7c-3.3.5-4.6 4.5-2.2 6.8l13.2 12.9-3.1 18.2c-.6 3.3 2.9 5.8 5.8 4.2l16.3-8.6 16.3 8.6c2.9 1.5 6.4-.9 5.8-4.2l-3.1-18.2 13.2-12.9c2.4-2.3 1.1-6.3-2.2-6.8l-18.1-2.7z"]
};
var faDesktop = {
  prefix: 'far',
  iconName: 'desktop',
  icon: [576, 512, [], "f108", "M528 0H48C21.5 0 0 21.5 0 48v288c0 26.5 21.5 48 48 48h480c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48zm-6 336H54c-3.3 0-6-2.7-6-6V54c0-3.3 2.7-6 6-6h468c3.3 0 6 2.7 6 6v276c0 3.3-2.7 6-6 6zm-42 152c0 13.3-10.7 24-24 24H120c-13.3 0-24-10.7-24-24s10.7-24 24-24h98.7l18.6-55.8c1.6-4.9 6.2-8.2 11.4-8.2h78.7c5.2 0 9.8 3.3 11.4 8.2l18.6 55.8H456c13.3 0 24 10.7 24 24z"]
};
var faDesktopAlt = {
  prefix: 'far',
  iconName: 'desktop-alt',
  icon: [576, 512, [], "f390", "M528 0H48C21.5 0 0 21.5 0 48v288c0 26.5 21.5 48 48 48h480c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48zM48 54c0-3.3 2.7-6 6-6h468c3.3 0 6 2.7 6 6v234H48V54zm432 434c0 13.3-10.7 24-24 24H120c-13.3 0-24-10.7-24-24s10.7-24 24-24h98.7l18.6-55.8c1.6-4.9 6.2-8.2 11.4-8.2h78.7c5.2 0 9.8 3.3 11.4 8.2l18.6 55.8H456c13.3 0 24 10.7 24 24z"]
};
var faDewpoint = {
  prefix: 'far',
  iconName: 'dewpoint',
  icon: [448, 512, [], "f748", "M176 0c-12.4 0-24.7 6.8-29.2 20.7C100 168.6 0 240.8 0 345c0 92.3 78.7 167 176 167s176-74.7 176-167c0-104.8-99.8-175.8-146.8-324.3C201.2 7.1 188.6 0 176 0zm128 345c0 65.6-57.4 119-128 119S48 410.6 48 345c0-42.9 25.1-82.9 56.8-133.5 23.7-37.8 49.9-79.6 71.2-131 21.4 51.7 47.6 93.4 71.4 131.2C279 262.1 304 301.9 304 345zM368 0c-44.1 0-80 35.9-80 80s35.9 80 80 80 80-35.9 80-80-35.9-80-80-80zm0 112c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32z"]
};
var faDharmachakra = {
  prefix: 'far',
  iconName: 'dharmachakra',
  icon: [512, 512, [], "f655", "M499.23 232.01l-20.46.62c-4.6-44.33-22.16-84.78-48.78-117.59l14.96-14.07c5.13-4.72 5.3-12.76.37-17.69l-16.6-16.6c-4.93-4.93-12.97-4.76-17.69.37l-14.07 14.96c-32.81-26.62-73.26-44.18-117.59-48.78l.62-20.46C280.28 5.8 274.71 0 267.74 0h-23.48c-6.97 0-12.54 5.8-12.25 12.77l.62 20.46c-44.33 4.6-84.77 22.16-117.59 48.78l-14.07-14.96c-4.72-5.13-12.76-5.3-17.69-.37l-16.6 16.6c-4.93 4.93-4.76 12.97.37 17.69l14.96 14.07c-26.62 32.81-44.18 73.26-48.78 117.59l-20.46-.62C5.8 231.72 0 237.29 0 244.26v23.48c0 6.97 5.8 12.54 12.77 12.25l20.46-.62c4.6 44.33 22.16 84.77 48.78 117.59l-14.96 14.07c-5.13 4.72-5.3 12.76-.37 17.69l16.6 16.6c4.93 4.93 12.97 4.76 17.69-.37l14.07-14.96c32.81 26.62 73.26 44.18 117.59 48.78l-.62 20.46c-.29 6.96 5.28 12.77 12.25 12.77h23.48c6.97 0 12.54-5.81 12.25-12.77l-.62-20.46c44.33-4.6 84.77-22.16 117.59-48.78l14.07 14.96c4.72 5.13 12.76 5.3 17.69.37l16.6-16.6c4.93-4.93 4.76-12.97-.37-17.69l-14.96-14.07c26.62-32.81 44.18-73.26 48.78-117.59l20.46.62c6.97.29 12.77-5.28 12.77-12.25v-23.48c0-6.97-5.8-12.54-12.77-12.25zm-68.74 2.1l-80.48 2.46c-2.49-12.06-7.33-23.25-13.89-33.2l58.67-55.2c18.98 24.37 31.68 53.79 35.7 85.94zM256 304c-26.51 0-48-21.49-48-48s21.49-48 48-48 48 21.49 48 48-21.49 48-48 48zm107.84-186.79l-55.2 58.67c-9.95-6.56-21.14-11.4-33.2-13.89l2.46-80.48c32.14 4.01 61.56 16.72 85.94 35.7zm-129.73-35.7l2.46 80.48c-12.06 2.49-23.25 7.33-33.2 13.89l-55.2-58.67c24.37-18.98 53.79-31.69 85.94-35.7zm-116.9 66.65l58.67 55.2c-6.56 9.95-11.4 21.14-13.89 33.2l-80.48-2.46c4.02-32.14 16.72-61.56 35.7-85.94zm-35.7 129.73l80.48-2.46c2.49 12.06 7.33 23.25 13.89 33.2l-58.67 55.2c-18.98-24.37-31.69-53.79-35.7-85.94zm66.65 116.9l55.2-58.67c9.95 6.56 21.14 11.4 33.2 13.89l-2.46 80.48c-32.14-4.01-61.56-16.72-85.94-35.7zm129.73 35.7l-2.46-80.48c12.06-2.49 23.25-7.33 33.2-13.89l55.2 58.67c-24.37 18.98-53.79 31.69-85.94 35.7zm116.9-66.65l-58.67-55.2c6.56-9.95 11.4-21.14 13.89-33.2l80.48 2.46c-4.01 32.14-16.72 61.56-35.7 85.94z"]
};
var faDiagnoses = {
  prefix: 'far',
  iconName: 'diagnoses',
  icon: [640, 512, [], "f470", "M632 464H8c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h624c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8zM256 304c0 8.8 7.2 16 16 16s16-7.2 16-16-7.2-16-16-16-16 7.2-16 16zm240-48c8.8 0 16-7.2 16-16s-7.2-16-16-16-16 7.2-16 16 7.2 16 16 16zM96 272c8.8 0 16-7.2 16-16s-7.2-16-16-16-16 7.2-16 16 7.2 16 16 16zm488.6 56.4l-17.8 26.7c-3.1 4.6-8.1 7.2-13.3 7.2-9.8 0-55.6-34.9-137.5-58.9V416h48v-43.8c26.3 11.7 46.7 23.1 57 29.2 9.9 5.8 21.1 8.9 32.5 8.9 21.4 0 41.3-10.7 53.2-28.6l17.8-26.7c9.7-14.6 13.1-32.7 9.2-49.7-3.8-16.9-14.5-31.7-29.4-40.6-13.8-8.3-35.3-20.1-61.2-32.3 4.2 26.5-13.3 41.5-17.4 44.9 23.2 11.1 42.2 21.6 53.9 28.6 8 4.7 10.1 14.9 5 22.5zM33.2 381.7c11.9 17.9 31.8 28.6 53.2 28.6 11.4 0 22.7-3.1 32.5-8.9 10.3-6.1 30.7-17.5 57-29.2V416h48V303.4C142.8 327.2 96 362.3 86.4 362.3c-5.2 0-10.2-2.5-13.3-7.2l-17.8-26.7c-5.1-7.6-2.9-17.8 4.9-22.5 3.6-2.2 8.5-4.9 13.4-7.7-14.7-7.8-24.9-23-25.5-40.7-4.4 2.5-9.1 5.1-12.6 7.2-14.9 8.9-25.6 23.7-29.4 40.6-3.8 17-.5 35.1 9.2 49.7l17.9 26.7zm110-117.3C192.7 243.5 255.7 224 320 224c44.9 0 89 9.6 128.6 22.4-3.6-26.6 14.1-41.1 18.3-44.4-19.9-6.6-41.1-12.3-63-16.8 17.2-19.7 28-45.1 28-73.3C432 50.2 381.8 0 320 0c-61.8 0-112 50.2-112 112 0 28 10.7 53.4 27.8 73.1-39.8 8.1-77.1 20.8-109.3 34.2 15.3 12.7 19.3 30.2 16.7 45.1zM320 48c35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64 28.7-64 64-64zm32 336c0 8.8 7.2 16 16 16s16-7.2 16-16-7.2-16-16-16-16 7.2-16 16z"]
};
var faDiamond = {
  prefix: 'far',
  iconName: 'diamond',
  icon: [448, 512, [], "f219", "M189.5 496L11 285.7c-14.6-17.2-14.6-42.2 0-59.5L189.5 16c18.1-21.4 50.9-21.3 69 0L437 226.3c14.6 17.2 14.6 42.2 0 59.5L258.5 496c-18.1 21.4-50.9 21.3-69 0zM48 256l176 206.5L400 256 224 49.5 48 256z"]
};
var faDice = {
  prefix: 'far',
  iconName: 'dice',
  icon: [640, 512, [], "f522", "M480 328c-13.25 0-24 10.74-24 24 0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24zm96-136H439.38v.01c-2.89-5.17-6.26-10.15-10.66-14.55L270.54 19.28C257.69 6.42 240.84 0 224 0s-33.69 6.42-46.54 19.28L19.28 177.46c-25.7 25.7-25.7 67.38 0 93.08l158.18 158.18C190.31 441.57 207.16 448 224 448s33.69-6.43 46.54-19.28L320 379.26V448c0 35.35 28.65 64 64 64h192c35.35 0 64-28.65 64-64V256c0-35.35-28.65-64-64-64zM235.63 393.82c-4.19 4.19-9.09 4.82-11.63 4.82s-7.44-.63-11.63-4.82L54.18 235.63c-6.42-6.42-6.42-16.86 0-23.27L212.37 54.18c4.19-4.19 9.09-4.82 11.63-4.82s7.44.63 11.63 4.82l158.19 158.18c6.42 6.41 6.42 16.85 0 23.27L235.63 393.82zM592 448c0 8.82-7.18 16-16 16H384c-8.82 0-16-7.18-16-16V331.26l60.72-60.72c8.73-8.73 14.26-19.37 17.05-30.54H576c8.82 0 16 7.18 16 16v192zM224 200c-13.25 0-24 10.74-24 24 0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24zm96 0c-13.25 0-24 10.74-24 24 0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24zm-192 0c-13.25 0-24 10.74-24 24 0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24zm96 96c-13.25 0-24 10.74-24 24 0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24zm0-192c-13.25 0-24 10.74-24 24 0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24z"]
};
var faDiceD10 = {
  prefix: 'far',
  iconName: 'dice-d10',
  icon: [512, 512, [], "f6cd", "M503.88 261.29L279.8 10.64C273.45 3.55 264.73 0 256 0s-17.45 3.55-23.8 10.64L8.12 261.29c-11.81 13.21-10.6 33.5 2.69 45.22l224.08 197.52c6.03 5.32 13.57 7.97 21.11 7.97s15.08-2.66 21.11-7.97L501.19 306.5c13.29-11.71 14.49-32.01 2.69-45.21zM256 287.83l-66.08-44.05L256 89.6l66.08 154.18L256 287.83zm-113.37-55.56l-56.9 14.23 97.58-109.15-40.68 94.92zm12.9 46.26L232 329.51v107.97L74.61 298.76l80.92-20.23zM280 329.51l76.47-50.98 80.92 20.22L280 437.49V329.51zm89.37-97.24l-40.68-94.92 97.58 109.15-56.9-14.23z"]
};
var faDiceD12 = {
  prefix: 'far',
  iconName: 'dice-d12',
  icon: [512, 512, [], "f6ce", "M508.62 185.24l-55.85-111.7a32.06 32.06 0 0 0-14.31-14.31L326.76 3.38A32.066 32.066 0 0 0 312.45 0h-112.9c-4.97 0-9.87 1.16-14.31 3.38L73.54 59.23a32.06 32.06 0 0 0-14.31 14.31L3.38 185.24A32.066 32.066 0 0 0 0 199.55v112.89c0 4.97 1.16 9.87 3.38 14.31l55.85 111.7a32.06 32.06 0 0 0 14.31 14.31l111.7 55.85c4.44 2.22 9.34 3.38 14.31 3.38h112.89c4.97 0 9.87-1.16 14.31-3.38l111.7-55.85a32.06 32.06 0 0 0 14.31-14.31l55.85-111.7c2.22-4.44 3.38-9.34 3.38-14.31V199.55c.01-4.96-1.15-9.86-3.37-14.31zm-53.62.1l-78.18 104.24L280 241.17v-93.5l140.72-28.14-.93-4.61L455 185.34zM300.56 464h-89.11l-52.96-132.41L256 282.83l97.52 48.76L300.56 464zM203.33 48h105.34l64.28 32.14L256 103.53 139.06 80.14 203.33 48zM92.21 114.92l-.93 4.61L232 147.68v93.5l-96.82 48.41L57 185.34l35.21-70.42zM48 308.67v-55.35l58.9 78.53 41.96 104.91-49.08-24.54L48 308.67zm364.22 103.55l-49.08 24.54 41.96-104.91 58.9-78.53v55.35l-51.78 103.55z"]
};
var faDiceD20 = {
  prefix: 'far',
  iconName: 'dice-d20',
  icon: [448, 512, [], "f6cf", "M431.88 116.13L239.88 4.3a31.478 31.478 0 0 0-31.76 0l-192 111.84C6.15 121.94 0 132.75 0 144.45v223.09c0 11.71 6.15 22.51 16.12 28.32l192 111.84a31.478 31.478 0 0 0 31.76 0l192-111.84c9.97-5.81 16.12-16.62 16.12-28.32V144.45c0-11.7-6.15-22.51-16.12-28.32zM224 87.87L296.47 184H151.53L224 87.87zm0 251.42L155.72 232h136.56L224 339.29zm-110.88-84.82l63.37 99.58-83.42-19.37 20.05-80.21zm221.76 0l20.05 80.21-83.42 19.37 63.37-99.58zm16.6-77.22l-70.41-93.41 106.02 61.76-35.61 31.65zm-254.96 0L60.91 145.6l106.02-61.76-70.41 93.41zm-24.24 42.66L48 317.05V198.33l24.28 21.58zM200 408.78v38.64L89.71 383.18 200 408.78zm48 0l110.29-25.61L248 447.42v-38.64zm152-91.73l-24.28-97.13L400 198.33v118.72z"]
};
var faDiceD4 = {
  prefix: 'far',
  iconName: 'dice-d4',
  icon: [512, 512, [], "f6d0", "M504.9 289.03L280.85 11.86C274.45 3.96 265.23 0 256 0s-18.45 3.96-24.85 11.86L7.1 289.03c-11.31 14-8.84 34.57 5.47 45.49l224.05 170.94a31.87 31.87 0 0 0 19.38 6.55c6.83 0 13.66-2.18 19.38-6.55l224.05-170.94c14.31-10.92 16.78-31.5 5.47-45.49zM232 87.17v354.38L54.81 306.37 232 87.17zm48 354.38V87.17l177.19 219.2L280 441.55z"]
};
var faDiceD6 = {
  prefix: 'far',
  iconName: 'dice-d6',
  icon: [448, 512, [], "f6d1", "M431.88 116.13L239.88 4.3a31.478 31.478 0 0 0-31.76 0l-192 111.84C6.15 121.94 0 132.75 0 144.45v223.09c0 11.71 6.15 22.51 16.12 28.32l192 111.84a31.478 31.478 0 0 0 31.76 0l192-111.84c9.97-5.81 16.12-16.62 16.12-28.32V144.45c0-11.7-6.15-22.51-16.12-28.32zM224 50.6l152.35 88.74L224 228.22 71.65 139.34 224 50.6zM48 181.12l152 88.66v177.64L48 358.88V181.12zm200 266.3V269.78l152-88.66v177.76l-152 88.54z"]
};
var faDiceD8 = {
  prefix: 'far',
  iconName: 'dice-d8',
  icon: [512, 512, [], "f6d2", "M502.12 232.14L279.86 9.88C273.27 3.29 264.64 0 256 0s-17.27 3.29-23.86 9.88L9.88 232.14c-13.18 13.18-13.18 34.55 0 47.73l222.25 222.25c6.59 6.59 15.23 9.88 23.86 9.88s17.27-3.29 23.86-9.88L502.1 279.87c13.19-13.19 13.19-34.55.02-47.73zM280 77.9l166.38 166.38L280 315.6V77.9zm-48 237.7L65.62 244.29 232 77.9v237.7zm0 52.22v66.27L116.04 318.13 232 367.82zm48 0l115.97-49.69L280 434.1v-66.28z"]
};
var faDiceFive = {
  prefix: 'far',
  iconName: 'dice-five',
  icon: [448, 512, [], "f523", "M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96c0-35.35-28.65-64-64-64zm16 384c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16v320zM128 128c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm96 96c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm-96 96c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm192-192c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm0 192c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faDiceFour = {
  prefix: 'far',
  iconName: 'dice-four',
  icon: [448, 512, [], "f524", "M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96c0-35.35-28.65-64-64-64zm16 384c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16v320zM128 128c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm0 192c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm192-192c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm0 192c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faDiceOne = {
  prefix: 'far',
  iconName: 'dice-one',
  icon: [448, 512, [], "f525", "M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96c0-35.35-28.65-64-64-64zm16 384c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16v320zM224 224c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faDiceSix = {
  prefix: 'far',
  iconName: 'dice-six',
  icon: [448, 512, [], "f526", "M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96c0-35.35-28.65-64-64-64zm16 384c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16v320zM128 128c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm0 96c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm192 0c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm-192 96c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm192-192c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm0 192c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faDiceThree = {
  prefix: 'far',
  iconName: 'dice-three',
  icon: [448, 512, [], "f527", "M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96c0-35.35-28.65-64-64-64zm16 384c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16v320zM128 128c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm96 96c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm96 96c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faDiceTwo = {
  prefix: 'far',
  iconName: 'dice-two',
  icon: [448, 512, [], "f528", "M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96c0-35.35-28.65-64-64-64zm16 384c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16v320zM128 128c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm192 192c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faDigging = {
  prefix: 'far',
  iconName: 'digging',
  icon: [576, 512, [], "f85e", "M272 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm39.06 320a32 32 0 0 0-30.35 21.88L256 512h320L474.07 305.69a32 32 0 0 0-56.07-2.15l-31.52 53.69-75-40.52L289 194.56a121.81 121.81 0 0 0-65.47-85.62A123 123 0 0 0 168.72 96H96a24 24 0 0 0-17.94 8.06L21.2 170.38a32 32 0 0 0 9 49l331.6 179.9L352 416zM107.84 206L70 185.38 106.78 144h55.33zm82.51 45l49.18-54.63 18 91.15zm203 189.26l50.84-86.63L498.75 464H379.48zM195.5 346.94L65.33 273.88l-64.24 207a24 24 0 1 0 45.81 14.23l46.35-149.27L160 382.25V488a24 24 0 0 0 48 0V368a24 24 0 0 0-12.5-21.06z"]
};
var faDigitalTachograph = {
  prefix: 'far',
  iconName: 'digital-tachograph',
  icon: [640, 512, [], "f566", "M608 96H32c-17.67 0-32 14.33-32 32v256c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V128c0-17.67-14.33-32-32-32zm-16 272H48V144h544v224zM96 240h192c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16H96c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16zm-8 104h208c4.42 0 8-3.58 8-8v-8c0-4.42-3.58-8-8-8H88c-4.42 0-8 3.58-8 8v8c0 4.42 3.58 8 8 8zm256 0h208c4.42 0 8-3.58 8-8v-8c0-4.42-3.58-8-8-8H344c-4.42 0-8 3.58-8 8v8c0 4.42 3.58 8 8 8zM96 264c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8H96zm58.67 0c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-16zm58.66 0c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-16zm58.67 0c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-16z"]
};
var faDiploma = {
  prefix: 'far',
  iconName: 'diploma',
  icon: [640, 512, [], "f5ea", "M608.64 79.58c-5.62-9.54-17.06-15.56-29.38-15.56-7.35 0 1.98-2.46-134.62 43.56a390.517 390.517 0 0 1-124.65 20.44c-42.38 0-84.48-6.9-124.65-20.44C58.15 61.36 68.05 64.03 60.74 64.03c-12.31 0-23.75 6.01-29.38 15.56-41.81 70.93-41.81 217.94 0 288.87 5.63 9.54 17.06 15.56 29.38 15.56 7.35 0-1.98 2.46 134.62-43.56 7.54-2.54 15.21-4.61 22.88-6.69l-57.4 98.91c-3.05 7.49 2.65 15.63 10.73 15.32l36.64.01 25.21 28.52c5.56 5.87 15.33 4.04 18.39-3.45L320 352.01l68.2 121.06c3.05 7.49 12.83 9.32 18.39 3.45l25.2-28.52 36.64-.01c8.08.31 13.78-7.83 10.73-15.32l-57.4-98.92c7.67 2.07 15.34 4.15 22.89 6.69C581.85 386.67 571.95 384 579.27 384c12.31 0 23.75-6.01 29.38-15.56 41.8-70.92 41.8-217.92-.01-288.86zM180.02 294.96l-113 38.07c-25.49-56.48-25.49-161.56 0-218.04l113 38.07c24.81 8.36 50.23 14.23 75.98 18.03v97.58l-5.15 8.88c-23.99 3.84-47.66 9.61-70.83 17.41zm392.96 38.08l-113-38.07c-23.16-7.8-46.84-13.57-70.82-17.4l-5.15-8.88V171.1c25.74-3.8 51.16-9.67 75.98-18.03l113-38.07c25.47 56.48 25.47 161.56-.01 218.04z"]
};
var faDirections = {
  prefix: 'far',
  iconName: 'directions',
  icon: [512, 512, [], "f5eb", "M502.61 233.32L278.68 9.39C272.42 3.13 264.21 0 256 0s-16.42 3.13-22.68 9.39L9.39 233.32c-12.52 12.53-12.52 32.83 0 45.36l223.93 223.93c6.26 6.26 14.47 9.39 22.68 9.39s16.42-3.13 22.68-9.39l223.93-223.93c12.52-12.53 12.52-32.83 0-45.36zM256 457.4L54.6 256 256 54.6 457.4 256 256 457.4zM160 248v80c0 4.42 3.58 8 8 8h32c4.42 0 8-3.58 8-8v-64h80v53.73c0 4.8 3.93 8.02 8.05 8.02 1.87 0 3.78-.66 5.38-2.14l84.21-77.73c3.43-3.17 3.43-8.59 0-11.76l-84.21-77.73c-1.6-1.47-3.51-2.14-5.38-2.14-4.12 0-8.05 3.22-8.05 8.02V216h-96c-17.67 0-32 14.33-32 32z"]
};
var faDisease = {
  prefix: 'far',
  iconName: 'disease',
  icon: [512, 512, [], "f7fa", "M459.68 179.63l-60.78-20.49c-9.81-3.32-16.94-9.95-19-17.7L365.37 87.5c-6.81-25.46-27.65-45-55.71-52.44-30.88-8.1-63.12.15-84.25 21.62L183.6 99.25c-7 7.16-18.59 11-30.15 10.14l-65.12-5c-33.75-2.54-65.06 13.19-79.93 40.19-12.85 23.38-10.88 50.32 5.37 72.06l34.9 46.8c4.63 6.17 5.32 13.16 2 19.67L25 334c-11.85 23.36-9.25 49.83 6.93 70.85 19.21 24.91 52.9 36.44 86.07 29.35l63.4-13.64c11.32-2.49 23.82-.05 32.38 6.28L263 463.3a87.24 87.24 0 0 0 51.87 16.7 89.76 89.76 0 0 0 37.25-8c25.41-11.6 41.75-33.77 43.75-59.35l4.25-55.24c.56-7.44 6-14.47 14.62-18.8L471 310.25c27.21-13.73 42.87-39.6 40.87-67.54-2.07-28.71-22.07-52.92-52.19-63.08zm-10.35 87.74l-56.21 28.35c-23.72 12-39 33.64-40.87 58L348 408.93c-.88 11.38-11.35 17.33-15.78 19.36-10.25 4.69-27 6.52-40.66-3.56l-49.21-36.47c-14.69-10.85-33.22-16.64-52-16.64a90.73 90.73 0 0 0-19 2l-63.4 13.64c-17 3.73-31.41-3.25-38-11.77-4.87-6.33-5.59-13-2.12-19.83l25.74-50.88c11.44-22.59 9-49.44-6.37-70.07L52.21 187.9c-4.91-6.58-5.5-13.38-1.75-20.18 4.4-8 16.43-16.87 34.18-15.5l65.12 5c25.25 2 51.12-7.1 68.09-24.36l41.81-42.55c8.87-9.08 23.78-12.54 37.78-8.85 11.22 2.94 19.25 9.83 21.56 18.46l14.5 54c6.28 23.29 25 42.24 50.09 50.7l60.77 20.5C456 229 463.3 236.9 464 246.12c.58 8.52-4.76 16.27-14.67 21.25zM160 192a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm128 96a32 32 0 1 0 32 32 32 32 0 0 0-32-31.95zm16-96a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]
};
var faDivide = {
  prefix: 'far',
  iconName: 'divide',
  icon: [384, 512, [], "f529", "M192 160c26.51 0 48-21.49 48-48s-21.49-48-48-48-48 21.49-48 48 21.49 48 48 48zm176 64H16c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16h352c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16zM192 352c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48z"]
};
var faDizzy = {
  prefix: 'far',
  iconName: 'dizzy',
  icon: [496, 512, [], "f567", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-33.8-217.9c7.8-7.8 7.8-20.5 0-28.3L196.3 192l17.9-17.9c7.8-7.8 7.8-20.5 0-28.3-7.8-7.8-20.5-7.8-28.3 0L168 163.7l-17.8-17.8c-7.8-7.8-20.5-7.8-28.3 0-7.8 7.8-7.8 20.5 0 28.3l17.9 17.9-17.9 17.9c-7.8 7.8-7.8 20.5 0 28.3 7.8 7.8 20.5 7.8 28.3 0l17.8-17.8 17.8 17.8c7.9 7.7 20.5 7.7 28.4-.2zm160-92.2c-7.8-7.8-20.5-7.8-28.3 0L328 163.7l-17.8-17.8c-7.8-7.8-20.5-7.8-28.3 0-7.8 7.8-7.8 20.5 0 28.3l17.9 17.9-17.9 17.9c-7.8 7.8-7.8 20.5 0 28.3 7.8 7.8 20.5 7.8 28.3 0l17.8-17.8 17.8 17.8c7.8 7.8 20.5 7.8 28.3 0 7.8-7.8 7.8-20.5 0-28.3l-17.8-18 17.9-17.9c7.7-7.8 7.7-20.4 0-28.2zM248 272c-35.3 0-64 28.7-64 64s28.7 64 64 64 64-28.7 64-64-28.7-64-64-64z"]
};
var faDna = {
  prefix: 'far',
  iconName: 'dna',
  icon: [384, 512, [], "f471", "M0 495.1C-.5 503 5.2 512 15.4 512h15.4c8.1 0 14.7-6.2 15.3-14.4.3-4.5 1-10.5 2.2-17.6h287c1.2 7.1 2.1 13.4 2.5 17.7.7 8.1 7.3 14.3 15.3 14.3h15.5c11.5 0 15.8-10.7 15.3-16.8-2.1-29.5-16.3-126.8-108.5-208.8-12.6 9.3-26.2 18.2-40.9 26.7 9.1 7.5 17 15.2 24.6 23H123.6c20.6-20.9 46.4-41.3 79.3-59.3C359.8 190.5 381.2 56 384 16.9 384.5 9 378.8 0 368.6 0h-15.4c-8.1 0-14.7 6.2-15.3 14.4-.3 4.5-1 10.5-2.2 17.6H48.6c-1.3-7.1-2-13.2-2.4-17.7C45.5 6.2 38.9 0 30.9 0H15.4C5.2 0-.5 9.1 0 16.9c2.6 35.7 21.2 153 147.9 238.9C21.3 341.4 2.6 458.9 0 495.1zM322.4 80c-5.7 15-13.6 31.3-24.2 48H86.3C75.7 111.3 67.8 95 62 80h260.4zM192 228.8c-27.4-16.3-49.4-34.3-67.5-52.8h135.4c-18.2 18.4-40.3 36.4-67.9 52.8zM61.4 432c5.7-14.9 13.5-31.2 24.1-48h211.7c10.6 16.8 18.6 33 24.4 48H61.4z"]
};
var faDoNotEnter = {
  prefix: 'far',
  iconName: 'do-not-enter',
  icon: [496, 512, [], "f5ec", "M394.67 192H101.33C93.97 192 88 199.16 88 208v96c0 8.84 5.97 16 13.33 16h293.33c7.36 0 13.33-7.16 13.33-16v-96c.01-8.84-5.96-16-13.32-16zM360 272H136v-32h224v32zM248 8C111.03 8 0 119.03 0 256s111.03 248 248 248 248-111.03 248-248S384.97 8 248 8zm0 448c-110.28 0-200-89.72-200-200S137.72 56 248 56s200 89.72 200 200-89.72 200-200 200z"]
};
var faDog = {
  prefix: 'far',
  iconName: 'dog',
  icon: [576, 512, [], "f6d3", "M416 112c-8.84 0-16 7.16-16 16s7.16 16 16 16 16-7.16 16-16-7.16-16-16-16zm120-48h-49.16l-.53-1.02C476.78 43.88 457.59 32 436.22 32H360c-.53 0-1.01.14-1.54.16l.14-.16-27.29-27.28C321.23-5.36 304 1.78 304 16.03V192H184c-31.28 0-59.56 12.32-80.95 32H88c-22.06 0-40-17.94-40-40 0-13.25-10.75-24-24-24S0 170.75 0 184c0 43.01 31.04 78.76 71.88 86.37C67.03 283.39 64 297.31 64 312v168c0 17.64 14.34 32 32 32h80c17.66 0 32-14.36 32-32v-96h128v96c0 17.64 14.34 32 32 32h80c17.66 0 32-14.36 32-32V240h8c48.53 0 88-39.47 88-88v-48c0-22.06-17.94-40-40-40zM432 464h-48V336H160v128h-48V312c0-39.7 32.31-72 72-72h133.06L432 268.73V464zm96-312c0 22.06-17.94 40-40 40h-56v27.27l-80-20V88c0-4.41 3.59-8 8-8h76.22c3.06 0 5.78 1.69 7.16 4.42L457.16 112H528v40z"]
};
var faDogLeashed = {
  prefix: 'far',
  iconName: 'dog-leashed',
  icon: [576, 512, [], "f6d4", "M416 112c-8.84 0-16 7.16-16 16s7.16 16 16 16 16-7.16 16-16-7.16-16-16-16zm120-48h-49.16l-.53-1.02C476.78 43.88 457.59 32 436.22 32H360c-.53 0-1.01.14-1.54.16l.14-.16-27.29-27.28C321.23-5.36 304 1.78 304 16.03v164.19L67.16 3.19C60.08-2.1 50.06-.65 44.77 6.42l-9.58 12.81c-5.29 7.08-3.85 17.11 3.23 22.4L239.59 192H184c-31.28 0-59.56 12.32-80.95 32H88c-22.06 0-40-17.94-40-40 0-13.25-10.75-24-24-24S0 170.75 0 184c0 43.01 31.04 78.76 71.88 86.37C67.03 283.39 64 297.31 64 312v168c0 17.64 14.34 32 32 32h80c17.66 0 32-14.36 32-32v-96h128v96c0 17.64 14.34 32 32 32h80c17.66 0 32-14.36 32-32V240h8c48.53 0 88-39.47 88-88v-48c0-22.06-17.94-40-40-40zM280 336H160v128h-48V312c0-39.7 32.31-72 72-72h96v96zm152 128h-48V336h-56v-93.27l104 26V464zm96-312c0 22.06-17.94 40-40 40h-56v27.27l-80-20V88c0-4.41 3.59-8 8-8h76.22c3.06 0 5.78 1.69 7.16 4.42L457.16 112H528v40z"]
};
var faDollarSign = {
  prefix: 'far',
  iconName: 'dollar-sign',
  icon: [288, 512, [], "f155", "M211.9 242.1L95.6 208.9c-15.8-4.5-28.6-17.2-31.1-33.5C60.6 150 80.3 128 105 128h73.8c15.9 0 31.5 5 44.4 14.1 6.4 4.5 15 3.8 20.5-1.7l22.9-22.9c6.8-6.8 6.1-18.2-1.5-24.1C240.4 74.3 210.4 64 178.8 64H176V16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v48h-2.5C60.3 64 14.9 95.8 3.1 143.6c-13.9 56.2 20.2 111.2 73 126.3l116.3 33.2c15.8 4.5 28.6 17.2 31.1 33.5C227.4 362 207.7 384 183 384h-73.8c-15.9 0-31.5-5-44.4-14.1-6.4-4.5-15-3.8-20.5 1.7l-22.9 22.9c-6.8 6.8-6.1 18.2 1.5 24.1 24.6 19.1 54.6 29.4 86.3 29.4h2.8v48c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16v-48h2.5c49.2 0 94.6-31.8 106.4-79.6 13.9-56.2-20.2-111.2-73-126.3z"]
};
var faDolly = {
  prefix: 'far',
  iconName: 'dolly',
  icon: [576, 512, [], "f472", "M575.2 309.9l-5.1-15.2c-2.8-8.4-11.9-12.9-20.2-10.1L531 291 459.1 75.3C455.7 65.2 448.6 57 439 52.2c-9.5-4.7-20.4-5.5-30.5-2.2l-221.9 74L158 38.3C150.4 15.4 129 0 105 0H16C7.2 0 0 7.2 0 16v16c0 8.8 7.2 16 16 16h88.9c3.4 0 6.5 2.2 7.6 5.5l93.6 280.8c-27.6 16.9-46.2 47-46.2 81.7 0 53 43 96 96 96s96-43 96-96c0-4.9-.7-9.5-1.4-14.2L565 330.2c8.4-2.8 13-11.9 10.2-20.3zM256 464c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm75.6-106.5C314 334.8 286.9 320 256 320c-1.3 0-2.6.3-3.9.4l-50.3-150.8 86.5-28.8 19.9 59.7c2.8 8.4 11.9 12.9 20.2 10.1l15.2-5.1c8.4-2.8 12.9-11.9 10.1-20.2l-19.9-59.7 82.3-27.4 69.4 208.1-153.9 51.2z"]
};
var faDollyEmpty = {
  prefix: 'far',
  iconName: 'dolly-empty',
  icon: [576, 512, [], "f473", "M575.2 309.9l-5.1-15.2c-2.8-8.4-11.9-12.9-20.2-10.1l-218.3 72.9C314 334.8 286.9 320 256 320c-1.3 0-2.6.3-3.9.4l-94-282.1C150.4 15.4 129 0 105 0H16C7.2 0 0 7.2 0 16v16c0 8.8 7.2 16 16 16h88.9c3.4 0 6.5 2.2 7.6 5.5l93.6 280.8c-27.6 16.9-46.2 47-46.2 81.7 0 53 43 96 96 96s96-43 96-96c0-4.9-.7-9.5-1.4-14.2L565 330.2c8.4-2.8 13-11.9 10.2-20.3zM256 464c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48z"]
};
var faDollyFlatbed = {
  prefix: 'far',
  iconName: 'dolly-flatbed',
  icon: [640, 512, [], "f474", "M208 352h384c8.8 0 16-7.2 16-16V80c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16v256c0 8.8 7.2 16 16 16zm32-240h112v112l48-32 48 32V112h112v192H240V112zm384 288H144V16c0-8.8-7.2-16-16-16H16C7.2 0 0 7.2 0 16v16c0 8.8 7.2 16 16 16h80v384c0 8.8 7.2 16 16 16h50.9c-1.8 5-2.9 10.4-2.9 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1.2-11-2.9-16H451c-1.8 5-2.9 10.4-2.9 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1.2-11-2.9-16H624c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16z"]
};
var faDollyFlatbedAlt = {
  prefix: 'far',
  iconName: 'dolly-flatbed-alt',
  icon: [640, 512, [], "f475", "M208 352h384c8.8 0 16-7.2 16-16V208c0-8.8-7.2-16-16-16h-48V80c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16v256c0 8.8 7.2 16 16 16zm208-240h80v80h-80v-80zm0 128h144v64H416v-64zM240 112h128v192H240V112zm384 288H144V16c0-8.8-7.2-16-16-16H16C7.2 0 0 7.2 0 16v16c0 8.8 7.2 16 16 16h80v384c0 8.8 7.2 16 16 16h50.9c-1.8 5-2.9 10.4-2.9 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1.2-11-2.9-16H451c-1.8 5-2.9 10.4-2.9 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1.2-11-2.9-16H624c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16z"]
};
var faDollyFlatbedEmpty = {
  prefix: 'far',
  iconName: 'dolly-flatbed-empty',
  icon: [640, 512, [], "f476", "M624 400H144V16c0-8.8-7.2-16-16-16H16C7.2 0 0 7.2 0 16v16c0 8.8 7.2 16 16 16h80v384c0 8.8 7.2 16 16 16h50.9c-1.8 5-2.9 10.4-2.9 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1.2-11-2.9-16H451c-1.8 5-2.9 10.4-2.9 16 0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1.2-11-2.9-16H624c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16z"]
};
var faDonate = {
  prefix: 'far',
  iconName: 'donate',
  icon: [512, 512, [], "f4b9", "M225.6 232.3l50.1 14.3c3.6 1 6.1 4.4 6.1 8.1 0 4.6-3.8 8.4-8.4 8.4h-32.8c-3.6 0-7.1-.8-10.3-2.2-4.8-2.2-10.4-1.7-14.1 2l-17.5 17.5c-5.3 5.3-4.7 14.3 1.5 18.4 9.5 6.3 20.4 10.1 31.8 11.5V328c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-17.6c30.3-3.6 53.4-31 49.3-63-2.9-23-20.7-41.3-42.9-47.7l-50.1-14.3c-3.6-1-6.1-4.4-6.1-8.1 0-4.6 3.8-8.4 8.4-8.4h32.8c3.6 0 7.1.8 10.3 2.2 4.8 2.2 10.4 1.7 14.1-2l17.5-17.5c5.3-5.3 4.7-14.3-1.5-18.4-9.5-6.3-20.4-10.1-31.8-11.5V104c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v17.6c-30.3 3.6-53.4 31-49.3 63 2.9 23 20.6 41.3 42.9 47.7zM480 320h-34.7c17-30.9 26.7-66.3 26.7-104C472 96.7 375.3 0 256 0S40 96.7 40 216c0 37.7 9.7 73.1 26.7 104H32c-17.7 0-32 17.2-32 38.4v115.2C0 494.8 14.3 512 32 512h448c17.7 0 32-17.2 32-38.4V358.4c0-21.2-14.3-38.4-32-38.4zM256 48c92.6 0 168 75.4 168 168s-75.4 168-168 168S88 308.6 88 216 163.4 48 256 48zm208 416H48v-96h54.6c12.2 12.3 25.9 22.9 40.7 32H104c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8h-39.3c14.8-9.1 28.5-19.7 40.7-32H464v96z"]
};
var faDoorClosed = {
  prefix: 'far',
  iconName: 'door-closed',
  icon: [640, 512, [], "f52a", "M624 464H512V32c0-17.67-14.33-32-32-32H160c-17.67 0-32 14.33-32 32v432H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h608c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zm-160 0H176V48h288v416zm-64-176c17.67 0 32-14.33 32-32s-14.33-32-32-32-32 14.33-32 32 14.33 32 32 32z"]
};
var faDoorOpen = {
  prefix: 'far',
  iconName: 'door-open',
  icon: [640, 512, [], "f52b", "M288 288c13.25 0 24-14.33 24-32s-10.75-32-24-32-24 14.33-24 32 10.75 32 24 32zm336 176H512V113.45C512 86.19 490.47 64 464 64h-80V33.18C384 14.42 369.21 0 352.06 0c-2.57 0-5.19.32-7.83 1.01l-192 49.74C137.99 54.44 128 67.7 128 82.92V464H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h608c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zm-288 0H176V94.18l160-41.45V464zm128 0h-80V112h80v352z"]
};
var faDotCircle = {
  prefix: 'far',
  iconName: 'dot-circle',
  icon: [512, 512, [], "f192", "M256 56c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m0-48C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 168c-44.183 0-80 35.817-80 80s35.817 80 80 80 80-35.817 80-80-35.817-80-80-80z"]
};
var faDove = {
  prefix: 'far',
  iconName: 'dove',
  icon: [512, 512, [], "f4ba", "M368 160.2c0 8.8 7.2 16 16 16s16-7.2 16-16-7.2-16-16-16c-8.9 0-16 7.2-16 16zM384 64c-46.2 0-84.8 32.8-93.9 76.4-29-36.6-49-79.8-56.2-126.5C231.8.6 215-5.1 206 5.5c-25.1 29.6-44.3 65.1-55 105.1-1.6 5.8-2.4 11.7-3.4 17.5-25.4-24.4-46.3-53.5-60.6-86.3-5.5-12.6-23.3-13.1-29.1-.7-16.1 34.1-25.3 72-25.9 112-1.3 96.1 54.8 163.1 95.9 199.4L13.8 391C1.6 394.3-3.9 409.2 3 420.3c19.8 32.3 68.9 87 174.8 91.6 13.5.6 17.6-4.6 25.2-9.4l76.4-54.1H320c88.4 0 160-71.7 160-160.1V159.9L512 64H384zm-186.6 59c2.6-9.7 5.8-19.1 9.6-28.2 15.9 38.4 39.9 72.9 69.3 102.4-30.2-6.8-58.6-18.2-84.1-34.1.4-13.7 1.8-27.2 5.2-40.1zM432 152.1v136.1c0 61.8-50.2 111.7-112 111.7h-55.9l-89.4 63.7c-52.3-3.3-85.9-21.4-107-40.2l154-52C165.9 324.9 78.6 261.1 80 153.7c.1-9 .8-17 1.9-25.7C174.6 249.1 320 256 336 256v-95.8c0-26.6 21.5-48.1 48-48.1h61.4l-13.4 40z"]
};
var faDownload = {
  prefix: 'far',
  iconName: 'download',
  icon: [576, 512, [], "f019", "M528 288h-92.1l46.1-46.1c30.1-30.1 8.8-81.9-33.9-81.9h-64V48c0-26.5-21.5-48-48-48h-96c-26.5 0-48 21.5-48 48v112h-64c-42.6 0-64.2 51.7-33.9 81.9l46.1 46.1H48c-26.5 0-48 21.5-48 48v128c0 26.5 21.5 48 48 48h480c26.5 0 48-21.5 48-48V336c0-26.5-21.5-48-48-48zm-400-80h112V48h96v160h112L288 368 128 208zm400 256H48V336h140.1l65.9 65.9c18.8 18.8 49.1 18.7 67.9 0l65.9-65.9H528v128zm-88-64c0-13.3 10.7-24 24-24s24 10.7 24 24-10.7 24-24 24-24-10.7-24-24z"]
};
var faDraftingCompass = {
  prefix: 'far',
  iconName: 'drafting-compass',
  icon: [512, 512, [], "f568", "M450.33 296.36c14.32-13.92 27.51-29.15 38.7-46.11 5.02-7.6 2.23-18.06-5.64-22.62l-13.79-8c-7.39-4.28-16.54-1.77-21.29 5.34-6.52 9.75-13.92 18.7-21.73 27.24l-76.3-141.76c.72-4.75 1.45-9.51 1.45-14.46C351.72 42.98 308.86 0 256 0s-95.72 42.98-95.72 95.99c0 4.95.73 9.71 1.45 14.46L85.46 252.16c-7.85-8.49-15.24-17.44-21.76-27.19-4.75-7.11-13.9-9.63-21.29-5.34l-13.79 8c-7.87 4.56-10.66 15.02-5.64 22.62 11.17 16.92 24.68 31.66 39.06 45.44L0 410.94l7.91 65.75c1.5 12.62 8.63 23.51 19.6 29.89 6.2 3.59 13.06 5.42 19.94 5.42 5.3 0 10.66-1.08 15.74-3.27l61.44-26.33 62.2-115.57c22.37 5.83 45.54 9.13 69.17 9.13 23.65 0 46.91-3.07 69.31-8.87l62.05 115.3 61.48 26.34c5.08 2.17 10.41 3.25 15.7 3.25 6.89 0 13.74-1.83 19.94-5.42 10.97-6.37 18.1-17.26 19.57-29.83l7.95-65.81-61.67-114.56zM256 48c26.43 0 47.86 21.49 47.86 48s-21.43 48-47.86 48-47.86-21.49-47.86-48S229.57 48 256 48zM90.48 444.85l-36.3 15.56-4.83-40.09 138.38-257.15c11.16 11.41 25.27 19.66 40.93 24.37l.15.28L90.48 444.85zM256 327.98c-15.5 0-30.71-1.85-45.58-4.97L256 238.32l45.56 84.65c-14.89 3.03-30.07 5.01-45.56 5.01zm27.18-140.17l.15-.28c15.67-4.71 29.77-12.96 40.93-24.37l65.57 121.85c-13.04 9.27-27.14 16.89-41.8 23.3l-64.85-120.5zm174.64 272.6l-36.3-15.56-50.76-94.31c14.56-6.61 28.6-14.25 41.83-23.24l50.06 93.03-4.83 40.08z"]
};
var faDragon = {
  prefix: 'far',
  iconName: 'dragon',
  icon: [640, 512, [], "f6d5", "M481.12 119.98c14.92.85 27.36-9.89 30.88-24.59l-58.43-15.37c-6.5 27.13 15.51 39.27 27.55 39.96zm82.55 136.9l-94.19-44.21a9.876 9.876 0 0 1-4.6-4.69h18.68c4.9 3.12 8.91 5.72 12.25 7.89 16.52 10.73 24.81 16.12 42.65 16.12h27.87c23.03 0 43.8-12.59 54.22-32.85l12.88-25.04c10.49-20.39 8.19-45.32-5.84-63.51L560.5 23.65C549.07 8.84 530.99 0 512.12 0h-213.7c-37.28 0-52.93 46.77-24.99 69.01l12.52 9.94c-4.44 1.8-3.56 1.43-4.75 2.01-29.37 14.28-29.24 55.87.01 70.08L320 166.01v12.95l-167.69-41.84c-22.03-5.48-45.5 3.28-58.53 21.77L5.03 285.13c-14.39 22.6 4.05 52.39 33.06 48.25l91.52-17.21c-14.71 23.28 5.27 52.03 31.82 48.36l180.76-24.23c4.91 10.23 10.58 19.99 17.01 29.17-147.08 10.08-247.2 32.47-321.46 48.52C15.88 422.71 0 442.24 0 464.42c0 26.21 21.52 47.54 47.98 47.54l449.17.04c76.07.01 138.73-55.84 142.65-127.15 2.96-53.81-26.93-104.04-76.13-127.97zM68.03 278.95l65-92.44c1.66-2.38 4.59-3.66 7.69-2.81l69.82 17.33-41.4 58.87-101.11 19.05zm123.03 33.18l69.38-98.67L320 228.47c0 21.25.13 36.77 6.72 65.48l-135.66 18.18zM497.15 464l-449.26.9c92.02-19.88 196.84-43.56 383.18-51.02 16.58-.67 23.38-21.76 9.29-31.79C367.78 330.38 368 258.74 368 239.03V132.98l-45.11-17.22 57.34-23.24L324.16 48h188.22c3.96 0 7.7 1.84 10.12 4.97l67.13 87.01c2.7 3.5 3.13 8.23 1.11 12.16l-12.88 25.04c-2.12 4.13-6.65 6.79-11.53 6.79h-27.87c-3.61 0-3.61 0-16.5-8.37-5.12-3.33-24.56-15.64-24.56-15.64H416v44.11c0 22.19 12.6 42.09 33.08 52.04l93.59 43.92c32.27 15.69 51.12 47.18 49.2 82.16-2.48 45.13-44.97 81.82-94.72 81.81z"]
};
var faDrawCircle = {
  prefix: 'far',
  iconName: 'draw-circle',
  icon: [512, 512, [], "f5ed", "M512 256c0-30.3-21.11-55.54-49.39-62.17-20.85-69.11-75.33-123.6-144.44-144.45C311.54 21.11 286.3 0 256 0s-55.54 21.11-62.17 49.39c-69.11 20.85-123.6 75.33-144.44 144.45C21.12 200.46 0 225.7 0 256c0 30.3 21.12 55.54 49.39 62.17 20.85 69.11 75.33 123.6 144.44 144.45C200.46 490.89 225.7 512 256 512s55.54-21.11 62.17-49.39c69.11-20.85 123.6-75.33 144.44-144.45C490.89 311.54 512 286.3 512 256zm-64 16c-8.82 0-16-7.18-16-16s7.18-16 16-16 16 7.18 16 16-7.18 16-16 16zM256 48c8.82 0 16 7.18 16 16s-7.18 16-16 16-16-7.18-16-16 7.18-16 16-16zM64 240c8.82 0 16 7.18 16 16s-7.18 16-16 16-16-7.18-16-16 7.18-16 16-16zm192 224c-8.82 0-16-7.18-16-16s7.18-16 16-16 16 7.18 16 16-7.18 16-16 16zm53.89-50.28C298.53 395.9 278.71 384 256 384c-22.7 0-42.53 11.9-53.89 29.72A166.552 166.552 0 0 1 98.28 309.89C116.1 298.53 128 278.7 128 256c0-22.71-11.9-42.53-29.72-53.89A166.567 166.567 0 0 1 202.12 98.28C213.47 116.1 233.3 128 256 128c22.71 0 42.53-11.9 53.89-29.72a166.614 166.614 0 0 1 103.84 103.83C395.9 213.47 384 233.29 384 256c0 22.7 11.9 42.53 29.72 53.89a166.529 166.529 0 0 1-103.83 103.83z"]
};
var faDrawPolygon = {
  prefix: 'far',
  iconName: 'draw-polygon',
  icon: [448, 512, [], "f5ee", "M384 352c-3.36 0-6.59.49-9.81.99l-35.21-58.68C347.05 283.6 352 270.43 352 256s-4.95-27.6-13.01-38.31l35.21-58.68c3.22.5 6.45.99 9.81.99 35.35 0 64-28.65 64-64s-28.65-64-64-64c-26.84 0-49.75 16.56-59.25 40H123.25c-9.5-23.44-32.4-40-59.25-40C28.65 32 0 60.65 0 96c0 26.84 16.56 49.75 40 59.25v201.49C16.56 366.25 0 389.15 0 416c0 35.35 28.65 64 64 64 26.85 0 49.75-16.56 59.25-40h201.49c9.5 23.44 32.41 40 59.25 40 35.35 0 64-28.65 64-64 .01-35.35-28.64-64-63.99-64zm-296 4.75v-201.5A64.053 64.053 0 0 0 123.25 120h201.49c2.1 5.19 4.96 9.92 8.28 14.32l-35.21 58.67c-3.22-.5-6.45-.99-9.82-.99-35.35 0-64 28.65-64 64s28.65 64 64 64c3.36 0 6.59-.49 9.82-.99l35.21 58.67c-3.32 4.4-6.18 9.14-8.28 14.32H123.25A64.053 64.053 0 0 0 88 356.75zM288 240c8.82 0 16 7.18 16 16s-7.18 16-16 16-16-7.18-16-16 7.18-16 16-16zm96-160c8.82 0 16 7.18 16 16s-7.18 16-16 16-16-7.18-16-16 7.18-16 16-16zM64 80c8.82 0 16 7.18 16 16s-7.18 16-16 16-16-7.18-16-16 7.18-16 16-16zm0 352c-8.82 0-16-7.18-16-16s7.18-16 16-16 16 7.18 16 16-7.18 16-16 16zm320 0c-8.82 0-16-7.18-16-16s7.18-16 16-16 16 7.18 16 16-7.18 16-16 16z"]
};
var faDrawSquare = {
  prefix: 'far',
  iconName: 'draw-square',
  icon: [448, 512, [], "f5ef", "M408 356.75v-201.5c23.44-9.5 40-32.41 40-59.25 0-35.35-28.65-64-64-64-26.84 0-49.75 16.56-59.25 40h-201.5c-9.5-23.44-32.4-40-59.25-40C28.65 32 0 60.65 0 96c0 26.84 16.56 49.75 40 59.25v201.49C16.56 366.25 0 389.15 0 416c0 35.35 28.65 64 64 64 26.85 0 49.75-16.56 59.25-40h201.49c9.5 23.44 32.41 40 59.25 40 35.35 0 64-28.65 64-64 .01-26.85-16.55-49.75-39.99-59.25zm-320 0v-201.5A64.053 64.053 0 0 0 123.25 120h201.49a64.053 64.053 0 0 0 35.25 35.25v201.49a64.053 64.053 0 0 0-35.25 35.25H123.25A64.066 64.066 0 0 0 88 356.75zM384 80c8.82 0 16 7.18 16 16s-7.18 16-16 16-16-7.18-16-16 7.18-16 16-16zM64 80c8.82 0 16 7.18 16 16s-7.18 16-16 16-16-7.18-16-16 7.18-16 16-16zm0 352c-8.82 0-16-7.18-16-16s7.18-16 16-16 16 7.18 16 16-7.18 16-16 16zm320 0c-8.82 0-16-7.18-16-16s7.18-16 16-16 16 7.18 16 16-7.18 16-16 16z"]
};
var faDreidel = {
  prefix: 'far',
  iconName: 'dreidel',
  icon: [448, 512, [], "f792", "M443.3 48L432 36.7c-6.2-6.2-16.4-6.2-22.6 0L294.7 151.4l-77.6-77.6c-6.5-6.5-15.1-9.8-23.6-9.8-8.6 0-17.1 3.3-23.6 9.8L19.6 224C7 236.5 0 253.5 0 271.3v141.8c0 37 29.9 66.9 66.9 66.9h141.8c17.7 0 34.7-7 47.3-19.6l150.2-150.2c13.1-13.1 13.1-34.2 0-47.3l-77.6-77.6L443.3 70.6c6.3-6.2 6.3-16.4 0-22.6zM222.1 426.5c-3.6 3.6-8.3 5.5-13.3 5.5H66.9c-10.4 0-18.9-8.5-18.9-18.9V271.3c0-5 2-9.8 5.5-13.3l53.2-53.2 168.5 168.5-53.1 53.2zm87.1-87.2L140.7 170.8l52.7-52.7L362 286.6l-52.8 52.7z"]
};
var faDrone = {
  prefix: 'far',
  iconName: 'drone',
  icon: [512, 512, [], "f85f", "M339.41 92.33a63.82 63.82 0 1 1 80.26 80.26l-35.93 49.77A110.32 110.32 0 0 0 400 224a112 112 0 1 0-112-112 110.32 110.32 0 0 0 1.64 16.26zM111 368.2a31.91 31.91 0 1 0 32.8 32.8l67.86-49h88.68l67.86 49a31.91 31.91 0 1 0 32.8-32.8l-49-67.86v-88.68l49-67.86a31.91 31.91 0 1 0-32.8-32.8l-67.86 49h-88.68l-67.86-49a31.91 31.91 0 1 0-32.8 32.8l49 67.86v88.68zM208 208h96v96h-96zm192 80a110.45 110.45 0 0 0-16.26 1.64l35.93 49.77a63.82 63.82 0 1 1-80.26 80.25l-49.77-35.92A110.32 110.32 0 0 0 288 400a112 112 0 1 0 112-112zm-288-64a110.32 110.32 0 0 0 16.26-1.64l-35.92-49.77a63.82 63.82 0 1 1 80.25-80.26l49.77 35.93A110.45 110.45 0 0 0 224 112a112 112 0 1 0-112 112zm60.59 195.67a63.82 63.82 0 1 1-80.26-80.26l35.93-49.77A110.32 110.32 0 0 0 112 288a112 112 0 1 0 112 112 110.32 110.32 0 0 0-1.64-16.26z"]
};
var faDroneAlt = {
  prefix: 'far',
  iconName: 'drone-alt',
  icon: [640, 512, [], "f860", "M287.94 136a24 24 0 0 0-24-24h-97.6a23.65 23.65 0 0 0-44.76 0H24a24 24 0 0 0 0 48h240a24 24 0 0 0 23.94-24zm184 101.65l-96.85-29.05a191.87 191.87 0 0 0-110.32 0L168 237.65V192h-48v64.05a32 32 0 0 0 32 32h45.44a178.39 178.39 0 0 0-53.36 110.24 16.13 16.13 0 0 0 16 17.71h16.25c8.34 0 14.76-6.58 15.68-14.87a130.07 130.07 0 0 1 41.87-81.89L251 336.38A53.34 53.34 0 0 0 288.7 352h62.47a53.32 53.32 0 0 0 37.7-15.62L406 319.24a130.07 130.07 0 0 1 41.87 81.89c.92 8.29 7.34 14.85 15.67 14.87h16.26a16.14 16.14 0 0 0 16-17.71 178.49 178.49 0 0 0-53.36-110.24h45.46a32 32 0 0 0 32-32V192h-48zm-117 64.79a5.38 5.38 0 0 1-3.77 1.56H288.7a5.36 5.36 0 0 1-3.77-1.56l-38.28-38.29 31.91-9.57a143.9 143.9 0 0 1 82.74 0l31.92 9.58zm261.45-190.37l-97.9.31a23.57 23.57 0 0 0-44.94.15l-98 .31a23.55 23.55 0 0 0 .15 47.09l240.86-.77a23.55 23.55 0 0 0-.15-47.09z"]
};
var faDrum = {
  prefix: 'far',
  iconName: 'drum',
  icon: [576, 512, [], "f569", "M452.66 119.08l112.65-75.1c11.03-7.36 14-22.25 6.66-33.28-7.34-11.02-22.25-14.05-33.28-6.66L388.48 104.18c-31.33-5.19-65.08-8.17-100.48-8.17-159.06 0-288 57.3-288 128v160c0 70.69 128.94 128 288 128s288-57.31 288-128v-160c0-43.46-48.84-81.79-123.34-104.93zM96 426.79C65.13 411.98 48 395.72 48 384v-89.3c13.57 9.08 29.81 17.26 48 24.51v107.58zm168 36.68c-46.61-1.87-87.05-9.03-120-18.67V334.74c35.86 9.23 76.51 15.13 120 16.73v112zm168-18.67c-32.95 9.64-73.39 16.8-120 18.67v-112c43.49-1.6 84.14-7.49 120-16.73V444.8zm96-60.8c0 11.71-17.13 27.98-48 42.79V319.22c18.19-7.25 34.43-15.44 48-24.51V384zm-240-79.99c-132.55 0-240-35.82-240-80s107.45-80 240-80c13.32 0 26.29.45 39.01 1.15l-76.32 50.88c-11.03 7.36-14 22.25-6.66 33.28 4.62 6.94 12.25 10.69 20 10.69 4.56 0 9.19-1.3 13.28-4.03l123.78-82.52c75.51 13.48 126.9 40 126.9 70.55.01 44.18-107.44 80-239.99 80z"]
};
var faDrumSteelpan = {
  prefix: 'far',
  iconName: 'drum-steelpan',
  icon: [576, 512, [], "f56a", "M288 32C128.94 32 0 89.31 0 160v192c0 70.69 128.94 128 288 128s288-57.31 288-128V160c0-70.69-128.94-128-288-128zm0 48c24.31 0 47.75 1.23 69.87 3.47l-11.5 44.71C341.86 145.73 315.67 160 288 160c-27.67 0-53.86-14.27-58.37-31.82l-11.5-44.71C240.25 81.23 263.69 80 288 80zm-58.38 95.55C245.95 185.92 266.66 192 288 192c21.02 0 41.47-5.87 57.68-15.95 2.82 21.76 11.49 41.94 24.64 59.01C344.61 238.2 316.97 240 288 240c-29.32 0-57.28-1.84-83.25-5.05 13.11-17.29 21.97-37.61 24.87-59.4zm-55.11-86.04l13.02 46.08c9.82 34.77-3.37 70.58-30.33 91.44C91.51 212.75 48 188.09 48 160c0-30.5 51.21-56.99 126.51-70.49zM528 352c0 27.47-93.46 80-240 80-146.54 0-240-52.53-240-80V230.7C99.59 265.22 187.77 288 288 288s188.41-22.78 240-57.3V352zM418.16 227.15c-8.38-6.16-15.65-13.85-21.32-22.94-11.73-18.82-15.42-41.09-10.4-62.7l12.19-52.46C475.46 102.39 528 129.13 528 160c0 28.18-43.8 52.9-109.84 67.15z"]
};
var faDrumstick = {
  prefix: 'far',
  iconName: 'drumstick',
  icon: [512, 512, [], "f6d6", "M471.06 57.65A169.92 169.92 0 0 0 348.12.07a172.16 172.16 0 0 0-126.19 49.72C195.34 76.21 160 119.46 160 189.81v60.42L116.3 294c-1.93 1.88-5.75 1-7.75.17A79.19 79.19 0 0 0 23.22 423.7a76.41 76.41 0 0 0 43.57 21.59 76.39 76.39 0 0 0 21.57 43.55 79.19 79.19 0 0 0 129.58-85.33c-1-2.5-1.56-6 .16-7.75L261.84 352H323c38.72 0 72.75-10.17 104-31.08 46.22-30.88 76.69-79.36 83.56-133 6.22-48.32-7.81-94.58-39.5-130.27zM173.37 421.34A31.07 31.07 0 0 1 144.43 464c-12 0-27.64-7.82-30.11-25.39l-5-35.8-35.81-5.05C56 395.28 48 379.69 48 367.65a31.13 31.13 0 0 1 42.5-29 60.4 60.4 0 0 0 22.5 4.42 52.8 52.8 0 0 0 37.27-15.17l20.43-20.45a84.92 84.92 0 0 0 34 33.87l-20.49 20.5c-15.3 15.24-19.43 38.05-10.84 59.52zM400.31 281c-23.13 15.47-48.44 23-77.34 23h-77.81A37 37 0 0 1 208 267.2v-77.39c0-41 14.28-72.7 47.78-106 57.69-57.39 139.86-38.82 179.4 5.7 61.93 69.83 14.31 158.66-34.87 191.49z"]
};
var faDrumstickBite = {
  prefix: 'far',
  iconName: 'drumstick-bite',
  icon: [512, 512, [], "f6d7", "M471.15 57.65A170 170 0 0 0 348.19.07 172.2 172.2 0 0 0 222 49.79c-26.62 26.42-62 69.67-62 140.01v60.42L116.3 294c-1.93 1.88-5.75 1-7.75.17A79.19 79.19 0 0 0 23.22 423.7a76.41 76.41 0 0 0 43.57 21.59 76.39 76.39 0 0 0 21.57 43.55 79.19 79.19 0 0 0 129.58-85.33c-1-2.5-1.56-6 .16-7.75L261.89 352H323a189.07 189.07 0 0 0 50.76-6.94A24 24 0 0 0 388.29 310c-19.38-33.91-14.6-75.9 11.63-102.15 21-21 51.48-28.58 81.7-20.23A24 24 0 0 0 512 164.24c-.38-40.09-14.5-76.95-40.85-106.59zM173.37 421.34A31.07 31.07 0 0 1 144.43 464c-12 0-27.64-7.82-30.11-25.38l-5-35.81-35.81-5.05C56 395.28 48 379.7 48 367.65a31.13 31.13 0 0 1 42.5-29 60.4 60.4 0 0 0 22.5 4.42 52.77 52.77 0 0 0 37.28-15.17l20.46-20.47a85 85 0 0 0 34 33.87c-21.21 21.15-18.74 18.7-20.59 20.52-15.23 15.24-19.36 38.05-10.78 59.52zM366 173.92c-33.85 33.86-45.38 83.82-32.16 129.66-3.59.27-7.16.41-10.78.41H245.2A37 37 0 0 1 208 267.2v-77.4c0-41 14.29-72.7 47.79-106 57.7-57.39 139.9-38.81 179.44 5.7a112.62 112.62 0 0 1 25.07 46.91 128.69 128.69 0 0 0-94.3 37.51z"]
};
var faDryer = {
  prefix: 'far',
  iconName: 'dryer',
  icon: [448, 512, [], "f861", "M384 0H64A64 64 0 0 0 0 64v416a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a64 64 0 0 0-64-64zm16 464H48V64a16 16 0 0 1 16-16h320a16 16 0 0 1 16 16zM128 104a24 24 0 1 0-24 24 24 24 0 0 0 24-24zm56 24a24 24 0 1 0-24-24 24 24 0 0 0 24 24zm40 32a136 136 0 1 0 136 136 136 136 0 0 0-136-136zm-25.5 179.93c6.59 6.17 15.25 14.28 17.71 28.13a6.94 6.94 0 0 1-7.07 7.94h-14.5a7.05 7.05 0 0 1-6.83-5.06c-1.21-4.29-4.25-7.3-9.42-12.15-7.77-7.27-18.39-17.23-18.39-36.07s10.62-28.83 18.39-36.11c7-6.54 10.06-9.75 10.06-17.25s-3.09-10.72-10.06-17.25c-6.6-6.19-15.26-14.3-17.71-28.17a6.94 6.94 0 0 1 7.06-7.94h14.51a7 7 0 0 1 6.82 5.07c1.22 4.3 4.25 7.33 9.43 12.18 7.76 7.28 18.39 17.24 18.39 36.11s-10.63 28.83-18.39 36.1c-7 6.54-10.05 9.76-10.05 17.26s3.08 10.67 10.05 17.21zm71.11 0c6.59 6.17 15.25 14.28 17.71 28.13a6.94 6.94 0 0 1-7.06 7.94h-14.51a7 7 0 0 1-6.82-5.06c-1.22-4.29-4.26-7.3-9.43-12.15-7.76-7.27-18.39-17.23-18.39-36.07s10.63-28.83 18.39-36.11c7-6.54 10.05-9.75 10.05-17.25s-3.08-10.72-10.05-17.25c-6.59-6.19-15.25-14.3-17.71-28.17a6.94 6.94 0 0 1 7.06-7.94h14.51a7 7 0 0 1 6.82 5.07c1.22 4.3 4.25 7.33 9.43 12.18 7.77 7.28 18.39 17.24 18.39 36.11s-10.62 28.83-18.39 36.1c-7 6.54-10.06 9.76-10.06 17.26s3.09 10.67 10.06 17.21z"]
};
var faDryerAlt = {
  prefix: 'far',
  iconName: 'dryer-alt',
  icon: [448, 512, [], "f862", "M224 160a136 136 0 1 0 136 136 136 136 0 0 0-136-136zm0 224c-40.15 0-73.73-27.18-84.25-64H176a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-36.25c10.52-36.82 44.1-64 84.25-64a88 88 0 0 1 0 176zm-96-280a24 24 0 1 0-24 24 24 24 0 0 0 24-24zm56 24a24 24 0 1 0-24-24 24 24 0 0 0 24 24zM384 0H64A64 64 0 0 0 0 64v416a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a64 64 0 0 0-64-64zm16 464H48V64a16 16 0 0 1 16-16h320a16 16 0 0 1 16 16z"]
};
var faDuck = {
  prefix: 'far',
  iconName: 'duck',
  icon: [576, 512, [], "f6d8", "M416 144c0-8.84-7.16-16-16-16s-16 7.16-16 16 7.16 16 16 16 16-7.16 16-16zm48 96c61.86 0 112-50.14 112-112h-65.57c-.46-3.32-.6-6.58-1.36-9.95-9.15-40.61-41.97-73.7-82.54-83-9-2.07-17.88-3.05-26.53-3.05-61.86 0-112 50.14-112 112v80h-54.23c-39 0-78.18-13.76-104.79-42.28-3.96-4.25-8.94-6.14-13.82-6.14-9.78 0-19.16 7.59-19.16 19.06 0 94.71 72.21 178.39 164.58 188.02 9.47.99 17.77-6.49 17.77-16.01v-16.09c0-8.02-5.94-14.86-13.9-15.77-45.77-5.2-85.53-35.7-105.91-77.49 23.38 9.37 48.83 14.27 75.24 14.27L336 272V144c0-35.29 28.71-64 64-64 5.19 0 10.5.62 15.79 1.83 22.66 5.2 41.32 23.99 46.46 46.77 7.9 35.06-11.85 61.87-34.92 72.89L400 214.54v71.63l11.86 13.57c8.89 10.18 19.61 27.21 20.12 50.54.43 19.57-7.61 38.82-22.64 54.19-17.12 17.5-40.59 27.54-64.39 27.54h-91.17c-6.03 0-12.1-.31-18.66-.97-88.83-7.9-163.37-73.51-183.76-159.04h29.28a190.546 190.546 0 0 1-14.15-48H32.25C12.96 224-2.39 241.03.31 260.13 16.82 376.94 112.22 468.3 230.87 478.84c7.53.77 15.18 1.16 22.91 1.16h91.17c71.96 0 136.61-58.84 135.02-130.78-.69-31.13-12.86-59.21-31.97-81.07V240h16z"]
};
var faDumbbell = {
  prefix: 'far',
  iconName: 'dumbbell',
  icon: [640, 512, [], "f44b", "M632 224h-24v-72c0-30.9-25.1-56-56-56h-32c-2.7 0-5.4.4-8 .8V88c0-30.9-25.1-56-56-56h-32c-30.9 0-56 25.1-56 56v136h-96V88c0-30.9-25.1-56-56-56h-32c-30.9 0-56 25.1-56 56v8.8c-2.6-.4-5.3-.8-8-.8H88c-30.9 0-56 25.1-56 56v72H8c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h24v72c0 30.9 25.1 56 56 56h32c2.7 0 5.4-.4 8-.8v8.8c0 30.9 25.1 56 56 56h32c30.9 0 56-25.1 56-56V288h96v136c0 30.9 25.1 56 56 56h32c30.9 0 56-25.1 56-56v-8.8c2.6.4 5.3.8 8 .8h32c30.9 0 56-25.1 56-56v-72h24c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM120 368H88c-4.4 0-8-3.6-8-8V152c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v208c0 4.4-3.6 8-8 8zm104 56c0 4.4-3.6 8-8 8h-32c-4.4 0-8-3.6-8-8V88c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v336zm240 0c0 4.4-3.6 8-8 8h-32c-4.4 0-8-3.6-8-8V88c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v336zm96-64c0 4.4-3.6 8-8 8h-32c-4.4 0-8-3.6-8-8V152c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v208z"]
};
var faDumpster = {
  prefix: 'far',
  iconName: 'dumpster',
  icon: [576, 512, [], "f793", "M560 160c10.4 0 18-9.8 15.5-19.9l-24-96C549.7 37 543.3 32 536 32h-98.9l25.6 128H560zM404.5 32H304v128h126.1L404.5 32zM560 224h-20l4-32H32l4 32H16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h26l22 176v16c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16v-16h320v16c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16v-16l22-176h26c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm-90.4 176H106.4l-20-160h403.3l-20.1 160zM16 160h97.3l25.6-128H40c-7.3 0-13.7 5-15.5 12.1l-24 96C-2 150.2 5.6 160 16 160zM272 32H171.5l-25.6 128H272V32z"]
};
var faDumpsterFire = {
  prefix: 'far',
  iconName: 'dumpster-fire',
  icon: [640, 512, [], "f794", "M418.7 104.1l.2-.2-14.4-72H304v128h60.8c16.2-19.3 34.2-38.2 53.9-55.8zm42.6 0c18.2 16.3 35.5 33.7 51.1 51.5 5.7-5.6 11.4-11.1 17.3-16.3l21.3-19 21.3 19c1.1.9 2.1 2.1 3.1 3.1-.1-.8.2-1.5 0-2.3l-24-96C549.7 37 543.3 32 536 32h-98.9l12.3 61.5 11.9 10.6zM272 32H171.5l-25.6 128H272V32zM106.4 400l-20-160h225.3c7.9-15.7 17.6-31.9 28.9-48H32l4 32H16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h26l22 176v16c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16v-16h208.8c-12.8-14.3-23.5-30.4-31.6-48H106.4zM16 160h97.3l25.6-128H40c-7.3 0-13.7 5-15.5 12.1l-24 96C-2 150.2 5.6 160 16 160zm535.1 3.2c-14.9 13.3-28.3 27.2-40.2 41.2-19.5-25.8-43.6-52-71-76.4-70.2 62.7-120 144.3-120 193.6 0 87.5 71.6 158.4 160 158.4s160-70.9 160-158.4c.1-36.6-37-112.2-88.8-158.4zM480 432c-61.8 0-112-49.5-112-110.4 0-22.6 24.9-74.7 72.2-126.4 22.4 23.7 30.5 35.7 68.5 86.1 40.6-47.8 39.1-46.1 41.1-48.4 26.4 35.3 42.2 74 42.2 88.8 0 60.8-50.2 110.3-112 110.3z"]
};
var faDungeon = {
  prefix: 'far',
  iconName: 'dungeon',
  icon: [512, 512, [], "f6d9", "M512 295.43c0-8.47-1.91-16.51-5.33-23.7 3.66-7.9 5.48-16.63 5.14-25.42-1.32-35.2-9.77-69.19-25.09-101-4.32-8.97-10.97-16.45-19.02-21.85-1.4-9.57-5.29-18.7-11.41-26.4-21.33-26.84-47.35-48.81-77.33-65.3a55.498 55.498 0 0 0-26.64-6.84c-.44 0-.88 0-1.31.02-6.72-7.04-15.24-12.27-24.74-15C303.32 3.35 279.67 0 256 0s-47.32 3.35-70.29 9.95c-9.49 2.72-18 7.95-24.72 14.99-.44-.01-.88-.02-1.31-.02-9.29 0-18.49 2.36-26.62 6.83-29.99 16.5-56.01 38.47-77.35 65.32a55.208 55.208 0 0 0-11.41 26.39c-8.05 5.39-14.7 12.87-19.02 21.84C9.95 177.12 1.51 211.1.18 246.32c-.33 8.77 1.48 17.5 5.14 25.4A55.223 55.223 0 0 0 0 295.43v57.14c0 8.37 1.86 16.31 5.2 23.43-3.34 7.12-5.2 15.06-5.2 23.43v57.14C0 487.13 24.87 512 55.43 512h401.14c30.56 0 55.43-24.87 55.43-55.43v-57.14c0-8.37-1.86-16.31-5.2-23.43 3.33-7.12 5.2-15.06 5.2-23.43v-57.14zM112 456.57c0 4.1-3.33 7.43-7.43 7.43H55.43c-4.1 0-7.43-3.33-7.43-7.43v-57.14c0-4.1 3.33-7.43 7.43-7.43h49.14c4.1 0 7.43 3.33 7.43 7.43v57.14zm0-104c0 4.1-3.33 7.43-7.43 7.43H55.43c-4.1 0-7.43-3.33-7.43-7.43v-57.14c0-4.1 3.33-7.43 7.43-7.43h49.14c4.1 0 7.43 3.33 7.43 7.43v57.14zm21.22-148.4c-5.98 13.92-9.85 28.93-10.74 44.79-.22 3.92-3.26 7.04-7.19 7.04H55.81c-4.25 0-7.82-3.62-7.66-7.86 1.1-29.28 8.33-57 20.37-81.99 1.29-2.67 4.01-4.17 6.8-4.17 1.39 0 2.8.37 4.05 1.15l51.11 31.94c3.09 1.93 4.18 5.75 2.74 9.1zm16.94-33.11c-1.3 0-2.6-.35-3.79-1.09L95.3 138.05c-3.78-2.36-4.79-7.62-2.02-11.11 17.19-21.62 38.54-39.72 62.89-53.12a7.23 7.23 0 0 1 3.5-.89c3.03 0 5.99 1.85 7.17 4.86l22.1 56.24c1.31 3.33-.03 7-3.07 8.89a133.5 133.5 0 0 0-30.09 25.55c-1.47 1.68-3.53 2.59-5.62 2.59zM208 456c0 4.42-3.58 8-8 8h-16c-4.42 0-8-3.58-8-8V203.13c8.16-12.3 19.22-22.32 32-29.78V456zm64 0c0 4.42-3.58 8-8 8h-16c-4.42 0-8-3.58-8-8V161.62c5.23-.89 10.52-1.62 16-1.62s10.77.73 16 1.62V456zm16.88-329.27c-.64 0-1.3-.08-1.94-.24-10.99-2.81-20.99-4.2-30.95-4.2-10.02 0-20 1.41-30.92 4.2-.65.17-1.3.25-1.95.25-2.98 0-5.79-1.7-6.91-4.56l-22.04-56.09c-1.6-4.08.59-8.79 4.8-10C217.1 50.87 236.21 48 256 48s38.9 2.87 57.03 8.08c4.21 1.21 6.4 5.92 4.8 10l-22.04 56.1c-1.12 2.86-3.93 4.55-6.91 4.55zM336 456c0 4.42-3.58 8-8 8h-16c-4.42 0-8-3.58-8-8V173.36c12.78 7.46 23.84 17.47 32 29.78V456zm25.84-284.94c-2.08 0-4.14-.91-5.62-2.6a133.758 133.758 0 0 0-30.09-25.55c-3.04-1.89-4.38-5.56-3.07-8.89l22.1-56.24c1.18-3.01 4.13-4.86 7.17-4.86 1.19 0 2.39.28 3.5.89a208.882 208.882 0 0 1 62.89 53.12c2.77 3.49 1.76 8.75-2.02 11.11l-51.07 31.92c-1.19.75-2.5 1.1-3.79 1.1zm27.68 77.9c-.89-15.85-4.76-30.87-10.74-44.79-1.44-3.35-.35-7.17 2.74-9.1l51.11-31.94a7.639 7.639 0 0 1 4.05-1.15c2.79 0 5.51 1.5 6.8 4.17 12.04 24.99 19.27 52.71 20.37 81.99.16 4.24-3.41 7.86-7.66 7.86H396.7c-3.92 0-6.96-3.12-7.18-7.04zM464 456.57c0 4.1-3.33 7.43-7.43 7.43h-49.14c-4.1 0-7.43-3.33-7.43-7.43v-57.14c0-4.1 3.33-7.43 7.43-7.43h49.14c4.1 0 7.43 3.33 7.43 7.43v57.14zm0-104c0 4.1-3.33 7.43-7.43 7.43h-49.14c-4.1 0-7.43-3.33-7.43-7.43v-57.14c0-4.1 3.33-7.43 7.43-7.43h49.14c4.1 0 7.43 3.33 7.43 7.43v57.14z"]
};
var faEar = {
  prefix: 'far',
  iconName: 'ear',
  icon: [384, 512, [], "f5f0", "M192 92c-55.12 0-100 44.86-100 100 0 37.5 30.5 68 68 68 15.44 0 28 12.56 28 28s-12.56 28-28 28h-20c-6.62 0-12 5.39-12 12v16c0 6.61 5.38 12 12 12h20c37.5 0 68-30.5 68-68s-30.5-68-68-68c-15.44 0-28-12.56-28-28 0-33.08 26.91-60 60-60s60 26.92 60 60v20c0 6.61 5.38 12 12 12h16c6.62 0 12-5.39 12-12v-20c0-55.14-44.88-100-100-100zm0-92C85.96 0 0 85.96 0 192v176c0 79.53 64.47 144 144 144s144-64.47 144-144v-9.9c57.33-33.21 96-95.08 96-166.1C384 85.96 298.04 0 192 0zm71.94 316.57L240 330.44v37.57c0 52.93-43.06 96-96 96s-96-43.07-96-96V192c0-79.4 64.6-144 144-144s144 64.6 144 144c0 51.09-27.61 98.82-72.06 124.57z"]
};
var faEarMuffs = {
  prefix: 'far',
  iconName: 'ear-muffs',
  icon: [640, 512, [], "f795", "M621.4 305.2c-6.3-39.7-43.5-50-44.4-50.2-13.8-18.4-32.2-22.3-33.1-22.6V224C544 100.5 443.5.1 320 0 196.5.1 96 100.5 96 224v8.4c-.9.3-19.2 4.2-33.1 22.6-.9.3-38 10.5-44.4 50.2-15 15-23.5 38.8-15.3 63.2-7.8 24.2.5 48 15.7 63 5.2 30.3 28.2 45 44.9 50.1.5.7 23.7 32.6 66 23.9 8.9 4.3 18.7 6.6 29 6.6 36 0 65.3-28.3 65.3-63.1 0-6.9-1.2-13.7-3.6-20.2 6.4-17.6 2.8-32.9.2-40.5 6.1-17.6 2.6-32.7 0-40.3 2.7-7.6 6.2-22.8-.2-40.5 2.4-6.5 3.6-13.3 3.6-20.2 0-34.8-29.3-63.1-65.3-63.1h-14.7c0-97 78.9-176 176-176 97 0 176 79 176 176h-14.7c-36 0-65.3 28.3-65.3 63.1 0 6.9 1.2 13.7 3.6 20.2-6.4 17.6-2.8 32.9-.2 40.5-2.6 7.6-6.1 22.7 0 40.3-2.6 7.6-6.2 22.8.2 40.5-2.4 6.5-3.6 13.3-3.6 20.2 0 34.8 29.3 63.1 65.3 63.1 10.2 0 20.1-2.3 29-6.6 42.3 8.7 65.5-23.2 66-23.9 16.7-5.1 39.7-19.8 44.9-50.1 15.2-15 23.5-38.7 15.7-63 8-24.4-.5-48.2-15.6-63.2zM167.5 314c11.7 10.1 11.1 26.5 0 36 11.7 10.1 11.1 26.5 0 36 11.7 10.1 11.1 26.5 0 36 24.5 21-7.7 57.1-31.4 35.6-16 14.5-41.3 2.5-39.7-19.3-20.5 7.7-38.2-13-30.5-31.6-16.9-4.5-24.1-24.8-11.5-38.7-12.6-13.9-5.4-34.2 11.5-38.8-7.7-18.5 9.7-39.3 30.5-31.6-1.6-21.8 23.6-33.9 39.7-19.3 23.7-21.5 55.8 14.7 31.4 35.7zm406.6 92.8c7.8 18.6-9.9 39.2-30.5 31.6 1.6 21.8-23.6 33.9-39.7 19.3-23.7 21.4-55.9-14.7-31.4-35.7-11.1-9.5-11.7-25.9 0-36-11.1-9.5-11.7-25.9 0-36-11.1-9.5-11.7-25.9 0-36-24.4-21 7.7-57.2 31.4-35.6 16-14.5 41.3-2.5 39.7 19.3 20.7-7.8 38.2 13.1 30.5 31.6 16.9 4.6 24.1 24.9 11.5 38.8 12.6 13.8 5.4 34.1-11.5 38.7z"]
};
var faEclipse = {
  prefix: 'far',
  iconName: 'eclipse',
  icon: [640, 512, [], "f749", "M448 64c-106 0-192 86-192 192s86 192 192 192 192-86 192-192S554 64 448 64zm0 336c-79.4 0-144-64.6-144-144s64.6-144 144-144 144 64.6 144 144-64.6 144-144 144zm-192 58l-51.9-77-90.9 17.6 17.6-91.2-76.8-52 76.8-52-17.6-91.2 91 17.6L256 53l31.7 46.9c11.2-11.5 23.7-21.9 37.2-30.8l-35.3-52.4c-15.1-22.3-51.9-22.3-67 0l-40.4 59.9-70.8-13.7C98 60.4 84.5 64.5 75 74.1s-13.7 23.1-11.1 36.3l13.7 71-59.8 40.5C6.6 229.5 0 242 0 255.5s6.7 26 17.8 33.5l59.8 40.5-13.7 71c-2.6 13.2 1.6 26.8 11.1 36.3 9.5 9.5 22.9 13.7 36.3 11.1l70.8-13.7 40.4 59.9C230 505.3 242.6 512 256 512s26-6.7 33.5-17.8l34.8-51.6c-13.5-9-25.8-19.4-37.1-30.9L256 458zm-26.4-251.1c4.3-19.1 11-37.3 19.9-54.3-54.3 3.5-97.5 48.3-97.5 103.4s43.2 99.9 97.5 103.3c-8.9-16.9-15.6-35.1-19.9-54.3-17.5-9.5-29.6-27.8-29.6-49.1s12.1-39.5 29.6-49z"]
};
var faEclipseAlt = {
  prefix: 'far',
  iconName: 'eclipse-alt',
  icon: [512, 512, [], "f74a", "M326.1 309.2c-46.5 8.9-89.3-26.8-89.3-73.9 0-27.1 14.5-52 38-65.4 3.6-2.1 2.7-7.6-1.4-8.3-5.8-1.1-11.6-1.6-17.5-1.6-52.9 0-95.9 42.9-95.9 96 0 53 42.9 96 95.9 96 29.6 0 56.6-13.5 74.5-35.5 2.7-3.3-.2-8.1-4.3-7.3zm168.1-87.3l-59.8-40.5 13.7-71c2.6-13.2-1.6-26.8-11.1-36.4-9.6-9.5-23.2-13.7-36.2-11.1l-70.9 13.7-40.4-59.9c-15.1-22.3-51.9-22.3-67 0l-40.4 59.9-70.8-13.7C98 60.4 84.5 64.5 75 74.1c-9.5 9.6-13.7 23.1-11.1 36.3l13.7 71-59.8 40.5C6.6 229.5 0 242 0 255.5s6.7 26 17.8 33.5l59.8 40.5-13.7 71c-2.6 13.2 1.6 26.8 11.1 36.3 9.5 9.5 22.9 13.7 36.3 11.1l70.8-13.7 40.4 59.9C230 505.3 242.6 512 256 512s26-6.7 33.5-17.8l40.4-59.9 70.9 13.7c13.4 2.7 26.8-1.6 36.3-11.1 9.5-9.5 13.6-23.1 11.1-36.3l-13.7-71 59.8-40.5c11.1-7.5 17.8-20.1 17.8-33.5-.1-13.6-6.7-26.1-17.9-33.7zm-112.9 85.6l17.6 91.2-91-17.6L256 458l-51.9-77-90.9 17.6 17.6-91.2-76.8-52 76.8-52-17.6-91.2 91 17.6L256 53l51.9 76.9 91-17.6-17.6 91.1 76.8 52-76.8 52.1z"]
};
var faEdit = {
  prefix: 'far',
  iconName: 'edit',
  icon: [576, 512, [], "f044", "M402.3 344.9l32-32c5-5 13.7-1.5 13.7 5.7V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h273.5c7.1 0 10.7 8.6 5.7 13.7l-32 32c-1.5 1.5-3.5 2.3-5.7 2.3H48v352h352V350.5c0-2.1.8-4.1 2.3-5.6zm156.6-201.8L296.3 405.7l-90.4 10c-26.2 2.9-48.5-19.2-45.6-45.6l10-90.4L432.9 17.1c22.9-22.9 59.9-22.9 82.7 0l43.2 43.2c22.9 22.9 22.9 60 .1 82.8zM460.1 174L402 115.9 216.2 301.8l-7.3 65.3 65.3-7.3L460.1 174zm64.8-79.7l-43.2-43.2c-4.1-4.1-10.8-4.1-14.8 0L436 82l58.1 58.1 30.9-30.9c4-4.2 4-10.8-.1-14.9z"]
};
var faEgg = {
  prefix: 'far',
  iconName: 'egg',
  icon: [384, 512, [], "f7fb", "M192 0C86 0 0 214 0 320s86 192 192 192 192-86 192-192S298 0 192 0zm0 464c-79.4 0-144-64.6-144-144 0-117.41 90.58-272 144-272s144 154.59 144 272c0 79.4-64.6 144-144 144z"]
};
var faEggFried = {
  prefix: 'far',
  iconName: 'egg-fried',
  icon: [512, 512, [], "f7fc", "M478.32 150.45c-39.5-40.71-100.73-46.29-144.39-82.24S255.63 0 200.54 0a157.74 157.74 0 0 0-25.15 2.1c-86.78 14-111.71 80-125 157.13-11.1 64.34-54.41 127-50 192.91s52.83 128.45 114.97 150.75c17.64 6.32 33.83 9.11 48.92 9.11 64.66 0 108.94-51.18 155.72-95.56 43.68-41.44 93.4-37.72 140.93-73.89 56.28-42.82 71.71-140.55 17.39-192.1zm-46.43 153.84C415.7 316.61 398.22 323 378 330.39c-28.26 10.33-60.29 22-91 51.18-5.51 5.23-11 10.55-16.48 15.88C233.77 433.13 202.05 464 164.28 464c-10.22 0-20.92-2.06-32.72-6.29C87.09 441.7 51.26 395 48.2 349c-1.92-29 10.31-61.4 23.26-95.69 10.3-27.28 21-55.49 26.19-85.85C111.48 87.34 133 57.6 183 49.54a110.62 110.62 0 0 1 17.52-1.49c32.33 0 54.3 17 93.51 49.5l9.39 7.77c25.45 21 54.09 33.12 79.36 43.85 25 10.6 46.52 19.75 61.08 34.76l.69.71.72.68c17.78 16.88 19.27 40.81 18.57 53.57-1.39 26.03-13.95 51.7-31.95 65.4zM224 128.14c-61.72 0-112 50.3-112 112.13s50.24 112.11 112 112.11 112-50.3 112-112.11-50.21-112.13-112-112.13zm0 72.07a40.08 40.08 0 0 0-40 40.06 16 16 0 1 1-32 0 72.13 72.13 0 0 1 72-72.09 16 16 0 0 1 0 32z"]
};
var faEject = {
  prefix: 'far',
  iconName: 'eject',
  icon: [448, 512, [], "f052", "M400 320H48c-26.51 0-48 21.49-48 48v64c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48v-64c0-26.51-21.49-48-48-48zm0 112H48v-64h352v64zM48.048 304h351.895c42.637 0 64.151-51.731 33.941-81.941l-175.943-176c-18.745-18.745-49.137-18.746-67.882 0l-175.952 176C-16.042 252.208 5.325 304 48.048 304zM224 80l176 176H48L224 80z"]
};
var faElephant = {
  prefix: 'far',
  iconName: 'elephant',
  icon: [640, 512, [], "f6da", "M528 127.97c-8.84 0-16 7.16-16 16s7.16 16 16 16 16-7.16 16-16-7.16-16-16-16zm-16-96h-61.16c-3.64-3.77-7.46-7.4-11.71-10.66-25.97-19.88-59.44-26.22-91.82-17.46-18.04 4.9-33.88 14.96-46.49 28.11H192C85.96 31.97 0 117.93 0 223.98v112.01c0 8.84 7.16 16 16 16h16V480c0 17.67 14.33 32 32 32h80c17.67 0 32-14.33 32-32v-72.84c18.48 5.11 66.55 16.98 128 0V480c0 17.67 14.33 32 32 32h80c17.67 0 32-14.33 32-32V287.98h144v88.01c0 13.24-10.78 24-24 24s-24-10.77-24-24v-8c0-8.84-7.16-16-16-16h-16c-8.84 0-16 7.16-16 16v4.78c0 37.58 27.38 71.2 64.78 74.87 42.91 4.21 79.22-29.56 79.22-71.65V159.97c0-70.69-57.31-128-128-128zM400 464h-48V344.09c-120.67 33.34-111.08 31.2-224 0V464H80V303.98H48v-80.01c0-79.54 64.47-144.01 144-144.01h83.24c-6.11 26.93-2.43 54.18 11.54 77.47 11.53 19.19 28.91 34.05 49.22 42.53 0 40.15 27.18 73.73 64 84.26V464zm192-256.02c0 17.67-14.33 32-32 32H424c-22.06 0-40-17.94-40-40v-37.24c-22.65-4.59-41.89-6.4-56.06-30-16.43-27.46-7.38-71.86 31.94-82.57 29.16-7.91 55.52 6.33 66.66 29.8H512c44.11 0 80 35.89 80 80.01v48z"]
};
var faEllipsisH = {
  prefix: 'far',
  iconName: 'ellipsis-h',
  icon: [512, 512, [], "f141", "M304 256c0 26.5-21.5 48-48 48s-48-21.5-48-48 21.5-48 48-48 48 21.5 48 48zm120-48c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48zm-336 0c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z"]
};
var faEllipsisHAlt = {
  prefix: 'far',
  iconName: 'ellipsis-h-alt',
  icon: [512, 512, [], "f39b", "M256 184c-39.8 0-72 32.2-72 72s32.2 72 72 72 72-32.2 72-72-32.2-72-72-72zm0 96c-13.2 0-24-10.8-24-24s10.8-24 24-24 24 10.8 24 24-10.8 24-24 24zm176-96c-39.8 0-72 32.2-72 72s32.2 72 72 72 72-32.2 72-72-32.2-72-72-72zm0 96c-13.2 0-24-10.8-24-24s10.8-24 24-24 24 10.8 24 24-10.8 24-24 24zM80 184c-39.8 0-72 32.2-72 72s32.2 72 72 72 72-32.2 72-72-32.2-72-72-72zm0 96c-13.2 0-24-10.8-24-24s10.8-24 24-24 24 10.8 24 24-10.8 24-24 24z"]
};
var faEllipsisV = {
  prefix: 'far',
  iconName: 'ellipsis-v',
  icon: [128, 512, [], "f142", "M64 208c26.5 0 48 21.5 48 48s-21.5 48-48 48-48-21.5-48-48 21.5-48 48-48zM16 104c0 26.5 21.5 48 48 48s48-21.5 48-48-21.5-48-48-48-48 21.5-48 48zm0 304c0 26.5 21.5 48 48 48s48-21.5 48-48-21.5-48-48-48-48 21.5-48 48z"]
};
var faEllipsisVAlt = {
  prefix: 'far',
  iconName: 'ellipsis-v-alt',
  icon: [192, 512, [], "f39c", "M96 184c-39.8 0-72 32.2-72 72s32.2 72 72 72 72-32.2 72-72-32.2-72-72-72zm0 96c-13.2 0-24-10.8-24-24s10.8-24 24-24 24 10.8 24 24-10.8 24-24 24zm0 80c-39.8 0-72 32.2-72 72s32.2 72 72 72 72-32.2 72-72-32.2-72-72-72zm0 96c-13.2 0-24-10.8-24-24s10.8-24 24-24 24 10.8 24 24-10.8 24-24 24zm0-304c39.8 0 72-32.2 72-72S135.8 8 96 8 24 40.2 24 80s32.2 72 72 72zm0-96c13.2 0 24 10.8 24 24s-10.8 24-24 24-24-10.8-24-24 10.8-24 24-24z"]
};
var faEmptySet = {
  prefix: 'far',
  iconName: 'empty-set',
  icon: [448, 512, [], "f656", "M443.31 48L432 36.69c-6.25-6.25-16.38-6.25-22.63 0l-67.77 67.77C309.09 79.19 268.36 64 224 64 117.96 64 32 149.96 32 256c0 44.36 15.19 85.09 40.46 117.6L4.69 441.38c-6.25 6.25-6.25 16.38 0 22.63L16 475.31c6.25 6.25 16.38 6.25 22.63 0l67.77-67.77C138.9 432.81 179.64 448 224 448c106.04 0 192-85.96 192-192 0-44.36-15.19-85.09-40.46-117.6l67.77-67.77c6.25-6.25 6.25-16.39 0-22.63zM80 256c0-79.4 64.6-144 144-144 31.04 0 59.64 10.11 83.18 26.88l-200.31 200.3C90.1 315.64 80 287.05 80 256zm288 0c0 79.4-64.6 144-144 144-31.05 0-59.64-10.1-83.19-26.88l200.31-200.3C357.9 196.36 368 224.96 368 256z"]
};
var faEngineWarning = {
  prefix: 'far',
  iconName: 'engine-warning',
  icon: [640, 512, [], "f5f2", "M320 32C196.3 32 96 132.3 96 256c0 123.76 100.3 224 224 224s224-100.24 224-224c0-123.7-100.3-224-224-224zm0 400c-97.05 0-176-78.95-176-176S222.95 80 320 80s176 78.95 176 176-78.95 176-176 176zm0-112c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm22.32-192h-44.64c-9.47 0-16.86 8.17-15.92 17.59l12.8 128c.82 8.18 7.7 14.41 15.92 14.41h19.04c8.22 0 15.1-6.23 15.92-14.41l12.8-128c.94-9.42-6.45-17.59-15.92-17.59zM48 256c0-59.53 19.55-117.38 55.36-164.51 5.18-6.81 4.48-16.31-2.03-21.86l-12.2-10.41c-6.91-5.9-17.62-5.06-23.15 2.15C23.32 117.02 0 185.5 0 256c0 70.47 23.32 138.96 65.96 194.62 5.53 7.21 16.23 8.05 23.15 2.16l12.19-10.4c6.51-5.55 7.21-15.04 2.04-21.86C67.55 373.37 48 315.53 48 256zM572.73 59.71c-5.58-7.18-16.29-7.95-23.17-2l-12.15 10.51c-6.47 5.6-7.1 15.09-1.88 21.87C572.04 137.47 592 195.81 592 256c0 60.23-19.96 118.57-56.46 165.95-5.22 6.78-4.59 16.27 1.88 21.87l12.15 10.5c6.87 5.95 17.59 5.18 23.17-2C616.21 396.38 640 327.31 640 256c0-71.27-23.79-140.34-67.27-196.29z"]
};
var faEnvelope = {
  prefix: 'far',
  iconName: 'envelope',
  icon: [512, 512, [], "f0e0", "M464 64H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zm0 48v40.805c-22.422 18.259-58.168 46.651-134.587 106.49-16.841 13.247-50.201 45.072-73.413 44.701-23.208.375-56.579-31.459-73.413-44.701C106.18 199.465 70.425 171.067 48 152.805V112h416zM48 400V214.398c22.914 18.251 55.409 43.862 104.938 82.646 21.857 17.205 60.134 55.186 103.062 54.955 42.717.231 80.509-37.199 103.053-54.947 49.528-38.783 82.032-64.401 104.947-82.653V400H48z"]
};
var faEnvelopeOpen = {
  prefix: 'far',
  iconName: 'envelope-open',
  icon: [512, 512, [], "f2b6", "M494.586 164.516c-4.697-3.883-111.723-89.95-135.251-108.657C337.231 38.191 299.437 0 256 0c-43.205 0-80.636 37.717-103.335 55.859-24.463 19.45-131.07 105.195-135.15 108.549A48.004 48.004 0 0 0 0 201.485V464c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V201.509a48 48 0 0 0-17.414-36.993zM464 458a6 6 0 0 1-6 6H54a6 6 0 0 1-6-6V204.347c0-1.813.816-3.526 2.226-4.665 15.87-12.814 108.793-87.554 132.364-106.293C200.755 78.88 232.398 48 256 48c23.693 0 55.857 31.369 73.41 45.389 23.573 18.741 116.503 93.493 132.366 106.316a5.99 5.99 0 0 1 2.224 4.663V458zm-31.991-187.704c4.249 5.159 3.465 12.795-1.745 16.981-28.975 23.283-59.274 47.597-70.929 56.863C336.636 362.283 299.205 400 256 400c-43.452 0-81.287-38.237-103.335-55.86-11.279-8.967-41.744-33.413-70.927-56.865-5.21-4.187-5.993-11.822-1.745-16.981l15.258-18.528c4.178-5.073 11.657-5.843 16.779-1.726 28.618 23.001 58.566 47.035 70.56 56.571C200.143 320.631 232.307 352 256 352c23.602 0 55.246-30.88 73.41-45.389 11.994-9.535 41.944-33.57 70.563-56.568 5.122-4.116 12.601-3.346 16.778 1.727l15.258 18.526z"]
};
var faEnvelopeOpenDollar = {
  prefix: 'far',
  iconName: 'envelope-open-dollar',
  icon: [512, 512, [], "f657", "M230.72 233.72l42.19 11.44c4.19 1.14 7.09 4.55 7.09 8.3 0 4.8-4.5 8.7-10.06 8.7H243.6c-4.15 0-8.23-1.04-11.77-2.95-3.08-1.67-6.84-1.37-9.24 1.18l-12.07 12.73c-3.11 3.28-2.6 8.64 1.13 11.19 8.3 5.65 18.06 8.88 28.35 9.52V304c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-10.25c22.18-1.1 40-18.57 40-40.3 0-18.17-12.62-34.28-30.72-39.17l-42.19-11.44c-4.19-1.14-7.09-4.55-7.09-8.3 0-4.8 4.5-8.7 10.06-8.7h26.34c4.15 0 8.23 1.04 11.77 2.95 3.08 1.66 6.84 1.37 9.24-1.18l12.07-12.73c3.11-3.28 2.6-8.64-1.13-11.19-8.3-5.65-18.06-8.88-28.35-9.52V144c0-4.42-3.58-8-8-8h-16c-4.42 0-8 3.58-8 8v10.25c-22.18 1.1-40 18.57-40 40.3 0 18.17 12.62 34.28 30.72 39.17zm263.87-69.2c-1.52-1.26-13.86-11.2-30.59-24.66V96c0-26.51-21.49-48-48-48h-66.13C327.24 28.85 293.77 0 256 0c-37.65 0-70.9 28.63-93.85 48H96c-26.51 0-48 21.49-48 48v43.85c-16.81 13.52-29.15 23.46-30.48 24.56A48.002 48.002 0 0 0 0 201.48V464c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V201.51c0-14.31-6.38-27.88-17.41-36.99zM96 96h320v156.66c-36.26 29.32-78.69 63.67-86.59 69.95C311.25 337.12 279.6 368 256 368c-23.69 0-55.86-31.37-73.41-45.39-7.9-6.28-50.33-40.64-86.59-69.97V96zm368 362c0 3.31-2.69 6-6 6H54c-3.31 0-6-2.69-6-6V275.56c38.96 31.48 95.95 77.65 104.66 84.58C174.71 377.76 212.55 416 256 416c43.21 0 80.64-37.72 103.34-55.86 9-7.15 65.84-53.19 104.66-84.56V458z"]
};
var faEnvelopeOpenText = {
  prefix: 'far',
  iconName: 'envelope-open-text',
  icon: [512, 512, [], "f658", "M494.59 164.52c-1.52-1.26-13.86-11.2-30.59-24.66V96c0-26.51-21.49-48-48-48h-66.13C327.24 28.85 293.77 0 256 0c-37.65 0-70.9 28.63-93.85 48H96c-26.51 0-48 21.49-48 48v43.85c-16.81 13.52-29.15 23.46-30.48 24.56A48.002 48.002 0 0 0 0 201.48V464c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V201.51c0-14.31-6.38-27.88-17.41-36.99zM96 96h320v156.66c-36.26 29.32-78.69 63.67-86.59 69.95C311.25 337.12 279.6 368 256 368c-23.69 0-55.86-31.37-73.41-45.39-7.9-6.28-50.33-40.64-86.59-69.97V96zm368 362c0 3.31-2.69 6-6 6H54c-3.31 0-6-2.69-6-6V275.56c38.96 31.48 95.95 77.65 104.66 84.58C174.71 377.76 212.55 416 256 416c43.21 0 80.64-37.72 103.34-55.86 9-7.15 65.84-53.19 104.66-84.56V458zM176 192h160c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16H176c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16zm176 64v-16c0-8.84-7.16-16-16-16H176c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h160c8.84 0 16-7.16 16-16z"]
};
var faEnvelopeSquare = {
  prefix: 'far',
  iconName: 'envelope-square',
  icon: [448, 512, [], "f199", "M187.293 260.374C114.743 210.491 115.482 210.366 96 196v-12c0-13.255 10.745-24 24-24h208c13.255 0 24 10.745 24 24v12c-19.497 14.376-18.747 14.494-91.293 64.374-8.414 5.812-25.104 19.79-36.707 19.625-11.6.166-28.296-13.816-36.707-19.625zm91.563 26.355C267.519 294.575 247.377 312.105 224 312c-23.241.104-43.082-17.118-54.849-25.266-45.054-30.977-62.02-42.883-73.151-50.958V328c0 13.255 10.745 24 24 24h208c13.255 0 24-10.745 24-24v-92.224c-11.13 8.074-28.094 19.978-73.144 50.953zM448 80v352c0 26.51-21.49 48-48 48H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48zm-48 346V86a6 6 0 0 0-6-6H54a6 6 0 0 0-6 6v340a6 6 0 0 0 6 6h340a6 6 0 0 0 6-6z"]
};
var faEquals = {
  prefix: 'far',
  iconName: 'equals',
  icon: [384, 512, [], "f52c", "M368 304H16c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16h352c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16zm0-160H16c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16h352c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16z"]
};
var faEraser = {
  prefix: 'far',
  iconName: 'eraser',
  icon: [512, 512, [], "f12d", "M497.94 273.94a48 48 0 0 0 0-67.88l-160-160a48 48 0 0 0-67.88 0l-256 256a48 48 0 0 0 0 67.88l96 96A48 48 0 0 0 144 480h356a12 12 0 0 0 12-12v-24a12 12 0 0 0-12-12H339.88l158.06-158.06zM304 80l160 160-103 103-160-160zM144 432l-96-96 119-119 160 160-55 55z"]
};
var faEthernet = {
  prefix: 'far',
  iconName: 'ethernet',
  icon: [512, 512, [], "f796", "M496 192h-48v-48c0-8.8-7.2-16-16-16h-48V80c0-8.8-7.2-16-16-16H144c-8.8 0-16 7.2-16 16v48H80c-8.8 0-16 7.2-16 16v48H16c-8.8 0-16 7.2-16 16v224c0 8.8 7.2 16 16 16h480c8.8 0 16-7.2 16-16V208c0-8.8-7.2-16-16-16zm-32 208h-48V288h-32v112h-64V288h-32v112h-64V288h-32v112h-64V288H96v112H48V240h64v-64h64v-64h160v64h64v64h64v160z"]
};
var faEuroSign = {
  prefix: 'far',
  iconName: 'euro-sign',
  icon: [320, 512, [], "f153", "M315.6 458.6l-6.5-29.4c-1.4-6.5-8-10.6-14.5-9.1-10.3 2.4-26.5 5.4-44.7 5.4-65.5 0-117-39.5-138.2-97.4h129.5c5.7 0 10.6-4 11.7-9.6l5-24c1.5-7.5-4.1-14.4-11.7-14.4h-148c-1.5-16.1-2.1-32.3-.6-48h162.5c5.7 0 10.6-4 11.7-9.5l5.1-24c1.6-7.5-4.1-14.5-11.7-14.5H108.1c21-58.4 72.5-98 140-98 14.7 0 28.9 2.1 38.2 3.8 6.2 1.1 12.2-2.6 13.8-8.7l7.9-29.6c1.8-6.8-2.5-13.6-9.4-14.9-11.4-2.1-29.4-4.7-49.3-4.7-100 0-179.7 64.1-205.9 152H12c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h23.1c-1.2 15.8-1 35.5.4 48H12c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h32.2c26 88.7 103.4 152 205 152 24.4 0 45.4-4.2 57.5-7.2 6.4-1.6 10.3-7.9 8.9-14.2z"]
};
var faExchange = {
  prefix: 'far',
  iconName: 'exchange',
  icon: [512, 512, [], "f0ec", "M508.485 168.485l-100.375 100c-4.686 4.686-12.284 4.686-16.97 0l-19.626-19.626c-4.753-4.753-4.675-12.484.173-17.14L422.916 184H12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h410.916l-51.228-47.719c-4.849-4.656-4.927-12.387-.173-17.14l19.626-19.626c4.686-4.686 12.284-4.686 16.97 0l100.375 100c4.685 4.686 4.685 12.284-.001 16.97zm-504.97 192l100.375 100c4.686 4.686 12.284 4.686 16.97 0l19.626-19.626c4.753-4.753 4.675-12.484-.173-17.14L89.084 376H500c6.627 0 12-5.373 12-12v-24c0-6.627-5.373-12-12-12H89.084l51.228-47.719c4.849-4.656 4.927-12.387.173-17.14l-19.626-19.626c-4.686-4.686-12.284-4.686-16.97 0l-100.375 100c-4.686 4.686-4.686 12.284.001 16.97z"]
};
var faExchangeAlt = {
  prefix: 'far',
  iconName: 'exchange-alt',
  icon: [512, 512, [], "f362", "M508.485 168.48l-96.16 96.16c-7.58 7.58-20.485 2.14-20.485-8.485L391.833 184H12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h379.833l.01-72.162c.001-10.683 12.949-16.022 20.485-8.485l96.156 96.156c4.687 4.686 4.688 12.285.001 16.971zM3.515 360.491l96.156 96.156c7.536 7.536 20.484 2.198 20.485-8.485l.01-72.162H500c6.627 0 12-5.373 12-12v-24c0-6.628-5.373-12-12-12H120.167l-.007-72.154c0-10.625-12.905-16.066-20.485-8.485l-96.16 96.16c-4.687 4.685-4.686 12.284 0 16.97z"]
};
var faExclamation = {
  prefix: 'far',
  iconName: 'exclamation',
  icon: [256, 512, [], "f12a", "M173.854 48c6.874 0 12.343 5.763 11.984 12.628l-11.742 224c-.334 6.375-5.6 11.372-11.984 11.372H93.888c-6.383 0-11.65-4.997-11.984-11.372l-11.742-224C69.802 53.763 75.271 48 82.146 48h91.708M128 336c35.29 0 64 28.71 64 64s-28.71 64-64 64-64-28.71-64-64 28.71-64 64-64M173.854 0H82.146C47.881 0 20.427 28.783 22.228 63.141l11.742 224c.698 13.309 5.689 25.414 13.592 35.001C28.035 342.31 16 369.777 16 400c0 61.757 50.243 112 112 112s112-50.243 112-112c0-30.223-12.035-57.69-31.561-77.858a59.78 59.78 0 0 0 13.592-35.001l11.742-224C235.566 28.922 208.259 0 173.854 0z"]
};
var faExclamationCircle = {
  prefix: 'far',
  iconName: 'exclamation-circle',
  icon: [512, 512, [], "f06a", "M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 448c-110.532 0-200-89.431-200-200 0-110.495 89.472-200 200-200 110.491 0 200 89.471 200 200 0 110.53-89.431 200-200 200zm42-104c0 23.159-18.841 42-42 42s-42-18.841-42-42 18.841-42 42-42 42 18.841 42 42zm-81.37-211.401l6.8 136c.319 6.387 5.591 11.401 11.985 11.401h41.17c6.394 0 11.666-5.014 11.985-11.401l6.8-136c.343-6.854-5.122-12.599-11.985-12.599h-54.77c-6.863 0-12.328 5.745-11.985 12.599z"]
};
var faExclamationSquare = {
  prefix: 'far',
  iconName: 'exclamation-square',
  icon: [448, 512, [], "f321", "M448 80v352c0 26.51-21.49 48-48 48H48c-26.51 0-48-21.49-48-48V80c0-26.51 21.49-48 48-48h352c26.51 0 48 21.49 48 48zm-48 346V86a6 6 0 0 0-6-6H54a6 6 0 0 0-6 6v340a6 6 0 0 0 6 6h340a6 6 0 0 0 6-6zm-134-74c0 23.159-18.841 42-42 42s-42-18.841-42-42 18.841-42 42-42 42 18.841 42 42zm-81.37-211.401l6.8 136c.319 6.387 5.591 11.401 11.985 11.401h41.17c6.394 0 11.666-5.014 11.985-11.401l6.8-136c.343-6.854-5.122-12.599-11.985-12.599h-54.77c-6.863 0-12.328 5.745-11.985 12.599z"]
};
var faExclamationTriangle = {
  prefix: 'far',
  iconName: 'exclamation-triangle',
  icon: [576, 512, [], "f071", "M248.747 204.705l6.588 112c.373 6.343 5.626 11.295 11.979 11.295h41.37a12 12 0 0 0 11.979-11.295l6.588-112c.405-6.893-5.075-12.705-11.979-12.705h-54.547c-6.903 0-12.383 5.812-11.978 12.705zM330 384c0 23.196-18.804 42-42 42s-42-18.804-42-42 18.804-42 42-42 42 18.804 42 42zm-.423-360.015c-18.433-31.951-64.687-32.009-83.154 0L6.477 440.013C-11.945 471.946 11.118 512 48.054 512H527.94c36.865 0 60.035-39.993 41.577-71.987L329.577 23.985zM53.191 455.002L282.803 57.008c2.309-4.002 8.085-4.002 10.394 0l229.612 397.993c2.308 4-.579 8.998-5.197 8.998H58.388c-4.617.001-7.504-4.997-5.197-8.997z"]
};
var faExpand = {
  prefix: 'far',
  iconName: 'expand',
  icon: [448, 512, [], "f065", "M0 180V56c0-13.3 10.7-24 24-24h124c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12H48v100c0 6.6-5.4 12-12 12H12c-6.6 0-12-5.4-12-12zM288 44v24c0 6.6 5.4 12 12 12h100v100c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12V56c0-13.3-10.7-24-24-24H300c-6.6 0-12 5.4-12 12zm148 276h-24c-6.6 0-12 5.4-12 12v100H300c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h124c13.3 0 24-10.7 24-24V332c0-6.6-5.4-12-12-12zM160 468v-24c0-6.6-5.4-12-12-12H48V332c0-6.6-5.4-12-12-12H12c-6.6 0-12 5.4-12 12v124c0 13.3 10.7 24 24 24h124c6.6 0 12-5.4 12-12z"]
};
var faExpandAlt = {
  prefix: 'far',
  iconName: 'expand-alt',
  icon: [448, 512, [], "f424", "M448 56v95.005c0 21.382-25.851 32.09-40.971 16.971l-27.704-27.704-107.242 107.243c-4.686 4.686-12.284 4.686-16.971 0l-22.627-22.627c-4.686-4.686-4.686-12.284 0-16.971l107.243-107.243-27.704-27.704C296.905 57.851 307.613 32 328.995 32H424c13.255 0 24 10.745 24 24zM175.917 264.485L68.674 371.728 40.97 344.024C25.851 328.905 0 339.613 0 360.995V456c0 13.255 10.745 24 24 24h95.005c21.382 0 32.09-25.851 16.971-40.971l-27.704-27.704 107.243-107.243c4.686-4.686 4.686-12.284 0-16.971l-22.627-22.627c-4.687-4.685-12.285-4.685-16.971.001z"]
};
var faExpandArrows = {
  prefix: 'far',
  iconName: 'expand-arrows',
  icon: [448, 512, [], "f31d", "M447.9 332l.1 136c0 6.6-5.4 12-12 12l-136-.1c-6.6 0-12-5.4-12-12v-27.8c0-6.7 5.5-12.1 12.2-12l61.4 2.3 1.4-1.4-139-139L85 429l1.4 1.4 61.4-2.3c6.7-.1 12.2 5.3 12.2 12v27.8c0 6.6-5.4 12-12 12L12 480c-6.6 0-12-5.4-12-12l.1-136c0-6.6 5.4-12 12-12h27.8c6.7 0 12.1 5.5 12 12.2l-2.3 61.4L51 395l139-139L51 117l-1.4 1.4 2.3 61.4c.1 6.7-5.3 12.2-12 12.2H12.1c-6.6 0-12-5.4-12-12L0 44c0-6.6 5.4-12 12-12l136 .1c6.6 0 12 5.4 12 12v27.8c0 6.7-5.5 12.1-12.2 12l-61.4-2.3L85 83l139 139L363 83l-1.4-1.4-61.4 2.3c-6.7.1-12.2-5.3-12.2-12V44.1c0-6.6 5.4-12 12-12l136-.1c6.6 0 12 5.4 12 12l-.1 136c0 6.6-5.4 12-12 12h-27.8c-6.7 0-12.1-5.5-12-12.2l2.3-61.4-1.4-1.4-139 139 139 139 1.4-1.4-2.3-61.4c-.1-6.7 5.3-12.2 12-12.2h27.8c6.6 0 12 5.4 12 12z"]
};
var faExpandArrowsAlt = {
  prefix: 'far',
  iconName: 'expand-arrows-alt',
  icon: [448, 512, [], "f31e", "M252.3 256l121.4 121.4 53.8-53.8c7.6-7.6 20.5-2.2 20.5 8.5v136c0 6.6-5.4 12-12 12H300c-10.7 0-16-12.9-8.5-20.5l53.8-53.8L224 284.3 102.6 405.7l53.8 53.8c7.6 7.6 2.2 20.5-8.5 20.5h-136c-6.6 0-12-5.4-12-12V332c0-10.7 12.9-16 20.5-8.5l53.8 53.8L195.7 256 74.3 134.6l-53.8 53.8C12.9 196 0 190.7 0 180V44c0-6.6 5.4-12 12-12h136c10.7 0 16 12.9 8.5 20.5l-53.8 53.8L224 227.7l121.4-121.4-53.8-53.8C284 44.9 289.3 32 300 32h136c6.6 0 12 5.4 12 12v136c0 10.7-12.9 16-20.5 8.5l-53.8-53.8L252.3 256z"]
};
var faExpandWide = {
  prefix: 'far',
  iconName: 'expand-wide',
  icon: [512, 512, [], "f320", "M0 212V88c0-13.3 10.7-24 24-24h124c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12H48v100c0 6.6-5.4 12-12 12H12c-6.6 0-12-5.4-12-12zM352 76v24c0 6.6 5.4 12 12 12h100v100c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12V88c0-13.3-10.7-24-24-24H364c-6.6 0-12 5.4-12 12zm148 212h-24c-6.6 0-12 5.4-12 12v100H364c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h124c13.3 0 24-10.7 24-24V300c0-6.6-5.4-12-12-12zM160 436v-24c0-6.6-5.4-12-12-12H48V300c0-6.6-5.4-12-12-12H12c-6.6 0-12 5.4-12 12v124c0 13.3 10.7 24 24 24h124c6.6 0 12-5.4 12-12z"]
};
var faExternalLink = {
  prefix: 'far',
  iconName: 'external-link',
  icon: [576, 512, [], "f08e", "M576 14.4l-.174 163.2c0 7.953-6.447 14.4-14.4 14.4H528.12c-8.067 0-14.56-6.626-14.397-14.691l2.717-73.627-2.062-2.062-278.863 278.865c-4.686 4.686-12.284 4.686-16.971 0l-23.029-23.029c-4.686-4.686-4.686-12.284 0-16.971L474.379 61.621l-2.062-2.062-73.626 2.717C390.626 62.44 384 55.946 384 47.879V14.574c0-7.953 6.447-14.4 14.4-14.4L561.6 0c7.953 0 14.4 6.447 14.4 14.4zM427.515 233.74l-24 24a12.002 12.002 0 0 0-3.515 8.485V458a6 6 0 0 1-6 6H54a6 6 0 0 1-6-6V118a6 6 0 0 1 6-6h301.976c10.691 0 16.045-12.926 8.485-20.485l-24-24A12.002 12.002 0 0 0 331.976 64H48C21.49 64 0 85.49 0 112v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V242.225c0-10.691-12.926-16.045-20.485-8.485z"]
};
var faExternalLinkAlt = {
  prefix: 'far',
  iconName: 'external-link-alt',
  icon: [576, 512, [], "f35d", "M448 241.823V464c0 26.51-21.49 48-48 48H48c-26.51 0-48-21.49-48-48V112c0-26.51 21.49-48 48-48h339.976c10.691 0 16.045 12.926 8.485 20.485l-24 24a12.002 12.002 0 0 1-8.485 3.515H54a6 6 0 0 0-6 6v340a6 6 0 0 0 6 6h340a6 6 0 0 0 6-6V265.823c0-3.183 1.264-6.235 3.515-8.485l24-24c7.559-7.56 20.485-2.206 20.485 8.485zM564 0H428.015c-10.658 0-16.039 12.93-8.485 20.485l48.187 48.201-272.202 272.202c-4.686 4.686-4.686 12.284 0 16.971l22.627 22.627c4.687 4.686 12.285 4.686 16.971 0l272.201-272.201 48.201 48.192c7.513 7.513 20.485 2.235 20.485-8.485V12c0-6.627-5.373-12-12-12z"]
};
var faExternalLinkSquare = {
  prefix: 'far',
  iconName: 'external-link-square',
  icon: [448, 512, [], "f14c", "M400 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zm-6 400H54a6 6 0 0 1-6-6V86a6 6 0 0 1 6-6h340a6 6 0 0 1 6 6v340a6 6 0 0 1-6 6zm-54-304l-136 .145c-6.627 0-12 5.373-12 12V167.9c0 6.722 5.522 12.133 12.243 11.998l58.001-2.141L99.515 340.485c-4.686 4.686-4.686 12.284 0 16.971l23.03 23.029c4.686 4.686 12.284 4.686 16.97 0l162.729-162.729-2.141 58.001c-.136 6.721 5.275 12.242 11.998 12.242h27.755c6.628 0 12-5.373 12-12L352 140c0-6.627-5.373-12-12-12z"]
};
var faExternalLinkSquareAlt = {
  prefix: 'far',
  iconName: 'external-link-square-alt',
  icon: [448, 512, [], "f360", "M400 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zm-6 400H54a6 6 0 0 1-6-6V86a6 6 0 0 1 6-6h340a6 6 0 0 1 6 6v340a6 6 0 0 1-6 6zm-54-304H204.015c-10.658 0-16.039 12.93-8.485 20.485l48.187 48.201L99.515 340.888c-4.686 4.686-4.686 12.284 0 16.971l22.627 22.627c4.687 4.686 12.285 4.686 16.971 0l144.201-144.201 48.201 48.192c7.513 7.513 20.485 2.235 20.485-8.485V140c0-6.627-5.373-12-12-12z"]
};
var faEye = {
  prefix: 'far',
  iconName: 'eye',
  icon: [576, 512, [], "f06e", "M288 144a110.94 110.94 0 0 0-31.24 5 55.4 55.4 0 0 1 7.24 27 56 56 0 0 1-56 56 55.4 55.4 0 0 1-27-7.24A111.71 111.71 0 1 0 288 144zm284.52 97.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 0 0 0 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 0 0 0-29.19zM288 400c-98.65 0-189.09-55-237.93-144C98.91 167 189.34 112 288 112s189.09 55 237.93 144C477.1 345 386.66 400 288 400z"]
};
var faEyeDropper = {
  prefix: 'far',
  iconName: 'eye-dropper',
  icon: [512, 512, [], "f1fb", "M483.89 28.14l-.02-.02-.03-.03c-37.47-37.47-98.26-37.46-135.72.03l-77.09 77.09-13.1-13.1c-9.44-9.44-24.65-9.31-33.94 0l-63.6 63.6c-9.37 9.37-9.37 24.57 0 33.94l16.98 16.98L50.75 333.25c-12 12-18.75 28.28-18.75 45.26V424L0 480l32 32 56-32h45.49c16.97 0 33.25-6.74 45.25-18.74l126.64-126.62 16.96 16.96c9.44 9.44 24.65 9.31 33.94 0l63.6-63.6c9.37-9.37 9.37-24.57 0-33.94l-13.1-13.1 77.09-77.09c37.5-37.47 37.5-98.25.02-135.73zM144.8 427.32a15.892 15.892 0 0 1-11.31 4.68H80v-53.49c0-4.27 1.66-8.29 4.69-11.31l126.63-126.62 60.12 60.12L144.8 427.32zm305.14-297.38l-77.09 77.09-33.94 33.94 30.07 30.06-29.66 29.66-128-128 29.66-29.65 30.06 30.07L382.08 62.05c9.05-9.06 21.1-14.05 33.91-14.05 12.82 0 24.86 4.98 33.91 14.04l.04.04C459.01 71.14 464 83.19 464 96.01c0 12.81-5 24.86-14.06 33.93z"]
};
var faEyeEvil = {
  prefix: 'far',
  iconName: 'eye-evil',
  icon: [640, 512, [], "f6db", "M610.12 217.47l-94.53-25.09c14.97-23.36 41.28-64.52 41.31-64.56 9.09-14.31 8.16-32.16-2.44-45.44-11-13.81-29.66-19.02-46.62-13.09l-101.62 36.06c-3.97-1.7-8.03-3.31-12.19-4.81l-36.75-77.16C350.41 8.95 336.12 0 320 0s-30.41 8.95-37.28 23.39l-36.75 77.14c-4.16 1.5-8.22 3.11-12.19 4.81L132.16 69.3c-16.94-6.02-35.62-.7-46.62 13.08-10.6 13.28-11.54 31.12-2.42 45.5 0 0 26.31 41.14 41.28 64.5l-94.53 25.09C12 222.2 0 237.69 0 256s12 33.8 29.84 38.53l94.5 25.08c-14.91 23.33-41.22 64.55-41.25 64.58-9.09 14.31-8.16 32.16 2.44 45.44 11 13.83 29.72 19.08 46.62 13.09l101.62-36.06c3.97 1.7 8.03 3.31 12.19 4.81l36.75 77.12C289.59 503.03 303.88 512 320 512s30.41-8.97 37.28-23.41l36.75-77.12c4.16-1.5 8.22-3.11 12.19-4.81l101.62 36.05c16.97 6.05 35.66.73 46.62-13.08 10.59-13.28 11.53-31.12 2.41-45.48 0 0-26.31-41.2-41.22-64.53l94.47-25.08C628 289.8 640 274.31 640 256s-12-33.8-29.88-38.53zm-123.81 60.26l-5 6.67a298.45 298.45 0 0 1-13.78 17.12l-11.81 13.73 9.88 15.17c1.34 2.08 23.72 37.08 38.31 59.95l-100.28-35.58-9.06 4.41c-7.72 3.78-16.12 7.09-24.94 9.83l-10.03 3.12-39.6 83.12-39.59-83.09-10.03-3.12c-8.81-2.73-17.22-6.05-24.94-9.83l-9.06-4.41L136.1 390.4c14.59-22.88 36.94-57.86 38.28-59.89l10.03-15.2-11.94-13.77c-5.12-5.91-9.69-11.64-13.78-17.12l-5-6.67L71.81 256l81.88-21.75 5-6.67c4.12-5.5 8.69-11.23 13.81-17.16l11.91-13.8-10-15.22c-1.5-2.31-23.75-37.05-38.28-59.78l100.25 35.56 9.06-4.41c7.72-3.78 16.12-7.09 24.94-9.83l10.03-3.12L320 56.72l39.59 83.11 10.03 3.12c8.81 2.73 17.22 6.05 24.94 9.83l9.06 4.41 100.25-35.56c-14.53 22.75-36.75 57.44-38.19 59.66l-10.28 15.27 12.09 13.88c5.12 5.92 9.69 11.66 13.81 17.16l5 6.67L568.19 256l-81.88 21.73zm-142.1-55.71c4.41 9.25 7.79 20.41 7.79 33.98 0 42.67-32 64-32 64s-32-21.33-32-64c0-13.57 3.37-24.73 7.79-33.98-20.82-3-39.68-9.76-55.59-19.33C229.99 217.94 224 236.27 224 256c0 53.02 42.98 96 96 96s96-42.98 96-96c0-19.73-5.99-38.06-16.2-53.31-15.9 9.57-34.77 16.33-55.59 19.33z"]
};
var faEyeSlash = {
  prefix: 'far',
  iconName: 'eye-slash',
  icon: [640, 512, [], "f070", "M634 471L36 3.51A16 16 0 0 0 13.51 6l-10 12.49A16 16 0 0 0 6 41l598 467.49a16 16 0 0 0 22.49-2.49l10-12.49A16 16 0 0 0 634 471zM296.79 146.47l134.79 105.38C429.36 191.91 380.48 144 320 144a112.26 112.26 0 0 0-23.21 2.47zm46.42 219.07L208.42 260.16C210.65 320.09 259.53 368 320 368a113 113 0 0 0 23.21-2.46zM320 112c98.65 0 189.09 55 237.93 144a285.53 285.53 0 0 1-44 60.2l37.74 29.5a333.7 333.7 0 0 0 52.9-75.11 32.35 32.35 0 0 0 0-29.19C550.29 135.59 442.93 64 320 64c-36.7 0-71.71 7-104.63 18.81l46.41 36.29c18.94-4.3 38.34-7.1 58.22-7.1zm0 288c-98.65 0-189.08-55-237.93-144a285.47 285.47 0 0 1 44.05-60.19l-37.74-29.5a333.6 333.6 0 0 0-52.89 75.1 32.35 32.35 0 0 0 0 29.19C89.72 376.41 197.08 448 320 448c36.7 0 71.71-7.05 104.63-18.81l-46.41-36.28C359.28 397.2 339.89 400 320 400z"]
};
var faFan = {
  prefix: 'far',
  iconName: 'fan',
  icon: [512, 512, [], "f863", "M256 224a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm255.69 41.06C501 180.11 428.72 116 343.53 116a244.34 244.34 0 0 0-42.5 3.63l7.78-77.15A38.8 38.8 0 0 0 265.09.34C180.09 11 116 83.31 116 168.49a244.42 244.42 0 0 0 3.63 42.5l-77.16-7.78a38.4 38.4 0 0 0-31.38 11.43A39.06 39.06 0 0 0 .31 246.92C11 331.92 83.28 396 168.47 396a244.34 244.34 0 0 0 42.5-3.63l-7.78 77.15a38.25 38.25 0 0 0 11.44 31.35A39 39 0 0 0 242 512a38.44 38.44 0 0 0 5-.31c84.91-10.69 149-82.97 149-168.15a244.42 244.42 0 0 0-3.63-42.5l77.16 7.78a38.5 38.5 0 0 0 31.34-11.43 39 39 0 0 0 10.82-32.31zM324.75 246l13 35.91c6.78 18.65 10.22 39.4 10.22 61.65 0 57.25-40.47 106.4-95.84 118.59L266 324.76l-35.9 13c-18.63 6.81-39.38 10.24-61.63 10.24-57.25 0-106.38-40.47-118.59-95.84l137.37 13.88-13-35.91c-6.78-18.65-10.22-39.4-10.22-61.65 0-57.25 40.47-106.37 95.84-118.59L246 187.27l35.9-13c18.66-6.78 39.41-10.22 61.66-10.22 57.25 0 106.41 40.47 118.59 95.84z"]
};
var faFarm = {
  prefix: 'far',
  iconName: 'farm',
  icon: [576, 512, [], "f864", "M112 48a64.07 64.07 0 0 1 64 64v37.43l14.25-28.49a64.12 64.12 0 0 1 31.24-29.86l.38-.17A111.93 111.93 0 0 0 0 112v384a16 16 0 0 0 16 16h112v-48H48V112a64.07 64.07 0 0 1 64-64zm288 176h-64a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16zm172.62 22.22l-55.49-111a32 32 0 0 0-15.62-14.93L381 66.76a32 32 0 0 0-26 0l-120.51 53.56c-5.17 2.3-11 8-10.49 8a31.56 31.56 0 0 0-5.13 6.95l-55.49 111a32.08 32.08 0 0 0-3.38 14.27V512h400a16 16 0 0 0 16-16V260.54a32.08 32.08 0 0 0-3.38-14.32zM528 464H416v-64a16 16 0 0 0-16-16h-64a16 16 0 0 0-16 16v64H208V264.31l51.23-102.46L368 113.51l108.77 48.34L528 264.31z"]
};
var faFastBackward = {
  prefix: 'far',
  iconName: 'fast-backward',
  icon: [512, 512, [], "f049", "M12 448h24c6.6 0 12-5.4 12-12V277.7c1.1 1.2 2.2 2.4 3.5 3.4l184 159.5c20.6 17.2 52.5 2.8 52.5-24.6V292l171.5 148.6c20.6 17.2 52.5 2.8 52.5-24.6V96c0-27.4-31.9-41.8-52.5-24.6L288 221.1v-125c0-27.4-31.9-41.8-52.5-24.6L51.5 232c-1.3 1.1-2.4 2.2-3.5 3.4V76c0-6.6-5.4-12-12-12H12C5.4 64 0 69.4 0 76v360c0 6.6 5.4 12 12 12zm452-316.8V381L320.4 256.5 464 131.2zm-224 0V381L96.4 256.5 240 131.2z"]
};
var faFastForward = {
  prefix: 'far',
  iconName: 'fast-forward',
  icon: [512, 512, [], "f050", "M500 64h-24c-6.6 0-12 5.4-12 12v158.3c-1.1-1.2-2.2-2.4-3.5-3.4l-184-159.5C255.9 54.3 224 68.6 224 96v124L52.5 71.4C31.9 54.3 0 68.6 0 96v320c0 27.4 31.9 41.8 52.5 24.6L224 291v125c0 27.4 31.9 41.8 52.5 24.6l184-160.5c1.3-1.1 2.4-2.2 3.5-3.4V436c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12V76c0-6.6-5.4-12-12-12zM48 380.8V131.1l143.6 124.4L48 380.8zm224 0V131.1l143.6 124.4L272 380.8z"]
};
var faFax = {
  prefix: 'far',
  iconName: 'fax',
  icon: [512, 512, [], "f1ac", "M480 136.88v-30.37c0-16.97-6.74-33.25-18.74-45.26l-42.51-42.51A64.037 64.037 0 0 0 373.49 0H174.48C157.64 0 144 14.33 144 32v104.88c-9.45-5.5-20.28-8.88-32-8.88H64c-35.35 0-64 28.65-64 64v256c0 35.35 28.65 64 64 64h48c15.22 0 29.01-5.54 40-14.41 10.99 8.87 24.78 14.41 40 14.41h256c35.35 0 64-28.65 64-64V192c0-23.63-12.95-44.04-32-55.12zM128 448c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V192c0-8.82 7.18-16 16-16h48c8.82 0 16 7.18 16 16v256zm64-400h176v48c0 8.84 7.16 16 16 16h48v80H192V48zm272 400c0 8.82-7.18 16-16 16H192c-8.82 0-16-7.18-16-16V240h288v208zM352 336h32c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16h-32c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16zm-96 96h32c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16h-32c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16zm0-96h32c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16h-32c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16zm96 96h32c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16h-32c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16z"]
};
var faFeather = {
  prefix: 'far',
  iconName: 'feather',
  icon: [512, 512, [], "f52d", "M467.1 44.9C438.24 16.04 401.59 0 361.59 0c-46.7 0-97.98 21.85-146.78 70.66l-85.75 85.76C54 231.47 56.69 352.92 72.69 405.37L7.03 471.03c-9.37 9.37-9.37 24.57 0 33.94 9.37 9.37 24.57 9.37 33.94 0l65.6-65.6c17.44 5.3 42.43 9.15 70.88 9.15 57.19 0 128.04-15.48 178.13-65.57l85.76-85.75c90.61-90.62 88.32-189.75 25.76-252.3zM147.37 398.57L193.94 352h124.12c-44.62 41.83-106.87 48.46-140.61 48.46-11.41.01-21.29-.81-30.08-1.89zM350.58 320H225.94l64-64h123.81c-2.23 2.4-4.01 4.83-6.39 7.21L350.58 320zm88.31-96H321.94l22.51-22.51c9.37-9.37 9.37-24.57 0-33.94-9.37-9.37-24.57-9.37-33.94 0l-197 197c-5.27-45.97-.29-124.34 49.52-174.15 0 0 18.71-18.71 85.75-85.76 37.02-37.02 76.03-56.58 112.8-56.58 26.63 0 51.37 10.66 71.53 30.82 39.17 39.16 40.02 92.25 5.78 145.12z"]
};
var faFeatherAlt = {
  prefix: 'far',
  iconName: 'feather-alt',
  icon: [512, 512, [], "f56b", "M71.46 287.61c-4.85 41.95-7.25 84.14-7.38 126.37L7.03 471.03c-9.37 9.37-9.37 24.57 0 33.94 9.37 9.37 24.57 9.37 33.94 0l57.05-57.05c42.23-.12 84.42-2.53 126.37-7.38C473.8 415.14 508.44 51.72 512 0 460.28 3.56 96.87 38.2 71.46 287.61zm147.42 105.25c-23.41 2.71-47.3 4.36-71.31 5.51L193.94 352h125.37c-27.89 21.72-60.89 36.83-100.43 40.86zM352.81 320H225.94l64-64h106.12c-12.11 23.11-26.54 44.76-43.25 64zm-30.87-96l13.54-13.54c9.37-9.37 9.37-24.57 0-33.94-9.37-9.37-24.57-9.37-33.94 0l-187.9 187.9c1.16-24.09 2.83-48.13 5.58-71.96C136.33 124.4 349.77 70.87 457.48 54.51c-6.89 45.3-20.53 109.25-46.37 169.49h-89.17z"]
};
var faFemale = {
  prefix: 'far',
  iconName: 'female',
  icon: [320, 512, [], "f182", "M300.6 331.5l-48-139c-3.5-10.2-9.4-19.4-17.4-26.6 15.4-17.6 24.8-40.6 24.8-65.8C260 44.9 215.1 0 160 0S60 44.9 60 100c0 25.2 9.4 48.2 24.8 65.8-7.9 7.3-13.9 16.4-17.4 26.6L19.5 331.2C5.2 374 36.9 416 80 416v32c0 35.3 28.7 64 64 64h32c35.3 0 64-28.7 64-64v-32c44-.2 74.5-42.9 60.6-84.5zM160 48c28.7 0 52 23.3 52 52s-23.3 52-52 52-52-23.3-52-52 23.3-52 52-52zm79.6 320H192v80c0 8.8-7.2 16-16 16h-32c-8.8 0-16-7.2-16-16v-80H80c-10.5 0-18.8-10.2-15.1-21.4L112.8 208c2.2-6.5 8.3-10.9 15.2-10.9h7.9c15.8 3.9 32.4 3.9 48.2 0h7.9c6.9 0 13 4.4 15.2 10.9l48 138.9c3.3 10-3.8 21.1-15.6 21.1z"]
};
var faFieldHockey = {
  prefix: 'far',
  iconName: 'field-hockey',
  icon: [640, 512, [], "f44c", "M619.5 96.3L558.8 157l-45.2-45.2 91.2-91.2C612.4 12.9 607 0 596.3 0h-33.9c-3.2 0-6.2 1.3-8.5 3.5L214.7 342.7c-29.4 29.5-75.6-14.8-45.3-45.2 31.2-31.2 31.2-81.9 0-113.1-31.2-31.2-81.8-31.3-113.1 0C20 220.6 0 268.8 0 320.1 0 426.7 86.3 512 192 512c86.5 0 131.8-52.2 153.3-73.7 18.2 43.3 61 73.7 110.7 73.7 66.2 0 120-53.8 120-120 0-49.8-30.5-92.5-73.7-110.7l134.2-134.2c2.3-2.3 3.5-5.3 3.5-8.5v-33.9c0-10.6-12.9-16-20.5-8.4zM192 464c-38.5 0-74.7-14.9-101.8-42C63 394.8 48 358.6 48 320.1c0-38.5 15-74.7 42.2-101.8 29.5-29.6 75.6 14.9 45.2 45.3-31.1 31.2-31.1 81.9.2 113.2 31.1 30.8 81.7 31.3 113-.2l231.1-231.1 45.2 45.2-82.5 82.5c-55.2 6.3-98.7 49.8-105 105C293.3 422.5 262.2 464 192 464zm336-72c0 39.7-32.3 72-72 72s-72-32.3-72-72 32.3-72 72-72 72 32.3 72 72z"]
};
var faFighterJet = {
  prefix: 'far',
  iconName: 'fighter-jet',
  icon: [640, 512, [], "f0fb", "M520 181.4l-108-12.34L370.22 152h-11.15L288.5 63.79C310.73 62.56 328 56.09 328 48c0-9-21.38-16-47.19-16H128v32h16v63.53L119.48 96h-74.3L8 133.18v62.12l-8 1v119.42l8 1v62.12L45.18 416h74.3L144 384.47V448h-16v32h152.81c25.81 0 47.19-7 47.19-16 0-8.09-17.27-14.56-39.5-15.79L359.07 360h11.15L412 342.94l108-12.34c61-13.55 120.35-22 120-74.6.3-52.76-59.54-61.15-120-74.6zm-8 101.8L400 296l-39.2 16H336l-96 120h-48V296h-40l-56 72H65.07L56 358.93V304h8v-16h40v-8l-56-6.8v-34.4l56-6.8v-8H64v-16h-8v-54.93l9.07-9.07H96l56 72h40V80h48l96 120h24.8l39.2 16 112 12.8c81.6 18.13 80 22.6 80 27.2s1.6 9.07-80 27.2z"]
};
var faFile = {
  prefix: 'far',
  iconName: 'file',
  icon: [384, 512, [], "f15b", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48z"]
};
var faFileAlt = {
  prefix: 'far',
  iconName: 'file-alt',
  icon: [384, 512, [], "f15c", "M288 248v28c0 6.6-5.4 12-12 12H108c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h168c6.6 0 12 5.4 12 12zm-12 72H108c-6.6 0-12 5.4-12 12v28c0 6.6 5.4 12 12 12h168c6.6 0 12-5.4 12-12v-28c0-6.6-5.4-12-12-12zm108-188.1V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V48C0 21.5 21.5 0 48 0h204.1C264.8 0 277 5.1 286 14.1L369.9 98c9 8.9 14.1 21.2 14.1 33.9zm-128-80V128h76.1L256 51.9zM336 464V176H232c-13.3 0-24-10.7-24-24V48H48v416h288z"]
};
var faFileArchive = {
  prefix: 'far',
  iconName: 'file-archive',
  icon: [384, 512, [], "f1c6", "M128.3 160v32h32v-32zm64-96h-32v32h32zm-64 32v32h32V96zm64 32h-32v32h32zm177.6-30.1L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM256 51.9l76.1 76.1H256zM336 464H48V48h79.7v16h32V48H208v104c0 13.3 10.7 24 24 24h104zM194.2 265.7c-1.1-5.6-6-9.7-11.8-9.7h-22.1v-32h-32v32l-19.7 97.1C102 385.6 126.8 416 160 416c33.1 0 57.9-30.2 51.5-62.6zm-33.9 124.4c-17.9 0-32.4-12.1-32.4-27s14.5-27 32.4-27 32.4 12.1 32.4 27-14.5 27-32.4 27zm32-198.1h-32v32h32z"]
};
var faFileAudio = {
  prefix: 'far',
  iconName: 'file-audio',
  icon: [384, 512, [], "f1c7", "M369.941 97.941l-83.882-83.882A48 48 0 0 0 252.118 0H48C21.49 0 0 21.49 0 48v416c0 26.51 21.49 48 48 48h288c26.51 0 48-21.49 48-48V131.882a48 48 0 0 0-14.059-33.941zM332.118 128H256V51.882L332.118 128zM48 464V48h160v104c0 13.255 10.745 24 24 24h104v288H48zm144-76.024c0 10.691-12.926 16.045-20.485 8.485L136 360.486h-28c-6.627 0-12-5.373-12-12v-56c0-6.627 5.373-12 12-12h28l35.515-36.947c7.56-7.56 20.485-2.206 20.485 8.485v135.952zm41.201-47.13c9.051-9.297 9.06-24.133.001-33.439-22.149-22.752 12.235-56.246 34.395-33.481 27.198 27.94 27.212 72.444.001 100.401-21.793 22.386-56.947-10.315-34.397-33.481z"]
};
var faFileCertificate = {
  prefix: 'far',
  iconName: 'file-certificate',
  icon: [512, 512, [], "f5f3", "M497.83 97.98L413.94 14.1c-9-9-21.2-14.1-33.89-14.1H175.99C149.5.1 128 21.6 128 48.09V128h47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H464v287.95H224V512h239.93c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zm-113.88 30.09V51.99l76.09 76.08h-76.09zM247.42 338.28c7.4-7.53 10.29-18.5 7.58-28.79-5.43-20.65-5.44-17.74 0-38.42 2.71-10.29-.18-21.26-7.58-28.79-14.86-15.12-13.43-12.61-18.87-33.27-2.71-10.29-10.6-18.32-20.71-21.07-20.28-5.53-17.84-4.1-32.69-19.21-7.4-7.53-18.18-10.47-28.29-7.71-20.32 5.54-17.46 5.53-37.75 0-10.1-2.76-20.88.19-28.28 7.71-14.91 15.18-12.5 13.7-32.69 19.21-10.11 2.76-18 10.79-20.71 21.07-5.46 20.74-4 18.13-18.87 33.27-7.4 7.53-10.29 18.5-7.58 28.79 5.45 20.71 5.42 17.79 0 38.42-2.71 10.29.18 21.26 7.58 28.79 14.85 15.11 13.43 12.61 18.87 33.27 2.71 10.29 10.6 18.32 20.71 21.07 14.31 3.9 11.52 2.97 15.84 5V512l64-32 64 32V397.62c4.31-2.02 1.52-1.1 15.84-5 10.11-2.76 18-10.79 20.71-21.07 5.48-20.75 4.02-18.14 18.89-33.27zM128 352c-35.34 0-64-28.65-64-64s28.66-64 64-64 64 28.65 64 64-28.66 64-64 64z"]
};
var faFileChartLine = {
  prefix: 'far',
  iconName: 'file-chart-line',
  icon: [384, 512, [], "f659", "M131.2 320h-22.4c-6.4 0-12.8 6.4-12.8 12.8v70.4c0 6.4 6.4 12.8 12.8 12.8h22.4c6.4 0 12.8-6.4 12.8-12.8v-70.4c0-6.4-6.4-12.8-12.8-12.8zm72-64h-22.4c-6.4 0-12.8 6.4-12.8 12.8v134.4c0 6.4 6.4 12.8 12.8 12.8h22.4c6.4 0 12.8-6.4 12.8-12.8V268.8c0-6.4-6.4-12.8-12.8-12.8zm49.6 160h22.4c6.4 0 12.8-6.4 12.8-12.8V300.8c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v102.4c0 6.4 6.4 12.8 12.8 12.8zM369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95z"]
};
var faFileChartPie = {
  prefix: 'far',
  iconName: 'file-chart-pie',
  icon: [384, 512, [], "f65a", "M369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95zm-176-206.4c-36.52 7.41-64 39.68-64 78.39 0 44.18 35.82 80 80 80 38.7 0 70.97-27.49 78.39-64H160v-94.39zm32-32V320h94.39a80.321 80.321 0 0 0 1.61-16c0-44.18-35.82-80-80-80-5.48 0-10.83.56-16 1.61z"]
};
var faFileCheck = {
  prefix: 'far',
  iconName: 'file-check',
  icon: [384, 512, [], "f316", "M369.941 97.941l-83.882-83.882A48 48 0 0 0 252.118 0H48C21.49 0 0 21.49 0 48v416c0 26.51 21.49 48 48 48h288c26.51 0 48-21.49 48-48V131.882a48 48 0 0 0-14.059-33.941zM332.118 128H256V51.882L332.118 128zM48 464V48h160v104c0 13.255 10.745 24 24 24h104v288H48zm261.151-192.661L166.842 412.508c-4.705 4.667-12.303 4.637-16.971-.068l-75.091-75.7c-4.667-4.705-4.637-12.303.068-16.971l22.719-22.536c4.705-4.667 12.303-4.637 16.97.069l44.104 44.461 111.072-110.181c4.705-4.667 12.303-4.637 16.971.068l22.536 22.718c4.667 4.706 4.636 12.303-.069 16.971z"]
};
var faFileCode = {
  prefix: 'far',
  iconName: 'file-code',
  icon: [384, 512, [], "f1c9", "M149.9 349.1l-.2-.2-32.8-28.9 32.8-28.9c3.6-3.2 4-8.8.8-12.4l-.2-.2-17.4-18.6c-3.4-3.6-9-3.7-12.4-.4l-57.7 54.1c-3.7 3.5-3.7 9.4 0 12.8l57.7 54.1c1.6 1.5 3.8 2.4 6 2.4 2.4 0 4.8-1 6.4-2.8l17.4-18.6c3.3-3.5 3.1-9.1-.4-12.4zm220-251.2L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM256 51.9l76.1 76.1H256zM336 464H48V48h160v104c0 13.3 10.7 24 24 24h104zM209.6 214c-4.7-1.4-9.5 1.3-10.9 6L144 408.1c-1.4 4.7 1.3 9.6 6 10.9l24.4 7.1c4.7 1.4 9.6-1.4 10.9-6L240 231.9c1.4-4.7-1.3-9.6-6-10.9zm24.5 76.9l.2.2 32.8 28.9-32.8 28.9c-3.6 3.2-4 8.8-.8 12.4l.2.2 17.4 18.6c3.3 3.5 8.9 3.7 12.4.4l57.7-54.1c3.7-3.5 3.7-9.4 0-12.8l-57.7-54.1c-3.5-3.3-9.1-3.2-12.4.4l-17.4 18.6c-3.3 3.5-3.1 9.1.4 12.4z"]
};
var faFileContract = {
  prefix: 'far',
  iconName: 'file-contract',
  icon: [384, 512, [], "f56c", "M196.66 363.33l-13.88-41.62c-3.28-9.81-12.44-16.41-22.78-16.41s-19.5 6.59-22.78 16.41L119 376.36c-1.5 4.58-5.78 7.64-10.59 7.64H96c-8.84 0-16 7.16-16 16s7.16 16 16 16h12.41c18.62 0 35.09-11.88 40.97-29.53L160 354.58l16.81 50.48a15.994 15.994 0 0 0 14.06 10.89c.38.03.75.05 1.12.05 6.03 0 11.59-3.41 14.31-8.86l7.66-15.33c2.78-5.59 7.94-6.19 10.03-6.19s7.25.59 10.19 6.53c7.38 14.7 22.19 23.84 38.62 23.84H288c8.84 0 16-7.16 16-16s-7.16-16-16-16h-15.19c-4.28 0-8.12-2.38-10.16-6.5-11.93-23.85-46.24-30.33-65.99-14.16zM369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95zM88 112h80c4.42 0 8-3.58 8-8V88c0-4.42-3.58-8-8-8H88c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8zm0 64h80c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8H88c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8z"]
};
var faFileCsv = {
  prefix: 'far',
  iconName: 'file-csv',
  icon: [384, 512, [], "f6dd", "M369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95zM224 264v20.8c0 35.48 12.88 68.89 36.28 94.09 3.02 3.25 7.27 5.11 11.72 5.11s8.7-1.86 11.72-5.11c23.41-25.2 36.28-58.61 36.28-94.09V264c0-4.42-3.58-8-8-8h-16c-4.42 0-8 3.58-8 8v20.8c0 20.27-5.7 40.17-16 56.88-10.3-16.7-16-36.61-16-56.88V264c0-4.42-3.58-8-8-8h-16c-4.42 0-8 3.58-8 8zm-104-8h-8c-26.51 0-48 21.49-48 48v32c0 26.51 21.49 48 48 48h8c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-8c-8.84 0-16-7.16-16-16v-32c0-8.84 7.16-16 16-16h8c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8zm59.45 42.47c-1.38-1.19-2.12-2.55-2.12-3.84 0-3.12 4.45-6.62 10.41-6.62H200c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8h-12.27c-23.39 0-42.41 17.33-42.41 38.62 0 10.66 4.86 20.92 13.33 28.14l21.89 18.77c1.38 1.19 2.12 2.55 2.12 3.84 0 3.12-4.45 6.62-10.41 6.62H160c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h12.27c23.39 0 42.41-17.33 42.41-38.62 0-10.66-4.86-20.92-13.33-28.14l-21.9-18.77z"]
};
var faFileDownload = {
  prefix: 'far',
  iconName: 'file-download',
  icon: [384, 512, [], "f56d", "M216 236.07c0-6.63-5.37-12-12-12h-24c-6.63 0-12 5.37-12 12v84.01h-48.88c-10.71 0-16.05 12.97-8.45 20.52l72.31 71.77c4.99 4.95 13.04 4.95 18.03 0l72.31-71.77c7.6-7.54 2.26-20.52-8.45-20.52H216v-84.01zM369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95z"]
};
var faFileEdit = {
  prefix: 'far',
  iconName: 'file-edit',
  icon: [384, 512, [], "f31c", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm163.1-229.9l46.8 46.8c2 2 2 5.2 0 7.2L143.4 402.6 95.2 408c-6.4.7-11.9-4.7-11.2-11.2l5.4-48.2 114.5-114.5c2-2 5.2-2 7.2 0zm83 17.8l-19.5 19.5c-2 2-5.2 2-7.2 0l-46.8-46.8c-2-2-2-5.2 0-7.2l19.5-19.5c7.9-7.9 20.7-7.9 28.6 0l25.4 25.4c7.9 7.9 7.9 20.7 0 28.6z"]
};
var faFileExcel = {
  prefix: 'far',
  iconName: 'file-excel',
  icon: [384, 512, [], "f1c3", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm212-240h-28.8c-4.4 0-8.4 2.4-10.5 6.3-18 33.1-22.2 42.4-28.6 57.7-13.9-29.1-6.9-17.3-28.6-57.7-2.1-3.9-6.2-6.3-10.6-6.3H124c-9.3 0-15 10-10.4 18l46.3 78-46.3 78c-4.7 8 1.1 18 10.4 18h28.9c4.4 0 8.4-2.4 10.5-6.3 21.7-40 23-45 28.6-57.7 14.9 30.2 5.9 15.9 28.6 57.7 2.1 3.9 6.2 6.3 10.6 6.3H260c9.3 0 15-10 10.4-18L224 320c.7-1.1 30.3-50.5 46.3-78 4.7-8-1.1-18-10.3-18z"]
};
var faFileExclamation = {
  prefix: 'far',
  iconName: 'file-exclamation',
  icon: [384, 512, [], "f31a", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm108.6-251.3l6.5 104c.4 6.3 5.6 11.3 12 11.3h33.8c6.3 0 11.6-4.9 12-11.3l6.5-104c.4-6.9-5.1-12.7-12-12.7h-46.8c-6.9 0-12.4 5.8-12 12.7zM232 384c0 22.1-17.9 40-40 40s-40-17.9-40-40 17.9-40 40-40 40 17.9 40 40z"]
};
var faFileExport = {
  prefix: 'far',
  iconName: 'file-export',
  icon: [576, 512, [], "f56e", "M572.29 279.06l-71.77-72.31c-7.55-7.6-20.52-2.26-20.52 8.45v48.88h-96v-132.1c0-12.7-5.17-25-14.17-33.99L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V360.07h-48v103.94H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v88.01H172c-6.63 0-12 5.37-12 12v24c0 6.63 5.37 12 12 12h308v48.88c0 10.71 12.97 16.05 20.52 8.45l71.77-72.31c4.95-4.99 4.95-13.04 0-18.03zM255.95 128.07V51.99l76.09 76.08h-76.09z"]
};
var faFileImage = {
  prefix: 'far',
  iconName: 'file-image',
  icon: [384, 512, [], "f1c5", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm32-48h224V288l-23.5-23.5c-4.7-4.7-12.3-4.7-17 0L176 352l-39.5-39.5c-4.7-4.7-12.3-4.7-17 0L80 352v64zm48-240c-26.5 0-48 21.5-48 48s21.5 48 48 48 48-21.5 48-48-21.5-48-48-48z"]
};
var faFileImport = {
  prefix: 'far',
  iconName: 'file-import',
  icon: [512, 512, [], "f56f", "M497.83 97.98L413.94 14.1c-9-9-21.2-14.1-33.89-14.1H175.99C149.5.1 128 21.6 128 48.09v215.98H12c-6.63 0-12 5.37-12 12v24c0 6.63 5.37 12 12 12h276v48.88c0 10.71 12.97 16.05 20.52 8.45l71.77-72.31c4.95-4.99 4.95-13.04 0-18.03l-71.77-72.31c-7.55-7.6-20.52-2.26-20.52 8.45v48.88H175.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H464v287.95H175.99V360.07H128v103.94c0 26.49 21.5 47.99 47.99 47.99h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zm-113.88 30.09V51.99l76.09 76.08h-76.09z"]
};
var faFileInvoice = {
  prefix: 'far',
  iconName: 'file-invoice',
  icon: [384, 512, [], "f570", "M296 400h-80c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h80c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8zM80 240v96c0 8.84 7.16 16 16 16h192c8.84 0 16-7.16 16-16v-96c0-8.84-7.16-16-16-16H96c-8.84 0-16 7.16-16 16zm32 16h160v64H112v-64zM369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95zM88 112h80c4.42 0 8-3.58 8-8V88c0-4.42-3.58-8-8-8H88c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8zm0 64h80c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8H88c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8z"]
};
var faFileInvoiceDollar = {
  prefix: 'far',
  iconName: 'file-invoice-dollar',
  icon: [384, 512, [], "f571", "M369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95zM208 216c0-4.42-3.58-8-8-8h-16c-4.42 0-8 3.58-8 8v24.12c-23.62.63-42.67 20.55-42.67 45.07 0 19.97 12.98 37.81 31.58 43.39l45 13.5c5.16 1.55 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.11c-4.56 0-8.96-1.29-12.82-3.72-3.24-2.03-7.36-1.91-10.13.73l-11.75 11.21c-3.53 3.37-3.33 9.21.57 12.14 9.1 6.83 20.08 10.77 31.37 11.35V424c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-24.12c23.62-.63 42.67-20.54 42.67-45.07 0-19.97-12.98-37.81-31.58-43.39l-45-13.5c-5.16-1.55-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11c4.56 0 8.96 1.29 12.82 3.72 3.24 2.03 7.36 1.91 10.13-.73l11.75-11.21c3.53-3.37 3.33-9.21-.57-12.14-9.1-6.83-20.08-10.77-31.37-11.35V216zM88 112h80c4.42 0 8-3.58 8-8V88c0-4.42-3.58-8-8-8H88c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8zm88 56v-16c0-4.42-3.58-8-8-8H88c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h80c4.42 0 8-3.58 8-8z"]
};
var faFileMedical = {
  prefix: 'far',
  iconName: 'file-medical',
  icon: [384, 512, [], "f477", "M224 232c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v56h-56c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h56v56c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-56h56c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8h-56v-56zM369.8 98l-83.9-83.9C276.9 5.1 264.7 0 252 0H48C21.5.1 0 21.6 0 48.1V464c0 26.5 21.5 48 48 48h287.9c26.5 0 48.1-21.5 48.1-48V132c0-12.7-5.2-25-14.2-34zM255.9 52l76.1 76.1h-76.1V52zM336 464H48V48.1h160v104c0 13.3 10.7 24 24 24h104V464z"]
};
var faFileMedicalAlt = {
  prefix: 'far',
  iconName: 'file-medical-alt',
  icon: [448, 512, [], "f478", "M433.9 98l-84-84c-9-9-21.1-14-33.8-14h-204C85.6.1 64 21.6 64 48.1V272H16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h113.2l32.5 65.1c5.9 11.8 22.7 11.8 28.6 0l49.7-99.4 17.2 34.3H344c13.2 0 24-10.8 24-24s-10.8-24-24-24h-57.2l-32.5-65.1c-5.9-11.8-22.7-11.8-28.6 0L176 306.3 158.9 272H112V48.1h160v104c0 13.3 10.7 24 24 24h104V464H112.1v-96H64v96c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V132c0-12.8-5.1-25-14.1-34zM320 128.1V52l76.1 76.1H320z"]
};
var faFileMinus = {
  prefix: 'far',
  iconName: 'file-minus',
  icon: [384, 512, [], "f318", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm44-136c-6.6 0-12-5.4-12-12v-24c0-6.6 5.4-12 12-12h200c6.6 0 12 5.4 12 12v24c0 6.6-5.4 12-12 12H92z"]
};
var faFilePdf = {
  prefix: 'far',
  iconName: 'file-pdf',
  icon: [384, 512, [], "f1c1", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm250.2-143.7c-12.2-12-47-8.7-64.4-6.5-17.2-10.5-28.7-25-36.8-46.3 3.9-16.1 10.1-40.6 5.4-56-4.2-26.2-37.8-23.6-42.6-5.9-4.4 16.1-.4 38.5 7 67.1-10 23.9-24.9 56-35.4 74.4-20 10.3-47 26.2-51 46.2-3.3 15.8 26 55.2 76.1-31.2 22.4-7.4 46.8-16.5 68.4-20.1 18.9 10.2 41 17 55.8 17 25.5 0 28-28.2 17.5-38.7zm-198.1 77.8c5.1-13.7 24.5-29.5 30.4-35-19 30.3-30.4 35.7-30.4 35zm81.6-190.6c7.4 0 6.7 32.1 1.8 40.8-4.4-13.9-4.3-40.8-1.8-40.8zm-24.4 136.6c9.7-16.9 18-37 24.7-54.7 8.3 15.1 18.9 27.2 30.1 35.5-20.8 4.3-38.9 13.1-54.8 19.2zm131.6-5s-5 6-37.3-7.8c35.1-2.6 40.9 5.4 37.3 7.8z"]
};
var faFilePlus = {
  prefix: 'far',
  iconName: 'file-plus',
  icon: [384, 512, [], "f319", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm256-172v24c0 6.6-5.4 12-12 12h-76v76c0 6.6-5.4 12-12 12h-24c-6.6 0-12-5.4-12-12v-76H92c-6.6 0-12-5.4-12-12v-24c0-6.6 5.4-12 12-12h76v-76c0-6.6 5.4-12 12-12h24c6.6 0 12 5.4 12 12v76h76c6.6 0 12 5.4 12 12z"]
};
var faFilePowerpoint = {
  prefix: 'far',
  iconName: 'file-powerpoint',
  icon: [384, 512, [], "f1c4", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm72-60V236c0-6.6 5.4-12 12-12h69.2c36.7 0 62.8 27 62.8 66.3 0 74.3-68.7 66.5-95.5 66.5V404c0 6.6-5.4 12-12 12H132c-6.6 0-12-5.4-12-12zm48.5-87.4h23c7.9 0 13.9-2.4 18.1-7.2 8.5-9.8 8.4-28.5.1-37.8-4.1-4.6-9.9-7-17.4-7h-23.9v52z"]
};
var faFilePrescription = {
  prefix: 'far',
  iconName: 'file-prescription',
  icon: [384, 512, [], "f572", "M369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95zM224.97 330.34l-32.3-32.3C211.17 288.9 224 270.03 224 248c0-30.93-25.07-56-56-56h-64c-4.42 0-8 3.58-8 8v144c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-40h25.37l48.97 48.97c-1.15.38-2.4.46-3.31 1.37l-36.69 36.69c-3.12 3.12-3.12 8.19 0 11.31l11.31 11.31c3.12 3.12 8.19 3.12 11.31 0l36.69-36.69c.92-.92.99-2.16 1.37-3.31l40 40c3.12 3.12 8.19 3.12 11.31 0l11.31-11.31c3.12-3.12 3.12-8.19 0-11.31l-40-40c1.15-.38 2.4-.46 3.31-1.37l36.69-36.69c3.12-3.12 3.12-8.19 0-11.31l-11.31-11.31c-3.12-3.12-8.19-3.12-11.31 0l-36.69 36.69c-.9.9-.98 2.15-1.36 3.3zM168 272h-40v-48h40c13.23 0 24 10.77 24 24s-10.77 24-24 24z"]
};
var faFileSearch = {
  prefix: 'far',
  iconName: 'file-search',
  icon: [640, 512, [], "f865", "M603.32 473.39l-81.48-81.46a128 128 0 1 0-33.93 33.93l81.48 81.46a16 16 0 0 0 22.62 0L603.32 496a16 16 0 0 0 0-22.61zM416 400a80 80 0 1 1 80-80 80.09 80.09 0 0 1-80 80zM80 464V48.09h160v104a23.93 23.93 0 0 0 24 24h83.29c20.89-10 44-16.06 68.71-16.06V132a48.23 48.23 0 0 0-14.1-34L318 14.1A48 48 0 0 0 284.1 0H80a48.16 48.16 0 0 0-48 48.09V464a48 48 0 0 0 48 48h288a47.86 47.86 0 0 0 45.15-32.29A158.48 158.48 0 0 1 347.43 464zM288 52l76.1 76.08H288z"]
};
var faFileSignature = {
  prefix: 'far',
  iconName: 'file-signature',
  icon: [576, 512, [], "f573", "M568.54 167.33l-31.87-31.87c-9.94-9.94-26.07-9.94-36.01 0l-27.25 27.25 67.88 67.88 27.25-27.25c9.95-9.94 9.95-26.07 0-36.01zM329.06 306a63.974 63.974 0 0 0-16.26 27.11L297.57 384h-24.76c-4.28 0-8.12-2.38-10.16-6.5-11.97-23.86-46.28-30.34-66-14.17l-13.88-41.62c-3.28-9.81-12.44-16.41-22.78-16.41s-19.5 6.59-22.78 16.41L119 376.36c-1.5 4.58-5.78 7.64-10.59 7.64H96c-8.84 0-16 7.16-16 16s7.16 16 16 16h12.41c18.62 0 35.09-11.88 40.97-29.53L160 354.58l16.81 50.48a15.994 15.994 0 0 0 14.06 10.89c.38.03.75.05 1.12.05 6.03 0 11.59-3.41 14.31-8.86l7.66-15.33c2.78-5.59 7.94-6.19 10.03-6.19s7.25.59 10.19 6.53c7.38 14.7 22.19 23.84 38.62 23.84H336V464H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v78l48-47.58v-74.5c0-12.7-5.17-25-14.17-33.99L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V388.8l134.66-135.58-67.88-67.88L329.06 306zM255.95 51.99l76.09 76.08h-76.09V51.99z"]
};
var faFileSpreadsheet = {
  prefix: 'far',
  iconName: 'file-spreadsheet',
  icon: [384, 512, [], "f65b", "M80 240v176c0 8.84 7.16 16 16 16h192c8.84 0 16-7.16 16-16V240c0-8.84-7.16-16-16-16H96c-8.84 0-16 7.16-16 16zm128 32h64v48h-64v-48zm0 80h64v48h-64v-48zm-96-80h64v48h-64v-48zm0 80h64v48h-64v-48zM369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95z"]
};
var faFileTimes = {
  prefix: 'far',
  iconName: 'file-times',
  icon: [384, 512, [], "f317", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm231.7-89.3l-17 17c-4.7 4.7-12.3 4.7-17 0L192 337.9l-53.7 53.7c-4.7 4.7-12.3 4.7-17 0l-17-17c-4.7-4.7-4.7-12.3 0-17l53.7-53.7-53.7-53.7c-4.7-4.7-4.7-12.3 0-17l17-17c4.7-4.7 12.3-4.7 17 0L192 270l53.7-53.7c4.7-4.7 12.3-4.7 17 0l17 17c4.7 4.7 4.7 12.3 0 17L225.9 304l53.7 53.7c4.8 4.7 4.8 12.3.1 17z"]
};
var faFileUpload = {
  prefix: 'far',
  iconName: 'file-upload',
  icon: [384, 512, [], "f574", "M369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95zM182.98 227.79l-72.31 71.77c-7.6 7.54-2.26 20.52 8.45 20.52H168v84c0 6.63 5.37 12 12 12h24c6.63 0 12-5.37 12-12v-84h48.88c10.71 0 16.05-12.97 8.45-20.52l-72.31-71.77c-4.99-4.95-13.05-4.95-18.04 0z"]
};
var faFileUser = {
  prefix: 'far',
  iconName: 'file-user',
  icon: [384, 512, [], "f65c", "M369.83 97.98L285.94 14.1c-9-9-21.2-14.1-33.89-14.1H47.99C21.5.1 0 21.6 0 48.09v415.92C0 490.5 21.5 512 47.99 512h287.94c26.5 0 48.07-21.5 48.07-47.99V131.97c0-12.69-5.17-24.99-14.17-33.99zM255.95 51.99l76.09 76.08h-76.09V51.99zM336 464.01H47.99V48.09h159.97v103.98c0 13.3 10.7 23.99 24 23.99H336v287.95zM128 272c0 35.35 28.65 64 64 64s64-28.65 64-64-28.65-64-64-64-64 28.65-64 64zm103.85 80c-12.29 5.12-25.73 8-39.85 8s-27.56-2.88-39.85-8h-4.95c-37.11 0-67.2 25.79-67.2 57.6v6.4c0 8.84 7.16 16 16 16h192c8.84 0 16-7.16 16-16v-6.4c0-31.81-30.09-57.6-67.2-57.6h-4.95z"]
};
var faFileVideo = {
  prefix: 'far',
  iconName: 'file-video',
  icon: [384, 512, [], "f1c8", "M369.941 97.941l-83.882-83.882A48 48 0 0 0 252.118 0H48C21.49 0 0 21.49 0 48v416c0 26.51 21.49 48 48 48h288c26.51 0 48-21.49 48-48V131.882a48 48 0 0 0-14.059-33.941zM332.118 128H256V51.882L332.118 128zM48 464V48h160v104c0 13.255 10.745 24 24 24h104v288H48zm228.687-211.303L224 305.374V268c0-11.046-8.954-20-20-20H100c-11.046 0-20 8.954-20 20v104c0 11.046 8.954 20 20 20h104c11.046 0 20-8.954 20-20v-37.374l52.687 52.674C286.704 397.318 304 390.28 304 375.986V264.011c0-14.311-17.309-21.319-27.313-11.314z"]
};
var faFileWord = {
  prefix: 'far',
  iconName: 'file-word',
  icon: [384, 512, [], "f1c2", "M369.9 97.9L286 14C277 5 264.8-.1 252.1-.1H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V131.9c0-12.7-5.1-25-14.1-34zM332.1 128H256V51.9l76.1 76.1zM48 464V48h160v104c0 13.3 10.7 24 24 24h104v288H48zm220.1-208c-5.7 0-10.6 4-11.7 9.5-20.6 97.7-20.4 95.4-21 103.5-.2-1.2-.4-2.6-.7-4.3-.8-5.1.3.2-23.6-99.5-1.3-5.4-6.1-9.2-11.7-9.2h-13.3c-5.5 0-10.3 3.8-11.7 9.1-24.4 99-24 96.2-24.8 103.7-.1-1.1-.2-2.5-.5-4.2-.7-5.2-14.1-73.3-19.1-99-1.1-5.6-6-9.7-11.8-9.7h-16.8c-7.8 0-13.5 7.3-11.7 14.8 8 32.6 26.7 109.5 33.2 136 1.3 5.4 6.1 9.1 11.7 9.1h25.2c5.5 0 10.3-3.7 11.6-9.1l17.9-71.4c1.5-6.2 2.5-12 3-17.3l2.9 17.3c.1.4 12.6 50.5 17.9 71.4 1.3 5.3 6.1 9.1 11.6 9.1h24.7c5.5 0 10.3-3.7 11.6-9.1 20.8-81.9 30.2-119 34.5-136 1.9-7.6-3.8-14.9-11.6-14.9h-15.8z"]
};
var faFilesMedical = {
  prefix: 'far',
  iconName: 'files-medical',
  icon: [448, 512, [], "f7fd", "M433.94 65.94l-51.88-51.88A48 48 0 0 0 348.12 0H176a48 48 0 0 0-48 48v48H48a48 48 0 0 0-48 48v320a48 48 0 0 0 48 48h224a48 48 0 0 0 48-48v-48h80a48 48 0 0 0 48-48V99.88a48 48 0 0 0-14.06-33.94zM352 51.88L396.12 96H352zM272 458a6 6 0 0 1-6 6H54a6 6 0 0 1-6-6V150a6 6 0 0 1 6-6h74v224a48 48 0 0 0 48 48h96zm128-96a6 6 0 0 1-6 6H182a6 6 0 0 1-6-6V54a6 6 0 0 1 6-6h122v64a32 32 0 0 0 32 32h64zm-85.33-179.34A6.67 6.67 0 0 0 308 176h-40a6.67 6.67 0 0 0-6.67 6.66v46.67h-46.66A6.67 6.67 0 0 0 208 236v40a6.67 6.67 0 0 0 6.67 6.66h46.66v46.67A6.67 6.67 0 0 0 268 336h40a6.67 6.67 0 0 0 6.67-6.67v-46.67h46.66A6.67 6.67 0 0 0 368 276v-40a6.67 6.67 0 0 0-6.67-6.67h-46.66z"]
};
var faFill = {
  prefix: 'far',
  iconName: 'fill',
  icon: [512, 512, [], "f575", "M502.63 217.06L294.94 9.37A31.94 31.94 0 0 0 272.31 0c-8.19 0-16.38 3.12-22.62 9.37L162.5 96.56 70.62 4.69c-6.25-6.25-16.38-6.25-22.63 0L36.69 16c-6.25 6.25-6.25 16.38 0 22.63l91.88 91.88L28.11 230.95c-37.49 37.48-37.49 98.26 0 135.75L145.3 483.89c18.74 18.74 43.31 28.12 67.87 28.12 24.57 0 49.13-9.37 67.87-28.12l221.57-221.57c12.51-12.51 12.51-32.76.02-45.26zM247.11 449.95C238.05 459.01 226 464 213.18 464s-24.87-4.99-33.93-14.05L65.3 336h295.75L247.11 449.95zM409.06 288H49.34c2-8.67 6.27-16.67 12.71-23.11L162.5 164.44l69.9 69.9c9.37 9.37 24.56 9.37 33.94 0 9.37-9.37 9.37-24.57 0-33.94l-69.9-69.9 75.87-75.87 185.06 185.06L409.06 288z"]
};
var faFillDrip = {
  prefix: 'far',
  iconName: 'fill-drip',
  icon: [576, 512, [], "f576", "M512 320s-64 92.65-64 128c0 35.35 28.66 64 64 64s64-28.65 64-64-64-128-64-128zm-9.37-102.94L294.94 9.37A31.94 31.94 0 0 0 272.31 0c-8.19 0-16.38 3.12-22.62 9.37L162.5 96.56 70.62 4.69c-6.25-6.25-16.38-6.25-22.63 0L36.69 16c-6.25 6.25-6.25 16.38 0 22.63l91.88 91.88L28.11 230.95c-37.49 37.48-37.49 98.26 0 135.75L145.3 483.89c18.74 18.74 43.31 28.12 67.87 28.12 24.57 0 49.13-9.37 67.87-28.12l221.57-221.57c12.51-12.51 12.51-32.76.02-45.26zM247.11 449.95C238.05 459.01 226 464 213.18 464s-24.87-4.99-33.93-14.05L65.3 336h295.75L247.11 449.95zM409.06 288H49.34c2-8.67 6.27-16.67 12.71-23.11L162.5 164.44l69.9 69.9c9.37 9.37 24.56 9.37 33.94 0 9.37-9.37 9.37-24.57 0-33.94l-69.9-69.9 75.87-75.87 185.05 185.06-48.3 48.31z"]
};
var faFilm = {
  prefix: 'far',
  iconName: 'film',
  icon: [512, 512, [], "f008", "M488 64h-8v20c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12V64H96v20c0 6.6-5.4 12-12 12H44c-6.6 0-12-5.4-12-12V64h-8C10.7 64 0 74.7 0 88v336c0 13.3 10.7 24 24 24h8v-20c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v20h320v-20c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v20h8c13.3 0 24-10.7 24-24V88c0-13.3-10.7-24-24-24zM96 372c0 6.6-5.4 12-12 12H44c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm0-96c0 6.6-5.4 12-12 12H44c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm0-96c0 6.6-5.4 12-12 12H44c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm288 208c0 6.6-5.4 12-12 12H140c-6.6 0-12-5.4-12-12v-96c0-6.6 5.4-12 12-12h232c6.6 0 12 5.4 12 12v96zm0-168c0 6.6-5.4 12-12 12H140c-6.6 0-12-5.4-12-12v-96c0-6.6 5.4-12 12-12h232c6.6 0 12 5.4 12 12v96zm96 152c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm0-96c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm0-96c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40z"]
};
var faFilmAlt = {
  prefix: 'far',
  iconName: 'film-alt',
  icon: [512, 512, [], "f3a0", "M488 64h-8v20c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12V64H96v20c0 6.6-5.4 12-12 12H44c-6.6 0-12-5.4-12-12V64h-8C10.7 64 0 74.7 0 88v336c0 13.3 10.7 24 24 24h8v-20c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v20h320v-20c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v20h8c13.3 0 24-10.7 24-24V88c0-13.3-10.7-24-24-24zM96 372c0 6.6-5.4 12-12 12H44c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm0-96c0 6.6-5.4 12-12 12H44c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm0-96c0 6.6-5.4 12-12 12H44c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm280 208c0 6.6-5.4 12-12 12H148c-6.6 0-12-5.4-12-12V124c0-6.6 5.4-12 12-12h216c6.6 0 12 5.4 12 12v264zm104-16c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm0-96c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40zm0-96c0 6.6-5.4 12-12 12h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40z"]
};
var faFilter = {
  prefix: 'far',
  iconName: 'filter',
  icon: [512, 512, [], "f0b0", "M463.952 0H48.057C5.419 0-16.094 51.731 14.116 81.941L176 243.882V416c0 15.108 7.113 29.335 19.2 40l64 47.066c31.273 21.855 76.8 1.538 76.8-38.4V243.882L497.893 81.941C528.042 51.792 506.675 0 463.952 0zM288 224v240l-64-48V224L48 48h416L288 224z"]
};
var faFingerprint = {
  prefix: 'far',
  iconName: 'fingerprint',
  icon: [512, 512, [], "f577", "M256.12 245.96c-13.25 0-24 10.74-24 24 1.14 72.25-8.14 141.9-27.7 211.55-2.73 9.72 2.15 30.49 23.12 30.49 10.48 0 20.11-6.92 23.09-17.52 13.53-47.91 31.04-125.41 29.48-224.52.01-13.25-10.73-24-23.99-24zm-.86-81.73C194 164.16 151.25 211.3 152.1 265.32c.75 47.94-3.75 95.91-13.37 142.55-2.69 12.98 5.67 25.69 18.64 28.36 13.05 2.67 25.67-5.66 28.36-18.64 10.34-50.09 15.17-101.58 14.37-153.02-.41-25.95 19.92-52.49 54.45-52.34 31.31.47 57.15 25.34 57.62 55.47.77 48.05-2.81 96.33-10.61 143.55-2.17 13.06 6.69 25.42 19.76 27.58 19.97 3.33 26.81-15.1 27.58-19.77 8.28-50.03 12.06-101.21 11.27-152.11-.88-55.8-47.94-101.88-104.91-102.72zm-110.69-19.78c-10.3-8.34-25.37-6.8-33.76 3.48-25.62 31.5-39.39 71.28-38.75 112 .59 37.58-2.47 75.27-9.11 112.05-2.34 13.05 6.31 25.53 19.36 27.89 20.11 3.5 27.07-14.81 27.89-19.36 7.19-39.84 10.5-80.66 9.86-121.33-.47-29.88 9.2-57.88 28-80.97 8.35-10.28 6.79-25.39-3.49-33.76zm109.47-62.33c-15.41-.41-30.87 1.44-45.78 4.97-12.89 3.06-20.87 15.98-17.83 28.89 3.06 12.89 16 20.83 28.89 17.83 11.05-2.61 22.47-3.77 34-3.69 75.43 1.13 137.73 61.5 138.88 134.58.59 37.88-1.28 76.11-5.58 113.63-1.5 13.17 7.95 25.08 21.11 26.58 16.72 1.95 25.51-11.88 26.58-21.11a929.06 929.06 0 0 0 5.89-119.85c-1.56-98.75-85.07-180.33-186.16-181.83zm252.07 121.45c-2.86-12.92-15.51-21.2-28.61-18.27-12.94 2.86-21.12 15.66-18.26 28.61 4.71 21.41 4.91 37.41 4.7 61.6-.11 13.27 10.55 24.09 23.8 24.2h.2c13.17 0 23.89-10.61 24-23.8.18-22.18.4-44.11-5.83-72.34zm-40.12-90.72C417.29 43.46 337.6 1.29 252.81.02 183.02-.82 118.47 24.91 70.46 72.94 24.09 119.37-.9 181.04.14 246.65l-.12 21.47c-.39 13.25 10.03 24.31 23.28 24.69.23.02.48.02.72.02 12.92 0 23.59-10.3 23.97-23.3l.16-23.64c-.83-52.5 19.16-101.86 56.28-139 38.76-38.8 91.34-59.67 147.68-58.86 69.45 1.03 134.73 35.56 174.62 92.39 7.61 10.86 22.56 13.45 33.42 5.86 10.84-7.62 13.46-22.59 5.84-33.43z"]
};
var faFire = {
  prefix: 'far',
  iconName: 'fire',
  icon: [384, 512, [], "f06d", "M216 24.01c0-23.8-31.16-33.11-44.15-13.04C76.55 158.25 200 238.73 200 288c0 22.06-17.94 40-40 40s-40-17.94-40-40V182.13c0-19.39-21.86-30.76-37.73-19.68C30.75 198.38 0 257.28 0 320c0 105.87 86.13 192 192 192s192-86.13 192-192c0-170.29-168-192.85-168-295.99zM192 464c-79.4 0-144-64.6-144-144 0-28.66 8.56-64.71 24-88v56c0 48.52 39.48 88 88 88s88-39.48 88-88c0-64.27-88-120-64-208 40 88 152 121.77 152 240 0 79.4-64.6 144-144 144z"]
};
var faFireAlt = {
  prefix: 'far',
  iconName: 'fire-alt',
  icon: [448, 512, [], "f7e4", "M323.56 51.2c-20.8 19.3-39.58 39.59-56.22 59.97C240.08 73.62 206.28 35.53 168 0 69.74 91.17 0 209.96 0 281.6 0 408.85 100.29 512 224 512s224-103.15 224-230.4c0-53.27-51.98-163.14-124.44-230.4zM224 464c-97.05 0-176-81.83-176-182.4 0-45.37 44.3-133.21 120.16-214.09 22.34 23.36 42.82 47.72 60.34 71.86l36.62 50.44 39.41-48.29c5.83-7.15 11.85-14.15 18.01-20.97C368.89 177.96 400 250.42 400 281.6 400 382.17 321.05 464 224 464zm89.47-220.84l-51.3 58.52S181.75 198.98 175.69 192C133.27 242.86 112 272.62 112 306.41 112 374.23 163.37 416 226.5 416c25.26 0 48.62-7.87 67.58-21.13 43.08-30.14 53.18-88.58 29.26-134.24-2.95-5.62-6.24-11.48-9.87-17.47z"]
};
var faFireExtinguisher = {
  prefix: 'far',
  iconName: 'fire-extinguisher',
  icon: [448, 512, [], "f134", "M420.054 20.658l-144 24C264.919 46.514 256 54.906 256 72h-58.332C208.353 36.108 181.446 0 144 0c-39.435 0-66.368 39.676-52.228 76.203-52.039 13.051-75.381 54.213-90.049 90.884-4.923 12.307 1.063 26.274 13.37 31.197 12.317 4.926 26.279-1.075 31.196-13.37C75.058 112.99 106.964 120 168 120v27.076c-41.543 10.862-72 49.235-72 94.129V488c0 13.255 10.745 24 24 24h144c13.255 0 24-10.745 24-24V240c0-44.731-30.596-82.318-72-92.975V120h40c0 16.871 8.727 25.454 20.054 27.342l144 24C434.681 173.78 448 162.501 448 147.669V44.331c0-14.829-13.316-26.112-27.946-23.673zM144 72c-8.822 0-16-7.178-16-16s7.178-16 16-16 16 7.178 16 16-7.178 16-16 16zm96 168v224h-96V241.205c0-26.936 21.366-49.009 47.632-49.204L192 192c26.467 0 48 21.533 48 48zm168-111.218l-112-18.667v-28.23l112-18.667v65.564z"]
};
var faFireSmoke = {
  prefix: 'far',
  iconName: 'fire-smoke',
  icon: [576, 512, [], "f74b", "M456 272c-27.3 0-53.1 9.2-74 25.8-23.9-26.3-57.8-41.8-94-41.8s-70.1 15.5-94 41.8c-20.9-16.6-46.6-25.8-74-25.8C53.8 272 0 325.8 0 392s53.8 120 120 120h336c66.2 0 120-53.8 120-120s-53.8-120-120-120zm0 192H120c-39.7 0-72-32.3-72-72s32.3-72 72-72c22.7 0 43.7 10.7 57.6 29.3l22.5 30.2 17.9-33.1c14-26.2 40.9-42.4 70-42.4s56 16.2 70.1 42.3l17.9 33.1 22.5-30.2c13.8-18.6 34.8-29.3 57.6-29.3 39.7 0 72 32.3 72 72S495.7 464 456 464zM320 200s-70.2-71.7-75.4-77.9c-36.2 44.9-54.4 71.2-54.4 101.1 0 11.4 2 21.6 5 31.3C222.1 235 254.5 224 288 224c32.4 0 63.7 10.5 90.1 28.7 5.9-22.8 3.7-48-7.4-69.9-2.5-5-5.3-10.1-8.4-15.4L320 200zm-200 40c15.7 0 30.9 2.6 45.4 7.2-3.2-10.9-5.4-22.3-5.4-34.2 0-29.8 31.5-89.7 84.2-146.1 14.5 15.1 27.9 30.7 39.5 46.1l36.1 47.9 38.8-45.8c2.1-2.5 4.2-4.9 6.4-7.3 31.9 40.9 51 87.8 51 105.2 0 11.9-2.2 23.3-5.4 34.2 14.5-4.6 29.7-7.2 45.4-7.2 1.9 0 3.7.5 5.6.6 1.5-9 2.4-18.2 2.4-27.6 0-40.3-40.8-123.4-97.8-174.2-16.3 14.6-31.1 29.9-44.2 45.4-21.4-28.5-47.9-57.3-78-84.2-77.2 68.9-132 158.8-132 213 0 9.4 1 18.6 2.4 27.6 1.9-.1 3.7-.6 5.6-.6z"]
};
var faFireplace = {
  prefix: 'far',
  iconName: 'fireplace',
  icon: [640, 512, [], "f79a", "M342.3 311.6c-14-18.8-31.4-37.8-51.1-55.6-50.5 45.6-86.4 105-86.4 140.8 0 63.6 51.6 115.2 115.2 115.2s115.2-51.6 115.2-115.2c0-26.6-26.7-81.6-64-115.2-10.7 9.6-20.4 19.8-28.9 30zm15.5 136.9c-10.6 7.7-23.7 12.3-37.8 12.3-35.3 0-64-24.4-64-64 0-19.7 11.9-37.1 35.6-66.8 3.4 4.1 48.3 64.1 48.3 64.1l28.7-34.2c2 3.5 3.9 6.9 5.5 10.2 13.4 26.6 7.8 60.8-16.3 78.4zM624 0H16C7.2 0 0 7.2 0 16v112c0 8.8 7.2 16 16 16h16v344c0 13.3 10.7 24 24 24h80c13.3 0 24-10.7 24-24v-96.6c0-83.7 60.9-158.7 144.2-166.7 5.3-.5 10.6-.8 15.8-.8 88.4 0 160 71.6 160 160v104c0 13.3 10.7 24 24 24h80c13.3 0 24-10.7 24-24V144h16c8.8 0 16-7.2 16-16V16c0-8.8-7.2-16-16-16zm-64 464h-32v-80c0-114.7-93.3-208-208-208-6.7 0-13.5.3-20.3 1C194.5 187 112 281 112 390.9V464H80V144h480v320zm32-368H48V48h544v48z"]
};
var faFirstAid = {
  prefix: 'far',
  iconName: 'first-aid',
  icon: [576, 512, [], "f479", "M200 288h56v56c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-56h56c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8h-56v-56c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v56h-56c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zM528 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h480c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM96 432H54c-3.3 0-6-2.7-6-6V86c0-3.3 2.7-6 6-6h42v352zm336 0H144V80h288v352zm96-6c0 3.3-2.7 6-6 6h-42V80h42c3.3 0 6 2.7 6 6v340z"]
};
var faFish = {
  prefix: 'far',
  iconName: 'fish',
  icon: [640, 512, [], "f578", "M360.18 64c-103.38 0-183.5 63.14-220.38 98.67l-72.88-56.3c-13.91-10.75-33.25-11.66-48.22-2.23C4.39 113.17-2.61 129.53.89 145.81L24.64 256 .89 366.19c-3.5 16.28 3.5 32.64 17.81 41.67 14.97 9.42 34.31 8.5 48.22-2.22l72.88-56.31c36.88 35.53 117 98.67 220.38 98.67C514.09 448 640 303.05 640 256S514.09 64 360.18 64zm0 336c-81.19 0-156.79-51.09-200.44-98.91l-14.91-16.31-92.72 71.63L73.77 256 52.11 155.59l92.72 71.63 14.91-16.31C203.4 163.09 278.99 112 360.18 112c125.22 0 227.97 119.88 231.85 143.2C588.15 280.13 485.4 400 360.18 400zM448 224c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faFishCooked = {
  prefix: 'far',
  iconName: 'fish-cooked',
  icon: [640, 512, [], "f7fe", "M360.18 64C257 64 176.93 126.92 140 162.48l-73-57.73a42.27 42.27 0 0 0-48.22-2.19C4.39 111.59-2.61 128 .89 144.14L24.67 256 .89 367.8a39.15 39.15 0 0 0 17.82 41.65 42.33 42.33 0 0 0 48.4-2.37L140 349.5c37 35.56 117 98.5 220.22 98.5C514.09 448 640 303.05 640 256S514.09 64 360.18 64zm0 336c-18 0-107.64 2.59-215.57-115.39l-92.5 73.16L73.74 256 52.11 154.2l92.57 73.19C252.75 109 341.55 112 360.18 112c125.22 0 228 119.88 231.85 143.2C588.16 280.12 485.4 400 360.18 400zm-12.87-240L336 148.69a16 16 0 0 0-22.62 0l-84.69 84.69a16 16 0 0 0 0 22.62L240 267.31a16 16 0 0 0 22.63 0l84.69-84.69a16 16 0 0 0-.01-22.62zm112 16L448 164.69a16 16 0 0 0-22.63 0L276.68 313.38a16 16 0 0 0 0 22.62L288 347.31a16 16 0 0 0 22.63 0l148.68-148.69a16 16 0 0 0 0-22.62zM496 244.69a16 16 0 0 0-22.63 0l-84.69 84.69a16 16 0 0 0 0 22.62L400 363.31a16 16 0 0 0 22.63 0l84.69-84.69a16 16 0 0 0 0-22.62z"]
};
var faFistRaised = {
  prefix: 'far',
  iconName: 'fist-raised',
  icon: [448, 512, [], "f6de", "M400 180.33V88c0-30.93-25.07-56-56-56h-24c-4.4 0-8.64.63-12.75 1.6C298.59 13.86 278.9 0 256 0h-24c-22.9 0-42.59 13.86-51.25 33.6-4.11-.97-8.35-1.6-12.75-1.6h-24c-22.9 0-42.59 13.86-51.25 33.6C88.64 64.63 84.4 64 80 64H56C25.07 64 0 89.07 0 120v210.98c0 40.29 16 78.94 44.49 107.43L64 457.93V496c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-57.94l-33.53-33.54C59.09 385.16 48 358.34 48 330.98v-59.79c2.63.38 5.26.81 8 .81h24c11.91 0 22.91-3.8 32-10.17 9.09 6.37 20.09 10.17 32 10.17h24c11.78 0 22.69-3.7 31.72-9.94 4.72 11.09 11.44 21.25 20.16 29.98 3.85 3.86 8.04 7.23 12.39 10.33-18.28 15.61-33.47 36.18-49.5 60.2-5.94 8.91-3.53 20.94 5.38 26.87l7.69 5.12c8.91 5.94 20.94 3.53 26.87-5.37 29.28-43.91 46.74-64.58 83.3-68.49 8-.86 13.98-7.8 13.98-15.85V288c0-8.84-7.16-16-16-16h-16.68c-26.16 0-47.36-21.2-47.36-47.36v-.74c0-8.78 7.12-15.9 15.9-15.9H336c35.35 0 64 28.65 64 64v48c0 25.46-10.11 49.88-28.12 67.88L320 439.76V496c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-36.35l37.83-37.83A144 144 0 0 0 448 320v-48c0-37.94-19.06-71.4-48-91.67zM80 224H56c-4.41 0-8-3.59-8-8v-96c0-4.41 3.59-8 8-8h24c4.41 0 8 3.59 8 8v96c0 4.41-3.59 8-8 8zm96-8c0 4.41-3.59 8-8 8h-24c-4.41 0-8-3.59-8-8V88c0-4.41 3.59-8 8-8h24c4.41 0 8 3.59 8 8v128zm48-47.13V56c0-4.41 3.59-8 8-8h24c4.41 0 8 3.59 8 8v104h-8.03c-11.7 0-22.53 3.38-31.97 8.87zm88-8.87V88c0-4.41 3.59-8 8-8h24c4.41 0 8 3.59 8 8v73.62c-5.27-.76-10.52-1.62-16-1.62h-24z"]
};
var faFlag = {
  prefix: 'far',
  iconName: 'flag',
  icon: [512, 512, [], "f024", "M336.174 80c-49.132 0-93.305-32-161.913-32-31.301 0-58.303 6.482-80.721 15.168a48.04 48.04 0 0 0 2.142-20.727C93.067 19.575 74.167 1.594 51.201.104 23.242-1.71 0 20.431 0 48c0 17.764 9.657 33.262 24 41.562V496c0 8.837 7.163 16 16 16h16c8.837 0 16-7.163 16-16v-83.443C109.869 395.28 143.259 384 199.826 384c49.132 0 93.305 32 161.913 32 58.479 0 101.972-22.617 128.548-39.981C503.846 367.161 512 352.051 512 335.855V95.937c0-34.459-35.264-57.768-66.904-44.117C409.193 67.309 371.641 80 336.174 80zM464 336c-21.783 15.412-60.824 32-102.261 32-59.945 0-102.002-32-161.913-32-43.361 0-96.379 9.403-127.826 24V128c21.784-15.412 60.824-32 102.261-32 59.945 0 102.002 32 161.913 32 43.271 0 96.32-17.366 127.826-32v240z"]
};
var faFlagAlt = {
  prefix: 'far',
  iconName: 'flag-alt',
  icon: [512, 512, [], "f74c", "M472.5 0c-7 0-14.3 1.5-21.2 4.6-50.5 22.7-87.8 30.3-119.1 30.3C266.1 34.9 227.7.4 151.4.4c-28.4 0-62.2 4.9-104.5 18C44.3 7.9 35.3 0 24 0 10.7 0 0 10.7 0 24v476c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12V398.1c37.3-11.8 69.6-16.5 98.5-16.5 81.2 0 137.8 34.4 219.1 34.4 35.3 0 75.1-6.5 123.7-25 14-5.4 22.8-17.9 22.8-31.2V33.4C512 13 493.4 0 472.5 0zM464 349.1c-35.3 12.7-67.6 18.9-98.5 18.9-75.5 0-128.5-34.4-219.1-34.4-31.9 0-64.5 4.7-98.5 14.2V68.5C87.7 55 121.7 48.4 151.4 48.4c66.3 0 105.2 34.5 180.8 34.5 40.3 0 82.3-10 131.8-31.5v297.7z"]
};
var faFlagCheckered = {
  prefix: 'far',
  iconName: 'flag-checkered',
  icon: [512, 512, [], "f11e", "M448 327.4V258c-15.5 9.4-44 19-72 22.9v70.4c28.7-2.8 54.8-13.5 72-23.9zm0-207.3c-21.2 8.1-46.7 15.8-72 20.2v70.6c25-4 48.6-12.5 72-21.4zM88 336.8c21.7-7 47.2-11.9 72-14.5v-70.1c-24.3 2.4-48 7.6-72 15.3zm357.1-285C409.2 67.3 371.6 80 336.2 80c-49.1 0-93.3-32-161.9-32-31.3 0-58.3 6.5-80.8 15.2 2.2-6.7 3-13.7 2.1-20.7C93.1 19.6 74.2 1.6 51.2.1 23.2-1.7 0 20.4 0 48c0 17.8 9.7 33.3 24 41.6V496c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-83.4c37.9-17.3 71.3-28.6 127.8-28.6 49.1 0 93.3 32 161.9 32 58.5 0 102-22.6 128.5-40 13.6-8.9 21.7-24 21.7-40.2V95.9c.1-34.4-35.2-57.7-66.8-44.1zM464 336c-21.8 15.4-60.8 32-102.3 32-59.9 0-102-32-161.9-32-43.4 0-96.4 9.4-127.8 24V128c21.8-15.4 60.8-32 102.3-32 59.9 0 102 32 161.9 32 43.3 0 96.3-17.4 127.8-32zM88 136.6V206c15.5-9.4 44-19 72-22.9v-70.4c-28.7 2.8-54.8 13.4-72 23.9zm72 46.5v69.1c30.5-3 51.4-1.3 72 3.1v-67c-28.5-7.6-48.7-8.4-72-5.2zm144 92.7c-23.7-6.2-46.5-15.2-72-20.5v67.5c25.9 4.3 48.9 12.9 72 19.6v-66.6c28.5 7.5 48.7 8.3 72 5.2v-70c-23.8 3.8-46.5 3.3-72-2.1zm0-134.5c-25.9-4.3-48.8-12.9-72-19.7v66.6c23.8 6.3 46.5 15.2 72 20.5z"]
};
var faFlagUsa = {
  prefix: 'far',
  iconName: 'flag-usa',
  icon: [512, 512, [], "f74d", "M472.5 0c-7 0-14.3 1.5-21.2 4.6-50.5 22.7-87.8 30.3-119.1 30.3C266.1 34.9 227.7.4 151.4.4c-28.4 0-62.2 4.9-104.5 18C44.3 7.9 35.3 0 24 0 10.7 0 0 10.7 0 24v476c0 6.6 5.4 12 12 12h24c6.6 0 12-5.4 12-12V398.1c37.3-11.8 69.6-16.5 98.5-16.5 81.2 0 137.8 34.4 219.1 34.4 35.3 0 75.1-6.5 123.7-25 14-5.4 22.8-17.9 22.8-31.2V33.4C512 13 493.4 0 472.5 0zM176 40c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm0 56c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm-72-56c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm0 56c8.8 0 16 7.2 16 16s-7.2 16-16 16-16-7.2-16-16 7.2-16 16-16zm360 253.1c-79 28.4-125.8 20.7-196.4 3.1-73-18.2-132.2-28.8-219.6-4.4v-55.3c92.6-32.5 146-19.4 202.2-5.2C304.4 301 363.8 317.4 464 286v63.1zm0-113.6c-92.5 32.4-146 19.4-202.1 5.2-57.5-14.5-117.4-29-213.9 1.3v-61.6c92.6-32.5 146-19.4 202.2-5.2C304.4 189 363.8 205.4 464 174v61.5zm0-112c-96.5 33.8-150.9 18.1-208 3.7V71c22.2 6.4 46.9 11.9 76.2 11.9 40.3 0 82.3-10 131.8-31.5v72.1z"]
};
var faFlame = {
  prefix: 'far',
  iconName: 'flame',
  icon: [384, 512, [], "f6df", "M192 0C79.7 101.33 0 220.92 0 300.55 0 425.05 78.95 512 192 512s192-86.95 192-211.45C384 220.6 303.78 100.86 192 0zm0 464c-86.13 0-144-65.69-144-163.45 0-46.27 45.31-136.62 143.96-234.47C278.21 151.97 336 244.82 336 300.55 336 398.31 278.13 464 192 464zm45.07-224.32c-19.89-17-38.67-33.06-38.67-58.22 0-3.4-2.82-4.69-4.04-5.08-2.32-.74-5.77-.57-7.94 2.38C131.52 253.42 216 248 216 302c0 23.2-18.8 42-42 42-23.19 0-42-18.8-42-42v-30a6 6 0 0 0-10.24-4.24C115.38 273.95 96 294.48 96 327.58c0 48.75 43.06 88.42 96 88.42s96-39.67 96-88.42c0-44.37-25.89-66.5-50.93-87.9z"]
};
var faFlask = {
  prefix: 'far',
  iconName: 'flask',
  icon: [448, 512, [], "f0c3", "M437.2 403.5L320 215V48h20c6.6 0 12-5.4 12-12V12c0-6.6-5.4-12-12-12H108c-6.6 0-12 5.4-12 12v24c0 6.6 5.4 12 12 12h20v167L10.8 403.5C-18.5 450.6 15.3 512 70.9 512h306.2c55.7 0 89.4-61.5 60.1-108.5zM377.1 464H70.9c-18.1 0-28.7-20.1-19.3-35.2l117.2-188.5c4.7-7.6 7.2-16.4 7.2-25.3V48h96v167c0 9 2.5 17.7 7.2 25.3l117.2 188.5c9.4 15.1-1.1 35.2-19.3 35.2z"]
};
var faFlaskPoison = {
  prefix: 'far',
  iconName: 'flask-poison',
  icon: [416, 512, [], "f6e0", "M304 169.05V48h16c8.84 0 16-7.16 16-16V16c0-8.84-7.16-16-16-16H96c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h16v120.12C45.61 202.85 0 271.88 0 352c0 53.79 20.43 102.79 53.94 139.7 11.95 13.17 29.22 20.3 47 20.3h214.05c18.06 0 35.49-7.44 47.58-20.85 32.24-35.78 52.25-82.79 53.39-134.48 1.75-79.95-44.77-151.49-111.96-187.62zm22.91 289.96c-2.81 3.12-7.27 4.99-11.92 4.99H100.94c-4.58 0-8.86-1.71-11.45-4.56C62.73 429.97 48 391.81 48 352c0-59.36 33.05-113.52 86.25-141.35L160 197.17V48h96v149.74l25.27 13.59c53.96 29.02 87.99 85.65 86.7 144.29-.85 38.23-15.43 74.95-41.06 103.39zM208 256c-49.09 0-88.89 31.84-88.89 71.11 0 23.19 14.09 43.59 35.55 56.57v14.54c0 9.82 7.96 17.78 17.78 17.78h71.11c9.82 0 17.78-7.96 17.78-17.78v-14.54c21.47-12.98 35.55-33.38 35.55-56.57C296.89 287.84 257.1 256 208 256zm-35.55 88.89c-9.82 0-17.78-7.96-17.78-17.78s7.96-17.78 17.78-17.78 17.78 7.96 17.78 17.78c-.01 9.82-7.97 17.78-17.78 17.78zm71.11 0c-9.82 0-17.78-7.96-17.78-17.78s7.96-17.78 17.78-17.78 17.78 7.96 17.78 17.78-7.97 17.78-17.78 17.78z"]
};
var faFlaskPotion = {
  prefix: 'far',
  iconName: 'flask-potion',
  icon: [416, 512, [], "f6e1", "M304 169.05V48h16c8.84 0 16-7.16 16-16V16c0-8.84-7.16-16-16-16H96c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h16v120.12C45.61 202.85 0 271.88 0 352c0 53.79 20.43 102.79 53.94 139.7 11.95 13.17 29.22 20.3 47 20.3h214.05c18.06 0 35.49-7.44 47.58-20.85 32.24-35.78 52.25-82.79 53.39-134.48 1.75-79.95-44.77-151.49-111.96-187.62zm-144 28.12V48h96v149.74c16.81 9.04 94.76 40.59 109.67 130.26h-31.76c-26.41 0-52.88-6.08-76.47-17.58-61-29.75-133.88-29.75-194.88 0l-9.93 4.84C72.41 232.48 142.66 206.25 160 197.17zm166.91 261.84c-2.81 3.12-7.27 4.99-11.92 4.99H100.94c-4.58 0-8.86-1.71-11.45-4.56-22.64-24.94-36.04-56.23-39.81-89.35l33.92-16.51c47.81-23.34 104.97-23.34 152.84 0 30.09 14.67 63.81 22.42 97.47 22.42h31.77c-4.68 30.72-17.76 59.7-38.77 83.01z"]
};
var faFlower = {
  prefix: 'far',
  iconName: 'flower',
  icon: [512, 512, [], "f7ff", "M461.55 256C492.22 229.19 512 190.23 512 146.29A146.28 146.28 0 0 0 365.71 0C321.77 0 282.81 19.78 256 50.45 229.19 19.78 190.23 0 146.29 0A146.28 146.28 0 0 0 0 146.29c0 43.94 19.78 82.9 50.45 109.71C19.78 282.81 0 321.77 0 365.71A146.29 146.29 0 0 0 146.29 512c43.94 0 82.9-19.78 109.71-50.45C282.81 492.22 321.77 512 365.71 512A146.29 146.29 0 0 0 512 365.71c0-43.94-19.78-82.9-50.45-109.71zm-95.84 208c-28.25 0-54.38-12.09-73.57-34L256 388.62 219.86 430c-19.19 22-45.32 34-73.57 34A98.4 98.4 0 0 1 48 365.71c0-28.25 12.09-54.38 34-73.57L123.38 256 82 219.86c-22-19.19-34-45.32-34-73.57A98.4 98.4 0 0 1 146.29 48c28.25 0 54.38 12.09 73.57 34L256 123.38 292.14 82c19.19-22 45.32-34 73.57-34A98.4 98.4 0 0 1 464 146.29c0 28.25-12.09 54.38-34 73.57L388.62 256 430 292.14c22 19.19 34 45.32 34 73.57A98.4 98.4 0 0 1 365.71 464zM256 176a80 80 0 1 0 80 80 80 80 0 0 0-80-80z"]
};
var faFlowerDaffodil = {
  prefix: 'far',
  iconName: 'flower-daffodil',
  icon: [512, 512, [], "f800", "M495.87 288h-47.26c-67.45 0-127.49 30-168.61 77v-82a90.52 90.52 0 0 0 102.53-139A89.43 89.43 0 0 0 400 90.67 90.76 90.76 0 0 0 309.34 0 89.39 89.39 0 0 0 256 17.47 89.4 89.4 0 0 0 202.65 0 90.75 90.75 0 0 0 112 90.67 89.43 89.43 0 0 0 129.47 144 89.43 89.43 0 0 0 112 197.33a90.48 90.48 0 0 0 120 85.72v82c-41.12-47-101.16-77-168.6-77H16.13c-9.19 0-17 9-16.06 19.65C10.06 422.15 106.43 512 223.83 512h64.34c117.4 0 213.77-89.85 223.76-204.35.92-10.65-6.87-19.65-16.06-19.65zm-272 176c-79.54 0-148.7-54.09-169.91-128 75.25 0 128.67 32.21 160.93 85.92L240.13 464zm12.92-241.37a42.48 42.48 0 1 1-59.38-59.38L203.19 144l-25.82-19.25A42.27 42.27 0 0 1 160 90.67 42.7 42.7 0 0 1 202.65 48a42.26 42.26 0 0 1 34.1 17.38L256 91.2l19.25-25.82A42.24 42.24 0 0 1 309.34 48 42.71 42.71 0 0 1 352 90.67a42.28 42.28 0 0 1-17.38 34.08L308.81 144l25.81 19.25A42.28 42.28 0 0 1 352 197.33 42.71 42.71 0 0 1 309.34 240a42.26 42.26 0 0 1-34.09-17.37L256 196.8zM288 464h-16.13l25.28-42.08c32.07-53.4 85.3-85.92 160.93-85.92-21.22 73.91-90.39 128-170.08 128zm0-320a32 32 0 1 0-32 32 32 32 0 0 0 32-32z"]
};
var faFlowerTulip = {
  prefix: 'far',
  iconName: 'flower-tulip',
  icon: [512, 512, [], "f801", "M495.87 288H448.6c-67.44 0-127.48 30-168.6 77v-77.16c75.24-.88 136-62 136-137.44V16a16 16 0 0 0-25.45-12.88l-73.91 53.64-48.35-51a16 16 0 0 0-24.58 0l-48.35 51-73.91-53.64A16 16 0 0 0 96 16v134.4c0 75.45 60.76 136.6 136 137.44V365c-41.12-47-101.16-77-168.6-77H16.13c-9.19 0-17 9-16.06 19.65C10.06 422.15 106.43 512 223.83 512h64.34c117.4 0 213.77-89.85 223.76-204.35.92-10.65-6.87-19.65-16.06-19.65zM144 150.4v-72l56 41.6 56-56 56 56 56-41.6v72a89.6 89.6 0 0 1-89.6 89.6h-44.8a89.61 89.61 0 0 1-89.6-89.6zM223.83 464c-79.54 0-148.7-54.09-169.91-128 75.25 0 128.67 32.21 160.93 85.92L240.13 464zm64.17 0h-16.13l25.28-42.08c32-53.34 85.23-85.92 160.93-85.92-21.22 73.91-90.39 128-170.08 128z"]
};
var faFlushed = {
  prefix: 'far',
  iconName: 'flushed',
  icon: [496, 512, [], "f579", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm96-312c-44.2 0-80 35.8-80 80s35.8 80 80 80 80-35.8 80-80-35.8-80-80-80zm0 128c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm0-72c-13.3 0-24 10.7-24 24s10.7 24 24 24 24-10.7 24-24-10.7-24-24-24zm-112 24c0-44.2-35.8-80-80-80s-80 35.8-80 80 35.8 80 80 80 80-35.8 80-80zm-80 48c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm0-72c-13.3 0-24 10.7-24 24s10.7 24 24 24 24-10.7 24-24-10.7-24-24-24zm160 144H184c-13.2 0-24 10.8-24 24s10.8 24 24 24h128c13.2 0 24-10.8 24-24s-10.8-24-24-24z"]
};
var faFog = {
  prefix: 'far',
  iconName: 'fog',
  icon: [640, 512, [], "f74e", "M208 464H80c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h128c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm416 0H288c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h336c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16zm-48-56v-16c0-8.8-7.2-16-16-16H16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h544c8.8 0 16-7.2 16-16zm-404-88h296c59.6 0 108-48.5 108-108 0-57.3-44.9-104.3-101.3-107.8C461.2 61.8 422 32 376 32c-13.5 0-26.8 2.6-39.2 7.7C314.3 14.5 282.4 0 248 0c-64 0-116.4 50.3-119.8 113.4C89.6 130.4 64 168.5 64 212c0 59.5 48.4 108 108 108zm-13.6-166.3l20.8-4.8-2.8-24.9c-.2-1.3-.4-2.6-.4-4 0-39.7 32.3-72 72-72 25.2 0 48.2 13.1 61.4 35.1l13.3 22.1 21.1-14.9C353.4 83.6 364.5 80 376 80c28.6 0 52.4 21.7 55.3 50.4l2.2 21.6H468c33.1 0 60 26.9 60 60s-26.9 60-60 60H172c-33.1 0-60-26.9-60-60 0-28 19.1-52 46.4-58.3z"]
};
var faFolder = {
  prefix: 'far',
  iconName: 'folder',
  icon: [512, 512, [], "f07b", "M464 128H272l-54.63-54.63c-6-6-14.14-9.37-22.63-9.37H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V176c0-26.51-21.49-48-48-48zm0 272H48V112h140.12l54.63 54.63c6 6 14.14 9.37 22.63 9.37H464v224z"]
};
var faFolderMinus = {
  prefix: 'far',
  iconName: 'folder-minus',
  icon: [512, 512, [], "f65d", "M464 128H272l-54.63-54.63c-6-6-14.14-9.37-22.63-9.37H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V176c0-26.51-21.49-48-48-48zm0 272H48V112h140.12l54.63 54.63c6 6 14.14 9.37 22.63 9.37H464v224zM176 280v16c0 8.84 7.16 16 16 16h128c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16H192c-8.84 0-16 7.16-16 16z"]
};
var faFolderOpen = {
  prefix: 'far',
  iconName: 'folder-open',
  icon: [576, 512, [], "f07c", "M527.9 224H480v-48c0-26.5-21.5-48-48-48H272l-64-64H48C21.5 64 0 85.5 0 112v288c0 26.5 21.5 48 48 48h400c16.5 0 31.9-8.5 40.7-22.6l79.9-128c20-31.9-3-73.4-40.7-73.4zM48 118c0-3.3 2.7-6 6-6h134.1l64 64H426c3.3 0 6 2.7 6 6v42H152c-16.8 0-32.4 8.8-41.1 23.2L48 351.4zm400 282H72l77.2-128H528z"]
};
var faFolderPlus = {
  prefix: 'far',
  iconName: 'folder-plus',
  icon: [512, 512, [], "f65e", "M464 128H272l-54.63-54.63c-6-6-14.14-9.37-22.63-9.37H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V176c0-26.51-21.49-48-48-48zm0 272H48V112h140.12l54.63 54.63c6 6 14.14 9.37 22.63 9.37H464v224zM248 208c-8.84 0-16 7.16-16 16v40h-40c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h40v40c0 8.84 7.16 16 16 16h16c8.84 0 16-7.16 16-16v-40h40c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16h-40v-40c0-8.84-7.16-16-16-16h-16z"]
};
var faFolderTimes = {
  prefix: 'far',
  iconName: 'folder-times',
  icon: [512, 512, [], "f65f", "M464 128H272l-54.63-54.63c-6-6-14.14-9.37-22.63-9.37H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V176c0-26.51-21.49-48-48-48zm0 272H48V112h140.12l54.63 54.63c6 6 14.14 9.37 22.63 9.37H464v224zM227.71 225.77a15.964 15.964 0 0 0-11.31-4.69c-4.09 0-8.19 1.56-11.31 4.69l-11.31 11.31c-6.25 6.25-6.25 16.38 0 22.63L222.06 288l-28.28 28.28c-6.25 6.25-6.25 16.38 0 22.63l11.31 11.31c3.12 3.12 7.22 4.69 11.31 4.69s8.19-1.56 11.31-4.69L256 321.94l28.29 28.28c3.12 3.12 7.22 4.69 11.31 4.69s8.19-1.56 11.31-4.69l11.31-11.31c6.25-6.25 6.25-16.38 0-22.63L289.94 288l28.28-28.29c6.25-6.25 6.25-16.38 0-22.63l-11.31-11.31a15.964 15.964 0 0 0-11.31-4.69c-4.09 0-8.19 1.56-11.31 4.69L256 254.06l-28.29-28.29z"]
};
var faFolderTree = {
  prefix: 'far',
  iconName: 'folder-tree',
  icon: [576, 512, [], "f802", "M288 224h224a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32H400L368 0h-80a32 32 0 0 0-32 32v72H80V16A16 16 0 0 0 64 0H48a16 16 0 0 0-16 16v392a32 32 0 0 0 32 32h192v40a32 32 0 0 0 32 32h224a32 32 0 0 0 32-32V352a32 32 0 0 0-32-32H400l-32-32h-80a32 32 0 0 0-32 32v72H80V152h176v40a32 32 0 0 0 32 32zm16-176h44.12l32 32H496v96H304zm0 288h44.12l32 32H496v96H304z"]
};
var faFolders = {
  prefix: 'far',
  iconName: 'folders',
  icon: [640, 512, [], "f660", "M592 64H400L345.37 9.37c-6-6-14.14-9.37-22.63-9.37H176c-26.51 0-48 21.49-48 48v80H48c-26.51 0-48 21.49-48 48v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48v-80h80c26.51 0 48-21.49 48-48V112c0-26.51-21.49-48-48-48zM464 464H48V176h80v160c0 26.51 21.49 48 48 48h288v80zm128-128H176V48h140.12l54.63 54.63c6 6 14.14 9.37 22.63 9.37H592v224z"]
};
var faFont = {
  prefix: 'far',
  iconName: 'font',
  icon: [448, 512, [], "f031", "M432 432h-33.32l-135-389.24A16 16 0 0 0 248.55 32h-49.1a16 16 0 0 0-15.12 10.76L49.32 432H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-35.44l33.31-96h164.26l33.31 96H304a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM158.53 288L224 99.31 289.47 288z"]
};
var faFontAwesomeLogoFull = {
  prefix: 'far',
  iconName: 'font-awesome-logo-full',
  icon: [3992, 512, ["Font Awesome"], "f4e6", "M454.6 0H57.4C25.9 0 0 25.9 0 57.4v397.3C0 486.1 25.9 512 57.4 512h397.3c31.4 0 57.4-25.9 57.4-57.4V57.4C512 25.9 486.1 0 454.6 0zm-58.9 324.9c0 4.8-4.1 6.9-8.9 8.9-19.2 8.1-39.7 15.7-61.5 15.7-40.5 0-68.7-44.8-163.2 2.5v51.8c0 30.3-45.7 30.2-45.7 0v-250c-9-7-15-17.9-15-30.3 0-21 17.1-38.2 38.2-38.2 21 0 38.2 17.1 38.2 38.2 0 12.2-5.8 23.2-14.9 30.2v21c37.1-12 65.5-34.4 146.1-3.4 26.6 11.4 68.7-15.7 76.5-15.7 5.5 0 10.3 4.1 10.3 8.9v160.4zm432.9-174.2h-137v70.1H825c39.8 0 40.4 62.2 0 62.2H691.6v105.6c0 45.5-70.7 46.4-70.7 0V128.3c0-22 18-39.8 39.8-39.8h167.8c39.6 0 40.5 62.2.1 62.2zm191.1 23.4c-169.3 0-169.1 252.4 0 252.4 169.9 0 169.9-252.4 0-252.4zm0 196.1c-81.6 0-82.1-139.8 0-139.8 82.5 0 82.4 139.8 0 139.8zm372.4 53.4c-17.5 0-31.4-13.9-31.4-31.4v-117c0-62.4-72.6-52.5-99.1-16.4v133.4c0 41.5-63.3 41.8-63.3 0V208c0-40 63.1-41.6 63.1 0v3.4c43.3-51.6 162.4-60.4 162.4 39.3v141.5c.3 30.4-31.5 31.4-31.7 31.4zm179.7 2.9c-44.3 0-68.3-22.9-68.3-65.8V235.2H1488c-35.6 0-36.7-55.3 0-55.3h15.5v-37.3c0-41.3 63.8-42.1 63.8 0v37.5h24.9c35.4 0 35.7 55.3 0 55.3h-24.9v108.5c0 29.6 26.1 26.3 27.4 26.3 31.4 0 52.6 56.3-22.9 56.3zM1992 123c-19.5-50.2-95.5-50-114.5 0-107.3 275.7-99.5 252.7-99.5 262.8 0 42.8 58.3 51.2 72.1 14.4l13.5-35.9H2006l13 35.9c14.2 37.7 72.1 27.2 72.1-14.4 0-10.1 5.3 6.8-99.1-262.8zm-108.9 179.1l51.7-142.9 51.8 142.9h-103.5zm591.3-85.6l-53.7 176.3c-12.4 41.2-72 41-84 0l-42.3-135.9-42.3 135.9c-12.4 40.9-72 41.2-84.5 0l-54.2-176.3c-12.5-39.4 49.8-56.1 60.2-16.9L2213 342l45.3-139.5c10.9-32.7 59.6-34.7 71.2 0l45.3 139.5 39.3-142.4c10.3-38.3 72.6-23.8 60.3 16.9zm275.4 75.1c0-42.4-33.9-117.5-119.5-117.5-73.2 0-124.4 56.3-124.4 126 0 77.2 55.3 126.4 128.5 126.4 31.7 0 93-11.5 93-39.8 0-18.3-21.1-31.5-39.3-22.4-49.4 26.2-109 8.4-115.9-43.8h148.3c16.3 0 29.3-13.4 29.3-28.9zM2571 277.7c9.5-73.4 113.9-68.6 118.6 0H2571zm316.7 148.8c-31.4 0-81.6-10.5-96.6-31.9-12.4-17 2.5-39.8 21.8-39.8 16.3 0 36.8 22.9 77.7 22.9 27.4 0 40.4-11 40.4-25.8 0-39.8-142.9-7.4-142.9-102 0-40.4 35.3-75.7 98.6-75.7 31.4 0 74.1 9.9 87.6 29.4 10.8 14.8-1.4 36.2-20.9 36.2-15.1 0-26.7-17.3-66.2-17.3-22.9 0-37.8 10.5-37.8 23.8 0 35.9 142.4 6 142.4 103.1-.1 43.7-37.4 77.1-104.1 77.1zm266.8-252.4c-169.3 0-169.1 252.4 0 252.4 170.1 0 169.6-252.4 0-252.4zm0 196.1c-81.8 0-82-139.8 0-139.8 82.5 0 82.4 139.8 0 139.8zm476.9 22V268.7c0-53.8-61.4-45.8-85.7-10.5v134c0 41.3-63.8 42.1-63.8 0V268.7c0-52.1-59.5-47.4-85.7-10.1v133.6c0 41.5-63.3 41.8-63.3 0V208c0-40 63.1-41.6 63.1 0v3.4c9.9-14.4 41.8-37.3 78.6-37.3 35.3 0 57.7 16.4 66.7 43.8 13.9-21.8 45.8-43.8 82.6-43.8 44.3 0 70.7 23.4 70.7 72.7v145.3c.5 17.3-13.5 31.4-31.9 31.4 3.5.1-31.3 1.1-31.3-31.3zM3992 291.6c0-42.4-32.4-117.5-117.9-117.5-73.2 0-127.5 56.3-127.5 126 0 77.2 58.3 126.4 131.6 126.4 31.7 0 91.5-11.5 91.5-39.8 0-18.3-21.1-31.5-39.3-22.4-49.4 26.2-110.5 8.4-117.5-43.8h149.8c16.3 0 29.1-13.4 29.3-28.9zm-180.5-13.9c9.7-74.4 115.9-68.3 120.1 0h-120.1z"]
};
var faFontCase = {
  prefix: 'far',
  iconName: 'font-case',
  icon: [640, 512, [], "f866", "M624 160h-16a16 16 0 0 0-16 16v12.82C570 171.07 542.44 160 512 160a128 128 0 0 0-128 128v32a128 128 0 0 0 128 128c30.44 0 58-11.07 80-28.82V432a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V176a16 16 0 0 0-16-16zm-32 160a80 80 0 0 1-160 0v-32a80 80 0 0 1 160 0zM212.5 74.35a16 16 0 0 0-15-10.35h-43.03a16 16 0 0 0-15 10.35L1 426.35A16 16 0 0 0 16 448h17.14a16 16 0 0 0 15-10.35L88.22 336h175.56l40.11 101.65a16 16 0 0 0 15 10.35H336a16 16 0 0 0 15-21.65zM107.16 288L176 113.58 244.84 288z"]
};
var faFootballBall = {
  prefix: 'far',
  iconName: 'football-ball',
  icon: [496, 512, [], "f44e", "M481.4 60.9c-4.8-18.2-19.1-32.5-37.2-37.4-23.8-6.4-211.8-59.9-349.7 78.2C-28.2 224.6-2.4 386.9 14.6 451.6c4.8 18.2 19.1 31.6 37.2 36.5 23.8 6.4 211.7 60.9 349.7-77.3 122.7-122.9 96.9-285.3 79.9-349.9zM64.3 442.6c-1.6-.4-2.8-1.7-3.2-3.3-5.4-20.3-11.7-51.9-12.8-88.9l105.1 105.1c-36.8-1.2-68.5-7.4-89.1-12.9zm303.3-66.7c-41.2 41.3-91.6 66.6-150.1 75.9L52.3 286.6c8.2-50.2 29.6-103.9 76.1-150.5 41.2-41.3 91.6-66.6 150.1-75.9l165.1 165.1c-8.1 50.3-29.5 104-76 150.6zm-25-319.4c36.8 1.2 68.5 7.4 89.1 12.9 1.6.4 2.8 1.7 3.2 3.3 5.4 20.3 11.7 51.9 12.8 88.9L342.6 56.5zm-88.9 103.3l-11.3 11.3c-3.1 3.1-3.1 8.2 0 11.3l28.3 28.3-22.7 22.7-28.3-28.3c-3.1-3.1-8.2-3.1-11.3 0l-11.3 11.3c-3.1 3.1-3.1 8.2 0 11.3l28.3 28.3-22.6 22.6-28.3-28.3c-3.1-3.1-8.2-3.1-11.3 0l-11.3 11.3c-3.1 3.1-3.1 8.2 0 11.3l28.3 28.3-28.3 28.3c-3.1 3.1-3.1 8.2 0 11.3l11.3 11.3c3.1 3.1 8.2 3.1 11.3 0l28.3-28.3 28.3 28.3c3.1 3.1 8.2 3.1 11.3 0l11.3-11.3c3.1-3.1 3.1-8.2 0-11.3l-28.3-28.3 22.6-22.6 28.3 28.3c3.1 3.1 8.2 3.1 11.3 0l11.3-11.3c3.1-3.1 3.1-8.2 0-11.3L270.6 256l22.6-22.6 28.3 28.3c3.1 3.1 8.2 3.1 11.3 0l11.3-11.3c3.1-3.1 3.1-8.2 0-11.3l-28.3-28.3 28.3-28.3c3.1-3.1 3.1-8.2 0-11.3l-11.3-11.3c-3.1-3.1-8.2-3.1-11.3 0l-28.3 28.3-28.2-28.4c-3.2-3.1-8.2-3.1-11.3 0z"]
};
var faFootballHelmet = {
  prefix: 'far',
  iconName: 'football-helmet',
  icon: [512, 512, [], "f44f", "M479.6 320H355.5l-15.2-76 136.5-17.8c9-1.2 15.6-9.8 13.9-18.7C468.1 93.8 368.3 8 248 8 114.9 8 18.2 109.5 2.6 219.9-7.6 292 13.3 359 53.7 409.9c3.1 3.9 7.8 6.1 12.8 6.1H120c92.7 46.4 95 49.8 115 49.8 17 0 33.8-6.6 46.4-19.2 36.2-36.2 10.9-79.7 5-94.6h42.9l9.5 49.5c9.5 47.4 47.6 83.2 95.6 89.2 42.2 5.3 52.6 9.6 66.5-2.6 14.3-12.6 10.8-18.4 10.8-136.1-.1-17.7-14.4-32-32.1-32zm-206 0l-10.3-25.7c-7.8-19.4 4.9-40.9 25.6-43.6l19.6-2.6 14.4 71.9h-49.3zm9.1-116.9c-51.8 6.7-83.4 60.5-64 109l32.6 81.6c4.6 11.5-3.9 24.1-16.3 24.1-5.9 0 .2 2.1-103.7-49.8H82.4c-28-41.2-39.5-90.9-32.3-141.4C62.3 140.1 139.6 56 248 56c83.2 0 156.4 51.9 185.8 127.4l-151.1 19.7zm196.9 261l-41.3-5.2c-25.9-3.2-47.6-18.7-59.7-40.7h101.1l-.1 45.9zm0-80.1H368.3l-6.4-32h117.7v32zM176 312c-13.3 0-24 10.7-24 24s10.7 24 24 24 24-10.7 24-24-10.7-24-24-24z"]
};
var faForklift = {
  prefix: 'far',
  iconName: 'forklift',
  icon: [640, 512, [], "f47a", "M416 344.9V237.1c0-8.7-1.8-17.2-5.2-25.2L332.5 29.1C324.9 11.4 307.6 0 288.3 0H144c-26.5 0-48 21.5-48 48v112H48c-26.5 0-48 21.5-48 48v208c0 53 43 96 96 96s96-43 96-96h64c0 53 43 96 96 96s96-43 96-96c0-28.3-12.5-53.5-32-71.1zM144 48h144.3l78.4 182.8c.9 2 1.3 4.1 1.3 6.3v2.9H246.1c-8.9 0-17.7-3-24.7-8.5L144 170.6V48zM96 464c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm173.3-96h-90.6c-16.6-28.6-47.2-48-82.7-48-17.6 0-33.8 5.1-48 13.3V208h65.9l77.9 61.2c15.4 12.1 34.8 18.8 54.4 18.8H368v33.6c-5.2-.9-10.5-1.6-16-1.6-35.4 0-66.1 19.4-82.7 48zm82.7 96c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm272-64h-96V16c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v416c0 8.8 7.2 16 16 16h128c8.8 0 16-7.2 16-16v-16c0-8.8-7.2-16-16-16z"]
};
var faForward = {
  prefix: 'far',
  iconName: 'forward',
  icon: [512, 512, [], "f04e", "M244.5 230.8L52.5 71.4C31.9 54.3 0 68.6 0 96v320c0 27.4 31.9 41.8 52.5 24.6l192-160.6c15.3-12.8 15.3-36.4 0-49.2zM48 381.7V130.1l151 125.4L48 381.7zm452.5-150.9l-192-159.4C287.9 54.3 256 68.6 256 96v320c0 27.4 31.9 41.8 52.5 24.6l192-160.6c15.3-12.8 15.3-36.4 0-49.2zM304 381.7V130.1l151 125.4-151 126.2z"]
};
var faFragile = {
  prefix: 'far',
  iconName: 'fragile',
  icon: [288, 512, [], "f4bb", "M200 464h-32V349.4c72.7-12.4 126.3-79.5 119.4-156.7l-16-178.1C270.7 6.3 263.9 0 255.7 0H32.3c-8.2 0-15 6.3-15.7 14.6L.6 192.7C-6.3 269.9 47.3 337 120 349.4V464H88.1c-37.2 0-50 48-32 48h175.8c18.1 0 5.2-48-31.9-48zM72.6 272c-18.5-20.6-27.4-47.3-24.9-75L61.1 48h61.7l26.6 38L80 130l98.7 94-40.1-82L208 98l-24.8-50H227l13.3 149c2.5 27.8-6.4 54.4-24.9 75s-43.9 32-71.4 32-52.9-11.3-71.4-32z"]
};
var faFrenchFries = {
  prefix: 'far',
  iconName: 'french-fries',
  icon: [512, 512, [], "f803", "M351.54 228.14c.4-1.78 1.46-3.22 2.06-4.91l30.15-172.46a16 16 0 0 0-20.34-18.08l-34.28 10.25c-4.24 1.27-7.17 4.51-9.13 8.33v207.27c17.55-8.38 29.15-19.54 31.54-30.4zM288 268.78V32a16 16 0 0 0-8.84-14.31l-32-16A16 16 0 0 0 224 16v252.78a160.62 160.62 0 0 0 64 0zM431.45 192l16.3-93.23a16 16 0 0 0-20.34-18.08l-17.31 5.17-18.75 107.26c2.24-.32 4.33-1.12 6.63-1.12zm-350.9 0H114c3.6 0 7 1 10.35 1.75l-20-107.16-19.74-5.9a16 16 0 0 0-20.36 18.08zm84.62 45.79c5.3 7.58 14.49 14.86 26.83 20.75V33.17l-3.76-20.1a16 16 0 0 0-25.39-9.81l-28.51 21.62a16 16 0 0 0-6.07 15.69zM432 224h-34c-6.92 0-13.7 4.27-15.19 11-8.6 39-62.09 69-126.79 69s-118.19-30-126.79-69c-1.49-6.76-8.27-11-15.19-11H80a16 16 0 0 0-15.62 19.47l54.1 243.47A32 32 0 0 0 149.73 512h212.54a32 32 0 0 0 31.24-25.06l54.1-243.47A16 16 0 0 0 432 224zm-82.56 240H162.56l-33.3-149.86C161.08 337.86 205.8 352 256 352s94.92-14.14 126.74-37.86z"]
};
var faFrog = {
  prefix: 'far',
  iconName: 'frog',
  icon: [576, 512, [], "f52e", "M576 189.94c0-21.4-11.72-40.95-30.48-51.23-28.68-15.71-65.94-29.69-85.51-36.62C448.64 61.74 411.98 32 368 32c-42.97 0-78.91 28.42-91.16 67.35C120.27 120.52-.49 254.49 0 416.98.11 451.89 29.08 480 64 480h304c8.84 0 16-7.16 16-16 0-17.67-14.33-32-32-32h-29.74l18.87-25.48c9.29-13.93 14.7-29.24 17.15-44.82L469.62 480H560c8.84 0 16-7.16 16-16 0-17.67-14.33-32-32-32h-53.63l-98.52-104.68 154.44-86.65A58.183 58.183 0 0 0 576 189.94zm-53.19 8.87l-174.79 96.05c-7.56-15.39-18.32-29.45-32.92-40.4-39.66-29.72-95-29.75-134.72 0l-34.78 26.09c-10.59 7.95-12.75 23-4.78 33.61 7.97 10.59 23 12.77 33.59 4.8l34.78-26.09c22.72-17.08 54.44-17.02 77.09 0 27.28 20.45 33.81 58.67 15.59 86.06L262.56 432H64c-8.65 0-15.97-6.95-16-15.17-.41-135.69 100.74-251.73 235.27-269.92l30.21-4.08 9.15-29.08C328.98 93.56 347.21 80 368 80c21.15 0 39.99 14.43 45.81 35.1l6.74 23.93 23.44 8.3c18.33 6.49 52.91 19.47 78.47 33.47 3.47 1.9 5.54 5.32 5.54 9.14 0 3.67-1.99 7.07-5.19 8.87zM368 120c-13.25 0-24 10.74-24 24 0 13.25 10.75 24 24 24s24-10.75 24-24c0-13.26-10.75-24-24-24z"]
};
var faFrostyHead = {
  prefix: 'far',
  iconName: 'frosty-head',
  icon: [384, 512, [], "f79b", "M368 240h-32V32c0-17.7-14.3-32-32-32H80C62.3 0 48 14.3 48 32v208H16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h13.1C20.9 308.4 16 330.4 16 353.7c0 62.8 32.8 117.5 82 148.8 10.7 6.8 23.6 9.5 36.2 9.5h41c-8.6-12.5-19.8-28.1-31.1-48h-9.9c-5.4 0-8.9-1-10.4-2C86.3 438.2 64 397.7 64 353.7c0-24.3 7.4-46.4 19.2-65.7H302c7.6 12.7 13.1 26.6 15.8 41.3 9.2 50.8-11.2 100.6-53.1 129.8-4.7 3.3-10.1 5-15.7 5h-9.2c-11.3 20-22.4 35.5-31.1 48H249c15.4 0 30.5-4.8 43.1-13.6 53.9-37.6 86.1-104.1 72.8-177.7-2-11.4-5.6-22.2-9.8-32.7H368c8.8 0 16-7.2 16-16v-16c0-8.9-7.2-16.1-16-16.1zm-80 0H96v-64h192v64zm0-112H96V48h192v80zm-96 240c-20.6 0-37.3 16.7-37.3 37.3C154.7 426 192 480 192 480s37.3-54 37.3-74.7c0-20.6-16.7-37.3-37.3-37.3zm-82.7-26.7c0 11.8 9.6 21.3 21.3 21.3 11.8 0 21.3-9.6 21.3-21.3 0-11.8-9.6-21.3-21.3-21.3-11.7 0-21.3 9.6-21.3 21.3zm165.4 0c0-11.8-9.6-21.3-21.3-21.3-11.8 0-21.3 9.6-21.3 21.3 0 11.8 9.6 21.3 21.3 21.3 11.7.1 21.3-9.5 21.3-21.3z"]
};
var faFrown = {
  prefix: 'far',
  iconName: 'frown',
  icon: [496, 512, [], "f119", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-80-216c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160-64c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-80 128c-40.2 0-78 17.7-103.8 48.6-8.5 10.2-7.1 25.3 3.1 33.8 10.2 8.4 25.3 7.1 33.8-3.1 16.6-19.9 41-31.4 66.9-31.4s50.3 11.4 66.9 31.4c8.1 9.7 23.1 11.9 33.8 3.1 10.2-8.5 11.5-23.6 3.1-33.8C326 321.7 288.2 304 248 304z"]
};
var faFrownOpen = {
  prefix: 'far',
  iconName: 'frown-open',
  icon: [496, 512, [], "f57a", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm-48-248c0-17.7-14.3-32-32-32s-32 14.3-32 32 14.3 32 32 32 32-14.3 32-32zm128-32c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm-80 112c-35.6 0-88.8 21.3-95.8 61.2-2 11.8 9 21.5 20.5 18.1 31.2-9.6 59.4-15.3 75.3-15.3s44.1 5.7 75.3 15.3c11.4 3.5 22.5-6.3 20.5-18.1-7-39.9-60.2-61.2-95.8-61.2z"]
};
var faFunction = {
  prefix: 'far',
  iconName: 'function',
  icon: [640, 512, [], "f661", "M224 48c0-8.84-7.16-16-16-16h-48c-48.6 0-88 39.4-88 88v48H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h56v144c0 22.09-17.91 40-40 40H16c-8.84 0-16 7.16-16 16v16c0 8.84 7.16 16 16 16h16c48.6 0 88-39.4 88-88V216h56c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16h-56v-48c0-22.09 17.91-40 40-40h48c8.84 0 16-7.16 16-16V48zm93.43 60.92l-12.8-9.63c-7.22-5.44-17.81-4.01-22.92 3.41C244.39 157 224 222.17 224 288c0 65.85 20.39 131.02 57.71 185.3 5.11 7.43 15.7 8.85 22.92 3.41l12.8-9.63c6.84-5.14 8.09-14.54 3.28-21.59C289.2 399.27 272 343.92 272 288c0-55.91 17.2-111.26 48.71-157.5 4.8-7.05 3.55-16.44-3.28-21.58zm264.86-6.22c-5.11-7.43-15.7-8.85-22.92-3.41l-12.8 9.63c-6.84 5.14-8.09 14.54-3.28 21.59C574.8 176.73 592 232.08 592 288c0 55.91-17.2 111.26-48.71 157.5-4.8 7.05-3.55 16.44 3.28 21.59l12.8 9.63c7.22 5.44 17.81 4.02 22.92-3.41C619.61 419 640 353.83 640 288c0-65.85-20.39-131.02-57.71-185.3zm-74.84 120.84l-10.99-10.99c-6.07-6.07-15.91-6.07-21.98 0L432 255.03l-42.47-42.47c-6.07-6.07-15.91-6.07-21.98 0l-10.99 10.99c-6.07 6.07-6.07 15.91 0 21.98L399.03 288l-42.47 42.47c-6.07 6.07-6.07 15.91 0 21.98l10.99 10.99c6.07 6.07 15.91 6.07 21.98 0L432 320.97l42.47 42.47c6.07 6.07 15.91 6.07 21.98 0l10.99-10.99c6.07-6.07 6.07-15.91 0-21.98L464.97 288l42.47-42.47c6.08-6.07 6.08-15.92.01-21.99z"]
};
var faFunnelDollar = {
  prefix: 'far',
  iconName: 'funnel-dollar',
  icon: [640, 512, [], "f662", "M471.61 160.38l94.5-103.14C587.24 36.12 572.27 0 542.4 0H33.6C3.73 0-11.24 36.12 9.89 57.25L192 256v135.91c0 15.11 7.11 29.33 19.2 38.4l95.99 72c8.91 6.68 18.89 9.7 28.63 9.7 16.62 0 32.46-8.82 41.17-23.14C402.66 503.51 432.31 512 464 512c97.2 0 176-78.8 176-176 0-94.63-74.74-171.6-168.39-175.62zM335.99 463.91l-95.99-72V237.33L66.52 48h442.96L393.15 174.96C331.26 202.23 288 264.02 288 336c0 46.7 18.31 89.03 47.99 120.53v7.38zM464 464c-70.58 0-128-57.42-128-128s57.42-128 128-128 128 57.42 128 128-57.42 128-128 128zm27.09-136.58l-45-13.5c-5.16-1.55-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11c4.56 0 8.96 1.29 12.82 3.72 3.24 2.03 7.36 1.91 10.13-.73l11.75-11.21c3.53-3.37 3.33-9.21-.57-12.14-9.1-6.83-20.08-10.77-31.37-11.35V240c0-4.42-3.58-8-8-8h-16c-4.42 0-8 3.58-8 8v16.12c-23.62.63-42.67 20.55-42.67 45.07 0 19.97 12.98 37.81 31.58 43.39l45 13.5c5.16 1.55 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.11c-4.56 0-8.96-1.29-12.82-3.72-3.24-2.03-7.36-1.91-10.13.73l-11.75 11.21c-3.53 3.37-3.33 9.21.57 12.14 9.1 6.83 20.08 10.77 31.37 11.35V432c0 4.42 3.58 8 8 8h16c4.42 0 8-3.58 8-8v-16.12c23.62-.63 42.67-20.54 42.67-45.07 0-19.97-12.98-37.81-31.58-43.39z"]
};
var faFutbol = {
  prefix: 'far',
  iconName: 'futbol',
  icon: [496, 512, [], "f1e3", "M483.8 179.4C449.8 74.6 352.6 8 248.1 8c-25.4 0-51.2 3.9-76.7 12.2C41.2 62.5-30.1 202.4 12.2 332.6 46.2 437.4 143.4 504 247.9 504c25.4 0 51.2-3.9 76.7-12.2 130.2-42.3 201.5-182.2 159.2-312.4zm-74.5 193.7l-52.2 6.4-43.7-60.9 24.4-75.2 71.1-22.1 38.9 36.4c-.2 30.7-7.4 61.1-21.7 89.2-4.7 9.3-10.7 17.8-16.8 26.2zm0-235.4l-10.4 53.1-70.7 22-64.2-46.5V92.5l47.4-26.2c39.2 13 73.4 38 97.9 71.4zM184.9 66.4L232 92.5v73.8l-64.2 46.5-70.6-22-10.1-52.5c24.3-33.4 57.9-58.6 97.8-71.9zM139 379.5L85.9 373c-14.4-20.1-37.3-59.6-37.8-115.3l39-36.4 71.1 22.2 24.3 74.3-43.5 61.7zm48.2 67l-22.4-48.1 43.6-61.7H287l44.3 61.7-22.4 48.1c-6.2 1.8-57.6 20.4-121.7 0z"]
};
var faGameBoard = {
  prefix: 'far',
  iconName: 'game-board',
  icon: [512, 512, [], "f867", "M480 0H32A32 32 0 0 0 0 32v448a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-16 464H48V48h416zm-32-32v-88h-88v88zm0-176v-88h-88v88zM80 80v88h88V80zm264 0h-88v88h88zM168 432h88v-88h-88zm88-264h-88v88h88zm0 176h88v-88h-88zm-88-88H80v88h88z"]
};
var faGameBoardAlt = {
  prefix: 'far',
  iconName: 'game-board-alt',
  icon: [512, 512, [], "f868", "M480 0H32A32 32 0 0 0 0 32v448a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-16 464H48V48h416zm-48-48V256H256v160zM256 96H96v160h160z"]
};
var faGamepad = {
  prefix: 'far',
  iconName: 'gamepad',
  icon: [640, 512, [], "f11b", "M256 240v32c0 4.4-3.6 8-8 8h-48v48c0 4.4-3.6 8-8 8h-32c-4.4 0-8-3.6-8-8v-48h-48c-4.4 0-8-3.6-8-8v-32c0-4.4 3.6-8 8-8h48v-48c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v48h48c4.4 0 8 3.6 8 8zm240-64c-22.1 0-40 17.9-40 40s17.9 40 40 40 40-17.9 40-40-17.9-40-40-40zm-64 80c-22.1 0-40 17.9-40 40s17.9 40 40 40 40-17.9 40-40-17.9-40-40-40zm32-128H176c-70.8 0-128 57.3-128 128 0 70.8 57.3 128 128 128 56.2 0 86.1-33.3 101.7-48h84.6c16.2 15.3 45.9 48 101.7 48 70.8 0 128-57.3 128-128 0-70.8-57.3-128-128-128m0-48c97.2 0 176 78.8 176 176s-78.8 176-176 176c-46.8 0-89.3-18.2-120.8-48h-46.4c-31.5 29.8-74 48-120.8 48C78.8 432 0 353.2 0 256S78.8 80 176 80h288z"]
};
var faGasPump = {
  prefix: 'far',
  iconName: 'gas-pump',
  icon: [512, 512, [], "f52f", "M493.3 107.3l-86.6-86.6c-3.1-3.1-8.2-3.1-11.3 0l-22.6 22.6c-3.1 3.1-3.1 8.2 0 11.3L416 97.9V160c0 28.1 20.9 51.3 48 55.2V376c0 13.2-10.8 24-24 24s-24-10.8-24-24v-32c0-48.6-39.4-88-88-88h-8V48c0-26.5-21.5-48-48-48H80C53.5 0 32 21.5 32 48v416H8c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h336c4.4 0 8-3.6 8-8v-32c0-4.4-3.6-8-8-8h-24V304h8c22.1 0 40 17.9 40 40v27.8c0 37.7 27 72 64.5 75.9 43 4.3 79.5-29.5 79.5-71.7V152.6c0-17-6.7-33.3-18.7-45.3zM272 464H80V240h192v224zm0-272H80V48h192v144z"]
};
var faGasPumpSlash = {
  prefix: 'far',
  iconName: 'gas-pump-slash',
  icon: [640, 512, [], "f5f4", "M633.99 471.02L36 3.51C29.1-2.01 19.03-.9 13.51 6l-10 12.49C-2.02 25.39-.9 35.46 6 40.98l598 467.51c6.9 5.52 16.96 4.4 22.49-2.49l10-12.49c5.52-6.9 4.41-16.97-2.5-22.49zM480 97.94V160c0 28.14 20.93 51.27 48 55.19v112.04l48 37.53V152.57c0-16.97-6.74-33.25-18.75-45.26l-86.63-86.63c-3.12-3.12-8.19-3.12-11.31 0L436.68 43.3c-3.12 3.12-3.12 8.19 0 11.31L480 97.94zM336 48v129.12l48 37.53V48c0-26.51-21.49-48-48-48H144c-9.28 0-17.86 2.75-25.21 7.31L170.84 48H336zm72 416h-24v-66.58l-48-37.53V464H144V209.79l-48-37.53V464H72c-4.42 0-8 3.58-8 8v32c0 4.42 3.58 8 8 8h336c4.42 0 8-3.58 8-8v-32c0-4.42-3.58-8-8-8z"]
};
var faGavel = {
  prefix: 'far',
  iconName: 'gavel',
  icon: [512, 512, [], "f0e3", "M497.965 176.618l-23.185-23.185c-13.611-13.61-33.433-17.321-50.434-11.133l-54.624-54.624c6.189-16.998 2.479-36.821-11.133-50.433l-23.185-23.174c-18.757-18.757-49.122-18.76-67.882 0L163.914 117.667c-18.715 18.715-18.715 49.167 0 67.883l23.184 23.184c13.613 13.613 33.433 17.326 50.434 11.133l10.342 10.342-56.543 56.52c-22.021-22.02-51.866-19.249-69.498-1.616L14.069 392.908c-18.757 18.757-18.76 49.122 0 67.882l37.163 37.174c18.714 18.714 49.165 18.715 67.882 0l107.773-107.796c17.412-17.41 20.652-47.231-1.616-69.499l56.543-56.519 10.341 10.341c-6.189 16.998-2.479 36.821 11.134 50.434l25.417 25.417c17.484 17.484 45.932 17.485 63.417 0L497.965 244.5c18.713-18.715 18.713-49.167 0-67.882zM85.195 464.043l-.021-.021L48 426.849l107.773-107.795 37.173 37.173L85.195 464.043zm275.219-149.875l-23.184-23.184 14.793-14.793L235.832 160l-14.792 14.792-23.184-23.184L301.465 48l23.184 23.184L307.832 88l116.191 116.191 16.816-16.816 23.184 23.184-103.609 103.609z"]
};
var faGem = {
  prefix: 'far',
  iconName: 'gem',
  icon: [576, 512, [], "f3a5", "M464 0H112c-4 0-7.8 2-10 5.4L2 152.6c-2.9 4.4-2.6 10.2.7 14.2l276 340.8c4.8 5.9 13.8 5.9 18.6 0l276-340.8c3.3-4.1 3.6-9.8.7-14.2L474.1 5.4C471.8 2 468.1 0 464 0zm-19.3 48l63.3 96h-68.4l-51.7-96h56.8zm-202.1 0h90.7l51.7 96H191l51.6-96zm-111.3 0h56.8l-51.7 96H68l63.3-96zm-43 144h51.4L208 352 88.3 192zm102.9 0h193.6L288 435.3 191.2 192zM368 352l68.2-160h51.4L368 352z"]
};
var faGenderless = {
  prefix: 'far',
  iconName: 'genderless',
  icon: [288, 512, [], "f22d", "M144 160c52.9 0 96 43.1 96 96s-43.1 96-96 96-96-43.1-96-96 43.1-96 96-96m0-48C64.5 112 0 176.5 0 256s64.5 144 144 144 144-64.5 144-144-64.5-144-144-144z"]
};
var faGhost = {
  prefix: 'far',
  iconName: 'ghost',
  icon: [384, 512, [], "f6e2", "M192 0c-1.96 0-3.93.03-5.91.09C81.01 3.24 0 94.92 0 200.05v263.92C0 473.61 7.89 480 16.12 480c3.93 0 7.94-1.46 11.2-4.72l24.92-18.53c2.86-2.12 6.21-3.16 9.54-3.16 4.43 0 8.82 1.83 11.97 5.38l42.95 48.35c3.12 3.12 7.22 4.69 11.31 4.69s8.19-1.56 11.31-4.69l40.72-45.85c3.18-3.58 7.57-5.38 11.96-5.38s8.78 1.79 11.96 5.38l40.72 45.85c3.12 3.12 7.22 4.69 11.31 4.69s8.19-1.56 11.31-4.69l42.95-48.35a15.994 15.994 0 0 1 21.51-2.22l24.92 18.53c3.26 3.26 7.27 4.72 11.2 4.72 8.22 0 16.12-6.39 16.12-16.03V192C384 85.96 298.04 0 192 0zm144 407.07c-4.48-.98-9.09-1.48-13.77-1.48-18.28 0-35.72 7.83-47.86 21.5L256 447.77l-16.15-18.18c-12.13-13.66-29.58-21.5-47.85-21.5s-35.71 7.84-47.85 21.5L128 447.77l-18.38-20.69a64.069 64.069 0 0 0-47.86-21.49c-4.68 0-9.29.5-13.77 1.48V200.05c0-81.49 62.6-149.67 139.53-151.98L192 48c79.4 0 144 64.6 144 144v215.07zM128 160c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32zm128 0c-17.67 0-32 14.33-32 32s14.33 32 32 32 32-14.33 32-32-14.33-32-32-32z"]
};
var faGift = {
  prefix: 'far',
  iconName: 'gift',
  icon: [512, 512, [], "f06b", "M464 144h-26.1c6.2-12.1 10.1-25.5 10.1-40 0-48.5-39.5-88-88-88-41.6 0-68.5 21.3-103 68.3-34.5-47-61.4-68.3-103-68.3-48.5 0-88 39.5-88 88 0 14.5 3.8 27.9 10.1 40H48c-26.5 0-48 21.5-48 48v128c0 8.8 7.2 16 16 16h16v107.4c0 29 23.6 52.6 52.6 52.6h342.8c29 0 52.6-23.6 52.6-52.6V336h16c8.8 0 16-7.2 16-16V192c0-26.5-21.5-48-48-48zM232 448H84.6c-2.5 0-4.6-2-4.6-4.6V336h112v-48H48v-96h184v256zm-78.1-304c-22.1 0-40-17.9-40-40s17.9-40 40-40c22 0 37.5 7.6 84.1 77l2 3h-86.1zm122-3C322.5 71.6 338 64 360 64c22.1 0 40 17.9 40 40s-17.9 40-40 40h-86.1l2-3zM464 288H320v48h112v107.4c0 2.5-2 4.6-4.6 4.6H280V192h184v96z"]
};
var faGiftCard = {
  prefix: 'far',
  iconName: 'gift-card',
  icon: [576, 512, [], "f663", "M528 128h-58.07c6.22-12.06 10.07-25.52 10.07-40 0-48.52-39.48-88-88-88-41.6 0-68.51 21.34-103.04 68.33C254.44 21.33 227.53 0 185.93 0c-48.52 0-88 39.48-88 88 0 14.48 3.85 27.94 10.07 40H48c-26.51 0-48 21.49-48 48v288c0 26.51 21.49 48 48 48h480c26.51 0 48-21.49 48-48V176c0-26.51-21.49-48-48-48zM392 48c22.06 0 40 17.94 40 40 0 22.05-17.94 40-40 40h-86.07c51.36-76.47 65.72-80 86.07-80zM145.93 88c0-22.06 17.94-40 40-40 19.94 0 34.58 3.27 86.07 80h-86.07c-22.06 0-40-17.95-40-40zm76.13 88l-51.72 51.72c-6.25 6.25-6.25 16.38 0 22.63l11.31 11.31c6.25 6.25 16.38 6.25 22.63 0L288 177.94l83.72 83.72c6.25 6.25 16.38 6.25 22.63 0l11.31-11.31c6.25-6.25 6.25-16.38 0-22.63L353.94 176H528v144H48V176h174.06zM48 464v-80h480v80H48z"]
};
var faGifts = {
  prefix: 'far',
  iconName: 'gifts',
  icon: [640, 512, [], "f79c", "M608 224h-20.4c2.6-7.6 4.4-15.5 4.4-23.8 0-35.5-27-72.2-72.1-72.2-48.1 0-75.9 47.7-87.9 75.3-11.4-26-36.9-69.4-80-74.3v-1c0-17.7-14.3-32-32-32h-61.4l30.7-22c7.2-5.1 8.9-15.1 3.7-22.3l-9.3-13c-5.1-7.2-15.1-8.9-22.3-3.7l-32 22.9 11.5-30.6c3.1-8.3-1.1-17.5-9.4-20.6l-15-5.6c-8.3-3.1-17.5 1.1-20.6 9.4l-19.9 53-19.9-53.1C153 2.1 143.8-2.1 135.5 1l-15 5.6c-8.3 3.1-12.5 12.3-9.4 20.6l11.5 30.6-32-22.8c-7.2-5.1-17.2-3.5-22.3 3.7l-9.3 13c-5.1 7.2-3.5 17.2 3.7 22.3l30.7 22H32c-17.7 0-32 14.3-32 32v352c0 17.7 14.3 32 32 32h576c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32zm-88.1-48c17.7 0 24.1 14.5 24.1 24.2 0 5.1-1.5 12.6-8.8 19-2.1 1.8-4.5 3.4-7.2 4.8h-52.6c8.8-20.3 25.9-48 44.5-48zm-175.8 0c18.7 0 35.6 27.4 44.5 48H336c-2.7-1.4-5.1-3-7.2-4.8-7.3-6.4-8.8-13.8-8.8-19 0-9.7 6.4-24.2 24.1-24.2zM224 256v208H48V144h250.7c-17 14-26.7 35.2-26.7 56.2 0 8.3 1.7 16.2 4.4 23.8H256c-17.7 0-32 14.3-32 32zm184 208H272v-72h136v72zm0-120H272v-72h136v72zm23.3-120l.7-.2.7.2h-1.4zM592 464H456v-72h136v72zm0-120H456v-72h136v72z"]
};
var faGingerbreadMan = {
  prefix: 'far',
  iconName: 'gingerbread-man',
  icon: [448, 512, [], "f79d", "M192 96c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm32 240c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm222.7-109.4c-7.6-46.7-48.5-81-98-82.5.9-5.9 1.3-12 1.3-18.1 0-33.7-13.1-65.3-36.9-89.1C289.3 13.1 257.7 0 224 0s-65.3 13.1-89.1 36.9C111.1 60.7 98 92.3 98 126c0 6.1.4 12.1 1.3 18.1-49.4 1.5-90.4 35.8-98 82.5-4.8 29.2 3.4 58.8 22.5 81.2 11.3 13.3 25.7 23.2 41.7 29.1l-7 8.5c-18 21.6-26.6 50.2-23.6 78.5 2.9 27 15.9 50.9 36.7 67.1 17.4 13.5 39.2 21 61.4 21 29.8 0 57.8-13.1 76.8-36l14.2-17 14.2 17c19.1 22.9 47.1 36 76.8 36 22.2 0 44-7.5 61.5-21.1 20.8-16.2 33.8-40 36.7-67.1 3-28.3-5.6-56.9-23.6-78.5l-7-8.5c16-5.9 30.3-15.8 41.7-29.1 18.9-22.3 27.1-51.9 22.4-81.1zM348 295h-31.2c-8.2 0-14.8 6.6-14.8 14.8 0 3.5 1.2 6.8 3.4 9.5l47.3 56.7c18.9 22.7 17.5 58.8-5.8 77-25.5 19.9-56.9 10.3-71.9-7.7L244 408c-5.2-6.2-12.6-9.4-20-9.4s-14.8 3.1-20 9.4l-31.1 37.3c-15 18.1-46.4 27.6-71.9 7.7-23.3-18.2-24.7-54.3-5.8-77l47.3-56.7c2.2-2.7 3.4-6 3.4-9.5 0-8.2-6.6-14.8-14.8-14.8H100c-66.9 0-72-103 2.8-103h60.4c5.8 0 8.5-7.9 4.5-12.1-13.4-14-21.7-33-21.7-53.9 0-43.1 34.9-78 78-78s78 34.9 78 78c0 20.9-8.3 39.9-21.7 53.9-4 4.2-1.4 12.1 4.5 12.1h60.4c74.8 0 69.8 103 2.8 103zm-124-23c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm32-176c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16zm-32 112c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.2-16-16-16z"]
};
var faGlass = {
  prefix: 'far',
  iconName: 'glass',
  icon: [384, 512, [], "f804", "M352 0H32A32 32 0 0 0 .06 34l32 448A32 32 0 0 0 64 512h256a32 32 0 0 0 31.94-30l32-448A32 32 0 0 0 352 0zm-17.19 48l-8 112H57.18l-8-112zM305.1 464H78.9L60.61 208h262.77z"]
};
var faGlassChampagne = {
  prefix: 'far',
  iconName: 'glass-champagne',
  icon: [256, 512, [], "f79e", "M200 464h-48V349.5c65-12 111.6-71 103-137.1l-27-185C225.7 11.7 212.2 0 196.3 0H59.7C43.8 0 30.3 11.7 28 27.4L1 212.3c-8.7 66.2 38 125.2 103 137.1V464H56c-22.1 0-40 17.9-40 40 0 4.4 3.6 8 8 8h208c4.4 0 8-3.6 8-8 0-22.1-17.9-40-40-40zM73.5 48h109l11.7 80H61.8l11.7-80zm-6.9 228.6c-14.3-16.3-20.7-37-18-57.4l6.3-43.3h146.3l6.2 42.6c2.8 21.1-3.6 41.7-17.9 58.1C174.2 294 151.8 304 128 304s-46.2-10-61.4-27.4z"]
};
var faGlassCheers = {
  prefix: 'far',
  iconName: 'glass-cheers',
  icon: [640, 512, [], "f79f", "M587.6 414.1l-29.8 11.7-40.5-103c50.9-33.5 70.1-100.2 40.2-154.3l-84.1-152C467.6 6.1 456.8 0 445.4 0c-3.9 0-7.9.7-11.7 2.2L320 46.9 206.3 2.2C202.5.7 198.5 0 194.6 0c-11.3 0-22.2 6.1-28 16.5l-84.1 152c-29.9 54.1-10.7 120.8 40.2 154.3l-40.5 103-29.8-11.7c-20.6-8.1-43.8 2-51.9 22.6-1.6 4.1.4 8.8 4.5 10.4l163.8 64.4c4.1 1.6 8.8-.4 10.4-4.5 8.1-20.6-2-43.8-22.6-51.9l-29.8-11.7L167.1 341c8 1.6 16 2.5 23.8 2.5 52.6 0 100.9-34.2 114.2-87.4l14.8-59.6 14.8 59.6c13.2 53.2 61.5 87.4 114.2 87.4 7.9 0 15.9-.9 23.8-2.5l40.2 102.3-29.8 11.7c-20.6 8.1-30.7 31.3-22.6 51.9 1.6 4.1 6.3 6.1 10.4 4.5l164-64.4c4.1-1.6 6.1-6.3 4.5-10.4-8-20.5-31.3-30.6-51.8-22.5zm-329-169.6c-7.5 30-35.3 51-67.6 51-9.4 0-18.7-1.8-27.8-5.3-20.1-7.9-35.7-23.8-42.8-43.5-6.7-18.5-5.2-38 4.1-54.8l25.1-45.3 121.5 47.8-12.5 50.1zm24.2-97.2L173 104.1 201.8 52l95.4 37.5-14.4 57.8zm74.4 0l-14.4-57.7L438.2 52l28.8 52.1-109.8 43.2zm119.6 142.8c-9 3.5-18.3 5.3-27.8 5.3-32.3 0-60.1-21-67.6-51l-12.5-50.3 121.5-47.8 25.1 45.3c9.3 16.8 10.8 36.3 4.1 54.8-7.1 19.9-22.7 35.8-42.8 43.7z"]
};
var faGlassCitrus = {
  prefix: 'far',
  iconName: 'glass-citrus',
  icon: [512, 512, [], "f869", "M368 0c-62.61 0-115.35 40.2-135.18 96h52.54C302 67.45 332.63 48 368 48a96.11 96.11 0 0 1 96 96c0 50.07-38.67 90.84-87.63 95.15l-4.84 48.49C449.39 285.73 512 222.32 512 144A144 144 0 0 0 368 0zm-48 128H32