import React from 'react';
import { connect } from 'react-redux';
import { changeDirection } from '../../redux/actions';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

const JourneyTypeSelect = ({ depart, changeDirection }) => {
    const leave = depart === 'DUNDEE' ? 'Dundee' : 'Edinburgh Airport';
    const arrive = depart === 'DUNDEE' ? 'Edinburgh Airport' : 'Dundee';
    return (
        <div className="direction-select">
            <div>{leave}</div>
            <button onClick={changeDirection}>
                <FontAwesomeIcon icon={['far', 'exchange-alt']} rotation={90} />
            </button>
            <div>{arrive}</div>
        </div>
    );
};

const mapStateToProps = state => {
    return { depart: state.cart.depart };
};

export default connect(
    mapStateToProps,
    { changeDirection }
)(JourneyTypeSelect);
