<?php

namespace XploreBooking\Controller;

class JourneyController
{

    const SEATS = 50;

    public function __construct()
    {
        $this->registerActions();
    }

    private function registerActions()
    {
        add_action('rest_api_init', function () {
            register_rest_route('xplore-booking/v1', '/get-all-journey-times/', [
                'methods' => 'GET',
                'callback' => [$this, 'getAllJourneyTimes'],
            ]);
        });

        add_action('rest_api_init', function () {
            register_rest_route('xplore-booking/v1', '/return-available-journeys/', [
                'methods' => 'GET',
                'callback' => [$this, 'returnAvailableJourneys'],
            ]);
        });

    }

    public static function returnAvailableJourneys($request)
    {
        $departLocation = $request['depart'];
        $departureDate = $request['departFormatted'];
        $returnDate = $request['returnFormatted'];
        $journeyType = $request['journeyType'];
        $seats = $request['totalSeats'];

        if ($departLocation == 'DUNDEE') {
            $direction = 'dundee';
            $return = 'edinburgh';
        } else {
            $direction = 'edinburgh';
            $return = 'dundee';
        }

        /*** TODO ADD CHECK IF THERE ARE ENOUGH SEATS LEFT ***/
        $outboundDates['outbound'] = self::returnComparedDates($departureDate, $direction);

        if ($journeyType == 'RETURN') {
            $inboundDates['inbound'] = self::returnComparedDates($returnDate, $return);
            $allDates = array_merge($inboundDates, $outboundDates);
        } else {
            $allDates = $outboundDates;
        }
        return json_encode($allDates);

    }

    public static function returnComparedDates($date, $direction)
    {
        $queryDate = date('Ymd', strtotime($date));

        $args = [
            'post_type' => 'journey-date',
            'posts-per_page' => -1,
            'meta_query' => [
                [
                    'key' => 'date',
                    'compare' => '=',
                    'value' => $queryDate,
                ],
            ],
        ];

        $journeys = get_posts($args);
        $departureDates = [];

        $expectedJourneys = self::returnAvailableTimes($date, $direction);
        if ($journeys) {
            foreach ($journeys as $journey) {
                if (explode('-', $journey->post_name)[0] === $direction) {
                    $departureDates[$journey->post_name] = [
                        'seats' => get_field('seats', $journey->ID),
                    ];
                }
            };
        }

        $combinedJourneys = array_replace_recursive($expectedJourneys, $departureDates);

        return $combinedJourneys;

    }

    public static function returnAvailableTimes($departureDate, $direction)
    {
        $journeyData = [];

        $args = [
            'post_type' => 'journey',
            'posts_per_page' => -1,
        ];
        $journeys = new \WP_Query($args);

        while ($journeys->have_posts()) {
            $journeys->the_post();
            if (explode('-', get_post_field('post_name', get_post()))[0] === $direction) {
                $journeyData[get_post_field('post_name', get_post()) . '-' . $departureDate] = [
                    'id' => get_the_id(),
                    'title' => get_the_title(),
                    'departure_time' => get_field('departure_time'),
                    'arrival_time' => get_field('arrival_time'),
                    'surcharge' => get_field('surcharge'),
                    'seats' => get_field('seats'),
                ];
            }
        }

        return $journeyData;
    }

    public static function getAllJourneyTimes()
    {
        $journeyData = [];

        $args = [
            'post_type' => 'journey',
            'posts-per_page' => -1,
        ];
        $journeys = new \WP_Query($args);

        while ($journeys->have_posts()) {
            $journeys->the_post();
            $journeyData[] = [
                'id' => get_the_id(),
                'title' => get_the_title(),
                'slug' => get_post_field('post_name', get_post()),
                'departure_time' => get_field('departure_time'),
                'arrival_time' => get_field('arrival_time'),
                'surcharge' => get_field('surcharge'),
            ];
        }

        return json_encode($journeyData);
    }


    public static function journeyTimes()
    {

        /*** TIMES FROM DUNDEE ***/
        $outwardJourneys = [
            'dundee-to-edinburgh-0230' => [
                'post_title' => 'Dundee to Edinburgh 02:30',
                'departure_time' => '02:30',
                'arrival_time' => '03:50',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-0400' => [
                'post_title' => 'Dundee to Edinburgh 04:00',
                'departure_time' => '04:00',
                'arrival_time' => '05:20',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-0530' => [
                'post_title' => 'Dundee to Edinburgh 05:30',
                'departure_time' => '05:30',
                'arrival_time' => '06:50',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-0700' => [
                'post_title' => 'Dundee to Edinburgh 07:00',
                'departure_time' => '07:00',
                'arrival_time' => '08:20',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-0830' => [
                'post_title' => 'Dundee to Edinburgh 08:30',
                'departure_time' => '08:30',
                'arrival_time' => '09:50',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-1000' => [
                'post_title' => 'Dundee to Edinburgh 10:00',
                'departure_time' => '10:00',
                'arrival_time' => '11:20',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-1130' => [
                'post_title' => 'Dundee to Edinburgh 11:30',
                'departure_time' => '11:30',
                'arrival_time' => '12:50',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-1300' => [
                'post_title' => 'Dundee to Edinburgh 13:00',
                'departure_time' => '13:00',
                'arrival_time' => '14:20',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-1430' => [
                'post_title' => 'Dundee to Edinburgh 14:00',
                'departure_time' => '14:30',
                'arrival_time' => '15:50',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-1600' => [
                'post_title' => 'Dundee to Edinburgh 16:00',
                'departure_time' => '16:00',
                'arrival_time' => '17:20',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-1730' => [
                'post_title' => 'Dundee to Edinburgh 17:30',
                'departure_time' => '17:30',
                'arrival_time' => '18:50',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-1900' => [
                'post_title' => 'Dundee to Edinburgh 19:00',
                'departure_time' => '19:00',
                'arrival_time' => '20:20',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-2030' => [
                'post_title' => 'Dundee to Edinburgh 20:30',
                'departure_time' => '20:30',
                'arrival_time' => '21:50',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-2200' => [
                'post_title' => 'Dundee to Edinburgh 22:00',
                'departure_time' => '22:00',
                'arrival_time' => '23:20',
                'seats' => self::SEATS,
            ],
            'dundee-to-edinburgh-2300' => [
                'post_title' => 'Dundee to Edinburgh 23:30',
                'departure_time' => '23:30',
                'arrival_time' => '00:50',
                'seats' => self::SEATS,
            ],
        ];

        /*** TIMES TO DUNDEE ***/
        $inwardJourneys = [
            'edinburgh-to-dundee-0400' => [
                'post_title' => 'Edinburgh to Dundee 04:00',
                'departure_time' => '04:00',
                'arrival_time' => '05:20',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-0530' => [
                'post_title' => 'Edinburgh to Dundee 05:30',
                'departure_time' => '05:30',
                'arrival_time' => '06:50',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-0700' => [
                'post_title' => 'Edinburgh to Dundee 07:00',
                'departure_time' => '07:00',
                'arrival_time' => '08:20',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-0830' => [
                'post_title' => 'Edinburgh to Dundee 08:30',
                'departure_time' => '08:30',
                'arrival_time' => '09:50',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-1000' => [
                'post_title' => 'Edinburgh to Dundee 10:00',
                'departure_time' => '10:00',
                'arrival_time' => '11:20',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-1130' => [
                'post_title' => 'Edinburgh to Dundee 11:30',
                'departure_time' => '11:30',
                'arrival_time' => '12:50',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-1300' => [
                'post_title' => 'Edinburgh to Dundee 13:00',
                'departure_time' => '13:00',
                'arrival_time' => '14:20',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-1430' => [
                'post_title' => 'Edinburgh to Dundee 14:00',
                'departure_time' => '14:30',
                'arrival_time' => '15:50',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-1600' => [
                'post_title' => 'Edinburgh to Dundee 16:00',
                'departure_time' => '16:00',
                'arrival_time' => '17:20',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-1730' => [
                'post_title' => 'Edinburgh to Dundee 17:30',
                'departure_time' => '17:30',
                'arrival_time' => '18:50',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-1900' => [
                'post_title' => 'Edinburgh to Dundee 19:00',
                'departure_time' => '19:00',
                'arrival_time' => '20:20',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-2030' => [
                'post_title' => 'Edinburgh to Dundee 20:30',
                'departure_time' => '20:30',
                'arrival_time' => '21:50',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-2200' => [
                'post_title' => 'Edinburgh to Dundee 22:00',
                'departure_time' => '22:00',
                'arrival_time' => '23:20',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-2300' => [
                'post_title' => 'Edinburgh to Dundee 23:30',
                'departure_time' => '23:30',
                'arrival_time' => '00:50',
                'seats' => self::SEATS,
            ],
            'edinburgh-to-dundee-0100' => [
                'post_title' => 'Edinburgh to Dundee 01:00',
                'departure_time' => '01:00',
                'arrival_time' => '02:20',
                'seats' => self::SEATS,
            ],
        ];

        return array_merge($outwardJourneys, $inwardJourneys);
    }
}
