<?php

namespace XploreBooking\Controller;

class BookingController
{

    const SEATS = 50;

    public function __construct()
    {
        $this->registerActions();
    }

    private function registerActions()
    {
        add_action('rest_api_init', function () {
            register_rest_route('xplore-booking/v1', '/add-new-booking/', [
                'methods' => ['GET', 'POST'],
                'callback' => [$this, 'addNewBooking'],
            ]);
        });

        add_action('rest_api_init', function () {
            register_rest_route('xplore-booking/v1', '/update-payment-status/', [
                'methods' => 'GET',
                'callback' => [$this, 'updatePaymentStatus'],
            ]);
        });

    }

    public function updatePaymentStatus()
    {
        /*** SAMPLE DATA ***/
        $status = 'paid';
        $bookingId = 148;
        $paymentReference = 'ABC123456';
        /*** END SAMPLE DATA ***/

        switch ($status) {
            case 'paid':
                update_field('payment_reference', $paymentReference, $bookingId);
                update_field('booking_status', 'completed', $bookingId);
                sef::emailUserBookingDetails($status, $bookingId);
                return 'sucessful-booking';
                break;
            case 'failed':
                update_field('payment_reference', $paymentReference, $bookingId);
                update_field('booking_status', 'failed', $bookingId);
                sef::emailUserBookingDetails($status, $bookingId);
                return 'payment-failed';
                break;
            default :
                update_field('booking_status', 'pending', $bookingId);
                return 'unsucessful-booking';
                break;
        }
    }

    public function emailUserBookingDetails($status, $bookingId)
    {
        $to = get_field('email', $bookingId);
        $name = get_field('name', $bookingId);
        $surname = get_field('surname', $bookingId);
        $paymentReference = get_field('payment_reference', $bookingId);
        switch ($status) {
            case 'paid':
                $subject = 'Successful Booking for ' . $paymentReference;
                $tickets = get_field('tickets', $bookingId);
                $outboundJourney = get_field('outbound_journey', $paymentReference);
                $outboundReference = get_field('outbound_reference', $paymentReference);
                $inboundJourney = get_field('inbound_journey', $paymentReference);
                $inboundReference = get_field('inbound_reference', $paymentReference);
                $addOns = get_field('add_ons', $paymentReference);

                $body = '<p>Dear '.$name.' '.$surname.'</p>';
                $body .= '<p>Thank you for your placing your booking, below you will find your booking and journey details.</p>';
                $body .= '<p>Booking for '.$name.' '.$surname.'.</p>';
                $body .= '<p>Payment Reference: '.$paymentReference.'</p>';
                $body .= '<p>Tickets:</p>';
                foreach ($tickets as $ticket) {
                    $body .= $ticket['ticket_type'].', Quantity: '.$ticket['quantity'];
                }
                $body .= 'Journey: ' . $outboundJourney . 'Reference: '.$outboundReference;
                if ($inboundJourney) {
                    $body .= 'Return Journey: ' . $inboundJourney . 'Reference: '.$inboundReference;
                }
                $body .= 'Add-ons: '.$addOns;
                break;
            case 'failed':
                $subject = 'Unsuccessful Booking for ' . $paymentReference;
                $body = 'Unfortunately payment was not succesful for reference: '.$paymentReference;
                $body .= 'Please try again or contact 0123456789 or info@xploremore.co.uk';
                break;
        }

        $headers = ['Content-Type: text/html; charset=UTF-8'];

        wp_mail($to, $subject, $body, $headers);
    }

    public function addNewBooking($request)
    {
        $requiredFields = [
            'name',
            'surname',
            'email',
            'phoneNumber',
            'outbound',
            'seats'
        ];
        foreach($requiredFields as $field) {
            if(!isset($request[$field]) || $request[$field] === '') {
                return new \WP_REST_Response('Required fields are missing.', 400);
            }
        }

        $name = $request['name'];
        $surname = $request['surname'];
        $email = $request['email'];
        $phone = $request['phoneNumber'];
        $seats = $request['seats'];
        $price = $request['price'];

        $outboundSlug = $request['outbound'];
        $outboundReference = explode('-', $outboundSlug);
        $outboundReference = strtoupper($outboundReference[0] . '-' . $outboundReference[2] . '-' . $outboundReference[3] . '-' . mt_rand(00000, 99999));
        $outboundJourney = self::updateOrInsertPostJourney($outboundSlug, $seats);

        if(isset($request['inbound']) && $request['inbound'] !== false) {
            $inboundSlug = $request['inbound'];
            $inboundReference = explode('-', $inboundSlug);
            $inboundReference = strtoupper($inboundReference[0].'-'.$inboundReference[2].'-'.$inboundReference[3].'-'.mt_rand(00000, 99999));
            $inboundJourney = self::updateOrInsertPostJourney($inboundSlug, $seats);
        }

        $addOns = implode(",",$request['addons']);

        $cartItem = $request['inCart'];
        $tickets = [];
        foreach($cartItem as $ticket) {
            $tickets[] = [
                'ticket_type' => $ticket['title'],
                'quantity' => $ticket['quantity']
            ];
        }


        if ( (isset($inboundJourney) && $inboundJourney === 'no-seats')  || $outboundJourney === 'no-seats') {
            return new \WP_REST_Response('There are not enough seats available on the selected journey', 400);
        } else {
            $args = [
                'post_type' => 'booking',
                'post_title' => $name . ' ' . $surname . ' ' . date("d-m-Y H:i"),
                'post_status' => 'publish'
            ];

            $newBooking = wp_insert_post($args);
            update_field('tickets', $tickets, $newBooking);
            update_field('outbound_journey', $outboundJourney, $newBooking);
            update_field('outbound_reference', $outboundReference, $newBooking);
            update_field('inbound_journey', $inboundJourney, $newBooking);
            update_field('inbound_reference', $inboundReference, $newBooking);
            update_field('add_ons', $addOns, $newBooking);
            update_field('name', $name, $newBooking);
            update_field('surname', $surname, $newBooking);
            update_field('email', $email, $newBooking);
            update_field('phone_number', $phone, $newBooking);
            update_field('price', $price, $newBooking);

            return $newBooking;
        }
    }

    public function updateOrInsertPostJourney($slug, $seats)
    {
        $newJourneyBooking = '';

        $postTitle = ucwords(str_replace('-', ' ', $slug));
        $postParts = explode('-', $slug);

        $date = $postParts['4'] . '-' . $postParts['5'] . '-' . $postParts['6'];
        $date = date('Ymd', strtotime($date));

        $args = [
            'name' => $slug,
            'post_type' => 'journey-date',
            'posts_per_page' => 1
        ];

        $query = new \WP_Query($args);

        if (!$query->have_posts()) {

            $newJourneyArgs = [
                'post_title' => $postTitle,
                'post_type' => 'journey-date',
                'post_status' => 'publish'
            ];

            $newJourneyBooking = wp_insert_post($newJourneyArgs);
            update_field('date', $date, $newJourneyBooking);
            update_field('seats', (self::SEATS - $seats), $newJourneyBooking);
        } else {
            while ($query->have_posts()) {
                $query->the_post();
                wp_update_post(get_the_ID());
                $seatsLeft = get_field('seats', get_the_ID());
                if ($seatsLeft > $seats) {
                    update_field('seats', ($seatsLeft - $seats), get_the_ID());
                    $newJourneyBooking = get_the_ID();
                } else {
                    $newJourneyBooking = 'no-seats';
                }
            }
        }
        return $newJourneyBooking;
    }
}
