import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

const iterateObject = (tickets, journeyType, advanced) => {
    let items = [];
    let priceIndex;

    if (advanced) {
        priceIndex = journeyType === 'SINGLE' ? 'advanced_single' : 'advanced_return';
    } else {
        priceIndex = journeyType === 'SINGLE' ? 'single_cost' : 'return_cost';
    }

    for (let [key, value] of Object.entries(tickets)) {
        items.push(
            <p key={key}>
                {value.title} x{value.quantity}: <b>£{value[priceIndex] * value.quantity}</b>
            </p>
        );
    }
    return items;
};

const PriceBreakdown = ({ inCart, journeyType, bookingFee, advanced }) => {
    const priceList = inCart ? iterateObject(inCart, journeyType, advanced) : null;
    return (
        <div className="price-breakdown">
            <p>
                <b>Price breakdown</b>
            </p>
            {priceList}
            <p>£{bookingFee} Booking Fee</p>
        </div>
    );
};

PriceBreakdown.propTypes = {
    inCart: PropTypes.object,
    journeyType: PropTypes.string
};

const mapStateToProps = state => ({
    advanced: state.cart.advanced,
    inCart: state.cart.inCart,
    journeyType: state.cart.journeyType,
    bookingFee: state.cart.bookingFee
});

export default connect(mapStateToProps)(PriceBreakdown);
