import React, { Component } from 'react';
import axios from 'axios';
import { Loader } from 'react-loader-spinner';
import { connect } from 'react-redux';
import { toast } from 'react-toastify';
import { ADD_NEW_BOOKING } from './../config/endpoints';
import { addBooking } from '../redux/actions';
import { getTotalSeatsFromCart } from '../redux/selectors';

class Payment extends Component {
    constructor(props) {
        super(props);

        this.state = {
            loading: true
        };
    }

    componentDidMount() {
        const { name, surname, email, phoneNumber } = this.props.user;
        const { addons, seats } = this.props;
        const outbound = this.props.outbound !== null && this.props.outbound.slug;
        const inbound = this.props.inbound !== null && this.props.inbound.slug;
        axios
            .post(ADD_NEW_BOOKING, {
                name,
                surname,
                email,
                phoneNumber,
                outbound,
                inbound,
                addons,
                seats
            })
            .then(response => {
                const bookingId = response.data;
                this.props.addBooking(bookingId);
                this.setState({ loading: false });
            })
            .catch(error => {
                toast.error(error.response.data);
                console.error('Create booking:', error);
                this.setState({ loading: false });
            });
    }

    render() {
        return (
            <div className="choose-journey">
                {this.loading && <Loader type="Oval" width={50} height={50} color="#088584" />}

                {this.props.bookingId !== null && <h1>{this.props.bookingId}</h1>}
            </div>
        );
    }
}

const mapStateToProps = state => {
    const { outbound, inbound, addons } = state.cart;
    const seats = getTotalSeatsFromCart(state);
    return {
        bookingId: state.booking.bookingId,
        user: state.user,
        outbound,
        inbound,
        addons,
        seats
    };
};
export default connect(
    mapStateToProps,
    { addBooking }
)(Payment);
