import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

const iterateObject = (tickets, journeyType) => {
    let items = [];
    const priceIndex = journeyType === 'SINGLE' ? 'single_cost' : 'return_cost';
    for (let [key, value] of Object.entries(tickets)) {
        items.push(
            <p key={key}>
                {value.title} x{value.quantity}: <b>£{value[priceIndex] * value.quantity}</b>
            </p>
        );
    }
    return items;
};

const PriceBreakdown = ({ inCart, journeyType }) => {
    const priceList = inCart ? iterateObject(inCart, journeyType) : null;
    return (
        <div className="price-breakdown">
            <p>
                <b>Price breakdown</b>
            </p>
            {priceList}
        </div>
    );
};

PriceBreakdown.propTypes = {
    inCart: PropTypes.object,
    journeyType: PropTypes.string
};

const mapStateToProps = state => ({
    inCart: state.cart.inCart,
    journeyType: state.cart.journeyType
});

export default connect(mapStateToProps)(PriceBreakdown);
