import React, { Component } from 'react';

import { BrowserRouter } from 'react-router-dom';
import { Header, Footer, MainView, Cart } from './components';
import { ToastContainer, Slide } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.min.css';
import './config/FontAwesomeLibrary';

class BookingApp extends Component {
    constructor(props) {
        super(props);
    }

    render() {
        return (
            <div className="container">
                <BrowserRouter>
                    <Header />
                    <div className="row">
                        <MainView />
                        <Cart />
                    </div>
                    {/* <Footer /> */}
                </BrowserRouter>
                <ToastContainer
                    position="top-center"
                    autoClose={3000}
                    hideProgressBar
                    newestOnTop
                    transition={Slide}
                    closeOnClick
                    rtl={false}
                    pauseOnVisibilityChange
                    draggable
                    pauseOnHover={false}
                />
            </div>
        );
    }
}

export default BookingApp;
