import React, { Component } from 'react';
import axios from 'axios';
import Loader from 'react-loader-spinner';
import { AVAILABLE_JOURNEYS } from './../config/endpoints';
import { connect } from 'react-redux';
import { getTotalSeatsFromCart } from '../redux/selectors';
import { addJourney } from '../redux/actions';
import moment from 'moment';
import NoResults from '../components/ChooseTickets/NoResults';
import posed from 'react-pose';

const Container = posed.div({
    enter: { staggerChildren: 50 }
});

const AnimatedDiv = posed.div({
    enter: { x: 0, opacity: 1 },
    exit: { x: 25, opacity: 0 }
});

class ChooseJourney extends Component {
    constructor(props) {
        super(props);

        this.state = {
            journeys: null,
            loading: true
        };
    }

    componentDidMount() {
        const { journeyType, depart, departureDate, returnDate, totalSeats } = this.props;
        const departFormatted = this.formatDate(departureDate);
        const returnFormatted = this.formatDate(returnDate);
        const body = { journeyType, depart, departFormatted, returnFormatted, totalSeats };

        axios
            .get(AVAILABLE_JOURNEYS, {
                params: body
            })
            .then(response => {
                const journeys = JSON.parse(response.data);
                this.setState({
                    journeys: JSON.parse(response.data),
                    loading: false
                });
            })
            .catch(error => {
                console.warn('CATCH ERROR: ', error);
            });
    }

    formatDate = date => {
        return moment(date).format('DD-MM-YYYY');
    };

    journeyList = (journeys, direction) => {
        let items = [];
        for (let [key, value] of Object.entries(journeys)) {
            items.push(
                <AnimatedDiv className="journey" key={key}>
                    <p dangerouslySetInnerHTML={{ __html: value.title }} />
                    <button onClick={() => this.props.addJourney(value, direction)}>
                        Add Journey
                    </button>
                </AnimatedDiv>
            );
        }
        return items;
    };

    render() {
        return (
            <div className="choose-journey">
                <h1>Choose Journey</h1>
                {this.state.loading && (
                    <Loader type="Oval" width={50} height={50} color="#088584" />
                )}
                {!this.state.loading && this.state.journeys === null && <NoResults />}

                {this.state.journeys && (
                    <Container>
                        {this.state.journeys.outbound && (
                            <>
                                <h2>Outbound Journey</h2>
                                {this.journeyList(this.state.journeys.outbound, 'outbound')}
                            </>
                        )}
                        {this.state.journeys.inbound && (
                            <>
                                <h2>Inbound Journey</h2>
                                {this.journeyList(this.state.journeys.inbound, 'inbound')}
                            </>
                        )}
                    </Container>
                )}

                {/* {this.state.journeys &&
                    this.state.journeys.map(journey => {
                        return (
                            <div className="journey" key={journey.id}>
                                <p dangerouslySetInnerHTML={{ __html: journey.title }} />
                            </div>
                        );
                    })} */}
            </div>
        );
    }
}

const mapStateToProps = state => {
    const { journeyType, depart, departureDate, returnDate } = state.cart;
    const totalSeats = getTotalSeatsFromCart(state);
    return {
        journeyType,
        depart,
        departureDate,
        returnDate,
        totalSeats
    };
};

//TODO: Add journey action to be connected
export default connect(
    mapStateToProps,
    { addJourney }
)(ChooseJourney);
