import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { updateAddons } from '../redux/actions';

class AddOns extends Component {
    constructor(props) {
        super(props);
    }

    updateUserDetail = e => {
        this.props.updateAddons(e.target);
    };

    render() {
        const {
            additionalLuggageChecked,
            luggageDescription,
            oversizedLuggage,
            oversizedDescription
        } = this.props;

        return (
            <>
                <h1>Add ons</h1>
                <div className="content">
                    <p>
                        <strong>Will you have extra luggage?</strong>
                    </p>
                    <input
                        type="radio"
                        name="additionalLuggageChecked"
                        value="yes"
                        checked={additionalLuggageChecked === 'yes'}
                        onChange={this.updateUserDetail}
                    />
                    Yes
                    <input
                        type="radio"
                        name="additionalLuggageChecked"
                        value="no"
                        checked={additionalLuggageChecked === 'no'}
                        onChange={this.updateUserDetail}
                    />
                    No <br />
                    <p>
                        The additional cost for each extra luggage is £10, and will be payed upon
                        your arrival at the bus
                    </p>
                    <br />
                    {additionalLuggageChecked === 'yes' && (
                        <>
                            <p>Please let us know the amount of extra luggage you will have.</p>
                            <textarea
                                name="luggageDescription"
                                placeholder={
                                    luggageDescription === ''
                                        ? 'Please enter brief description...'
                                        : undefined
                                }
                                defaultValue={luggageDescription}
                                onBlur={this.updateUserDetail}
                            />
                            <br />
                        </>
                    )}
                    <p>
                        <strong>Will you have oversized baggage?</strong>
                    </p>
                    <input
                        type="radio"
                        name="oversizedLuggage"
                        value="yes"
                        checked={oversizedLuggage === 'yes'}
                        onChange={this.updateUserDetail}
                    />
                    Yes
                    <input
                        type="radio"
                        name="oversizedLuggage"
                        value="no"
                        checked={oversizedLuggage === 'no'}
                        onChange={this.updateUserDetail}
                    />
                    No <br />
                    {oversizedLuggage === 'yes' && (
                        <>
                            <p>Please let us know the amount of extra luggage you will have.</p>
                            <textarea
                                name="oversizedDescription"
                                placeholder={
                                    oversizedDescription === ''
                                        ? 'Please enter brief description...'
                                        : undefined
                                }
                                defaultValue={oversizedDescription}
                                onBlur={this.updateUserDetail}
                            />
                            <br />
                        </>
                    )}
                </div>
                <p>
                    * Luggage allowance is 1 large suitcase with a maximum weight of 23kg, or two
                    medium suitcases per person with a maximum combined weight of 23kg
                </p>
            </>
        );
    }
}

AddOns.propTypes = {
    context: PropTypes.object
};

const mapStateToProps = state => ({ ...state.cart.addons });

export default connect(
    mapStateToProps,
    { updateAddons }
)(AddOns);
