import {
    CHANGE_JOURNEY_TYPE,
    CHANGE_DIRECTION,
    SET_DEPARTURE_DATE,
    SET_RETURN_DATE,
    ADD_TICKET_TO_CART,
    REMOVE_TICKET_FROM_CART,
    UPDATE_ADDONS,
    SET_TERMS,
    ADD_JOURNEY
} from '../actionTypes';

const initialState = {
    journeyType: 'SINGLE',
    depart: 'DUNDEE',
    departureDate: null,
    returnDate: null,
    inCart: {},
    addons: {
        additionalLuggageChecked: 'no',
        luggageDescription: '',
        oversizedLuggage: 'no',
        oversizedDescription: ''
    },
    outbound: null,
    inbound: null,
    agreeToTerms: false
};

export default function(state = initialState, action) {
    switch (action.type) {
        case CHANGE_JOURNEY_TYPE: {
            const { type } = action.payload;
            return {
                ...state,
                journeyType: type
            };
        }
        case CHANGE_DIRECTION: {
            const newDepart = state.depart === 'DUNDEE' ? 'EDINBURGH' : 'DUNDEE';
            return {
                ...state,
                depart: newDepart
            };
        }
        case SET_DEPARTURE_DATE: {
            const { date } = action.payload;
            return {
                ...state,
                departureDate: date
            };
        }
        case SET_RETURN_DATE: {
            const { date } = action.payload;
            return {
                ...state,
                returnDate: date
            };
        }
        case ADD_TICKET_TO_CART: {
            const { id, title, single_cost, return_cost, seats } = action.payload;
            const newObj = state.inCart[id]
                ? {
                      quantity: state.inCart[id].quantity + 1
                  }
                : {
                      title,
                      single_cost,
                      return_cost,
                      seats,
                      quantity: 1
                  };

            return {
                ...state,
                inCart: {
                    ...state.inCart,
                    [id]: {
                        ...state.inCart[id],
                        ...newObj
                    }
                }
            };
        }
        case REMOVE_TICKET_FROM_CART: {
            const { id } = action.payload;
            if (!(id in state.inCart)) return state;

            if (state.inCart[id].quantity === 1) {
                const newInCart = state.inCart;
                delete newInCart[id];
                return {
                    ...state,
                    inCart: {
                        ...newInCart
                    }
                };
            }

            const quantity = state.inCart[id].quantity - 1;
            return {
                ...state,
                inCart: {
                    ...state.inCart,
                    [id]: {
                        ...state.inCart[id],
                        quantity
                    }
                }
            };
        }
        case UPDATE_ADDONS: {
            const { key, value } = action.payload;
            return {
                ...state,
                addons: {
                    ...state.addons,
                    [key]: value
                }
            };
        }
        case SET_TERMS: {
            return {
                ...state,
                agreeToTerms: action.payload
            };
        }
        case ADD_JOURNEY: {
            const { journey, direction } = action.payload;
            return {
                ...state,
                [direction]: {
                    ...journey
                }
            };
        }
        default:
            return state;
    }
}
