import React from 'react';
import { NavLink } from 'react-router-dom';
import Routes from '../routes';

const Header = () => {
    return (
        <div className="header">
            <ul>
                {Routes.map((route, index) => {
                    return route.hide ? null : (
                        <li key={index}>
                            <NavLink
                                exact={true}
                                isActive={route.isActive && route.isActive}
                                to={route.path}
                                title={route.title}
                                onClick={e => e.preventDefault()}>
                                {route.title}
                            </NavLink>
                        </li>
                    );
                })}
            </ul>
        </div>
    );
};

export default Header;
