import React from 'react';
import { connect } from 'react-redux';
import { setTerms } from '../../redux/actions';
import { getTotalCostFromCart } from '../../redux/selectors';
import BackButton from './BackButton';
import ContinueButton from './ContinueButton';
import JourneyDetails from './JourneyDetails';
import PriceBreakdown from './PriceBreakdown';
import Addons from './Addons';

const Cart = ({ totalPrice, setTerms }) => (
    <div className="cart">
        <BackButton />
        <div className="content">
            <div className="heading">
                <h2>Booking Details</h2>
                <span className="price">£{totalPrice}</span>
                <hr />
            </div>
            <JourneyDetails />
            <PriceBreakdown />
            <Addons />
            <div className="terms">
                <input name="terms" type="checkbox" onChange={e => setTerms(e.target.checked)} />I
                have read and accept the terms and conditions
            </div>
            <ContinueButton />
        </div>
    </div>
);

const mapStateToProps = state => {
    const { journeyType, depart, departureDate, returnDate, inCart } = state.cart;
    const totalPrice = getTotalCostFromCart(state);
    return {
        journeyType,
        depart,
        departureDate,
        returnDate,
        inCart,
        totalPrice
    };
};

export default connect(
    mapStateToProps,
    { setTerms }
)(Cart);
