import React from 'react';
import { connect } from 'react-redux';
import moment from 'moment';

const DirectionText = ({ direction }) => {
    return direction ? (
        <p>
            <b>Dundee to Edinburgh</b>
        </p>
    ) : (
        <p>
            <b>Edinburgh to Dundee</b>
        </p>
    );
};

const departureTimeText = (date, journey) => {
    return (
        <p>
            Departure: {moment(date).format('ddd Do MMMM')}
            {journey !== null && `, ${journey.departure_time}`}
        </p>
    );
};

const JourneyDetails = ({ depart, departureDate, journeyType, returnDate, outbound, inbound }) => (
    <div className="journey-details">
        <DirectionText direction={depart === 'DUNDEE'} />
        {departureDate && departureTimeText(departureDate, outbound)}

        {journeyType === 'RETURN' && (
            <>
                <DirectionText direction={depart !== 'DUNDEE'} />
                {returnDate && departureTimeText(returnDate, inbound)}
            </>
        )}
        <hr />
    </div>
);

const mapStateToProps = state => {
    const { depart, departureDate, journeyType, returnDate, inbound, outbound } = state.cart;
    return {
        depart,
        departureDate,
        journeyType,
        returnDate,
        inbound,
        outbound
    };
};

export default connect(mapStateToProps)(JourneyDetails);
