import React from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { previousRoute } from './../../redux/actions';

const BackButton = ({ history, step, previousRoute }) => (
    <div className="back-button">
        {step > 1 && (
            <button
                onClick={() => {
                    history.goBack();
                    previousRoute();
                }}>
                Back
            </button>
        )}
    </div>
);

export default connect(
    state => ({
        step: state.route.step
    }),
    { previousRoute }
)(withRouter(BackButton));
