export const getTotalSeatsFromCart = store => {
    const { inCart } = store.cart;
    let seats = 0;
    for (const [key, value] of Object.entries(inCart)) {
        seats += parseInt(value.seats) * parseInt(value.quantity);
    }
    return seats;
};

export const getTotalCostFromCart = store => {
    const { inCart, journeyType } = store.cart;
    const priceIndex = journeyType === 'SINGLE' ? 'single_cost' : 'return_cost';
    let cost = 0;
    for (let [key, value] of Object.entries(inCart)) {
        cost += value[priceIndex] * value.quantity;
    }
    return cost;
};
