import React from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { progressRoute } from './../../redux/actions';
import Routes from '../../routes';

const BackButton = ({ history, step, continueDisable, progressRoute }) => (
    <button
        disabled={continueDisable}
        className="primary continue-button"
        onClick={() => {
            history.push(Routes[step].path);
            progressRoute();
        }}>
        Continue
    </button>
);

export default connect(
    state => ({
        step: state.route.step,
        continueDisable: state.route.continueDisable
    }),
    { progressRoute }
)(withRouter(BackButton));
