import React, { Component } from 'react';
import axios from 'axios';
import { ALL_TICKETS } from '../config/endpoints';
import { connect } from 'react-redux';
import { addTickets } from '../redux/actions';

import {
    JourneyTypeSelect,
    DirectionSelect,
    DateSelect,
    TicketList
} from '../components/ChooseTickets';

class ChooseTicket extends Component {
    constructor(props) {
        super(props);

        this.now = new Date();
    }

    componentDidMount() {
        axios
            .get(ALL_TICKETS)
            .then(response => {
                this.props.addTickets(JSON.parse(response.data));
                this.setState({ loading: false });
            })
            .catch(error => {
                console.warn('CATCH ERROR: ', error);
            });
    }

    render() {
        return (
            <div className="choose-ticket">
                <h1>Choose Journey</h1>
                <div className="content">
                    <JourneyTypeSelect />
                    <DirectionSelect />
                    <hr />
                    <DateSelect />
                    <TicketList />
                </div>
            </div>
        );
    }
}

export default connect(
    null,
    { addTickets }
)(ChooseTicket);
