import { PROGRESS_ROUTE } from '../actionTypes';
import { Routes } from './../../routes/index';
import { PREVIOUS_ROUTE } from './../actionTypes';

const initialState = {
    step: 1,
    continueDisable: false
};

export default function(state = initialState, action) {
    switch (action.type) {
        case PROGRESS_ROUTE: {
            const nextStep = state.step + 1;
            if (nextStep > Routes.length) return { ...state };
            const continueDisable = nextStep === Routes.length;
            return {
                ...state,
                continueDisable,
                step: nextStep
            };
        }
        case PREVIOUS_ROUTE: {
            const prevStep = state.step - 1;
            if (prevStep < 0) return { ...state };
            const continueDisable = prevStep === Routes.length;
            return {
                ...state,
                continueDisable,
                step: prevStep
            };
        }

        default:
            return state;
    }
}
