import React from 'react';
import { connect } from 'react-redux';
import { changeJourneyType } from '../../redux/actions';

const JourneyTypeSelect = ({ journeyType, changeJourneyType }) => (
    <>
        <div className="journey-type-radio">
            <input
                type="radio"
                value="SINGLE"
                name="journey_type"
                onChange={e => changeJourneyType(e.target.value)}
                checked={journeyType === 'SINGLE'}
            />
            Single
        </div>
        <div className="journey-type-radio">
            <input
                type="radio"
                value="RETURN"
                name="journey_type"
                onChange={e => changeJourneyType(e.target.value)}
                checked={journeyType === 'RETURN'}
            />
            Return
        </div>
    </>
);

const mapStateToProps = state => {
    return { journeyType: state.cart.journeyType };
};

export default connect(
    mapStateToProps,
    { changeJourneyType }
)(JourneyTypeSelect);
