import React from 'react';
import { connect } from 'react-redux';

import DatePicker from 'react-datepicker';
import { setDepartureDate, setReturnDate } from '../../redux/actions';

const now = new Date();
const DateSelect = ({
    journeyType,
    departureDate,
    returnDate,
    setDepartureDate,
    setReturnDate
}) => (
    <>
        Depart Date *
        <DatePicker
            selected={departureDate === null ? now : departureDate}
            onChange={value => setDepartureDate(value)}
            dateFormat="dd/M/Y"
        />
        {journeyType === 'RETURN' && (
            <>
                Return Date *
                <DatePicker
                    selected={returnDate === null ? now : returnDate}
                    onChange={value => setReturnDate(value)}
                    dateFormat="dd/M/Y"
                />
            </>
        )}
        <hr />
    </>
);

const mapStateToProps = state => {
    const { journeyType, departureDate, returnDate } = state.cart;
    return {
        journeyType: journeyType,
        departureDate: departureDate,
        returnDate: returnDate
    };
};

export default connect(
    mapStateToProps,
    { setDepartureDate, setReturnDate }
)(DateSelect);
