import React, { Component } from 'react';
import axios from 'axios';
import Loader from 'react-loader-spinner';
import { AVAILABLE_JOURNEYS } from './../config/endpoints';
import { connect } from 'react-redux';
import { getTotalSeatsFromCart } from '../redux/selectors';
import moment from 'moment';

class ChooseJourney extends Component {
    constructor(props) {
        super(props);

        this.state = {
            journeys: null,
            loading: true
        };
    }

    componentDidMount() {
        const { journeyType, depart, departureDate, returnDate, totalSeats } = this.props;
        const departFormatted = this.formatDate(departureDate);
        const returnFormatted = this.formatDate(returnDate);
        const body = { journeyType, depart, departFormatted, returnFormatted, totalSeats };

        axios
            .get(AVAILABLE_JOURNEYS, {
                params: body
            })
            .then(response => {
                const journeys = JSON.parse(response.data);
                console.log(journeys.outbound);
                console.log(journeys.inbound);
                this.setState({
                    // journeys: JSON.parse(response.data),
                    loading: false
                });
            })
            .catch(error => {
                console.warn('CATCH ERROR: ', error);
            });
    }

    formatDate = date => {
        return moment(date).format('DD-MM-YYYY');
    };

    render() {
        return (
            <div className="choose-journey">
                <h1>Choose Journey</h1>
                {this.state.loading && (
                    <Loader type="Oval" width={50} height={50} color="#088584" />
                )}

                {this.state.journeys &&
                    this.state.journeys.map(journey => {
                        return (
                            <div className="journey" key={journey.id}>
                                <p dangerouslySetInnerHTML={{ __html: journey.title }} />
                            </div>
                        );
                    })}
            </div>
        );
    }
}

const mapStateToProps = state => {
    const { journeyType, depart, departureDate, returnDate } = state.cart;
    const totalSeats = getTotalSeatsFromCart(state);
    return {
        journeyType,
        depart,
        departureDate,
        returnDate,
        totalSeats
    };
};

//TODO: Add journey action to be connected
export default connect(mapStateToProps)(ChooseJourney);
