import {
    CHANGE_JOURNEY_TYPE,
    CHANGE_DIRECTION,
    SET_DEPARTURE_DATE,
    SET_RETURN_DATE,
    ADD_TICKET_TO_CART,
    REMOVE_TICKET_FROM_CART,
    UPDATE_ADDONS
} from '../actionTypes';

const now = new Date();
const initialState = {
    journeyType: 'SINGLE',
    depart: 'DUNDEE',
    departureDate: now,
    returnDate: now,
    inCart: [],
    addons: {
        additionalLuggageChecked: 'no',
        luggageDescription: '',
        oversizedLuggage: 'no',
        oversizedDescription: ''
    }
};

export default function(state = initialState, action) {
    switch (action.type) {
        case CHANGE_JOURNEY_TYPE: {
            const { type } = action.payload;
            return {
                ...state,
                journeyType: type
            };
        }
        case CHANGE_DIRECTION: {
            const newDepart = state.depart === 'DUNDEE' ? 'EDINBURGH' : 'DUNDEE';
            return {
                ...state,
                depart: newDepart
            };
        }
        case SET_DEPARTURE_DATE: {
            const { date } = action.payload;
            return {
                ...state,
                departureDate: date
            };
        }
        case SET_RETURN_DATE: {
            const { date } = action.payload;
            return {
                ...state,
                returnDate: date
            };
        }
        case ADD_TICKET_TO_CART: {
            const { id, title, single_cost, return_cost, seats } = action.payload;
            const newObj = state.inCart[id]
                ? {
                      quantity: state.inCart[id].quantity + 1
                  }
                : {
                      title,
                      single_cost,
                      return_cost,
                      seats,
                      quantity: 1
                  };

            return {
                ...state,
                inCart: {
                    ...state.inCart,
                    [id]: {
                        ...state.inCart[id],
                        ...newObj
                    }
                }
            };
        }
        case REMOVE_TICKET_FROM_CART: {
            const { id } = action.payload;
            const newCount = state.inCart[id] > 0 ? state.inCart[id] - 1 : state.inCart[id];
            return {
                ...state,
                inCart: { ...state.inCart, [id]: newCount }
            };
        }
        case UPDATE_ADDONS: {
            const { key, value } = action.payload;
            return {
                ...state,
                addons: {
                    ...state.addons,
                    [key]: value
                }
            };
        }
        default:
            return state;
    }
}
