import * as ACTIONS from './actionTypes';

//CART
export const changeJourneyType = type => ({
    type: ACTIONS.CHANGE_JOURNEY_TYPE,
    payload: {
        type
    }
});

export const changeDirection = () => ({
    type: ACTIONS.CHANGE_DIRECTION
});

export const setDepartureDate = date => ({
    type: ACTIONS.SET_DEPARTURE_DATE,
    payload: {
        date
    }
});

export const setReturnDate = date => ({
    type: ACTIONS.SET_RETURN_DATE,
    payload: {
        date
    }
});

export const addTicketToCart = id => ({
    type: ACTIONS.ADD_TICKET_TO_CART,
    payload: id
});

export const removeTicketFromCart = id => ({
    type: ACTIONS.REMOVE_TICKET_FROM_CART,
    payload: id
});

export const updateAddons = field => ({
    type: ACTIONS.UPDATE_ADDONS,
    payload: {
        key: field.name,
        value: field.value
    }
});

//TICKETS
export const addTickets = tickets => ({
    type: ACTIONS.ADD_TICKETS,
    payload: tickets
});

//USER
export const updateUser = field => ({
    type: ACTIONS.UPDATE_USER,
    payload: {
        key: field.name,
        value: field.value
    }
});
