import React from 'react';
import { connect } from 'react-redux';
import { addTicketToCart, removeTicketFromCart } from '../../redux/actions';
import Loader from 'react-loader-spinner';

const TicketList = ({ tickets, addTicketToCart, removeTicketFromCart }) => {
    if (tickets.length === 0) return <Loader type="Oval" width={50} height={50} color="#088584" />;
    return (
        <>
            {tickets.map(ticket => {
                return (
                    <div className="ticket" key={ticket.id}>
                        <b>{ticket.title}</b>
                        <button onClick={() => addTicketToCart(ticket)}>Add</button>
                        <button onClick={() => removeTicketFromCart(ticket)}>Remove</button>
                    </div>
                );
            })}
        </>
    );
};

const mapStateToProps = state => {
    return {
        tickets: state.tickets.allTickets
    };
};

export default connect(
    mapStateToProps,
    { addTicketToCart, removeTicketFromCart }
)(TicketList);
