import React from 'react';
import { connect } from 'react-redux';

import DatePicker from 'react-datepicker';
import { setDepartureDate, setReturnDate } from '../../redux/actions';

const DateSelect = ({
    journeyType,
    departureDate,
    returnDate,
    setDepartureDate,
    setReturnDate
}) => (
    <>
        Depart Date*
        <DatePicker
            selected={departureDate}
            onChange={value => setDepartureDate(value)}
            dateFormat="dd/M/Y"
        />
        {journeyType === 'RETURN' && (
            <>
                <hr />
                Return Date*
                <DatePicker
                    selected={returnDate}
                    onChange={value => setReturnDate(value)}
                    dateFormat="dd/M/Y"
                />
            </>
        )}
    </>
);

const mapStateToProps = state => {
    const { journeyType, departureDate, returnDate } = state.cart;
    return {
        journeyType: journeyType,
        departureDate: departureDate,
        returnDate: returnDate
    };
};

export default connect(
    mapStateToProps,
    { setDepartureDate, setReturnDate }
)(DateSelect);
