import React from 'react';
import ReactDOM from 'react-dom';
import './styles/main.scss';

import { BrowserRouter } from 'react-router-dom';
import { Header, Footer, MainView, Cart } from './components';

const AppRoutes = () => (
    <BrowserRouter>
        <Header />
        <div className="row">
            <MainView />
            {window.location.pathname !== '/booking/confirmation' && <Cart />}
        </div>
        <Footer />
    </BrowserRouter>
);

const App = (
    <div className="container">
        <AppRoutes />
    </div>
);

ReactDOM.render(App, document.getElementById('app'));
