import React from 'react';
import ReactDOM from 'react-dom';
import './styles/main.scss';

import { BrowserRouter as Router } from 'react-router-dom';
import { Header, Footer, MainView, Cart } from './components';

const AppRoutes = () => (
    <Router>
        <Header />
        <div className="row">
            <MainView />
            <Cart />
        </div>
        <Footer />
    </Router>
);

const App = (
    <div className="container">
        <AppRoutes />
    </div>
);

ReactDOM.render(App, document.getElementById('app'));
