<?php

namespace B2;

class XploreBookingPlugin
{

    private $pluginDirectoryPath;
    private $pluginDirectoryURL;

    public function __construct($pluginDirectoryPath, $pluginDirectoryURL)
    {
        $this->pluginDirectoryPath = $pluginDirectoryPath;
        $this->pluginDirectoryURL = $pluginDirectoryURL;

        $this->setupControllers();
        $this->registerShortCodes();
        $this->registerActions();
        $this->registerFilters();

    }

    private function setupControllers()
    {

    }

    private function registerShortCodes()
    {

    }

    private function registerActions()
    {
        add_action('wp_enqueue_scripts', [$this, 'enqueueAssets']);
        add_action('wp_enqueue_scripts', [$this, 'addjquery']);

    }

    private function registerFilters()
    {

    }

    public function addJquery()
    {
        wp_deregister_script('jquery');
        wp_enqueue_script('jquery', 'https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js', [], null, true);
    }

    public function pluginActivation()
    {
        $this->createPages();
    }

    private function createPages()
    {
        $pageDefinitions = [
            'click-collect-login' => [
                'post_title' => 'Click & Collect Login',
            ],
        ];

        foreach ($pageDefinitions as $slug => $pageArgs) {
            // Check that the page doesn't exist already
            $query = new \WP_Query('pagename=' . $slug);
            if (!$query->have_posts()) {
                // Add the page using the data from the array above
                $defaultArgs = [
                    'post_name' => $slug,
                    'post_status' => 'publish',
                    'post_type' => 'page',
                    'ping_status' => 'closed',
                    'comment_status' => 'closed',
                ];
                $args = array_merge($pageArgs, $defaultArgs);
                wp_insert_post($args);
            }
        }
    }

    public function enqueueAssets()
    {
        //TODO: REPLACE WITH CORRECT
        if (is_page(['click-collect-dashboard', 'click-collect-location', 'click-collect-login'])) {
            wp_enqueue_style('click-collect-css', $this->pluginDirectoryURL . '/assets/styles/main.css', [], '1', false);
        }
    }

    function clickCollectTemplates($page_template)
    {
        //TODO: REPLACE WITH CORRECT
        if (is_page(['click-collect-login', 'click-collect-location', 'click-collect-dashboard'])) {
            $page_template = $this->pluginDirectoryPath . '/templates/template-click-collect.php';
        }
        return $page_template;
    }

    public function checkValidUserType()
    {
        return !empty(array_intersect(['administrator'], $this->getUserRoles()));
    }

    public function getUserRoles()
    {
        $roles = '';
        if (is_user_logged_in()) {
            $user = wp_get_current_user();
            $roles = $user->roles;
        }
        return $roles;
    }

}
