<?php
$heroType = get_sub_field('hero_type');
$heroImage = get_sub_field('hero_background_image');
$thinCurve = get_template_directory_uri() . '/dist/images/thin-curve.png';
?>

<div class="custom-flexible-section hero-section <?= $heroType; ?>">
    <?php if($heroType == 'exclude-header-bar') {
        $heroForegroundImage = get_sub_field('hero_foreground_image');
        $heroTitle = get_sub_field('hero_title_no_header');
        $heroCTA = get_sub_field('hero_cta');
        ?>
        <div class="header-holder exclude-bar" style="background-image:url('<?= $heroImage['url']; ?>')">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-lg-7">
                        <h1><?= $heroTitle; ?></h1>
                        <?php if($heroCTA) { ?>
                            <div class="cta-holder">
                                <a href="<?= $heroCTA['url']; ?>"><?= $heroCTA['title']; ?></a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="col-md-6 col-lg-5 foreground-image-col">
                        <img src="<?= $heroForegroundImage['url']; ?>">
                    </div>
                </div>
                <span class="fa-stack arrow-stack fa-2x">
                  <i class="fas fa-circle fa-stack-2x"></i>
                  <i class="fas fa-arrow-down fa-stack-1x fa-inverse social-icon"></i>
                </span>
            </div>
            <img src="<?= get_template_directory_uri() . '/dist/images/thick-curve.png'; ?>" class="curve">
        </div>
    <?php } elseif($heroType == 'include-header-bar') {
        $heroTitle = get_sub_field('hero_title_fixed_header');
        $heroDescription = get_sub_field('hero_text_fixed_header'); ?>

        <div class="fixed-header-hero">
            <div class="inner-hero">
                <div class="row bg-row no-gutters">
                    <div class="col-lg-6"></div>
                    <div class="col-lg-6 image-col" style="background-image:url('<?= $heroImage['url']; ?>')"></div>
                </div>

                <div class="container content-container">
                    <div class="row">
                        <div class="col-lg-6">
                            <h1><?= $heroTitle; ?></h1>
                            <div class="description"><?= $heroDescription; ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <img src="<?= $thinCurve; ?>" class="thin-curve">
        </div>
    <?php }?>
</div>
