<?php
$image = get_sub_field('introduction_image');
$introPrimary = get_sub_field('introduction_primary_text');
$introSecondary = get_sub_field('introduction_secondary_text');
$cta = get_sub_field('cta');
$blocks = get_sub_field('award_blocks');
$awardImage = get_template_directory_uri() . '/dist/images/award.png';
?>

<div class="custom-flexible-section award-section">
    <div class="container">
        <div class="introduction">
            <img src="<?= $image['url']; ?>">
            <h3><?= $introPrimary; ?></h3>
            <p><?= $introSecondary ?></p>
        </div>
        <?php if($blocks) { ?>
            <div class="blocks">
                <div class="row">
                    <?php foreach($blocks as $block) { ?>
                        <div class="col-lg-6 award-col">
                            <div class="award-item">
                                <img src="<?= $awardImage; ?>">
                                <div class="description"><?= $block['award_description']; ?></div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>

        <?php if($cta) { ?>
            <div class="cta"><a href="<?= $cta['url']; ?>"><?= $cta['title']; ?></a></div>
        <?php } ?>

    </div>
</div>

