<?php
$companyLogo = get_field('company_logo', 'option');
$phoneNumber = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$addressLocation = get_field('company_location', 'option');
$addressText = $addressLocation['address'] ?: get_field('company_address_text', 'option');
?>

<footer class="custom-footer">
    <div class="container">
        <div class="top-section">
            <div class="row">
                <div class="col-lg-6"><img src="<?= $companyLogo['url']; ?>" alt="<?php bloginfo('name'); ?>"></div>
                <div class="offset-lg-1 col-lg-5">
                    <?php if (have_rows('social_media_channels', 'option')) { ?>
                        <ul class="socials">
                            <?php while (have_rows('social_media_channels', 'option')) {
                                the_row(); ?>
                                <li>
                                    <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                        <span class="fa-stack fa-2x">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse social-icon"></i>
                                        </span>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="middle-section">
            <div class="row">
                <div class="col-lg-6">
                    <h3>Contact</h3>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="address-text">
                                <?= $addressText; ?>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <ul class="contact-details">
                                <?php if($phoneNumber) { ?><li>Call: <a href="tel:<?= $phoneNumber; ?>"><?= $phoneNumber; ?></a></li><?php } ?>
                                <?php if($email) { ?><li>Email: <a href="mailto:<?= $email; ?>"><?= $email; ?></a></li><?php } ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="offset-lg-1 col-lg-5">
                    <div class="footer-form">
                        <?php the_field('footer_form', 'option'); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="bottom-section">
            <div class="row">
                <div class="col-lg-4 copyright-col">
                    <p class="copyright">&copy; <?php bloginfo('name'); ?> Ltd <?= date("Y"); ?> </p>
                </div>
                <div class="col-lg-4 footer-menu-col">
                    <?php
                    if (has_nav_menu( 'footer_menu' )) {
                        wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => '']);
                    }
                    ?>
                </div>
                <div class="col-lg-4 website-by-col">
                    <p class="website-by">Website by <?php echo do_shortcode( '[blue2_logo type="light"]' ); ?></p>
                </div>
            </div>
        </div>
    </div>
</footer>
