<?php
$heroType = get_sub_field('hero_type');
$heroImage = get_sub_field('hero_background_image');
?>

<div class="custom-flexible-section hero-section <?= $heroType; ?>">
    <?php if($heroType == 'exclude-header-bar') {
        $heroForegroundImage = get_sub_field('hero_foreground_image');
        $heroTitle = get_sub_field('hero_title_no_header');
        $heroCTA = get_sub_field('hero_cta');
        ?>
        <div class="header-holder exclude-bar" style="background-image:url('<?= $heroImage['url']; ?>')">
            <div class="container">
                <div class="row">
                    <div class="col-lg-7">
                        <h1><?= $heroTitle; ?></h1>
                        <?php if($heroCTA) { ?>
                            <div class="cta-holder">
                                <a href="<?= $heroCTA['url']; ?>"><?= $heroCTA['title']; ?></a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="col-lg-5 foreground-image-col">
                        <img src="<?= $heroForegroundImage['url']; ?>">
                    </div>
                </div>

            </div>
        </div>
    <?php } elseif($heroType == 'include-header-bar') {
        $heroTitle = get_sub_field('hero_title_fixed_header');
        $heroDescription = get_sub_field('hero_text_fixed_header');
        ?>
    <?php }?>
</div>
