<?php
$companyLogo = get_field('company_logo', 'option');
$testimonials = get_sub_field('testimonials');
$testimonialBg = get_sub_field('testimonials_background_image');
if($testimonials){ ?>
    <!--   todo - make centered slider large -->
    <div class="custom-flexible-section testimonial-section" style="background-image:url('<?= $testimonialBg['url']; ?>')">
        <div class="container">
            <div class="swiper-container testimonial-swiper">
                <div class="swiper-wrapper">
                    <?php foreach($testimonials as $testimonial) {
                        $image = $testimonial['testimonial_image'] ? $testimonial['testimonial_image']['url'] : $companyLogo['url'];
                        $imageClass = $testimonial['testimonial_image'] ? 'standard' : 'default';
                        $imageType = $testimonial['image_type'];
                        ?>
                        <div class="swiper-slide">
                            <div class="inner-testimonial">

                                <div class="top-holder">
                                    <div class="custom-button-prev"><i class="far fa-chevron-left"></i></div>
                                    <div class="image-holder <?= $imageClass . ' ' . $imageType; ?>">
                                        <img src="<?= $image; ?>">
                                    </div>
                                    <div class="custom-button-next"><i class="far fa-chevron-right"></i></div>
                                </div>


                                <div class="description"><?= $testimonial['testimonial_description']; ?></div>

                                <div class="by">
                                    <?php if($testimonial['testimonial_by_person']) { ?><div class="name"><?= $testimonial['testimonial_by_person']; ?></div><?php } ?>
                                    <?php if($testimonial['testimonial_by_company']) { ?><div class="company"><?= $testimonial['testimonial_by_company']; ?></div><?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>

            <div class="swiper-pagination"></div>

        </div>
    </div>
<?php } ?>
