<?php
$tabs = get_sub_field('tabs');
$title = get_sub_field('tabs_title');
?>

<div class="custom-flexible-section tab-section">
    <div class="container">
        <h2><?= $title; ?></h2>
        <?php if($tabs) { ?>
            <ul class="nav custom-nav-blocks" id="myTab" role="tablist">
                <?php
                $tabNavCount = 0;
                foreach($tabs as $tab) {
                    $tabNavCount++;
                    $active = $tabNavCount == 1 ? 'active' : "";
                    $selected = $tabNavCount == 1 ? "true" : "false"; ?>
                    <li class="nav-item">
                        <a class="nav-link <?= $active; ?>" id="<?= 'tab-' . $tabNavCount; ?>" data-toggle="tab" href="#<?= 'tab' . $tabNavCount; ?>" role="tab" aria-controls="<?= 'tab' . $tabNavCount; ?>" aria-selected="<?= $selected; ?>"><?= $tab['tab_title']; ?></a>
                    </li>
                <?php } ?>
            </ul>

            <div class="tab-content" id="myTabContent">
                <?php
                $tabContentCount = 0;
                foreach($tabs as $tab) {
                    $tabContentCount++;
                    $active = $tabContentCount == 1 ? 'show active' : ""; ?>
                    <div class="tab-pane fade <?= $active; ?>" id="<?= 'tab' . $tabContentCount; ?>" role="tabpanel" aria-labelledby="<?= 'tab' . $tabContentCount; ?>">
                        <?= $tab['tab_content']; ?>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</div>

