<?php
$includeCurve = get_sub_field('include_top_curve_style');
$curveClass = $includeCurve ? 'curve-active' : "";
$text = get_sub_field('title');
$description = get_sub_field('description');
$cta = get_sub_field('cta');
$image = get_sub_field('image');
$imagePosition = get_sub_field('image_position');
$curve = get_template_directory_uri() . '/dist/images/bottom-curve.png';
$bgOrderPrimary = $imagePosition == 'left' ? 'order-1' : 'order-2';
$bgOrderSecondary = $imagePosition == 'left' ? 'order-2' : 'order-1';
$contentOrderPrimary = $imagePosition == 'left' ? 'order-1' : 'order-2';
$contentOrderSecondary = $imagePosition == 'left' ? 'order-2' : 'order-1';
?>
<div class="custom-flexible-section split-section <?= $curveClass; ?>">
    <div class="desktop-split">
        <?php if($includeCurve) { ?>
            <img src="<?= $curve; ?>" class="curve">
        <?php } ?>
        <div class="row bg-row no-gutters">
            <div class="col-lg-6 image-col <?= $bgOrderPrimary; ?>" style="background-image:url('<?= $image['url']; ?>')"></div>
            <div class="col-lg-6 colour-col <?= $bgOrderSecondary; ?>"></div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-6 <?= $contentOrderPrimary; ?>">

                </div>
                <div class="col-lg-6 text-col <?= $contentOrderSecondary; ?>">
                    <div class="text-section <?= 'image-position-' . $imagePosition; ?>">
                        <h3><?= $text; ?></h3>
                        <div class="description">
                            <?= $description; ?>
                        </div>
                        <?php if($cta) { ?>
                            <div class="cta"><a href="<?= $cta['url']; ?>"><?= $cta['title']; ?></a></div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="mobile-split">

        <div class="mobile-content">
            <div class="container">
                <h3><?= $text; ?></h3>
                <div class="description">
                    <?= $description; ?>
                </div>
                <?php if($cta) { ?>
                    <div class="cta"><a href="<?= $cta['url']; ?>"><?= $cta['title']; ?></a></div>
                <?php } ?>
            </div>
        </div>

        <div class="container">
            <img src="<?= $image['url']; ?>">
        </div>
    </div>
</div>

