<?php
$thinCurve = get_template_directory_uri() . '/dist/images/thin-curve.png';
$bg = get_field('content_area_background');
?>

<div class="custom-contact-template">
    <div class="fixed-header-hero" style="background-image:url('<?php the_post_thumbnail_url(); ?>')">
        <div class="inner-hero">
            <div class="row bg-row no-gutters">
                <div class="col-lg-6"></div>
                <div class="col-lg-6 image-col" style="background-image:url('<?php the_post_thumbnail_url(); ?>')"></div>
            </div>

            <div class="container content-container">
                <div class="row">
                    <div class="col-lg-6">
                        <h1><?php the_title(); ?></h1>
                        <div class="description"><?php the_content(); ?></div>
                    </div>
                </div>
            </div>
        </div>
        <img src="<?= $thinCurve; ?>" class="thin-curve">
    </div>

    <div class="below-fixed-banner-mobile">
        <div class="container">
            <h1><?php the_title(); ?></h1>
            <div class="description"><?php the_content(); ?></div>
        </div>
    </div>

    <div class="main-contact-section">
        <div class="container">
            <div class="row row-eq-height">
                <div class="col-lg-6">

                            <div class="form"><?= do_shortcode(get_field('contact_form_shortcode')); ?></div>

                </div>
                <div class="col-lg-6">
                    <div class="inner d-flex align-items-center justify-content-center h-100" style="background-image:url('<?= $bg['url']; ?>')">
                        <div class="info-box">
                            <div class="title">Virosafe</div>
                            <div class="address"><?php the_field('contact_address') ?></div>
                            <?php if (get_field('contact_phone_number', 'option')) { ?>
                                <div class="phone"><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>">Call: <?php the_field('contact_phone_number', 'option'); ?></a></div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
