import Swiper from 'swiper';

const common = () => {
    new Swiper('.testimonial-swiper', {
        centeredSlides: true,
        loop: true,
        breakpoints: {
            0: {
                spaceBetween: 50,
                slidesPerView: 1,
            },
            992: {
                spaceBetween: 50,
                slidesPerView: 2,
            },
            1500: {
                spaceBetween: 50,
                slidesPerView: 3,
            },
        },
        navigation: {
            nextEl: '.custom-button-next',
            prevEl: '.custom-button-prev',
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true
        },
    });

    $('.navbar-toggler').on('click', function() {
        $('.custom-mobile-menu').toggleClass('active');
        $('.navbar-toggler svg').toggleClass('fa-bars fa-times');
    });

    $('.arrow-stack').on('click', function() {
        console.log('clicked');
        $('html,body').animate({
            scrollTop: $('.custom-flexible-section:nth-child(2)').offset().top }
        , 'slow');
    });
};

export default common;
