<?php
$companyLogo = get_field('company_logo', 'option');
$flexibleSection = get_field('flexible_sections');
$headerFlexClass = $flexibleSection[0]['acf_fc_layout'] == 'hero_section' ? $flexibleSection[0]['hero_type'] : 'include-header-bar';
?>

<div class="mobile-bar">
    <div class="container bar-cont">
        <div class="phone"><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>">Call: <?php the_field('contact_phone_number', 'option'); ?></a></div>
        <div class="social">
            <?php if (have_rows('social_media_channels', 'option')) { ?>
                <ul class="socials">
                    <?php while (have_rows('social_media_channels', 'option')) {
                        the_row(); ?>
                        <li>
                            <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                        <span class="fa-stack fa-2x">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse social-icon"></i>
                                        </span>
                            </a>
                        </li>
                    <?php } ?>
                </ul>
            <?php } ?>
        </div>
    </div>
</div>

<nav class="header-nav" id="<?= $headerFlexClass; ?>">
    <div class="container">
        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
            <img src="<?= $companyLogo['url']; ?>" alt="<?php bloginfo('name'); ?>" />
        </a>
        <button class="navbar-toggler">
            <i class="far fa-bars fa-2x"></i>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <div class="contact">
                <?php if (have_rows('social_media_channels', 'option')) { ?>
                    <ul class="socials">
                        <?php while (have_rows('social_media_channels', 'option')) {
                            the_row(); ?>
                            <li>
                                <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener">
                                        <span class="fa-stack fa-2x">
                                          <i class="fas fa-circle fa-stack-2x"></i>
                                          <i class="<?php the_sub_field('fa5_icon_class'); ?> fa-stack-1x fa-inverse social-icon"></i>
                                        </span>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>
                <?php if (get_field('contact_phone_number', 'option')) { ?>
                    <li><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>">Call: <?php the_field('contact_phone_number', 'option'); ?></a></li>
                <?php } ?>
            </div>
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
            }
            ?>
        </div>
    </div>
</nav>

<div class="custom-mobile-menu">
    <div class="container mob-cont">
        <?php
        if (has_nav_menu('main_menu')) {
            wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
        }
        ?>
    </div>
</div>
