<?php
$title = get_sub_field('title');
$blocks = get_sub_field('info_blocks');
$blocksCount = count($blocks);
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

switch($blocksCount){
    case 1:
        $blockCol = 'col-md-6 offset-md-3';
        break;
    case 2:
        $blockCol = 'col-md-6';
        break;
    case 3:
        $blockCol = 'col-md-6 col-xl-4';
        break;
    default:
        $blockCol = 'col-md-6 col-lg-4 col-xl-3';
}

if($blocks) { ?>
<section class="custom-flexible-section info-blocks-section">
    <div class="contain">
        <?php if($title) { ?><h2 class="text-center fw-500"><?= $title; ?></h2><?php } ?>
        <div class="blocks">
            <div class="row row-eq-height justify-content-center">
                <?php
                $blocksCount = count($blocks);

                foreach($blocks as $block) {

                    switch($blocksCount) {
                        case 1:
                        case 2:
                            $imageSize = '2-wide';
                            break;
                        case 3:
                            $imageSize = '3-wide';
                            break;
                        default:
                            $imageSize = '4-wide';
                    }

                    if($block['image']){
                        $imageDetails = wp_get_attachment_image_src($block['image']['id'], $imageSize);
                        $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $block['image']['alt'] .'">';
                        $imageClass = 'featured-image';
                    } else {
                        $image = $defaultImage;
                        $imageClass = 'default-image';
                    }

                    ?>
                    <div class="block-col <?= $blockCol; ?>">
                        <div class="inner-block h-100">
                            <div class="image-wrapper <?= $imageClass ?>">
                                <?= $image; ?>
                            </div>
                            <div class="content-wrapper">
                                <?php if($block['title']) { ?><h3><?= $block['title']; ?></h3><?php } ?>
                                <?php if($block['description']) { ?><div class="description"><?= $block['description']; ?></div><?php } ?>
                                <?php if($block['call_to_action']) { ?><a class="u-case fw-700 purple-button" href="<?= $block['call_to_action']['url']; ?>" target="<?= $block['call_to_action']['target']; ?>"><span class="text"><?= $block['call_to_action']['title']; ?></span></a><?php } ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>
